
HolyLibrams = { }

if (HolyLibrams_Options == nil) then
   HolyLibrams_Options = { }
   HolyLibrams_Options.Version = "1.1"
   HolyLibrams_Options.Mp5Mode = true
   HolyLibrams_Options.RefreshWindow = 2.0
end

function HolyLibrams:OnLoad()

	if (select(2, UnitClass("player")) ~= "PALADIN") then return end
   
   SLASH_HolyLibrams1 = "/hl"
   SLASH_HolyLibrams2 = "/HolyLibrams"
   SlashCmdList["HolyLibrams"] = HolyLibrams.SlashHandler
   
   this:RegisterEvent("UNIT_SPELLCAST_SENT")
   
end

function HolyLibrams.SlashHandler(msg)

   local _, _, cmd, arg1, arg2, arg3 =
         string.find(msg, "(%w+)%s*(%w*)%s*(%w*)%s*(%w*)")

   if (cmd == "help") then
      HolyLibrams:Print("HolyLibrams", HolyLibrams_Options.Version, "options:")
      HolyLibrams:Print("  /hl mp5 - efficiency mode")
      HolyLibrams:Print("  /hl hps - throughput mode")
   end

   if (cmd == "mp5") then
      HolyLibrams_Options.Mp5Mode = true
   end

   if (cmd == "hps") then
      HolyLibrams_Options.Mp5Mode = false
   end

   if (cmd == "refresh") then
      local refresh = tonumber(arg1)
      if (refresh and refresh >= 0 and refresh <= 30) then
         HolyLibrams_Options.RefreshWindow = refresh
      end
      HolyLibrams:Print("Grace of the Naaru refreshes when under ",
            HolyLibrams_Options.RefreshWindow, "s.")
   end

   if (cmd == "debug") then
      HolyLibrams_Options.Debug = not HolyLibrams_Options.Debug
      HolyLibrams:Debug("HolyLibrams debug messages are on.")
   end

   if (HolyLibrams_Options.Mp5Mode) then
      HolyLibrams:Print("HolyLibrams is in efficiency (mp5) mode.")
   else
      HolyLibrams:Print("HolyLibrams is in throughput (hps) mode.")
   end

end

function HolyLibrams:Debug(...)

   if (HolyLibrams_Options.Debug) then
      self:Print(...)
   end

end

function HolyLibrams:Print(...)

   local s = ""
   for i = 1, select("#", ...) do
      if (i == 1) then
         s = select(i, ...)
      else
         s = s .. " " .. select(i, ...)
      end
   end
   DEFAULT_CHAT_FRAME:AddMessage(s, 1.0, 0.55, 0.73)

end

function HolyLibrams:OnEvent(event)

	if (type(self[event]) == 'function') then
		self[event](self, event, arg1, arg2, arg3, arg4);
	else
		self:Print("Unhandled event: ", event);
	end

end

function HolyLibrams:UNIT_SPELLCAST_SENT(event, unit, spell, rank, targ)

   if (unit ~= "player") then return end
   
   local LoSR = "Libram of Souls Redeemed"
   local BBoN = "Blessed Book of Nagrand"
   local LoAT = "Libram of Absolute Truth"
   local LoM  = "Libram of Mending"
   local LotL = "Libram of the Lightbringer"  -- "Libram of Light"

   -- Flash of Light logic
   if (spell == "Flash of Light") then
      if (self:HasBoL(targ)) then
         self:Debug("Equipping", LoSR)
			EquipItemByName(LoSR)
      else
         self:Debug("Equipping", BBoN)
			EquipItemByName(BBoN)
      end
   end

   -- Holy Light logic
   if (spell == "Holy Light") then
      if (HolyLibrams_Options.Mp5Mode) then
         if (self:HasMendingBuff()) then
            self:Debug("Equipping", LoAT)
            EquipItemByName(LoAT)
         else
            self:Debug("Equipping", LoM)
            EquipItemByName(LoM)
         end
      else
         if (self:HasBoL(targ)) then
            self:Debug("Equipping", LoSR)
            EquipItemByName(LoSR)
         else
            self:Debug("Equipping", LotL)
            EquipItemByName(LotL)
         end
      end
   end

end

function HolyLibrams:HasBoL(target)

   return self:BuffByTexture(target, "Spell_Holy_PrayerOfHealing02") or
         self:BuffByTexture(target, "Spell_Holy_GreaterBlessingofLight")

end

function HolyLibrams:HasMendingBuff()

   local mending_buff_name = "Grace of the Naaru"

   for id = 1,100 do
      local name, _, _, _, _, time_left = UnitBuff("player", id)
      if (not name or not time_left) then
         return false
      elseif (name == mending_buff_name) then
         self:Debug("Mending buff is active, timeleft: ", time_left)
         return time_left >= HolyLibrams_Options.RefreshWindow
      end
   end

end

function HolyLibrams:BuffByTexture(unit, texture_to_find)

   for id = 1,100 do
      local _, _, texture = UnitBuff(unit, id)
      if (not texture) then
         return false
      elseif (texture == "Interface\\Icons\\" .. texture_to_find) then
         return true
      end
   end

end
