-- HitsMode, by Allara

function HitsMode:Localize_enUS()
	local WHT = "|cffffffff";
	local BLK = "|cff000000";
	local YEL = "|cffffff20";
	local RED = "|cffff2020";
	local GRN = "|cff20ff20";
	local BLU = "|cff2020ff";
	local HIL = "|cfffbd284";
	
	BINDING_HEADER_HITSMODE = "HitsMode";
	BINDING_NAME_OPTIONSTOGGLE = "Show HitsMode Options Window";

	-- Combat output
	self.ChatMessages = {
		["ABSORB"] = "absorb for",
		["ABSORBS"] = "absorbs for",
		["ABSORBED"] = "absorbed",
		["AFFLICTED"] = "afflicted by",
		["AFFLICTS"] = "afflicts for",
		["APPLYENCHANTMENTON"] = "apply enchantment on",
		["AREAFFLICTED"] = "are afflicted by",
		["AREFATIGUEDFOR"] = "are fatigued for",
		["AREIMMUNE"] = "are immune",
		["ARESLIMEDFOR"] = "are slimed for",
		["BLOCK"] = "block",
		["BLOCKED"] = "blocked",
		["BLOCKED"] = "blocked",
		["BLOCKS"] = "blocks",
		["BRACKETLEFT"] = "[",
		["BRACKETRIGHT"] = "]",
		["BURNFOR"] = "burn for",
		["BURNSFOR"] = "burns for",
		["CDIVIDER"] = " - ",
		["CREATE"] = "create",
		["CREATES"] = "creates",
		["CRITFOR"] = "crit for",
		["CRITSFOR"] = "crits for",
		["CRUSHING"] = "crushing",
		["DEFLECT"] = "deflect",
		["DEFLECTS"] = "deflects",
		["DIES"] = "dies",
		["DISPEL"] = "dispel",
		["DISPELS"] = "dispels",
		["DODGE"] = "dodge",
		["DODGES"] = "dodges",
		["DRAIN"] = "drain for",
		["DRAINENERGY"] = "drain energy for",
		["DRAINFOCUS"] = "drain focus for",
		["DRAINHEALTH"] = "drain health for",
		["DRAINMANA"] = "drain mana for",
		["DRAINRAGE"] = "drain rage for",
		["DRAINS"] = "drains for",
		["DRAINSENERGY"] = "drains energy for",
		["DRAINSFOCUS"] = "drains focus for",
		["DRAINSHEALTH"] = "drains health for",
		["DRAINSMANA"] = "drains mana for",
		["DRAINSRAGE"] = "drains rage for",
		["DROPTOTEM"] = "drop",
		["DROWNFOR"] = "drown for",
		["DROWNSFOR"] = "drowns for",
		["ENCHANT"] = "enchant",
		["EVADE"] = "evade",
		["EVADES"] = "evades",
		["FADES"] = "fades",
		["FAILSTOCAST"] = "fails to cast",
		["FAILTOCAST"] = "fail to cast",
		["FAILSTODISPEL"] = "fails to dispel",
		["FAILTODISPEL"] = "fail to dispel",
		["FALLFOR"] = "fall for",
		["FALLSFOR"] = "falls for",
		["FINISHCASTING"] = "finish casting",
		["FINISHESCASTING"] = "finishes casting",
		["FOR"] = "for",
		["GAIN"] = "gain",
		["GAINATTACKS"] = "gain attacks for",
		["GAINENERGY"] = "gain energy for",
		["GAINFOCUS"] = "gain focus for",
		["GAINHAPPINESS"] = "gain happiness for",
		["GAINMANA"] = "gain mana for",
		["GAINRAGE"] = "gain rage for",
		["GAINREP"] = "gain reputation",
		["GAINRUNES"] = "gain runes for",
		["GAINS"] = "gains",
		["GAINSATTACKS"] = "gains attacks for",
		["GAINSENERGY"] = "gains energy for",
		["GAINSFOCUS"] = "gains focus for",
		["GAINSHAPPINESS"] = "gains happiness for",
		["GAINSMANA"] = "gains mana for",
		["GAINSRAGE"] = "gains rage for",
		["GAINSRUNES"] = "gains runes for",
		["GLANCING"] = "glancing",
		["HEALFOR"] = "heal for",
		["HEALSFOR"] = "heals for",
		["HITFOR"] = "hit for",
		["HITSFOR"] = "hits for",
		["HONOR"] = "gain honor",
		["INTER"] = "was interrupted",
		["INTERS"] = "interrupted",
		["INTERRUPT"] = "interrupt",
		["INTERRUPTS"] = "interrupts",
		["INSTANTLYKILL"] = "instantly kill",
		["INSTANTLYKILLS"] = "instantly kills",
		["ISAFFLICTED"] = "is afflicted by",
		["ISFATIGUEDFOR"] = "is fatigued for",
		["ISDESTROYED"] = "is destroyed",
		["ISIMMUNE"] = "is immune",
		["ISIMMUNETO"] = "is immune to your",
		["ISREMOVED"] = "is removed",
		["ISSLIMEDFOR"] = "is slimed for",
		["KILL"] = "kill",
		["KILLS"] = "kills",
		["LOSEDURABILITY"] = "lose durability for",
		["LOSESDURABILITY"] = "loses durability for",
		["LOSEREP"] = "lose reputation",
		["MISS"] = "miss",
		["MISSED"] = "missed",
		["MISSES"] = "misses",
		["OTHERSLAY"]  = "has slain",
		["PARRIES"] = "parries",
		["PARRY"] = "parry",
		["PLAYERCRAFT"] = "create",
		["PLAYERLOOT"] = "loot",
		["PLAYERLOOTS"] = "loots",
		["PLAYERSLAY"] = "have slain",
		["PURGE"] = "was removed",
		["REFLECT"] = "reflect",
		["REFLECTS"] = "reflects",
		["REMOVEENCHANTMENTFROM"] = "remove enchantment from",
		["RESIST"] = "resist",
		["RESISTED"] = "resisted",
		["RESISTS"] = "resists",
		["SEPARATOR"] = "----",
		["SHORTSEP"] = "~~~",
		["SKILLHASINCREASEDTO"] = "skill has increased to",
		["STARTCASTING"] = "start casting",
		["STARTSCASTING"] = "starts casting",
		["STEAL"] = "steal",
		["STEALS"] = "steals",
		["SUFFER"] = "suffer",
		["SUFFERS"] = "suffers",
		["SUMMON"] = "summon",
		["SUMMONS"] = "summons",
		["WASABS"] = "was absorbed",
		["XP"] = "gain exp",
		["YOU"] = "you",
		["YOUCAP"] = "You",
		["YOUR"] = "your",
		["YOURCAP"] = "Your",
		["YOURSELF"] = "Yourself",
	};



	-- Help system
	local helpcat = "HitsMode";

	HelpLib.AddQuestion({
		q = "How do I configure HitsMode?",
		a = "Type /hm or /hitsmode to open the options window. You can also make a key binding to the options window in the Key Binding screen.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Why are there four checkboxes next to everything?",
		a = "HitsMode lets you send output to up to four separate windows. Four checkboxes next to an option indicate that that option can be configured differently for each window. So, to turn an option on for Window 3, check the third checkbox from the left.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "How do I pick which chat messages to put in which window?",
		a = "Check the checkbox for each window you want the message to appear. The checkboxes are assigned to windows 1 through 4 going left to right.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Can one chat message appear in more than one window?",
		a = "Yes, and each window gets it's own formatting.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Can I change the color of the message in each window?",
		a = "No, you can only customize one color per event.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "I've checked the boxes next to the messages, but they aren't showing up!",
		a = "You have to \"enable\" the windows. This is done in the General tab. Also make sure HitsMode itself is enabled (at the top of the General tab).",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "I'm trying to send messages to different windows. Why are they all showing up in the same one?",
		a = "You also need to tell HitsMode which chat window to use for each HitsMode window. WoW supports up to 7 chat windows. #1 is General Chat, and #2 is usually Combat. It's best to pick a window from 3 to 7 for the HitsMode windows, but you can use any of them. You can even send two or more HitsMode \"windows\" to the same physical chat window! This allows for some very interesting combinations.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "How do I tell HitsMode which chat window to use?",
		a = "In the General tab, right underneath the \"Enable Chat Window X\" option, there is a slider. That tells HitsMode which WoW chat window you want to use. It's usually best to count backwards from 7 as you go.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "I want to put my combat in one window and my attacker's combat in another. Just tell me how!",
		a = "1. Go to the General tab\n2. Enable windows 1 and 2, leaving the others disabled\n3. Set window 1 to chat window 7, and window 2 to chat window 6\n4. Setup the options you'd like for each window. For example, to display both windows in Verbose Mode A, just select the first two checkboxes next to Verbose Mode A.\n5. Go to the Messages tab\n6. Check only the first box next to all the \"You\" events, and the second box next to all the \"Attacker\" events. For the rest, pick what you want.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "General Troubleshooting Steps",
		a = "Please check the following:\n\n1. Add-on is installed in your Interface/AddOns folder\n2. Add-on is enabled in WoW\n3. Your client is in a supported language (currently only English is supported)\n4. If you're upgrading from a previous version and something doesn't work, load the default options. This is available from the Presets tab.\n5. Turn off all Filters (in the Filters tab) and see if that helps\n6. If nothing works, you probably have an add-on that's conflicting with HitsMode: Some chat add-ons have been known to cause problems. Try disabling these and see if it helps.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "When I turn off a window in HitsMode, why doesn't the chat window disappear?",
		a = "HitsMode will NEVER close a chat window for you. You can simply close them yourself. Every time you close the options window, HitsMode puts a \"HM window 1 is here!\" message in each active window. Use that to help you see which windows you're using.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Why won't HitsMode let me resize my General Chat (window 1) below normal?",
		a = "Doing so has been known to cause a crash.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "What do these \"Verbose Modes\" do?",
		a = "HitsMode was originally designed to just display the numeric values of your combat chat for quick reading. Later, we added several \"verbose modes\" to let you see your chat in many other (longer) ways. To see what each mode looks like, hover your mouse over the option and look at the tooltip.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Why am I getting spammed with all these messages I don't want to see?",
		a = "Out of the box, HitsMode will only show you messages that affect you, your pet, or your target. Additional messages are available under the Messages tab, in the sections called \"Others Versus Others\" and \"Spam\". There are also four \"double messages\" available under the \"Heals\" section. Make sure all of these messages are off, and your spam should be cut down completely.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "I don't like the default colors and they take too long to change.",
		a = "1. You can write down the RGB values of the colors you like and just type them in on the color picker.\n2. You can quickly replicate a color throughout several options. First, open the color picker for the color you want to copy and press the Copy button. Then, open each color you want to copy to and press the Paste button.\n3. Once you have everything set up how you like it, don't forget to save that configuration as a Preset.\n4. You can also easily copy your configuration from one character to another on the Chars tab.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "HitsMode takes FOREVER to configure the way I like it! It's too hard to get started.",
		a = "You're right! There are hundreds of options in HitsMode:\n\n1. You can use the \"select all\" feature to quickly select a column of options. Just click a checkbox in a blue header to select that entire column. This is a quick way to put an entire set of messages into one window, for example.\n2. Using Presets, you can set up certain configurations the way you like it and save it. Later, you can quickly load that Preset for whichever situation you needed it.\n3. You can also easily copy your configuration from one character to another on the Chars tab.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "When I turn a message off, it doesn't seem to actually turn off. Am I missing something?",
		a = "You've probably found a bug! Email me at allara.starmist@gmail.com, or post a comment on the add-on home page at http://wow.curse.com/downloads/details/298/, and I'll try to get it fixed soon!",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "How do the filters work?",
		a = "HitsMode contains a robust filter system that lets you completely control which "..
						"events you see and where they go. The filters in HitsMode are designed mainly "..
						"for advanced users. They function as a layer above all other options in the "..
						"add-on. Your imagination is the limit!\n\n"..
						YEL.."PERFORMANCE|r\n\n"..
						"The filters were designed to be as high-performance as possible, but enabling "..
						"filters does add additional overhead. Please turn off \"Enable Filter System\" if "..
						"you don't plan to use them, as this will eliminate all of the extra checks.\n\n"..
						YEL.."ABOUT FILTERS|r\n\n"..
						"The filter system is split into six sections -- three for the source unit, "..
						"three for the destination unit. The six sections can be enabled and disabled "..
						"independently. This improves performance, as well as making it easier to use "..
						"just the filters you need. Each section that is enabled becomes required. If "..
						"you enable two sections, combat events must satisfy the conditions of both "..
						"sections before they will be shown. However, an event does not need to meet "..
						"both the SOURCE and DESTINATION filters to be shown (otherwise you'd never see "..
						"anything).\n\n"..
						YEL.."FILTER SECTIONS|r\n\n"..
						GRN.."Special Filters|r\n"..
						"These filters control specific units, such as your target, the raid main tank, "..
						"or one of the marked raid targets. These filters function as a logical OR, so "..
						"if you choose more than one in this section, messages which satisfy ANY of your "..
						"selections will be shown.\n\n"..
						GRN.."Unit Type Filters|r\n"..
						"These are powerful filters that let you precisely control which unit types get "..
						"routed to which windows. They can be a bit complex to understand at first. "..
						"Basically, every unit in the game has four attributes assigned to it: "..
						"affiliation, reaction, controlled by, and type. These filters function as a "..
						"logical OR, so if you choose more than one in this section, messages which "..
						"satisfy ANY of your selections will be shown. However, you MUST choose at least "..
						"one attribute from each of the four attribute types, or no messages will be "..
						"shown.\n\n"..
						GRN.."Unit Name Filters|r\n"..
						"This lets you show only units whose name matches a name in a "..
						"list you specify. You can also choose to exclude certain units by their name. "..
						"HitsMode gives you four separate lists of names, and you can assign them to any "..
						"of the four chat windows in any combination. The name lists should be comma "..
						"separated, and are not case sensitive. They are accent sensitive, however, so "..
						"if a unit name contains an accent, you must type it in. These filters function "..
						"as a logical AND, so HitsMode will look at everything in this section before "..
						"allowing a message to be displayed.\n\n"..
						YEL.."SOURCE AND DESTINATION|r\n\n"..
						"If you enable source and destination filters, messages that meet EITHER the source "..
						"OR the destination filters will be shown.\n\n"..
						YEL.."FAQ|r\n\n"..
						GRN.."Q:|r The Filters tab seems to offer most of the same options that the Messages tab "..
						"does in terms of message routing. Why have both?\n"..
						GRN.."A:|r The Filters tab functions as a layer above the Messages tab. After you've "..
						"finished routing your messages to the best of your ability under Messages, you "..
						"can perform additional (more advanced) routing using the Filters tab. The "..
						"Messages tab exists in order to turn off specific types of combat events and "..
						"to configure colors for different messages.\n\n"..
						GRN.."Q:|r I want to display my party or raid combat log in a separate window. How can "..
						"I do that?\n"..
						GRN.."A:|r Under the Messages tab, turn on all the messages in the \"Others Versus "..
						"Others\" section. Then, under the Filters tab, turn on Enable Unit Filters, Enable "..
						"Source Special Filters, and Enable Destination Special Filters. Then turn on My Party "..
						"under both source and destination. Repeat the same process for raid combat, except "..
						"choose My Raid. You might also want to turn on Party Pets and/or Raid Pets.\n\n"..
						GRN.."Q:|r I'm trying various combinations of filters and it's not working the "..
						"way I expect. How are the filters applied?\n"..
						GRN.."A:|r In general, the filters are applied with this logic:\n"..
						"((SourceSpecial AND SourceType) OR (DestSpec AND DestType)) AND (SourceName AND DestName)"
						,
		cat = helpcat,
	});
	--HelpLib.AddQuestion({
		--q = "The color I've set for dodge, miss, parry, etc. isn't working!",
		--a = "When you're in one of the Verbose Modes, the Verbose Mode color that you've configured overrides the individual messages colors (except for the actual damage amount). If you turn off all Verbose Modes, you'll see the right color for dodge, etc. This affects a great deal of messages in HitsMode:",
		--cat = helpcat,
	--});
	HelpLib.AddQuestion({
		q = "What is the Combat Summary?",
		a = "Available under the \"Summary\" tab, Combat Summary is a lightweight personal DPS summary system that activates any time you lose aggro. It is designed to take advantage of the existing HitsMode combat parser, and is therefore able to give you some interesting statistics after each fight without impacting your computer's performance. It is not designed as a replacement for (or even a competitor with) any other DPS add-ons, but rather can exist as a complement to them.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Will Combat Summary slow down my computer?",
		a = "No. Since HitsMode already parses all of your combat messages, it was quite easy to add DPS tracking to the engine without impacting system performance whatsoever.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Can Combat Summary display the DPS of other people in my party?",
		a = "No. Combat Summary was designed as a lightweight personal DPS meter only. We don't want to get into competition with full-size DPS add-ons like Recap or DamageMeters.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Why would I want to use HitsMode's Combat Summary when I already have an add-on that tracks DPS?",
		a = "Here are some reasons:\n\n1. Combat Summary gives you an automatic summary of your personal statistics directly into your chat window.\n2. Combat Summary can output summaries to multiple chat windows, and you can send part of the summary to different chat windows. This lets you, for example, place all your outgoing damage in one window, and your incoming damage in another window. Then you can have Combat Summary place the DPS for the last encounter into both windows separately, allowing a clean separation.\n3. Combat Summary tracks some messages that may not be as easy to track with other add-ons: mana/rage/energy gained, experience gained, attacks gained, skill ups, etc. The potential is there to add even more, as long as it can be tracked in your combat log.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "When I upgrade to a new version of HitsMode, will my be options saved?",
		a = "Yes, your options will be migrated. However, the options are very fluid as new versions come out. If you experience any problems after upgrading, it's always good to try loading the defaults first. This will usually fix everything. You can load the defaults by going to the Presets tab and clicking the Load button on the Defaults row.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "What are some advanced things I can do with HitsMode?",
		a = "HitsMode is extremely configurable -- the sky's the limit! Here are some examples of things you can accomplish:\n\n1. Put your spells and your melee text in the same window. Your spells are in verbose mode, but your melee shows just the damage.\n2. Your skills with names appear in Window 1, while only the skill damage appears in Window 2.\n3. All the melee (numbers only) scroll in big numbers up the side of the screen, while the full text of all the combat goes into another window in a smaller size.\n4. Your hits (number only) are in the first column. Your Attacker's hits (number only) are in the second column. All the skills (verbose mode) are in the third column.\n5. Put heals received in one window, and heals cast in another.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "HitsMode looks just like <insert add-on>.",
		a = "HitsMode uses it's own proprietary parsing and output engine, which results in slightly different combat log output. HitsMode also has a very different configuration system than other add-ons. Often this is what turns users on or off to HitsMode: As always, try several add-ons and use what you like! If you have ideas for how HitsMode should be improved, don't hesitate to comment on one of the hosting web sites.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Can I show damage done on the left and damage received on the right?",
		a = "Not in the same chat window. But you can create two (or more) windows and split them up between damage done and damage received. This achieves a very similar effect to that of add-ons like EavesDrop. In fact, this is how I prefer to play! If you want some text to actually be right-aligned, check out the add-on called Prat (available from http://www.wowace.com).",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Can I right-align my text?",
		a = "Check out the add-on called Prat (available from http://www.wowace.com).",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "What about timestamps? Mouse wheel? Remove chat buttons? Fade delay?",
		a = "There are many other add-ons that accomplish all of these things. Check out the add-on called Prat (available from http://www.wowace.com).",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "I'm still lost!",
		a = "Post a comment on the add-on home page at http://wow.curse.com/downloads/details/298/ or email me directly at allara.starmist@gmail.com.",
		cat = helpcat,
	});
	HelpLib.AddQuestion({
		q = "Where can I download new versions of HitsMode?",
		a = "Search for HitsMode on wow.curse.com, www.wowinterface.com, or ui.worldofwar.net. The official home page is at the Curse site.\n\nI recommend downloading WowUs, an automatic add-on updater. Get it at http://wowus.m6.net/download.php. This excellent program will automatically update HitsMode and most of your other add-ons.",
		cat = helpcat,
	});


	-- Chat message patterns
	self.ChatPatterns = {
		[1] = "Reputation with (.+) increased by (%d+).",
		[2] = "Reputation with (.+) decreased by (%d+).",
		[3] = "You create: (.+).",
		[4] = "You receive loot: (.+).",
		[5] = "Your share of the loot is (.+).",
		[6] = "(.+) receives loot: (.+).",
		[7] = "Your skill in (.+) has increased to ([%d]+)",
		[8] = "([%d]+)",
		[9] = "You have been awarded ([%d]+) honor.",
		[10] = ".* gain (%d+).*",
		[11] = "experience%. %(%+(%d+) exp Rested bonus",
		[12] = "You loot (.+)",
	};

	-- UI strings
	return {
		[1] = "General",
		[2] = "Enable HitsMode",
		[3] = "Enables or disables HitsMode as a whole.\nDisabling HitsMode will not close any chat windows.\nGo to the Windows tab and scroll down to enable/disable each individual chat window.",
		[4] = "Text Layout",
		[5] = "These options let you choose how the chat should be displayed. \nUse the four checkboxes to choose the option for each chat window separately.",
		[6] = "Enable Verbose Mode A",
		[7] = "Shows more information in chat. Mode A looks like:\n[You] hit for 12\n[Wolf] hits for 8",
		[8] = "Enable Verbose Mode B",
		[9] = "Shows more information in chat. Mode B looks like:\n[You] hit [Wolf] for 12\n[Wolf] hits [You] for 8",
		[10] = "Enable Verbose Mode C",
		[11] = "Shows more information in chat. Mode C looks like:\n12 - [You] hit [Wolf]\n8 - [Wolf] hits [You]",
		[12] = "Short Verbose Mode",
		[13] = "Eliminates the \"for\" in most messages.",
		[14] = "Show Spell Names",
		[15] = "Shows the name of the skill or spell that was used. \nThis only works if you have one of the Verbose Modes turned on.",
		[16] = "Capitalize Text",
		[17] = "Capitalizes the beginning of some verbose mode text.",
		[18] = "Show Brackets Around Unit Names",
		[19] = "Check to display brackets around unit names.",
		[20] = "Show My Name",
		[21] = "Shows the unit name for events caused by you. \nUnit names are only shown when Verbose Mode is on.",
		[22] = "Show My Pet's Name",
		[23] = "Shows the unit name for events caused by your pet. \nUnit names are only shown when Verbose Mode is on.",
		[24] = "Show My Target's Name",
		[25] = "Shows the unit name for events caused by your attacker.\n Unit names are only shown when Verbose Mode is on.",
		[26] = "Flag Crits (*)",
		[27] = "Puts a flag around all critical events. Looks like:\n*1297*",
		[28] = "Flag Heals (+)",
		[29] = "Puts a plus sign in front of heals. Looks like:\n+892",
		[30] = "Flag Pet Damage (~)",
		[31] = "Puts a flag around all pet events. Looks like:\n~36~",
		[32] = "Recolor Crits",
		[33] = "Overlays the selected color over crits of all types. \nFor example, white would make all crits appear brighter. A pet crit \nwill not be double overlayed (it will use the pet overlay).",
		[34] = "Recolor Pet Damage",
		[35] = "Overlays the selected color over all pet numeric messages. \nFor example, white would make all pet damage appear \nbrighter. A pet crit will not be double overlayed (it will use the pet overlay).",
		[36] = "Recolor Based On Spell School",
		[37] = "Overlays the selected color over all spell damage numeric messages. \nFrost damage will be colored blue, fire damage will be colored red, etc.",
		[38] = "Show Extra Values",
		[39] = "Defines whether resisted, absorbed, blocked, and crushing values should be \nshown after regular damage or not.",
		[40] = "Show Rested Experience",
		[41] = "Shows how much experience was rested experience, if any. \nLooks like: 470 (+235)",
		[42] = "Gain Reputation",
		[43] = "Shows with which faction, when and how much reputation you gain.",
		[44] = "Remove Scroll Buttons From Chat Windows",
		[45] = "Lets you selectively remove the scroll buttons \nfrom any of the four HitsMode chat windows. \n(This will only work on windows that are enabled.) \n\nIf the buttons reappear for some reason (this does happen), \nopen and close the HitsMode options window to fix it.",
		[46] = "Allow Greater Resizing Of Chat Windows",
		[47] = "This will allow the selected chat windows to be resized smaller \nand larger than the World of Warcraft defaults. \nYou cannot do this with the General Chat window (window 1).",
		[48] = "Window 1 Options",
		[49] = "These options are specific to chat window 1 only. \nThis is where you specify which WoW chat window to \nuse for each HitsMode window. \n(More options are planned for future versions.)",
		[50] = "Enable Chat Window 1",
		[51] = "The master switch that turns on and off chat window 1.",
		[52] = "Output To Which Chat Window",
		[53] = "Selects which chat window HitsMode outputs to. \nThere can be up to 7 chat windows open at once. \nGeneral Chat is usually 1, and Combat Chat is usually 2. \nMove this slider until you find the one you want to use.",
		[54] = "Message Threshold",
		[55] = "Lets you suppress messages with values below a certain threshold.\nFor example, setting this slider to 10 will suppress all messages that are 10 points or less.\nThe threshold functions as an absolute value, so the above example would\nsuppress messages between -10 and 10.",
		[56] = "Window 2 Options",
		[57] = "These options are specific to chat window 2 only. \nThis is where you specify which WoW chat window to \nuse for each HitsMode window. (More options are planned for future versions.)",
		[58] = "Enable Chat Window 2",
		[59] = "The master switch that turns on and off chat window 2.",
		[60] = "Window 3 Options",
		[61] = "These options are specific to chat window 3 only. \nThis is where you specify which WoW chat window to use for each HitsMode window. \n(More options are planned for future versions.)",
		[62] = "Enable Chat Window 3",
		[63] = "The master switch that turns on and off chat window 3.",
		[64] = "Window 4 Options",
		[65] = "These options are specific to chat window 4 only. \nThis is where you specify which WoW chat window to use for each HitsMode window. \n(More options are planned for future versions.)",
		[66] = "Enable Chat Window 4",
		[67] = "The master switch that turns on and off chat window 4.",
		[68] = "Spell School Colors",
		[69] = "Arcane Spell Damage",
		[70] = "Fire Spell Damage",
		[71] = "Frost Spell Damage",
		[72] = "Holy Spell Damage",
		[73] = "Nature Spell Damage",
		[74] = "Shadow Spell Damage",
		[75] = "Actions Taken By You",
		[76] = "Miss/Absorb/Block/Deflect/Dodge/Resist/Parry/Immune/Evade",
		[77] = "Block",
		[78] = "Blocked Amount",
		[79] = "Deflect",
		[80] = "Dispel/Steal",
		[81] = "Dodge",
		[82] = "Evade",
		[83] = "Take Environmental Damage",
		[84] = "Gain A Buff/Debuff",
		[85] = "Gain Experience",
		[86] = "Gain Mana/Rage/Energy/Focus",
		[87] = "Gain Extra Attacks",
		[88] = "You Heal Yourself (double message)",
		[89] = "Immune",
		[90] = "You Heal Someone",
		[91] = "Interrupt Spell",
		[92] = "Instant Spell Damage",
		[93] = "Melee Damage",
		[94] = "Miss",
		[95] = "Parry",
		[96] = "Drop Totem",
		[97] = "Periodic Spell Damage",
		[98] = "Resist",
		[99] = "Spell Fades",
		[100] = "Use ++/-- Instead Of Gains/Fades (only affects you or your pet)",
		[101] = "You Are Periodically Healed",
		[102] = "You Periodically Heal Someone",
		[103] = "You Are Afflicted By A Debuff",
		[104] = "Attacker Versus You",
		[105] = "Lose A Buff/Debuff",
		[106] = "Kill An Enemy",
		[107] = "An Enemy Dies (will display [Name] dies)",
		[108] = "Someone Else Killed Someone",
		[109] = "Death Separator (-----)",
		[110] = "Attacker Versus Your Pet",
		[111] = "Actions Taken By Your Pet",
		[112] = "Actions Taken By Others",
		[113] = "Others Heal You",
		[114] = "Others Periodically Heal You",
		[115] = "Spell Fades From Someone",
		[116] = "Other",
		[117] = "Gain Honor",
		[118] = "Gain A Skill Point",
		[119] = "You Craft Something",
		[120] = "You Enchant Or Disenchant Something",
		[121] = "You Loot Something",
		[122] = "Someone Else Loots Something",
		[123] = "Enable Combat Summary",
		[124] = "Enables HitsMode's Combat Summary feature. HitsMode uses a custom,\n lightweight DPS engine that makes use of the existing HitsMode parsing\n engine to deliver fight recap details without slowing down your computer.",
		[125] = "Numeric Values",
		[126] = "Show \"/sec\"",
		[127] = "Try To Skip Non-Combat Encounters",
		[128] = "Does not display any combat summary if you or\nyour pet did no damage and you didn't heal anybody.\nUseful to skip \"run away!\" encounters.",
		[129] = "Combat Summary Messages",
		[130] = "Pre-Summary Combat Separator (~~~~~~~~~)",
		[131] = "Show Fight Duration",
		[132] = "Damage Given (You)",
		[133] = "Damage Taken (You)",
		[134] = "Damage Avoided (You)",
		[135] = "Heals Given",
		[136] = "Heals Received (You)",
		[137] = "Damage Given (Your Pet)",
		[138] = "Damage Taken (Your Pet)",
		[139] = "Mana/Energy/Rage Gained",
		[140] = "Attacks Gained",
		[141] = "Totems Dropped",
		[142] = "Skills Increased",
		[143] = "Experience Gained",
		[144] = "Post-Summary Combat Separator (~~~~~~~~~)",
		[145] = "Automatically Skip Combat Summary Messages That Are Zero",
		[146] = "Auto Skip Damage Taken/Given By You",
		[147] = "Auto Skip Damage Taken/Given By Your Pet",
		[148] = "Auto Skip Heals Received/Given By You",
		[149] = "Auto Skip Damage Avoided",
		[150] = "Enter the preset name",
		[151] = "Load",
		[152] = "Save Preset",
		[153] = "Messages",
		[154] = "Filters",
		[155] = "Summary",
		[156] = "HitsMode: Debug mode OFF. You must reload your UI for the changes to take effect.",
		[157] = "HitsMode: Debug mode ON. You must reload your UI for the changes to take effect.",
		[158] = "HitsMode: Debug mode is ON.",
		[159] = "%sHitsMode%s v%s%s loaded. Type /hitsmode or /hm.",
		[160] = "HM window %s is here!",
		[161] = "Chars",
		[162] = "Presets",
		[163] = "Copy",
		[164] = "Upgrading from a version prior to 1.2. Reset required.",
		[165] = "You are using a different version of HitsMode: Migrating options.",
		[166] = "Default options loaded for %s.",
		[167] = "Options migrated from version %s.",
		[168] = "%s new default values loaded.",
		[169] = "Using %s KB",
		[170] = "Unable to locate settings for character: %s",
		[171] = "Copied options from %s",
		[172] = "Unable to locate preset: %s",
		[173] = "Loaded preset: %s",
		[174] = "Saved preset: %s",
		[175] = "Deleted preset: %s",
		[176] = "Paste",
		[177] = "Saves a preset with a name of your choosing.\nPresets are global amongst all your characters.",
		[178] = "Preset name may not start with $$",
		[179] = "Show \"You\" Instead Of Your Name",
		[180] = "Shows \"You\" instead of your actual name in the combat log.",
		[181] = "Show Spell Icons",
		[182] = "Shows spell icons on the left of each message\nif the action used a spell or skill.",
		[183] = "Others Heal Your Pet",
		[184] = "Others Periodically Heal Your Pet",
		[185] = "Heals Received (Your Pet)",
		[186] = "Damage given (you): ",
		[187] = "Damage avoided (you): ",
		[188] = "Damage taken (you): ",
		[189] = "Damage given (your pet): ",
		[190] = "Damage taken (your pet): ",
		[191] = "Heals given: ",
		[192] = "Heals received (you): ",
		[193] = "Heals received (your pet): ",
		[194] = "Mana gained: ",
		[195] = "Energy gained: ",
		[196] = "Rage gained: ",
		[197] = "Attacks gained: ",
		[198] = "Totems dropped: ",
		[199] = "Skills increased: ",
		[200] = "Exp gained: ",
		[201] = "Heals",
		[202] = "You Heal Your Pet (double message)",
		[203] = "You Periodically Heal Your Pet (double message)",
		[204] = "You Periodically Heal Yourself (double message)",
		[205] = "Misc Options",
		[206] = "Unit Names",
		[207] = "Flags",
		[208] = "Color Overlays",
		[209] = "Summon/Create",
		[210] = "Gain Mana/Rage/Energy/Focus/Happiness",
		[211] = "Flag Energizes (+)",
		[212] = "Puts a plus sign in front of all energizes\n(mana/energy/rage/focus/happiness).\nLooks like: +12",
		[213] = "Drain",
		[214] = "Flag Experience/Honor/Reputation (+/-)",
		[215] = "Puts a plus or minus sign in front of experience/honor/reputation.\nLooks like: +12",
		[216] = "Your Target Heals Itself",
		[217] = "Your Target Periodically Heals Itself",
		[218] = "Get help about how to use HitsMode.",
		[219] = "Spells",
		[220] = "Others Versus Others",
		[221] = "Show Other Entity Name: Controlled By Player (Friendly/Neutral)",
		[222] = "For messages under the \"Others Versus Others\" section,\nunit names controlled by a player are governed by this option.",
		[223] = "Someone Else Heals Someone Else",
		[224] = "Someone Else Periodically Heals Someone Else",
		[225] = "Short Combat Separator (~~~)",
		[226] = "Filters",
		[227] = "Source Unit Type Filters (choose at least one from each category)",
		[228] = "Affiliation:"..GRN.." Mine|r",
		[229] = "Affiliation:"..GRN.." Party|r",
		[230] = "Affiliation:"..GRN.." Raid|r",
		[231] = "Affiliation:"..GRN.." Outsider|r",
		[232] = "Reaction:"..GRN.." Friendly|r",
		[233] = "Reaction:"..GRN.." Neutral|r",
		[234] = "Reaction:"..GRN.." Hostile|r",
		[235] = "Controlled By:"..GRN.." Player|r",
		[236] = "Controlled By:"..GRN.." NPC|r",
		[237] = "Type:"..GRN.." Player|r",
		[238] = "Type:"..GRN.." NPC|r",
		[239] = "Type:"..GRN.." Pet|r",
		[240] = "Type:"..GRN.." Guardian|r",
		[241] = "Type:"..GRN.." Object|r",
		[242] = "My Target",
		[243] = "My Focus",
		[244] = "Main Tank",
		[245] = "Main Assist",
		[246] = "Raid Target 1-8",
		[247] = HIL.."One Of These Names:|r",
		[248] = HIL.."Not One Of These Names:|r",
		[249] = "Destination Unit Type Filters (choose at least one from each category)",
		[250] = "Enter a comma-separated list of names that should only be shown.",
		[251] = "Enter a comma-separated list of names to be excluded.",
		[252] = "Enable Filter System",
		[253] = "Enable "..GRN.."Source|r Unit "..YEL.."Type|r Filters",
		[254] = "Enable "..GRN.."Destination|r Unit "..YEL.."Type|r Filters",
		[255] = "Enable "..GRN.."Source|r Unit "..YEL.."Name|r Filters",
		[256] = "Enable "..GRN.."Destination|r Unit "..YEL.."Name|r Filters",
		[257] = "Source Unit Name Filters",
		[258] = "Destination Unit Name Filters",
		[259] = "Enable "..GRN.."Source|r "..YEL.."Special|r Filters",
		[260] = "Enable "..GRN.."Destination|r "..YEL.."Special|r Filters",
		[261] = "Source Special Filters",
		[262] = "Destination Special Filters",
		[263] = "Me",
		[264] = "My Pet",
		[265] = "My Party",
		[266] = "My Raid",
		[267] = "Party Pets",
		[268] = "Raid Pets",
		[269] = "Show Other Entity Name: Controlled By NPC",
		[270] = "For messages under the \"Others Versus Others\" section,\nunit names controlled by an NPC are governed by this option.",
		[271] = "Filter Sections (choose which filter types you want to use)",
		[272] = "Master Switch (this enables the entire tab)",
		[273] = "Spam",
		[274] = "Spell Cast Start",
		[275] = "Spell Cast Success",
		[276] = "Spell Cast Failed (you will not be told why it failed)",
		[277] = "Dispel Failed",
		[278] = "Durability Loss",
		[279] = "Instant Kill",
		[280] = "Unit Died",
		[281] = "Unit Destroyed (for example, a summoned elemental ending it's allotted life)",
		[282] = "Master Switch (this enables the entire add-on)",
		[283] = "Show Spell Links",
		[284] = "Shows spell names as a link if possible.\n(Must also turn on Show Spell Names.)",
		[285] = "Colorize Unit Names By Class When Available (overrides the colors above)",
		[286] = "Colorizes all unit names based on their class.\nIf the class cannot be determined, the colors\nabove will be used.",
		[287] = "Click|r to open the HitsMode options window",
		[288] = "%s old options deleted.",
		[289] = "%s options converted to new format.",
		[290] = "Show Other Entity Name: Controlled By Player (Hostile)",
		[291] = "Show Raid Icons",
		[292] = "Shows the raid icon for the unit just before it's name, if applicable.",
		[293] = "Damage Given (Total)",
		[294] = "Total damage given:",
		[295] = "Announce DPS",
		[296] = "When enabled, HitsMode will announce your DPS to you\nusing Blizzard's floating combat text, or (if floating\ncombat text is disabled) the error frame.",
		[297] = "Announce New High DPS",
		[298] = "When enabled, HitsMode will keep track of your character's\nhighest DPS. If your DPS in the last fight (combined with\nyour pet) is higher than it's ever been before, HitsMode\nwill announce this to you using Blizzard's floating combat\ntext, or (if floating combat text is disabled) the error\nframe.\n\nTo reset your saved maximum, load HitsMode's default settings.",
		[299] = "*** NEW HIGH DPS! (",
		[300] = ") ***",
		[301] = "Total DPS: ",
	};

end
