-- HitsMode, by Allara


function HitsMode:CreateOptions(L)

 -- Create the initial object
 self.OptionsList = {};
 
 ----------------------------------------------------------------------------------------
 ---- PANE 1: General Options -----------------------------------------------------------
 ----------------------------------------------------------------------------------------
 self.OptionsList[1] = {
		{ ---------------------------------------------------------------
			type = "heading",
			t = 282, -- Master Switch (this enables the entire add-on)
			hideSelectAll = true,
		},
		{ 
			t = 2, -- Enable HitsMode
			single = true,
			hideColor = true,
			var = "enable",
			default = 1,
			tip = 3, -- Enables or disables HitsMode as a whole.\nDisabling HitsMode will not close any chat windows.\nGo to the Windows tab and scroll down to enable/disable each individual chat window.
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 4, -- Text Layout
			hideSelectAll = true,
		},
		{ 
			t = 6, -- Enable Verbose Mode A
			var = "verbosea",
			c = { r = (255/255),  g = (255/255),  b = (255/255) },  -- White
			tip = 7, -- Shows more information in chat. Mode A looks like:\n[You] hit for 12\n[Wolf] hits for 8
		},
		{ 
			t = 8, -- Enable Verbose Mode B
			var = "verboseb",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (255/255) },  -- White
			tip = 9, -- Shows more information in chat. Mode B looks like:\n[You] hit [Wolf] for 12\n[Wolf] hits [You] for 8
		},
		{ 
			t = 10, -- Enable Verbose Mode C
			var = "verbosec",
			c = { r = (255/255),  g = (255/255),  b = (255/255) },  -- White
			tip = 11, -- Shows more information in chat. Mode C looks like:\n12 - [You] hit [Wolf]\n8 - [Wolf] hits [You]
		},
		{ 
			t = 12, -- Short Verbose Mode
			hideColor = true,
			var = "shortmode",
			tip = 13, -- Eliminates the \"for\" in most messages.
		},
		{ 
			t = 16, -- Capitalize Text
			hideColor = true,
			var = "caps",
			tip = 17, -- Capitalizes the beginning of some verbose mode text.
		},
		{ 
			t = 100, -- Use ++/-- Instead Of Gains/Fades (only affects you or your pet)
			hideColor = true,
			var = "plusplus"
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 219, -- Spells
		},
		{ 
			t = 14, -- Show Spell Names
			var = "showskill",
			d1 = 1,
			c = { r = (202/255),  g = (76/255),  b = (217/255) },  -- Dark Pink
			tip = 15, -- Shows the name of the skill or spell that was used. \nThis only works if you have one of the Verbose Modes turned on.
		},
		{ 
			t = 283, -- Show Spell Links
			var = "showspelllinks",
			hideColor = true,
			d1 = 1,
			tip = 284, -- Shows spell names as a link if possible.\n(Must also turn on Show Spell Names.)
		},
		{ 
			t = 181, -- Show Spell Icons
			var = "showicons",
			hideColor = true,
			d1 = 1,
			tip = 182, -- Shows spell icons on the left of each message\nif the action used a spell or skill.
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 206, -- Unit Names
		},
		{ 
			t = 20, -- Show Your Name
			var = "showyou",
			d1 = 1,
			c = { r = (  0/255),  g = (192/255),  b = (255/255) },  -- Light Blue
			tip = 21, -- Shows the unit name for events caused by you. \nUnit names are only shown when Verbose Mode is on.
		},
		{ 
			t = 179, -- Show "You" Instead Of Your Name
			hideColor = true,
			var = "renameplayer",
			d1 = 1,
			d2 = 1,
			d3 = 1,
			d4 = 1,
			tip = 180, -- Shows "You" instead of your actual name in the combat log.
		},
		{ 
			t = 22, -- Show Pet's Name
			var = "showpet",
			d1 = 1,
			c = { b =  0.388235 , g =  1,  r =  0.376471 },  -- Light Green
			tip = 23, -- Shows the unit name for events caused by your pet. \nUnit names are only shown when Verbose Mode is on.
		},
		{ 
			t = 24, -- Show My Target's Name
			var = "showmob",
			d1 = 1,
			c = { b =  0.427451,  g =  0.454902,  r =  1 },  -- Light Pink
			tip = 25, -- Shows the unit name for events caused by your attacker.\n Unit names are only shown when Verbose Mode is on.
		},
		{ 
			t = 221, -- Show Other Entity Name: Controlled By Player (Friendly/Neutral)
			var = "showoth_player",
			d1 = 1,
			c = { r = (  0/255),  g = ( 89/255),  b = (255/255) },  -- Medium Blue
			tip = 222, -- For messages under the "Others Versus Others" section,\nunit names controlled by a player are governed by this option.
		},
		{ 
			t = 290, -- Show Other Entity Name: Controlled By Player (Hostile)
			var = "showoth_playerhostile",
			d1 = 1,
			c = { r = (255/255),  g = ( 59/255),  b = ( 18/255) },  -- Burnt Orange
			tip = 222, -- For messages under the "Others Versus Others" section,\nunit names controlled by a player are governed by this option.
		},
		{ 
			t = 269, -- Show Other Entity Name: Controlled By NPC
			var = "showoth_npc",
			d1 = 1,
			c = { r = (255/255),  g = ( 59/255),  b = ( 18/255) },  -- Burnt Orange
			tip = 270, -- For messages under the "Others Versus Others" section,\nunit names controlled by an NPC are governed by this option.
		},
		{ 
			t = 18, -- Show Brackets Around Unit Names
			var = "brackets",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (255/255) },  -- White
			tip = 19, -- Check to display brackets around unit names.
		},
		{ 
			t = 285, -- Colorize Unit Names By Class When Available (overrides the colors above)
			var = "colorbyclass",
			hideColor = true,
			tip = 286, -- Colorizes all unit names based on their class.\nIf the class cannot be determined, the colors above\nwill be used.
		},
		{ 
			t = 291, -- Show Raid Icons
			var = "showraidicons",
			hideColor = true,
			tip = 292, -- Shows the raid icon for the unit just before it's name, if applicable.
			d1 = 1,
			d2 = 1,
			d3 = 1,
			d4 = 1,
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 207, -- Flags
			hideSelectAll = true,
		},
		{ 
			t = 26, -- Flag Crits
			var = "flagcrits",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
			tip = 27, -- Puts a flag around all critical events. Looks like:\n*1297*
		},
		{ 
			t = 28, -- Flag Heals
			var = "flagheals",
			hideColor = true,
			d1 = 1,
			tip = 29, -- Puts a plus sign in front of heals. Looks like:\n+892
		},
		{ 
			t = 30, -- Flag Pet Damage
			var = "flagpet",
			hideColor = true,
			d1 = 1,
			tip = 31, -- Puts a flag around all pet events. Looks like:\n~36~
		},
		{ 
			t = 211, -- Flag Energizes
			var = "flagenergizes",
			hideColor = true,
			d1 = 1,
			tip = 212, -- Puts a plus sign in front of all energizes\n(mana/energy/rage/focus/happiness). Looks like: +12
		},
		{ 
			t = 214, -- Flag Experience/Honor/Reputation (+/-)
			var = "flagexp",
			hideColor = true,
			default = 1,
			single = true,
			tip = 215, -- Puts a plus or minus sign in front of experience/honor/reputation.\nLooks like: +12
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 208, -- Color Overlays
		},
		{ 
			t = 32, -- Recolor Crits
			var = "critoverlay",
			c = { r = (255/255),  g = (255/255),  b = (255/255) },  -- White
			tip = 33, -- Overlays the selected color over crits of all types. \nFor example, white would make all crits appear brighter. A pet crit \nwill not be double overlayed (it will use the pet overlay).
		},
		{ 
			t = 34, -- Recolor Pet Damage
			var = "petoverlay",
			c = { r = (255/255),  g = (255/255),  b = (255/255) },  -- White
			tip = 35, -- Overlays the selected color over all pet numeric messages. \nFor example, white would make all pet damage appear \nbrighter. A pet crit will not be double overlayed (it will use the pet overlay).
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 68, -- Spell School Colors
			hideSelectAll = true,
		},
		{
			t = 36, -- Recolor Based On Spell School
			hideColor = true,
			var = "schoCol",
			d1 = 1,
			tip = 37, -- Overlays the selected color over all spell damage numeric messages. \nFrost damage will be colored blue, fire damage will be colored red, etc.
		},
		{
			type =  "school",
			t = 69, -- Arcane Spell Damage
			var = "Arcane",
			d1 = 1,
			c = { r = (175/255),  g = (175/255),  b = (175/255) },  -- White
		},
		{
			type =  "school",
			t = 70, -- Fire Spell Damage
			var = "Fire",
			d1 = 1,
			c = { r = (255/255),  g = (0/255),  b = (0/255) },  -- Red
		},
		{
			type =  "school",
			t = 71, -- Frost Spell Damage
			var = "Frost",
			d1 = 1,
			c = { r = (0/255),  g = (0/255),  b = (255/255) },  -- Blue
		},
		{
			type =  "school",
			t = 72, -- Holy Spell Damage
			var = "Holy",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{
			type =  "school",
			t = 73, -- Nature Spell Damage
			var = "Nature",
			d1 = 1,
			c = { r = (0/255),  g = (255/255),  b = (0/255) },  -- Green
		},
		{
			type =  "school",
			t = 74, -- Shadow Spell Damage
			var = "Shadow",
			d1 = 1,
			c = { r = (185/255),  g = (0/255),  b = (171/255) },  -- Shadow
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 205, -- Misc Options
			hideSelectAll = true,
		},
		{
			t = 38, -- Show Extra Values
			var = "extval",
			d1 = 1,
			c = { r = (172/255),  g = (172/255),  b = (172/255) },  -- grayish
			tip = 39, -- Defines whether resisted, absorbed, blocked, and crushing values should be \nshown after regular damage or not.
		},
		{ 
			t = 40, -- Show Rested Experience
			var = "showrested",
			hideColor = true,
			single = true,
			d1 = 1,
			tip = 41, -- Shows how much experience was rested experience, if any. \nLooks like: 470 (+235)
		},
		{ 
			t = 46, -- Allow Greater Resizing for Chat Windows
			var = "resize",
			hideColor = true,
			tip = 47,
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 48, -- Window 1 Options
			tip = 49, -- These options are specific to chat window 1 only. \nThis is where you specify which WoW chat window to \nuse for each HitsMode window. \n(More options are planned for future versions.)
			hideSelectAll = true,
		},
		{ 
			t = 50, -- Enable Chat Window 1
			var = "enable1",
			hideColor = true,
			single = true,
			default = 1,
			tip = 51, -- The master switch that turns on and off chat window 1.
		},
		{
			t = 52, -- Output to Chat Window
			type = "slider",
			var = "window1",
			minValue = 1,
			maxValue = 7,
			minText = "1",
			maxText = "7",
			valueStep = 1,
			default = 7,
			tip = 53,
		},
		{
			t = 54, -- Message Threshold
			type = "slider",
			var = "threshold1",
			minValue = 0,
			maxValue = 200,
			minText = "0",
			maxText = "200",
			valueStep = 1,
			default = 0,
			tip = 55, -- Lets you suppress messages with values below a certain threshold.\nFor example, setting this slider to 10 will suppress all messages that are 10 points or less.\nThe threshold functions as an absolute value, so the above example would\nsuppress messages between -10 and 10.
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 56, -- Window 2 Options
			tip = 57, -- These options are specific to chat window 2 only. \nThis is where you specify which WoW chat window to \nuse for each HitsMode window. (More options are planned for future versions.)
			hideSelectAll = true,
		},
		{ 
			t = 58, -- Enable Chat Window 2
			var = "enable2",
			hideColor = true,
			single = true,
			tip = 59, -- The master switch that turns on and off chat window 2.
		},
		{
			t = 52, -- Output to Chat Window
			type = "slider",
			var = "window2",
			minValue = 1,
			maxValue = 7,
			minText = "1",
			maxText = "7",
			valueStep = 1,
			default = 6,
			tip = 53, -- Selects which chat window HitsMode outputs to. \nThere can be up to 7 chat windows open at once. \nGeneral Chat is usually 1, and Combat Chat is usually 2. \nMove this slider until you find the one you want to use.
		},
		{
			t = 54, -- Message Threshold
			type = "slider",
			var = "threshold2",
			minValue = 0,
			maxValue = 200,
			minText = "0",
			maxText = "200",
			valueStep = 1,
			default = 0,
			tip = 55, -- Lets you suppress messages with values below a certain threshold.\nFor example, setting this slider to 10 will suppress all messages that are 10 points or less.\nThe threshold functions as an absolute value, so the above example would\nsuppress messages between -10 and 10.
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 60, -- Window 3 Options
			tip = 61, -- These options are specific to chat window 3 only. \nThis is where you specify which WoW chat window to use for each HitsMode window. \n(More options are planned for future versions.)
			hideSelectAll = true,
		},
		{ 
			t = 62, -- Enable Chat Window 3
			var = "enable3",
			hideColor = true,
			single = true,
			tip = 63, -- The master switch that turns on and off chat window 3.
		},
		{
			t = 52, -- Output to Chat Window
			type = "slider",
			var = "window3",
			minValue = 1,
			maxValue = 7,
			minText = "1",
			maxText = "7",
			valueStep = 1,
			default = 5,
			tip = 53, -- Selects which chat window HitsMode outputs to. \nThere can be up to 7 chat windows open at once. \nGeneral Chat is usually 1, and Combat Chat is usually 2. \nMove this slider until you find the one you want to use.
		},
		{
			t = 54, -- Message Threshold
			type = "slider",
			var = "threshold3",
			minValue = 0,
			maxValue = 200,
			minText = "0",
			maxText = "200",
			valueStep = 1,
			default = 0,
			tip = 55, -- Lets you suppress messages with values below a certain threshold.\nFor example, setting this slider to 10 will suppress all messages that are 10 points or less.\nThe threshold functions as an absolute value, so the above example would\nsuppress messages between -10 and 10.
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 64, -- Window 4 Options
			tip = 65, -- These options are specific to chat window 4 only. \nThis is where you specify which WoW chat window to use for each HitsMode window. \n(More options are planned for future versions.)
			hideSelectAll = true,
		},
		{ 
			t = 66, -- Enable Chat Window 4
			var = "enable4",
			hideColor = true,
			single = true,
			tip = 67, -- The master switch that turns on and off chat window 4.
		},
		{
			t = 52, -- Output to Chat Window
			type = "slider",
			var = "window4",
			minValue = 1,
			maxValue = 7,
			minText = "1",
			maxText = "7",
			valueStep = 1,
			default = 4,
			tip = 53, -- Selects which chat window HitsMode outputs to. \nThere can be up to 7 chat windows open at once. \nGeneral Chat is usually 1, and Combat Chat is usually 2. \nMove this slider until you find the one you want to use.
		},
		{
			t = 54, -- Message Threshold
			type = "slider",
			var = "threshold4",
			minValue = 0,
			maxValue = 200,
			minText = "0",
			maxText = "200",
			valueStep = 1,
			default = 0,
			tip = 55, -- Lets you suppress messages with values below a certain threshold.\nFor example, setting this slider to 10 will suppress all messages that are 10 points or less.\nThe threshold functions as an absolute value, so the above example would\nsuppress messages between -10 and 10.
		},
	};
 
 
 
 ----------------------------------------------------------------------------------------
 ---- PANE 2: Messages ------------------------------------------------------------------
 ----------------------------------------------------------------------------------------
 self.OptionsList[2] = {
		{ ---------------------------------------------------------------
			type = "heading",
			t = 75, -- Actions Taken By You
		},
		{
			t = 76, -- Miss/Absorb/Block/Deflect/Dodge/Resist/Parry/Immune/etc.
			var = "you_miss",
			d1 = 1,
			c = { r = (  0/255),  g = (128/255),  b = (  0/255) },  -- Dark Green
		},
		{ 
			t = 93, -- Melee Damage
			var = "you_melee",
			d1 = 1,
			c = { r = (  0/255),  g = (255/255),  b = ( 36/255) },  -- Green
		},
		{ 
			t = 92, -- Instant Spell Damage
			var = "you_nuke",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{ 
			t = 97, -- Periodic Spell Damage
			var = "you_dot",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{ 
			t = 213, -- Drain
			var = "you_drain",
			d1 = 1,
			c = { r = (  0/255),  g = (255/255),  b = ( 36/255) },  -- Green
		},
		{ 
			t = 83, -- Take Environmental Damage
			var = "you_fall",
			d1 = 1,
			c = { r = (255/255),  g = ( 47/255),  b = ( 47/255) },  -- Red
		},
		{
			t = 91, -- Interrupt Spell
			var = "you_inter",
			d1 = 1,
			hideColor = true,
		},
		{
			t = 80, -- Dispel
			var = "you_dispel",
			d1 = 1,
			hideColor = true,
		},
		{ 
			t = 106, -- Kill An Enemy
			var = "mob_died",
			d1 = 1,
			hideColor = true,
		},
		{ 
			t = 84, -- Gain A Buff
			var = "you_gain",
			d1 = 1,
			hideColor = true,
		},
		{ 
			t = 105, -- Lose A Buff
			var = "you_debuff",
			d1 = 1,
			hideColor = true,
		},
		{ 
			t = 86, -- Gain Mana/Rage/Energy/Focus
			var = "you_energize",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{
			t = 87, -- Gain Extra Attacks
			var = "you_gainatk",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 85, -- Gain Experience
			var = "exp",
			d1 = 1,
			c = { r = (111/255),  g = (111/255),  b = (255/255) },  -- Purple
		},
		{
			t = 117, -- Gain Honor
			var = "you_gain_honor",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (0/255) },  -- Yellow
		},
		{
			t = 42, -- Gain Reputation
			var = "you_gain_rep",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{
			t = 118, -- Gain A Skill Point
			var = "skill_up",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (0/255) },  -- Yellow
		},
		{
			t = 209, -- Summon/Create
			var = "you_summon",
			d1 = 1,
			hideColor = true,
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 104, -- Attacker Versus You
		},
		{
			t = 76, -- Miss/Absorb/Block/Deflect/Dodge/Resist/Parry/Immune/Evade/Reflect
			var = "mob_miss",
			d1 = 1,
			c = { r = (128/255),  g = (  0/255),  b = (  0/255) },  -- Dark Red
		},
		{ 
			t = 93, -- Melee Damage
			var = "mob_melee",
			d1 = 1,
			c = { r = (255/255),  g = ( 47/255),  b = ( 47/255) },  -- Red
		},
		{ 
			t = 92, -- Instant Spell Damage
			var = "mob_nuke",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{
			t = 97, -- Periodic Spell Damage
			var = "mob_dot",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{ 
			t = 213, -- Drain
			var = "mob_drain",
			d1 = 1,
			c = { r = (255/255),  g = ( 47/255),  b = ( 47/255) },  -- Red
		},
		{
			t = 91, -- Interrupt Spell
			var = "mob_inter",
			d1 = 1,
			hideColor = true,
		},
		{
			t = 80, -- Dispel
			var = "mob_dispel",
			d1 = 1,
			hideColor = true,
		},
		{
			t = 84, -- Gain A Buff
			var = "mob_gains",
			d1 = 1,
			hideColor = true,
		},
		{
			t = 105, -- Lose A Buff
			var = "mob_debuff",
			d1 = 1,
			hideColor = true,
		},
		{ 
			t = 86, -- Gain Mana/Rage/Energy/Focus
			var = "mob_energize",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{
			t = 87, -- Gain Extra Attacks
			var = "mob_gainatk",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{
			t = 209, -- Summon/Create
			var = "mob_summon",
			d1 = 1,
			hideColor = true,
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 111, -- Actions Taken By Your Pet
		},
		{ 
			t = 76, -- Miss/Absorb/Block/Deflect/Dodge/Resist/Parry/Immune/Evade/Reflect
			var = "pet_miss",
			d1 = 1,
			c = { r = (  0/255),  g = (128/255),  b = (  0/255) },  -- Dark Green
		},
		{ 
			t = 93, -- Melee Damage
			var = "pet_melee",
			d1 = 1,
			c = { r = (  0/255),  g = (255/255),  b = ( 36/255) },  -- Green
		},
		{ 
			t = 92, -- Instant Spell Damage
			var = "pet_nuke",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{ 
			t = 97, -- Periodic Spell Damage
			var = "pet_dot",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{ 
			t = 213, -- Drain
			var = "pet_drain",
			d1 = 1,
			c = { r = (  0/255),  g = (255/255),  b = ( 36/255) },  -- Green
		},
		{
			t = 80, -- Dispel
			var = "pet_dispel",
			d1 = 1,
			hideColor = true,
		},
		{
			t = 84, -- Gain A Buff
			var = "pet_gains",
			d1 = 1,
			hideColor = true,
		},
		{
			t = 105, -- Lose A Buff
			var = "pet_debuff",
			d1 = 1,
			hideColor = true,
		},
		{ 
			t = 210, -- Gain Mana/Rage/Energy/Focus/Happiness
			var = "pet_energize",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{
			t = 87, -- Gain Extra Attacks
			var = "pet_gainatk",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 110, -- Attacker Versus Your Pet
		},
		{
			t = 76, -- Miss/Absorb/Block/Deflect/Dodge/Resist/Parry/Immune/Evade/Reflect
			var = "vspet_miss",
			d1 = 1,
			c = { r = (128/255),  g = (  0/255),  b = (  0/255) },  -- Dark Red
		},
		{
			t = 93, -- Melee Damage
			var = "vspet_melee",
			d1 = 1,
			c = { r = (255/255),  g = ( 47/255),  b = ( 47/255) },  -- Red
		},
		{ 
			t = 92, -- Instant Spell Damage
			var = "vspet_nuke",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{ 
			t = 97, -- Periodic Spell Damage
			var = "vspet_dot",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{ 
			t = 213, -- Drain
			var = "vspet_drain",
			d1 = 1,
			c = { r = (255/255),  g = ( 47/255),  b = ( 47/255) },  -- Red
		},
		{
			t = 80, -- Dispel
			var = "vspet_dispel",
			d1 = 1,
			hideColor = true,
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 220, -- Others Versus Others
		},
		{
			t = 76, -- Miss/Absorb/Block/Deflect/Dodge/Resist/Parry/Immune/etc.
			var = "oth_miss",
			c = { r = (128/255),  g = (  0/255),  b = (  0/255) },  -- Dark Red
		},
		{ 
			t = 93, -- Melee Damage
			var = "oth_melee",
			c = { r = (255/255),  g = ( 47/255),  b = ( 47/255) },  -- Red
		},
		{ 
			t = 92, -- Instant Spell Damage
			var = "oth_nuke",
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{ 
			t = 97, -- Periodic Spell Damage
			var = "oth_dot",
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{ 
			t = 213, -- Drain
			var = "oth_drain",
			c = { r = (255/255),  g = ( 47/255),  b = ( 47/255) },  -- Red
		},
		{ 
			t = 83, -- Take Environmental Damage
			var = "oth_fall",
			c = { r = (255/255),  g = ( 47/255),  b = ( 47/255) },  -- Red
		},
		{
			t = 91, -- Interrupt Spell
			var = "oth_inter",
			hideColor = true,
		},
		{
			t = 80, -- Dispel
			var = "oth_dispel",
			hideColor = true,
		},
		{ 
			t = 106, -- Kill An Enemy
			var = "oth_kill",
			hideColor = true,
		},
		{ 
			t = 84, -- Gain A Buff
			var = "oth_gain",
			hideColor = true,
		},
		{ 
			t = 105, -- Lose A Buff
			var = "oth_debuff",
			hideColor = true,
		},
		{ 
			t = 86, -- Gain Mana/Rage/Energy/Focus
			var = "oth_energize",
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{
			t = 87, -- Gain Extra Attacks
			var = "oth_gainatk",
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{
			t = 209, -- Summon/Create
			var = "oth_summon",
			hideColor = true,
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 201, -- Heals
		},
		{ 
			t = 90, -- You Heal Someone
			var = "you_heal",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 102, -- You Periodically Heal Someone
			var = "you_hot_others",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{
			t = 88, -- You Heal Yourself (double message)
			var = "you_heal_yourself",
			d1 = 0,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 204, -- You Periodically Heal Yourself (double message)
			var = "you_hot_yourself",
			d1 = 0,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{
			t = 202, -- You Heal Your Pet (double message)
			var = "you_heal_pet",
			d1 = 0,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{
			t = 203, -- You Periodically Heal Your Pet (double message)
			var = "you_hot_pet",
			d1 = 0,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 113, -- Others Heal You
			var = "others_heal_you",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 114, -- Others Periodically Heal You
			var = "others_hot_you",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 183, -- Others Heal Your Pet
			var = "others_heal_pet",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 184, -- Others Periodically Heal Your Pet
			var = "others_hot_pet",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 216, -- Your Target Heals Itself
			var = "mob_heal_itself",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 217, -- Your Target Periodically Heals Itself
			var = "mob_hot_itself",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 223, -- Someone Else Heals Someone Else
			var = "oth_heal_oth",
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ 
			t = 224, -- Someone Else Periodically Heals Someone Else
			var = "oth_hot_oth",
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 273, -- Spam
		},
		{ 
			t = 274, -- Spell Cast Start
			var = "spam_spellstart",
			hideColor = true
		},
		{ 
			t = 275, -- Spell Cast Success
			var = "spam_spellsuccess",
			hideColor = true
		},
		{ 
			t = 276, -- Spell Cast Failed (you will not be told why it failed)
			var = "spam_spellfailed",
			hideColor = true
		},
		{ 
			t = 277, -- Dispel Failed
			var = "spam_dispelfailed",
			hideColor = true
		},
		{ 
			t = 278, -- Durability Loss
			var = "spam_durability",
			hideColor = true
		},
		{ 
			t = 279, -- Instant Kill
			var = "spam_instantkill",
			hideColor = true
		},
		{ 
			t = 280, -- Unit Died
			var = "spam_unitdied",
			hideColor = true
		},
		{ 
			t = 281, -- Unit Destroyed (for example, a summoned elemental ending it's allotted life)
			var = "spam_unitdestroyed",
			hideColor = true
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 116, -- Other
		},
		{
			t = 119, -- You Craft Something
			var = "you_craft",
			d1 = 1,
			hideColor = true
		},
		{
			t = 120, -- You Enchant Something
			var = "you_ench",
			d1 = 1,
			hideColor = true
		},
		{
			t = 121, -- You Loot Something
			var = "you_loot",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (  0/255) },  -- Yellow
		},
		{
			t = 122, -- Someone Else Loots Something
			var = "they_loot",
			d1 = 1,
			hideColor = true
		},
	};


 ----------------------------------------------------------------------------------------
 ---- PANE 3: Filters -------------------------------------------------------------------
 ----------------------------------------------------------------------------------------
 self.OptionsList[3] = {
		{ ---------------------------------------------------------------
			type = "heading",
			t = 272, -- Master Switch (this enables the entire tab)
			hideSelectAll = true,
		},
		{ 
			t = 252, -- Enable Unit Filters
			single = true,
			hideColor = true,
			var = "enable_filters",
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 271, -- Filter Sections (choose which filter types you want to use)
		},
		{ 
			t = 259, -- Enable Source Special Filters
			hideColor = true,
			var = "enable_flt_src_spec",
		},
		{ 
			t = 260, -- Enable Destination Special Filters
			hideColor = true,
			var = "enable_flt_dst_spec",
		},
		{ 
			t = 253, -- Enable Source Unit Type Filters
			hideColor = true,
			var = "enable_flt_src_type",
		},
		{ 
			t = 254, -- Enable Destination Unit Type Filters
			hideColor = true,
			var = "enable_flt_dst_type",
		},
		{ 
			t = 255, -- Enable Source Unit Name Filters
			hideColor = true,
			var = "enable_flt_src_name",
		},
		{ 
			t = 256, -- Enable Destination Unit Name Filters
			hideColor = true,
			var = "enable_flt_dst_name",
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 261, -- Source Special Filters
		},
		{ 
			t = 263, -- Me
			hideColor = true,
			var = "flt_src_spec_me",
		},
		{ 
			t = 264, -- My Pet
			hideColor = true,
			var = "flt_src_spec_mypet",
		},
		{ 
			t = 265, -- My Party
			hideColor = true,
			var = "flt_src_spec_party",
		},
		{ 
			t = 266, -- My Raid
			hideColor = true,
			var = "flt_src_spec_raid",
		},
		{ 
			t = 267, -- Party Pets
			hideColor = true,
			var = "flt_src_spec_partypets",
		},
		{ 
			t = 268, -- Raid Pets
			hideColor = true,
			var = "flt_src_spec_raidpets",
		},
		{ 
			t = 242, -- Special: My Target
			hideColor = true,
			var = "flt_src_spec_target",
		},
		{ 
			t = 243, -- Special: My Focus
			hideColor = true,
			var = "flt_src_spec_focus",
		},
		{ 
			t = 244, -- Special: Main Tank
			hideColor = true,
			var = "flt_src_spec_tank",
		},
		{ 
			t = 245, -- Special: Main Assist
			hideColor = true,
			var = "flt_src_spec_assist",
		},
		{ 
			t = 246, -- Special: Raid Target 1-8
			hideColor = true,
			var = "flt_src_spec_raidtarget",
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 227, -- Source Unit Type Filters
		},
		{ 
			t = 228, -- Affiliation: Mine
			hideColor = true,
			var = "flt_src_affil_mine",
		},
		{ 
			t = 229, -- Affiliation: Party
			hideColor = true,
			var = "flt_src_affil_party",
		},
		{ 
			t = 230, -- Affiliation: Raid
			hideColor = true,
			var = "flt_src_affil_raid",
		},
		{ 
			t = 231, -- Affiliation: Outsider
			hideColor = true,
			var = "flt_src_affil_outsider",
		},
		{ 
			t = 232, -- Reaction: Friendly
			hideColor = true,
			var = "flt_src_reac_friendly",
		},
		{ 
			t = 233, -- Reaction: Neutral
			hideColor = true,
			var = "flt_src_reac_neutral",
		},
		{ 
			t = 234, -- Reaction: Hostile
			hideColor = true,
			var = "flt_src_reac_hostile",
		},
		{ 
			t = 235, -- Controlled By: Player
			hideColor = true,
			var = "flt_src_cont_player",
		},
		{ 
			t = 236, -- Controlled By: NPC
			hideColor = true,
			var = "flt_src_cont_npc",
		},
		{ 
			t = 237, -- Type: Player
			hideColor = true,
			var = "flt_src_type_player",
		},
		{ 
			t = 238, -- Type: NPC
			hideColor = true,
			var = "flt_src_type_npc",
		},
		{ 
			t = 239, -- Type: Pet
			hideColor = true,
			var = "flt_src_type_pet",
		},
		{ 
			t = 240, -- Type: Guardian
			hideColor = true,
			var = "flt_src_type_guardian",
		},
		{ 
			t = 241, -- Type: Object
			hideColor = true,
			var = "flt_src_type_object",
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 257, -- Source Unit Name Filters
		},
		{
			type = "text",
			t = 247, -- One Of These Names
			hideColor = true,
			var = "flt_src_includenames1",
			tip = 250, -- Enter a comma-separated list of names that should only be shown.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_src_includenames2",
			tip = 250, -- Enter a comma-separated list of names that should only be shown.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_src_includenames3",
			tip = 250, -- Enter a comma-separated list of names that should only be shown.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_src_includenames4",
			tip = 250, -- Enter a comma-separated list of names that should only be shown.
		},
		{
			type = "text",
			t = 248, -- Not One Of These Names
			hideColor = true,
			var = "flt_src_excludenames1",
			tip = 251, -- Enter a comma-separated list of names to be excluded.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_src_excludenames2",
			tip = 251, -- Enter a comma-separated list of names to be excluded.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_src_excludenames3",
			tip = 251, -- Enter a comma-separated list of names to be excluded.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_src_excludenames4",
			tip = 251, -- Enter a comma-separated list of names to be excluded.
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 262, -- Destination Special Filters
		},
		{ 
			t = 263, -- Me
			hideColor = true,
			var = "flt_dst_spec_me",
		},
		{ 
			t = 264, -- My Pet
			hideColor = true,
			var = "flt_dst_spec_mypet",
		},
		{ 
			t = 265, -- My Party
			hideColor = true,
			var = "flt_dst_spec_party",
		},
		{ 
			t = 266, -- My Raid
			hideColor = true,
			var = "flt_dst_spec_raid",
		},
		{ 
			t = 267, -- Party Pets
			hideColor = true,
			var = "flt_dst_spec_partypets",
		},
		{ 
			t = 268, -- Raid Pets
			hideColor = true,
			var = "flt_dst_spec_raidpets",
		},
		{ 
			t = 242, -- Special: My Target
			hideColor = true,
			var = "flt_dst_spec_target",
		},
		{ 
			t = 243, -- Special: My Focus
			hideColor = true,
			var = "flt_dst_spec_focus",
		},
		{ 
			t = 244, -- Special: Main Tank
			hideColor = true,
			var = "flt_dst_spec_tank",
		},
		{ 
			t = 245, -- Special: Main Assist
			hideColor = true,
			var = "flt_dst_spec_assist",
		},
		{ 
			t = 246, -- Special: Raid Target 1-8
			hideColor = true,
			var = "flt_dst_spec_raidtarget",
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 249, -- Destination Unit Type Filters
		},
		{ 
			t = 228, -- Affiliation: Mine
			hideColor = true,
			var = "flt_dst_affil_mine",
		},
		{ 
			t = 229, -- Affiliation: Party
			hideColor = true,
			var = "flt_dst_affil_party",
		},
		{ 
			t = 230, -- Affiliation: Raid
			hideColor = true,
			var = "flt_dst_affil_raid",
		},
		{ 
			t = 231, -- Affiliation: Outsider
			hideColor = true,
			var = "flt_dst_affil_outsider",
		},
		{ 
			t = 232, -- Reaction: Friendly
			hideColor = true,
			var = "flt_dst_reac_friendly",
		},
		{ 
			t = 233, -- Reaction: Neutral
			hideColor = true,
			var = "flt_dst_reac_neutral",
		},
		{ 
			t = 234, -- Reaction: Hostile
			hideColor = true,
			var = "flt_dst_reac_hostile",
		},
		{ 
			t = 235, -- Controlled By: Player
			hideColor = true,
			var = "flt_dst_cont_player",
		},
		{ 
			t = 236, -- Controlled By: NPC
			hideColor = true,
			var = "flt_dst_cont_npc",
		},
		{ 
			t = 237, -- Type: Player
			hideColor = true,
			var = "flt_dst_type_player",
		},
		{ 
			t = 238, -- Type: NPC
			hideColor = true,
			var = "flt_dst_type_npc",
		},
		{ 
			t = 239, -- Type: Pet
			hideColor = true,
			var = "flt_dst_type_pet",
		},
		{ 
			t = 240, -- Type: Guardian
			hideColor = true,
			var = "flt_dst_type_guardian",
		},
		{ 
			t = 241, -- Type: Object
			hideColor = true,
			var = "flt_dst_type_object",
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 258, -- Source Unit Name Filters
		},
		{
			type = "text",
			t = 247, -- One Of These Names
			hideColor = true,
			var = "flt_dst_includenames1",
			tip = 250, -- Enter a comma-separated list of names that should only be shown.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_dst_includenames2",
			tip = 250, -- Enter a comma-separated list of names that should only be shown.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_dst_includenames3",
			tip = 250, -- Enter a comma-separated list of names that should only be shown.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_dst_includenames4",
			tip = 250, -- Enter a comma-separated list of names that should only be shown.
		},
		{
			type = "text",
			t = 248, -- Not One Of These Names
			hideColor = true,
			var = "flt_dst_excludenames1",
			tip = 251, -- Enter a comma-separated list of names to be excluded.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_dst_excludenames2",
			tip = 251, -- Enter a comma-separated list of names to be excluded.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_dst_excludenames3",
			tip = 251, -- Enter a comma-separated list of names to be excluded.
		},
		{
			type = "text",
			hideColor = true,
			var = "flt_dst_excludenames4",
			tip = 251, -- Enter a comma-separated list of names to be excluded.
		},
	};



 ----------------------------------------------------------------------------------------
 ---- PANE 4: Combat Summary ------------------------------------------------------------
 ----------------------------------------------------------------------------------------
 self.OptionsList[4] = {
		{ ---------------------------------------------------------------
			type = "heading",
			t = 272, -- Master Switch (this enables the entire tab)
			hideSelectAll = true,
		},
		{ 
			t = 123, -- Enable Combat Summary
			single = true,
			hideColor = true,
			var = "enable_combatsummary",
			default = 1,
			tip = 124, -- Enables HitsMode's Combat Summary feature. HitsMode uses a custom,\n lightweight DPS engine that makes use of the existing HitsMode parsing\n engine to deliver fight recap details without slowing down your computer.
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 1, -- General
			hideSelectAll = true,
		},
		{
			type = "school",
			t = 125, -- Numeric Values
			var = "cs_numeric",
			c = { r = (255/255),  g = (255/255),  b = (255/255) },  -- White
		},
		{ 
			t = 126, -- Show \"/sec\"
			var = "cs_sec",
			d1 = 1,
			d2 = 1,
			d3 = 1,
			d4 = 1,
			c = { r = ( 96/255),  g = ( 96/255),  b = ( 96/255) },  -- Dark Gray
		},
		{ 
			t = 127, -- Try To Skip Non-Combat Encounters
			tip = 128, -- Does not display any combat summary if you or\nyour pet did no damage and you didn't heal anybody.\nUseful to skip \"run away!\" encounters.
			var = "cs_skipentire",
			d1 = 1,
			d2 = 1,
			d3 = 1,
			d4 = 1,
			hideColor = true,
		},
		{ 
			t = 295, -- Announce DPS
			single = true,
			var = "cs_announcedps",
			default = 1,
 		tip = 296, -- When enabled, HitsMode will announce your DPS to you\nusing Blizzard's floating combat text, or (if floating\ncombat text is disabled) the error frame.
			c = { r = (255/255),  g = (255/255),  b = (0/255) },  -- Yellow
		},
		{ 
			t = 297, -- Announce New High DPS
			single = true,
			var = "cs_announcehighdps",
			default = 1,
 		tip = 298, -- When enabled, HitsMode will keep track of your character's\nhighest DPS. If your DPS in the last fight (combined with\nyour pet) is higher than it's ever been before, HitsMode\nwill announce this to you using Blizzard's floating combat\ntext, or (if floating combat text is disabled) the error\nframe.\n\nTo reset your saved maximum, load HitsMode's default settings.
			c = { r = (255/255),  g = (255/255),  b = (255/255) },  -- White
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 129, -- Combat Summary Messages
		},
		{
			t = 225, -- Short Combat Separator (~~~)
			var = "cs_sep_short",
			c = { r = (111/255),  g = (111/255),  b = (255/255) },  -- Purple
		},
		{
			t = 130, -- Pre-Summary Combat Separator (~~~~~~~~~)
			var = "cs_sep1",
			d1 = 1,
			c = { r = (111/255),  g = (111/255),  b = (255/255) },  -- Purple
		},
		{ 
			t = 131, -- Show Fight Duration
			var = "cs_duration",
			d1 = 1,
			c = { r = (111/255),  g = (111/255),  b = (255/255) },  -- Purple
		},
		{
			t = 132, -- Damage Given
			var = "cs_damagegiven",
			d1 = 0,
			c = { r = (  0/255),  g = (255/255),  b = ( 36/255) },  -- Green
		},
		{
			t = 133, -- Damage Taken
			var = "cs_damagetaken",
			d1 = 1,
			c = { r = (255/255),  g = ( 47/255),  b = ( 47/255) },  -- Red
		},
		{
			t = 134, -- Damage Avoided
			var = "cs_damageavoided",
			d1 = 1,
			c = { r = (128/255),  g = (128/255),  b = (128/255) },  -- Gray
		},
		{
			t = 135, -- Heals Given
			var = "cs_healsgiven",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (0/255) },  -- Yellow
		},
		{
			t = 136, -- Heals Received
			var = "cs_healsreceived",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (128/255) },  -- Light Yellow
		},
		{
			t = 137, -- Pet Damage Given
			var = "cs_petdamagegiven",
			d1 = 0,
			c = { r = (  0/255),  g = (128/255),  b = (  0/255) },  -- Dark Green
		},
		{
			t = 138, -- Pet Damage Taken
			var = "cs_petdamagetaken",
			d1 = 1,
			c = { r = (128/255),  g = (  0/255),  b = (  0/255) },  -- Dark Red
		},
		{
			t = 185, -- Pet Heals Received
			var = "cs_pethealsreceived",
			d1 = 1,
			c = { r = (255/255),  g = (255/255),  b = (128/255) },  -- Light Yellow
		},
		{
			t = 293, -- Total Damage Given
			var = "cs_totaldamagegiven",
			d1 = 1,
			c = { r = (  0/255),  g = (255/255),  b = ( 36/255) },  -- Green
		},
		{
			t = 139, -- Mana/Energy/Rage Gained
			var = "cs_gained",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{
			t = 140, -- Attacks Gained
			var = "cs_attacksgained",
			d1 = 1,
			c = { r = (255/255),  g = (128/255),  b = (128/255) },  -- Pink
		},
		{
			t = 142, -- Skills Increased
			var = "cs_skills",
			d1 = 1,
			c = { r = (  0/255),  g = (  0/255),  b = (128/255) },  -- Dark Blue
		},
		{
			t = 143, -- Experience Gained
			var = "cs_exp",
			d1 = 1,
			c = { r = (111/255),  g = (111/255),  b = (255/255) },  -- Purple
		},
		{
			t = 144, -- Post-Summary Combat Separator (~~~~~~~~~)
			var = "cs_sep2",
			d1 = 1,
			c = { r = (111/255),  g = (111/255),  b = (255/255) },  -- Purple
		},
		{ ---------------------------------------------------------------
			type = "heading",
			t = 145, -- Automatically Skip Combat Summary Messages That Are Zero
		},
		{ 
			t = 146, -- Auto Skip Damage Taken/Given By You
			hideColor = true,
			var = "skip_yourdamage",
			d1 = 1,
			d2 = 1,
			d3 = 1,
			d4 = 1,
		},
		{ 
			t = 147, -- Auto Skip Damage Taken/Given By Your Pet
			hideColor = true,
			var = "skip_petdamage",
			d1 = 1,
			d2 = 1,
			d3 = 1,
			d4 = 1,
		},
		{ 
			t = 148, -- Auto Skip Heals Received/Given By You
			hideColor = true,
			var = "skip_yourheals",
			d1 = 1,
			d2 = 1,
			d3 = 1,
			d4 = 1,
		},
		{ 
			t = 149, -- Auto Skip Damage Avoided
			hideColor = true,
			var = "skip_avoided",
			d1 = 1,
			d2 = 1,
			d3 = 1,
			d4 = 1,
		},
	};

 -- Populate the Characters panel
 self:PopulateCharacters();
 
 -- Populate the Presets panel
 self:PopulatePresets();

end
