local MINOR_VERSION = tonumber(("$Revision: 80080 $"):match("%d+"))
HitsMode = LibStub("AceAddon-3.0"):NewAddon("HitsMode", "AceConsole-3.0", "AceEvent-3.0")
HitsMode.version = GetAddOnMetadata("HitsMode", "Version");
HitsMode.MINOR_VERSION = MINOR_VERSION;--


local WHT = "|cffffffff";
local BLK = "|cff000000";
local YEL = "|cffffff20";
local RED = "|cffff2020";
local GRN = "|cff20ff20";
local BLU = "|cff2020ff";
local HIL = "|cfffbd284";

BINDING_HEADER_HITSMODE = "HitsMode";
BINDING_NAME_OPTIONSTOGGLE = "Show HitsMode Options Window";

local L = nil;
local isEnabled = 0;
local coerceChat = 0;
local currentWindow = 0;
local optionsVisible = 0;
local currentPanel = 1;
local lockUpdateOptions = 0;
local pOptions = nil;
local currentColor = 0;
local inCombat = 0;
local loadingHelp = 0;
local fullyLoaded = false;

local damageTaken = 0;
local damageGiven = 0;
local healsTaken = 0;
local healsGiven = 0;
local damageResisted = 0;
local petDamageGiven = 0;
local petDamageTaken = 0;
local petHealsTaken = 0;
local petHealsGiven = 0;
local manaGained = 0;
local energyGained = 0;
local rageGained = 0;
local attacksGained = 0;
local skillsIncreased = 0;
local expGained = 0;
local combatStartTime = 0;
local announced = false;

local NUMTABS = 6;
local PANELINDEX_CHARS = 5;
local PANELINDEX_PRESETS = 6;
local NUMOPTIONS = 26;
local OPTIONHEIGHT = 18;
local HM_EXPTYPE_EXPERIENCE = 1;
local HM_EXPTYPE_HONOR = 2;
local HM_EXPTYPE_REPUTATION = 3;


function HitsMode:OnEnable()
	-- Get localized strings
 L = self:Localize();
 if L == nil then return; end
 self:LocalizeXml();

 -- Register events
 local events = {
		"PLAYER_REGEN_DISABLED",
		"PLAYER_REGEN_ENABLED",
		"CHAT_MSG_COMBAT_XP_GAIN",
		"CHAT_MSG_LOOT",
		"CHAT_MSG_COMBAT_FACTION_CHANGE",
		"CHAT_MSG_COMBAT_HONOR_GAIN",
		"CHAT_MSG_MONEY",
		"CHAT_MSG_SKILL",
	};
 for key, value in pairs(events) do
  self:RegisterEvent(value, "OnEvent");
 end

 -- Add Slash Commands
 self:RegisterChatCommand("hitsmode", "ShowOptions");
 self:RegisterChatCommand("hm", "ShowOptions");
 
 -- Add extra font heights to the game
 CHAT_FONT_HEIGHTS = { 6, 8, 10, 11, 12, 14, 16, 18, 20, 24, 36, 48, 72, 96 };

 -- Startup the options system
 self:CreateOptions(L);
 self:InitializeOptionsSystem();

 -- Turn HitsMode on if it's enabled
 if (self:Get("enable") ~= 0) then
  self:TurnOn();
 end

 -- Initialize the options window
 PanelTemplates_SetNumTabs(HMOptionsPaneBgFrame, NUMTABS);
 self:SwitchPanel(1);

		-- Setup the Save Preset static popup
	StaticPopupDialogs["HITSMODE_SAVE_PRESET"] = {
		text = L[150], -- Enter the preset name
		button1 = TEXT(ACCEPT),
		button2 = TEXT(CANCEL),
		hasEditBox = 1,
		maxLetters = 60,
		whileDead = 1,
		OnAccept = function(renameID)
			local name = getglobal(this:GetParent():GetName().."EditBox"):GetText();
			getglobal(this:GetParent():GetName().."EditBox"):SetText("");
			self:SavePreset(name);
		end,
		timeout = 0,
		EditBoxOnEnterPressed = function(renameID)
			local name = getglobal(this:GetParent():GetName().."EditBox"):GetText();
			getglobal(this:GetParent():GetName().."EditBox"):SetText("");
			self:SavePreset(name);
			this:GetParent():Hide();
		end,
		EditBoxOnEscapePressed = function ()
			getglobal(this:GetParent():GetName().."EditBox"):SetText("");
			this:GetParent():Hide();
		end,
		hideOnEscape = 1
	};
	
	-- Cleanup
	self:Cleanup();

 -- Print our loaded message
 self:Print(string.format(L[159], self:C(.3, .3, 1), self:C(1, 1, 1), self.version, self:C(.3, .3, 1)));
 fullyLoaded = true;
end


function HitsMode:Localize()
	local loc = GetLocale();
	if type(self["Localize_"..loc]) == "function" then
		return self["Localize_"..loc](self);
	elseif type(self["Localize_enUS"]) == "function" then
		self:Print("Warning: HitsMode was unable to localize to your language. Defaulting to US English.");
		return self:Localize_enUS();
	else
		self:Print("Error: HitsMode was unable to locate any localizations. Disabling.");
		return nil;
	end
end


function HitsMode:LocalizeXml()
	-- Localize all static UI strings
	local i;
	for i = 1, NUMOPTIONS do
  local prefix = "HMOptionLine"..i;
  getglobal(prefix.."_Load"):SetText(L[151]); -- Load
	end
	getglobal("HMSavePresetButton"):SetText(L[152]); -- Save Preset
	getglobal("HMOptionsPaneBgFrameTab1"):SetText(L[1]); -- General
	getglobal("HMOptionsPaneBgFrameTab2"):SetText(L[153]); -- Messages
	getglobal("HMOptionsPaneBgFrameTab3"):SetText(L[154]); -- Filters
	getglobal("HMOptionsPaneBgFrameTab4"):SetText(L[155]); -- Summary
	getglobal("HMOptionsPaneBgFrameTab5"):SetText(L[161]); -- Chars
	getglobal("HMOptionsPaneBgFrameTab6"):SetText(L[162]); -- Presets
	getglobal("HMColorPickerCopyButton"):SetText(L[163]); -- Copy
	getglobal("HMColorPickerPasteButton"):SetText(L[176]); -- Paste
	
	-- Force a resize on the tabs
	for i = 1, NUMTABS do
		local name = "HMOptionsPaneBgFrameTab"..i;
		local tab = getglobal(name);
		PanelTemplates_TabResize(0, tab);
		getglobal(name.."HighlightTexture"):SetWidth(tab:GetTextWidth() + 31);
	end
end


function HitsMode:OnUpdateFuBarTooltip()
	GameTooltip:AddLine("|cffffff00"..L[287])
end

function HitsMode:OnFuBarClick(button)
	HitsMode:ToggleOptions();
end


function HitsMode:Cleanup()
	self.OptionsList = 0;
	self.OptionsList = nil;
	collectgarbage("collect");
end


function HitsMode:TurnOn()
 local c;
 
 if (isEnabled == 0) then
  self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "OnEvent");
  coerceChat = 0;
  for c = 1, 4 do
   if (self:Get("enable"..c) == 1) then
    currentWindow = c;
    self:EnableMultiwindow(c);
   end
  end
  isEnabled = 1;
 end
end


function HitsMode:EnableMultiwindow(window)
 local shown, chatFrame, chatTab, _;
 local i = self:GetSliderValue("window"..window);
  
 _, _, _, _, _, _, shown, _ = GetChatWindowInfo(i);
 chatFrame = getglobal("ChatFrame"..i);
 chatTab = getglobal("ChatFrame"..i.."Tab");
 if (not shown and not chatFrame.isDocked and (i ~= 1)) then
  FCF_SetWindowName(chatFrame, "HitsMode "..window);
  FCF_SetWindowColor(chatFrame, DEFAULT_CHATFRAME_COLOR.r, DEFAULT_CHATFRAME_COLOR.g, DEFAULT_CHATFRAME_COLOR.b);
  FCF_SetWindowAlpha(chatFrame, DEFAULT_CHATFRAME_ALPHA);
  SetChatWindowLocked(i, nil);
  ChatFrame_RemoveAllMessageGroups(chatFrame);
  chatFrame:Show();
  SetChatWindowShown(i, 1);
  FCF_DockFrame(chatFrame, i);
 end
 if (self:Get("resize", window) == 1 and i ~= 1) then
  chatFrame:SetMaxResize(1000, 700);
  chatFrame:SetMinResize(40, 40);
 else
  chatFrame:SetMaxResize(608, 400);
  chatFrame:SetMinResize(296, 75);
 end
 self:PrintW(string.format(L[160], window)); -- HM window %s is here!
end


function HitsMode:TurnOff()
 if (isEnabled == 1) then
  self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
  isEnabled = 0;
 end
end


function HitsMode:ShowHelp()
 ToggleHelpFrame();
 loadingHelp = 1;
end


function HitsMode:HelpOnLoad()
	LoadMicroButtonTextures("Help");
end


-- This is only called while the Options window is open and if the
-- help button is present. We need to use this to tell the
-- knowledge base to search for our help articles after it has loaded.
function HitsMode:HelpOnUpdate()
 if (loadingHelp == 1) then
  if (KBSetup_IsLoaded()) then
   loadingHelp = 0;
   KnowledgeBaseFrameEditBox:SetText("");
   UIDropDownMenu_SetSelectedName(KnowledgeBaseFrameCategoryDropDown, "HitsMode");
   KnowledgeBaseFrame_Search(1);
  end
 end
end


-- Main event handler
function HitsMode:OnEvent(event, ...)
 if (isEnabled) then
  self:HandleCombatEvent(event, ...);
 end
end


function HitsMode:Is(flags, flag)
	if (flags == nil or flag == nil) then return false; end
 return (bit.band(flags, flag) ~= 0);
end

function HitsMode:PackColor(r, g, b)
	return bit.lshift(bit.mod(r * 255, 256), 16) + bit.lshift(bit.mod(g * 255, 256), 8) + bit.mod(b * 255, 256);
end

function HitsMode:UnpackColor(c)
	return bit.band(bit.rshift(c, 16), 255) / 255, bit.band(bit.rshift(c, 8), 255) / 255, bit.band(c, 255) / 255;
end

function HitsMode:PackValues(a, b, c, d)
	local v = 0;
	if (a and a ~= 0) then v = v + 1; end
	if (b and b ~= 0) then v = v + 2; end
	if (c and c ~= 0) then v = v + 4; end
	if (d and d ~= 0) then v = v + 8; end
	return v;
end

function HitsMode:UnpackValues(v)
	return (bit.band(v, 1) > 0), (bit.band(v, 2) > 0), (bit.band(v, 4) > 0), (bit.band(v, 8) > 0);
end


-- Adds a message to the current HitsMode window
function HitsMode:PrintW(msg)
 local c = coerceChat;
 coerceChat = 0; -- turn off coerce so we make sure to get the right chat window during GetValue
 if (currentWindow == 0 or currentWindow == nil) then return; end
 getglobal("ChatFrame"..self:GetSliderValue("window"..currentWindow)):AddMessage(msg);
 coerceChat = c; -- set coerce back where it was
end


-- BuildColorCode:
-- Returns a string that changes the color in any WoW displayed string.
-- You can use |r to close the color change or just change to the next color.
function HitsMode:C(r, g, b)
 return string.format("|cff%02x%02x%02x", (r*255), (g*255), (b*255));
end


-- GetColorCode: Gets the configured color and converts it to a chat color code 
function HitsMode:GC(option)
 return self:C(self:GetColor(option));
end


-- Gets a configured chat color code and scales it by a certain value
function HitsMode:GetScaledColor(option, scale)
	local r, g, b = self:GetColor(option);
 return self:C(r * scale, g * scale, b * scale);
end


-- GetColorCodeOverlay:
-- Gets an overlayed chat color code. Requires some extra input, where:
--   unit is either you, pet, or mob
--   msgtype is crit or anything else
-- Crit overlay takes precedence; a Pet Crit will appear with Crit overlay only.
function HitsMode:GCO(option, unit, msgtype)
	local r, g, b = self:GetColor(option);
 
 if (msgtype == "crit") then
  if (self:Get("critoverlay") == 1) then
   local r2, g2, b2 = self:GetColor("critoverlay");
   r = (r / 2) + (r2 / 2);
   g = (g / 2) + (g2 / 2);
   b = (b / 2) + (b2 / 2);
  end
 elseif (unit == "pet") then
  if (self:Get("petoverlay") == 1) then
   local r2, g2, b2 = self:GetColor("critoverlay");
   r = (r / 2) + (r2 / 2);
   g = (g / 2) + (g2 / 2);
   b = (b / 2) + (b2 / 2);
  end
 end
 
 return self:C(r, g, b);
end


-- Gets the requested chat message string. This does the checking for capitalize.
function HitsMode:GetString(option)
 local s = self.ChatMessages[option];
 if (s == nil) then
  self:Print(string.format("[Error] GetString: Unable to locate \"%s\"", option));
  return " ";
 end
 if (self:Get("caps") == 1 and option ~= "FOR") then
  s = string.upper(string.sub(s, 1, 1))..string.sub(s, 2);
 end
 return s;
end


-- Returns brackets if they have been turned on
function HitsMode:BracketLeft()
 if (self:Get("brackets") == 1) then
  return self:GC("brackets")..self:GetString("BRACKETLEFT").."|r";
 else
  return "";
 end
end


function HitsMode:BracketRight()
 if (self:Get("brackets") == 1) then
  return self:GC("brackets")..self:GetString("BRACKETRIGHT").."|r";
 else
  return "";
 end
end


function HitsMode:Round(base, precision)
 local m = math.pow(10, precision);
 local a = math.floor(base * m) / m;
 return a;
end


function HitsMode:FormatNumber(number)
 return self:Round(number, 2);
end


function HitsMode:IsPet(s, f)
	if (s == nil or f == nil) then return false; end
	if (UnitName("pet") == nil) then return false;	end
	local b = (s == UnitName("pet") and self:Is(f, COMBATLOG_OBJECT_AFFILIATION_MINE) and self:Is(f, COMBATLOG_OBJECT_REACTION_FRIENDLY) and self:Is(f, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Is(f, COMBATLOG_OBJECT_TYPE_PET));
 return b;
end


function HitsMode:IsTarget(s, f)
	if (s == nil or f == nil) then return false; end
	local b = (s == UnitName("target") and self:Is(f, COMBATLOG_OBJECT_TARGET));
 return b;
end


function HitsMode:IsYou(s, f)
	if (s == nil or f == nil) then return false; end
	local b = (s == UnitName("player") and self:Is(f, COMBATLOG_OBJECT_AFFILIATION_MINE) and self:Is(f, COMBATLOG_OBJECT_REACTION_FRIENDLY) and self:Is(f, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Is(f, COMBATLOG_OBJECT_TYPE_PLAYER));
 return b;
end


function HitsMode:IsParty(s, f)
	if (s == nil or f == nil) then return false; end
	if (self:Is(f, COMBATLOG_OBJECT_AFFILIATION_PARTY) and self:Is(f, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Is(f, COMBATLOG_OBJECT_REACTION_FRIENDLY) and self:Is(f, COMBATLOG_OBJECT_TYPE_PLAYER)) then
		local i;
		for i = 1, 4 do
			if (s == UnitName("party"..i)) then return true; end
		end
	end
	return false;
end


function HitsMode:IsPartyPet(s, f)
	if (s == nil or f == nil) then return false; end
	if (self:Is(f, COMBATLOG_OBJECT_AFFILIATION_PARTY) and self:Is(f, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Is(f, COMBATLOG_OBJECT_REACTION_FRIENDLY) and self:Is(f, COMBATLOG_OBJECT_TYPE_PET)) then
		local i;
		for i = 1, 4 do
			if (s == UnitName("partypet"..i)) then return true; end
		end
	end
	return false;
end


function HitsMode:IsRaid(s, f)
	if (s == nil or f == nil) then return false; end
	if (self:Is(f, COMBATLOG_OBJECT_AFFILIATION_RAID) and self:Is(f, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Is(f, COMBATLOG_OBJECT_REACTION_FRIENDLY) and self:Is(f, COMBATLOG_OBJECT_TYPE_PLAYER)) then
		local i;
		for i = 1, 40 do
			if (s == UnitName("raid"..i)) then return true; end
		end
	end
	return false;
end


function HitsMode:IsRaidPet(s, f)
	if (s == nil or f == nil) then return false; end
	if (self:Is(f, COMBATLOG_OBJECT_AFFILIATION_RAID) and self:Is(f, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Is(f, COMBATLOG_OBJECT_REACTION_FRIENDLY) and self:Is(f, COMBATLOG_OBJECT_TYPE_PET)) then
		local i;
		for i = 1, 40 do
			if (s == UnitName("raidpet"..i)) then return true; end
		end
	end
	return false;
end


function HitsMode:IsInList(s, list)
	if (s == nil or list == nil) then return false; end
	local a, l, x;
	a = string.lower(string.gsub(s, "%s", ""));
	l = string.lower(list)..",";
 for x in string.gmatch(l, "(.-)%,") do
		x = string.gsub(x, "%s", "");
		--self:DebugWrite(string.format("checking name from comma list: %s against: %s", x, a));
		if (x == a) then return true; end
 end
 return false;
end


function HitsMode:IsCrit(critical)
	return (critical ~= nil);
end


function HitsMode:Damage(amount, critical)
	if amount == nil then return ""; else return string.format("%s", amount); end
end


function HitsMode:FormatBool(b)
	if b == true then return "true"; else return "false"; end
end


function HitsMode:Flip(a, b)
	return b, a;
end


function HitsMode:Add(a, b)
	if a == nil then a = 0; end
	if b == nil then b = 0; end
	return a + b;
end


function HitsMode:DebugWrite(s)
	--self:Print(s);
end


function HitsMode:GetSpellIcon(spellId)
 local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(spellId);
 return icon;
end


function HitsMode:GetItemLink(itemId)
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(itemId);
	return itemLink;
end


-- This system is very nil-safe, except for one assumption. Because of the order of
-- calls, the option system assumes that if a variable exists, it's entire structure
-- has been created. Therefore, it's important you properly initialize the option
-- system before any calls to Get or Set functions.
--
-- The structure of an option variable is as follows:
--
--   HM_Options["Player of Realm"]  (pOptions is set to this on init)
--     ["variable name"]
--       ["value"]  the single value of the option (also the value of sliders)
--       ["window"]
--  1..4    the individual toggles for each chat window
--       ["color"]
--  r, g, b  the color of the option (0-1 range)
--
-- This system relies on the self.OptionsList object to load default values. If a
-- default is not present, a 0 is initialized into the field.


-- Starts up the options system
function HitsMode:InitializeOptionsSystem()
 if (HM_Options == nil) then
  self:InitBlankOptions();
 end
 pOptions = self:GetOptionsPlayer();
end


function HitsMode:Get(var, num)
 if (coerceChat == 1) then num = currentWindow; end
 if (num == nil) then num = 1; end
 if (pOptions[var]) then
		a, b, c, d = self:UnpackValues(pOptions[var][1]);
		if (num == 1) then if (a) then return 1; else return 0; end
		elseif (num == 2) then if (b) then return 1; else return 0; end
		elseif (num == 3) then if (c) then return 1; else return 0; end
		elseif (num == 4) then if (d) then return 1; else return 0; end
		else
			self:Print(string.format("[Error] GetValue: Invalid window number %s specified for variable %s", num, var));
			return 0;
		end
	else
  self:Print(string.format("[Error] GetValue: Unable to locate \"%s\"", var));
  return 0;
	end
end

function HitsMode:SetValue(var, value, num)
 if (pOptions[var]) then
		a, b, c, d = self:UnpackValues(pOptions[var][1]);
		if (num == 1) then a = value;
		elseif (num == 2) then b = value;
		elseif (num == 3) then c = value;
		elseif (num == 4) then d = value;
		else
			self:Print(string.format("[Error] SetValue: Invalid window number %s specified for variable %s", num, var));
		end
		pOptions[var][1] = self:PackValues(a, b, c, d);
 else
  self:Print(string.format("[Error] SetValue: Unable to locate \"%s\"", var));
 end
end

function HitsMode:SetTextValue(var, value)
 if (pOptions[var]) then
		pOptions[var][4] = value;
	else
  self:Print(string.format("[Error] SetTextValue: Unable to locate \"%s\"", var));
 end
end

function HitsMode:GetTextValue(var)
 if (pOptions[var]) then
		return pOptions[var][4] or "";
	else
  self:Print(string.format("[Error] GetTextValue: Unable to locate \"%s\"", var));
  return "";
 end
end

function HitsMode:SetAllValues(var, value)
 self:SetValue(var, value, 1);
 self:SetValue(var, value, 2);
 self:SetValue(var, value, 3);
 self:SetValue(var, value, 4);
end

function HitsMode:SetSliderValue(var, value)
 if (pOptions[var]) then
		pOptions[var][3] = value;
	else
  self:Print(string.format("[Error] SetSliderValue: Unable to locate \"%s\"", var));
 end
end

function HitsMode:GetSliderValue(var, value)
 if (pOptions[var]) then
		return pOptions[var][3] or 0;
	else
  self:Print(string.format("[Error] GetSliderValue: Unable to locate \"%s\"", var));
 end
end

function HitsMode:GetColor(var)
 if (pOptions[var]) then
		return self:UnpackColor(pOptions[var][2] or 0);
 else
  self:Print(string.format("[Error] GetColor: Unable to locate \"%s\"", var));
  return 1, 1, 1;
 end
end

function HitsMode:SetColor(var, value)
 if (pOptions[var]) then
  pOptions[var][2] = self:PackColor(value.r, value.g, value.b);
 else
  self:Print(string.format("[Error] SetColor: Unable to locate \"%s\"", var));
 end
end


-- Creates the initial blank object
function HitsMode:InitBlankOptions()
 HM_Options = { };
end


-- Returns a pointer to the current player's option set, or creates a default if none present
function HitsMode:GetOptionsPlayer()
 name = UnitName("player").." of "..GetCVar("realmName");

 -- No current options object found, load all defaults
 if (HM_Options[name] == nil) then
  self:LoadDefaultOptions(name);
  
 -- Upgrading from a version prior to 1.2, which introduced multiwindow support and requires a reset
 elseif (HM_Options[name].version == "1.0" or HM_Options[name].version == "1.1") then
  self:Print(self:C(.3, .3, 1)..L[164]); -- Upgrading from a version prior to 1.2. Reset required.
  self:LoadDefaultOptions(name);
  
 -- Different version found, migrate options
 elseif (HM_Options[name].version ~= self.version) then
  self:Print(self:C(.3, .3, 1)..L[165]); -- You are using a different version of HitsMode: Migrating options.
  self:MigrateOptions(HM_Options[name]);
  
 -- Same version, but we're still going to migrate silently in case something got corrupted
 else
		self:MigrateOptions(HM_Options[name], true);
 end
 return HM_Options[name];
end


-- Makes a deep copy of a given table
function HitsMode:CopyTable(t, lookup_table)
 local copy = {};
 for i,v in pairs(t) do
  if type(v) ~= "table" then
   copy[i] = v;
  else
   lookup_table = lookup_table or {};
   lookup_table[t] = copy;
   if lookup_table[v] then
    copy[i] = lookup_table[v]; -- We already copied this table, reuse the copy
   else
    copy[i] = self:CopyTable(v,lookup_table); -- Not yet copied, copy it
   end
  end
 end
 return copy;
end


function HitsMode:PopulatePresets()
 self.OptionsList[PANELINDEX_PRESETS] = { };
 self.OptionsList[PANELINDEX_PRESETS][1] = {
  type = "preset",
  presetText = self:C(1, 1, 0).."Default Settings|r",
  presetName = "$$default",
  delete = 0
 };
 if (HM_Options) then
  if (HM_Options["presets"] == nil) then HM_Options["presets"] = { }; end
  local i = 2;
  for k, v in pairs(HM_Options["presets"]) do
   if (strsub(k, 1, 2) ~= "$$") then
				self:MigrateOptions(v, true);
    self.OptionsList[PANELINDEX_PRESETS][i] = {
     type = "preset",
     presetText = k,
     presetName = k
    };
    i = i + 1;
   end
  end
 end
end


function HitsMode:PopulateCharacters()
 local name = UnitName("player").." of "..GetCVar("realmName");
 local i = 1;
 self.OptionsList[PANELINDEX_CHARS] = { };
 if (HM_Options) then
  for k, v in pairs(HM_Options) do
   if (k ~= name and k ~= "global" and k ~= "presets" and v["version"] ~= "1.0" and v["version"] ~= "1.1") then
				self:MigrateOptions(v, true);
    self.OptionsList[PANELINDEX_CHARS][i] = {
     type = "preset",
     presetText = k,
     presetName = "$$"..k,
     delete = 0
    };
    i = i + 1;
   end
  end
  self.OptionsList["global"] = nil; -- Ditch legacy "global" settings
 end
end


function HitsMode:SavePresetOnClick()
 StaticPopup_Show("HITSMODE_SAVE_PRESET");
end


function HitsMode:SavePreset(presetName)
 if (strsub(presetName, 1, 2) ~= "$$") then
  local name = UnitName("player").." of "..GetCVar("realmName");
  if HM_Options["presets"] == nil then HM_Options["presets"] = { }; end
  HM_Options["presets"][presetName] = self:CopyTable(HM_Options[name]);
  self:PopulatePresets();
  self:UpdateOptions();
  self:Print(string.format(self:C(.3, .3, 1)..L[174], presetName)); -- Saved preset: %s
 else
  self:Print(string.format(self:C(.3, .3, 1)..L[178])); -- Preset name may not start with $$
 end
end


function HitsMode:DeletePreset(presetName)
 HM_Options["presets"][presetName] = nil;
 self:PopulatePresets();
 self:UpdateOptions();
 self:Print(string.format(self:C(.3, .3, 1)..L[175], presetName)); -- Deleted preset: %s
end


function HitsMode:LoadPreset(presetName)
 local name = UnitName("player").." of "..GetCVar("realmName");
 pOptions = nil;
 
 -- Defaults
 if (presetName == "$$default") then
  self:LoadDefaultOptions(name);
  
 -- Another character
 elseif (strsub(presetName, 1, 2) == "$$") then
  local copyName = strsub(presetName, 3);
  if (HM_Options[copyName] == nil) then
   self:Print(string.format(self:C(.3, .3, 1)..L[170], copyName)); -- Unable to locate settings for character: %s
  else
   HM_Options[name] = self:CopyTable(HM_Options[copyName]);
   self:Print(string.format(self:C(.3, .3, 1)..L[171], copyName)); -- Copied options from %s
  end
 
 -- Preset -- cannot find
 elseif (HM_Options["presets"][presetName] == nil) then
  self:Print(string.format(self:C(.3, .3, 1)..L[172], presetName)); -- Unable to locate preset: %s
  
 -- Preset -- found
 else
  HM_Options[name] = self:CopyTable(HM_Options["presets"][presetName]);
  self:Print(string.format(self:C(.3, .3, 1)..L[173], presetName)); -- Loaded preset: %s
 end
 
 pOptions = HM_Options[name];
 self:UpdateOptions();
end


-- Creates a new default configuration for the current player
function HitsMode:LoadDefaultOptions(name, silent)
 local c, p;

 HM_Options[name] = nil;
 HM_Options[name] = { };
 p = HM_Options[name];
 p.version = self.version;
 p.maxdps = 0.0;
 
 for c = 1, NUMTABS-2 do
  for key, value in pairs(self.OptionsList[c]) do
			if (value.var) then
			
				p[value.var] = {};
			
				-- Checkboxes
				if (value.single and value.default) then p[value.var][1] = self:PackValues(value.default, value.default, value.default, value.default);
				else p[value.var][1] = self:PackValues(value.d1 or false, value.d2 or false, value.d3 or false, value.d4 or false); end
				
				-- Color
				if (value.hideColor ~= true and value.c) then p[value.var][2] = self:PackColor(value.c.r or 0, value.c.g or 0, value.c.b or 0); end
				
				-- Slider value
				if (value.type == "slider") then
					p[value.var][2] = 0; -- Fill in the color to keep array entries linear
					p[value.var][3] = value.default or 0;
				
				-- Text value
				elseif (value.type == "text") then
					p[value.var][2] = 0; -- Keep array entries linear again
					p[value.var][3] = 0; -- Still keeping array entries linear, can't skip any
					p[value.var][4] = value.defaultText or "";
				end
				
   end
  end
 end
 
 if (silent == nil) then
  self:Print(self:C(.3, .3, 1)..string.format(L[166], name)); -- Default options loaded for %s.
 end
end


-- Migrates options from an older version. Converts old options format to new format,
-- loads defaults for any missing options, and deletes and options that are no longer in use.
function HitsMode:MigrateOptions(p, silent)
 local c, count, oldversion, deleted, converted;

 oldversion = p.version or "(unknown)";
 count = 0;
 deleted = 0;
 converted = 0;

 -- Delete options that no longer exist
 for key, value in pairs(p) do
		local found = false;
		for c = 1, NUMTABS-2 do
			for key2, value2 in pairs(self.OptionsList[c]) do
				if (value2.var == key) then
					found = true;
					break;
				end
			end
		end
		if (found == false and key ~= "version") then
			p[key] = nil;
			deleted = deleted + 1;
		end
	end
	
	-- Set the version
	p.version = self.version;

	-- Convert old format options to new format
	for c = 1, NUMTABS-2 do
  for key, value in pairs(self.OptionsList[c]) do
   if (value.var and p[value.var]) then
				if (p[value.var].value or p[value.var].window or p[value.var].color or p[value.var].textValue) then

					-- Checkboxes
					if (value.single and p[value.var].value) then p[value.var][1] = p[value.var].value;
					elseif (p[value.var].window) then p[value.var][1] = self:PackValues(p[value.var].window[1] or 0, p[value.var].window[2] or 0, p[value.var].window[3] or 0, p[value.var].window[4] or 0);
					else p[value.var][1] = 0; end

					-- Color
					if (p[value.var].color) then p[value.var][2] = self:PackColor(p[value.var].color.r or 0, p[value.var].color.g or 0, p[value.var].color.b or 0);
					else p[value.var][2] = self:PackColor(1, 1, 1); end

					-- Slider value
					if (value.type == "slider") then p[value.var][3] = p[value.var].value or 0; end

					-- Text value
					if (value.type == "text") then
						p[value.var][3] = 0;
						p[value.var][4] = p[value.var].textValue or "";
					end

					-- Drop old data
					p[value.var].value = nil;
					p[value.var].window = nil;
					p[value.var].color = nil;
					p[value.var].textValue = nil;

					converted = converted + 1;
				end
			end
		end	
	end

	-- Get Lua to reallocate the table to free up space
	p["resetTrigger"] = 0;
	p["resetTrigger"] = nil;

	-- Load any missing defaults
 for c = 1, NUMTABS-2 do
  for key, value in pairs(self.OptionsList[c]) do
   if (value.var) then
				if (p[value.var] == nil) then
				
					p[value.var] = {};

					-- Checkboxes
					if (value.single and value.default) then p[value.var][1] = self:PackValues(value.default, value.default, value.default, value.default);
					else p[value.var][1] = self:PackValues(value.d1 or false, value.d2 or false, value.d3 or false, value.d4 or false); end

					-- Color
					if (value.hideColor ~= true and value.c) then p[value.var][2] = self:PackColor(value.c.r or 1, value.c.g or 1, value.c.b or 1);
					else p[value.var][2] = self:PackColor(1, 1, 1); end

					-- Slider value
					if (value.type == "slider") then
						p[value.var][2] = 0; -- Fill in the color to keep array entries linear
						p[value.var][3] = value.default or 0;

					-- Text value
					elseif (value.type == "text") then
						p[value.var][2] = 0; -- Keep array entries linear again
						p[value.var][3] = 0; -- Still keeping array entries linear, can't skip any
						p[value.var][4] = value.defaultText or "";
					end

     count = count + 1;
    end
   end
  end
 end

 if (silent == nil) then
  self:Print(self:C(.3, .3, 1)..string.format(L[167], oldversion)); -- Options migrated from version %s.
  self:Print(self:C(.3, .3, 1)..string.format(L[168], count)); -- %s new default values loaded.
  self:Print(self:C(.3, .3, 1)..string.format(L[288], deleted)); -- %s old options deleted.
  self:Print(self:C(.3, .3, 1)..string.format(L[289], converted)); -- %s options converted to new format.
 end
end


-- Displays the options window
function HitsMode:ShowOptions()
	self:CreateOptions(L);
	HMHelpMicroButton.tooltipText = L[218]; -- Get help about how to use HitsMode.
 ShowUIPanel(HMOptions);
end


-- Hides the options window
function HitsMode:HideOptions()
 HideUIPanel(HMOptions);
 self:Cleanup();
end


-- Toggles the options window
function HitsMode:ToggleOptions()
	if (fullyLoaded ~= true or L == nil) then return; end
 if (optionsVisible == 1) then
  self:HideOptions();
 else
  self:ShowOptions();
 end
end


-- The OnShow handler
function HitsMode:OptionsFrameOnShow()
 self:TurnOff();
 PlaySound("igMainMenuOpen");
 optionsVisible = 1;
 self:UpdateOptions();
 getglobal("HMOptionsWindowHeaderText"):SetText("HitsMode v"..self.version.." rev "..self.MINOR_VERSION);
end


-- The OnHide handler
function HitsMode:OptionsFrameOnHide()
 self:SetInfo("");
 PlaySound("igMainMenuClose");
 optionsVisible = 0;
 if (self:Get("enable") == 1) then
  self:TurnOn();
 end
end


function HitsMode:OptionsOnVerticalScroll()
	FauxScrollFrame_OnVerticalScroll(OPTIONHEIGHT, function() end);
	HitsMode:UpdateOptions();
end


-- Gets the number of options in the current panel
function HitsMode:GetOptionCount()
 return table.getn(self.OptionsList[currentPanel]);
end


-- Gets the current offset
function HitsMode:GetOffset()
 return FauxScrollFrame_GetOffset(HMOptionsPane);
end


-- Draws the option window
-- Important: the options system must be fully initialized before calling this
function HitsMode:UpdateOptions()
 local c, cc;
 local panel = currentPanel;
 local offset = self:GetOffset();
 local numItems = self:GetOptionCount();
 
 FauxScrollFrame_Update(HMOptionsPane, numItems, NUMOPTIONS, OPTIONHEIGHT);
 
 if (lockUpdateOptions == 0) then
  lockUpdateOptions = 1;
 else
  return;
 end
 
 for c = 1, NUMOPTIONS do
  local prefix = "HMOptionLine"..c;
  local line = getglobal(prefix);
  local highlight = getglobal(prefix.."_HighlightBox");
  local headerHighlight = getglobal(prefix.."_HeaderHighlightBox");
  local description = getglobal(prefix.."_Description");
  local color = getglobal(prefix.."_Color");
  local swatch = getglobal(prefix.."_ColorSwatchTexture");
  local heading = getglobal(prefix.."_Heading");
  local slider = getglobal(prefix.."_Slider");
  local divider = getglobal(prefix.."_DividerLine");
  local delete = getglobal(prefix.."_Delete");
  local load = getglobal(prefix.."_Load");
  local editbox = getglobal(prefix.."_EditBox");
  
  local config = self.OptionsList[panel][c+offset];
    
  -- An option exists
  if (config) then
   line:Show();
   self:HideOptionsLine(c);
   if (c == NUMOPTIONS) then
    divider:Hide();
   end

   -- Heading
   if (config.type == "heading") then
    line.disableHighlight = 1;
    heading:SetText(L[config.t]);
    heading:Show();
    headerHighlight:Show();
    if config.hideSelectAll == nil or config.hideSelectAll == false then
					for cc = 1, 4 do
						local checkbutton = getglobal("HMOptionLine"..c.."_CheckButton"..cc);
						local i = c + offset + 1;
						local checked = true;
						while self.OptionsList[panel][i] ~= nil and self.OptionsList[panel][i].type ~= "heading" do
							if self:Get(self.OptionsList[panel][i].var, cc) == 0 then
								checked = false;
								break;
							end
							i = i + 1;
						end
						checkbutton:SetChecked(checked);
						checkbutton:Show();
					end
				end
    
   -- Slider
   elseif (config.type == "slider") then
    local string = getglobal(prefix.."_SliderText");
    local low = getglobal(prefix.."_SliderLow");
    local high = getglobal(prefix.."_SliderHigh");
    local valuetext = getglobal(prefix.."_SliderValueText");
    local getvalue = self:GetSliderValue(config.var);
    slider:SetMinMaxValues(config.minValue, config.maxValue);
    slider:SetValueStep(config.valueStep);
    slider:SetValue(getvalue);
    valuetext:SetText(getvalue);
    description:SetText(L[config.t]);
    low:SetText(config.minText);
    high:SetText(config.maxText);
    description:Show();
    slider:Show();
    
   -- Spell school
   elseif (config.type == "school") then
    description:SetText(L[config.t]);
    description:Show();
    if (config.hideColor == nil) then
     local r, g, b = self:GetColor(config.var);
     color.r = r;
     color.g = g;
     color.b = b;
     swatch:SetTexture(r, g, b);
     color:Show();
    end
    
   -- Preset 
   elseif (config.type == "preset") then
    description:SetText(config.presetText);
    description:Show();
    if (config.delete == nil or config.delete == 1) then delete:Show(); end
    if (config.show == nil or config.load == 1) then load:Show(); end
    line.presetName = config.presetName;
    
   -- Text entry option
   elseif (config.type == "text") then
    for cc = 1, 4 do
     local checkbutton = getglobal("HMOptionLine"..c.."_CheckButton"..cc);
     checkbutton:SetChecked(self:Get(config.var, cc));
     if (config.single == nil) then
      checkbutton:Show();
     elseif (cc == 4) then
      checkbutton:Show();
      checkbutton:SetChecked(self:Get(config.var));
     end
    end
    description:SetText(L[config.t]);
    description:Show();
    line.disableHighlight = nil;
    editbox:Show();
    editbox:SetText(self:GetTextValue(config.var));

   -- Regular option
   else
    for cc = 1, 4 do
     local checkbutton = getglobal("HMOptionLine"..c.."_CheckButton"..cc);
     checkbutton:SetChecked(self:Get(config.var, cc));
     if (config.single == nil) then
      checkbutton:Show();
     elseif (cc == 4) then
      checkbutton:Show();
      checkbutton:SetChecked(self:Get(config.var));
     end
    end
    description:SetText(L[config.t]);
    description:Show();
    line.disableHighlight = nil;
    if (config.hideColor == nil) then
     local r, g, b = self:GetColor(config.var);
     color.r = r;
     color.g = g;
     color.b = b;
     swatch:SetTexture(r, g, b);
     color:Show();
    end    
    
   end

  -- No option exists
  else
   line:Hide();
  end
 end
 
 lockUpdateOptions = 0;
end


function HitsMode:HideOptionsLine(c)
 local cc;
 local prefix = "HMOptionLine"..c;
 local line = getglobal(prefix);
 local highlight = getglobal(prefix.."_HighlightBox");
 local headerHighlight = getglobal(prefix.."_HeaderHighlightBox");
 local description = getglobal(prefix.."_Description");
 local color = getglobal(prefix.."_Color");
 local heading = getglobal(prefix.."_Heading");
 local slider = getglobal(prefix.."_Slider");
 local delete = getglobal(prefix.."_Delete");
 local load = getglobal(prefix.."_Load");
 local editbox = getglobal(prefix.."_EditBox");

 for cc = 1, 4 do
  local checkbutton = getglobal("HMOptionLine"..c.."_CheckButton"..cc);
  checkbutton:Hide();
 end
 description:Hide();
 color:Hide();
 highlight:Hide();
 heading:Hide();
 slider:Hide();
 headerHighlight:Hide();
 load:Hide();
 delete:Hide();
 line.disableHighlight = nil;
 line.presetName = nil;
 line.presetDisplayName = nil;
 editbox:Hide();
end


function HitsMode:SwitchPanel(panel)
 currentPanel = panel;
 FauxScrollFrame_SetOffset(HMOptionsPane, 0);
 getglobal("HMOptionsPaneBgFrameTab"..panel):SetFrameLevel(HMOptionsPaneBgFrame:GetFrameLevel() + 1);
 PanelTemplates_SetTab(HMOptionsPaneBgFrame, panel);
 getglobal("HMOptionsPaneScrollBar"):SetValue(0);
 self:UpdateOptions();
end


function HitsMode:SetInfo(str)
 if (string == "" or string == nil) then
  GameTooltip:Hide();
 else
  GameTooltip:SetOwner(UIParent, "ANCHOR_BOTTOMRIGHT");
  GameTooltip:SetText(str);
  GameTooltip:Show();
 end
end


function HitsMode:OnMouseEnter(o)
 if (o:GetName() == "HMSavePresetButton") then
  self:SetInfo(L[177]);
 else
  if (getglobal(o:GetName()).disableHighlight == nil) then
   if (getglobal(o:GetName().."_HighlightBox") ~= nil) then
    getglobal(o:GetName().."_HighlightBox"):Show();
   end
  end
  local offset = tonumber(o:GetID());
  local option = self.OptionsList[currentPanel][self:GetOffset()+offset];
  if (option) then
   if (option.tip) then
    self:SetInfo(L[option.tip]);
   else
    self:SetInfo("");
   end
  else
   self:SetInfo("");
  end
 end
end


function HitsMode:OnMouseLeave(o)
 if (getglobal(o:GetName().."_HighlightBox")) then
  if (getglobal(o:GetName()).disableHighlight == nil) then
   getglobal(o:GetName().."_HighlightBox"):Hide();
  end
 end
 self:SetInfo("");
end


function HitsMode:SliderOnValueChanged(o)
 local slider = getglobal(o:GetName().."_Slider");
 local offset = tonumber(o:GetID());
 local option = self.OptionsList[currentPanel][self:GetOffset()+offset];
 self:SetSliderValue(option.var, slider:GetValue());
end


function HitsMode:CheckboxOnClick(o)
 local offset = tonumber(o:GetParent():GetID());
 local option = self.OptionsList[currentPanel][self:GetOffset()+offset];
 local checked;
 if (o:GetChecked()) then
  checked = 1;
 else
  checked = 0;
 end
 if option.type == "heading" then
		local i = self:GetOffset() + offset + 1;
		while self.OptionsList[currentPanel][i] ~= nil and self.OptionsList[currentPanel][i].type ~= "heading" do
			if (self.OptionsList[currentPanel][i].single) then
				self:SetAllValues(self.OptionsList[currentPanel][i].var, checked);
			else
				self:SetValue(self.OptionsList[currentPanel][i].var, checked, tonumber(o:GetID()));
			end
			i = i + 1;
		end
 else
		self:SetValue(option.var, checked, tonumber(o:GetID()));
		if (option.single) then
			self:SetAllValues(option.var, checked);
		end
		if (option.var == "verbosea" and checked == 1) then
			self:SetValue("verboseb", 0, tonumber(o:GetID()));
			self:SetValue("verbosec", 0, tonumber(o:GetID()));
		elseif (option.var == "verboseb" and checked == 1) then
			self:SetValue("verbosea", 0, tonumber(o:GetID()));
			self:SetValue("verbosec", 0, tonumber(o:GetID()));
		elseif (option.var == "verbosec" and checked == 1) then
			self:SetValue("verbosea", 0, tonumber(o:GetID()));
			self:SetValue("verboseb", 0, tonumber(o:GetID()));
		end
 end
	self:UpdateOptions();
end


function HitsMode:EditBoxOnTextChanged(o)
 local offset = tonumber(o:GetParent():GetID());
 local option = self.OptionsList[currentPanel][self:GetOffset()+offset];
 self:SetTextValue(option.var, o:GetText());
end


function HitsMode:OpenColorPicker(c, o)
	currentColor = c;
 CloseMenus();
 local offset = tonumber(o:GetID());
 local option = self.OptionsList[currentPanel][self:GetOffset()+offset];
 local prefix = "HMOptionLine"..currentColor;
 local swatch = getglobal(prefix.."_ColorSwatchTexture");
 local color = getglobal(prefix.."_Color");
 local r, g, b = self:GetColor(option.var);
 color.r = r;
 color.g = g;
 color.b = b;
 HMColorPicker:SetColorRGB(color.r, color.g, color.b);
 HMColorPicker.previousValues = { r = color.r, g = color.g, b = color.b };
 HMColorPicker:Show();
end


function HitsMode:ColorFunc()
 local r, g, b = HMColorPicker:GetColorRGB();
 local offset = tonumber(currentColor);
 local option = self.OptionsList[currentPanel][self:GetOffset()+offset];
 local prefix = "HMOptionLine"..currentColor;
 local swatch = getglobal(prefix.."_ColorSwatchTexture");
 local color = getglobal(prefix.."_Color");
 local savedColor = { };
 
 swatch:SetTexture(r, g, b);
 color.r = r;
 color.g = g;
 color.b = b;
 savedColor.r = r;
 savedColor.g = g;
 savedColor.b = b;
 self:SetColor(option.var, savedColor);

 if HM_ColorPicker_InTextChanged ~= true then
		HMColorPicker_ValueR:SetText((r*255));
		HMColorPicker_ValueG:SetText((g*255));
		HMColorPicker_ValueB:SetText((b*255));
 end
end


function HitsMode:ColorPickerOnTextChanged()
	HM_ColorPicker_InTextChanged = true;

	local rText = HMColorPicker_ValueR:GetText();
	if rText == "" or rText == nil then rText = "0" end;
	local r = tonumber(rText) / 255;
	if r > 1 then
		r = 1;
		HMColorPicker_ValueR:SetText((r*255));
	end
	local gText = HMColorPicker_ValueG:GetText();
	if gText == "" or gText == nil then gText = "0" end;
	local g = tonumber(gText) / 255;
	if g > 1 then
		g = 1;
		HMColorPicker_ValueG:SetText((g*255));
	end
	local bText = HMColorPicker_ValueB:GetText();
	if bText == "" or bText == nil then bText = "0" end;
	local b = tonumber(bText) / 255;
	if b > 1 then
		b = 1;
		HMColorPicker_ValueB:SetText((b*255));
	end

 local offset = tonumber(currentColor);
 local option = self.OptionsList[currentPanel][self:GetOffset()+offset];
 local prefix = "HMOptionLine"..currentColor;
 local swatch = getglobal(prefix.."_ColorSwatchTexture");
 local color = getglobal(prefix.."_Color");
 local savedColor = { };
 
	HMColorPicker:SetColorRGB(r, g, b);
	HMColorSwatch:SetTexture(r, g, b);
 swatch:SetTexture(r, g, b);
 color.r = r;
 color.g = g;
 color.b = b;
 savedColor.r = r;
 savedColor.g = g;
 savedColor.b = b;
 self:SetColor(option.var, savedColor);
 
 HM_ColorPicker_InTextChanged = false;
end


function HitsMode:ColorPickerCopy()
 HM_SavedR, HM_SavedG, HM_SavedB = HMColorPicker:GetColorRGB();
end


function HitsMode:ColorPickerPaste()
	if (HM_SavedR ~= nil and HM_SavedG ~= nil and HM_SavedB ~= nil) then
		HMColorPicker_ValueR:SetText((HM_SavedR*255));
		HMColorPicker_ValueG:SetText((HM_SavedG*255));
		HMColorPicker_ValueB:SetText((HM_SavedB*255));
		self:ColorPickerOnTextChanged();
	end
end


function HitsMode:CancelFunc()
 local offset = tonumber(currentColor);
 local option = self.OptionsList[currentPanel][self:GetOffset()+offset];
 local prefix = "HMOptionLine"..currentColor;
 local swatch = getglobal(prefix.."_ColorSwatchTexture");
 
 swatch:SetTexture(HMColorPicker.previousValues.r, HMColorPicker.previousValues.g, HMColorPicker.previousValues.b);
 self:SetColor(option.var, HMColorPicker.previousValues);
end


function HitsMode:FormatCombatEvent(...)
	 local timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags = select(1, ...);
	 local message = format("%s, %s, %s, %s, %s", eventtype or "nil", srcName or "nil", srcFlags or "nil", dstName or "nil", dstFlags or "nil");
  local pipe = false;
	 for i = 9, select("#", ...) do
	  if pipe == false then
	   pipe = true;
	   message = message.." || ";
	  else
	   message = message..", ";
	  end
		 message = message..(select(i, ...) or "nil");
	 end
	 return message;
end


--
-- The primary event handler for the combat log. This function retrieves the appropriate values from the
-- WoW event and passes them along to various output functions.
--
function HitsMode:HandleCombatEvent(event, ...)
 
 local arg1, arg2 = select(1, ...);
 local _, d, d2, name, spell, damage;
 local HM_COMBATLOG_OBJECT_YOU = bit.bor(COMBATLOG_OBJECT_AFFILIATION_MINE, COMBATLOG_OBJECT_REACTION_FRIENDLY, COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_TYPE_PLAYER);
 local HM_COMBATLOG_OBJECT_PARTYMEMBER = bit.bor(COMBATLOG_OBJECT_AFFILIATION_PARTY, COMBATLOG_OBJECT_REACTION_FRIENDLY, COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_TYPE_PLAYER);
 
 -- COMBAT EVENTS -------------------------------------------------------------------------------------------------------------
 
 if (event == "COMBAT_LOG_EVENT_UNFILTERED") then
  self:DebugWrite(self:FormatCombatEvent(...));
 
  local timestamp, eventType, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags = select(1, ...);
	 local amount, school, resisted, blocked, absorbed, critical, glancing, crushing, missType, environmentalType;
	 local spellId, spellName, spellSchool, powerType, extraAmount, extraSpellId, extraSpellName, extraSpellSchool, auraType;
	 local schoolName, powerName, extraSchoolName, itemId, itemName;
	 if (eventType == nil) then return; end
 	
	 -- DAMAGING EVENTS AND MISSES

	 if (eventType == "SWING_DAMAGE") then
		 amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(9, ...);
		 self:OutputDamage(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing, environmentalType);

	 elseif (eventType == "SWING_MISSED") then
		 missType = select(9, ...);
   self:OutputMiss(eventType, srcName, srcFlags, dstName, dstFlags, missType, spellId, spellName, spellSchool);
   
	 elseif (eventType == "RANGE_DAMAGE") or (eventType == "SPELL_DAMAGE") or (eventType == "SPELL_PERIODIC_DAMAGE") or (eventType == "DAMAGE_SHIELD") or (eventType == "DAMAGE_SPLIT") then
		 spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(9, ...);
		 self:OutputDamage(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing, environmentalType);

	 elseif (eventType == "RANGE_MISSED") or (eventType == "SPELL_MISSED") or (eventType == "SPELL_PERIODIC_MISSED") or (eventType == "DAMAGE_SHIELD_MISSED") then
		 spellId, spellName, spellSchool, missType = select(9, ...);
   self:OutputMiss(eventType, srcName, srcFlags, dstName, dstFlags, missType, spellId, spellName, spellSchool);

	 elseif (eventType == "ENVIRONMENTAL_DAMAGE") then
		 environmentalType, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(9, ...);
			self:OutputDamage(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing, environmentalType);

  -- HEALING EVENTS
  
	 elseif (eventType == "SPELL_HEAL") or (eventType == "SPELL_PERIODIC_HEAL") then
		 spellId, spellName, spellSchool, amount, critical = select(9, ...);
		 self:OutputHeal(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, critical);

  -- DEATH EVENTS
  
	 elseif (eventType == "PARTY_KILL") then
			if (self:IsYou(srcName, srcFlags)) then self:Output("mob_died", srcName, srcFlags, dstName, dstFlags, nil, "KILL", nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
			else self:Output("oth_kill", srcName, srcFlags, dstName, dstFlags, nil, "KILLS", nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
			end

  -- SUMMONING AND CREATING PETS
  
	 elseif (eventType == "SPELL_SUMMON") or (eventType == "SPELL_CREATE") then
		 spellId, spellName, spellSchool = select(9, ...);
		 local verbose;
		 if (eventType == "SPELL_SUMMON") then
				if (self:IsYou(srcName, srcFlags)) then verbose = "SUMMONS"; else verbose = "SUMMONS"; end
			else
				if (self:IsYou(srcName, srcFlags)) then verbose = "CREATE"; else verbose = "CREATES"; end
			end
		 if (self:IsYou(srcName, srcFlags)) then self:Output("you_summon", srcName, srcFlags, dstName, dstFlags, spellName, verbose, nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 elseif (self:IsTarget(srcName, srcFlags)) then self:Output("mob_summon", srcName, srcFlags, dstName, dstFlags, spellName, verbose, nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 else self:Output("oth_summon", srcName, srcFlags, dstName, dstFlags, spellName, verbose, nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 end

  -- GAINS, DRAINS, LEECHES, EXTRA ATTACKS
  
	 elseif (eventType == "SPELL_ENERGIZE") or (eventType == "SPELL_PERIODIC_ENERGIZE") then
		 spellId, spellName, spellSchool, amount, powerType = select(9, ...);
			self:OutputEnergize(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, powerType);

	 elseif (eventType == "SPELL_DRAIN") or (eventType == "SPELL_PERIODIC_DRAIN") then
		 spellId, spellName, spellSchool, amount, powerType, extraAmount = select(9, ...);
		 self:OutputDrain(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, powerType, extraAmount);

	 elseif (eventType == "SPELL_LEECH") or (eventType == "SPELL_PERIODIC_LEECH") then
		 -- could be Dark Pact moving mana from an imp to its warlock
		 -- it seems that amount is the gain for the source and extraAmount is the loss for the dest
		 spellId, spellName, spellSchool, amount, powerType, extraAmount = select(9, ...);
			self:OutputEnergize(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, powerType);

	 elseif (eventType == "SPELL_EXTRA_ATTACKS") then
		 spellId, spellName, spellSchool, amount = select(9, ...);
		 self:OutputExtraAttacks(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount);

  -- BUFFS AND DEBUFFS
  
	 elseif (eventType == "SPELL_AURA_APPLIED") then
		 -- source arguments are nil
		 spellId, spellName, spellSchool, auraType = select(9, ...);
		 if (auraType == "BUFF") then
				if (self:IsYou(dstName, dstFlags)) then self:Output("you_gain", srcName, srcFlags, dstName, dstFlags, spellName, "GAIN", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
				elseif (self:IsPet(dstName, dstFlags)) then self:Output("pet_gains", srcName, srcFlags, dstName, dstFlags, spellName, "GAINS", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
				elseif (self:IsTarget(dstName, dstFlags)) then self:Output("mob_gains", srcName, srcFlags, dstName, dstFlags, spellName, "GAINS", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
				else self:Output("oth_gain", srcName, srcFlags, dstName, dstFlags, spellName, "GAINS", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
				end
			else
				if (self:IsYou(dstName, dstFlags)) then self:Output("you_gain", srcName, srcFlags, dstName, dstFlags, spellName, "AREAFFLICTED", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
				elseif (self:IsPet(dstName, dstFlags)) then self:Output("pet_gains", srcName, srcFlags, dstName, dstFlags, spellName, "ISAFFLICTED", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
				elseif (self:IsTarget(dstName, dstFlags)) then self:Output("mob_gains", srcName, srcFlags, dstName, dstFlags, spellName, "ISAFFLICTED", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
				else self:Output("oth_gain", srcName, srcFlags, dstName, dstFlags, spellName, "ISAFFLICTED", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
				end
			end

	 elseif (eventType == "SPELL_AURA_APPLIED_DOSE") then
		 -- source arguments are nil
		 -- for example Sunder Armor, a stacking debuff
		 spellId, spellName, spellSchool, auraType, amount = select(9, ...);
		 if (self:IsYou(dstName, dstFlags)) then self:Output("you_gain", srcName, srcFlags, dstName, dstFlags, spellName, "GAIN", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 elseif (self:IsPet(dstName, dstFlags)) then self:Output("pet_gains", srcName, srcFlags, dstName, dstFlags, spellName, "GAINS", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 elseif (self:IsTarget(dstName, dstFlags)) then self:Output("mob_gains", srcName, srcFlags, dstName, dstFlags, spellName, "GAINS", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 else self:Output("oth_gain", srcName, srcFlags, dstName, dstFlags, spellName, "GAINS", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 end

	 elseif (eventType == "SPELL_AURA_REMOVED") then
		 -- source arguments are nil
		 spellId, spellName, spellSchool, auraType = select(9, ...);
		 if (self:IsYou(dstName, dstFlags)) then self:Output("you_debuff", srcName, srcFlags, dstName, dstFlags, spellName, "FADES", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 elseif (self:IsPet(dstName, dstFlags)) then self:Output("pet_debuff", srcName, srcFlags, dstName, dstFlags, spellName, "FADES", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 elseif (self:IsTarget(dstName, dstFlags)) then self:Output("mob_debuff", srcName, srcFlags, dstName, dstFlags, spellName, "FADES", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 else self:Output("oth_debuff", srcName, srcFlags, dstName, dstFlags, spellName, "FADES", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 end

	 elseif (eventType == "SPELL_AURA_REMOVED_DOSE") then
		 -- source arguments are nil
		 -- spellId, spellName, spellSchool, auraType, amount = select(9, ...);
		 -- I think this is where a stacked buff or debuff loses some but not all of its stacking
		 if (self:IsYou(dstName, dstFlags)) then self:Output("you_debuff", srcName, srcFlags, dstName, dstFlags, spellName, "FADES", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 elseif (self:IsPet(dstName, dstFlags)) then self:Output("pet_debuff", srcName, srcFlags, dstName, dstFlags, spellName, "FADES", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 elseif (self:IsTarget(dstName, dstFlags)) then self:Output("mob_debuff", srcName, srcFlags, dstName, dstFlags, spellName, "FADES", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 else self:Output("oth_debuff", srcName, srcFlags, dstName, dstFlags, spellName, "FADES", nil, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		 end

	 elseif (eventType == "SPELL_AURA_DISPELLED") then
		 -- the first spell is the one causing the aura to be dispelled or otherwise cancelled, and the *extra* is the name of the aura that is being dispelled
		 spellId, spellName, spellSchool, extraSpellId, extraSpellName, extraSpellSchool, auraType = select(9, ...);
		 if (self:IsYou(srcName, srcFlags)) then self:Output("you_dispel", srcName, srcFlags, dstName, dstFlags, extraSpellName, "DISPEL", nil, nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
		 elseif (self:IsPet(srcName, srcFlags)) then self:Output("pet_dispel", srcName, srcFlags, dstName, dstFlags, extraSpellName, "DISPELS", nil, nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
		 elseif (self:IsTarget(srcName, srcFlags)) then self:Output("mob_dispel", srcName, srcFlags, dstName, dstFlags, extraSpellName, "DISPELS", nil, nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
		 else self:Output("oth_dispel", srcName, srcFlags, dstName, dstFlags, extraSpellName, "DISPELS", nil, nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
		 end

	 elseif (eventType == "SPELL_AURA_STOLEN") then
		 spellId, spellName, spellSchool, extraSpellId, extraSpellName, extraSpellSchool, auraType = select(9, ...);
		 if (self:IsYou(srcName, srcFlags)) then self:Output("you_dispel", srcName, srcFlags, dstName, dstFlags, extraSpellName, "STEAL", nil, nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
		 elseif (self:IsPet(srcName, srcFlags)) then self:Output("pet_dispel", srcName, srcFlags, dstName, dstFlags, extraSpellName, "STEALS", nil, nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
		 elseif (self:IsTarget(srcName, srcFlags)) then self:Output("mob_dispel", srcName, srcFlags, dstName, dstFlags, extraSpellName, "STEALS", nil, nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
		 else self:Output("oth_dispel", srcName, srcFlags, dstName, dstFlags, extraSpellName, "STEALS", nil, nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
		 end

  -- INTERRUPTING
  
	 elseif (eventType == "SPELL_INTERRUPT") then
		 -- spellName does the interrupting, extraSpellName is what gets interrupted
		 spellId, spellName, spellSchool, extraSpellId, extraSpellName, extraSpellSchool = select(9, ...);
			if (self:IsYou(srcName, srcFlags)) then self:Output("you_inter", srcName, srcFlags, dstName, dstFlags, extraSpellName, "INTERRUPT", nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
			elseif (self:IsTarget(dstName, dstFlags)) then self:Output("mob_inter", srcName, srcFlags, dstName, dstFlags, extraSpellName, "INTERRUPTS", nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
			else self:Output("oth_inter", srcName, srcFlags, dstName, dstFlags, extraSpellName, "INTERRUPTS", nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
			end
  
  -- ENCHANT EVENTS
  		
	 elseif (eventType == "ENCHANT_APPLIED") then
		 spellName, itemId, itemName = select(9, ...);
		 if (self:IsYou(srcName, srcFlags)) then self:Output("you_ench", srcName, srcFlags, dstName, dstFlags, spellName, "APPLYENCHANTMENTON", self:GetItemLink(itemId), nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
		 end
 		
	 elseif (eventType == "ENCHANT_REMOVED") then
		 spellName, itemId, itemName = select(9, ...);
		 if (self:IsYou(srcName, srcFlags)) then self:Output("you_ench", srcName, srcFlags, dstName, dstFlags, spellName, "REMOVEENCHANTMENTFROM", self:GetItemLink(itemId), nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
		 end

  -- SPAM EVENTS
  
	 elseif (eventType == "SPELL_CAST_START") then
	  spellId, spellName, spellSchool = select(9, ...);
			if (self:IsYou(srcName, srcFlags)) then self:Output("spam_spellstart", srcName, srcFlags, dstName, dstFlags, spellName, "STARTCASTING", nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			else self:Output("spam_spellstart", srcName, srcFlags, dstName, dstFlags, spellName, "STARTSCASTING", nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			end

	 elseif (eventType == "SPELL_CAST_SUCCESS") then
		 spellId, spellName, spellSchool = select(9, ...);
		 srcName, dstName = self:Flip(srcName, dstName);
		 srcFlags, dstFlags = self:Flip(srcFlags, dstFlags);
			if (self:IsYou(dstName, dstFlags)) then self:Output("spam_spellsuccess", srcName, srcFlags, dstName, dstFlags, spellName, "FINISHCASTING", nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			else self:Output("spam_spellsuccess", srcName, srcFlags, dstName, dstFlags, spellName, "FINISHESCASTING", nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			end

	 elseif (eventType == "SPELL_CAST_FAILED") then
	  spellId, spellName, spellSchool, missType = select(9, ...);
			if (self:IsYou(srcName, srcFlags)) then self:Output("spam_spellfailed", srcName, srcFlags, dstName, dstFlags, spellName, "FAILTOCAST", nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			else self:Output("spam_spellfailed", srcName, srcFlags, dstName, dstFlags, spellName, "FAILSTOCAST", nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			end
 		
	 elseif (eventType == "SPELL_DISPEL_FAILED") then
	  spellId, spellName, spellSchool, extraSpellId, extraSpellName, extraSpellSchool = select(9, ...);
			if (self:IsYou(srcName, srcFlags)) then self:Output("spam_dispelfailed", srcName, srcFlags, dstName, dstFlags, extraSpellName, "FAILTODISPEL", nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
			else self:Output("spam_dispelfailed", srcName, srcFlags, dstName, dstFlags, extraSpellName, "FAILSTODISPEL", nil, extraSpellSchool, nil, nil, nil, nil, nil, nil, extraSpellId, nil, nil);
			end

	 elseif (eventType == "SPELL_DURABILITY_DAMAGE") or (eventType == "SPELL_DURABILITY_DAMAGE_ALL") then
		 spellId, spellName, spellSchool = select(9, ...);
			if (self:IsYou(srcName, srcFlags)) then self:Output("spam_durability", srcName, srcFlags, dstName, dstFlags, spellName, "LOSEDURABILITY", nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			else self:Output("spam_durability", srcName, srcFlags, dstName, dstFlags, spellName, "LOSESDURABILITY", nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			end

	 elseif (eventType == "SPELL_INSTAKILL") then
		 spellId, spellName, spellSchool = select(9, ...);
			if (self:IsYou(srcName, srcFlags)) then self:Output("spam_instantkill", srcName, srcFlags, dstName, dstFlags, spellName, "INSTANTLYKILL", nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			else self:Output("spam_instantkill", srcName, srcFlags, dstName, dstFlags, spellName, "INSTANTLYKILLS", nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			end

	 elseif (eventType == "UNIT_DIED") then
			self:Output("spam_unitdied", srcName, srcFlags, dstName, dstFlags, nil, "DIES", nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
			
	 elseif (eventType == "UNIT_DESTROYED") then
	  -- for example, summoned elemental ending its allotted life
			self:Output("spam_unitdestroyed", srcName, srcFlags, dstName, dstFlags, nil, "ISDESTROYED", nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);

  -- UNKNOWN EVENT
  
  else
  
  end
  
  
 -- COMBAT STARTED ------------------------------------------------------------------------------------------------------------
 
 elseif (event == "PLAYER_REGEN_DISABLED") then
  inCombat = 1;
  damageTaken = 0;
  damageGiven = 0;
  healsTaken = 0;
  healsGiven = 0;
  damageResisted = 0;
  petDamageGiven = 0;
  petDamageTaken = 0;
		petHealsTaken = 0;
		petHealsGiven = 0;
  manaGained = 0;
  energyGained = 0;
  rageGained = 0;
  attacksGained = 0;
  skillsIncreased = 0;
  expGained = 0;
  combatStartTime = GetTime();
  announced = false;
 
 
 -- COMBAT ENDED --------------------------------------------------------------------------------------------------------------
 
 elseif (event == "PLAYER_REGEN_ENABLED") then
  self:SummarizeCombat();
  inCombat = 0;
  damageTaken = 0;
  damageGiven = 0;
  healsTaken = 0;
  healsGiven = 0;
  damageResisted = 0;
  petDamageGiven = 0;
  petDamageTaken = 0;
		petHealsTaken = 0;
		petHealsGiven = 0;
  manaGained = 0;
  energyGained = 0;
  rageGained = 0;
  attacksGained = 0;
  skillsIncreased = 0;
  expGained = 0;
  
  
 -- REPUTATION ----------------------------------------------------------------------------------------------------------------
 elseif (event == "CHAT_MSG_COMBAT_FACTION_CHANGE") then
 
  for spell, damage in string.gmatch(arg1, self.ChatPatterns[1]) do -- Reputation with (.+) increased by (%d+).
			if (self:Get("flagexp") == 1) then damage = "+"..damage; end
			self:Output("you_gain_rep", UnitName("player"), HM_COMBATLOG_OBJECT_YOU, nil, nil, nil, "GAINREP", spell.." "..damage, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, HM_EXPTYPE_REPUTATION);
   return;
  end
  for spell, damage in string.gmatch(arg1, self.ChatPatterns[2]) do -- Reputation with (.+) decreased by (%d+).
			if (self:Get("flagexp") == 1) then damage = "-"..damage; end
			self:Output("you_gain_rep", UnitName("player"), HM_COMBATLOG_OBJECT_YOU, nil, nil, nil, "LOSEREP", spell.." "..damage, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, HM_EXPTYPE_REPUTATION);
   return;
  end
  

 -- LOOT ----------------------------------------------------------------------------------------------------------------------

 elseif (event == "CHAT_MSG_LOOT" or event == "CHAT_MSG_MONEY") then
 
		self:DebugWrite(string.format("Parser received loot event: %s", event));
 
  for spell in string.gmatch(arg1, self.ChatPatterns[4]) do -- You receive loot: (.+).
			self:Output("you_loot", UnitName("player"), HM_COMBATLOG_OBJECT_YOU, nil, nil, nil, "PLAYERLOOT", spell, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
   return;
  end
  for spell in string.gmatch(arg1, self.ChatPatterns[12]) do -- You loot (.+)
			self:Output("you_loot", UnitName("player"), HM_COMBATLOG_OBJECT_YOU, nil, nil, nil, "PLAYERLOOT", spell, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
   return;
  end
  for spell in string.gmatch(arg1, self.ChatPatterns[5]) do -- Your share of the loot is (.+).
			self:Output("you_loot", UnitName("player"), HM_COMBATLOG_OBJECT_YOU, nil, nil, nil, "PLAYERLOOT", spell, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
   return;
  end
  for name, spell in string.gmatch(arg1, self.ChatPatterns[6]) do -- (.+) receives loot: (.+).
			self:Output("they_loot", name, HM_COMBATLOG_OBJECT_PARTYMEMBER, nil, nil, nil, "PLAYERLOOTS", spell, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
   return;
  end
  for spell in string.gmatch(arg1, self.ChatPatterns[3]) do -- You create: (.+).
			self:Output("you_craft", UnitName("player"), HM_COMBATLOG_OBJECT_YOU, nil, nil, nil, "PLAYERCRAFT", spell, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
   return;
  end
 
 
 -- SKILL ---------------------------------------------------------------------------------------------------------------------

 elseif (event == "CHAT_MSG_SKILL") then

  for spell, damage in string.gmatch(arg1, self.ChatPatterns[7]) do -- Your skill in (.+) has increased to ([%d]+)
			self:Output("skill_up", UnitName("player"), HM_COMBATLOG_OBJECT_YOU, nil, nil, spell, "SKILLHASINCREASEDTO", damage, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);
   skillsIncreased = self:Add(skillsIncreased, 1);
   return;
  end
 

 -- HONOR ---------------------------------------------------------------------------------------------------------------------

 elseif (event == "CHAT_MSG_COMBAT_HONOR_GAIN") then

  for spell in string.gmatch(arg1, self.ChatPatterns[8]) do -- ([%d]+)
			if (self:Get("flagexp") == 1) then spell = "+"..spell; end
			self:Output("you_gain_honor", UnitName("player"), HM_COMBATLOG_OBJECT_YOU, nil, nil, nil, "HONOR", spell, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, HM_EXPTYPE_HONOR);
   return;
  end
  for spell in string.gmatch(arg1, self.ChatPatterns[9]) do -- You have been awarded ([%d]+) honor.
			if (self:Get("flagexp") == 1) then spell = "+"..spell; end
			self:Output("you_gain_honor", UnitName("player"), HM_COMBATLOG_OBJECT_YOU, nil, nil, nil, "HONOR", spell, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, HM_EXPTYPE_HONOR);
   return;
  end


 -- EXPERIENCE ----------------------------------------------------------------------------------------------------------------

 elseif (event == "CHAT_MSG_COMBAT_XP_GAIN") then
  _, _, d = string.find(arg1, self.ChatPatterns[10]); -- .* gain (%d+).*
  _, _, d2 = string.find(arg1, self.ChatPatterns[11]); -- experience%. %(%+(%d+) exp Rested bonus
  expGained = self:Add(expGained, d);
  if (d2 ~= nil and self:Get("showrested") == 1) then d = d.." (+"..d2..")"; end
  if (self:Get("flagexp") == 1) then d = "+"..d; end
		self:Output("exp", UnitName("player"), HM_COMBATLOG_OBJECT_YOU, nil, nil, nil, "XP", d, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, HM_EXPTYPE_EXPERIENCE);


 ------------------------------------------------------------------------------------------------------------------------------

	end
	
end


----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

--
-- All damage done is routed through this handler.
--
function HitsMode:OutputDamage(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing, environmentalType)
 
	self:DebugWrite(string.format(GRN.."self:OutputDamage received eventType: %s || src: %s || dst: %s || amount: %s|r", eventType or "nil", srcName or "nil", dstName or "nil", amount or "nil"));
	if (amount == nil) then return; end
	
	local hitsfor, afflicts;
	if (self:IsCrit(critical)) then
		hitsfor = "CRITSFOR";
		afflicts = "CRITSFOR";
	else
		hitsfor = "HITSFOR";
		afflicts = "AFFLICTS";
	end

 -- ACTIONS TAKEN BY YOU -----------------------
 if (self:IsYou(srcName, srcFlags)) then
 
		damageGiven = self:Add(damageGiven, amount);
		
		if (eventType == "SWING_DAMAGE" or eventType == "RANGE_DAMAGE" or eventType == "DAMAGE_SHIELD" or eventType == "DAMAGE_SPLIT") then
			self:Output("you_melee", srcName, srcFlags, dstName, dstFlags, spellName, hitsfor, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			
		elseif (eventType == "SPELL_DAMAGE") then
			self:Output("you_nuke", srcName, srcFlags, dstName, dstFlags, spellName, hitsfor, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
		
		elseif (eventType == "SPELL_PERIODIC_DAMAGE") then
			self:Output("you_dot", srcName, srcFlags, dstName, dstFlags, spellName, afflicts, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
					
		end
		 
 -- ACTIONS TAKEN BY YOUR PET ------------------
 elseif (self:IsPet(srcName, srcFlags)) then
 
		petDamageGiven = self:Add(petDamageGiven, amount);
		
		if (eventType == "SWING_DAMAGE" or eventType == "RANGE_DAMAGE" or eventType == "DAMAGE_SHIELD" or eventType == "DAMAGE_SPLIT") then
			self:Output("pet_melee", srcName, srcFlags, dstName, dstFlags, spellName, hitsfor, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);

		elseif (eventType == "SPELL_DAMAGE") then
			self:Output("pet_nuke", srcName, srcFlags, dstName, dstFlags, spellName, hitsfor, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
		
		elseif (eventType == "SPELL_PERIODIC_DAMAGE") then
			self:Output("pet_dot", srcName, srcFlags, dstName, dstFlags, spellName, afflicts, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);

		end
		
 -- ATTACKER VERSUS YOU ------------------------
 elseif (self:IsYou(dstName, dstFlags)) then

		damageTaken = self:Add(damageTaken, amount);
		
		if (eventType == "SWING_DAMAGE" or eventType == "RANGE_DAMAGE" or eventType == "DAMAGE_SHIELD" or eventType == "DAMAGE_SPLIT") then
			self:Output("mob_melee", srcName, srcFlags, dstName, dstFlags, spellName, hitsfor, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);

		elseif (eventType == "SPELL_DAMAGE") then
			self:Output("mob_nuke", srcName, srcFlags, dstName, dstFlags, spellName, hitsfor, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
		
		elseif (eventType == "SPELL_PERIODIC_DAMAGE") then
			self:Output("mob_dot", srcName, srcFlags, dstName, dstFlags, spellName, afflicts, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);

		elseif (eventType == "ENVIRONMENTAL_DAMAGE") then
			if (environmentalType == "DROWNING") then self:Output("you_fall", srcName, srcFlags, dstName, dstFlags, spellName, "DROWNFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			elseif (environmentalType == "FALLING") then self:Output("you_fall", srcName, srcFlags, dstName, dstFlags, spellName, "FALLFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			elseif (environmentalType == "FATIGUE") then self:Output("you_fall", srcName, srcFlags, dstName, dstFlags, spellName, "AREFATIGUEDFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			elseif (environmentalType == "FIRE") then self:Output("you_fall", srcName, srcFlags, dstName, dstFlags, spellName, "BURNFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			elseif (environmentalType == "LAVA") then self:Output("you_fall", srcName, srcFlags, dstName, dstFlags, spellName, "BURNFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			elseif (environmentalType == "SLIME") then self:Output("you_fall", srcName, srcFlags, dstName, dstFlags, spellName, "ARESLIMEDFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			end

		end
		
 -- ATTACKER VERSUS YOUR PET -------------------
 elseif (self:IsPet(dstName, dstFlags)) then
 
		petDamageTaken = self:Add(petDamageTaken, amount);
		
		if (eventType == "SWING_DAMAGE" or eventType == "RANGE_DAMAGE" or eventType == "DAMAGE_SHIELD" or eventType == "DAMAGE_SPLIT") then
			self:Output("vspet_melee", srcName, srcFlags, dstName, dstFlags, spellName, hitsfor, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);

		elseif (eventType == "SPELL_DAMAGE") then
			self:Output("vspet_nuke", srcName, srcFlags, dstName, dstFlags, spellName, hitsfor, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
		
		elseif (eventType == "SPELL_PERIODIC_DAMAGE") then
			self:Output("vspet_dot", srcName, srcFlags, dstName, dstFlags, spellName, afflicts, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);

		end

 -- OTHERS VERSUS OTHERS -----------------------
	else

		if (eventType == "SWING_DAMAGE" or eventType == "RANGE_DAMAGE" or eventType == "DAMAGE_SHIELD" or eventType == "DAMAGE_SPLIT") then
			self:Output("oth_melee", srcName, srcFlags, dstName, dstFlags, spellName, hitsfor, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);

		elseif (eventType == "SPELL_DAMAGE") then
			self:Output("oth_nuke", srcName, srcFlags, dstName, dstFlags, spellName, hitsfor, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
		
		elseif (eventType == "SPELL_PERIODIC_DAMAGE") then
			self:Output("oth_dot", srcName, srcFlags, dstName, dstFlags, spellName, afflicts, self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);

		elseif (eventType == "ENVIRONMENTAL_DAMAGE") then
			if (environmentalType == "DROWNING") then self:Output("oth_fall", srcName, srcFlags, dstName, dstFlags, spellName, "DROWNSFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			elseif (environmentalType == "FALLING") then self:Output("oth_fall", srcName, srcFlags, dstName, dstFlags, spellName, "FALLSFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			elseif (environmentalType == "FATIGUE") then self:Output("oth_fall", srcName, srcFlags, dstName, dstFlags, spellName, "ISFATIGUEDFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			elseif (environmentalType == "FIRE") then self:Output("oth_fall", srcName, srcFlags, dstName, dstFlags, spellName, "BURNSFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			elseif (environmentalType == "LAVA") then self:Output("oth_fall", srcName, srcFlags, dstName, dstFlags, spellName, "BURNSFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			elseif (environmentalType == "SLIME") then self:Output("oth_fall", srcName, srcFlags, dstName, dstFlags, spellName, "ISSLIMEDFOR", self:Damage(amount, critical), self:IsCrit(critical), spellSchool, resisted, blocked, absorbed, crushing, glancing, nil, spellId, nil, nil);
			end

		end
		
 end
end


--
-- All misses are routed through this handler.
--
function HitsMode:OutputMiss(eventtype, srcName, srcFlags, dstName, dstFlags, missType, spellId, spellName, spellSchool)
 
	self:DebugWrite(string.format(GRN.."self:OutputMiss received eventType: %s || src: %s || dst: %s || missType: %s || spellName: %s|r", eventType or "nil", srcName or "nil", dstName or "nil", missType or "nil", spellName or "nil"));
	if (missType == nil) then return; end

 -- ACTIONS TAKEN BY YOU -----------------------
 if (self:IsYou(srcName, srcFlags)) then

		if (missType == "MISS") then self:Output("you_miss", srcName, srcFlags, dstName, dstFlags, spellName, "MISS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "DODGE") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "DODGES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "ABSORB") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "ABSORBS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "RESIST") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "RESISTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "PARRY") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "PARRIES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "BLOCK") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "BLOCKS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "REFLECT") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "REFLECTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "DEFLECT") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "DEFLECTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "IMMUNE") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "ISIMMUNE", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "EVADE") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "EVADES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		end
		 
 -- ACTIONS TAKEN BY YOUR PET ------------------
 elseif (self:IsPet(srcName, srcFlags)) then
 
		if (missType == "MISS") then self:Output("pet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "MISSES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "DODGE") then self:Output("vspet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "DODGES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "ABSORB") then self:Output("vspet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "ABSORBS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "RESIST") then self:Output("vspet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "RESISTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "PARRY") then self:Output("vspet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "PARRIES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "BLOCK") then self:Output("vspet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "BLOCKS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "REFLECT") then self:Output("vspet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "REFLECTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "DEFLECT") then self:Output("vspet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "DEFLECTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "IMMUNE") then self:Output("vspet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "ISIMMUNE", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "EVADE") then self:Output("vspet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "EVADES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		end
		
 -- ATTACKER VERSUS YOU ------------------------
 elseif (self:IsYou(dstName, dstFlags)) then

		if (missType == "MISS") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "MISSES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "DODGE") then self:Output("you_miss", srcName, srcFlags, dstName, dstFlags, spellName, "DODGE", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "ABSORB") then self:Output("you_miss", srcName, srcFlags, dstName, dstFlags, spellName, "ABSORB", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "RESIST") then self:Output("you_miss", srcName, srcFlags, dstName, dstFlags, spellName, "RESIST", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "PARRY") then self:Output("you_miss", srcName, srcFlags, dstName, dstFlags, spellName, "PARRY", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "BLOCK") then self:Output("you_miss", srcName, srcFlags, dstName, dstFlags, spellName, "BLOCK", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "REFLECT") then self:Output("you_miss", srcName, srcFlags, dstName, dstFlags, spellName, "REFLECT", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "DEFLECT") then self:Output("you_miss", srcName, srcFlags, dstName, dstFlags, spellName, "DEFLECT", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "IMMUNE") then self:Output("you_miss", srcName, srcFlags, dstName, dstFlags, spellName, "AREIMMUNE", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "EVADE") then self:Output("you_miss", srcName, srcFlags, dstName, dstFlags, spellName, "EVADE", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		end
		
 -- ATTACKER VERSUS YOUR PET -------------------
 elseif (self:IsPet(dstName, dstFlags)) then
 
		if (missType == "MISS") then self:Output("mob_miss", srcName, srcFlags, dstName, dstFlags, spellName, "MISSES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "DODGE") then self:Output("pet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "DODGES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "ABSORB") then self:Output("pet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "ABSORBS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "RESIST") then self:Output("pet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "RESISTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "PARRY") then self:Output("pet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "PARRIES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "BLOCK") then self:Output("pet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "BLOCKS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "REFLECT") then self:Output("pet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "REFLECTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "DEFLECT") then self:Output("pet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "DEFLECTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "IMMUNE") then self:Output("pet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "ISIMMUNE", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "EVADE") then self:Output("pet_miss", srcName, srcFlags, dstName, dstFlags, spellName, "EVADES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		end

 -- OTHERS VERSUS OTHERS -----------------------
	else

		if (missType == "MISS") then self:Output("oth_miss", srcName, srcFlags, dstName, dstFlags, spellName, "MISSES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "DODGE") then self:Output("oth_miss", srcName, srcFlags, dstName, dstFlags, spellName, "DODGES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "ABSORB") then self:Output("oth_miss", srcName, srcFlags, dstName, dstFlags, spellName, "ABSORBS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "RESIST") then self:Output("oth_miss", srcName, srcFlags, dstName, dstFlags, spellName, "RESISTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "PARRY") then self:Output("oth_miss", srcName, srcFlags, dstName, dstFlags, spellName, "PARRIES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "BLOCK") then self:Output("oth_miss", srcName, srcFlags, dstName, dstFlags, spellName, "BLOCKS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "REFLECT") then self:Output("oth_miss", srcName, srcFlags, dstName, dstFlags, spellName, "REFLECTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "DEFLECT") then self:Output("oth_miss", srcName, srcFlags, dstName, dstFlags, spellName, "DEFLECTS", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "IMMUNE") then self:Output("oth_miss", srcName, srcFlags, dstName, dstFlags, spellName, "ISIMMUNE", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		elseif (missType == "EVADE") then self:Output("oth_miss", srcName, srcFlags, dstName, dstFlags, spellName, "EVADES", nil, false, spellSchool, nil, nil, nil, nil, nil, missType, spellId, nil, nil);
		end
		
 end
end


--
-- All heals are routed through this handler.
--
function HitsMode:OutputHeal(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, critical)
 
	self:DebugWrite(string.format(RED.."self:OutputHeal received eventType: %s || src: %s || dst: %s || spellName: %s || amount: %s || crit: %s|r", eventType or "nil", srcName or "nil", dstName or "nil", spellName or "nil", amount or "nil", critical or "nil"));
	if (amount == nil) then return; end

 -- YOU HEAL OTHERS ----------------------------
 if (self:IsYou(srcName, srcFlags) and self:IsYou(dstName, dstFlags) == false and self:IsPet(dstName, dstFlags) == false) then

		healsGiven = self:Add(healsGiven, amount);

		if (eventType == "SPELL_HEAL") then self:Output("you_heal", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		elseif (eventType == "SPELL_PERIODIC_HEAL") then self:Output("you_hot_others", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		end

 -- YOU HEAL YOURSELF --------------------------
 elseif (self:IsYou(srcName, srcFlags) and self:IsYou(dstName, dstFlags)) then

		-- This qualifies as both a heal given and received
		healsGiven = self:Add(healsGiven, amount);
		healsTaken = self:Add(healsTaken, amount);
		
		-- Fire two events here in case heals given and heals received are being routed to different windows, they can see events in both windows
		if (eventType == "SPELL_HEAL") then
			self:Output("you_heal", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			self:Output("you_heal_yourself", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		elseif (eventType == "SPELL_PERIODIC_HEAL") then
			self:Output("you_hot_others", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			self:Output("you_hot_yourself", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		end
		 
 -- YOU HEAL YOUR PET --------------------------
 elseif (self:IsYou(srcName, srcFlags) and self:IsPet(dstName, dstFlags)) then

		-- This qualifies as both a heal given and received
		healsGiven = self:Add(healsGiven, amount);
		petHealsTaken = self:Add(petHealsTaken, amount);

		-- Fire two events here in case heals given and heals received are being routed to different windows, they can see events in both windows
		if (eventType == "SPELL_HEAL") then
			self:Output("you_heal", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			self:Output("you_heal_pet", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		elseif (eventType == "SPELL_PERIODIC_HEAL") then
			self:Output("you_hot_others", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
			self:Output("you_hot_pet", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		end

 -- SOMEONE ELSE HEALS YOU ---------------------
 elseif (self:IsYou(dstName, dstFlags)) then

		healsTaken = self:Add(healsTaken, amount);

		if (eventType == "SPELL_HEAL") then self:Output("others_heal_you", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		elseif (eventType == "SPELL_PERIODIC_HEAL") then self:Output("others_hot_you", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		end
		
 -- SOMEONE ELSE HEALS YOUR PET ----------------
 elseif (self:IsPet(dstName, dstFlags)) then

		petHealsTaken = self:Add(petHealsTaken, amount);

		if (eventType == "SPELL_HEAL") then self:Output("others_heal_pet", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		elseif (eventType == "SPELL_PERIODIC_HEAL") then self:Output("others_hot_pet", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		end
		
 -- YOUR PET HEALS SOMEONE ---------------------
 elseif (self:IsPet(srcName, srcFlags)) then

		healsGiven = self:Add(healsGiven, amount);

		if (eventType == "SPELL_HEAL") then self:Output("you_heal", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		elseif (eventType == "SPELL_PERIODIC_HEAL") then self:Output("you_hot_others", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		end
		
 -- YOUR TARGET HEALS ITSELF -------------------
 elseif (self:IsTarget(srcName, srcFlags) and self:IsTarget(dstName, dstFlags)) then
 
		if (eventType == "SPELL_HEAL") then self:Output("mob_heal_itself", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		elseif (eventType == "SPELL_PERIODIC_HEAL") then self:Output("mob_hot_itself", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		end
		
 -- SOMEONE ELSE HEALS SOMEONE ELSE ------------
	else

		if (eventType == "SPELL_HEAL") then self:Output("oth_heal_oth", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		elseif (eventType == "SPELL_PERIODIC_HEAL") then self:Output("oth_hot_oth", srcName, srcFlags, dstName, dstFlags, spellName, "HEALSFOR", amount, self:IsCrit(critical), spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
		end
		
 end
end


--
-- All energizes are routed through this handler.
--
function HitsMode:OutputEnergize(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, powerType)
 
	self:DebugWrite(string.format(YEL.."self:OutputEnergize received eventType: %s || src: %s || dst: %s || powerType: %s || spellName: %s|r", eventType or "nil", srcName or "nil", dstName or "nil", powerType or "nil", spellName or "nil"));
	if (powerType == nil) then return; end
	
	-- Reroute health gains to the heal handler (hopefully this works)
	if (powerType == -2) then
		self:OutputHeal("SPELL_PERIODIC_HEAL", srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, nil);
		return;
	end
	
 -- YOU ARE ENERGIZED --------------------------
 if (self:IsYou(dstName, dstFlags)) then
 
		-- Accumulate DPS. We don't track focus or pet happiness.
		if (powerType == 0) then manaGained = self:Add(manaGained, amount);
		elseif (powerType == 1) then rageGained = self:Add(rageGained, amount);
		elseif (powerType == 3) then energyGained = self:Add(energyGained, amount);
		end
		
		if (powerType == 0) then self:Output("you_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINMANA", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 1) then self:Output("you_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINRAGE", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 2) then self:Output("you_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINFOCUS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 3) then self:Output("you_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINENERGY", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		end
		 
 -- YOUR PET IS ENERGIZED ----------------------
 elseif (self:IsPet(dstName, dstFlags)) then
 
		if (powerType == 0) then self:Output("pet_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSMANA", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 1) then self:Output("pet_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSRAGE", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 2) then self:Output("pet_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSFOCUS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 3) then self:Output("pet_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSENERGY", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 4) then self:Output("pet_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSHAPPINESS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		end
		
 -- YOUR TARGET IS ENERGIZED -------------------
 elseif (self:IsTarget(dstName, dstFlags)) then

		if (powerType == 0) then self:Output("mob_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSMANA", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 1) then self:Output("mob_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSRAGE", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 2) then self:Output("mob_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSFOCUS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 3) then self:Output("mob_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSENERGY", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		end
		
 -- SOMEONE ELSE IS ENERGIZED ------------------
	else

		if (powerType == 0) then self:Output("oth_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSMANA", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 1) then self:Output("oth_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSRAGE", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 2) then self:Output("oth_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSFOCUS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 3) then self:Output("oth_energize", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSENERGY", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		end
		
 end
end


--
-- All drains are routed through this handler.
--
function HitsMode:OutputDrain(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount, powerType, extraAmount)
	
	self:DebugWrite(string.format(YEL.."self:OutputDrain received eventType: %s || src: %s || dst: %s || powerType: %s || spellName: %s|r", eventType or "nil", srcName or "nil", dstName or "nil", powerType or "nil", spellName or "nil"));
	if (powerType == nil) then return; end
	
 -- ACTIONS TAKEN BY YOU -----------------------
 if (self:IsYou(srcName, srcFlags)) then
 
		if (powerType == -2) then damageGiven = self:Add(damageGiven, amount); end

		if (powerType == 0) then self:Output("you_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSMANA", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 1) then self:Output("you_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSRAGE", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 2) then self:Output("you_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSFOCUS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 3) then self:Output("you_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSENERGY", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == -2) then self:Output("you_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSHEALTH", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		end
		 
 -- ACTIONS TAKEN BY YOUR PET ------------------
 elseif (self:IsPet(srcName, srcFlags)) then
 
		if (powerType == -2) then petDamageGiven = self:Add(petDamageGiven, amount); end

		if (powerType == 0) then self:Output("pet_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSMANA", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 1) then self:Output("pet_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSRAGE", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 2) then self:Output("pet_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSFOCUS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 3) then self:Output("pet_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSENERGY", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == -2) then self:Output("pet_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSHEALTH", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		end
		
 -- ATTACKER VERSUS YOU ------------------------
 elseif (self:IsYou(dstName, dstFlags)) then

		if (powerType == -2) then damageTaken = self:Add(damageTaken, amount); end

		if (powerType == 0) then self:Output("mob_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSMANA", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 1) then self:Output("mob_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSRAGE", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 2) then self:Output("mob_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSFOCUS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 3) then self:Output("mob_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSENERGY", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == -2) then self:Output("mob_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSHEALTH", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		end
		
 -- ATTACKER VERSUS YOUR PET -------------------
 elseif (self:IsPet(dstName, dstFlags)) then
 
		if (powerType == -2) then petDamageTaken = self:Add(petDamageTaken, amount); end

		if (powerType == 0) then self:Output("vspet_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSMANA", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 1) then self:Output("vspet_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSRAGE", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 2) then self:Output("vspet_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSFOCUS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 3) then self:Output("vspet_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSENERGY", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == -2) then self:Output("vspet_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSHEALTH", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		end

 -- OTHERS VERSUS OTHERS -----------------------
	else

		if (powerType == 0) then self:Output("oth_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSMANA", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 1) then self:Output("oth_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSRAGE", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 2) then self:Output("oth_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSFOCUS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == 3) then self:Output("oth_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSENERGY", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		elseif (powerType == -2) then self:Output("oth_drain", srcName, srcFlags, dstName, dstFlags, spellName, "DRAINSHEALTH", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, powerType, nil);
		end
		
 end
end


--
-- Handles extra attacks gained.
--
function HitsMode:OutputExtraAttacks(eventType, srcName, srcFlags, dstName, dstFlags, spellId, spellName, spellSchool, amount)

	self:DebugWrite(string.format(YEL.."self:OutputExtraAttacks received eventType: %s || src: %s || dst: %s || amount: %s || spellName: %s|r", eventType or "nil", srcName or "nil", dstName or "nil", amount or "nil", spellName or "nil"));
	if (amount == nil) then return; end
	
 -- YOU GAIN EXTRA ATTACKS ---------------------
	if (self:IsYou(dstName, dstFlags)) then
	
		attacksGained = self:Add(attacksGained, amount);
		self:Output("you_gainatk", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSATTACKS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
	
 -- YOUR PET GAINS EXTRA ATTACKS ---------------
	elseif (self:IsPet(dstName, dstFlags)) then

		self:Output("pet_gainatk", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSATTACKS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
	
 -- YOUR TARGET GAINS EXTRA ATTACKS ------------
	elseif (self:IsTarget(dstName, dstFlags)) then

		self:Output("mob_gainatk", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSATTACKS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
	
 -- SOMEONE ELSE GAINS EXTRA ATTACKS -----------
	else

		self:Output("oth_gainatk", srcName, srcFlags, dstName, dstFlags, spellName, "GAINSATTACKS", amount, nil, spellSchool, nil, nil, nil, nil, nil, nil, spellId, nil, nil);
	
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

--
-- This function handles all unit filters. It returns true if the given source/destination should be displayed in the current context.
--
local overrideFilter;

function HitsMode:MatchesFilters(srcName, srcFlags, dstName, dstFlags)
	if (self:Get("enable_filters") == 0) then return true; end
	
	-- Debug section (comment out for performance)
	--self:DebugWrite(string.format("((%s AND %s) OR (%s AND %s)) AND (%s AND %s)",
		--self:FormatBool(self:SpecFilter("src", srcName, srcFlags)),
		--self:FormatBool(self:TypeFilter("src", srcName, srcFlags)),
		--self:FormatBool(self:SpecFilter("dst", dstName, dstFlags)),
		--self:FormatBool(self:TypeFilter("dst", dstName, dstFlags)),
		--self:FormatBool(self:NameFilter("src", srcName, srcFlags)),
		--self:FormatBool(self:NameFilter("dst", dstName, dstFlags))));

	-- The overall logic goes like this:
	--((SourceSpecial AND SourceType) OR (DestSpec AND DestType)) AND (SourceName AND DestName)
	return
		(
			(self:SpecFilter("src", srcName, srcFlags) and self:TypeFilter("src", srcName, srcFlags))
			or
			(self:SpecFilter("dst", dstName, dstFlags) and self:TypeFilter("dst", dstName, dstFlags))
		)
		and
		(
			self:NameFilter("src", srcName, srcFlags) and self:NameFilter("dst", dstName, dstFlags)
		);
end

function HitsMode:SpecFilter(prefix, srcName, srcFlags)
	if (self:Get("enable_flt_"..prefix.."_spec") == 0) then
		-- If the Type filter is on, we need to return true here to allow the Type filter to work
		if (self:Get("enable_flt_"..prefix.."_type") == 1) then return true; else
			-- If neither Type nor Special is on, we need to return true to cause no filtering to take place
			if (self:Get("enable_flt_"..prefix.."_spec") == 0 and self:Get("enable_flt_"..prefix.."_type") == 0) then
				-- If the opposite prefix is on, we need to return false to only allow that filter to work
				local newprefix;
				if (prefix == "src") then newprefix = "dst"; else newprefix = "src"; end
				if (self:Get("enable_flt_"..newprefix.."_spec") == 1) then return false; else
					return true;
				end
			else
				return false;
			end
		end
	end
	
	if
	(self:Get("flt_"..prefix.."_spec_me") == 1 and self:IsYou(srcName, srcFlags)) or
	(self:Get("flt_"..prefix.."_spec_mypet") == 1 and self:IsPet(srcName, srcFlags)) or
	(self:Get("flt_"..prefix.."_spec_party") == 1 and self:IsParty(srcName, srcFlags)) or
	(self:Get("flt_"..prefix.."_spec_target") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_TARGET)) or
	(self:Get("flt_"..prefix.."_spec_focus") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_FOCUS)) or
	(self:Get("flt_"..prefix.."_spec_tank") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_MAINTANK)) or
	(self:Get("flt_"..prefix.."_spec_assist") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_MAINASSIST)) or
	(self:Get("flt_"..prefix.."_spec_raidtarget") == 1 and (
		self:Is(srcFlags, COMBATLOG_OBJECT_RAIDTARGET1) or
		self:Is(srcFlags, COMBATLOG_OBJECT_RAIDTARGET2) or 
		self:Is(srcFlags, COMBATLOG_OBJECT_RAIDTARGET3) or
		self:Is(srcFlags, COMBATLOG_OBJECT_RAIDTARGET4) or
		self:Is(srcFlags, COMBATLOG_OBJECT_RAIDTARGET5) or
		self:Is(srcFlags, COMBATLOG_OBJECT_RAIDTARGET6) or
		self:Is(srcFlags, COMBATLOG_OBJECT_RAIDTARGET7) or
		self:Is(srcFlags, COMBATLOG_OBJECT_RAIDTARGET8)
	)) or
	(self:Get("flt_"..prefix.."_spec_partypets") == 1 and self:IsPartyPet(srcName, srcFlags)) or
	(self:Get("flt_"..prefix.."_spec_raid") == 1 and self:IsRaid(srcName, srcFlags)) or
	(self:Get("flt_"..prefix.."_spec_raidpets") == 1 and self:IsRaidPet(srcName, srcFlags)) then
		return true;
	else
		return false;
	end
end

function HitsMode:TypeFilter(prefix, srcName, srcFlags)
	if (self:Get("enable_flt_"..prefix.."_type") == 0) then
		-- If the Special filter is on, we need to return true here to allow the Special filter to work
		if (self:Get("enable_flt_"..prefix.."_spec") == 1) then return true; else
			-- If neither Type nor Special is on, we need to return true to cause no filtering to take place
			if (self:Get("enable_flt_"..prefix.."_spec") == 0 and self:Get("enable_flt_"..prefix.."_type") == 0) then
				-- If the opposite prefix is on, we need to return false to only allow that filter to work
				local newprefix;
				if (prefix == "src") then newprefix = "dst"; else newprefix = "src"; end
				if (self:Get("enable_flt_"..newprefix.."_type") == 1) then return false; else
					return true;
				end
			else
				return false;
			end
		end
	end
	
	if
	(self:Get("flt_"..prefix.."_affil_mine") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_AFFILIATION_MINE)) or
	(self:Get("flt_"..prefix.."_affil_party") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_AFFILIATION_PARTY)) or
	(self:Get("flt_"..prefix.."_affil_raid") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_AFFILIATION_RAID)) or
	(self:Get("flt_"..prefix.."_affil_outsider") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_AFFILIATION_OUTSIDER)) then
		if
		(self:Get("flt_"..prefix.."_reac_friendly") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_REACTION_FRIENDLY)) or
		(self:Get("flt_"..prefix.."_reac_neutral") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_REACTION_NEUTRAL)) or
		(self:Get("flt_"..prefix.."_reac_hostile") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_REACTION_HOSTILE)) then
			if
			(self:Get("flt_"..prefix.."_cont_player") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_CONTROL_PLAYER)) or
			(self:Get("flt_"..prefix.."_cont_npc") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_CONTROL_NPC)) then
				if
				(self:Get("flt_"..prefix.."_type_player") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_TYPE_PLAYER)) or
				(self:Get("flt_"..prefix.."_type_npc") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_TYPE_NPC)) or
				(self:Get("flt_"..prefix.."_type_pet") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_TYPE_PET)) or
				(self:Get("flt_"..prefix.."_type_guardian") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_TYPE_GUARDIAN)) or
				(self:Get("flt_"..prefix.."_type_object") == 1 and self:Is(srcFlags, COMBATLOG_OBJECT_TYPE_OBJECT)) then
					return true;
				end
			end
		end
	end
	return false;
end

function HitsMode:NameFilter(prefix, srcName, srcFlags)
	if (self:Get("enable_flt_"..prefix.."_name") == 0) then return true; end
	
	local i, good, filtered;
	good = false;
	filtered = false;
	
	-- Only allow these names
	for i = 1, 4 do
		if (self:Get("flt_"..prefix.."_includenames"..i) == 1) then
			filtered = true;
			if (self:IsInList(srcName, self:GetTextValue("flt_"..prefix.."_includenames"..i))) then
				good = true;
				break;
			end
		end
	end
	
	-- We didn't want to use the first filter, so set our condition to good
	if (filtered == false) then good = true; end
	
	-- Short circuit the next comparison if we already know we can't allow this name 
	if (good == false) then return false; end
	
	-- Do not allow these names
	for i = 1, 4 do
		if (self:Get("flt_"..prefix.."_excludenames"..i) == 1) then
			if (self:IsInList(srcName, self:GetTextValue("flt_"..prefix.."_excludenames"..i))) then
				good = false;
				break;
			end
		end
	end
	
	return good;
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

--
-- The main output function of HitsMode: This function loops through all open windows and hands the logic
-- off to a worker method.
--
--   Option:          String; The HitsMode option that controls the visibility and color of this event, e.g. "you_hit"
--   srcName:         String; The name of the source of the event
--   srcFlags:        Number (bit field); The flags of the source of the event, as given by WoW
--   dstName:         String; The name of the destination of the event
--   dstFlags:        Number (bit field); The flags of the destination of the event, as given by WoW
--   SpecialAttack:   String; The spell/skill name, if any.
--   VerboseMessage:  String; The verbose message to display. This is for putting sentences together, e.g. in "You hit for 12", "hit for" is the verbose message.
--   Message:         String; The amount of damage/heal applied, if any. Must be a string representation of the number.
--   Crit:            Boolean; True if this action is critical
--   School:          Number; The internal WoW ID of the spell school that was used, if any
--   Resisted:        Number; The amount resisted, if any, as given by WoW
--   Blocked:         Number; The amount blocked, if any, as given by WoW
--   Absorbed:        Number; The amount absorbed, if any, as given by WoW
--   Crushing:        Number; Non-nil if this action is crushing, as given by WoW
--   Glancing:        Number; Non-nil if this action is glancing, as given by WoW
--   MissType:        Number; The internal WoW ID of the type of miss that this action was, if any
--   SpellId:         Number: The internal WoW ID of the spell that was used, if any. This can be used to get info about the spell, including it's icon texture.
--   PowerType:       Number; The internal WoW ID of the type of power that this action involved, if any
--   ExpType:         Number: An internal HitsMode ID for the type of experience that was gained in this action, if any
--
function HitsMode:Output(Option, srcName, srcFlags, dstName, dstFlags, SpecialAttack, VerboseMessage, Message, Crit, School, Resisted, Blocked, Absorbed, Crushing, Glancing, MissType, SpellId, PowerType, ExpType)
 local count;
 
 for count = 1, 4 do
  if (self:Get("enable"..count) == 1) then
   currentWindow = count;
   coerceChat = 1;
   self:DoOutput(Option, srcName, srcFlags, dstName, dstFlags, SpecialAttack, VerboseMessage, Message, Crit, School, Resisted, Blocked, Absorbed, Crushing, Glancing, MissType, SpellId, PowerType, ExpType);
   coerceChat = 0;
  end
 end
end


--
-- A lightweight output function that just prints the indicated localized string in the configured color.
-- Outputs to all windows as configured by the user.
--
function HitsMode:OutputConfiguredString(option, message)
 local count;
 
 for count = 1, 4 do
  if (self:Get("enable"..count) == 1) then
   currentWindow = count;
   coerceChat = 1;
   if (self:Get(option) == 1) then
    self:PrintW(self:GC(option)..self:GetString(message));
   end
   coerceChat = 0;
  end
 end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function HitsMode:GetUnitColor(type, name, flags)
	if (name == self:GetString("YOURCAP") or name == self:GetString("YOUCAP")) then name = UnitName("player"); end
 local unitColor;
 if (type == "you") then unitColor = self:GC("showyou");
 elseif (type == "pet") then unitColor = self:GC("showpet");
 elseif (type == "mob") then unitColor = self:GC("showmob");
	elseif (self:Is(flags, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Is(flags, COMBATLOG_OBJECT_REACTION_HOSTILE)) then unitColor = self:GC("showoth_playerhostile");
 elseif (self:Is(flags, COMBATLOG_OBJECT_CONTROL_PLAYER)) then unitColor = self:GC("showoth_player");
	else unitColor = self:GC("showoth_npc");
	end
 if (self:Get("colorbyclass") == 1) then
		local _, class = UnitClass(name);
		if (class ~= nil) then
			if (RAID_CLASS_COLORS[class] ~= nil) then
				unitColor = self:C(RAID_CLASS_COLORS[class].r, RAID_CLASS_COLORS[class].g, RAID_CLASS_COLORS[class].b);
			end
		end
 end
 return unitColor;
end

function HitsMode:GetRaidIcon(name, flags)
 if (self:Get("showraidicons") ~= 1) then return ""; end 
 if (self:Is(flags, COMBATLOG_OBJECT_RAIDTARGET1)) then return ICON_LIST[1].."0|t"; end
 if (self:Is(flags, COMBATLOG_OBJECT_RAIDTARGET2)) then return ICON_LIST[2].."0|t"; end
 if (self:Is(flags, COMBATLOG_OBJECT_RAIDTARGET3)) then return ICON_LIST[3].."0|t"; end
 if (self:Is(flags, COMBATLOG_OBJECT_RAIDTARGET4)) then return ICON_LIST[4].."0|t"; end
 if (self:Is(flags, COMBATLOG_OBJECT_RAIDTARGET5)) then return ICON_LIST[5].."0|t"; end
 if (self:Is(flags, COMBATLOG_OBJECT_RAIDTARGET6)) then return ICON_LIST[6].."0|t"; end
 if (self:Is(flags, COMBATLOG_OBJECT_RAIDTARGET7)) then return ICON_LIST[7].."0|t"; end
 if (self:Is(flags, COMBATLOG_OBJECT_RAIDTARGET8)) then return ICON_LIST[8].."0|t"; end
 return "";
end

--
-- The worker method that actually renders the final output to the HitsMode combat logs. This
-- function handles all the colorization, flags, text layout, source/destination swaps, and other
-- logic.
--
function HitsMode:DoOutput(Option, srcName, srcFlags, dstName, dstFlags, SpecialAttack, VerboseMessage, Message, Crit, School, Resisted, Blocked, Absorbed, Crushing, Glancing, MissType, SpellId, PowerType, ExpType)

 local SrcUnitType, DstUnitType, ShortText, ForText, s, ColorTag, sType, RevisedOption, ExtraValue, ShowSourceUnit, ShowDestUnit;
 local SrcUnit_Text, DstUnit_Text, SpecialAttack_Text, VerboseMessage_Text, Message_Text, SpellTexture, IsHeal, IsDrain, IsOutOfOrder, HasFor = false;
 local SrcUnit_RaidIcon, DstUnit_RaidIcon;
  
 RevisedOption = "";
 ExtraValue = "";
 
 -- If we're not supposed to display this message, then exit
 if (self:Get(Option) ~= 1) then return; end
 
 -- Suppress the message if it's under the threshold
 local threshold = self:GetSliderValue("threshold"..currentWindow);
 if (threshold ~= 0 and Message ~= nil and tonumber(Message) ~= nil and math.abs(tonumber(Message)) <= threshold) then return; end
 
 -- Suppress the message if it doesn't meet the filters
 if (self:MatchesFilters(srcName, srcFlags, dstName, dstFlags) == false) then return; end
 
 -- This bit guards against some nil comparisons
 if (srcName == nil) then
  SrcUnit_Text = "";
  srcName = "";
 end
 if (dstName == nil) then
  DstUnit_Text = "";
  dstName = "";
 end
 if (SpecialAttack == nil) then
  SpecialAttack_Text = "";
  SpecialAttack = "";
 end
 
 -- Setup various flags based on what type of event this is
 if (strfind(Option, "heal") or strfind(Option, "hot")) then IsHeal = true; else IsHeal = false; end
 if (strfind(Option, "drain")) then IsDrain = true; else IsDrain = false; end
 if (
		VerboseMessage == "GAIN" or VerboseMessage == "GAINS" or
		VerboseMessage == "AREAFFLICTED" or VerboseMessage == "ISAFFLICTED" or
		VerboseMessage == "DISPEL" or VerboseMessage == "DISPELS" or
		VerboseMessage == "STEAL" or VerboseMessage == "STEALS" or
		VerboseMessage == "STARTCASTING" or VerboseMessage == "STARTSCASTING" or
		VerboseMessage == "FINISHCASTING" or VerboseMessage == "FINISHESCASTING" or
		VerboseMessage == "FAILTOCAST" or VerboseMessage == "FAILSTOCAST" or
		VerboseMessage == "FAILTODISPEL" or VerboseMessage == "FAILSTODISPEL"
	) then IsOutOfOrder = true; else IsOutOfOrder = false; end
 
 -- Process the unit names and figure out what type they are
 if (self:IsYou(srcName, srcFlags)) then
  SrcUnitType = "you";
		if (self:Get("renameplayer") == 1) then
			if (SpecialAttack ~= "" and IsOutOfOrder == false) then srcName = self:GetString("YOURCAP"); else srcName = self:GetString("YOUCAP"); end
		end
 elseif (self:IsPet(srcName, srcFlags)) then
  SrcUnitType = "pet";
 elseif (self:IsTarget(srcName, srcFlags)) then
  SrcUnitType = "mob";
 else
		SrcUnitType = "oth";
 end
 if (self:IsYou(dstName, dstFlags)) then
  DstUnitType = "you";
		if (self:Get("renameplayer") == 1) then
			dstName = self:GetString("YOUCAP");
			if (SpecialAttack ~= "" and srcName == "" and IsOutOfOrder == false) then dstName = self:GetString("YOURCAP"); else dstName = self:GetString("YOUCAP"); end
		end
 elseif (self:IsPet(dstName, dstFlags)) then
  DstUnitType = "pet";
 elseif (self:IsTarget(dstName, dstFlags)) then
  DstUnitType = "mob";
 else
		DstUnitType = "oth";
 end
 
 -- Special case for healing yourself -- set destination to "yourself"
 if IsHeal and SrcUnitType == "you" and DstUnitType == "you" then
		dstName = self:GetString("YOURSELF");
	end
 
 -- Change message from "hits for" to "hit for" if the source is you and there is no special attack
 if (SpecialAttack == "" and SrcUnitType == "you") then
		if (VerboseMessage == "HITSFOR") then VerboseMessage = "HITFOR";
		elseif (VerboseMessage == "CRITSFOR") then VerboseMessage = "CRITFOR";
		end
	end
	
	-- If source is null but we have a destination, flip them (this is how buffs/debuffs work, for example)
	if (srcName == "" and dstName ~= "") then
		srcName, dstName = self:Flip(srcName, dstName);
		SrcUnitType, DstUnitType = self:Flip(SrcUnitType, DstUnitType);
		srcFlags, dstFlags = self:Flip(srcFlags, dstFlags);
	end
	
	-- For environmental damage we hardcode source to "You" and destination to nothing
	if (Option == "you_fall") then
		dstName = "";
		srcName = self:GetString("YOUCAP");
		SrcUnitType = "you";
		DstUnitType = "you";
	end
	
	-- For miss types other than MISS, we need to flip source and destination
	if (MissType ~= nil) then
		if (MissType ~= "MISS") then
			srcName, dstName = self:Flip(srcName, dstName);
			SrcUnitType, DstUnitType = self:Flip(SrcUnitType, DstUnitType);
			srcFlags, dstFlags = self:Flip(srcFlags, dstFlags);
		end
	end
 
 -- Get the localized verbose message text
 if (VerboseMessage == nil) then VerboseMessage_Text = ""; else VerboseMessage_Text = self:GetString(VerboseMessage); end
 
	-- Substitute ++/-- for buffs/debuffs if desired
	if (self:Get("plusplus") == 1 and (SrcUnitType == "you" or SrcUnitType == "pet")) then
		if ((VerboseMessage == "GAIN" or VerboseMessage == "GAINS")) then
			VerboseMessage_Text = "++";
		elseif ((VerboseMessage == "FADE" or VerboseMessage == "FADES")) then
			VerboseMessage_Text = "--";
			IsOutOfOrder = true;
		end
	end

 
 if (Message ~= nil and Message ~= "") then
 
  -- Spell school coloring (don't color heals or energizes, do color drains)
  if (School ~= nil and IsHeal == false and (powerType == nil or IsDrain == true)) then
			if (School == 0x02) then RevisedOption = "Holy";
			elseif (School == 0x04) then RevisedOption = "Fire";
			elseif (School == 0x08) then RevisedOption = "Nature";
			elseif (School == 0x10) then RevisedOption = "Frost";
			elseif (School == 0x20) then RevisedOption = "Shadow";
			elseif (School == 0x40) then RevisedOption = "Arcane";
			end
  end
  
  -- Extra values
  if (self:Get("extval") == 1) then
   ExtraValue = "";
   if (Resisted ~= nil) then ExtraValue = ExtraValue..string.format(" (%s %s)", Resisted, self:GetString("RESISTED")); end
   if (Blocked ~= nil) then ExtraValue = ExtraValue..string.format(" (%s %s)", Blocked, self:GetString("BLOCKED")); end
   if (Absorbed ~= nil) then ExtraValue = ExtraValue..string.format(" (%s %s)", Absorbed, self:GetString("ABSORBED")); end
   if (Crushing ~= nil) then ExtraValue = ExtraValue..string.format(" (%s)", self:GetString("CRUSHING")); end
   if (Glancing ~= nil) then ExtraValue = ExtraValue..string.format(" (%s)", self:GetString("GLANCING")); end
			if (ExtraValue ~= "") then ExtraValue = self:GC("extval")..ExtraValue.."|r"; end
  end

  -- Heal flag
  if (IsHeal and self:Get("flagheals") == 1) then
   Message = "+"..Message;
  end
  
  -- Energize flag
  if (PowerType ~= nil and self:Get("flagenergizes") == 1 and IsDrain == false) then
			Message = "+"..Message;
  end
  
  -- Pet flag
  if ((self:IsPet(srcName, srcFlags) or self:IsPet(dstName, dstFlags)) and self:Get("flagpet") == 1) then
   Message = "~"..Message.."~";
  end
  
  -- If we didn't want to revise the option, go with the original
  if (RevisedOption == "") then
   RevisedOption = Option;
  end

  -- Crit flag and color
  if (Crit == true) then
   if (self:Get("flagcrits") == 1) then
    Message = string.format("%s*|r%s%s|r%s*|r", self:GC("flagcrits"), self:GCO(RevisedOption, SrcUnitType, "crit"), Message, self:GC("flagcrits"));
   else
    Message = string.format("%s%s|r", self:GCO(RevisedOption, SrcUnitType, "crit"), Message);
			end
  else
   Message = self:GCO(RevisedOption, SrcUnitType, "not")..Message.."|r";
  end
  
  -- Append extra values if any
  Message_Text = Message..ExtraValue;

 else
  Message_Text = VerboseMessage_Text;
 end
 
 -- Colorize spell names and/or convert them to links
 if (SpecialAttack ~= nil and SpecialAttack ~= "") then
		if (SpellId ~= nil and self:Get("showspelllinks") == 1) then
			SpecialAttack_Text = GetSpellLink(SpellId);
		else
			SpecialAttack_Text = self:GC("showskill")..SpecialAttack.."|r";
		end
 else
  SpecialAttack_Text = "";
 end
 
 -- Colorize unit names
 SrcUnit_Text = string.format("%s%s%s|r%s", self:BracketLeft(), self:GetUnitColor(SrcUnitType, srcName, srcFlags), srcName, self:BracketRight());
 DstUnit_Text = string.format("%s%s%s|r%s", self:BracketLeft(), self:GetUnitColor(DstUnitType, dstName, dstFlags), dstName, self:BracketRight());
 
 -- Get raid icons
 SrcUnit_RaidIcon = self:GetRaidIcon(srcName, srcFlags);
 DstUnit_RaidIcon = self:GetRaidIcon(dstName, dstFlags);
 
 -- Determine if we should show the source and destination unit names
 if (SrcUnitType == "you" and self:Get("showyou") == 1) or
    (SrcUnitType == "pet" and self:Get("showpet") == 1) or
    (SrcUnitType == "mob" and self:Get("showmob") == 1) or
    (SrcUnitType == "oth" and (
					(self:Is(srcFlags, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Is(srcFlags, COMBATLOG_OBJECT_REACTION_HOSTILE) and self:Get("showoth_playerhostile") == 1) or
					(self:Is(srcFlags, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Get("showoth_player") == 1) or
					(self:Get("showoth_npc") == 1)
				)) then ShowSourceUnit = true; else ShowSourceUnit = false; end
 if (DstUnitType == "you" and self:Get("showyou") == 1) or
    (DstUnitType == "pet" and self:Get("showpet") == 1) or
    (DstUnitType == "mob" and self:Get("showmob") == 1) or
    (DstUnitType == "oth" and (
					(self:Is(dstFlags, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Is(dstFlags, COMBATLOG_OBJECT_REACTION_HOSTILE) and self:Get("showoth_playerhostile") == 1) or
					(self:Is(dstFlags, COMBATLOG_OBJECT_CONTROL_PLAYER) and self:Get("showoth_player") == 1) or
					(self:Get("showoth_npc") == 1)
				)) then ShowDestUnit = true; else ShowDestUnit = false; end
	if (SrcUnitType == "you" and DstUnitType == "you") then
		if (IsOutOfOrder) then ShowSourceUnit = false; else ShowDestUnit = false; end
	end
				
	-- If we're substituting ++/-- on buffs/debuffs, and the source is you, hide the source
	if ((VerboseMessage_Text == "++" or VerboseMessage_Text == "--") and SrcUnitType == "you") then ShowSourceUnit = false; end
	
 -- Construct a short version of VerboseMessage for Short Mode and for Verbose Mode B to use
 -- (Removes trailing " for")
 if (strsub(VerboseMessage_Text, -4, -1) == " for") then
  HasFor = true;
  ShortText = strsub(VerboseMessage_Text, 1, -5);
 else
  ShortText = VerboseMessage_Text;
 end
 
 -- Verbose Mode B needs a constant for the word "for"
 ForText = self:GetString("FOR");

 -- Colorize VerboseMessage, ShortText, and ForText
 if (self:Get("verbosea") == 1) then
  ColorTag = self:GC("verbosea");
 elseif (self:Get("verboseb") == 1) then
  ColorTag = self:GC("verboseb");
 else
  ColorTag = self:C(1, 1, 1);
 end
 VerboseMessage_Text = ColorTag..VerboseMessage_Text.."|r";
 ShortText = ColorTag..ShortText.."|r";
 ForText = ColorTag..ForText.."|r";

 -- Fix a missing unit name for some out of order messages
 if (IsOutOfOrder) then
		if (dstName == "" and srcName ~= "") then
			DstUnit_Text = SrcUnit_Text;
		elseif (srcName == "" and dstName ~= "") then
			SrcUnit_Text = DstUnit_Text;
		end
 end

	-- No unit name available; hide it
	if (srcName == nil or srcName == "") then ShowSourceUnit = false; end
	if (dstName == nil or dstName == "") then ShowDestUnit = false; end
	
	if (IsOutOfOrder and ShowSourceUnit == false and ShowDestUnit == true) then
		srcName, dstName = self:Flip(srcName, dstName);
		SrcUnitType, DstUnitType = self:Flip(SrcUnitType, DstUnitType);
		srcFlags, dstFlags = self:Flip(srcFlags, dstFlags);
		ShowSourceUnit, ShowDestUnit = self:Flip(ShowSourceUnit, ShowDestUnit);
	end


 ------
 --- Main output section
 ------
 
 -------- VERBOSE MODE A
 if (self:Get("verbosea") == 1) then
  
  s = "";

  -- Unit name
  s = s..SrcUnit_RaidIcon;
  if (ShowSourceUnit) then
   s = s..SrcUnit_Text.." ";
  end
  
  -- Special case for out of order messages: display the verbose message before the skill name
  if (IsOutOfOrder) then
   s = s..VerboseMessage_Text.." ";
  end
  
  -- Skill name
  if (SpecialAttack ~= nil and SpecialAttack ~= "" and self:Get("showskill") == 1) then
   s = s..SpecialAttack_Text.." ";
  end
  
  -- Verbose text (check for short mode)
  if (IsOutOfOrder == false) then
   if (self:Get("shortmode") == 1) then
    s = s..ShortText;
   else
    s = s..VerboseMessage_Text;
   end
  end

  -- Message
  if (Message ~= VerboseText) then
   s = s.." "..Message_Text;
  end
  
 
 -------- VERBOSE MODE B
 elseif (self:Get("verboseb") == 1) then

  s = "";

  s = s..SrcUnit_RaidIcon;
  if (ShowSourceUnit) then s = s..SrcUnit_Text.." "; end
  if (IsOutOfOrder) then s = s..VerboseMessage_Text.." "; end
  if (SpecialAttack ~= nil and SpecialAttack ~= "" and self:Get("showskill") == 1) then s = s..SpecialAttack_Text.." "; end
  if (IsOutOfOrder == false) then s = s..ShortText.." "; end
  s = s..DstUnit_RaidIcon;
		if (ShowDestUnit) then s = s..DstUnit_Text.." "; end
		if (Message ~= VerboseText) then
			if (self:Get("shortmode") ~= 1 and ((srcName ~= "" and dstName ~= "" and tonumber(Message) ~= nil) or HasFor)) then s = s..ForText.." "; end
			s = s..Message_Text;
		end

 -------- VERBOSE MODE C
 elseif (self:Get("verbosec") == 1) then

  -- The message comes first followed by the divider
  local VerboseC_Text = Message_Text..self:GC("verbosec")..self:GetString("CDIVIDER").."|r";
  
  s = "";
  
  -- CASE 1: You or your pet did something to it
  if ((SrcUnitType == "you" or SrcUnitType == "pet") and dstName ~= "") then

   -- srcName name
   s = s..SrcUnit_RaidIcon;
   if (ShowSourceUnit) then
    s = s..SrcUnit_Text.." ";
   end
   -- Special case for out of order messages: display the verbose message before the skill name
   if (IsOutOfOrder) then
    s = s..VerboseMessage_Text.." ";
   end
   -- Skill name
   if (SpecialAttack ~= nil and SpecialAttack ~= "" and self:Get("showskill") == 1) then
    s = s..SpecialAttack_Text.." ";
   end
   -- ShortText goes here
   if (IsOutOfOrder == false) then
    s = s..ShortText.." ";
   end
   -- dstName name
   s = s..DstUnit_RaidIcon;
   if (self:Get("showmob") == 1) then
    s = s..DstUnit_Text.." ";
   end
   
  -- CASE 2: It did something to you or your pet
  elseif (dstName ~= "") then
  
   -- Unit name
   s = s..SrcUnit_RaidIcon;
   if (ShowSourceUnit) then
    s = s..SrcUnit_Text.." ";
   end 
   -- Special case for out of order messages: display the verbose message before the skill name
   if (IsOutOfOrder) then
    s = s..VerboseMessage_Text.." ";
   end
   -- Skill name
   if (SpecialAttack ~= nil and SpecialAttack ~= "" and self:Get("showskill") == 1) then
    s = s..SpecialAttack_Text.." ";
   end
   -- ShortText goes here
   if (IsOutOfOrder == false) then
    s = s..ShortText.." ";
   end
   -- dstName name
   s = s..DstUnit_RaidIcon;
   if (ShowDestUnit) then
    -- Don't put the target unit if verbose=message (like dodge, parry)
    if (Message ~= VerboseText) then
     s = s..DstUnit_Text.." ";
    end
   end

  -- DEFAULT CASE: Something happened without two targets specified
  -- We revert to Verbose Mode A in this case
  else
   
   -- Unit name
   s = s..SrcUnit_RaidIcon;
   if (ShowSourceUnit) then
    s = s..SrcUnit_Text.." ";
   end
   -- Special case for out of order messages: display the verbose message before the skill bane
   if (IsOutOfOrder) then
    s = s..VerboseMessage_Text.." ";
   end
   -- Skill name
   if (SpecialAttack ~= nil and SpecialAttack ~= "" and self:Get("showskill") == 1) then
    s = s..SpecialAttack_Text.." ";
   end
   -- Verbose text (check for short mode)
   if (IsOutOfOrder == false) then
    if (self:Get("shortmode") == 1) then
     s = s..ShortText;
    else
     s = s..VerboseMessage_Text;
    end
   end
  end
  
  s = VerboseC_Text..s;
 
 -------- NO VERBOSE MODE
 else
		if (self:Get("showskill") == 1) then
			s = SpecialAttack_Text.." ";
		end
		s = (s or "")..DstUnit_RaidIcon;
  s = (s or "")..Message_Text;
 end
 
 -- Add the spell texture if necessary
 if (SpellId ~= nil and self:Get("showicons") == 1) then
		local spellTexture = self:GetSpellIcon(SpellId);
		if spellTexture ~= nil then s = "|T"..spellTexture..":0|t "..s; end
 end
 
 -- And..... output the text
 self:PrintW(s);
end



-- Iterate through all the open windows and output the combat summary
function HitsMode:SummarizeCombat()
 if (self:Get("enable_combatsummary") == 0) then return; end
 local endTime = GetTime();
 local seconds = endTime - combatStartTime;
 if (seconds == 0) then return; end
 local count;
 for count = 1, 4 do
  if (self:Get("enable"..count) == 1) then
   currentWindow = count;
   coerceChat = 1;
   self:DoSummarizeCombat(seconds);
   coerceChat = 0;
  end
 end
end


function HitsMode:Announce(text, r, g, b)
	if tostring(SHOW_COMBAT_TEXT) ~= "0" then
		CombatText_AddMessage(text, CombatText_StandardScroll, r, g, b, nil, false)
	else
		UIErrorsFrame:AddMessage(text, r, g, b, 1, UIERRORS_HOLD_TIME)
	end
end


-- Handles the actual output of the combat summary
function HitsMode:DoSummarizeCombat(seconds)
 if (self:Get("cs_skipentire") == 1 and damageGiven == 0 and petDamageGiven == 0 and healsGiven == 0 and expGained == 0) then return; end
 if (self:Get("cs_sep_short") == 1) then self:PrintW(self:GC("cs_sep_short")..self:GetString("SHORTSEP").."|r"); end
 if (self:Get("cs_sep1") == 1) then self:PrintW(self:GC("cs_sep1").."~~~~~~~~~~~~~~~~~~~~~~~~~~~~~|r"); end
 if (self:Get("cs_duration") == 1) then self:PrintW(self:GC("cs_duration").."Fight duration: |r"..self:GC("cs_numeric")..SecondsToTime(seconds).."|r"); end
 self:OutputCombatSummary(L[294], damageGiven + petDamageGiven, seconds, "skip_yourdamage", "cs_totaldamagegiven"); -- Total damage given:
 self:OutputCombatSummary(L[186], damageGiven, seconds, "skip_yourdamage", "cs_damagegiven"); -- Damage given (you):
 self:OutputCombatSummary(L[187], damageResisted, seconds, "skip_avoided", "cs_damageavoided"); -- Damage avoided (you): 
 self:OutputCombatSummary(L[188], damageTaken, seconds, "skip_yourdamage", "cs_damagetaken"); -- Damage taken (you): 
 self:OutputCombatSummary(L[189], petDamageGiven, seconds, "skip_petdamage", "cs_petdamagegiven"); -- Damage given (your pet): 
 self:OutputCombatSummary(L[190], petDamageTaken, seconds, "skip_petdamage", "cs_petdamagetaken"); -- Damage taken (your pet): 
 self:OutputCombatSummary(L[191], healsGiven, seconds, "skip_yourheals", "cs_healsgiven"); -- Heals given: 
 self:OutputCombatSummary(L[192], healsTaken, seconds, "skip_yourheals", "cs_healsreceived"); -- Heals received (you): 
 self:OutputCombatSummary(L[193], petHealsTaken, seconds, "skip_yourheals", "cs_pethealsreceived"); -- Heals received (your pet): 
 self:OutputCombatSummary(L[194], manaGained, seconds, "1", "cs_gained"); -- Mana gained: 
 self:OutputCombatSummary(L[195], energyGained, seconds, "1", "cs_gained"); -- Energy gained: 
 self:OutputCombatSummary(L[196], rageGained, seconds, "1", "cs_gained"); -- Rage gained: 
 self:OutputCombatSummary(L[197], attacksGained, seconds, "1", "cs_attacksgained"); -- Attacks gained: 
 self:OutputCombatSummary(L[199], skillsIncreased, seconds, "1", "cs_skills"); -- Skills increased: 
 self:OutputCombatSummary(L[200], expGained, seconds, "1", "cs_exp"); -- Exp gained: 
 if (self:Get("cs_sep2") == 1) then self:PrintW(self:GC("cs_sep2").."~~~~~~~~~~~~~~~~~~~~~~~~~~~~~|r"); end
 local r, g, b = self:GetColor("cs_announcedps");
 if (announced == false) then
  local dps = (damageGiven + petDamageGiven) / seconds;
  if (self:Get("cs_announcedps") == 1) then self:Announce(L[301]..self:FormatNumber(dps), r, g, b); end
  if (pOptions.maxdps == nil) then pOptions.maxdps = 0.0; end
  if (dps > pOptions.maxdps) then
   local r, g, b = self:GetColor("cs_announcehighdps");
   pOptions.maxdps = dps;
   if (self:Get("cs_announcehighdps") == 1) then self:Announce(L[299]..self:FormatNumber(dps)..L[300], r, g, b); end
  end
  announced = true;
 end
end


function HitsMode:OutputCombatSummary(text, value, seconds, skipOption, messageOption)
 -- Skip the message if it's been turned off
 if (self:Get(messageOption) ~= 1) then return; end
 
 value = math.abs(value);

 -- Get whether to auto-skip or not
 local skip = 0;
 if (skipOption == "1") then
  skip = 1;
 else
  skip = self:Get(skipOption, 1);
 end
 
 -- Get the configured colors of the message
 local color = self:GC(messageOption);
 local numcolor = self:GC("cs_numeric");
 
 -- Output the message if necessary
 if ((skip == 1 and value > 0) or skip == 0) then
  local s = color..text.."|r"..numcolor..self:FormatNumber(value).."|r "..color.."(|r"..numcolor..self:FormatNumber(value / seconds).."|r";
  if (self:Get("cs_sec") == 1) then s = s..self:GC("cs_sec").."/sec".."|r"; end
  s = s..color..")|r";
  self:PrintW(s);
 end
end


function HitsMode:AutoSkip(amount, option)
 local skip = self:Get(option, 1);
 if ((amount > 0 and skip == 1) or skip == 0) then
  return 1;
 else
  return 0;
 end;
end
