local HELPLIB_REV=3
local isBetterInstanceLoaded = ( HelpLib and HelpLib.version and HelpLib.version >= HELPLIB_REV );

if (not isBetterInstanceLoaded) then

	if (not HelpLib) then
		HelpLib = {};
	end
	
	HelpLib.version = HELPLIB_REV;

HelpLib={}
HelpLib_Loaded=true
--[[EntryFormat example
ChangeColor={
    q="Can I change my own color?",
    a="At this time, it is not possible to change your own color.\n\nShould there be enough feedback wishing for it though, an option may be added to change individual colors on your own screen.",
    hot=true,
    new=false,
    
    }
]]--
--Entry stuff
HelpLib.entries={}
HelpLib.entries.categories={}
HelpLib.entries.subcats={}
HelpLib.entries.questions={}
HelpLib.entries.questions.count=0
HelpLib.results={}
HelpLib.results.num=0
HelpLib.links={}
--Internal stuff
HelpLib.CurrentCat=0
HelpLib.CurrentSubCat=0
HelpLib.CurrentPage=1
HelpLib.ClickedItem=1
HelpLib.ActiveQuestion=false
-----Hooking stuff
HelpLib.oldfunc={}
HelpLib.oldfunc.KBSetup_GetArticleHeaderCount=KBSetup_GetArticleHeaderCount
HelpLib.oldfunc.KBSetup_GetArticleHeaderData=KBSetup_GetArticleHeaderData
HelpLib.oldfunc.KnowledgeBaseFrameCategoryDropDown_Initialize=KnowledgeBaseFrameCategoryDropDown_Initialize
HelpLib.oldfunc.KBSetup_GetCategoryCount=KBSetup_GetCategoryCount
HelpLib.oldfunc.KBSetup_GetCategoryData=KBSetup_GetCategoryData
HelpLib.oldfunc.KBSetup_GetSubCategoryCount=KBSetup_GetSubCategoryCount
HelpLib.oldfunc.KBSetup_GetSubCategoryData=KBSetup_GetSubCategoryData
HelpLib.oldfunc.KBQuery_BeginLoading=KBQuery_BeginLoading
HelpLib.oldfunc.KBArticle_BeginLoading=KBArticle_BeginLoading
HelpLib.oldfunc.KnowledgeBaseArticleListFrameNextButtonOnClick=KnowledgeBaseArticleListFrameNextButton:GetScript("OnClick")
HelpLib.oldfunc.KnowledgeBaseArticleListFramePreviousButtonOnClick=KnowledgeBaseArticleListFramePreviousButton:GetScript("OnClick")

hooksecurefunc("KnowledgeBaseFrameCategoryButton_OnClick",function() HelpLib.CurrentCat=UIDropDownMenu_GetSelectedID(KnowledgeBaseFrameCategoryDropDown)-1; end)
hooksecurefunc("KnowledgeBaseFrameSubCategoryButton_OnClick",function() HelpLib.CurrentSubCat=UIDropDownMenu_GetSelectedID(KnowledgeBaseFrameSubCategoryDropDown)-1; end)
hooksecurefunc("KnowledgeBaseFrame_ShowArticleFrame",function() HelpLib.CheckDropdowns() end)
hooksecurefunc("KnowledgeBaseFrame_ShowSearchFrame",function() UIDropDownMenu_DisableDropDown(HelpLibLinkFrame) UIDropDownMenu_DisableDropDown(HelpLibActionFrame) end)
for i=1,20 do
    getglobal("KnowledgeBaseArticleListItem"..i):SetScript("OnClick",function() HelpLib.ClickedItem=this.articleId; KnowledgeBaseArticleListItem_OnClick(); end)
end

--KnowledgeBaseArticleListFrameNextButton:SetScript("OnClick",function())

function KBArticle_BeginLoading(articleId, searchType)
    HelpLib.ActiveQuestion=false
    if HelpLib.CurrentCat>HelpLib.oldfunc.KBSetup_GetCategoryCount() then
        --local id, subject, subjectAlt, text, keywords, languageId, isHot = KBArticle_GetData();
        local id=(HelpLib.CurrentPage-1)*KBASE_NUM_ARTICLES_PER_PAGE+HelpLib.ClickedItem
        local currentQuestion=HelpLib.results[id]
        HelpLib.ActiveQuestion=currentQuestion
        local subject,subjectAlt,text,keywords,languageId,isHot=currentQuestion.question,currentQuestion.question,currentQuestion.answer,"","",currentQuestion.hot
        KnowledgeBaseArticleScrollChildFrameTitle:SetText(subject);
        KnowledgeBaseArticleScrollChildFrameText:SetText(text);
        KnowledgeBaseArticleScrollChildFrameArticleId:SetText(format(KBASE_ARTICLE_ID, id));
        KnowledgeBaseArticleScrollFrame:UpdateScrollChildRect();
        KnowledgeBaseArticleScrollFrameScrollBar:SetValue(0);
        KnowledgeBaseFrame_ShowArticleFrame();
    else
        HelpLib.oldfunc.KBArticle_BeginLoading(articleId, searchType)
    end
end
function KBQuery_BeginLoading(searchText,categoryIndex,subcategoryIndex,ArticlesPerPage,CurrentPage)
    HelpLib.CurrentPage=CurrentPage
    if categoryIndex>HelpLib.oldfunc.KBSetup_GetCategoryCount() then
        HelpLib:Debug("KBQuery_BeginLoading called by you")
        HelpLib.search(searchText,categoryIndex,subcategoryIndex,ArticlesPerPage,CurrentPage)
    else
        HelpLib.oldfunc.KBQuery_BeginLoading(searchText,categoryIndex,subcategoryIndex,ArticlesPerPage,CurrentPage)
    end
end
function KBSetup_GetSubCategoryData(selectedCategoryId, i)
    if selectedCategoryId>HelpLib.oldfunc.KBSetup_GetCategoryCount() then
        HelpLib:Debug("KBSetup_GetSubCategoryData called by you")
        local myselectedCategoryId = (selectedCategoryId)-HelpLib.oldfunc.KBSetup_GetCategoryCount()
        local currentcatname=HelpLib.entries.categories[myselectedCategoryId]
        local subcattext=HelpLib.entries.subcats[currentcatname][i]
        local subcatId=HelpLib.hash(currentcatname..subcattext)
        return subcatId,subcattext
    else
        return HelpLib.oldfunc.KBSetup_GetSubCategoryData(selectedCategoryId, i)
    end
end

function KBSetup_GetSubCategoryCount(selectedCategoryId)
    if selectedCategoryId>HelpLib.oldfunc.KBSetup_GetCategoryCount() then
        HelpLib:Debug("KBSetup_GetSubCategoryCount called by you")
        local myselectedCategoryId = (selectedCategoryId)-HelpLib.oldfunc.KBSetup_GetCategoryCount()
        local mycount = getn(HelpLib.entries.subcats[HelpLib.entries.categories[myselectedCategoryId]])
        return mycount
    else
        return HelpLib.oldfunc.KBSetup_GetSubCategoryCount(selectedCategoryId)
    end

end

function KBSetup_GetCategoryCount()
    local oldcount = HelpLib.oldfunc.KBSetup_GetCategoryCount()
    newcount=oldcount+getn(HelpLib.entries.categories)
    return newcount
end

function KBSetup_GetCategoryData(i)
    local oldcount=HelpLib.oldfunc.KBSetup_GetCategoryCount()
    if i>oldcount then
    HelpLib:Debug("KBSetup_GetCategoryData called by you")
        return HelpLib.hash(HelpLib.entries.categories[i-oldcount]),HelpLib.entries.categories[i-oldcount]
    else
        return HelpLib.oldfunc.KBSetup_GetCategoryData(i)
    end
end



------End hooking stuff-----


function HelpLib.CreateNewCategory(CategoryName)
    if not HelpLib.CategoryExists(CategoryName) then
        tinsert(HelpLib.entries.categories,CategoryName)
        HelpLib.entries.subcats[CategoryName]={}
        HelpLib.entries.questions[CategoryName]={}
        HelpLib.entries.questions[CategoryName]["count"]=0
    end
end

function HelpLib.CreateNewSubCategory(SubCategoryName,CategoryName)
    if not HelpLib.SubCategoryExists(SubCategoryName,CategoryName) then
        if not HelpLib.CategoryExists(CategoryName) then
            HelpLib.CreateNewCategory(CategoryName)
        end
        tinsert(HelpLib.entries.subcats[CategoryName],SubCategoryName)
        HelpLib.entries.questions[CategoryName][SubCategoryName]={}
        HelpLib.entries.questions[CategoryName][SubCategoryName]["count"]=0
    end
end

function HelpLib.CategoryExists(CategoryName)
    if HelpLib.entries.subcats[CategoryName] then
        return true
    else
        return false
    end
end

function HelpLib.SubCategoryExists(SubCategoryName,CategoryName)
    if not HelpLib.CategoryExists(CategoryName) then return false end
    if HelpLib.entries.questions[CategoryName][SubCategoryName] then
        return true
    else
        return false
    end
end
--Outward Functions--
function HelpLib.AddQuestion(questionTable)
    if not (questionTable.q and questionTable.a) then return end
    local Question=questionTable.q
    local Answer=questionTable.a
    local Hot=questionTable.hot or false
    local New=questionTable.new or false
    local CategoryName=questionTable.cat or "Addons"
    local SubCategoryName=questionTable.subcat
    local Actions=questionTable.act or false
    if not HelpLib.CategoryExists(CategoryName) then
        HelpLib.CreateNewCategory(CategoryName)
    end
    if (CategoryName) and (SubCategoryName) then
        if not HelpLib.SubCategoryExists(SubCategoryName,CategoryName) then
            HelpLib.CreateNewSubCategory(SubCategoryName,CategoryName)
        end
        local QuestionNumber=HelpLib.entries.questions[CategoryName][SubCategoryName]["count"]+1
        HelpLib.entries.questions[CategoryName][SubCategoryName]["question"..QuestionNumber]={}
        HelpLib.entries.questions[CategoryName][SubCategoryName]["question"..QuestionNumber]["question"]=Question
        HelpLib.entries.questions[CategoryName][SubCategoryName]["question"..QuestionNumber]["answer"]=Answer
        HelpLib.entries.questions[CategoryName][SubCategoryName]["question"..QuestionNumber]["hot"]=Hot
        HelpLib.entries.questions[CategoryName][SubCategoryName]["question"..QuestionNumber]["new"]=New
        HelpLib.entries.questions[CategoryName][SubCategoryName]["question"..QuestionNumber]["actions"]=Actions
        HelpLib.entries.questions[CategoryName][SubCategoryName]["count"]=HelpLib.entries.questions[CategoryName][SubCategoryName]["count"]+1
    elseif (CategoryName) and (not (SubCategoryName)) then
        local QuestionNumber=HelpLib.entries.questions[CategoryName]["count"]+1
        HelpLib.entries.questions[CategoryName]["question"..QuestionNumber]={}
        HelpLib.entries.questions[CategoryName]["question"..QuestionNumber]["question"]=Question
        HelpLib.entries.questions[CategoryName]["question"..QuestionNumber]["answer"]=Answer
        HelpLib.entries.questions[CategoryName]["question"..QuestionNumber]["hot"]=Hot
        HelpLib.entries.questions[CategoryName]["question"..QuestionNumber]["new"]=New
        HelpLib.entries.questions[CategoryName]["question"..QuestionNumber]["actions"]=Actions
        HelpLib.entries.questions[CategoryName]["count"]=HelpLib.entries.questions[CategoryName]["count"]+1
    end
end
--End Outward Functions--

--My searching functions--
function HelpLib:Debug(text)
    --DEFAULT_CHAT_FRAME:AddMessage(text,1,0,0)
end
function HelpLib.search(searchText,categoryIndex,subcategoryIndex,ArticlesPerPage,CurrentPage)
    local NewScore=1
    local HotScore=2
    HelpLib.CurrentCat=categoryIndex
    HelpLib.CurrentSubCat=subcategoryIndex
    HelpLib.results={}
    HelpLib.results.num=0
    local CategoryName=HelpLib.entries.categories[categoryIndex-HelpLib.oldfunc.KBSetup_GetCategoryCount()]
    for _,targetscore in pairs({3,2,1,0}) do
    if subcategoryIndex>0 then
        local SubCategoryName=HelpLib.entries.subcats[CategoryName][subcategoryIndex]
        for i=1,HelpLib.entries.questions[CategoryName][SubCategoryName]["count"] do
            local currentQuestion=HelpLib.entries.questions[CategoryName][SubCategoryName]["question"..i]
            local currentScore=(currentQuestion.hot and HotScore or 0)+(currentQuestion.new and NewScore or 0)
            if currentScore==targetscore then
                if (strfind(strlower(currentQuestion.question),strlower(searchText))) or (strfind(strlower(currentQuestion.answer),strlower(searchText))) or searchText=="" then
                    HelpLib.results[HelpLib.results.num+1]=currentQuestion
                    HelpLib.results.num=HelpLib.results.num+1
                end
            end
        end
    else
        for i=1,HelpLib.entries.questions[CategoryName]["count"] do
            local currentQuestion=HelpLib.entries.questions[CategoryName]["question"..i]
            local currentScore=(currentQuestion.hot and HotScore or 0)+(currentQuestion.new and NewScore or 0)
            if currentScore==targetscore then
                if (strfind(strlower(currentQuestion.question),strlower(searchText))) or (strfind(strlower(currentQuestion.answer),strlower(searchText))) or searchText=="" then
                    HelpLib.results[HelpLib.results.num+1]=currentQuestion
                    HelpLib.results.num=HelpLib.results.num+1
                end
            end
        end
        for j=1,getn(HelpLib.entries.subcats[CategoryName]) do
            SubCategoryName=HelpLib.entries.subcats[CategoryName][j]
            for i=1,HelpLib.entries.questions[CategoryName][SubCategoryName]["count"] do
                local currentQuestion=HelpLib.entries.questions[CategoryName][SubCategoryName]["question"..i]
                local currentScore=(currentQuestion.hot and HotScore or 0)+(currentQuestion.new and NewScore or 0)
                if currentScore==targetscore then
                    if (strfind(strlower(currentQuestion.question),strlower(searchText))) or (strfind(strlower(currentQuestion.answer),strlower(searchText))) or searchText=="" then
                        HelpLib.results[HelpLib.results.num+1]=currentQuestion
                        HelpLib.results.num=HelpLib.results.num+1
                    end
                end
            end
        end
    end
    end
    if HelpLib.results.num>0 then
        --Taken directly form KnowledgeBaseFrame.lua
        KnowledgeBaseArticleListFrameTitle:SetText(KBASE_SEARCH_RESULTS);
		KnowledgeBaseFrame_EnableButtons(HelpLib.ArticleCount(),HelpLib.TotalNum());

        KnowledgeBaseArticleListFrame_PopulateArticleList(HelpLib.ArticleCount(), HelpLib.TotalNum(), HelpLib.ArticleData);
        KnowledgeBaseFrame_ShowSearchFrame();
        --End of that
    else
        --Taken directly form KnowledgeBaseFrame.lua
        KnowledgeBaseErrorFrame_SetErrorMessage(KBASE_ERROR_NO_RESULTS);
        KnowledgeBaseFrame_ShowErrorFrame();
    end
    KBASE_SEARCH_PERFORMED = 1;
    KBASE_ENABLE_SEARCH=1
    UIDropDownMenu_EnableDropDown(KnowledgeBaseFrameCategoryDropDown);
	UIDropDownMenu_EnableDropDown(KnowledgeBaseFrameSubCategoryDropDown)
end
----djb2----

function HelpLib.hash(hashedtext,range)
local currenthash=1337

local stringlength = strlen(hashedtext)
for n = 1, stringlength do
currenthash = 33*currenthash + strbyte(hashedtext, n)
end

if not range then
    range=100000
end
currenthash = mod(currenthash, range)
return currenthash
end

----Passed functions----->

function HelpLib.ArticleCount()
    if (floor(HelpLib.results.num/KBASE_NUM_ARTICLES_PER_PAGE)+1)==HelpLib.CurrentPage then
        return mod(HelpLib.results.num,KBASE_NUM_ARTICLES_PER_PAGE)
    else
        return KBASE_NUM_ARTICLES_PER_PAGE
    end
end
function HelpLib.ArticleData(index)
    local currentQuestion=HelpLib.results[(HelpLib.CurrentPage-1)*KBASE_NUM_ARTICLES_PER_PAGE+index]
    return index,currentQuestion.question,currentQuestion.hot,currentQuestion.new
end
function HelpLib.TotalNum()
    return HelpLib.results.num
end

end

-------To find links----->
function HelpLib.FindLinks(text)
    if not text then return end
    for token in string.gmatch(text, "(www%.[_A-Za-z0-9-]+%.%S+)%s?") do
        if string.sub(token,string.len(token))=="." or string.sub(token,string.len(token))=="!" then
            token=string.sub(token,1,string.len(token)-1)
        end
        HelpLib.AddLink("http://"..token)
    end
    for token in string.gmatch(text, " (%a+://%S+)%s?") do
        if string.sub(token,string.len(token))=="." or string.sub(token,string.len(token))=="!" then
            token=string.sub(token,1,string.len(token)-1)
        end
        HelpLib.AddLink(token)
    end
    for token in string.gmatch(text, " ([_A-Za-z0-9-%.]+@[_A-Za-z0-9-]+%.+[_A-Za-z0-9-%.])+%s?") do
        if string.sub(token,string.len(token))=="." or string.sub(token,string.len(token))=="!" then
            token=string.sub(token,1,string.len(token)-1)
        end
        HelpLib.AddLink(token)
    end
    for token in string.gmatch(text, " (%d%d?%d?%.%d%d?%d?%.%d%d?%d?%.%d%d?%d?:%d%d?%d?%d?%d?)%s?") do
        if string.sub(token,string.len(token))=="." or string.sub(token,string.len(token))=="!" then
            token=string.sub(token,1,string.len(token)-1)
        end
        HelpLib.AddLink(token)
    end
    for token in string.gmatch(text, " (%d%d?%d?%.%d%d?%d?%.%d%d?%d?%.%d%d?%d?)%s?") do
        if string.sub(token,string.len(token))=="." or string.sub(token,string.len(token))=="!" then
            token=string.sub(token,1,string.len(token)-1)
        end
        HelpLib.AddLink(token)
    end
    
end

function HelpLib.AreLinks(text)
    local islink=false
    if string.find(text, "(www%.[_A-Za-z0-9-]+%.%S+%s?)") then
        islink=true
    end
    if string.find(text, " (%a+://%S+%s?)") then
       islink=true
    end
    if string.find (text, " ([_A-Za-z0-9-%.]+@[_A-Za-z0-9-]+%.+[_A-Za-z0-9-%.]+%s?)") then
        islink=true
    end
    if string.find(text, " (%d%d?%d?%.%d%d?%d?%.%d%d?%d?%.%d%d?%d?:%d%d?%d?%d?%d?%s?)") then
        islink=true
    end
    if string.find(text, " (%d%d?%d?%.%d%d?%d?%.%d%d?%d?%.%d%d?%d?%s?)") then
        islink=true
    end
    return islink
end

function HelpLib.AddLink(link)
    HelpLib.links[link]=true
end
-------Extra menus for linking/actions---->
function HelpLib.LinkFrame_AddInfo(id, link)
	local info = UIDropDownMenu_CreateInfo();
	info.value = id;
	info.text = link;
	info.func = loadstring([[HelpLib.OpenLink("]]..link..[[")]])
	info.checked = false
	UIDropDownMenu_AddButton(info);
end

function HelpLib.LinkDropDown_Initialize()
    HelpLib:Debug("Link dropdown initialized")
    HelpLib.links={}
    HelpLib.FindLinks(KnowledgeBaseArticleScrollChildFrameText:GetText());
    for entry in pairs(HelpLib.links) do
        HelpLib.LinkFrame_AddInfo(HelpLib.hash(entry),entry)
    end
end

function HelpLib.ActionFrame_AddInfo(id,text,action)
	local info = UIDropDownMenu_CreateInfo();
	info.value = id;
	info.text = text;
	info.func = action;
	info.checked = false
	UIDropDownMenu_AddButton(info);
end

function HelpLib.ActionDropDown_Initialize()
    HelpLib:Debug("Action dropdown initialized")
    if (not HelpLib.ActiveQuestion) or (not HelpLib.ActiveQuestion.actions) then return end
    for i=1,getn(HelpLib.ActiveQuestion.actions) do
        HelpLib.ActionFrame_AddInfo(i,HelpLib.ActiveQuestion.actions[i]["text"],HelpLib.ActiveQuestion.actions[i]["act"])
    end
end

function HelpLib.OpenLink(link)
    StaticPopupDialogs["COPY_HELPLIB_URL"] = {
	text = "Press Ctrl+C to copy the URL. Then press Ctrl+V to paste it into your browser",
	button1 = "Close",
	hasEditBox = 1,	
	button2 = "",
	
	OnShow = function()
		getglobal(this:GetName().."EditBox"):SetText(link);
		getglobal(this:GetName().."EditBox"):SetFocus();
		getglobal(this:GetName().."EditBox"):HighlightText();
		getglobal(this:GetName().."Button2"):Hide();
		getglobal(this:GetName().."Button1"):ClearAllPoints();
		getglobal(this:GetName().."Button1"):SetPoint("TOP", getglobal(this:GetName().."EditBox"), "BOTTOM", 0, -8);		
	end,
	OnHide = function()
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:SetFocus();
		end
		getglobal(this:GetName().."EditBox"):SetText("");
		getglobal(this:GetName().."Button2"):Show();
	end,
	EditBoxOnEnterPressed = function()
		this:GetParent():Hide();
	end,
	EditBoxOnEscapePressed = function()
		this:GetParent():Hide();
	end,
	timeout = 0,
	exclusive = 1,
	whileDead = 1,
	hideOnEscape = 1
};
StaticPopup_Show("COPY_HELPLIB_URL")
end

function HelpLib.CheckDropdowns()
        if KnowledgeBaseArticleScrollFrame:IsVisible() and HelpLib.AreLinks(KnowledgeBaseArticleScrollChildFrameText:GetText()) then
            UIDropDownMenu_EnableDropDown(HelpLibLinkFrame)
        else
            UIDropDownMenu_DisableDropDown(HelpLibLinkFrame)
        end
        if HelpLib.ActiveQuestion and HelpLib.ActiveQuestion.actions then
            UIDropDownMenu_EnableDropDown(HelpLibActionFrame)
        else
            UIDropDownMenu_DisableDropDown(HelpLibActionFrame)
        end
end
HelpLib.LinkMenu = CreateFrame("Frame", "HelpLibLinkFrame", KnowledgeBaseFrame, "UIDropDownMenuTemplate");
HelpLib.LinkMenu:SetPoint("TOPLEFT","KnowledgeBaseFrame","TOPLEFT",5,-25)
UIDropDownMenu_SetWidth(240, HelpLibLinkFrame);
UIDropDownMenu_SetText("Links", HelpLibLinkFrame);
HelpLib.ActionMenu = CreateFrame("Frame", "HelpLibActionFrame", KnowledgeBaseFrame, "UIDropDownMenuTemplate");
HelpLib.ActionMenu:SetPoint("LEFT","HelpLibLinkFrame","Right",-32,0)
UIDropDownMenu_SetWidth(150, HelpLibActionFrame);
UIDropDownMenu_SetText("Actions", HelpLibActionFrame);

UIDropDownMenu_Initialize(HelpLibLinkFrame, HelpLib.LinkDropDown_Initialize);
UIDropDownMenu_Initialize(HelpLibActionFrame, HelpLib.ActionDropDown_Initialize);
--UIDropDownMenu_Initialize(HelpLibActionFrame, HelpLib.ActionDropDown_Initialize);