﻿local LS = AceLibrary("AceLocale-2.2"):new("Historian-Shared");

LS:RegisterTranslations("zhCN", function() return {
	-- Slash commands
	["CMD_GUI_TITLE"] = "显示图形界面",
	["CMD_GUI_DESC"] = "显示/关闭Historian图形界面窗口。",
		
	["CMD_SHOWTOOLTIP_TITLE"] = "显示敌人信息",
	["CMD_SHOWTOOLTIP_DESC"] = "当你鼠标指向已知的敌人时显示一系列信息。",
		
	["CMD_COUNTPARTYKILLS_TITLE"] = "包含队友击杀",
	["CMD_COUNTPARTYKILLS_DESC"] = "如果启用，你的队友所造成的击杀也算在你的击杀统计范围内。",
	
	["CMD_COUNTINSTANCEKILLS_TITLE"] = "包含全部击杀",
	["CMD_COUNTINSTANCEKILLS_DESC"] = "如果启用，当你处于副本中时，你周围的一切击杀行为都算在你的击杀统计范围内。",

	["CMD_FIRST_USE_TITLE"] = "首次使用",
	["CMD_FIRST_USE_DESC"] = "显示本角色最初载入并使用Historian的时间。",
	
	-- Statistics
	["NOT_AVAILABLE"] = " -- ";
	
	["STAT_CATEGORY_FORTUNE"] = "财富",
	["STAT_MAX_MONEY"] = "最富有时拥有",
	
	["STAT_CATEGORY_ITEMS_LOOTED"] = "收到物品数",
	["STAT_LOOTED_COMMON"] = "普通",
	["STAT_LOOTED_UNCOMMON"] = "优良",
	["STAT_LOOTED_RARE"] = "精良",
	["STAT_LOOTED_EPIC"] = "史诗",
	["STAT_LOOTED_LEGENDARY"] = "传奇",
	["STAT_LOOTED_ARTIFACT"] = "神器",
	
	["STAT_CATEGORY_ACHIEVEMENTS"] = "成就",
	["STAT_QUESTS_COMPLETED"] = "已完成任务数",
	["STAT_RECIPES_LEARNED"] = "已学会配方数",
	["STAT_AREAS_DISCOVERED"] = "已发现区域数",
	["STAT_TOTAL_SPELLS"] = "总共施法次数",
	["STAT_TOTAL_KILLS"] = "杀死怪物次数",
	
	["STAT_CATEGORY_DISAPPOINTMENTS"] = "沮丧",
	["STAT_ENV_DROWNING"] = "溺水窒息",
	["STAT_ENV_FATIGUE"] = "游泳疲劳",
	["STAT_ENV_FALL"] = "高处摔落",
	["STAT_ENV_FIRE"] = "身上起火",
	["STAT_ENV_LAVA"] = "品尝岩浆",
	["STAT_ENV_SLIME"] = "沐浴毒液",
	["STAT_ENV_VALUE"] = "%s次 (%s伤害)",
	["STAT_ENV_VALUE_SINGLE"] = "1次 (%s伤害)",
	["STAT_DEATHS"] = "平凡死去",
	["STAT_DEATHS_VALUE"] = "%s次",
	["STAT_DEATHS_VALUE_SINGLE"] = "1次",
	
	["STAT_CATEGORY_HABITS"] = "习惯",
	["STAT_MOST_FOLLOWED"] = "尾行最多的玩家",
	["STAT_MOST_FOLLOWED_VALUE"] = "%s (%s次)",
	["STAT_MOST_FOLLOWED_VALUE_SINGLE"] = "%s (1次)",
	["STAT_FAVORITE_PREY"] = "最喜爱的猎物",
	["STAT_FAVORITE_PREY_VALUE"] = "%s (杀掉了%s只)",
	["STAT_FAVORITE_SPELL"] = "最喜欢的法术",
	["STAT_FAVORITE_SPELL_VALUE"] = "%s (施放过%s次)",
	["STAT_FOOD"] = "进食次数",
	["STAT_DRINK"] = "喝水次数",
	["STAT_FOOD_VALUE"] = "%s 次",
	["STAT_DRINK_VALUE"] = "%s 次",
	["STAT_TIPSY"] = "微醉次数",
	["STAT_TIPSY_VALUE"] = "%s 次",
	["STAT_DRUNK"] = "烂醉次数",
	["STAT_DRUNK_VALUE"] = "%s 次",
	["STAT_SMASHED"] = "酩酊大醉次数",
	["STAT_SMASHED_VALUE"] = "%s 次",
	["STAT_JUMPS"] = "跳跃次数",
	
	["STAT_CATEGORY_KILL_DETAILS"] = "击杀",
	["STAT_CATEGORY_SPELL_DETAILS"] = "法术",
	["STAT_CATEGORY_LEVEL_DETAILS"] = "等级",
	
	["STAT_KILLS_NONE"] = "自从安装了Historian以来你还没有击杀任何东西。",
	["STAT_SPELLS_NONE"] = "自从安装了Historian以来你还没有施放过任何法术。",
	["STAT_LEVELS_NONE"] = "还没有任何升级的信息。",
	["STAT_LEVEL_X"] = "%s级",
	
	-- Chat inserts
	["CHAT_INSERT_MAX_MONEY"] = "我曾拥有的最多的钱数：%s",
	["CHAT_INSERT_LOOTED_COMMON"] = "至今为止我捡过%s件白色物品。",
	["CHAT_INSERT_LOOTED_UNCOMMON"] = "至今为止我捡过%s件绿色物品。",
	["CHAT_INSERT_LOOTED_RARE"] = "至今为止我捡过%s件蓝色物品。",
	["CHAT_INSERT_LOOTED_EPIC"] = "至今为止我捡过%s件紫色物品。",
	["CHAT_INSERT_LOOTED_LEGENDARY"] = "至今为止我捡过%s件程色物品。",
	["CHAT_INSERT_LOOTED_ARTIFACT"] = "至今为止我捡过%s件红色物品。",
	["CHAT_INSERT_QUESTS_COMPLETED"] = "至今为止我完成了%s个任务。",
	["CHAT_INSERT_RECIPES_LEARNED"] = "至今为止我已经学会了%s个配方。",
	["CHAT_INSERT_AREAS_DISCOVERED"] = "至今为止我已经发现了%s个区域。",
	["CHAT_INSERT_TOTAL_SPELLS"] = "至今为止我施放过了%s次法术。",
	["CHAT_INSERT_TOTAL_KILLS"] = "至今为止我杀死了%s个怪物。",
	
	["CHAT_INSERT_ENV_DROWNING"] = "我潜水淹死过%s次，总计伤害%s点。",
	["CHAT_INSERT_ENV_FATIGUE"] = "我游泳疲劳致死过%s次，总计伤害%s点。",
	["CHAT_INSERT_ENV_FALL"] = "我从高处摔下%s次，总计伤害%s点。",
	["CHAT_INSERT_ENV_FIRE"] = "我被篝火点着%s次，总计伤害%s点。",
	["CHAT_INSERT_ENV_LAVA"] = "我进到岩浆里%s次，总计伤害%s点。",
	["CHAT_INSERT_ENV_SLIME"] = "我进到毒液里%s次，总计伤害%s点。",
	["CHAT_INSERT_DEATHS"] = "目前为止我死了%s次。",
	
	["CHAT_INSERT_MOST_FOLLOWED"] = "我已经尾行了%s整整%s次。",
	["CHAT_INSERT_FAVORITE_PREY"] = "我最爱的猎物是%s (%s次击杀)",
	["CHAT_INSERT_FAVORITE_SPELL"] = "我最爱的法术是%s (%s次施放)",
	["CHAT_INSERT_FOOD"] = "我已经进过食%s次。",
	["CHAT_INSERT_DRINK"] = "我已经喝过水%s次。",
	["CHAT_INSERT_JUMPS"] = "我跳跃过%s次。",
	["CHAT_INSERT_TIPSY"] = "我微醉过%s次。",
	["CHAT_INSERT_DRUNK"] = "我烂醉过%s次。",
	["CHAT_INSERT_SMASHED"] = "我酩酊大醉过%s次。",
} end)



local L = AceLibrary("AceLocale-2.2"):new("Historian");

L:RegisterTranslations("zhCN", function() return {
	-- Slash commands
	["SLASH-COMMANDS"] = { "/historian", "/hist", "/stats" },

	["CMD_REPORT_TITLE"] = "报告",
	["CMD_REPORT_DESC"] = "将你的角色的统计信息发送到聊天频道。",

	-- Status messages
	["MSG_IMPORT_OLD_DATA"] = "正在导入旧数据……",
	["MSG_IMPORT_COMPLETE"] = "导入完成。",

	-- Chat report
	["MSG_REPORT_HEADER"] = "----------- Historian 报告书 -----------",
	["MSG_REPORT_SEPARATOR"] = "--",
	["MSG_REPORT_NOTE"] = "提醒：你可能需要向上滚动聊天框才能看到完整的报告。使用FuBar插件的话你可以在一个图形界面里面看到这个报告。",
		

	-- Buffs
	["BUFF_FOOD"] = "进食", -- NOTE: This MUST match the name of the aura you get when you eat something
	["BUFF_DRINK"] = "喝水", -- NOTE: This MUST match the name of the aura you get when you drink something
	
	-- Tooltip
	["MSG_TOOLTIP_KILLED"] = "被你杀过%s次。",
	["MSG_TOOLTIP_KILLED_SINGLE"] = "被你杀过1次。",
	["MSG_TOOLTIP_KILLED_WITH_KB"] = "被你杀过%s次(%s次爆死)。",

	["MSG_FIRST_USE"] = "%s于%s第一次使用Historian。",
} end)



local LFu = AceLibrary("AceLocale-2.2"):new("HistorianFu");

LFu:RegisterTranslations("zhCN", function() return {
	["HINT"] = "点击一行将其插入聊天框。",
} end)