HistorianFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceDB-2.0");
local L = AceLibrary("AceLocale-2.2"):new("HistorianFu");
local LS = AceLibrary("AceLocale-2.2"):new("Historian-Shared");
local tablet = AceLibrary("Tablet-2.0");
local abacus = AceLibrary("Abacus-2.0");
local f = AceLibrary("HistorianFormatting-1.0");

local DEBUG = false;

HistorianFu:RegisterDB("HistorianFuDB");


-- *************************************
-- * Set up defaults / addon options
-- *************************************
HistorianFu.hasIcon = "Interface\\Icons\\INV_Scroll_05";
HistorianFu.hideWithoutStandby = true;
HistorianFu.tooltipHiddenWhenEmpty = true;
HistorianFu.clickableTooltip = true;


-- *************************************
-- * Properties
-- *************************************
function HistorianFu:IsShowingTooltip()
	return (Historian ~= nil) and (Historian:IsShowingTooltip());
end;
 
function HistorianFu:ToggleShowingTooltip()
	if (Historian ~= nil) then
		Historian:ToggleShowingTooltip();
		self:Update();
	end;
end;

function HistorianFu:IsCountingPartyKills()
	return (Historian ~= nil) and (Historian:IsCountingPartyKills());
end;
 
function HistorianFu:ToggleCountingPartyKills()
	if (Historian ~= nil) then
		Historian:ToggleCountingPartyKills();
		self:Update();
	end;
end;

function HistorianFu:IsCountingInstanceKills()
	return (Historian ~= nil) and (Historian:IsCountingInstanceKills());
end;
 
function HistorianFu:ToggleCountingInstanceKills()
	if (Historian ~= nil) then
		Historian:ToggleCountingInstanceKills();
		self:Update();
	end;
end;

function HistorianFu:ReportFirstUse()
	Historian:FirstUse();
end;


-- *************************************
-- * Menu options
-- *************************************
HistorianFu.OnMenuRequest = {
	type = 'group',
	args = {
		countPartyKills = {
			type = "toggle",
			name = LS["CMD_COUNTPARTYKILLS_TITLE"],
			desc = LS["CMD_COUNTPARTYKILLS_DESC"],
			get = "IsCountingPartyKills",
			set = "ToggleCountingPartyKills",
		},
		countInstanceKills = {
			type = "toggle",
			name = LS["CMD_COUNTINSTANCEKILLS_TITLE"],
			desc = LS["CMD_COUNTINSTANCEKILLS_DESC"],
			get = "IsCountingInstanceKills",
			set = "ToggleCountingInstanceKills",
		},
		showTooltip = {
			type = "toggle",
			name = LS["CMD_SHOWTOOLTIP_TITLE"],
			desc = LS["CMD_SHOWTOOLTIP_DESC"],
			get = "IsShowingTooltip",
			set = "ToggleShowingTooltip",
		},
		firstUse = {
			type = 'execute',
			name = LS["CMD_FIRST_USE_TITLE"],
			desc = LS["CMD_FIRST_USE_DESC"],
			func = "ReportFirstUse",
		},
	}
}
 

-- *************************************
-- * OnInitialize
-- *************************************
function HistorianFu:OnInitialize()
	self:RegisterEvent("Historian_Updated", "OnStatsUpdated");
end;


-- *************************************
-- * OnClick
-- *************************************
function HistorianFu:OnClick()
	Historian:ToggleWindow();
end;
 
 
-- *************************************
-- * OnStatsUpdated
-- *************************************
function HistorianFu:OnStatsUpdated()
	self:Update();
end;


-- *************************************
-- * GetEnvDamageText
-- *************************************
function HistorianFu:GetEnvDamageText(times, damage)
	local timesText = f:IntToStr(times);
	local damageText = f:IntToStr(damage);
	
	if (times == 1) then
		return string.format(LS["STAT_ENV_VALUE_SINGLE"], damageText);
	else
		return string.format(LS["STAT_ENV_VALUE"], timesText, damageText);
	end;
end;


-- *************************************
-- * GetDeathsText
-- *************************************
function HistorianFu:GetDeathsText(times)
	if (times == 1) then
		return LS["STAT_DEATHS_VALUE_SINGLE"];
	else
		return string.format(LS["STAT_DEATHS_VALUE"], f:IntToStr(times));
	end;
end;


-- *************************************
-- * GetMostFollowedText
-- *************************************
function HistorianFu:GetMostFollowedText(player, times)
	if (times == 1) then
		return string.format(LS["STAT_MOST_FOLLOWED_VALUE_SINGLE"], player);
	else
		return string.format(LS["STAT_MOST_FOLLOWED_VALUE"], player, f:IntToStr(times));
	end;
end;


-- *************************************
-- * OnTooltipUpdate
-- *************************************
function HistorianFu:OnTooltipUpdate()

	-- *******************	
	-- HANDLE CASE WHERE HISTORIAN.LUA WAS NOT LOADED
	-- *******************	

	if (Historian == nil) then
		
		local errorCategory = tablet:AddCategory(
			'text', "Error",
			'columns', 1,
			'child_textR', 1,
			'child_textG', 0,
			'child_textB', 0,
			'child_text2R', 1,
			'child_text2G', 1,
			'child_text2B', 1
		)

		errorCategory:AddLine(
			'text', "Historian has not been loaded."
		)

		return;
	end;

	-- *******************	
	-- FORTUNE
	-- *******************	

	local moneyCategory = tablet:AddCategory(
		'text', LS["STAT_CATEGORY_FORTUNE"],
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	
	moneyCategory:AddLine(
		'text', LS["STAT_MAX_MONEY"],
		'text2', abacus:FormatMoneyFull(Historian.db.char.Loot.MostMoneyEver, true),
		'func', "InsertIntoChat",
		'arg1', self,
		'arg2', LS["CHAT_INSERT_MAX_MONEY"], 
		'arg3', abacus:FormatMoneyFull(Historian.db.char.Loot.MostMoneyEver, false)
	)
	
	
	-- *******************	
	-- ITEMS LOOTED
	-- *******************	

	local lootCategory = tablet:AddCategory(
		'text', LS["STAT_CATEGORY_ITEMS_LOOTED"],
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	
	local r,g,b = GetItemQualityColor(1);
      
	lootCategory:AddLine(
		'text', LS["STAT_LOOTED_COMMON"],
		'text2', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[1]),
		'textR', r,
		'textG', g,
    	'textB', b,
		'func', "InsertIntoChat",
		'arg1', self,
		'arg2', LS["CHAT_INSERT_LOOTED_COMMON"], 
		'arg3', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[1])
	)
	
	r,g,b = GetItemQualityColor(2);
	
	lootCategory:AddLine(
		'text', LS["STAT_LOOTED_UNCOMMON"],
		'text2', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[2]),
		'textR', r,
		'textG', g,
    	'textB', b,
		'func', "InsertIntoChat",
		'arg1', self,
		'arg2', LS["CHAT_INSERT_LOOTED_UNCOMMON"], 
		'arg3', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[2])
	)
	
	r,g,b = GetItemQualityColor(3);
	
	lootCategory:AddLine(
		'text', LS["STAT_LOOTED_RARE"],
		'text2', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[3]),
		'textR', r,
		'textG', g,
    	'textB', b,
		'func', "InsertIntoChat",
		'arg1', self,
		'arg2', LS["CHAT_INSERT_LOOTED_RARE"], 
		'arg3', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[3])
	)
	
	r,g,b = GetItemQualityColor(4);
	
	lootCategory:AddLine(
		'text', LS["STAT_LOOTED_EPIC"],
		'text2', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[4]),
		'textR', r,
		'textG', g,
    	'textB', b,
		'func', "InsertIntoChat",
		'arg1', self,
		'arg2', LS["CHAT_INSERT_LOOTED_EPIC"], 
		'arg3', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[4])
	)

	r,g,b = GetItemQualityColor(5);

	if (Historian.db.char.Loot.ItemsOfQuality[5] > 0) or DEBUG then
		lootCategory:AddLine(
			'text', LS["STAT_LOOTED_LEGENDARY"],
			'text2', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[5]),
			'textR', r,
			'textG', g,
			'textB', b,
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_LOOTED_LEGENDARY"], 
			'arg3', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[5])
		)
	end;
	
	r,g,b = GetItemQualityColor(6);
	
	if (Historian.db.char.Loot.ItemsOfQuality[6] > 0) or DEBUG then
		lootCategory:AddLine(
			'text', LS["STAT_LOOTED_ARTIFACT"],
			'text2', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[6]),
			'textR', r,
			'textG', g,
			'textB', b,
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_LOOTED_ARTIFACT"], 
			'arg3', f:IntToStr(Historian.db.char.Loot.ItemsOfQuality[6])
		)
	end;	
	
	-- *******************	
	-- ACHIEVEMENTS
	-- *******************	

	local achievementsCategory = tablet:AddCategory(
		'text', LS["STAT_CATEGORY_ACHIEVEMENTS"],
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	
	achievementsCategory:AddLine(
		'text', LS["STAT_QUESTS_COMPLETED"],
		'text2', f:IntToStr(Historian.db.char.Advancement.QuestsCompleted),
		'func', "InsertIntoChat",
		'arg1', self,
		'arg2', LS["CHAT_INSERT_QUESTS_COMPLETED"], 
		'arg3', f:IntToStr(Historian.db.char.Advancement.QuestsCompleted)
	)
	
	achievementsCategory:AddLine(
		'text', LS["STAT_RECIPES_LEARNED"],
		'text2', f:IntToStr(Historian.db.char.Advancement.RecipesLearned),
		'func', "InsertIntoChat",
		'arg1', self,
		'arg2', LS["CHAT_INSERT_RECIPES_LEARNED"], 
		'arg3', f:IntToStr(Historian.db.char.Advancement.RecipesLearned)
	)
	
	achievementsCategory:AddLine(
		'text', LS["STAT_AREAS_DISCOVERED"],
		'text2', f:IntToStr(Historian.db.char.Discoveries.Areas),
		'func', "InsertIntoChat",
		'arg1', self,
		'arg2', LS["CHAT_INSERT_AREAS_DISCOVERED"], 
		'arg3', f:IntToStr(Historian.db.char.Discoveries.Areas)
	)
	
	achievementsCategory:AddLine(
		'text', LS["STAT_TOTAL_KILLS"],
		'text2', f:IntToStr(Historian.db.char.Kills.Total),
		'func', "InsertIntoChat",
		'arg1', self,
		'arg2', LS["CHAT_INSERT_TOTAL_KILLS"], 
		'arg3', f:IntToStr(Historian.db.char.Kills.Total)
	)
	
	

	-- *******************	
	-- DISAPPOINTMENTS
	-- *******************	

	local disappointmentsCategory = tablet:AddCategory(
		'text', LS["STAT_CATEGORY_DISAPPOINTMENTS"],
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)
	
	if (f:AsNumber(Historian.db.char.EnvironmentalDamage.Drowning.Times) > 0) or DEBUG then
		disappointmentsCategory:AddLine(
			'text', LS["STAT_ENV_DROWNING"],
			'text2', self:GetEnvDamageText(Historian.db.char.EnvironmentalDamage.Drowning.Times, Historian.db.char.EnvironmentalDamage.Drowning.TotalDamage),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_ENV_DROWNING"], 
			'arg3', f:IntToStr(Historian.db.char.EnvironmentalDamage.Drowning.Times), 
			'arg4', f:IntToStr(Historian.db.char.EnvironmentalDamage.Drowning.TotalDamage)
		)
	end;
	
	if (f:AsNumber(Historian.db.char.EnvironmentalDamage.Fatique.Times) > 0) or DEBUG then
		disappointmentsCategory:AddLine(
			'text', LS["STAT_ENV_FATIGUE"],
			'text2', self:GetEnvDamageText(Historian.db.char.EnvironmentalDamage.Fatique.Times, Historian.db.char.EnvironmentalDamage.Fatique.TotalDamage),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_ENV_FATIGUE"], 
			'arg3', f:IntToStr(Historian.db.char.EnvironmentalDamage.Fatique.Times), 
			'arg4', f:IntToStr(Historian.db.char.EnvironmentalDamage.Fatique.TotalDamage)
		)
	end;
	
	if (f:AsNumber(Historian.db.char.EnvironmentalDamage.Falling.Times) > 0) or DEBUG then
		disappointmentsCategory:AddLine(
			'text', LS["STAT_ENV_FALL"],
			'text2', self:GetEnvDamageText(Historian.db.char.EnvironmentalDamage.Falling.Times, Historian.db.char.EnvironmentalDamage.Falling.TotalDamage),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_ENV_FALL"], 
			'arg3', f:IntToStr(Historian.db.char.EnvironmentalDamage.Falling.Times), 
			'arg4', f:IntToStr(Historian.db.char.EnvironmentalDamage.Falling.TotalDamage)
		)
	end;
	
	if (f:AsNumber(Historian.db.char.EnvironmentalDamage.Fire.Times) > 0) or DEBUG then
		disappointmentsCategory:AddLine(
			'text', LS["STAT_ENV_FIRE"],
			'text2', self:GetEnvDamageText(Historian.db.char.EnvironmentalDamage.Fire.Times, Historian.db.char.EnvironmentalDamage.Fire.TotalDamage),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_ENV_FIRE"], 
			'arg3', f:IntToStr(Historian.db.char.EnvironmentalDamage.Fire.Times), 
			'arg4', f:IntToStr(Historian.db.char.EnvironmentalDamage.Fire.TotalDamage)
		)
	end;
	
	if (f:AsNumber(Historian.db.char.EnvironmentalDamage.Lava.Times) > 0) or DEBUG then
		disappointmentsCategory:AddLine(
			'text', LS["STAT_ENV_LAVA"],
			'text2', self:GetEnvDamageText(Historian.db.char.EnvironmentalDamage.Lava.Times, Historian.db.char.EnvironmentalDamage.Lava.TotalDamage),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_ENV_LAVA"], 
			'arg3', f:IntToStr(Historian.db.char.EnvironmentalDamage.Lava.Times), 
			'arg4', f:IntToStr(Historian.db.char.EnvironmentalDamage.Lava.TotalDamage)
		)
	end;
		
	if (f:AsNumber(Historian.db.char.EnvironmentalDamage.Slime.Times) > 0) or DEBUG then
		disappointmentsCategory:AddLine(
			'text', LS["STAT_ENV_SLIME"],
			'text2', self:GetEnvDamageText(Historian.db.char.EnvironmentalDamage.Slime.Times, Historian.db.char.EnvironmentalDamage.Slime.TotalDamage),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_ENV_SLIME"], 
			'arg3', f:IntToStr(Historian.db.char.EnvironmentalDamage.Slime.Times), 
			'arg4', f:IntToStr(Historian.db.char.EnvironmentalDamage.Slime.TotalDamage)
		)
	end;
	
	if (f:AsNumber(Historian.db.char.Advancement.TotalDeaths) > 0) or DEBUG then
		disappointmentsCategory:AddLine(
			'text', LS["STAT_DEATHS"],
			'text2', self:GetDeathsText(Historian.db.char.Advancement.TotalDeaths),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_DEATHS"], 
			'arg3', f:IntToStr(Historian.db.char.Advancement.TotalDeaths)
		)
	end;	
	
	-- *******************	
	-- HABITS
	-- *******************	

	local habitsCategory = tablet:AddCategory(
		'text', LS["STAT_CATEGORY_HABITS"],
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0,
		'child_text2R', 1,
		'child_text2G', 1,
		'child_text2B', 1
	)

	if (Historian.db.char.Follow.MostFollowed.Count > 0) or DEBUG then
		habitsCategory:AddLine(
			'text', LS["STAT_MOST_FOLLOWED"],
			'text2', self:GetMostFollowedText(Historian.db.char.Follow.MostFollowed.Name, Historian.db.char.Follow.MostFollowed.Count),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_MOST_FOLLOWED"], 
			'arg3', Historian.db.char.Follow.MostFollowed.Name, 
			'arg4', f:IntToStr(Historian.db.char.Follow.MostFollowed.Count)
		)
	end;
	
	if (Historian.db.char.Kills.Favorite.Count > 0) or DEBUG then
		habitsCategory:AddLine(
			'text', LS["STAT_FAVORITE_PREY"],
			'text2', string.format(LS["STAT_FAVORITE_PREY_VALUE"], Historian.db.char.Kills.Favorite.Name, f:IntToStr(Historian.db.char.Kills.Favorite.Count)),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_FAVORITE_PREY"], 
			'arg3', Historian.db.char.Kills.Favorite.Name, 
			'arg4', f:IntToStr(Historian.db.char.Kills.Favorite.Count)
		)
	end;

	if (Historian.db.char.Spells.Favorite.Count > 0) or DEBUG then
		habitsCategory:AddLine(
			'text', LS["STAT_FAVORITE_SPELL"],
			'text2', string.format(LS["STAT_FAVORITE_SPELL_VALUE"], Historian.db.char.Spells.Favorite.Name, f:IntToStr(Historian.db.char.Spells.Favorite.Count)),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_FAVORITE_SPELL"], 
			'arg3', Historian.db.char.Spells.Favorite.Name, 
			'arg4', f:IntToStr(Historian.db.char.Spells.Favorite.Count)
		)
	end;

	if (Historian.db.char.Spells.Total > 0) or DEBUG then
		habitsCategory:AddLine(
			'text', LS["STAT_TOTAL_SPELLS"],
			'text2', f:IntToStr(Historian.db.char.Spells.Total),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_TOTAL_SPELLS"], 
			'arg3', f:IntToStr(Historian.db.char.Spells.Total)
		)
	end;
	
	habitsCategory:AddLine(
			'text', LS["STAT_FOOD"],
			'text2', string.format(LS["STAT_FOOD_VALUE"], f:IntToStr(Historian.db.char.Consumption.Food)),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_FOOD"], 
			'arg3', f:IntToStr(Historian.db.char.Consumption.Food)
		)

	habitsCategory:AddLine(
			'text', LS["STAT_DRINK"],
			'text2', string.format(LS["STAT_DRINK_VALUE"], f:IntToStr(Historian.db.char.Consumption.Drink)),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_DRINK"], 
			'arg3', f:IntToStr(Historian.db.char.Consumption.Drink)
		)

	if (Historian.db.char.Consumption.Tipsy > 0) or DEBUG then
		habitsCategory:AddLine(
			'text', LS["STAT_TIPSY"],
			'text2', string.format(LS["STAT_TIPSY_VALUE"], f:IntToStr(Historian.db.char.Consumption.Tipsy)),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_TIPSY"], 
			'arg3', Historian.db.char.Consumption.Tipsy
		)
	end;

	if (Historian.db.char.Consumption.Drunk > 0) or DEBUG then
		habitsCategory:AddLine(
			'text', LS["STAT_DRUNK"],
			'text2', string.format(LS["STAT_DRUNK_VALUE"], f:IntToStr(Historian.db.char.Consumption.Drunk)),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_DRUNK"], 
			'arg3', Historian.db.char.Consumption.Drunk
		)
	end;

	if (Historian.db.char.Consumption.Smashed > 0) or DEBUG then
		habitsCategory:AddLine(
			'text', LS["STAT_SMASHED"],
			'text2', string.format(LS["STAT_SMASHED_VALUE"], f:IntToStr(Historian.db.char.Consumption.Smashed)),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_SMASHED"], 
			'arg3', Historian.db.char.Consumption.Smashed
		)
	end;

	habitsCategory:AddLine(
			'text', LS["STAT_JUMPS"],
			'text2', f:IntToStr(Historian.db.char.Jumps),
			'func', "InsertIntoChat",
			'arg1', self,
			'arg2', LS["CHAT_INSERT_JUMPS"], 
			'arg3', f:IntToStr(Historian.db.char.Jumps)
		)

	tablet:SetHint(L["HINT"]);
end;



-- *************************************
-- * InsertIntoChat
-- *************************************
function HistorianFu:InsertIntoChat(...)
	if (ChatFrameEditBox == nil) then 
		return; 
	end;
	
	if not ChatFrameEditBox:IsVisible() then 
		ChatFrameEditBox:Show();
	end;
	
	ChatFrameEditBox:Insert(string.format(...) .." ");
end;