local MAJOR_VERSION = "HistorianFormatting-1.0";
local MINOR_VERSION = 1;


if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end;
if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end;

local THOUSAND_SEPARATOR = ",";


local HistorianFormatting = {};


-- *************************************
-- * IntToStr
-- * Formats a number as a string (incl. thousand separators)
-- *************************************
function HistorianFormatting:IntToStr(amount)
	local negative = false;
	
	local amount = self:AsNumber(amount);
	
	if (amount < 0) then 
		amount = 0 - amount;
		negative = true;
	end;
	
	local s = string.format("%d", math.floor(amount));
	local pos = string.len(s) % 3;
	
	if (pos == 0) then pos = 3 end;
	
	local result = string.sub(s, 1, pos) .. string.gsub(string.sub(s, pos + 1), "(...)", THOUSAND_SEPARATOR .. "%1");
	
	if (negative) then
		return "-" .. result;
	else
		return result;
	end;
end;


-- *************************************
-- * AsNumber
-- * Converts a value to a number. A nil value becomes 0.
-- *************************************
function HistorianFormatting:AsNumber(value)
	local result = tonumber(value);
	if (result == nil) then return 0; end;
	return result;
end;



AceLibrary:Register(HistorianFormatting, MAJOR_VERSION, MINOR_VERSION)
