﻿--[[

Author: Sheppe Pharis aka Critters
Version: 1.0.4

Notes:
	Hides the standard experience bar. This is useful for use in conjunction with addons like Basic Experience Bar.
]]

function HideXpBar_OnEvent()
	MainMenuExpBar:Hide();
end

function HideXpBar_ShowMessage(msg)
	if(DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage(msg);
	end
end

-- Create a "virtual" frame to catch the events we need. It doesn't need to display anything, so that's
-- why I'm creating it here instead of in an XML file.
local frame = CreateFrame("Frame");
frame:SetScript("OnEvent", HideXpBar_OnEvent);

-- A hack work around to keep the xp bar hidden. Blizz likes to display it in several events
-- and I don't want to track them all down. 
frame:RegisterEvent("PLAYER_XP_UPDATE");

-- The above event doesn't handle the situation when the player levels up, so....
-- frame:RegisterEvent("PLAYER_LEVEL_UP");

-- Trap the zone changed events because Blizz re-displays the experience bar then too.
frame:RegisterEvent("ZONE_CHANGED");
frame:RegisterEvent("ZONE_CHANGED_NEW_AREA");

-- Indicate the addon loaded.
HideXpBar_ShowMessage("HideXpBar Loaded");