local AddOn = "HideBorders"

local function log(msg) DEFAULT_CHAT_FRAME:AddMessage(msg) end -- alias for convenience

local Table = {
	["Nameplates"] = {},
	}


local function UpdateObjects(hp)
	frame = hp:GetParent()
	local hpborder, cbborder, cbicon, overlay, oldname, level, bossicon, raidicon = frame:GetRegions()
	--local overlayRegion, castBarOverlayRegion, spellIconRegion, highlightRegion, nameTextRegion, bossIconRegion, levelTextRegion, raidIconRegion = frame:GetRegions()
	local name = oldname:GetText()
	
	overlay:SetAlpha(1) 
	hpborder:Hide() -- frame border that you wanted to hide
	hpborder:SetAlpha(0) -- idk if necessary or not, let it be
	oldname:Show() -- controls if name is shown
	level:Show() -- controls if level is shown
	hp:SetAlpha(1) -- alpha of hp, 1 = 100%
	raidicon:Hide()		
	
end


local function SkinObjects(frame)
	local HealthBar, CastBar = frame:GetChildren()
	--local threat, hpborder, cbshield, cbborder, cbicon, overlay, oldname, level, bossicon, raidicon, elite = frame:GetRegions()
	local overlayRegion, castBarOverlayRegion, spellIconRegion, highlightRegion, nameTextRegion, bossIconRegion, levelTextRegion, raidIconRegion = frame:GetRegions()

	HealthBar:SetScript("OnShow", UpdateObjects)
	HealthBar:SetScript("OnSizeChanged", UpdateObjects)

	UpdateObjects(HealthBar)
	Table["Nameplates"][frame] = true
end

local select = select
local function HookFrames(...)
	for index = 1, select('#', ...) do
		local frame = select(index, ...)
		local region = frame:GetRegions()
		if ( not Table["Nameplates"][frame] and not frame:GetName() and region and region:GetObjectType() == "Texture" and region:GetTexture() == "Interface\\Tooltips\\Nameplate-Border" ) then
			SkinObjects(frame)						
			frame.region = region
		end
	end
end

local Frame = CreateFrame("Frame")
Frame:RegisterEvent("PLAYER_ENTERING_WORLD")
Frame:SetScript("OnUpdate", function(self, elapsed)
	if ( WorldFrame:GetNumChildren() ~= numChildren ) then
		numChildren = WorldFrame:GetNumChildren()
		HookFrames(WorldFrame:GetChildren())		
	end
end)
Frame:SetScript("OnEvent", function(self, event, name) 
	if ( event == "PLAYER_ENTERING_WORLD" ) then
		if ( not _G[AddOn .. "_PlayerEnteredWorld"] ) then
			DEFAULT_CHAT_FRAME:AddMessage("|cff00ccff" .. AddOn .. "|cffffffff Loaded")
			_G[AddOn .. "_PlayerEnteredWorld"] = true
		end	
	end
end)