-------------------------------------------------------- 
-- Addon Information
--------------------------------------------------------

-- Addon        : HelpMeSheep
-- Author       : Warcrazy of Nathrezim
-- Game Version : 20400 (2.4.3)
-- Version      : 1.93
-- Libraries    : LibStub, LibBars-1.0, CallBackHandler-3.0

--------------------------------------------------------
-- Library Embeds
--------------------------------------------------------

HelpMeSheep = {}

LibStub("LibBars-1.0"):Embed(HelpMeSheep)
local bars = LibStub("LibBars-1.0")
local media = LibStub("LibSharedMedia-3.0")
local mod = HelpMeSheep

--------------------------------------------------------
-- Saved Variables
--------------------------------------------------------

-- Used for reference, overridden at  run time

HMSVarTable = {InstanceRaid, LoadConfirm, LoadOnDemand,
SheepWithSelect, StopCasting, Tooltip, DefaultFrame, NoBoarder, BreakZoneText, BreakYell,
BreakRaid_Warning, BreakParty, BreakRaid, BreakSay, BreakChat, SheepType,
TargetSelectParty, LoadInArenas, TargetSelectRaid, TargetSelectSay, TargetSelectRaid_Warning,
TargetSelectYell, TargetSelectChat, TargetSelectZoneText, DoTAppliedSay, DoTAppliedRaid,
DoTAppliedParty, DoTAppliedChat, DoTAppliedRaid_Warning, DoTAppliedYell, DoTAppliedZoneText, CastFailParty,
CastFailRaid, CastFailSay, CastFailChat, CastFailRaid_Warning, CastFailYell, CastFailZoneText, CastSuccessParty,
CastSuccessRaid, CastSuccessSay, CastSuccessChat, CastSuccessRaid_Warning, CastSuccessYell, CastSuccessZoneText,
PlayerDiesParty, PlayerDiesRaid, PlayerDiesSay, PlayerDiesChat, PlayerDiesRaid_Warning, PlayerDiesYell, PlayerDiesZoneText, 
ShowTimer=1, SheepTimerBarSize={["x"]=400, ["y"]=30}, SheepTimerBarColor = {r, g, b, opac}, TimerPos = {Point, RelativeTo, RelativePoint, X, Y},
Messages = {DoTMessage, BreakMessage, SuccessMessage, FailMessage, PlayerDiesMessage, SelectMessage}, ShowTimerText=1, ShowTimerIcon="Interface\\icons\\Spell_Nature_Polymorph.blp" }		

--------------------------------------------------------
-- File Constants
--------------------------------------------------------

local ADDON_NAME             = "HelpMeSheep"
local AUTHOR                 = "Warcrazy" 							

local POLYMORPH_DEBUFF       = "Polymorph"

local SHEEP_SPELL            = "Polymorph"
local PIG_SPELL              = "Polymorph(Rank 1: pig)"
local TURTLE_SPELL           = "Polymorph(Rank 1: turtle)"

local RANGE_UPDATE_INTERVAL  = 0.5
local REFRESH_DELAY_INTERVAL = 0.5

local SHEEP_ICON_FILE        = "Interface\\icons\\Spell_Nature_Polymorph.blp"
	

--------------------------------------------------------
-- File Locals
--------------------------------------------------------

local VersionNumber="1.93"


-- Art Files
local ArtFiles = {
["TooltipBGFile"] = "Interface/Tooltips/ChatBubble-Background",
["TooltipEdgeFile"] = "Interface/Tooltips/UI-Tooltip-Border",
["DefaultBGFile"] = "Interface/DialogFrame/UI-DialogBox-Background",
["DefaultEdgeFile"] = "Interface/DialogFrame/UI-DialogBox-Border"}

local frames = {"HelpMeSheepMainFrame", "HelpMeSheepOptions", "HelpMeSheepMessageFrame", "HelpMeSheepBarConfigFrame"}

local messageDefaults = {
	DoTMessage = "A DoT has been placed on *Player*'s Sheep Target *SheepInfo*", 
	BreakMessage = "*Player*'s Sheep*SheepInfo* was broken by *BreakSource*", 
	SuccessMessage = "*SheepInfo* Successfully Sheeped",
	FailMessage = "*Player*'s sheep cast has failed! (*MissType*)",
	PlayerDiesMessage = "*Player* Has Died!!! *Player* Was Sheeping *SheepInfo* - This Target Will Remain Sheeped for *TimeLeft* More Seconds! - ",
	SelectMessage = "*SheepInfo* is now *Player*'s Sheep Target"
	}

local timeLeftMessage
local missType, breakSource
local messageExt
local dotTable = {}
local dotApplied=false
local dotCount=0
local maxSheepTime=50
local macroTextSuffix, macroTextPrefix
local midSheepTimeUpper, MidSheepTimeLower, Time
local playerName=UnitName("player")
local sheepIcon, sheepTarget, sheepTargetGUID
local realChannelNames = {[1]="Party", [2]="Raid", [3]="Yell", [4]="Say",[5]="Raid_Warning"}
local newTime
local toggle


local SheepTimeRefreshFrame = CreateFrame("Frame")
SheepTimeRefreshFrame:Hide()
SheepTimeRefreshFrame:SetScript("OnUpdate", SheepTimeRefreshFrame_OnUpdate)

--------------------------------------------------------
-- Binding Globals
--------------------------------------------------------

BINDING_HEADER_HELPMESHEEP = ADDON_NAME
setglobal("BINDING_NAME_CLICK HelpMeSheepMainFrameSelectButton:LeftButton", "Select Target")
setglobal("BINDING_NAME_CLICK HelpMeSheepMainFrameSheepTargetButton:LeftButton", "Sheep Target")


--------------------------------------------------------
-- Error Handler
--------------------------------------------------------

function HelpMeSheep_Error(error, addInfo)

	if (error) and (addInfo) then	

		DEFAULT_CHAT_FRAME:AddMessage("HelpMeSheep - ["..Error.."] : "..AddInfo)

	end


end

--------------------------------------------------------
-- Sheep Time Stamp
--------------------------------------------------------

function HelpMeSheep_TimeStamp()

	local time

	for debuffIndex = 1,40 do 
		if UnitDebuff("focus", debuffIndex) == POLYMORPH_DEBUFF then
			_,_,_,_,_,_,time = UnitDebuff("focus", debuffIndex) 
		end
	end	

	if (time) then 
		return time
	else
		return false
	end
	
end

--------------------------------------------------------
-- Custom Message Popup
--------------------------------------------------------

local messageExt
local popupVisible

function HelpMeSheep_CustomMessage(message)


	if popupVisible then

		return;

	else
	
		popupVisible = true

	end

	messageExt = message
	StaticPopupDialogs["HELPMESHEEP_POPUP1"].text = "Please enter your text for the "..string.gsub(messageExt, "Message", " Message").." message below"
	StaticPopup_Show ("HELPMESHEEP_POPUP1");

end


StaticPopupDialogs["HELPMESHEEP_POPUP1"] = {
  text =  "",
  hasEditBox = 1,
  hasWideEditBox = 1,
  button1 = "OK",
  button2 = "Default",
  button3 = "Cancel",
  OnAccept = function()

     	HMSVarTable.Messages[messageExt] = _G[this:GetParent():GetName().."WideEditBox"]:GetText()

  end,
  OnCancel = function()

	HMSVarTable.Messages[messageExt] = messageDefaults[messageExt]

  end,
  OnShow = function()
	
	if not HMSVarTable.Messages then 

		HMSVarTable.Messages = {}
		HMSVarTable.Messages[messageExt] = messageDefaults[messageExt]

	elseif not HMSVarTable.Messages[messageExt] then

		HMSVarTable.Messages[messageExt] = messageDefaults[messageExt]

	end

	
	_G[this:GetName().."WideEditBox"]:SetText(HMSVarTable.Messages[messageExt])
	_G[this:GetName().."WideEditBox"]:SetCursorPosition(0)

  end,
  OnHide = function()

	popupVisible = nil

  end,
  timeout = 0,
  whileDead = 1,
  hideOnEscape = 1
};


--------------------------------------------------------
-- Message Handler
--------------------------------------------------------
local function Message_Handler(varName, tableExt)

	local message

	local sheepTargetInfo = "("..sheepTarget..")("..sheepIcon..")"

	if not missType then missType = "[none]" end
	if not timeLeftMessage then timeLeftMessage = "[none]" end
	if not breakSource then breakSource = "Duration" end
	

	if not HMSVarTable.Messages or not HMSVarTable.Messages[tableExt] then 

		message = messageDefaults[tableExt]

	else

		message = HMSVarTable.Messages[tableExt]
		
	end

	message = string.gsub(message, "*SheepInfo*", sheepTargetInfo)
	message = string.gsub(message, "*Player*", playerName)
	message = string.gsub(message, "*MissType*", missType)
	message = string.gsub(message, "*TimeLeft*", timeLeftMessage)
	message = string.gsub(message, "*BreakSource*", breakSource)
	message = string.gsub(message, "*", "")


	for index, value in ipairs(realChannelNames) do
		if HMSVarTable[varName..value]==1 then SendChatMessage(message, strupper(value)) end 
	end
	if HMSVarTable[varName.."Chat"]==1 then
		DEFAULT_CHAT_FRAME:AddMessage(message)
	end
	if HMSVarTable[varName.."ZoneText"]==1 then
		ZoneTextString:SetText(message);
		ZoneTextFrame.startTime=GetTime()
		ZoneTextFrame.fadeInTime=0
		ZoneTextFrame.holdTime=1
		ZoneTextFrame.fadeOutTime=2
		ZoneTextString:SetTextColor(0, 1, 0);
		ZoneTextFrame:Show()
		PVPInfoTextString:SetText("");	
	end

	breakSource = nil
	missTyppe = nil
	timeLeftMessage = nil


end

--------------------------------------------------------
-- Resize Function
--------------------------------------------------------

function HelpMeSheepDimensionValueChanged(self, dimension)

	if HMSVarTable.ShowTimerText then
		local timerText = SheepTimerBar.label:GetText()
	else
		local timerText = nil
	end

	HMSVarTable.SheepTimerBarSize[dimension] = self:GetValue()

	SheepTimerBar = HelpMeSheep:NewTimerBar("SheepTimerBar", timerText, 300, 300, HMSVarTable.ShowTimerIcon, 1, HMSVarTable.SheepTimerBarSize.x, HMSVarTable.SheepTimerBarSize.y)

	
end


		
--------------------------------------------------------
-- In Combat Lock Down Lock/Unlock Functions
--------------------------------------------------------

local function Frame_Lock()
	HelpMeSheepMessageFrame:Hide();
	HelpMeSheepOptions:Hide();
	HelpMeSheepMainFrameOptionsButton:Disable(true)
	HelpMeSheepMainFrameCloseButton:Disable(true)
end


local function Frame_Unlock()
	HelpMeSheepMainFrameOptionsButton:Enable(true)
	HelpMeSheepMainFrameCloseButton:Enable(true)
end

--------------------------------------------------------
-- Focus Attributes Function
--------------------------------------------------------

local function Focus_Attributes()

	if (HMSVarTable.SheepWithSelect == 1) then
		macroTextSuffix = "\n/cast "..HMSVarTable.SheepType
	else
		macroTextSuffix=""
	end
	
	if (HMSVarTable.StopCasting == 1) then
		macroTextPrefix = "/stopcasting\n"
	else
		macroTextPrefix = ""
	end
	HelpMeSheepMainFrameSheepTargetButton:SetAttribute("type1", "macro")
	HelpMeSheepMainFrameSheepTargetButton:SetAttribute("macrotext", macroTextPrefix.."/cast [target=focus] "..HMSVarTable.SheepType)
	HelpMeSheepMainFrameSelectButton:SetAttribute("type1", "macro")
	HelpMeSheepMainFrameSelectButton:SetAttribute("macrotext", "/focus"..macroTextSuffix)
end

--------------------------------------------------------
-- Color Select Functions
--------------------------------------------------------

function HelpMeSheep_ShowColorPicker(frame)
	
	frame.r = HMSVarTable.SheepTimerBarColor.r;
	frame.g = HMSVarTable.SheepTimerBarColor.g;
	frame.b = HMSVarTable.SheepTimerBarColor.b;
	frame.swatchFunc = HelpMeSheep_SetColor;
	frame.cancelFunc = HelpMeSheep_CancelColor;
	UIDropDownMenuButton_OpenColorPicker(frame);
end

function HelpMeSheep_SetColor()
	local r, g, b = ColorPickerFrame:GetColorRGB();
	HMSVarTable.SheepTimerBarColor.r = r;
	HMSVarTable.SheepTimerBarColor.g = g;
	HMSVarTable.SheepTimerBarColor.b = b;
	HelpMeSheepBarConfigFrameColorPickerButtonNormalTexture:SetVertexColor(HMSVarTable.SheepTimerBarColor.r, HMSVarTable.SheepTimerBarColor.g, HMSVarTable.SheepTimerBarColor.b);
	SheepTimerBar.texture:SetVertexColor(HMSVarTable.SheepTimerBarColor.r, HMSVarTable.SheepTimerBarColor.g, HMSVarTable.SheepTimerBarColor.b)
	
	
end

function HelpMeSheep_CancelColor()

	HMSVarTable.SheepTimerBarColor.r = HelpMeSheepBarConfigFrameColorPickerButton.r
	HMSVarTable.SheepTimerBarColor.g = HelpMeSheepBarConfigFrameColorPickerButton.g
	HMSVarTable.SheepTimerBarColor.b = HelpMeSheepBarConfigFrameColorPickerButton.b
	HelpMeSheepBarConfigFrameColorPickerButtonNormalTexture:SetVertexColor(HMSVarTable.SheepTimerBarColor.r, HMSVarTable.SheepTimerBarColor.g, HMSVarTable.SheepTimerBarColor.b);
	SheepTimerBar.texture:SetVertexColor(HMSVarTable.SheepTimerBarColor.r, HMSVarTable.SheepTimerBarColor.g, HMSVarTable.SheepTimerBarColor.b)

end


--------------------------------------------------------
-- DropDownSkins Functions
--------------------------------------------------------

function DropDownSkins_DropDown_OnLoad(self)
	UIDropDownMenu_Initialize(self, DropDownSkins_InitializeDropDown)
end

function DropDownSkins_Button_OnClick(self, button, down)
	ToggleDropDownMenu(1,nil, DropDownSkins_DropDown, self:GetName(), 0,0)
end


function DropDownSkins_InitializeDropDown(level)
	local info={}
	info.text="Skins"
	info.isTitle = 1
	UIDropDownMenu_AddButton(info)
	
	info={}
	info.text="Default Frame"
	info.IsTitle = nil
	if HMSVarTable.DefaultFrame==nil then HMSVarTable.Tooltip=false end
	info.checked=HMSVarTable.DefaultFrame
	function info.func(arg1, arg2)
		ChangeTexture_DefaultFrame()	
	end
	UIDropDownMenu_AddButton(info)
	
	info={}
	info.text="Tooltip Frame"
	if HMSVarTable.Tooltip==nil then HMSVarTable.Tooltip=false end
	info.checked=HMSVarTable.Tooltip
	function info.func(arg1, arg2)
		ChangeTexture_Tooltip()
	end
	UIDropDownMenu_AddButton(info)

	info={}
	info.text="No Boarder"
	if HMSVarTable.NoBoarder==nil then HMSVarTable.NoBoarder=false end
	info.checked=HMSVarTable.NoBoarder
	function info.func(arg1, arg2)
		ChangeTexture_NoBoarder()
	end
	UIDropDownMenu_AddButton(info)
end

--------------------------------------------------------
-- Texture Functions
--------------------------------------------------------

function ChangeTexture_NoBoarder()

	HMSVarTable.DefaultFrame=false
	HMSVarTable.Tooltip=false
	HMSVarTable.NoBoarder=true

	for index, value in pairs(frames) do

		_G[value]:SetBackdrop({bgFile=ArtFiles.TooltipBGFile,
		edgeFile="",
		tile=true, tileSize=32, edgeSize=32, insets={left=11, right=12, top=12, bottom=11} })
	end




end

function ChangeTexture_Tooltip()
	HMSVarTable.DefaultFrame=false
	HMSVarTable.NoBoarder=false
	HMSVarTable.Tooltip=true	
	
	for index, value in pairs(frames) do

		_G[value]:SetBackdrop({bgFile=ArtFiles.TooltipBGFile,
		edgeFile=ArtFiles.TooltipEdgeFile,
		tile=true, tileSize=32, edgeSize=32, insets={left=11, right=12, top=12, bottom=11} })
	end
end

function ChangeTexture_DefaultFrame()
	HMSVarTable.DefaultFrame=true
	HMSVarTable.NoBoarder=false
	HMSVarTable.Tooltip=false 
	
	for index, value in pairs(frames) do

		_G[value]:SetBackdrop({bgFile=ArtFiles.DefaultBGFile,
		edgeFile=ArtFiles.DefaultEdgeFile,
		tile=true, tileSize=32, edgeSize=32, insets={left=11, right=12, top=12, bottom=11} })

	end
	

end

--------------------------------------------------------
-- Slash Command Handler
--------------------------------------------------------

SLASH_HELPMESHEEP1="/hms"
SLASH_HELPMESHEEP2="/helpmesheep"

SlashCmdList["HELPMESHEEP"]=function(msg)
	if (msg == "show") then

		if InCombatLockdown() then

			HelpMeSheep_Error("HelpMeSheep Error", "Operation Can Not Be Completed In-Combat")
			return;

		end
		
		HelpMeSheepMainFrame:Show();
		
	elseif (msg == "hide") then 

		if InCombatLockdown() then

			HelpMeSheep_Error("HelpMeSheep Error", "Operation Can Not Be Completed In-Combat")
			return;

		end

		HelpMeSheepMainFrame:Hide();

	elseif (msg == "reset") then

		HelpMeSheepMainFrame:Show();
		HelpMeSheepMainFrame:ClearAllPoints();
		HelpMeSheepMainFrame:SetPoint("TOP", "UIParent", "TOP");

	elseif (msg == "timer") then

		if HelpMeSheepBarConfigFrame:IsVisible(true) then
			
			HelpMeSheepBarConfigFrame:Hide()
		else
			
			HelpMeSheepBarConfigFrame:Show()
		end	
	else
		DEFAULT_CHAT_FRAME:AddMessage("HelpMeSheep - Invalid Command")
		DEFAULT_CHAT_FRAME:AddMessage("/hms show - Shows Frame")
		DEFAULT_CHAT_FRAME:AddMessage("/hms hide - Hides Frame")
		DEFAULT_CHAT_FRAME:AddMessage("/hms reset - Resets Frame's Posistion")
		DEFAULT_CHAT_FRAME:AddMessage("/hms timer - Opens the Sheep Timer's Configuration Frame")
		
	end	
end

--------------------------------------------------------
-- Populate All Checkboxes
--------------------------------------------------------

local function Populate_CheckBoxes()


	-- Channel Names used for Variable Loading only; not used for sending messages
	local channelNames={[1]="Party", [2]="Raid", [3]="Yell", [4]="Say",[5]="Raid_Warning", [6]="Chat", [7]="ZoneText"}
	
	for index, value in ipairs(channelNames) do
		_G["TargetSelect"..value.."CheckButton"]:SetChecked(HMSVarTable["TargetSelect"..value])
		_G["CastSuccess"..value.."CheckButton"]:SetChecked(HMSVarTable["CastSuccess"..value])
		_G["CastFail"..value.."CheckButton"]:SetChecked(HMSVarTable["CastFail"..value])
		_G["DoTApplied"..value.."CheckButton"]:SetChecked(HMSVarTable["DoTApplied"..value])
		_G["Break"..value.."CheckButton"]:SetChecked(HMSVarTable["Break"..value])
		_G["PlayerDies"..value.."CheckButton"]:SetChecked(HMSVarTable["PlayerDies"..value])
	end
	-- Loads Checkboxes not in the Message Frame 
	HelpMeSheepOptionsShowTimerCheckButton:SetChecked(HMSVarTable["ShowTimer"])
	HelpMeSheepOptionsStopCastingCheckButton:SetChecked(HMSVarTable["StopCasting"])
	HelpMeSheepOptionsSheepWithSelectCheckButton:SetChecked(HMSVarTable["SheepWithSelect"])
	HelpMeSheepOptionsLoadConfirmCheckButton:SetChecked(HMSVarTable["LoadConfirm"])
	HelpMeSheepOptionsArenaCheckButton:SetChecked(HMSVarTable["LoadInArenas"])
	HelpMeSheepOptionsInstanceRaidCheckButton:SetChecked(HMSVarTable["InstanceRaid"])
	HelpMeSheepOptionsOnDemandCheckButton:SetChecked(HMSVarTable["LoadOnDemand"])
	
	HelpMeSheepBarConfigFrameShowIconCheckButton:SetChecked(HMSVarTable["ShowTimerIcon"])
	HelpMeSheepBarConfigFrameShowTextCheckButton:SetChecked(HMSVarTable["ShowTimerText"])

	if HMSVarTable.SheepType == PIG_SPELL then
		HelpMeSheepOptionsPigCheckButton:SetChecked(true)
	elseif HMSVarTable.SheepType == TURTLE_SPELL then
		HelpMeSheepOptionsTurtleCheckButton:SetChecked(true)
	else 
		HMSVarTable.SheepType = SHEEP_SPELL
		HelpMeSheepOptionsSheepCheckButton:SetChecked(true)	
	end
end

--------------------------------------------------------
-- HelpMeSheep Loads
--------------------------------------------------------

function MainFrame_OnLoad()
									
	if UnitClass("player")=="Mage" then

		this:RegisterEvent("VARIABLES_LOADED");
		this:RegisterEvent("PLAYER_TARGET_CHANGED");
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
		this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		this:RegisterEvent("PLAYER_REGEN_ENABLED");
		this:RegisterEvent("PLAYER_REGEN_DISABLED");
		this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
		this:RegisterEvent("PLAYER_FOCUS_CHANGED");
		this:RegisterEvent("PLAYER_DEAD");
		

		dotApplied=false
		dotCount=0
		

	else 
		HelpMeSheepMainFrame:Hide();
		HelpMeSheepMainFrame:UnregisterAllEvents();
	end
	
end

--------------------------------------------------------
-- Event Handler
--------------------------------------------------------

function MainFrame_OnEvent(self, event, ...)

	--------------------------------------------------------
	-- Variables Load
	--------------------------------------------------------


	if (event == "VARIABLES_LOADED")then

	if (HMSVarTable.Tooltip == true) then

		ChangeTexture_Tooltip()

	elseif (HMSVarTable.DefaultFrame == true) then

		ChangeTexture_DefaultFrame()

	elseif (HMSVarTable.NoBoarder == true) then

		ChangeTexture_NoBoarder()

	end
	
	
	Populate_CheckBoxes()
	
	Focus_Attributes() 

	if not HMSVarTable.SheepTimerBarColor then
			
		-- opac not currently in use

		HMSVarTable.SheepTimerBarColor = {r, g, b, opac}

		HMSVarTable.SheepTimerBarColor.r = 0.9098039215686274
		HMSVarTable.SheepTimerBarColor.g = 0.9372549019607843
		HMSVarTable.SheepTimerBarColor.b = 0.9098039215686274
		HMSVarTable.SheepTimerBarColor.opac = 1.0

	elseif not HMSVarTable.SheepTimerBarColor.r then

		HMSVarTable.SheepTimerBarColor = {r, g, b, opac}

		HMSVarTable.SheepTimerBarColor.r = 0.9098039215686274
		HMSVarTable.SheepTimerBarColor.g = 0.9372549019607843
		HMSVarTable.SheepTimerBarColor.b = 0.9098039215686274
		HMSVarTable.SheepTimerBarColor.opac = 1.0


	end

	if not HMSVarTable.SheepTimerBarSize then

		HMSVarTable.SheepTimerBarSize = {x, y}

		HMSVarTable.SheepTimerBarSize.x=100
		HMSVarTable.SheepTimerBarSize.y=20

	end

	-- Sets up the Sheep Timer Bar

	SheepTimerBar = HelpMeSheep:NewTimerBar("SheepTimerBar", "SheepTimerBar", 15, 15, HMSVarTable.ShowTimerIcon, 1, HMSVarTable.SheepTimerBarSize.x, HMSVarTable.SheepTimerBarSize.y)

	SheepTimerBar:SetScript("OnShow", SheepTimerBar_OnShow)
	SheepTimerBar:SetTexture(media:Fetch("statusbar", "Minimalist"))
	SheepTimerBar.texture:SetVertexColor(HMSVarTable.SheepTimerBarColor.r, HMSVarTable.SheepTimerBarColor.g, HMSVarTable.SheepTimerBarColor.b)
	SheepTimerBar:SetMovable(true)
	SheepTimerBar:EnableMouse(true)
	SheepTimerBar:RegisterForDrag("LeftButton")

	if HMSVarTable.TimerPos then
		if HMSVarTable.TimerPos.Point then
 			SheepTimerBar:SetPoint(HMSVarTable.TimerPos.Point, HMSVarTable.TimerPos.RelativeTo, HMSVarTable.TimerPos.RelativePoint, HMSVarTable.TimerPos.X, HMSVarTable.TimerPos.Y )
		else
			SheepTimerBar:SetPoint("CENTER")
		end
	else
		SheepTimerBar:SetPoint("CENTER")
	end

	SheepTimerBarWidthSlider:SetValue(HMSVarTable.SheepTimerBarSize.x)
	SheepTimerBarHeightSlider:SetValue(HMSVarTable.SheepTimerBarSize.y)


	SheepTimerBar:SetScript("OnMouseDown", function(self, down)

		self:StartMoving()
	
	end)

	SheepTimerBar:SetScript("OnMouseUp", function(self, up)

		self:StopMovingOrSizing()

		HMSVarTable.TimerPos = {Point, RelativeTo, RelativePoint, X, Y}
	
		HMSVarTable.TimerPos.Point, HMSVarTable.TimerPos.RelativeTo, HMSVarTable.TimerPos.RelativePoint, HMSVarTable.TimerPos.X, HMSVarTable.TimerPos.Y  = self:GetPoint(1)

	end)

	if (HMSVarTable.LoadOnDemand == 1) then
		HelpMeSheepMainFrame:Hide();
	end
		
	if (HMSVarTable.LoadConfirm == 1) then
		DEFAULT_CHAT_FRAME:AddMessage("HelpMeSheep "..VersionNumber.." Loaded") 
	end
		
	end
	if (event=="PLAYER_ENTERING_WORLD")then	
		
		SheepTimerBar:Hide()
		
		local inInstance, instanceType = IsInInstance();

		if (HMSVarTable.LoadInArenas == 1) then 
			
			if (instanceType == "arena") then
				HelpMeSheepMainFrame:Show();
				return
			else 
				HelpMeSheepMainFrame:Hide()
			end
			
		end
		if (HMSVarTable.InstanceRaid == 1) then 

			if ( (instanceType == "party") or (instanceType == "raid") ) and (instanceType == "none")==false then
				HelpMeSheepMainFrame:Show();
				return
			else 
				HelpMeSheepMainFrame:Hide()
			end	
			
		end
	end
	
	--------------------------------------------------------
	-- Combat Log Events
	--------------------------------------------------------
	if (event=="UNIT_SPELLCAST_SUCCEEDED") then

		unit, spellName, spellRank = ...

		if  (spellName == SHEEP_SPELL) then

			SheepTimeRefreshFrame:Show()
	
		end

	end


	if (event=="COMBAT_LOG_EVENT_UNFILTERED")then

	local eventType = arg2
	local sourceGUID = arg3
	local spellName = arg10
	local sourceName = arg4
	local destGUID = arg6
	local destName = arg7

		if (eventType == "SPELL_AURA_BROKEN" or eventType == "SPELL_AURA_BROKEN_SPELL") and (destGUID == sheepTargetGUID)  then

			breakSource = sourceName

		end
		if (eventType == "SPELL_PERIODIC_DAMAGE") and (destGUID == sheepTargetGUID) then

			-- Argument is returned for both Melee and Spell DoTs

			local dotName = arg10
			local dotFound
			
			if (dotApplied == false) then
				-- Sends the DoTApplied Message
				Message_Handler("DoTApplied", "DoTMessage")
			end
			-- Make sure we only count new DoTs and not old ones ticking

			for index, value in ipairs(dotTable) do
				if (value == dotName) then

					dotFound = index
					break

				else 
					dotFound=nil
				end
			end

			-- If DoT is unindexed, index it

			if (dotFound == nil) then
				table.insert(dotTable, dotName)
				dotCount = dotCount+1
			end

			dotApplied=true
		end
		if (eventType == "SPELL_AURA_REMOVED") and (destGUID == sheepTargetGUID) then

			-- If Aura Removed=DoT from sheep target, remove from dotTable

			local debuffRemoved = arg10
			local dotTableLength = #dotTable
			
			if (debuffRemoved == POLYMORPH_DEBUFF) then
				-- Sends the Sheep Break Messages
				Message_Handler("Break", "BreakMessage")
				SheepTimerBar:Hide()
			end
			
			if dotApplied==true then
				for i = 1, dotTableLength do
					if (dotTable[i] == debuffRemoved) then
						dotCount = dotCount - 1
						table.remove(dotTable, i)
						if (dotCount == 0) then
							dotApplied = false
						end
					end
				end
			end
		end
		if (eventType == "SPELL_MISSED") and (sourceName == playerName) and (spellName == SHEEP_SPELL)  then
			-- Sends Cast Fail Message
			missType = arg12
			Message_Handler("CastFail", "FailMessage")	
		end
		if (eventType == "SPELL_AURA_APPLIED") and (destGUID == sheepTargetGUID) and (spellName == SHEEP_SPELL) then

			Message_Handler("CastSuccess", "SuccessMessage")
		
			if HMSVarTable.ShowTimer then 
				-- Redundant call if bar isn't shown but necessary if bar is already shown
				SheepTimerBar:Show();
				if SheepTimerBar:IsVisible(true) then
					SheepTimerBar_OnShow();
				end
			end 
		end
		if (eventType == "UNIT_DIED") and (destGUID == sheepTargetGUID) then

			-- Clears DoTTable if Sheep Target dies

			dotTable = {}
			dotApplied = false
			dotCount = 0
			HMSSheepTargetFontString:SetVertexColor("green", 1);
			SheepTimerBar:Hide();
		end
	end
	if (event == "PLAYER_FOCUS_CHANGED") then
		
		if (UnitName("focus") == nil) then
			Clear_Sheep_Target()
		else
			Update_SheepTarget()
		end
	
	end
	if (event == "PLAYER_DEAD") then
		if (sheepTarget and ((sheepTarget == "No Sheep Target") == false)) then

			local time
		
			time = HelpMeSheep_TimeStamp()
		
			if (time) then 
				timeLeftMessage = time 
			else 
				timeLeftMessage = "[Not Available]" 
			end

			Message_Handler("PlayerDies", "PlayerDiesMessage")	

		end
	end
	if (event == "PLAYER_REGEN_DISABLED") then
		Frame_Lock()
	end
	if (event == "PLAYER_REGEN_ENABLED") then
		Frame_Unlock()
	end	

	
end

--------------------------------------------------------
-- Clear Sheep Target
--------------------------------------------------------

function Clear_Sheep_Target()

	HMSSheepTargetFontString:SetText("Sheep Target")
	HMSSheepTargetFontString:SetVertexColor(HMSSelectTargetFontString:GetTextColor())
	sheepTarget = "No Sheep Target"
	sheepTargetGUID = "No Sheep GUID"
	SheepTimerBar:Hide()

end

--------------------------------------------------------
-- Update Sheep Target
--------------------------------------------------------

function Update_SheepTarget()
	
	local sheepIconIndex

	local raidSymbols = {[1]="{Star}", [2]="{Circle}", [3]="{Diamond}", [4]="{Triangle}", 
	[5]="{Moon}", [6]="{Square}", [7]="{Cross}", [8]="{Skull}"}

	local targetGUID = UnitGUID("target")

	sheepTarget = UnitName("target")
	sheepIconIndex = GetRaidTargetIndex("target")

	for index, value in ipairs(raidSymbols) do

		if (index == sheepIconIndex) then
			sheepIcon = value
			break
		end
		
	end
	if (sheepIconIndex == nil) then 
		sheepIcon = "{No Symbol}" 
	end
	

	HMSSheepTargetFontString:SetText("Sheep "..sheepTarget.."("..sheepIcon..")");

	if not (targetGUID == sheepTargetGUID) then
		-- New sheep target, recompile DoT info
		dotTable = {}
		dotApplied = false
		dotCount = 0	

		Message_Handler("TargetSelect", "SelectMessage");		

	end

	sheepTargetGUID = UnitGUID("target")

	for debuffIndex = 1, 40 do 
		if (UnitDebuff("focus", debuffIndex) == SHEEP_DEBUFF) and (HMSVarTable.ShowTimer) then
			-- Redundant call if bar isn't shown but necessary if bar is already shown
			SheepTimerBar:Show();
			if SheepTimerBar:IsVisible(true) then
				SheepTimerBar_OnShow();
			end
			break
		else
			SheepTimerBar:Hide();
		end
	end	

end

--------------------------------------------------------
-- btnSelect's PreClick Handler
--------------------------------------------------------

function btnSelect_PreClick()


	if (UnitName("target") == nil) then	
		Clear_Sheep_Target()	
	else 
		Update_SheepTarget()
	end	
	
	
	
end

--------------------------------------------------------
-- Range Check
--------------------------------------------------------

function MainFrame_OnUpdate(self, elapsed)
local InRange=InRange

if UnitName("focus") then
	if (self.timeSinceLastRangeUpdate == nil) then self.timeSinceLastRangeUpdate=0 end
	self.timeSinceLastRangeUpdate = self.timeSinceLastRangeUpdate + elapsed
	if (self.timeSinceLastRangeUpdate > RANGE_UPDATE_INTERVAL) then
		inRange = IsSpellInRange(SHEEP_SPELL, "focus");
		if (inRange == 1) then
			if (dotApplied == false) then
				HMSSheepTargetFontString:SetVertexColor("green", 1);
			elseif (dotApplied == true) then
				HMSSheepTargetFontString:SetVertexColor(0, 0, 1);
			end
		end
		if (inRange == 0) then
			HMSSheepTargetFontString:SetVertexColor(1, 0, 0);
		end
		self.timeSinceLastRangeUpdate = 0 

	end	
end


end

--------------------------------------------------------
-- Timer Update
--------------------------------------------------------

function SheepTimeRefreshFrame_OnUpdate(self, elapsed)

	-- Gives a needed delay before the timer can be updated after a resheep

	if (self.timeSinceLastUpdate == nil) then self.timeSinceLastUpdate = 0 end

	self.timeSinceLastUpdate = self.timeSinceLastUpdate + elapsed

	if (self.timeSinceLastUpdate >= REFRESH_DELAY_INTERVAL) then

		SheepTimerBar_RenewTimer()
		self.timeSinceLastUpdate = 0
		self:Hide()


	end


end


function SheepTimerBar_RenewTimer()


	if maxSheepTime and UnitName("focus") then

		newTime = HelpMeSheep_TimeStamp()

		if (newTime and maxSheepTime) then
			SheepTimerBar:SetTimer(newTime, maxSheepTime)
		end

	end


end


function SheepTimerBar_OnShow()

	if (not HMSVarTable.ShowTimerText) and SheepTimerBar.label then

		SheepTimerBar.label:SetText("")

	end

	
	if UnitName("focus") then
		
		maxSheepTime = HelpMeSheep_TimeStamp()
				
		if (maxSheepTime) then
				
			midSheepTimeLower = maxSheepTime / 5
			midSheepTimeUpper = maxSheepTime - midSheepTimeLower
			
			if (HMSVarTable.ShowTimerText) and SheepTimerBar.label then

				SheepTimerBar.label:SetText(UnitName("focus").." Polymorphed")

			end

			SheepTimerBar:SetTimer(maxSheepTime, maxSheepTime)
			
			
		elseif (not toggle) then

			SheepTimerBar:Hide()
			
		end

	else
		
	end

	toggle = nil

end



--------------------------------------------------------
-- Handlers for Misc. Checkbox/Button Clicks
--------------------------------------------------------

-- Important, Handles all checkbox clicks in Message Frame

function Message_Frame_CheckBox_Change(varName)

	HMSVarTable[varName] = _G[varName.."CheckButton"]:GetChecked()

end

function btnClose_OnClick()
	HelpMeSheepMainFrame:Hide();
	SheepTimerBar:Hide();
end

function btnMessageFrameClose_OnClick()
	HelpMeSheepMessageFrame:Hide()
end

function btnOptions_OnClick()

	if HelpMeSheepOptions:IsVisible(true) then
		HelpMeSheepOptions:Hide();
	else
		HelpMeSheepOptions:Show();
	end
end
function btnCloseOptions_OnClick()
	if (HMSVarTable.LoadInArenas == 1) or (HMSVarTable.LoadOnDemand == 1) or (HMSVarTable.InstanceRaid == 1)  then 
		HelpMeSheepMainFrame:Hide();
		SheepTimerBar:Hide();
	end
	HelpMeSheepOptions:Hide();
end

function cxbShowTimer_OnClick()
	HMSVarTable.ShowTimer = HelpMeSheepOptionsShowTimerCheckButton:GetChecked()
end

function cxbArena_OnClick()
	HMSVarTable.LoadInArenas = HelpMeSheepOptionsArenaCheckButton:GetChecked()
	HMSVarTable.LoadOnDemand = nil 
	HelpMeSheepOptionsOnDemandCheckButton:SetChecked(HMSVarTable.LoadOnDemand)
	
end



function btnMessages_OnClick()
	if HelpMeSheepMessageFrame:IsVisible(true) then 
		HelpMeSheepMessageFrame:Hide();
	else
		HelpMeSheepMessageFrame:Show();
	end
end

function cxbShowText_OnClick(self)

	HMSVarTable.ShowTimerText = self:GetChecked()

	if HMSVarTable.ShowTimerText then

		SheepTimerBar = HelpMeSheep:NewTimerBar("SheepTimerBar", "<Drag to Move Frame>", 300, 300, HMSVarTable.ShowTimerIcon, 1, HMSVarTable.SheepTimerBarSize.x, HMSVarTable.SheepTimerBarSize.y)

	else
		
		SheepTimerBar = HelpMeSheep:NewTimerBar("SheepTimerBar", HMSVarTable.ShowTimerText, 300, 300, HMSVarTable.ShowTimerIcon, 1, HMSVarTable.SheepTimerBarSize.x, HMSVarTable.SheepTimerBarSize.y)

	end

end

function cxbShowIcon_OnClick(self)

	HMSVarTable.ShowTimerIcon = self:GetChecked()

	if HMSVarTable.ShowTimerIcon then
		HMSVarTable.ShowTimerIcon = SHEEP_ICON_FILE
	end

	if HMSVarTable.ShowTimerText then

		SheepTimerBar = HelpMeSheep:NewTimerBar("SheepTimerBar", "<Drag to Move Frame>", 300, 300, HMSVarTable.ShowTimerIcon, 1, HMSVarTable.SheepTimerBarSize.x, HMSVarTable.SheepTimerBarSize.y)

	else
		
		SheepTimerBar = HelpMeSheep:NewTimerBar("SheepTimerBar", HMSVarTable.ShowTimerText, 300, 300, HMSVarTable.ShowTimerIcon, 1, HMSVarTable.SheepTimerBarSize.x, HMSVarTable.SheepTimerBarSize.y)

	end

end

function cxbStopCasting_OnClick()
	HMSVarTable.StopCasting=HelpMeSheepOptionsStopCastingCheckButton:GetChecked()
	Focus_Attributes()
end

function cxbSheepWithSelect_OnClick()
	HMSVarTable.SheepWithSelect = HelpMeSheepOptionsSheepWithSelectCheckButton:GetChecked()
	Focus_Attributes()
end
function cxbOnDemand_OnClick()
	HMSVarTable.LoadOnDemand = HelpMeSheepOptionsOnDemandCheckButton:GetChecked()
	if (HMSVarTable.LoadOnDemand == 1) then

		HMSVarTable.LoadInArenas = nil 
		HelpMeSheepOptionsArenaCheckButton:SetChecked(LoadInArenas)
		HMSVarTable.InstanceRaid = nil
		HelpMeSheepOptionsInstanceRaidCheckButton:SetChecked(InstanceRaid)	
		
	end
end

function btnToggleTimer_OnClick()
	
	if SheepTimerBar:IsVisible(true) then 
		SheepTimerBar:Hide(); 
		HelpMeSheepBarConfigFrame:Hide()
		toggle = nil
	else 
		toggle = true
		SheepTimerBar:Show();
		HelpMeSheepBarConfigFrame:Show()
		SheepTimerBar:SetTimer(300, 300)
		
		if( HMSVarTable.ShowTimerText) and (SheepTimerBar.label) then
			SheepTimerBar.label:SetText("<Drag to Move Frame>")
		end
	end
end

function cxbInstanceRaid_OnClick()
	HMSVarTable.InstanceRaid = HelpMeSheepOptionsInstanceRaidCheckButton:GetChecked()
	HMSVarTable.LoadOnDemand = nil 
	HelpMeSheepOptionsOnDemandCheckButton:SetChecked(HMSVarTable.LoadOnDemand)
end

function cxbLoadConfirm_OnClick()
	HMSVarTable.LoadConfirm = HelpMeSheepOptionsLoadConfirmCheckButton:GetChecked()
end

function cxbSheep_OnClick()
	if HelpMeSheepOptionsSheepCheckButton:GetChecked(true) then
		HMSVarTable.SheepType = SHEEP_SPELL
		HelpMeSheepOptionsPigCheckButton:SetChecked(nil)
		HelpMeSheepOptionsTurtleCheckButton:SetChecked(nil)
	else 
		HelpMeSheepOptionsSheepCheckButton:SetChecked(true)
		HMSVarTable.SheepType = SHEEP_SPELL
	end	
	
	Focus_Attributes();
	
end

function cxbPig_OnClick()
	if HelpMeSheepOptionsPigCheckButton:GetChecked(true) then
		HMSVarTable.SheepType = PIG_SPELL
		HelpMeSheepOptionsSheepCheckButton:SetChecked(nil)
		HelpMeSheepOptionsTurtleCheckButton:SetChecked(nil)
	else 
		HelpMeSheepOptionsSheepCheckButton:SetChecked(true)
		HMSVarTable.SheepType = SHEEP_SPELL
	end
	
	Focus_Attributes();
	
end

function cxbTurtle_OnClick()
	if HelpMeSheepOptionsTurtleCheckButton:GetChecked(true) then
		HMSVarTable.SheepType = TURTLE_SPELL
		HelpMeSheepOptionsSheepCheckButton:SetChecked(nil)
		HelpMeSheepOptionsPigCheckButton:SetChecked(nil)
	else
		HelpMeSheepOptionsSheepCheckButton:SetChecked(true)
		HMSVarTable.SheepType = SHEEP_SPELL
	end
	
	Focus_Attributes();

end