--[[
  You can edit the weights for each stat on the weapon and how
  important the stat is to a certain class. Here is a list of what all
  the midifier flags are.
  
  If the flag is not listed for a class, that stat does not
  contribute to the DKP value.
  
  
  -- Main Stats --
    AGI ==> Agility
    INT ==> Intellect
    SPI ==> Spirit
    STA ==> Stamina
    STR ==> Strength

  -- Defense --
    ARMOR ==> Armor
    CR_BLOCK ==> Block rating
    CR_DEFENSE ==> Defense rating
    CR_DODGE ==> Dodge rating
    CR_PARRY ==> Parry rating
    CR_RESILIENCE ==> Resilience
  
  -- Resistances --
    ARCANERES ==> Arcane Resistance
    FIRERES ==> Fire Resistance
    FROSTRES ==> Frost Resistance
    HOLYRES ==> Holy Resistance
    NATURERES ==> Nature Resistance
    SHADOWRES ==> Shadow Resistance
  
  -- Spell Enhancements --  
    CR_SPELLCRIT ==> Critical strike with spell rating
    CR_SPELLHASTE ==> Spell haste rating
    CR_SPELLHIT ==> Hit with spell rating
    ARCANEDMG ==> Arcane Damage
    FIREDMG ==> Fire Damage
    FROSTDMG ==> Frost Damage
    HOLYDMG ==> Holy Damage
    NATUREDMG ==> Nature Damage
    SHADOWDMG ==> Shadow Damage
    DMG ==> Spell Damage
    HEAL ==> Healing    
    MANAREG ==> Mana Regeneration (mp5)
    
  -- Melee Enhancements --
    ATTACKPOWER ==> Attack Power
    ATTACKPOWERFERAL ==> Attack Power in feral form
    ATTACKPOWERUNDEAD ==> Attack Power against Undead
    RANGEDATTACKPOWER ==> Ranged Attack Power
    
    CR_CRIT ==> Critical strike rating  
    CR_HASTE ==> Haste rating
    CR_HIT ==> Hit rating
    CR_WEAPON_AXE ==> Axe skill rating
    CR_WEAPON_DAGGER ==> Dagger skill rating
    CR_WEAPON_FERAL ==> CR_WEAPON_FERAL
    CR_WEAPON_MACE ==> Mace skill rating
    CR_WEAPON_SWORD ==> Sword skill rating
    CR_WEAPON_SWORD_2H ==> Two-Handed Swords skill rating

]]--

local BC = AceLibrary("Babble-Class-2.2");
local BI = AceLibrary("Babble-Inventory-2.2");
local L = AceLibrary("AceLocale-2.2"):new("Hellbender");

HBDKPStatModifiers = {
	[L['SpellGeneric']] = {
		STA = 0.20,
		INT = 0.24,
		SPI = 0.19,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		MANAREG = 0.30,
		HEALTHREG = 0.30,
		DMG = 0.12,
		ARCANEDMG = 0.10,
    FIREDMG = 0.10,
    FROSTDMG = 0.10,
    NATUREDMG = 0.10,
    SHADOWDMG = 0.10,
    DMGUNDEAD = 0.10,
    HOLYDMG = 0.10,
		HEAL = 0.025,
		CR_SPELLCRIT = 0.2,
		CR_SPELLHIT = 0.25,
		STR = 0.13,
		SPELLPEN = 0.15,
	},
	[BC['Mage']] = {
		STA = 0.18,
		INT = 0.25,
		SPI = 0.17,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		MANAREG = 0.30,
		HEALTHREG = 0.15,
		DMG = 0.15,
		ARCANEDMG = 0.10,
    FIREDMG = 0.10,
    FROSTDMG = 0.10,
    NATUREDMG = 0.10,
    SHADOWDMG = 0.10,
    DMGUNDEAD = 0.10,
    HOLYDMG = 0.10,
		CR_SPELLCRIT = 0.215,
		CR_SPELLHIT = 0.25,
		SPELLPEN = 0.15,
	},
	[BC['Warlock']] = {
		STA = 0.25,
		INT = 0.20,
		SPI = 0.15,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		MANAREG = 0.25,
		HEALTHREG = 0.50,
		DMG = 0.15,
		ARCANEDMG = 0.10,
    FIREDMG = 0.10,
    FROSTDMG = 0.10,
    NATUREDMG = 0.10,
    SHADOWDMG = 0.10,
    DMGUNDEAD = 0.10,
    HOLYDMG = 0.10,
		CR_SPELLCRIT = 0.215,
		CR_SPELLHIT = 0.25,
		SPELLPEN = 0.15,
		HEAL = 0.0,
	},
	[BC['Priest']] = {
		STA = 0.15,
		INT = 0.25,
		SPI = 0.22,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		MANAREG = 0.37,
		HEALTHREG = 0.20,
		DMG = 0.13,
		ARCANEDMG = 0.13,
    FIREDMG = 0.13,
    FROSTDMG = 0.13,
    NATUREDMG = 0.13,
    SHADOWDMG = 0.13,
    DMGUNDEAD = 0.13,
    HOLYDMG = 0.13,
		HEAL = 0.08,
		CR_SPELLCRIT = 0.08,
		CR_SPELLHIT = 0.05,
		SPELLPEN = 0.10,
	},
	[BC['Druid']] = {
		STA = 0.15,
		INT = 0.28,
		SPI = 0.17,
		AGI = 0.13,
		STR = 0.13,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		MANAREG = 0.40,
		DMG = 0.11,
		ARCANEDMG = 0.11,
    FIREDMG = 0.11,
    FROSTDMG = 0.11,
    NATUREDMG = 0.11,
    SHADOWDMG = 0.11,
    DMGUNDEAD = 0.11,
    HOLYDMG = 0.11,
		HEAL = 0.08,
		CR_HIT = 0.12,
		CR_CRIT = 0.08,
		CR_SPELLCRIT = 0.08,
		CR_SPELLHIT = 0.05,
		SPELLPEN = 0.10,
		ATTACKPOWERFERAL = 0.01,
	},
	[BC['Paladin']] = {
		STA = 0.20,
		INT = 0.25,
		SPI = 0.15,
		AGI = 0.13,
		STR = 0.15,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		MANAREG = 0.35,
		DMG = 0.08,
		ARCANEDMG = 0.08,
    FIREDMG = 0.08,
    FROSTDMG = 0.08,
    NATUREDMG = 0.08,
    SHADOWDMG = 0.08,
    DMGUNDEAD = 0.08,
    HOLYDMG = 0.08,
		HEAL = 0.08,
		CR_HIT = 0.12,
		CR_CRIT = 0.11,
		CR_SPELLCRIT = 0.11,
		CR_SPELLHIT = 0.05,
		CR_PARRY = 0.05,
		ARMOR = 0.001,
		SPELLPEN = 0.10,
	},
	[L['MeleeGeneric']] = {
		STA = 0.22,
		STR = 0.20,
		AGI = 0.22,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		HEALTHREG = 0.50,
		CR_HIT = 0.18,
		CR_CRIT = 0.215,
		ATTACKPOWER = 0.00,
		CR_DEFENSE = 0.20,
		CR_PARRY = 0.1,
		CR_DODGE = 0,
	},
	[BC['Rogue']] = {
		STA = 0.20,
		STR = 0.10,
		AGI = 0.30,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		CR_HIT = 0.18,
		CR_CRIT = 0.215,
		ATTACKPOWER = 0.11,
	},
	[BC['Hunter']] = {
		STA = 0.20,
		AGI = 0.27,
		INT = 0.15,
		SPI = 0.10,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		CR_HIT = 0.18,
		CR_CRIT = 0.215,
		ATTACKPOWER = 0.10,
		RANGEDATTACKPOWER = 0.10,
	},
	[BC['Warrior']] = {
		STA = 0.25,
		STR = 0.23,
		AGI = 0.15,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		HEALTHREG = 0.50,
		CR_HIT = 0.18,
		CR_CRIT = 0.215,
		ATTACKPOWER = 0.09,
		CR_DEFENSE = 0.20,
		CR_PARRY = 0.1,
		CR_DODGE = 0.1,
		CR_BLOCK = 0.1,
		ARMOR = 0.002,
	},
	[BC['Shaman']] = {
		STA = 0.20,
		INT = 0.28,
		SPI = 0.15,
		AGI = 0.13,
		STR = 0.15,
		ARCANERES = 0.10,
    FIRERES = 0.10,
    FROSTRES = 0.10,
    NATURERES = 0.10,
    SHADOWRES = 0.10,
		MANAREG = 0.30,
		DMG = 0.08,
		ARCANEDMG = 0.08,
    FIREDMG = 0.08,
    FROSTDMG = 0.08,
    NATUREDMG = 0.08,
    SHADOWDMG = 0.08,
    DMGUNDEAD = 0.08,
    HOLYDMG = 0.08,
		HEAL = 0.06,
		CR_HIT = 0.12,
		CR_CRIT = 0.08,
		CR_SPELLCRIT = 0.11,
		CR_SPELLHIT = 0.04,
		SPELLPEN = 0.10,
	},
};

--[[
  Multipliers of DKP for certain item slots

    "INVTYPE_AMMO"        ==> Ammo  
    "INVTYPE_HEAD"        ==> Head  
    "INVTYPE_NECK"        ==> Neck  
    "INVTYPE_SHOULDER"    ==> Shoulder  
    "INVTYPE_BODY"        ==> Shirt  
    "INVTYPE_CHEST"       ==> Chest  
    "INVTYPE_ROBE"        ==> Chest  
    "INVTYPE_WAIST"       ==> Waist  
    "INVTYPE_LEGS"        ==> Legs  
    "INVTYPE_FEET"        ==> Feet  
    "INVTYPE_WRIST"       ==> Wrist  
    "INVTYPE_HAND"        ==> Hands  
    "INVTYPE_FINGER"      ==> Fingers  
    "INVTYPE_TRINKET"     ==> Trinkets  
    "INVTYPE_CLOAK"       ==> Cloaks  
    "INVTYPE_WEAPON"      ==> One-Hand  
    "INVTYPE_SHIELD"      ==> Shield  
    "INVTYPE_2HWEAPON"    ==> Two-Handed  
    "INVTYPE_WEAPONMAINHAND"  ==> Main-Hand Weapon  
    "INVTYPE_WEAPONOFFHAND"   ==> Off-Hand Weapon  
    "INVTYPE_HOLDABLE"    ==> Held In Off-Hand  
    "INVTYPE_RANGED"      ==> Bows Guns or Crossbows  
    "INVTYPE_THROWN"      ==> Ranged  
    "INVTYPE_RANGEDRIGHT" ==> Wands  
    "INVTYPE_RELIC"       ==> Relics  
    "INVTYPE_TABARD"      ==> Tabard  
    "INVTYPE_BAG"         ==> Containers  

]]--
HBDKPItemSlotWeights = {
	["INVTYPE_TRINKET"] = 1.5,
	["INVTYPE_FINGER"] = 1.5,
	["INVTYPE_NECK"] = 1.5,
	["INVTYPE_CLOAK"] = 1.2,
	["INVTYPE_RELIC"] = 2.0,
	["INVTYPE_RANGEDRIGHT"] = 2.6, -- Wand
	["INVTYPE_SHIELD"] = 1.2,
};

HBDKPWeaponTypeWeights = {
	[BI["Wands"]] = 2.6,
};

HBDKPWarriorWeaponsWeights = {
	["INVTYPE_WEAPON"] = {
		[BI["One-Handed Axes"]] = { dps = 0.47, top = 0.22, sub = 71.73},
		[BI["One-Handed Swords"]] = { dps = 0.47, top = 0.22, sub = 72.10},
		[BI["One-Handed Maces"]] = { dps = 0.48, top = 0.22, sub = 71.56},
		[BI["Daggers"]] = { dps = 0.47, top = 0.29, sub = 66.04},
	},
	["INVTYPE_2HWEAPON"] = {
		[BI["Two-Handed Axes"]] = { dps = 0.42, top = 0.16, sub = 86.71},
		[BI["Two-Handed Swords"]] = { dps = 0.40, top = 0.18, sub = 87.98},
		[BI["Two-Handed Maces"]] = { dps = 0.43, top = 0.17, sub = 86.76},
		[BI["Polearms"]] = { dps = 0.43, top = 0.18, sub = 86.01},
	},
	["INVTYPE_WEAPONMAINHAND"] = {
		[BI["One-Handed Axes"]] = { dps = 0.47, top = 0.22, sub = 71.73},
		[BI["One-Handed Swords"]] = { dps = 0.47, top = 0.22, sub = 72.10},
		[BI["One-Handed Maces"]] = { dps = 0.48, top = 0.22, sub = 71.56},
		[BI["Daggers"]] = { dps = 0.47, top = 0.29, sub = 66.04},
		[BI["Fist Weapons"]] = { dps = 0.47, top = 0.29, sub = 72.10},
	},
	["INVTYPE_WEAPONOFFHAND"] = {
		[BI["One-Handed Axes"]] = { dps = 0.47, top = 0.22, sub = 71.73},
		[BI["One-Handed Swords"]] = { dps = 0.47, top = 0, sub = 72.10},
		[BI["One-Handed Maces"]] = { dps = 0.48, top = 0.22, sub = 71.56},
		[BI["Daggers"]] = { dps = 0.47, top = 0.29, sub = 66.04},
		[BI["Fist Weapons"]] = { dps = 0.47, top = 0, sub = 66.68},
	},
};

HBDKPRogueWeaponsWeights = {
  -- One Hand Weapons
	["INVTYPE_WEAPON"] = { 
		[BI["One-Handed Swords"]] = { dps = 0.52, top = 0.30, sub = 84.62},
		[BI["One-Handed Maces"]] = { dps = 0.52, top = 0.30, sub = 81.52},
		[BI["Daggers"]] = { dps = 0.52, top = 0.39, sub = 79.66},
	},
	["INVTYPE_WEAPONMAINHAND"] = {
		[BI["One-Handed Swords"]] = { dps = 0.52, top = 0.30, sub = 84.62},
		[BI["One-Handed Maces"]] = { dps = 0.52, top = 0.30, sub = 84.62},
		[BI["Daggers"]] = { dps = 0.52, top = 0.39, sub = 79.66},
		[BI["Fist Weapons"]] = { dps = 0.52, top = 0.30, sub = 84.62},
	},
	["INVTYPE_WEAPONOFFHAND"] = {
		[BI["One-Handed Swords"]] = { dps = 0.52, top = 0, sub = 39.84},
		[BI["One-Handed Maces"]] = { dps = 0.52, top = 0.30, sub = 84.62},
		[BI["Daggers"]] = { dps = 0.52, top = 0.39, sub = 79.66},
		[BI["Fist Weapons"]] = { dps = 0.52, top = 0, sub = 39.84},
	},
};

HBDKPCasterWeaponsWeights = {
	["INVTYPE_WEAPON"] = {
		[BI["One-Handed Axes"]] = { dps = 0.47, top = 0.35, sub = 89.96},
		[BI["One-Handed Maces"]] = { dps = 0.48, top = 0.34, sub = 89.32},
		[BI["Daggers"]] = { dps = 0.47, top = 0.55, sub = 89.96},
	},
	["INVTYPE_2HWEAPON"] = {
		[BI["Two-Handed Axes"]] = { dps = 0.42, top = 0.22, sub = 101.4},
		[BI["Two-Handed Maces"]] = { dps = 0.43, top = 0.23, sub = 101.43},
	},
	["INVTYPE_WEAPONMAINHAND"] = {
		[BI["One-Handed Axes"]] = { dps = 0.47, top = 0.35, sub = 89.96},
		[BI["One-Handed Maces"]] = { dps = 0.48, top = 0.34, sub = 89.32},
		[BI["Daggers"]] = { dps = 0.47, top = 0.55, sub = 89.96},
		[BI["Fist Weapons"]] = { dps = 0.49, top = 0.54, sub = 87.77},
	},
	["INVTYPE_WEAPONOFFHAND"] = {
		[BI["Fist Weapons"]] = { dps = 0.49, top = 0.54, sub = 87.09},
	},
};

HBDKPHunterWeaponsWeights = {
	["INVTYPE_WEAPON"] = {
		[BI["Axe"]] = { dps = 0.47, top = 0, sub = 39.05 },
		[BI["Sword"]] = { dps = 0.47, top = 0, sub = 39.06 },
		[BI["Dagger"]] = { dps = 0.47, top = 0, sub = 39.03 },
	},
	["INVTYPE_2HWEAPON"] = {
		[BI["Axe"]] = { dps = 0.42, top = 0, sub = 45.03 },
		[BI["Sword"]] = { dps = 0.40, top = 0, sub = 46.44 },
		[BI["Polearm"]] = { dps = 0.43, top = 0, sub = 46.15 },
	},
	["INVTYPE_WEAPONMAINHAND"] = {
		[BI["Axe"]] = { dps = 0.47, top = 0, sub = 39.05 },
		[BI["Sword"]] = { dps = 0.47, top = 0, sub = 39.06 },
		[BI["Dagger"]] = { dps = 0.47, top = 0, sub = 39.03 },
		[BI["Fist Weapon"]] = { dps = 0.49, top = 0, sub = 38 },
	},
	["INVTYPE_WEAPONOFFHAND"] = {
		[BI["Axe"]] = { dps = 0.47, top = 0, sub = 39.05 },
		[BI["Sword"]] = { dps = 0.47, top = 0, sub = 39.03 },
		[BI["Dagger"]] = { dps = 0.47, top = 0, sub = 39.03 },
		[BI["Fist Weapon"]] = { dps = 0.49, top = 0, sub = 37.87 },
	},
};

HBDKPRangedWeaponsWeights = {
	[BI["Bows"]] = { dps = 0.50, top = 0.20, sub = 52.52 },
	[BI["Guns"]] = { dps = 0.51, top = 0.20, sub = 51.56 },
	[BI["Crossbows"]] = { dps = 0.51, top = 0.17, sub = 54.33 },
	[BI["Thrown"]] = { dps = 0.50, top = 0.20, sub = 52.52 },
	[BI["Wands"]] = { dps = 0.42, top = 0.1, sub = 49 },
};

HBDKPGemWeights = {
  [L['Red Socket']] = 3,
  [L['Blue Socket']] = 3,
  [L['Yellow Socket']] = 3,
  [L['Meta Socket']] = 3,
}