

local BC = AceLibrary("Babble-Class-2.2");
local BI = AceLibrary("Babble-Inventory-2.2");
local L = AceLibrary("AceLocale-2.2"):new("Hellbender");

--[[ 
  Mark the primary users of each armor type.
  
  Each class should only appear once as their primary armor
  type even if they can us a different type (i.e. Druids are primary
  Leather users even though they can us Cloth
]]--
ArmorUse = {
  [BI['Cloth']] = {
    [BC['Mage']] = 1,
    [BC['Priest']] = 1,
    [BC['Warlock']] = 1,
  },
  [BI['Leather']] = {
    [BC['Druid']] = 1,
    [BC['Rogue']] = 1,
  },
  [BI['Mail']] = {
    [BC['Hunter']] = 1,
    [BC['Shaman']] = 1,
  },
  [BI['Plate']] = {
    [BC['Paladin']] = 1,
    [BC['Warrior']] = 1,
  },
  [L['Idols']] = {
    [BC['Druid']] = 1,
  },
  [L['Totems']] = {
    [BC['Shaman']] = 1,
  },
  [L['Librams']] = {
    [BC['Paladin']] = 1,
  },
  [L['Shields']] = {
    [BC['Paladin']] = 1,
    [BC['Shaman']] = 1,
    [BC['Warrior']] = 1,
  },
  [BI['Miscellaneous']] = {
    [BC['Priest']] = 1,
    [BC['Rogue']] = 1,
    [BC['Warrior']] = 1,
    [BC['Mage']] = 1,
    [BC['Druid']] = 1,
    [BC['Hunter']] = 1,
    [BC['Warlock']] = 1,
    [BC['Shaman']] = 1,
    [BC['Paladin']] = 1,
  }
}

--[[
  Mark the eligable users of each weapon type
]]--
WeaponUse = {
  [BI['Bows']] = {
    [BC['Warrior']] = 1,
    [BC['Hunter']] = 1,
    [BC['Rogue']] = 1,
  },
  [BI['Crossbows']] = {
    [BC['Warrior']] = 1,
    [BC['Hunter']] = 1,
    [BC['Rogue']] = 1,
  },
  [BI['Daggers']] = {
    [BC['Priest']] = 1,
    [BC['Rogue']] = 1,
    [BC['Warrior']] = 1,
    [BC['Mage']] = 1,
    [BC['Druid']] = 1,
    [BC['Hunter']] = 1,
    [BC['Warlock']] = 1,
    [BC['Shaman']] = 1,
  },
  [BI["Miscellaneous"]] = {
    [BC['Priest']] = 1,
    [BC['Rogue']] = 1,
    [BC['Warrior']] = 1,
    [BC['Mage']] = 1,
    [BC['Druid']] = 1,
    [BC['Hunter']] = 1,
    [BC['Warlock']] = 1,
    [BC['Shaman']] = 1,
    [BC['Paladin']] = 1,
  },
  [BI['Guns']] = {
    [BC['Rogue']] = 1,
    [BC['Warrior']] = 1,
    [BC['Hunter']] = 1,
  },
  [BI['Fist Weapons']] = {
    [BC['Rogue']] = 1,
    [BC['Warrior']] = 1,
    [BC['Druid']] = 1,
    [BC['Hunter']] = 1,
    [BC['Shaman']] = 1,
  },
  [BI['One-Handed Axes']] = {
    [BC['Warrior']] = 1,
    [BC['Hunter']] = 1,
    [BC['Shaman']] = 1,
    [BC['Paladin']] = 1,
  },
  [BI['One-Handed Maces']] = {
    [BC['Priest']] = 1,
    [BC['Rogue']] = 1,
    [BC['Warrior']] = 1,
    [BC['Druid']] = 1,
    [BC['Warlock']] = 1,
    [BC['Shaman']] = 1,
    [BC['Paladin']] = 1,
  },
  [BI['One-Handed Swords']] = {
    [BC['Rogue']] = 1,
    [BC['Warrior']] = 1,
    [BC['Mage']] = 1,
    [BC['Hunter']] = 1,
    [BC['Warlock']] = 1,
    [BC['Paladin']] = 1,
  },
  [BI['Polearms']] = {
    [BC['Warrior']] = 1,
    [BC['Hunter']] = 1,
    [BC['Paladin']] = 1,
  },
  [BI['Staves']] = {
    [BC['Priest']] = 1,
    [BC['Warrior']] = 1,
    [BC['Mage']] = 1,
    [BC['Druid']] = 1,
    [BC['Hunter']] = 1,
    [BC['Warlock']] = 1,
    [BC['Shaman']] = 1,
  },
  [BI['Thrown']] = {
    [BC['Rogue']] = 1,
    [BC['Warrior']] = 1,
    [BC['Hunter']] = 1,
  },
  [BI['Two-Handed Axes']] = {
    [BC['Warrior']] = 1,
    [BC['Hunter']] = 1,
    [BC['Shaman']] = 1,
    [BC['Paladin']] = 1,
  },
  [BI['Two-Handed Maces']] = {
    [BC['Warrior']] = 1,
    [BC['Druid']] = 1,
    [BC['Shaman']] = 1,
    [BC['Paladin']] = 1,
  },
  [BI['Two-Handed Swords']] = {
    [BC['Warrior']] = 1,
    [BC['Hunter']] = 1,
    [BC['Paladin']] = 1,
  },
  [BI['Wands']] = {
    [BC['Priest']] = 1,
    [BC['Mage']] = 1,
    [BC['Warlock']] = 1,
  },
}

--[[
  These are the stats that would flag a weapon as being
  for casters. These do not apply to ranged weapons
]]--

CasterFlags = {
  INT = true,
  MANAGEN = true,
  DMG = true,
  HEAL = true,
  CR_SPELLCRIT = true,
	CR_SPELLHIT = true,
	SPELLPEN = true,
}

NonCasterRangedLocations = {
  ['INVTYPE_RANGED'] = true,
  ['INVTYPE_THROWN'] = true,
}