
HealPointsSpells = {
  SPELLTABLE = { };
};

local rankCache = { };

function HealPointsSpells:init()
	local _, className = UnitClass("player");
	if (className == "PALADIN") then
    fol = { name = HealPointsLoc.SPELL_FOL, type = 'normal', abbr = "FoL" };
    self.SPELLTABLE[1] = {	
                { class = fol, rank = 1, min =  62, max =  72, time = 1.5, mana =  35, level = 20, bolfactor = 1},
                { class = fol, rank = 2, min =  96, max = 110, time = 1.5, mana =  50, level = 26, bolfactor = 1},
                { class = fol, rank = 3, min = 145, max = 163, time = 1.5, mana =  70, level = 34, bolfactor = 1},
                { class = fol, rank = 4, min = 197, max = 221, time = 1.5, mana =  90, level = 42, bolfactor = 1},
                { class = fol, rank = 5, min = 267, max = 299, time = 1.5, mana = 115, level = 50, bolfactor = 1},
                { class = fol, rank = 6, min = 343, max = 383, time = 1.5, mana = 140, level = 58, bolfactor = 1},
                { class = fol, rank = 7, min = 448, max = 502, time = 1.5, mana = 180, level = 66, bolfactor = 1}};

    hl = { name = HealPointsLoc.SPELL_HL, type = 'normal', abbr = "HL" };
    self.SPELLTABLE[2] = {	
                { class = hl, rank =  1, min =   39, max =   47, time = 2.5, mana =  35, level =  1, bolfactor = 0.2},
                { class = hl, rank =  2, min =   76, max =   90, time = 2.5, mana =  60, level =  6, bolfactor = 0.4},
                { class = hl, rank =  3, min =  159, max =  187, time = 2.5, mana = 110, level = 14, bolfactor = 0.7},
                { class = hl, rank =  4, min =  310, max =  356, time = 2.5, mana = 190, level = 22, bolfactor = 1},
                { class = hl, rank =  5, min =  491, max =  553, time = 2.5, mana = 275, level = 30, bolfactor = 1},
                { class = hl, rank =  6, min =  698, max =  780, time = 2.5, mana = 365, level = 38, bolfactor = 1},
                { class = hl, rank =  7, min =  945, max = 1053, time = 2.5, mana = 465, level = 46, bolfactor = 1},
                { class = hl, rank =  8, min = 1246, max = 1388, time = 2.5, mana = 580, level = 54, bolfactor = 1},
                { class = hl, rank =  9, min = 1590, max = 1770, time = 2.5, mana = 660, level = 60, bolfactor = 1},
                { class = hl, rank = 10, min = 1741, max = 1939, time = 2.5, mana = 710, level = 62, bolfactor = 1},
                { class = hl, rank = 11, min = 2196, max = 2446, time = 2.5, mana = 840, level = 70, bolfactor = 1}};
                
    hs = { name = HealPointsLoc.SPELL_HS, type = 'instant', abbr = "HS", cooldown = 15 };
    self.SPELLTABLE[3] = { 
                { class = hs, rank = 1, min = 351, max = 379, mana = 335, level = 40},
                { class = hs, rank = 2, min = 480, max = 518, mana = 410, level = 48},
                { class = hs, rank = 3, min = 628, max = 680, mana = 485, level = 56},
                { class = hs, rank = 4, min = 777, max = 841, mana = 575, level = 64},
                { class = hs, rank = 5, min = 913, max = 987, mana = 650, level = 70}};
                
	elseif (className == "PRIEST") then
    fh = { name = HealPointsLoc.SPELL_FH, type = 'normal', abbr = "FH" };
    self.SPELLTABLE[1] = {	
                { class = fh, rank = 1, min =  193, max =  237, time = 1.5, mana = 125, level = 20},
                { class = fh, rank = 2, min =  258, max =  314, time = 1.5, mana = 155, level = 26},
                { class = fh, rank = 3, min =  327, max =  393, time = 1.5, mana = 185, level = 32},
                { class = fh, rank = 4, min =  400, max =  478, time = 1.5, mana = 215, level = 38},
                { class = fh, rank = 5, min =  518, max =  616, time = 1.5, mana = 265, level = 44},
                { class = fh, rank = 6, min =  644, max =  764, time = 1.5, mana = 315, level = 50},
                { class = fh, rank = 7, min =  812, max =  958, time = 1.5, mana = 380, level = 56},
                { class = fh, rank = 8, min =  913, max = 1059, time = 1.5, mana = 400, level = 61},
                { class = fh, rank = 9, min = 1101, max = 1279, time = 1.5, mana = 470, level = 67}};

    lh = { name = HealPointsLoc.SPELL_LH, type = 'normal', abbr = "LH" };
    heal = { name = HealPointsLoc.SPELL_HEAL, type = 'normal', abbr = "Heal" };
    gh = { name = HealPointsLoc.SPELL_GH, type = 'normal', abbr = "GH" };
    self.SPELLTABLE[2] = {	
                { class = lh, rank = 1, min =  46, max =  56, time = 1.5, mana = 30, level = 1},
                { class = lh, rank = 2, min =  71, max =  85, time = 2.0, mana = 45, level = 4},
                { class = lh, rank = 3, min = 135, max = 157, time = 2.5, mana = 75, level = 10},                
                { class = heal, rank = 1, min = 295, max = 341, time = 3.0, mana = 155, level = 16},
                { class = heal, rank = 2, min = 429, max = 491, time = 3.0, mana = 205, level = 22},
                { class = heal, rank = 3, min = 566, max = 642, time = 3.0, mana = 255, level = 28},
                { class = heal, rank = 4, min = 712, max = 804, time = 3.0, mana = 305, level = 34},
                { class = gh, rank = 1, min =  899, max = 1013, time = 3.0, mana = 370, level = 40},
                { class = gh, rank = 2, min = 1149, max = 1289, time = 3.0, mana = 455, level = 46},
                { class = gh, rank = 3, min = 1437, max = 1609, time = 3.0, mana = 545, level = 52},
                { class = gh, rank = 4, min = 1789, max = 2006, time = 3.0, mana = 655, level = 58},
                { class = gh, rank = 5, min = 1966, max = 2194, time = 3.0, mana = 710, level = 60},
                { class = gh, rank = 6, min = 2074, max = 2410, time = 3.0, mana = 750, level = 63},
                { class = gh, rank = 7, min = 2396, max = 2784, time = 3.0, mana = 710, level = 68}};
                
    renew = { name = HealPointsLoc.SPELL_RENEW, type = 'hot', abbr = "Renew", tickcount = 5, interval = 3 };
    self.SPELLTABLE[3] = {	
                { class = renew, rank =  1, tick =   9, mana =  30, level =  8},
                { class = renew, rank =  2, tick =  20, mana =  65, level = 14},
                { class = renew, rank =  3, tick =  35, mana = 105, level = 20},
                { class = renew, rank =  4, tick =  49, mana = 140, level = 26},
                { class = renew, rank =  5, tick =  63, mana = 170, level = 32},
                { class = renew, rank =  6, tick =  80, mana = 205, level = 38},
                { class = renew, rank =  7, tick = 102, mana = 250, level = 44},
                { class = renew, rank =  8, tick = 130, mana = 305, level = 50},
                { class = renew, rank =  9, tick = 162, mana = 365, level = 56},
                { class = renew, rank = 10, tick = 194, mana = 410, level = 60},
                { class = renew, rank = 11, tick = 202, mana = 430, level = 65},
                { class = renew, rank = 12, tick = 222, mana = 450, level = 70}};

    poh = { name = HealPointsLoc.SPELL_POH, type = 'aoe', abbr = "PoH", time = 3 };
    self.SPELLTABLE[4] = {
                { class = poh, rank = 1, min =  301, max =  321, mana =  410, level = 30},
                { class = poh, rank = 2, min =  444, max =  472, mana =  560, level = 40},
                { class = poh, rank = 3, min =  657, max =  695, mana =  770, level = 50},
                { class = poh, rank = 4, min =  939, max =  991, mana = 1030, level = 60},
                { class = poh, rank = 5, min =  997, max = 1053, mana = 1070, level = 60},
                { class = poh, rank = 6, min = 1246, max = 1316, mana = 1255, level = 68}};
    holynova = { name = HealPointsLoc.SPELL_HOLYNOVA, type = 'aoe', abbr = "HNova", time = 0 };
    self.SPELLTABLE[5] = {
                { class = holynova, rank = 1, min = 52, max = 60, mana = 185, level = 20},
                { class = holynova, rank = 2, min = 86, max = 98, mana = 290, level = 28},
                { class = holynova, rank = 3, min = 121, max = 139, mana = 400, level = 36},
                { class = holynova, rank = 4, min = 161, max = 187, mana = 520, level = 44},
                { class = holynova, rank = 5, min = 235, max = 271, mana = 635, level = 52},
                { class = holynova, rank = 6, min = 302, max = 350, mana = 750, level = 60},
                { class = holynova, rank = 7, min = 384, max = 446, mana = 875, level = 68}};
    coh = { name = HealPointsLoc.SPELL_COH, type = 'aoe', abbr = 'CoH', time = 0 };
    self.SPELLTABLE[6] = {
                { class = coh, rank = 1, min = 246, max = 270, mana = 300, level = 50},
                { class = coh, rank = 2, min = 288, max = 318, mana = 337, level = 56},
                { class = coh, rank = 3, min = 327, max = 361, mana = 375, level = 60},
                { class = coh, rank = 4, min = 370, max = 408, mana = 412, level = 65},
                { class = coh, rank = 5, min = 409, max = 451, mana = 450, level = 70}};

  elseif (className == "DRUID") then
    regr = { name = HealPointsLoc.SPELL_REGR, type = 'regrowth', abbr = "Regr", tickcount = 7, interval = 3 };
    lifebl = { name = HealPointsLoc.SPELL_LIFEBL, type = 'lifebloom', abbr = "LifeBl", tickcount = 7, interval = 1 };
    self.SPELLTABLE[1] = {	
                { class = regr, rank =  1, min =   84, max =   98, tick =  21, time = 2, mana =  80, level = 12},
                { class = regr, rank =  2, min =  164, max =  188, tick =  25, time = 2, mana = 135, level = 18},
                { class = regr, rank =  3, min =  240, max =  274, tick =  37, time = 2, mana = 185, level = 24},
                { class = regr, rank =  4, min =  318, max =  360, tick =  49, time = 2, mana = 230, level = 30},
                { class = regr, rank =  5, min =  405, max =  457, tick =  61, time = 2, mana = 275, level = 36},
                { class = regr, rank =  6, min =  511, max =  575, tick =  78, time = 2, mana = 335, level = 42},
                { class = regr, rank =  7, min =  646, max =  724, tick =  98, time = 2, mana = 405, level = 48},
                { class = regr, rank =  8, min =  809, max =  905, tick = 123, time = 2, mana = 485, level = 54},
                { class = regr, rank =  9, min = 1003, max = 1119, tick = 152, time = 2, mana = 575, level = 60},
                { class = lifebl, rank = 1, burst = 600, tick = 39, mana = 220, level = 64},
                { class = regr, rank = 10, min = 1215, max = 1355, tick = 182, time = 2, mana = 675, level = 65}};
                
    ht = { name = HealPointsLoc.SPELL_HT, type = 'normal', abbr = "HT" };
    self.SPELLTABLE[2] = { 	
                { class = ht, rank =  1, min =   37, max =   51, time = 1.5, mana =  25, level =  1},
                { class = ht, rank =  2, min =   88, max =  112, time = 2.0, mana =  55, level =  8},
                { class = ht, rank =  3, min =  195, max =  243, time = 2.5, mana = 110, level = 14},
                { class = ht, rank =  4, min =  363, max =  445, time = 3.0, mana = 185, level = 20},
                { class = ht, rank =  5, min =  572, max =  694, time = 3.5, mana = 270, level = 26},
                { class = ht, rank =  6, min =  742, max =  894, time = 3.5, mana = 335, level = 32},
                { class = ht, rank =  7, min =  936, max = 1120, time = 3.5, mana = 405, level = 38},
                { class = ht, rank =  8, min = 1199, max = 1427, time = 3.5, mana = 495, level = 44},
                { class = ht, rank =  9, min = 1516, max = 1796, time = 3.5, mana = 600, level = 50},
                { class = ht, rank = 10, min = 1890, max = 2230, time = 3.5, mana = 720, level = 56},
                { class = ht, rank = 11, min = 2267, max = 2677, time = 3.5, mana = 800, level = 60},
                { class = ht, rank = 12, min = 2364, max = 2790, time = 3.5, mana = 820, level = 62},
                { class = ht, rank = 13, min = 2707, max = 3197, time = 3.5, mana = 935, level = 69}};
    
    rejuv = { name = HealPointsLoc.SPELL_REJUV, type = 'hot', abbr = "Rejuv", tickcount = 4, interval = 3 };
    self.SPELLTABLE[3] = {		
                { class = rejuv, rank =  1, tick =   8, mana =  25, level =  4},
                { class = rejuv, rank =  2, tick =  14, mana =  40, level = 10},
                { class = rejuv, rank =  3, tick =  29, mana =  75, level = 16},
                { class = rejuv, rank =  4, tick =  45, mana = 105, level = 22},
                { class = rejuv, rank =  5, tick =  61, mana = 135, level = 28},
                { class = rejuv, rank =  6, tick =  76, mana = 160, level = 34},
                { class = rejuv, rank =  7, tick =  97, mana = 195, level = 40},
                { class = rejuv, rank =  8, tick = 122, mana = 235, level = 46},
                { class = rejuv, rank =  9, tick = 152, mana = 280, level = 52},
                { class = rejuv, rank = 10, tick = 189, mana = 335, level = 58},
                { class = rejuv, rank = 11, tick = 222, mana = 360, level = 60},
                { class = rejuv, rank = 12, tick = 233, mana = 370, level = 63},
                { class = rejuv, rank = 13, tick = 265, mana = 415, level = 69}};

  elseif (className == "SHAMAN") then
    lhw = { name = HealPointsLoc.SPELL_LHW, type = 'normal', abbr = "LHW" };
    self.SPELLTABLE[1] = {	
                { class = lhw, rank = 1, min =  162, max =  186, time = 1.5, mana = 105, level = 20},
                { class = lhw, rank = 2, min =  247, max =  281, time = 1.5, mana = 145, level = 28},
                { class = lhw, rank = 3, min =  337, max =  381, time = 1.5, mana = 185, level = 36},
                { class = lhw, rank = 4, min =  458, max =  514, time = 1.5, mana = 235, level = 44},
                { class = lhw, rank = 5, min =  631, max =  705, time = 1.5, mana = 305, level = 52},
                { class = lhw, rank = 6, min =  832, max =  928, time = 1.5, mana = 380, level = 60},
                { class = lhw, rank = 7, min = 1039, max = 1185, time = 1.5, mana = 440, level = 66}};
                
    hw = { name = HealPointsLoc.SPELL_HW, type = 'normal', abbr = "HW" };
    self.SPELLTABLE[2] = {	
                { class = hw, rank =  1, min =   34, max =   44, time = 1.5, mana =  25, level =  1},
                { class = hw, rank =  2, min =   64, max =   78, time = 2.0, mana =  45, level =  6},
                { class = hw, rank =  3, min =  129, max =  155, time = 2.5, mana =  80, level = 12},
                { class = hw, rank =  4, min =  268, max =  316, time = 3.0, mana = 155, level = 18},
                { class = hw, rank =  5, min =  376, max =  440, time = 3.0, mana = 200, level = 24},
                { class = hw, rank =  6, min =  536, max =  622, time = 3.0, mana = 265, level = 32},
                { class = hw, rank =  7, min =  740, max =  854, time = 3.0, mana = 340, level = 40},
                { class = hw, rank =  8, min = 1017, max = 1167, time = 3.0, mana = 440, level = 48},
                { class = hw, rank =  9, min = 1367, max = 1561, time = 3.0, mana = 560, level = 56},
                { class = hw, rank = 10, min = 1620, max = 1850, time = 3.0, mana = 620, level = 60},
                { class = hw, rank = 11, min = 1725, max = 1969, time = 3.0, mana = 655, level = 63},
                { class = hw, rank = 12, min = 2134, max = 2436, time = 3.0, mana = 720, level = 70}};
                
    chain = { name = HealPointsLoc.SPELL_CHAIN, type = 'chain', abbr = "CH" }; 
    self.SPELLTABLE[3] = {  
                { class = chain, rank = 1, min = 191, max = 217, time = 2.0, mana = 255, level = 32},
                { class = chain, rank = 2, min = 277, max = 311, time = 2.0, mana = 345, level = 40},
                { class = chain, rank = 3, min = 378, max = 424, time = 2.0, mana = 445, level = 48},
                { class = chain, rank = 4, min = 493, max = 551, time = 2.0, mana = 550, level = 56},
                { class = chain, rank = 5, min = 603, max = 687, time = 2.0, mana = 650, level = 63},
                { class = chain, rank = 6, min = 734, max = 838, time = 2.0, mana = 760, level = 70}};
	end
end

function HealPointsSpells:getSpell(spellName, rank)
	for t = 1, table.getn(self.SPELLTABLE), 1 do
		for i = 1, table.getn(self.SPELLTABLE[t]), 1 do
			if (self.SPELLTABLE[t][i]['class']['name'] == spellName and self.SPELLTABLE[t][i]['rank'] == rank) then
				return self.SPELLTABLE[t][i];
			end
		end
	end
end

function HealPointsSpells:spellsChanged()
  for k in pairs(rankCache) do
    rankCache[k] = nil;
  end
end

function HealPointsSpells:getHighestSpellRank(spellName)
  local function getRealRank(spellName)
    local totalSpellTabs = GetNumSpellTabs();
    local totalSpells = 0;
    for t = 1, totalSpellTabs do
      local _, _, _, numSpells = GetSpellTabInfo(t);
      totalSpells = totalSpells + numSpells;
    end

    local highestRank = 0;
    for t = 1, totalSpells do
      local nameSpell, rankSpell = GetSpellName(t, BOOKTYPE_SPELL);
      if (nameSpell == spellName) then
        local j, k = string.find(rankSpell, HealPointsLoc.DIV_RANK.." ");
        if (j ~= nil) then
          highestRank = math.max(highestRank, string.sub(rankSpell, k));
        end
      end
    end
    return highestRank;
  end
  
  if (rankCache[spellName] == nil) then
    rankCache[spellName] = getRealRank(spellName);
  end
  return rankCache[spellName];  
end

function HealPointsSpells:getHighestKnownSpell(spellTable)
  if (spellTable ~= nil) then
    for i = table.getn(spellTable), 1, -1 do
      if (self:getHighestSpellRank(spellTable[i]['class']['name']) == spellTable[i]['rank'] and spellTable[i]['class']['type'] ~= 'lifebloom') then -- Bit of a hack
        return spellTable[i];
      end
    end
  end
  return nil;
end

function HealPointsSpells:getCastTime(spell, spellHaste) 
  local castTime = spell['time'];
  if (castTime == nil) then
    castTime = spell.class['time'];
  end

	local _, className = UnitClass("player");

	if (className == "PALADIN") then
		if (spell.class['name'] == HealPointsLoc.SPELL_HL) then
			castTime = castTime - HealPointsBS:GetBonus('TIME_HL') / 10; -- 3 pc Freethinker bonus
		end

	elseif (className == "PRIEST") then
		if (spell.class['name'] == HealPointsLoc.SPELL_HEAL or spell.class['name'] == HealPointsLoc.SPELL_GH) then
			castTime = castTime - HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_DIVFUR) * 0.1; -- Reduced time for Heal/Greater Heal by 0.1 per rank
		end
		if (spell.class['name'] == HealPointsLoc.SPELL_FH) then
			castTime = castTime - HealPointsBS:GetBonus('TIME_FH') / 10; -- 3 pc Prophecy bonus
		end

	elseif (className == "DRUID") then
		if (spell.class['name'] == HealPointsLoc.SPELL_HT) then
			castTime = castTime - HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_NATURA) * 0.1; -- Reduced time for Healing Touch by 0.1 per rank
		end
    if (spell.class['name'] == HealPointsLoc.SPELL_REGR) then
			castTime = castTime - HealPointsBS:GetBonus('TIME_REGR') / 10; -- 5 pc Stormrage bonus
		end

  elseif (className == "SHAMAN") then
		if (spell.class['name'] == HealPointsLoc.SPELL_HW) then
			castTime = castTime - HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_IMHEWA) * 0.1; -- Reduced time for Healing Wave by 0.1 per rank
		end
		if (spell.class['name'] == HealPointsLoc.SPELL_CHAIN) then
			castTime = castTime - HealPointsBS:GetBonus('TIME_CHAIN') / 10; -- 5 pc Stormcaller bonus
		end
  end
  
  if (castTime ~= nil) then
    castTime = castTime / (1 + spellHaste / 100);
  end
  
  return castTime;
end

function HealPointsSpells:getNumberOfTicks(spell)
  local tickcount = spell.class['tickcount'];

	local _, className = UnitClass("player");

	if (className == "PRIEST") then
		if (spell.class['name'] == HealPointsLoc.SPELL_RENEW) then
      tickcount = tickcount + HealPointsBS:GetBonus('DURATION_RENEW') / spell.class['interval']; -- 5 pc Oracle bonus
		end

	elseif (className == "DRUID") then
		if (spell.class['name'] == HealPointsLoc.SPELL_REJUV) then
      tickcount = tickcount + HealPointsBS:GetBonus('DURATION_REJUV') / spell.class['interval']; -- 8 pc Stormrage bonus
		end
    if (spell.class['name'] == HealPointsLoc.SPELL_REGR) then
      tickcount = tickcount + HealPointsBS:GetBonus('DURATION_REGR') / spell.class['interval']; -- tier 5
    end
  end

  return tickcount;
end

function HealPointsSpells:getManaCost(spell, spellCrit)
  local percentCheaper = 0;
  local refund = 0;

  spellCrit = spellCrit + self:getSpellCritBonus(spell);

	local _, className = UnitClass("player");

  if (className == "PALADIN") then
    percentCheaper = (spellCrit / 100) * 0.20 * HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_ILLUMI) * 0.6; -- Reduced mana cost for crits by 20% per rank
    if (spell.class['name'] == HealPointsLoc.SPELL_HL) then
      refund = HealPointsBS:GetBonus('MANA_ABS_HL'); -- Straight mana reduction
    end

  elseif (className == "PRIEST") then
    if (spell.class['name'] == HealPointsLoc.SPELL_LH or spell.class['name'] == HealPointsLoc.SPELL_HEAL or spell.class['name'] == HealPointsLoc.SPELL_GH) then
      percentCheaper = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_IMPHEA) * 0.05; -- Reduced mana cost for slow heal by 5% per rank
		end
		if (spell.class['name'] == HealPointsLoc.SPELL_FH or spell.class['name'] == HealPointsLoc.SPELL_GH) then
			percentCheaper = percentCheaper + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_HOLCON) * 0.02; -- 2% chance per rank for free spell
		end
		if (spell.class['name'] == HealPointsLoc.SPELL_RENEW) then
      percentCheaper = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_MENAGI) * 0.02; -- Reduced mana cost for Renew by 2% per rank
      percentCheaper = percentCheaper + HealPointsBS:GetBonus('MANA_PC_RENEW') * 0.01; -- 2 pc Vestments of Faith bonus
    elseif (spell.class['name'] == HealPointsLoc.SPELL_POH) then
      percentCheaper = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_HEAPRA) * 0.1; -- Reduced mana cost for Prayer of Healing by 10% per rank
      percentCheaper = percentCheaper + HealPointsBS:GetBonus('MANA_PC_POH') * 0.01; -- Tier 6
    elseif (spell.class['name'] == HealPointsLoc.SPELL_HOLYNOVA or spell.class['name'] == HealPointsLoc.SPELL_COH) then
      percentCheaper = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_MENAGI) * 0.02; -- Reduced mana cost for instants by 2% per rank    
    end

  elseif (className == "DRUID") then
    percentCheaper = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_MOONGL) * 0.03;		-- Reduced mana cost for all spells by 3% per rank
    if (spell.class['name'] ~= HealPointsLoc.SPELL_LIFEBL) then
      percentCheaper = percentCheaper + HealPointsBS:GetBonus('MANA_PC_DRUID') * 0.01; -- 4 pc Dreamwalker bonus
    elseif (spell.class['name'] == HealPointsLoc.SPELL_HT) then
      percentCheaper = percentCheaper + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_TRASPI) * 0.02; -- Reduced mana cost for Healing Touch by 2% per rank
      refund = (spellCrit / 100) * 0.01 * HealPointsBS:GetBonus('MANA_REFUND_CRIT_HT') * spell['mana']; -- 8 pc Dreamwalker bonus
      if (HealPointsBS:GetBonus('MANA_REFUND_HT') > 0) then
        refund = refund + math.min(HealPointsBS:GetBonus('MANA_REFUND_HT'), spell['mana'] / (HealPointsBS:GetBonus('MANA_REFUND_HT') - 1)); -- Idol of Longevity
      end
    elseif (spell.class['name'] == HealPointsLoc.SPELL_REGROWTH) then
      refund = refund + HealPointsBS:GetBonus('MANA_ABS_REGR'); -- Straight mana reduction
    elseif (spell.class['name'] == HealPointsLoc.SPELL_REJUV) then
			refund = refund + HealPointsBS:GetBonus('MANA_ABS_REJUV'); -- Straight mana reduction
    end    
    if (HealPointsUtil:isPlayerBuffUp(HealPointsLoc.BUFF_TREELI) and (spell.class['name'] == HealPointsLoc.SPELL_REJUV or spell.class['name'] == HealPointsLoc.SPELL_REGR or spell.class['name'] == HealPointsLoc.SPELL_LIFEBL)) then
      percentCheaper = percentCheaper + 0.2; -- 20% cheaper in treeform
    end

	elseif (className == "SHAMAN") then
    percentCheaper = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_TIDFOC) * 0.01; -- Reduced mana cost for all spells by 1% per rank
    if (spell.class['name'] == HealPointsLoc.SPELL_LHW or spell.class['name'] == HealPointsLoc.SPELL_HW) then
      refund = 0.25 * 0.01 * HealPointsBS:GetBonus('MANA_REFUND_HWLHW') * spell['mana']; -- 5 pc Earthfury bonus
    end
    if (spell.class['name'] == HealPointsLoc.SPELL_LHW) then
      percentCheaper = percentCheaper + HealPointsBS:GetBonus('MANA_PC_LHW') * 0.01; -- Tier 5
    elseif (spell.class['name'] == HealPointsLoc.SPELL_HW) then
      refund = refund + HealPointsBS:GetBonus('MANA_ABS_HW'); -- Straight mana reduction
    elseif (spell.class['name'] == HealPointsLoc.SPELL_CHAIN) then
      percentCheaper = percentCheaper + HealPointsBS:GetBonus('MANA_PC_CHAIN') * 0.01; -- Tier 6
      refund = refund + HealPointsBS:GetBonus('MANA_ABS_CHAIN'); -- Straight mana reduction
    end
    
  end
    
  return spell['mana'] * (1 - percentCheaper) - refund;
end

function HealPointsSpells:getHealingPercentBonus(spell) 
  local percentBonus = 0;

	local _, className = UnitClass("player");

	if (className == "PALADIN") then
		if (spell.class['name'] == HealPointsLoc.SPELL_FOL or spell.class['name'] == HealPointsLoc.SPELL_HL) then
      percentBonus = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_HEALIG) * 0.04; -- Increases avg for both spells by 4% per rank
    end
    if (spell.class['name'] == HealPointsLoc.SPELL_FOL) then
      percentBonus = percentBonus + HealPointsBS:GetBonus('AVG_PC_FOL') * 0.01; -- Tier 6
		end
		percentBonus = 1 + percentBonus;

	elseif (className == "PRIEST") then
    percentBonus = 1 + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_SPIHEA) * 0.02;  -- Increased avg for all spells by 2% per rank
    if (spell.class['name'] == HealPointsLoc.SPELL_RENEW) then
      percentBonus = percentBonus * (1 + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_IMPREN) * 0.05); -- Increased avg for Renew by 5% per rank
    elseif (spell.class['name'] == HealPointsLoc.SPELL_GH) then
      percentBonus = percentBonus * (1 + HealPointsBS:GetBonus('AVG_PC_GH') * 0.01); -- Tier 6
		end
		-- Tested to be multiplicative for Renew

	elseif (className == "DRUID") then
		percentBonus = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_GIOFNA) * 0.02;				-- Increased avg for all spells by 2% per rank
		if (spell.class['name'] == HealPointsLoc.SPELL_REJUV) then
      percentBonus = percentBonus + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_IMPREJ) * 0.05; -- Increased avg for Rejuvenation by 5% per rank
    elseif (spell.class['name'] == HealPointsLoc.SPELL_HT) then
      percentBonus = percentBonus + HealPointsBS:GetBonus('AVG_PC_HT') * 0.01; -- Tier 6
		end
		percentBonus = 1 + percentBonus; -- Tested not to be multiplicative for Rejuvenation

	elseif (className == "SHAMAN") then
    percentBonus = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_PURIFI) * 0.02; -- Increased avg for all spells by 2% per rank
    if (spell.class['name'] == HealPointsLoc.SPELL_CHAIN) then
      percentBonus = percentBonus + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_IMPCHA) * 0.1; -- Increased avg for Chain heal by 10% per rank
      percentBonus = percentBonus + HealPointsBS:GetBonus('AVG_PC_CHAIN') * 0.01; -- Tier 6
    end
    percentBonus = 1 + percentBonus;
  end
    
  return percentBonus;
end

function HealPointsSpells:getHealingFactor(spell)
	local levelFactor = 1 - ((20 - math.min(20, spell['level'])) * 0.0375);
  levelFactor = levelFactor * math.min(1, (spell['level'] + 11) / UnitLevel("player"));

  local timeFactor, timeFactor2;
  if (spell.class['type'] == 'regrowth') then
    timeFactor = 0.5 * math.min(spell['time'], 3.5) / 3.5;
    timeFactor2 = 0.5 * spell.class['tickcount'] * spell.class['interval'] / 15; -- Now scales above 100%
  elseif (spell.class['type'] == 'lifebloom') then
    timeFactor = 0.52;
    timeFactor2 = 0.8 * 1.5 / 3.5;
  elseif (spell.class['type'] == 'hot') then
    timeFactor = spell.class['tickcount'] * spell.class['interval'] / 15; --- Now scales above 100%
  elseif (spell.class['type'] == 'instant') then
    timeFactor = 1.5 / 3.5;
  elseif (spell.class['type'] == 'aoe') then
    timeFactor = (math.max(1.5, spell.class['time']) / 3.5) / 2;
    if (spell.class['name'] == HealPointsLoc.SPELL_HOLYNOVA) then
      timeFactor = timeFactor * 7 / 9;
    end
  else -- normal / chain
    timeFactor = math.min(spell['time'], 3.5) / 3.5;
	end
  
  -- Empowered talents (strange difference between empowered healing and empowered rejuvenation)
  if (spell.class['name'] == HealPointsLoc.SPELL_GH) then
    timeFactor = timeFactor + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_EMPHEA) * 0.04; -- +4% bonus healing per rank
  elseif (spell.class['name'] == HealPointsLoc.SPELL_FH) then
    timeFactor = timeFactor + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_EMPHEA) * 0.02; -- +2% bonus healing per rank
  elseif (spell.class['name'] == HealPointsLoc.SPELL_HT) then
    timeFactor = timeFactor * (1 + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_EMPOHT) * 0.1); -- +10% bonus healing per rank
  elseif (spell.class['name'] == HealPointsLoc.SPELL_REJUV) then
    timeFactor = timeFactor * (1 + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_EMPREJ) * 0.04); -- +4% bonus healing per rank
  elseif (spell.class['name'] == HealPointsLoc.SPELL_REGR) then
    timeFactor = timeFactor * (1 + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_EMPREJ) * 0.04); -- +4% bonus healing per rank (Burst)
    timeFactor2 = timeFactor2 * (1 + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_EMPREJ) * 0.04); -- +4% bonus healing per rank (HoT)
  elseif (spell.class['name'] == HealPointsLoc.SPELL_LIFEBL) then
    timeFactor = timeFactor * (1 + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_EMPREJ) * 0.04); -- +4% bonus healing per rank 
    timeFactor2 = timeFactor2 * (1 + HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_EMPREJ) * 0.04); -- +4% bonus healing per rank 
  end
  
  if (timeFactor2 ~= nil) then
    return levelFactor * timeFactor, levelFactor * timeFactor2;
  else
    return levelFactor * timeFactor;
  end
end

function HealPointsSpells:getSpellCritBonus(spell)
  local critBonus = 0;
  
  if (spell.class['name'] == HealPointsLoc.SPELL_REGR) then
    critBonus = 10 * HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_IMPREG); -- Increases crit for Regrowth by 10% per rank
  elseif (spell.class['name'] == HealPointsLoc.SPELL_HL) then
    critBonus = 2 * HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_SANCLI); -- Increases crit for Holy Light by 2% per rank
    critBonus = critBonus + HealPointsBS:GetBonus('CRIT_HL'); -- Tier 6
  elseif (spell.class['name'] == HealPointsLoc.SPELL_FOL) then
    critBonus = HealPointsBS:GetBonus('CRIT_FOL'); -- Arena set
  elseif (spell.class['name'] == HealPointsLoc.SPELL_POH) then
    critBonus = HealPointsBS:GetBonus('CRIT_POH'); -- Tier 1
  end
  
  return critBonus;
end

function HealPointsSpells:getHealingBonus(spell)
  local healBonus = 0;

  if (spell.class['name'] == HealPointsLoc.SPELL_FOL) then
    healBonus = HealPointsBS:GetBonus('AVG_ABS_FOL'); -- Libram of Grace/Divinity
  elseif (spell.class['name'] == HealPointsLoc.SPELL_HL) then
    healBonus = HealPointsBS:GetBonus('AVG_ABS_HL');
  elseif (spell.class['name'] == HealPointsLoc.SPELL_REJUV) then
    healBonus = HealPointsBS:GetBonus('AVG_ABS_REJUV'); -- Idol of Rejuvenation
  elseif (spell.class['name'] == HealPointsLoc.SPELL_HT) then
    healBonus = HealPointsBS:GetBonus('AVG_ABS_HT'); -- Idol of Health
  elseif (spell.class['name'] == HealPointsLoc.SPELL_LHW) then
    healBonus = HealPointsBS:GetBonus('AVG_ABS_LHW'); -- Totem of Life/Sustaining
  elseif (spell.class['name'] == HealPointsLoc.SPELL_HW) then
    healBonus = HealPointsBS:GetBonus('AVG_ABS_HW');
  elseif (spell.class['name'] == HealPointsLoc.SPELL_CHAIN) then
    healBonus = HealPointsBS:GetBonus('AVG_ABS_CHAIN');
  end
  
  return healBonus;
end
