
HealPointsGems = {
};

HealPointsGems.gems ={
	blessedTanzanite = {
		name = "Blessed Tanzanite",
		desc = "+11 Healing and +6 Stamina (epic)",
		color = "purple",
		stats = {
			HEAL = 11
		}
	},
	brilliantLionseye ={
		name = "Brilliant Lionseye",
		desc = "+10 Intellect (epic)",
		color = "yellow",
		stats ={
			INT = 10,
		}
	},
	dazzlingSeasprayEmerald ={
		name = "Dazzling Seaspray Emerald",
		desc = "+5 Intellect and +2 Mana every 5 seconds (epic)",
		color = "green",
		stats ={
			INT = 5,
			MANAREG = 2,
		}
	},
	durableFireOpal = {
		name = "Durable Fire Opal",
		desc = "+11 Healing and +4 Resilience Rating (epic)",
		color = "orange",
		stats = {
			HEAL = 11,
		}
	},
	forcefulSeasprayEmerald = {
		name = "Forceful Seaspray Emerald",
		desc = "+5 Spell Haste Rating and +7 Stamina (epic)",
		color = "purple",
		stats = {
			SPELLHASTERATING = 5,
		}
	},
	gleamingLionseye ={
		name = "Gleaming Lionseye",
		desc = "+10 Spell Critical Rating (epic)",
		color = "yellow",
		stats ={
			SPELLCRITRATING = 10,
		}
	},
	imperialTanzanite = {
		name = "Imperial Tanzanite",
		desc = "+5 Spirit and +9 Healing (epic)",
		color = "purple",
		stats = {
			SPI = 5,
			HEAL = 9,
		}
	},
	iridescentFireOpal = {
		name = "Iridescent Fire Opal",
		desc = "+11 Healing and +4 Spell Critical Rating (epic)",
		color = "orange",
		stats = {
			HEAL = 11,
			SPELLCRITRATING = 4,
		}
	},
	luminousPyrestone ={
		name = "Luminous Pyrestone",
		desc = "+11 Healing and +5 Intellect (epic)",
		color = "orange",
		stats ={
			HEAL = 11,
			INT = 5,
		}
	},
	lustrousEmpyreanSapphire ={
		name = "Lustrous Empyrean Sapphire",
		desc = "+4 Mana every 5 seconds (epic)",
		color = "blue",
		stats ={
			MANAREG = 4,
		}
	},
	polishedChrysoprase = {
		name = "Polished Chrusoprase",
		desc = "+6 Stamina and +5 Spell Critical Rating (epic)",
		color = "green",
		stats = {
			SPELLCRITRATING = 5,
		}
	},
	potentPyrestone ={
		name = "Potent Pyrestone",
		desc = "+5 Spell Critical Rating and +6 Spell Damage (epic)",
		color = "orange",
		stats ={
			SPELLCRITRATING = 5,
			HEAL = 6,
		}
	},
	quickLionseye = {
		name = "Quick Lionseye",
		desc = "+10 Spell Haste Rating (epic)",
		color = "yellow",
		stats = {
			SPELLHASTERATING = 10,
		}
	},
	recklessPyrestone = {
		name = "Reckless Pyrestone",
		desc = "+5 Spell Haste Rating and +6 Spell Damage (epic)",
		color = "orange",
		stats = {
			SPELLHASTERATING = 5,
			HEAL = 6,
		}
	},
	royalShadowsongAmethyst ={
		name = "Royal Shadowsong Amethyst",
		desc = "+11 Healing and +2 Mana every 5 seconds (epic)",
		color = "purple",
		stats ={
			HEAL = 11,
			MANAREG = 2,
		}
	},
	runeCoveredChrysoprase = {
		name = "Rune Covered Chrysoprase",
		desc = "+5 Spell Critical Rating and +2 Mana every 5 seconds (epic)",
		color = "green",
		stats = {
			SPELLCRITRATING = 5,
			MANAREG = 2,
		}
	},
	seersChrysoprase = {
		name = "Seer's Chrysoprase",
		desc = "+4 Intellect and +5 Spirit (epic)",
		color = "green",
		stats = {
			INT = 4,
			SPI = 5,
		},
	},
	sparklingEmpyreanSapphire ={
		name = "Sparkling Empyrean Sapphire",
		desc = "+10 Spirit (epic)",
		color = "blue",
		stats ={
			SPI = 10,
		}
	},
	teardropCrimsonSpinel ={
		name = "Teardrop Crimson Spinel",
		desc = "+22 Healing (epic)",
		color = "red",
		stats ={
			HEAL = 22,
		}
	},
	timelessChrysoprase = {
		name = "Timeless Chrysoprase",
		desc = "+5 Intellect and +6 Stamina (epic)",
		color = "green",
		stats = {
			INT = 5,
		}
	},
	
	brilliantDawnstone ={
		name = "Brilliant Dawnstone",
		desc = "+8 Intellect",
		color = "yellow",
		stats ={
			INT = 8,
		}
	},
	dazzlingTalasite ={
		name = "Dazzling Talasite",
		desc = "+4 Intellect and +2 Mana every 5 seconds",
		color = "green",
		stats ={
			INT = 4,
			MANAREG = 2,
		}
	},
	forcefulTalasite = {
		name = "Forceful Talasite",
		desc = "+4 Spell Haste Rating and +6 Stamina",
		color = "green",
		stats = {
			SPELLHASTERATING = 4,
		},
	},	
	gleamingDawnstone ={
		name = "Gleaming Dawnstone",
		desc = "+8 Spell Critical Rating",
		color = "yellow",
		stats ={
			SPELLCRITRATING = 8,
		}
	},
	luminousNobleTopaz ={
		name = "Luminous Noble Topaz",
		desc = "+9 Healing and +4 Intellect",
		color = "orange",
		stats ={
			HEAL = 9,
			INT = 4,
		}
	},
	lustrousStarOfElune ={
		name = "Lustrous Star of Elune",
		desc = "+3 Mana every 5 seconds",
		color = "blue",
		stats ={
			MANAREG = 3,
		}
	},
	potentNobleTopaz ={
		name = "Potent Noble Topaz",
		desc = "+4 Spell Critical Rating and +5 Spell Damage",
		color = "orange",
		stats ={
			SPELLCRITRATING = 4,
			HEAL = 5,
		}
	},
	purifiedShadowPearl ={
		name = "Purified Shadow Pearl",
		desc = "+9 Healing and +4 Spirit",
		color = "purple",
		stats ={
			HEAL = 9,
			SPI = 4,
		}
	},
	quickDawnstone = {
		name = "Quick Dawnstone",
		desc = "+8 Spell Haste Rating",
		color = "yellow",
		stats = {
			SPELLHASTERATING = 8,
		}
	},
	recklessNobleTopaz = {
		name = "Reckless Noble Topaz",
		desc = "+4 Spell Haste Rating and +5 Spell Damage",
		color = "orange",
		stats = {
			SPELLHASTERATING = 4,
			HEAL = 5,
		}
	},
	royalNightseye ={
		name = "Royal Nightseye",
		desc = "+9 Healing and +2 Mana every 5 seconds",
		color = "purple",
		stats ={
			HEAL = 9,
			MANAREG = 2,
		}
	},
	sparklingStarOfElune ={
		name = "Sparkling Star of Elune",
		desc = "+8 Spirit",
		color = "blue",
		stats ={
			SPI = 8,
		}
	},
	teardropLivingRuby ={
		name = "Teardrop Living Ruby",
		desc = "+18 Healing",
		color = "red",
		stats ={
			HEAL = 18,
		}
	},
}

function HealPointsGems:setBlue(gemNumber)
	HealPoints:clearLinkCache();
	HealPoints.db.char.gems.blueGem = gemNumber;
end

function HealPointsGems:getBlue(gemNumber)
	return HealPoints.db.char.gems.blueGem == gemNumber;
end

function HealPointsGems:setRed(gemNumber)
	HealPoints:clearLinkCache();
	HealPoints.db.char.gems.redGem = gemNumber;
end

function HealPointsGems:getRed(gemNumber)
	return HealPoints.db.char.gems.redGem == gemNumber;
end

function HealPointsGems:setYellow(gemNumber)
	HealPoints:clearLinkCache();
	HealPoints.db.char.gems.yellowGem = gemNumber;
end

function HealPointsGems:getYellow(gemNumber)
	return HealPoints.db.char.gems.yellowGem == gemNumber;
end

function HealPointsGems:getBlueSelected()
	local number = HealPoints.db.char.gems.blueGem;
	local i, menu;
	for i, menu in pairs(HealPointsGems.blueSocket) do
		if (menu.passValue == number) then
			if (menu.gem == nil) then
				return nil;
			else
				return menu.gem.stats;
			end
		end
	end
	return nil;
end

function HealPointsGems:getRedSelected()
	local number = HealPoints.db.char.gems.redGem;
	local i, menu;
	for i, menu in pairs(HealPointsGems.redSocket) do
		if (menu.passValue == number) then
			if (menu.gem == nil) then
				return nil;
			else
				return menu.gem.stats;
			end
		end
	end
	return nil;
end

function HealPointsGems:getYellowSelected()
	local number = HealPoints.db.char.gems.yellowGem;
	local i, menu;
	for i, menu in pairs(HealPointsGems.yellowSocket) do
		if (menu.passValue == number) then
			if (menu.gem == nil) then
				return nil;
			else
				return menu.gem.stats;
			end
		end
	end
	return nil;
end

local function gemToMenu(color, gemNumber, gem)
	menu ={
		type = "toggle",
		name = gem.name,
		desc = gem.desc,
		get = "get"..color,
		set = "set"..color,
		passValue = gemNumber,
		handler = HealPointsGems,
		isRadio = true,
		gem = gem
	};
	return menu;
end

HealPointsGems.blueSocket ={
	none ={
		type = "toggle",
		name = "None",
		desc = "None",
		get = "getBlue",
		set = "setBlue",
		passValue = 1;
		handler = HealPointsGems,
		isRadio = true,
		order = 1,
	},
	gemToMenu("Blue", 11, HealPointsGems.gems.blessedTanzanite),
	gemToMenu("Blue", 3, HealPointsGems.gems.dazzlingSeasprayEmerald),
	gemToMenu("Blue", 12, HealPointsGems.gems.forcefulSeasprayEmerald),
	gemToMenu("Blue", 13, HealPointsGems.gems.imperialTanzanite),
	gemToMenu("Blue", 4, HealPointsGems.gems.lustrousEmpyreanSapphire),
	gemToMenu("Blue", 14, HealPointsGems.gems.polishedChrysoprase),
	gemToMenu("Blue", 9, HealPointsGems.gems.royalShadowsongAmethyst),
	gemToMenu("Blue", 15, HealPointsGems.gems.runeCoveredChrysoprase),
	gemToMenu("Blue", 16, HealPointsGems.gems.seersChrysoprase),
	gemToMenu("Blue", 10, HealPointsGems.gems.sparklingEmpyreanSapphire),
	gemToMenu("Blue", 17, HealPointsGems.gems.timelessChrysoprase),

	gemToMenu("Blue", 2, HealPointsGems.gems.dazzlingTalasite),
	gemToMenu("Blue", 18, HealPointsGems.gems.forcefulTalasite),
	gemToMenu("Blue", 5, HealPointsGems.gems.lustrousStarOfElune),
	gemToMenu("Blue", 6, HealPointsGems.gems.purifiedShadowPearl),
	gemToMenu("Blue", 7, HealPointsGems.gems.royalNightseye),
	gemToMenu("Blue", 8, HealPointsGems.gems.sparklingStarOfElune),
}

HealPointsGems.redSocket ={
	none ={
		type = "toggle",
		name = "None",
		desc = "None",
		get = "getRed",
		set = "setRed",
		passValue = 1;
		handler = HealPointsGems,
		isRadio = true,
		order = 1,
	},
	gemToMenu("Red", 11, HealPointsGems.gems.blessedTanzanite),
	gemToMenu("Red", 12, HealPointsGems.gems.durableFireOpal),
	gemToMenu("Red", 13, HealPointsGems.gems.forcefulSeasprayEmerald),
	gemToMenu("Red", 14, HealPointsGems.gems.imperialTanzanite),
	gemToMenu("Red", 15, HealPointsGems.gems.iridescentFireOpal),
	gemToMenu("Red", 2, HealPointsGems.gems.luminousPyrestone),
	gemToMenu("Red", 3, HealPointsGems.gems.potentPyrestone),
	gemToMenu("Red", 16, HealPointsGems.gems.recklessPyrestone),
	gemToMenu("Red", 8, HealPointsGems.gems.royalShadowsongAmethyst),
	gemToMenu("Red", 10, HealPointsGems.gems.teardropCrimsonSpinel),
	
	gemToMenu("Red", 4, HealPointsGems.gems.luminousNobleTopaz),
	gemToMenu("Red", 5, HealPointsGems.gems.potentNobleTopaz),
	gemToMenu("Red", 6, HealPointsGems.gems.purifiedShadowPearl),
	gemToMenu("Red", 17, HealPointsGems.gems.recklessNobleTopaz),
	gemToMenu("Red", 7, HealPointsGems.gems.royalNightseye),
	gemToMenu("Red", 9, HealPointsGems.gems.teardropLivingRuby),
}

HealPointsGems.yellowSocket ={
	none ={
		type = "toggle",
		name = "None",
		desc = "None",
		get = "getYellow",
		set = "setYellow",
		passValue = 1;
		handler = HealPointsGems,
		isRadio = true,
		order = 1,
	},
	gemToMenu("Yellow", 7, HealPointsGems.gems.brilliantLionseye),
	gemToMenu("Yellow", 8, HealPointsGems.gems.dazzlingSeasprayEmerald),
	gemToMenu("Yellow", 12, HealPointsGems.gems.durableFireOpal),
	gemToMenu("Yellow", 22, HealPointsGems.gems.forcefulSeasprayEmerald),
	gemToMenu("Yellow", 9, HealPointsGems.gems.gleamingLionseye),
	gemToMenu("Yellow", 13, HealPointsGems.gems.iridescentFireOpal),
	gemToMenu("Yellow", 10, HealPointsGems.gems.luminousPyrestone),
	gemToMenu("Yellow", 14, HealPointsGems.gems.polishedChrysoprase),
	gemToMenu("Yellow", 6, HealPointsGems.gems.potentNobleTopaz),
	gemToMenu("Yellow", 15, HealPointsGems.gems.quickLionseye),
	gemToMenu("Yellow", 16, HealPointsGems.gems.recklessPyrestone),
	gemToMenu("Yellow", 17, HealPointsGems.gems.runeCoveredChrysoprase),
	gemToMenu("Yellow", 19, HealPointsGems.gems.seersChrysoprase),
	gemToMenu("Yellow", 20, HealPointsGems.gems.timelessChrysoprase),

	gemToMenu("Yellow", 2, HealPointsGems.gems.brilliantDawnstone),
	gemToMenu("Yellow", 3, HealPointsGems.gems.dazzlingTalasite),
	gemToMenu("Yellow", 21, HealPointsGems.gems.forcefulTalasite),
	gemToMenu("Yellow", 4, HealPointsGems.gems.gleamingDawnstone),
	gemToMenu("Yellow", 5, HealPointsGems.gems.luminousNobleTopaz),
	gemToMenu("Yellow", 11, HealPointsGems.gems.potentPyrestone),
	gemToMenu("Yellow", 23, HealPointsGems.gems.quickDawnstone),
	gemToMenu("Yellow", 24, HealPointsGems.gems.recklessNobleTopaz),
}

