
HealPointsCharUI = { };

function HealPointsCharUI:setTooltip()
	if (HealPoints.ISHEALER and HealPoints:IsActive()) then
		GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
		GameTooltip:SetText("HealPoints "..format("%5.0f", this.healPoints), HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		GameTooltip:AddDoubleLine("PowerPoints ("..this.powerText.."):", format("%5.0f", this.powerPoints), NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		GameTooltip:AddDoubleLine("EndurancePoints ("..this.enduranceText.."):", format("%5.0f", this.endurancePoints), NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		GameTooltip:AddLine("Hint: Click to show the HealPoints calculator", GREEN_FONT_COLOR.r, GREEN_FONT_COLOR.g, GREEN_FONT_COLOR.b);
		GameTooltip:Show();
	end
end

function HealPointsCharUI:setStats(healPoints, powerPoints, endurancePoints, powerSpell, enduranceSpell)
	local label = getglobal("HealPoints_CharFrameLabel");
	local text = getglobal("HealPoints_CharFrameStatText");
	local frame = getglobal("HealPoints_CharFrame");

	frame.healPoints = healPoints;
	frame.powerPoints = powerPoints;
	frame.endurancePoints = endurancePoints;
	if (powerSpell == nil) then
		frame.powerText = "No spell selected";
	else
		frame.powerText = powerSpell.class['abbr'].." "..powerSpell['rank'];
	end
	if (enduranceSpell == nil) then
		frame.enduranceText = "No spell selected";
	else
		frame.enduranceText = enduranceSpell.class['abbr'].." "..enduranceSpell['rank'];
	end

	label:SetText("HealPoints:");
	text:SetText(format("%5.0f", healPoints));
end
