
HealPointsCalculatorUI = { };

local TH_TotalTimeCurrent = nil;
local TH_TotalTimeNew = nil;
local SELECTED_SPELL = nil;
local SELECTED_RANK = nul;
local Spell_Names = { };
local SPELLLIST = { };

local function setStat(statString, stat, delta)
	if (delta == 0) then
		statString:SetText(stat);
	elseif (delta > 0) then
		statString:SetText(GREEN_FONT_COLOR_CODE..stat..FONT_COLOR_CODE_CLOSE);
	else
		statString:SetText(RED_FONT_COLOR_CODE..stat..FONT_COLOR_CODE_CLOSE);
	end
end

local function updateRankLists()
	local function updateRankList(objref, maxRank)
		for i = 1, maxRank, 1 do
			local info ={
				text = "Rank "..i,
				func = HealPointsCalculatorUI.rankSelected
			};
			if (objref and type(objref) == "table") then
				info.owner = objref;
			end
			UIDropDownMenu_AddButton(info)
		end
	end

	local spellMax = HealPointsSpells:getHighestSpellRank(SELECTED_SPELL);
	UIDropDownMenu_Initialize(HealPointsSpellSelectRank,function() updateRankList(HealPointsSpellSelectRank, spellMax); end);
end

function HealPointsCalculatorUI:setHealPoints(power, powerNew, efficient, efficientNew)
	local function setResultInfo(number, name, currentStat, newStat, numberFormat)
		local diff = newStat - currentStat;
		getglobal("HealPointsResult"..number.."Label"):SetText(name);
		getglobal("HealPointsResult"..number.."Current"):SetText(format(numberFormat, currentStat));
		setStat(getglobal("HealPointsResult"..number.."Difference"), format(numberFormat, diff), diff);
		setStat(getglobal("HealPointsResult"..number.."Result"), format(numberFormat, newStat), diff);
	end

	local healPoints = power + efficient;
	local healPointsNew = powerNew + efficientNew;

	setResultInfo(1, "PowerPoints:", power, powerNew, "%5.0f");
	setResultInfo(2, "+ EndurancePoints:", efficient, efficientNew, "%5.0f");
	setResultInfo(4, "= HealPoints:", healPoints, healPointsNew, "%5.0f");
end

function HealPointsCalculatorUI:setSpellStat(number, name, currentStat, newStat, formatString)
	if (name == nil) then
		getglobal("HealPointsSpell"..number.."Label"):SetText("");
		getglobal("HealPointsSpell"..number.."Current"):SetText("");
		getglobal("HealPointsSpell"..number.."Difference"):SetText("");
		getglobal("HealPointsSpell"..number.."Result"):SetText("");
	elseif (currentStat < 0 or newStat < 0) then
		getglobal("HealPointsSpell"..number.."Label"):SetText(name);
		getglobal("HealPointsSpell"..number.."Difference"):SetText("");
		if (currentStat < 0) then
			getglobal("HealPointsSpell"..number.."Current"):SetText("Infinite");
		else
			setStat(getglobal("HealPointsSpell"..number.."Current"), format(formatString, currentStat), 0);
		end
		if (newStat < 0) then
			getglobal("HealPointsSpell"..number.."Result"):SetText("Infinite");
		else
			setStat(getglobal("HealPointsSpell"..number.."Result"), format(formatString, newStat), -1);
		end
	else
		local diff = newStat - currentStat;
		getglobal("HealPointsSpell"..number.."Label"):SetText(name);
		setStat(getglobal("HealPointsSpell"..number.."Current"), format(formatString, currentStat), 0);
		setStat(getglobal("HealPointsSpell"..number.."Difference"), format(formatString, diff), diff);
		setStat(getglobal("HealPointsSpell"..number.."Result"), format(formatString, newStat), diff);
	end
end

function HealPointsCalculatorUI:setHealFactor(factor1, factor2)
	local factorString = getglobal("HealPointsSpellInfo");
	if (factor2 == nil) then
		factorString:SetText("Each point of +healing adds "..format("%1.2f", factor1).." hp/cast to this spell.");
	else
		factorString:SetText("Each point of +healing adds "..format("%1.2f", factor1).." to burst and "..format("%1.2f", factor2).." to HoT.");
	end
end

function HealPointsCalculatorUI:setVariableStatInfo(number, currentStat, extraDelta, numberFormat)
	local originalStatText = getglobal("HealPointsVariables"..number.."Current");
	local inputBox = getglobal("HealPointsVariables"..number.."InputBox");
	local newStatText = getglobal("HealPointsVariables"..number.."Result");

	local delta = inputBox:GetNumber() + extraDelta;
	local newStat = currentStat + delta;
	originalStatText:SetText(format(numberFormat, currentStat));
	setStat(newStatText, format(numberFormat, newStat), delta);
end

function HealPointsCalculatorUI:inputBoxChanged()
	HealPointsCalculator:updateStats();
	self:updateSelectedSpellStats();
	HealPointsCalculator:updateHealPoints();
end

function HealPointsCalculatorUI:updateSpellLists() -- Update dropdown menus
	local function updateSpellList(objref)
		for i = 1, table.getn(SPELLLIST), 1 do
			local info ={
				text = SPELLLIST[i],
				func = HealPointsCalculatorUI.spellSelected
			};
			if (objref and type(objref) == "table") then
				info.owner = objref;
			end
			UIDropDownMenu_AddButton(info)
		end
	end

	for k in pairs(SPELLLIST) do
		SPELLLIST[k] = nil;
	end
	for i = 1, table.getn(Spell_Names), 1 do
		if (HealPointsSpells:getHighestSpellRank(Spell_Names[i]) > 0) then
			table.insert(SPELLLIST, Spell_Names[i]);
		end
	end

	UIDropDownMenu_Initialize(HealPointsSpellSelectSpell,function() updateSpellList(HealPointsSpellSelectSpell); end);
	UIDropDownMenu_SetSelectedID(HealPointsSpellSelectSpell, 1);
	SELECTED_SPELL = SPELLLIST[UIDropDownMenu_GetSelectedID(HealPointsSpellSelectSpell)];
	updateRankLists();
	SELECTED_RANK = HealPointsSpells:getHighestSpellRank(SELECTED_SPELL);
	UIDropDownMenu_SetSelectedID(HealPointsSpellSelectRank, SELECTED_RANK);
	HealPointsCalculatorUI:updateSelectedSpellStats();
end


function HealPointsCalculatorUI:spellSelected()
	if (this.owner) then
		UIDropDownMenu_SetSelectedID(this.owner, this:GetID());
		SELECTED_SPELL = SPELLLIST[UIDropDownMenu_GetSelectedID(HealPointsSpellSelectSpell)];
		updateRankLists();
		SELECTED_RANK = HealPointsSpells:getHighestSpellRank(SELECTED_SPELL);
		UIDropDownMenu_SetSelectedID(HealPointsSpellSelectRank, SELECTED_RANK);
		HealPointsCalculatorUI:updateSelectedSpellStats();
	end
end

function HealPointsCalculatorUI:rankSelected()
	if (this.owner) then
		UIDropDownMenu_SetSelectedID(this.owner, this:GetID());
		SELECTED_RANK = UIDropDownMenu_GetSelectedID(HealPointsSpellSelectRank);
		HealPointsCalculatorUI:updateSelectedSpellStats();
	end
end

function HealPointsCalculatorUI:setTimeToOOM(curTime, newTime)
	TH_TotalTimeCurrent = curTime;
	TH_TotalTimeNew = newTime;
end

function HealPointsCalculatorUI:setTooltip()
	local function spellToString(spell)
		if (spell == nil) then
			return "No spell selected";
		else
			return spell.class['name'].." ("..spell['rank']..")";
		end
	end

	local function totalTimeToString(curTime, newTime)
		if (curTime == null) then
			curTime = "NA";
		elseif (curTime < 0) then
			curTime = "Infinite";
		else
			curTime = format("%d", curTime).."s";
		end
		if (newTime == null) then
			newTime = "NA";
		elseif (newTime < 0) then
			newTime = "Infinite";
		else
			newTime = format("%d", newTime).."s";
		end
		return newTime.." ("..curTime..")";
	end

	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	if (this:GetID() == 1) then -- PowerPoints
		GameTooltip:SetText("PowerPoints", HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		if (HealPoints.db.char.power['auto'] == true) then
			GameTooltip:AddLine("Hitpoints healed in "..HealPoints.db.char.power['duration'].." minute(s) using your most");
			GameTooltip:AddLine("powerful spell, starting with "..HealPoints.db.char.power['mana'].."% mana.");
			GameTooltip:AddLine("Regeneration and 5 sec rule are taken into account.");
			GameTooltip:AddLine("\nSelected spell:", HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
			GameTooltip:AddLine(spellToString(HealPointsCalculator.HP_LastPowerfulCurrent).." / "..spellToString(HealPointsCalculator.HP_LastPowerfulNew));
		else
			GameTooltip:AddLine("Hitpoints healed in "..HealPoints.db.char.power['duration'].." minute(s) using");
			GameTooltip:AddLine(HealPoints.db.char.power['spell'].." ("..HealPoints.db.char.power['rank'].."), starting with "..HealPoints.db.char.power['mana'].."% mana.");
			GameTooltip:AddLine("Regeneration and 5 sec rule are taken into account.");
		end
	elseif (this:GetID() == 2) then -- EndurancePoints
		GameTooltip:SetText("EndurancePoints", HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		if (HealPoints.db.char.endurance['auto'] == true) then
			GameTooltip:AddLine("Hitpoints healed in "..HealPoints.db.char.endurance['duration'].." minute(s) using your most");
			GameTooltip:AddLine("efficient spell, starting with "..HealPoints.db.char.endurance['mana'].."% mana.");
			GameTooltip:AddLine("Regeneration and 5 sec rule are taken into account.");
			GameTooltip:AddLine("\nSelected spell:", HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
			GameTooltip:AddLine(spellToString(HealPointsCalculator.HP_LastEfficientCurrent).." / "..spellToString(HealPointsCalculator.HP_LastEfficientNew));
		else
			GameTooltip:AddLine("Hitpoints healed in "..HealPoints.db.char.endurance['duration'].." minute(s) using");
			GameTooltip:AddLine(HealPoints.db.char.endurance['spell'].." ("..HealPoints.db.char.endurance['rank'].."), starting with "..HealPoints.db.char.endurance['mana'].."% mana.");
			GameTooltip:AddLine("Regeneration and 5 sec rule are taken into account.");
		end
	elseif (this:GetID() == 8) then -- Tot. healed with regen
		GameTooltip:SetText("HP/manabar", HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		GameTooltip:AddLine("Hitpoints healed with selected spell");
		GameTooltip:AddLine("using the whole mana bar.");
		GameTooltip:AddLine("Casting regeneration is taken into account.");
		GameTooltip:AddLine("\nTime taken until mana bar is spent:", HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		GameTooltip:AddLine(totalTimeToString(TH_TotalTimeCurrent, TH_TotalTimeNew));
	elseif (this:GetID() == 16) then -- Casting regen
		GameTooltip:SetText("Casting mana regeneration", HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		GameTooltip:AddLine("Mana regenerated when last spell");
		GameTooltip:AddLine("was cast less than 5 seconds ago.");
	elseif (this:GetID() == 17) then -- Normal regen
		GameTooltip:SetText("Normal mana regeneration", HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		GameTooltip:AddLine("Mana regenerated when last spell");
		GameTooltip:AddLine("was cast more than 5 seconds ago.");
	elseif (this:GetID() == 20) then -- Spell Crit rating
		GameTooltip:SetText("Spell critical strike rating", HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
		GameTooltip:AddLine("Only includes bonuses from gear.");
	end
		GameTooltip:Show();
end

function HealPointsCalculatorUI:show()
	if (SELECTED_SPELL == nil) then
		self:updateSpellLists();
	end
	HealPointsCalculator:updateStats();
	self:updateSelectedSpellStats();
	HealPointsCalculator:updateHealPoints();
end

function HealPointsCalculatorUI:updateSelectedSpellStats()
	local spell = HealPointsSpells:getSpell(SELECTED_SPELL, SELECTED_RANK);
	HealPointsCalculator:displaySpellStats(spell);
end

function HealPointsCalculatorUI:init()
	local _, className = UnitClass("player");
	if (className == "PALADIN") then
		Spell_Names ={ HealPointsLoc.SPELL_FOL, HealPointsLoc.SPELL_HL, HealPointsLoc.SPELL_HS };
	elseif (className == "PRIEST") then
		Spell_Names ={ HealPointsLoc.SPELL_FH, HealPointsLoc.SPELL_LH, HealPointsLoc.SPELL_HEAL,
		HealPointsLoc.SPELL_GH, HealPointsLoc.SPELL_RENEW, HealPointsLoc.SPELL_POH,
		HealPointsLoc.SPELL_HOLYNOVA, HealPointsLoc.SPELL_COH};
	elseif (className == "DRUID") then
		Spell_Names ={ HealPointsLoc.SPELL_HT, HealPointsLoc.SPELL_REJUV, HealPointsLoc.SPELL_REGR,
		HealPointsLoc.SPELL_LIFEBL };
	elseif (className == "SHAMAN") then
		Spell_Names ={ HealPointsLoc.SPELL_LHW, HealPointsLoc.SPELL_HW, HealPointsLoc.SPELL_CHAIN };
	end
end