
HealPointsCalculator ={
	HP_LastPowerfulCurrent = nil;
	HP_LastPowerfulNew = nil;
	HP_LastEfficientCurrent = nil;
	HP_LastEfficientNew = nil;
};

local BonusPercentInt;
local BonusPercentSpi;
local BonusPercentMana;

local BASE_REGEN = { };
BASE_REGEN[1] = 0.034965
BASE_REGEN[2] = 0.034191
BASE_REGEN[3] = 0.033465
BASE_REGEN[4] = 0.032526
BASE_REGEN[5] = 0.031661
BASE_REGEN[6] = 0.031076
BASE_REGEN[7] = 0.030523
BASE_REGEN[8] = 0.029994
BASE_REGEN[9] = 0.029307
BASE_REGEN[10] = 0.028661
BASE_REGEN[11] = 0.027584
BASE_REGEN[12] = 0.026215
BASE_REGEN[13] = 0.025381
BASE_REGEN[14] = 0.0243
BASE_REGEN[15] = 0.023345
BASE_REGEN[16] = 0.022748
BASE_REGEN[17] = 0.021958
BASE_REGEN[18] = 0.021386
BASE_REGEN[19] = 0.02079
BASE_REGEN[20] = 0.020121
BASE_REGEN[21] = 0.019733
BASE_REGEN[22] = 0.019155
BASE_REGEN[23] = 0.018819
BASE_REGEN[24] = 0.018316
BASE_REGEN[25] = 0.017936
BASE_REGEN[26] = 0.017576
BASE_REGEN[27] = 0.017201
BASE_REGEN[28] = 0.016919
BASE_REGEN[29] = 0.016581
BASE_REGEN[30] = 0.016233
BASE_REGEN[31] = 0.015994
BASE_REGEN[32] = 0.015707
BASE_REGEN[33] = 0.015464
BASE_REGEN[34] = 0.015204
BASE_REGEN[35] = 0.014956
BASE_REGEN[36] = 0.014744
BASE_REGEN[37] = 0.014495
BASE_REGEN[38] = 0.014302
BASE_REGEN[39] = 0.014094
BASE_REGEN[40] = 0.013895
BASE_REGEN[41] = 0.013724
BASE_REGEN[42] = 0.013522
BASE_REGEN[43] = 0.013363
BASE_REGEN[44] = 0.013175
BASE_REGEN[45] = 0.012996
BASE_REGEN[46] = 0.012853
BASE_REGEN[47] = 0.012687
BASE_REGEN[48] = 0.012539
BASE_REGEN[49] = 0.012384
BASE_REGEN[50] = 0.012233
BASE_REGEN[51] = 0.012113
BASE_REGEN[52] = 0.011973
BASE_REGEN[53] = 0.011859
BASE_REGEN[54] = 0.011714
BASE_REGEN[55] = 0.011575
BASE_REGEN[56] = 0.011473
BASE_REGEN[57] = 0.011342
BASE_REGEN[58] = 0.011245
BASE_REGEN[59] = 0.01111
BASE_REGEN[60] = 0.010999
BASE_REGEN[61] = 0.0107
BASE_REGEN[62] = 0.010522
BASE_REGEN[63] = 0.01029
BASE_REGEN[64] = 0.010119
BASE_REGEN[65] = 0.009968
BASE_REGEN[66] = 0.009808
BASE_REGEN[67] = 0.009651
BASE_REGEN[68] = 0.009553
BASE_REGEN[69] = 0.009445
BASE_REGEN[70] = 0.009327

local Paladin_BoL = {
	{ HL = 210, FoL = 60},
	{ HL = 300, FoL = 85},
	{ HL = 400, FoL = 115},
	{ HL = 580, FoL = 185}
};

-- Helper functions
local function getGCD(spellHaste)
	if (spellHaste == nil) then
		return 1.5;
	else
		return math.max(1.0, 1.5 / (1 + spellHaste / 100));	
	end
end

local function getHPCast(spell, healing, spellCrit)
	local percentBonus = HealPointsSpells:getHealingPercentBonus(spell);
	local healFactor, healFactor2 = HealPointsSpells:getHealingFactor(spell);
	spellCrit = spellCrit + HealPointsSpells:getSpellCritBonus(spell);
	healing = healing + HealPointsSpells:getHealingBonus(spell);

	local out;

	if (spell.class['type'] == 'normal' or spell.class['type'] == 'instant') then
		out = (((spell['min'] + spell['max']) / 2) + healing * healFactor) * percentBonus * (1 + spellCrit / 200)

	elseif (spell.class['type'] == 'hot') then
		local healTick = spell['tick'] + healing * healFactor / spell.class['tickcount']; -- +healing divided between original tickcount
		out = healTick * HealPointsSpells:getNumberOfTicks(spell) * percentBonus;

	elseif (spell.class['type'] == 'regrowth') then
		-- Burst part
		out = (((spell['min'] + spell['max']) / 2) + healing * healFactor) * percentBonus * (1 + spellCrit / 200);
		-- HOT part
		local healTick = spell['tick'] + healing * healFactor2 / spell.class['tickcount'];
		out = out + healTick * HealPointsSpells:getNumberOfTicks(spell) * percentBonus;

	elseif (spell.class['type'] == 'lifebloom') then
		-- Burst part
		out = (spell['burst'] + (healing + HealPointsBS:GetBonus('AVG_BURST_LIFEBL')) * healFactor2) * percentBonus * (1 + spellCrit / 200);
		-- HOT part
		local healTick = spell['tick'] + (healing + HealPointsBS:GetBonus('AVG_HOT_LIFEBL')) * healFactor / spell.class['tickcount'];
		out = out + healTick * HealPointsSpells:getNumberOfTicks(spell) * percentBonus;

	elseif (spell.class['type'] == 'chain') then
		out = (((spell['min'] + spell['max']) / 2) + healing * healFactor) * percentBonus * (1 + spellCrit / 200);
		out = out * (1 + 0.75 * (1 + HealPointsBS:GetBonus('AVG_PC_JUMPS_CHAIN') / 100)); -- Assumes that the spell hits all 3 targets

	elseif (spell.class['type'] == 'aoe') then
		out = (((spell['min'] + spell['max']) / 2) + healing * healFactor) * percentBonus * (1 + spellCrit / 200)
		out = out * math.min(5, HealPoints.db.char.hot['numtargets']);
	end

	if (spell.class['name'] == HealPointsLoc.SPELL_HL or spell.class['name'] == HealPointsLoc.SPELL_FOL) then
		out = (((spell['min'] + spell['max']) / 2) + healing * healFactor) * percentBonus;
		if (getglobal("HealPointsOptionsConfigBoL"):GetChecked() == 1) then
			local bolRank = HealPointsSpells:getHighestSpellRank(HealPointsLoc.SPELL_BOL);
			if (bolRank > 0) then
				local bol = Paladin_BoL[bolRank];
				local levelFactor = (1 - ((20 - math.min(20, spell['level'])) * 0.0375)) * math.min(1, (spell['level'] + 11) / UnitLevel("player"));
				out = out + (levelFactor * spell['bolfactor'] * (bol[spell.class['abbr']] + HealPointsBS:GetBonus('AVG_ABS_BOL'))) * percentBonus;
			end
		end
		out = out * (1 + (spellCrit / 200));

	elseif (spell.class['name'] == HealPointsLoc.SPELL_HW and HealPointsBS:GetBonus('JUMP_HW') > 0) then
		local factor = 1 - HealPointsBS:GetBonus('JUMP_HW') / 100;
		out = out * (1 + factor + factor * factor);

	elseif (spell.class['name'] == HealPointsLoc.SPELL_GH and HealPointsBS:GetBonus('GH_RENEW') > 0) then
		local renew = HealPointsSpells:getSpell(HealPointsLoc.SPELL_RENEW, HealPointsBS:GetBonus('GH_RENEW'));
		local renewHealFactor = HealPointsSpells:getHealingFactor(renew);
		healing = healing - HealPointsSpells:getHealingBonus(spell);
		out = out + renew.class['tickcount'] * renew['tick'] + healing * renewHealFactor; -- Assumes renew effect isn't overwritten
	end

	return out;
end

local function getHPTick(spell, healing)
	local percentBonus = HealPointsSpells:getHealingPercentBonus(spell);
	local healFactor, healFactor2 = HealPointsSpells:getHealingFactor(spell);
	healing = healing + HealPointsSpells:getHealingBonus(spell);

	local healTick = 0;

	if (spell.class['type'] == 'hot') then
		healTick = spell['tick'] + healing * healFactor / spell.class['tickcount']; -- +healing divided between original tickcount

	elseif (spell.class['type'] == 'regrowth') then
		healTick = spell['tick'] + healing * healFactor2 / spell.class['tickcount'];

	elseif (spell.class['type'] == 'lifebloom') then
		healTick = spell['tick'] + (healing + HealPointsBS:GetBonus('AVG_HOT_LIFEBL')) * healFactor / spell.class['tickcount'];
	end

	healTick = healTick * percentBonus;
	return healTick;
end

local function getHPSec(spell, healing, spellCrit, spellHaste)
	if (spell.class['name'] == HealPointsLoc.SPELL_GH and HealPointsBS:GetBonus('GH_RENEW') > 0) then
		local percentBonus = HealPointsSpells:getHealingPercentBonus(spell);
		local healFactor = HealPointsSpells:getHealingFactor(spell);
		spellCrit = spellCrit + HealPointsSpells:getSpellCritBonus(spell);
		healing = healing + HealPointsSpells:getHealingBonus(spell);
		local out = (((spell['min'] + spell['max']) / 2) + healing * healFactor) * percentBonus * (1 + spellCrit / 200)
		return out / HealPointsSpells:getCastTime(spell, spellHaste); -- Don't count renew-effect in HP/s.
	elseif (spell.class['type'] == 'normal' or spell.class['type'] == 'chain' or spell.class['type'] == 'aoe') then
		local castTime = HealPointsSpells:getCastTime(spell, spellHaste);
		if (castTime == 0) then
			castTime = getGCD(spellHaste);
		end
	return getHPCast(spell, healing, spellCrit) / castTime;
	elseif (spell.class['type'] == 'instant') then
		return getHPCast(spell, healing, spellCrit) / spell.class['cooldown'];
	elseif (spell.class['type'] == 'hot' or spell.class['type'] == 'lifebloom') then
		return getHPCast(spell, healing, spellCrit) / (HealPointsSpells:getNumberOfTicks(spell) * spell.class['interval']);
	elseif (spell.class['type'] == 'regrowth') then
		return getHPCast(spell, healing, spellCrit) /
			(HealPointsSpells:getCastTime(spell, spellHaste) + HealPointsSpells:getNumberOfTicks(spell) * spell.class['interval']);
	end
end

local function getHPMana(spell, healing, spellCrit)
	local hpcast = getHPCast(spell, healing, spellCrit);
	local manaCost = HealPointsSpells:getManaCost(spell, spellCrit);
	return hpcast / manaCost;
end

local function getHPTotalRegen(spell, healing, spellCrit, spellHaste, manaRegenCasting, mana)
	local hpPerCast = getHPCast(spell, healing, spellCrit);
	local manaCost = HealPointsSpells:getManaCost(spell, spellCrit);

	local interval;
	if (spell.class['type'] == 'regrowth') then
		interval = HealPointsSpells:getCastTime(spell, spellHaste) + HealPointsSpells:getNumberOfTicks(spell) * spell.class['interval'];
	elseif (spell.class['type'] == 'hot' or spell.class['type'] == 'lifebloom') then
		interval = HealPointsSpells:getNumberOfTicks(spell) * spell.class['interval'];
	elseif (spell.class['type'] == 'instant') then
		interval = math.max(getGCD(spellHaste), spell.class['cooldown']);
	else
		interval = math.max(getGCD(spellHaste), HealPointsSpells:getCastTime(spell, spellHaste)); 
	end

	local manaUsageSpell = manaCost - interval * (manaRegenCasting / 5);
	local hpPerMana = hpPerCast / manaUsageSpell;
	local hpPerManaBar = hpPerMana * mana;

	local numberCasts = mana / manaUsageSpell;
	local totalTime = numberCasts * interval;

	return hpPerManaBar, totalTime;
end

local function computeTotalHealingNormal(spell, healing, seconds, startMana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal)
	--DEFAULT_CHAT_FRAME:AddMessage("Computing total healing for "..spell.class['name'].."("..spell['rank']..") secs="..seconds.." mana="..startMana,1,1,1);
	local hpCast = getHPCast(spell, healing, spellCrit);
	local castDelay = math.max(getGCD(spellHaste), HealPointsSpells:getCastTime(spell, spellHaste)); 
	local manaCost = HealPointsSpells:getManaCost(spell, spellCrit);
	local hps = hpCast / castDelay;

	-- Phase 1: Has mana to chain-cast
	local manaUsageSecond = (manaCost / castDelay) - (manaRegenCasting / 5);
	local secondsPhase1 = math.min(seconds, startMana / manaUsageSecond);
	local totalHealed = secondsPhase1 * hps;

	-- Phase 2: Has no mana left
	local secondsPhase2 = seconds - secondsPhase1;
	if (secondsPhase2 > 0) then
		local cycleTime; -- Seconds between each casting
		if (manaRegenCasting > manaCost) then -- chaincast inside 5s rule
			local secs = manaCost / (manaRegenCasting / 5);
			cycleTime = math.max(secs, castDelay);
		else
			local manaToRegen = manaCost - manaRegenCasting;
			cycleTime = 5 + manaToRegen / (manaRegenNormal / 5);
		end
		local spellsCast = secondsPhase2 / cycleTime;
		local healedPhase2 = spellsCast * hpCast;
		totalHealed = totalHealed + healedPhase2;
	end

	return totalHealed;
end

local function computeTotalHealingTrans8(spell, healing, seconds, startMana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal)
	--DEFAULT_CHAT_FRAME:AddMessage("Computing total healing for "..spell.class['name'].."("..spell['rank']..") secs="..seconds.." mana="..startMana,1,1,1);
	local hps = getHPSec(spell, healing, spellCrit, spellHaste);
	local manaCost = HealPointsSpells:getManaCost(spell, spellCrit);
	local castTime = math.max(getGCD(spellHaste), HealPointsSpells:getCastTime(spell, spellHaste)); 
	local numtargets = HealPoints.db.char.hot['numtargets'];

	local renew = HealPointsSpells:getSpell(HealPointsLoc.SPELL_RENEW, HealPointsBS:GetBonus('GH_RENEW'));
	local renewHealFactor = HealPointsSpells:getHealingFactor(renew);
	healing = healing + HealPointsSpells:getHealingBonus(renew);

	-- Phase 1: Has mana to chain-cast
	local manaUsageSecond = (manaCost / castTime) - (manaRegenCasting / 5);
	local secondsPhase1 = math.min(seconds, startMana / manaUsageSecond);
	local secsBetweenSameTarget = numtargets * castTime;
	if (numtargets == 0) then
		secsBetweenSameTarget = castTime;
	end
	local ticsPerCast = secsBetweenSameTarget / renew.class['interval'];
	ticsPerCast = math.min(ticsPerCast, renew.class['tickcount']);
	local spellsCast = secondsPhase1 / castTime;

	local burstHealed = secondsPhase1 * hps;
	local hotHealed = spellsCast * ticsPerCast * (renew['tick'] + healing * renewHealFactor / renew.class['tickcount']);
	local totalHealed = burstHealed + hotHealed;

	-- Phase 2: Has no mana left
	local secondsPhase2 = seconds - secondsPhase1;
	if (secondsPhase2 > 0) then
		local cycleTime; -- Seconds between each casting
		if (manaRegenCasting > manaCost) then -- chaincast inside 5s rule
			local secs = manaCost / (manaRegenCasting / 5);
			cycleTime = math.max(secs, castTime);
		else
		local manaToRegen = manaCost - manaRegenCasting;
		cycleTime = 5 + manaToRegen / (manaRegenNormal / 5);
		end
		secsBetweenSameTarget = numtargets * cycleTime;
		if (numtargets == 0) then
			secsBetweenSameTarget = cycleTime;
		end
		ticsPerCast = secsBetweenSameTarget / renew.class['interval'];
		ticsPerCast = math.min(ticsPerCast, renew.class['tickcount']);
		spellsCast = secondsPhase2 / cycleTime;

		burstHealed = secondsPhase2 * hps * castTime / cycleTime;
		hotHealed = spellsCast * ticsPerCast * (renew['tick'] + healing * renewHealFactor / renew.class['tickcount']);
		local healedPhase2 = burstHealed + hotHealed;
		totalHealed = totalHealed + healedPhase2;
	end

return totalHealed;
end

local function computeTotalHealingRegrowth(spell, healing, seconds, startMana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal)
	--DEFAULT_CHAT_FRAME:AddMessage("Computing total healing for "..spell.class['name'].."("..spell['rank']..") secs="..seconds.." mana="..startMana,1,1,1);
	local manaCost = HealPointsSpells:getManaCost(spell, spellCrit);
	local castTime = math.max(getGCD(spellHaste), HealPointsSpells:getCastTime(spell, spellHaste)); 
	local percentBonus = HealPointsSpells:getHealingPercentBonus(spell);
	local healFactorBurst, healFactorHot = HealPointsSpells:getHealingFactor(spell);
	local numtargets = HealPoints.db.char.hot['numtargets'];
	spellCrit = spellCrit + HealPointsSpells:getSpellCritBonus(spell);
	healing = healing + HealPointsSpells:getHealingBonus(spell);

	local avgBurst = (((spell['min'] + spell['max']) / 2) + healing * healFactorBurst) * percentBonus * (1 + spellCrit / 200);
	local healTick = (spell['tick'] + healing * healFactorHot / spell.class['tickcount']) * percentBonus;

	-- Phase 1: Has mana to chain-cast
	local manaUsageSecond = (manaCost / castTime) - (manaRegenCasting / 5);
	local secondsPhase1 = math.min(seconds, startMana / manaUsageSecond);
	local secsBetweenSameTarget = math.max(castTime, numtargets * castTime);
	local ticsPerCast = secsBetweenSameTarget / spell.class['interval'];
	ticsPerCast = math.min(ticsPerCast, HealPointsSpells:getNumberOfTicks(spell));
	local spellsCast = secondsPhase1 / castTime;

	local totalHealed = spellsCast * (avgBurst + ticsPerCast * healTick);

	-- Phase 2: Has no mana left
	local secondsPhase2 = seconds - secondsPhase1;
	if (secondsPhase2 > 0) then
		local cycleTime; -- Seconds between each casting
		if (manaRegenCasting > manaCost) then -- chaincast inside 5s rule
			local secs = manaCost / (manaRegenCasting / 5);
			cycleTime = math.max(secs, castTime);
		else
			local manaToRegen = manaCost - manaRegenCasting;
			cycleTime = 5 + manaToRegen / (manaRegenNormal / 5);
		end
		secsBetweenSameTarget = math.max(cycleTime, numtargets * cycleTime);
		ticsPerCast = secsBetweenSameTarget / spell.class['interval'];
		ticsPerCast = math.min(ticsPerCast, HealPointsSpells:getNumberOfTicks(spell));
		spellsCast = secondsPhase2 / cycleTime;

		local healedPhase2 = spellsCast * (avgBurst + ticsPerCast * healTick);
		totalHealed = totalHealed + healedPhase2;
	end

	return totalHealed;
end

local function computeTotalHealingLifebloom(spell, healing, seconds, startMana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal)
	local percentBonus = HealPointsSpells:getHealingPercentBonus(spell);
	local healFactorHot, healFactorBurst = HealPointsSpells:getHealingFactor(spell);
	spellCrit = spellCrit + HealPointsSpells:getSpellCritBonus(spell);
	healing = healing + HealPointsSpells:getHealingBonus(spell);
	local avgBurst = (spell['burst'] + (healing + HealPointsBS:GetBonus('AVG_BURST_LIFEBL')) * healFactorBurst) * percentBonus;
	local healTick = (spell['tick'] + (healing + HealPointsBS:GetBonus('AVG_HOT_LIFEBL')) * healFactorHot / spell.class['tickcount']) * percentBonus;
	avgBurst = avgBurst * (1 + spellCrit / 200);
	local duration = HealPointsSpells:getNumberOfTicks(spell) * spell.class['interval'];
	local manaCost = HealPointsSpells:getManaCost(spell, spellCrit);
	local numtargets = HealPoints.db.char.hot['numtargets'];

	if (getglobal("HealPointsOptionsConfigLifeBl"):GetChecked() == 1) then -- stack lifeblooms
		-- Phase 1: Has enough mana/regen to keep stacking lifeblooms up on numtargets constantly
		numtargets = math.min(3, numtargets); -- max 3 targets
		local cycleTime = duration;
		local manaUsageCycle = numtargets * manaCost;
		local regenTimeCasting = math.min(cycleTime, 5 + (numtargets - 1) * getGCD(spellHaste));
		local regenTimeNormal = math.max(0, cycleTime - regenTimeCasting);
		local manaRegainCycle = regenTimeCasting * (manaRegenCasting / 5) + regenTimeNormal * (manaRegenNormal / 5);
		local numCycles = seconds / cycleTime;
		if (manaRegainCycle < manaUsageCycle) then -- if you regen more than you use, you'll never go oom.
			numCycles = math.min(numCycles, startMana / (manaUsageCycle - manaRegainCycle));
		end
		local secondsPhase1 = numCycles * cycleTime;
		local numTicks = numCycles * numtargets * 3 * (HealPointsSpells:getNumberOfTicks(spell) - 1); -- Overwrites before the last tick
		if (numCycles > 2) then -- Ticks lost due to building stacks
			numTicks = numTicks - numtargets * 3 * (HealPointsSpells:getNumberOfTicks(spell) - 1) - 3 * 0.75 * (numtargets * numtargets - numtargets);
		elseif (numCycles == 2) then
			numTicks = numTicks - numtargets * 3 * (HealPointsSpells:getNumberOfTicks(spell) - 1) - 2 * 0.75 * (numtargets * numtargets - numtargets);
		elseif (numCycles == 1) then
			numTicks = numTicks - numtargets * 2 * (HealPointsSpells:getNumberOfTicks(spell) - 1) - 0.75 * (numtargets * numtargets - numtargets);
		end
		local totalHealed = numTicks * healTick;
		if (numCycles > 1) then
			totalHealed = totalHealed + numtargets * (avgBurst + healTick); -- Last tick + burst when oom
		end

		-- Phase 2: Has no mana left, no stacking
		local secondsPhase2 = seconds - secondsPhase1;
		if (secondsPhase2 > 0) then
			local manaToRegen = manaUsageCycle - regenTimeCasting * (manaRegenCasting / 5);
			cycleTime = regenTimeCasting + manaToRegen / (manaRegenNormal / 5);
			numCycles = secondsPhase2 / cycleTime;
			local healedPhase2 = numCycles * numtargets * (avgBurst + healTick * HealPointsSpells:getNumberOfTicks(spell));
			totalHealed = totalHealed + healedPhase2;
		end
		return totalHealed;

	else
	-- Phase 1: Has enough mana/regen to keep lifebloom up on numtargets constantly
	local cycleTime = math.max(duration + 1, numtargets * getGCD(spellHaste)); -- time between casts on the same target
	local manaUsageCycle = numtargets * manaCost;
	local regenTimeCasting = math.min(cycleTime, 5 + (numtargets - 1) * getGCD(spellHaste));
	local regenTimeNormal = math.max(0, cycleTime - regenTimeCasting);
	local manaRegainCycle = regenTimeCasting * (manaRegenCasting / 5) + regenTimeNormal * (manaRegenNormal / 5);
	local healingPerCycle = numtargets * (avgBurst + healTick * HealPointsSpells:getNumberOfTicks(spell));
	local numCycles = seconds / cycleTime;
	if (manaRegainCycle < manaUsageCycle) then -- if you regen more than you use, you'll never go oom.
		numCycles = math.min(numCycles, startMana / (manaUsageCycle - manaRegainCycle));
	end
	local secondsPhase1 = numCycles * cycleTime;
	local totalHealed = numCycles * healingPerCycle;

	-- Phase 2: Has no mana left
	local secondsPhase2 = seconds - secondsPhase1;
	if (secondsPhase2 > 0) then
		local manaToRegen = manaUsageCycle - regenTimeCasting * (manaRegenCasting / 5);
		cycleTime = regenTimeCasting + manaToRegen / (manaRegenNormal / 5);
		numCycles = secondsPhase2 / cycleTime;
		local healedPhase2 = numCycles * healingPerCycle;
		totalHealed = totalHealed + healedPhase2;
	end

	return totalHealed;
	end
end

local function computeTotalHealingHot(spell, healing, seconds, startMana, spelllHaste, manaRegenCasting, manaRegenNormal)
	local hpCast = getHPCast(spell, healing, 0); -- Can't crit
	local duration = HealPointsSpells:getNumberOfTicks(spell) * spell.class['interval'];
	local manaCost = HealPointsSpells:getManaCost(spell, 0); -- Can't crit
	local numtargets = HealPoints.db.char.hot['numtargets'];

	-- Phase 1: Has enough mana/regen to keep the HoT up on numtargets constantly
	local cycleTime = math.max(duration + 1, numtargets * getGCD(spellHaste)); -- time between casts on the same target
	local manaUsageCycle = numtargets * manaCost;
	local regenTimeCasting = math.min(cycleTime, 5 + (numtargets - 1) * getGCD(spellHaste));
	local regenTimeNormal = math.max(0, cycleTime - regenTimeCasting);
	local manaRegainCycle = regenTimeCasting * (manaRegenCasting / 5) + regenTimeNormal * (manaRegenNormal / 5);
	local healingPerCycle = numtargets * hpCast;
	local numCycles = seconds / cycleTime;
	if (manaRegainCycle < manaUsageCycle) then -- if you regen more than you use, you'll never go oom.
		numCycles = math.min(numCycles, startMana / (manaUsageCycle - manaRegainCycle));
	end
	local secondsPhase1 = numCycles * cycleTime;
	local totalHealed = numCycles * healingPerCycle;

	-- Phase 2: Has no mana left
	local secondsPhase2 = seconds - secondsPhase1;
	if (secondsPhase2 > 0) then
		local manaToRegen = manaUsageCycle - regenTimeCasting * (manaRegenCasting / 5);
		cycleTime = regenTimeCasting + manaToRegen / (manaRegenNormal / 5);
		numCycles = secondsPhase2 / cycleTime;
		local healedPhase2 = numCycles * healingPerCycle;
		totalHealed = totalHealed + healedPhase2;
	end

	return totalHealed;
end

local function computePowerPoints(healing, spellCrit, spellHaste, maxMana, manaRegenCasting, manaRegenNormal)
	local mana = HealPoints.db.char.power['mana'] * maxMana / 100;
	if (HealPoints.db.char.power['auto'] == true) then
		local powerfulSpell;
		local maxPowerPoints = 0;
		for i = 1, table.getn(HealPointsSpells.SPELLTABLE) do
			for j = 1, table.getn(HealPointsSpells.SPELLTABLE[i]), 1 do
				local spell = HealPointsSpells.SPELLTABLE[i][j];
				if (spell ~= nil and HealPointsSpells:getHighestSpellRank(spell.class['name']) == spell['rank'] and spell.class['type'] ~= 'instant') then
					local powerPoints;
					if (spell.class['type'] == 'hot') then
						powerPoints = computeTotalHealingHot(spell, healing, 60 * HealPoints.db.char.power['duration'], mana, spellHaste, manaRegenCasting, manaRegenNormal);
					elseif (spell.class['type'] == 'regrowth') then
						powerPoints = computeTotalHealingRegrowth(spell, healing, 60 * HealPoints.db.char.power['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
					elseif (spell.class['type'] == 'lifebloom') then
						powerPoints = computeTotalHealingLifebloom(spell, healing, 60 * HealPoints.db.char.power['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
					elseif (spell.class['name'] == HealPointsLoc.SPELL_GH and HealPointsBS:GetBonus('GH_RENEW') > 0) then
						powerPoints = computeTotalHealingTrans8(spell, healing, 60 * HealPoints.db.char.power['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
					elseif (spell.class['name'] == HealPointsLoc.SPELL_HT and HealPointsUtil:isPlayerBuffUp(HealPointsLoc.BUFF_TREELI)) then
						powerPoints = 0;
					else
						powerPoints = computeTotalHealingNormal(spell, healing, 60 * HealPoints.db.char.power['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
					end
					if (powerPoints > maxPowerPoints) then
						powerfulSpell = spell;
						maxPowerPoints = powerPoints;
					end
				end
			end
		end
		return maxPowerPoints, powerfulSpell;

	else
		local powerfulSpell = HealPointsSpells:getSpell(HealPoints.db.char.power['spell'], HealPoints.db.char.power['rank']);
		local powerPoints;
		if (powerfulSpell.class['type'] == 'hot') then
			powerPoints = computeTotalHealingHot(powerfulSpell, healing, 60 * HealPoints.db.char.power['duration'], mana, spellHaste, manaRegenCasting, manaRegenNormal);
		elseif (powerfulSpell.class['type'] == 'regrowth') then
			powerPoints = computeTotalHealingRegrowth(powerfulSpell, healing, 60 * HealPoints.db.char.power['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
		elseif (powerfulSpell.class['type'] == 'lifebloom') then
			powerPoints = computeTotalHealingLifebloom(powerfulSpell, healing, 60 * HealPoints.db.char.power['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
		elseif (powerfulSpell.class['name'] == HealPointsLoc.SPELL_GH and HealPointsBS:GetBonus('GH_RENEW') > 0) then
			powerPoints = computeTotalHealingTrans8(powerfulSpell, healing, 60 * HealPoints.db.char.power['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
		else
			powerPoints = computeTotalHealingNormal(powerfulSpell, healing, 60 * HealPoints.db.char.power['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
		end
		return powerPoints, powerfulSpell;
	end
end

local function computeEndurancePoints(healing, spellCrit, spellHaste, maxMana, manaRegenCasting, manaRegenNormal)
	local mana = HealPoints.db.char.endurance['mana'] * maxMana / 100;
	if (HealPoints.db.char.endurance['auto'] == true) then
		local efficientSpell;
		local maxEndurancePoints = 0;
		for i = 1, table.getn(HealPointsSpells.SPELLTABLE), 1 do
			for j = 1, table.getn(HealPointsSpells.SPELLTABLE[i]), 1 do
				local spell = HealPointsSpells.SPELLTABLE[i][j];
				if (spell ~= nil and HealPointsSpells:getHighestSpellRank(spell.class['name']) >= spell['rank'] and spell.class['type'] ~= 'instant') then
					local endurancePoints;
					if (spell.class['type'] == 'hot') then
						endurancePoints = computeTotalHealingHot(spell, healing, 60 * HealPoints.db.char.endurance['duration'], mana, spellHaste, manaRegenCasting, manaRegenNormal);
					elseif (spell.class['type'] == 'regrowth') then
						endurancePoints = computeTotalHealingRegrowth(spell, healing, 60 * HealPoints.db.char.endurance['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
					elseif (spell.class['type'] == 'lifebloom') then
						endurancePoints = computeTotalHealingLifebloom(spell, healing, 60 * HealPoints.db.char.endurance['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
					elseif (spell.class['name'] == HealPointsLoc.SPELL_GH and HealPointsBS:GetBonus('GH_RENEW') > 0) then
						endurancePoints = computeTotalHealingTrans8(spell, healing, 60 * HealPoints.db.char.endurance['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
					elseif (spell.class['name'] == HealPointsLoc.SPELL_HT and HealPointsUtil:isPlayerBuffUp(HealPointsLoc.BUFF_TREELI)) then
						endurancePoints = 0;
					else
						endurancePoints = computeTotalHealingNormal(spell, healing, 60 * HealPoints.db.char.endurance['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
					end
					if (endurancePoints > maxEndurancePoints) then
						efficientSpell = spell;
						maxEndurancePoints = endurancePoints;
					end
				end
			end
		end
		return maxEndurancePoints, efficientSpell;

	else
		local efficientSpell = HealPointsSpells:getSpell(HealPoints.db.char.endurance['spell'], HealPoints.db.char.endurance['rank']);
		local endurancePoints;
		if (efficientSpell.class['type'] == 'hot') then
			endurancePoints = computeTotalHealingHot(efficientSpell, healing, 60 * HealPoints.db.char.endurance['duration'], mana, spellHaste, manaRegenCasting, manaRegenNormal);
		elseif (efficientSpell.class['type'] == 'regrowth') then
			endurancePoints = computeTotalHealingRegrowth(efficientSpell, healing, 60 * HealPoints.db.char.endurance['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
		elseif (efficientSpell.class['type'] == 'lifebloom') then
			endurancePoints = computeTotalHealingLifebloom(efficientSpell, healing, 60 * HealPoints.db.char.endurance['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
		elseif (efficientSpell.class['name'] == HealPointsLoc.SPELL_GH and HealPointsBS:GetBonus('GH_RENEW') > 0) then
			endurancePoints = computeTotalHealingTrans8(efficientSpell, healing, 60 * HealPoints.db.char.endurance['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
		else
			endurancePoints = computeTotalHealingNormal(efficientSpell, healing, 60 * HealPoints.db.char.endurance['duration'], mana, spellCrit, spellHaste, manaRegenCasting, manaRegenNormal);
		end
		return endurancePoints, efficientSpell;
	end
end

local function computeHealpoints(healing, spellCrit, spellHaste, maxMana, manaRegenCasting, manaRegenNormal)
	local powerPoints, powerfulSpell = computePowerPoints(healing, spellCrit, spellHaste, maxMana, manaRegenCasting, manaRegenNormal);
	local endurancePoints, efficientSpell = computeEndurancePoints(healing, spellCrit, spellHaste, maxMana, manaRegenCasting, manaRegenNormal);
	local healPoints = powerPoints + endurancePoints;
	return healPoints, powerPoints, endurancePoints, powerfulSpell, efficientSpell;
end

-- Compute current and new values
local function getCurrentAndNewManaRegen(itemIntDelta, itemSpiDelta, itemCastingRegenDelta)
	local function getRegenNormal(spi, int)
		return (0.001 + spi * BASE_REGEN[UnitLevel("player")] * math.pow(int, 0.5)) * 5;
--[[		local baseSpirit = min(50, spi);
		local moreSpirit = spi - baseSpirit;
		local baseRate = 0.25;
		local moreRate;
		local _, unitClass = UnitClass("player");
		if (unitClass == "PRIEST" ) then
			moreRate = 0.125;
		elseif ( unitClass == "DRUID" ) then
			moreRate = 0.1125;
		else
			moreRate = 0.1; -- paladin, shaman
		end
		return 5 * (baseSpirit * baseRate + moreSpirit * moreRate);]]
	end

	local function getRegenCastingInt(int)
		local mana5Int = 0;
		local talentDreamstate = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_DREAMS); -- 4/7/10% of intellect as mana/5
		local talentUnrelentStorm = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_UNRSTO); -- 2% of intellect as mana/5 per rank
		if (talentDreamstate == 1) then
			mana5Int = 0.04 * int;
		elseif (talentDreamstate == 2) then
			mana5Int = 0.07 * int;
		elseif (talentDreamstate == 3) then
			mana5Int = 0.1 * int;
		end
		mana5Int = mana5Int + 0.02 * talentUnrelentStorm * int;
		return mana5Int;
	end

	-- Base stats
	local manaRegenNormal, manaRegenCasting = GetManaRegen();
	manaRegenNormal = HealPointsUtil:round(manaRegenNormal * 5) + itemCastingRegenDelta;
	manaRegenCasting = HealPointsUtil:round(manaRegenCasting * 5) + itemCastingRegenDelta;

	local talentMeditation = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_MEDITA); -- 10% spi mana regen while casting per rank (priest)
	local talentIntensity = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_INTENS); -- 10% spi mana regen while casting per rank (druid)
	local percentRegen = 0.1 * talentMeditation + 0.1 * talentIntensity + HealPointsBS:GetBonus('CASTINGREG') / 100;

	-- Item bonuses
	local _, intellect, _, _ = UnitStat("player", 4);
	local _, spirit, _, _ = UnitStat("player", 5);
	local itemRegenNormal = getRegenNormal(spirit + itemSpiDelta, intellect + itemIntDelta) - getRegenNormal(spirit, intellect);
	local itemRegenCasting = getRegenCastingInt(itemIntDelta);
	manaRegenNormal = manaRegenNormal + itemRegenNormal + itemRegenCasting;
	manaRegenCasting = manaRegenCasting + percentRegen * itemRegenNormal + itemRegenCasting;

	-- Calculator bonuses
	local calcInt = getglobal("HealPointsVariables1InputBox"):GetNumber() * (1 + BonusPercentInt);
	local calcSpi = getglobal("HealPointsVariables2InputBox"):GetNumber() * (1 + BonusPercentSpi);
	local calcCastingRegen = getglobal("HealPointsVariables4InputBox"):GetNumber();
	local calcNormalRegen = getglobal("HealPointsVariables5InputBox"):GetNumber();
	local calcPercentRegen = getglobal("HealPointsVariables6InputBox"):GetNumber() / 100;

	local manaRegenSpirit = getRegenNormal(spirit + itemSpiDelta, intellect + itemIntDelta);
	local manaRegenSpiritNew = getRegenNormal(spirit + itemSpiDelta + calcSpi, intellect + itemIntDelta + calcInt);
	local deltaRegenSpirit = manaRegenSpiritNew - manaRegenSpirit;

	local percentRegenNew = percentRegen + calcPercentRegen;

	local deltaCasting = calcCastingRegen + getRegenCastingInt(calcInt);
	local deltaNormal = calcNormalRegen + deltaRegenSpirit;

	local manaRegenNormalNew = manaRegenNormal + deltaNormal + deltaCasting;
	local manaRegenCastingNew = manaRegenCasting + percentRegenNew * deltaNormal + deltaCasting + calcPercentRegen * manaRegenSpiritNew;

	return manaRegenNormal, manaRegenCasting, manaRegenNormalNew, manaRegenCastingNew, percentRegen;
end

local function getCurrentAndNewMaxMana(itemManaDelta, itemIntDelta)
	local currentMana = UnitManaMax("player") + itemManaDelta + (15 * itemIntDelta) * (1 + BonusPercentMana);

	local intDelta = getglobal("HealPointsVariables1InputBox"):GetNumber() * (1 + BonusPercentInt);
	local newMana = currentMana + (getglobal("HealPointsVariables3InputBox"):GetNumber() + 15 * intDelta) * (1 + BonusPercentMana);
	return currentMana, newMana;
end

local function getCurrentAndNewHealing(itemHealDelta, itemIntDelta, itemSpiDelta, itemAgiDelta)
	local holyGuidance = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_HOLYGU); -- 7/14/21/28/35% of intellect
	local lunarGuidance = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_LUNGUI); -- 8/16/25% of intellect
	local natureBlessing = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_NATBLE); -- 10/20/30% of intellect
	local spiritualGuidance = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_SPIGUI); -- 5/10/15/20/25% of spirit
	local nurturingInstinct = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_NURINS); -- 50/100% of agility

	local temp = HealPointsBS:GetBonus('HEALFROMINT');

	local healingDelta = (holyGuidance * 0.07 + lunarGuidance * 0.0833 + natureBlessing * 0.1 + temp * 0.01) * itemIntDelta;
	healingDelta = healingDelta + spiritualGuidance * 0.05 * itemSpiDelta;
	healingDelta = healingDelta + nurturingInstinct * 0.50 * itemAgiDelta;

	local healingDeltaNew = getglobal("HealPointsVariables7InputBox"):GetNumber();
	itemIntDelta = itemIntDelta + getglobal("HealPointsVariables1InputBox"):GetNumber() * (1 + BonusPercentInt);
	itemSpiDelta = itemSpiDelta + getglobal("HealPointsVariables2InputBox"):GetNumber() * (1 + BonusPercentSpi);
	healingDeltaNew = healingDeltaNew + (holyGuidance * 0.07 + lunarGuidance * 0.0833 + natureBlessing * 0.1 + temp * 0.01) * itemIntDelta;
	healingDeltaNew = healingDeltaNew + spiritualGuidance * 0.05 * itemSpiDelta;
	healingDeltaNew = healingDeltaNew + nurturingInstinct * 0.50 * itemAgiDelta;

	local currentHealing = GetSpellBonusHealing() + itemHealDelta;

	return currentHealing + healingDelta, currentHealing + healingDeltaNew;
end

local function getCurrentAndNewSpellCrit(itemIntDelta, itemCritRatingDelta)
	local function ratingToPercent(critRating)
		if (UnitLevel("player") < 61) then
			return critRating * 52 / (14 * (math.max(10, UnitLevel("player")) - 8));
		else
			return critRating * (262 - 3 * UnitLevel("player")) / (14 * 82);
		end
	end

	-- BaseCrit: 3.33 (paladin), 0.8 (priest), 1.85 (druid), 3.7 (shaman)

	local intPerCrit = 0;
	local spellCrit = 0;

	local _, className = UnitClass("player");
	if (className == "PALADIN") then
		-- intPerCrit = 54; @ lvl 60
		intPerCrit = 80;
		spellCrit = GetSpellCritChance(2); -- Holy
	elseif (className == "PRIEST") then
		-- intPerCrit = 59.5; @ lvl 60
		intPerCrit = 80;
		spellCrit = GetSpellCritChance(2); -- Holy
	elseif (className == "DRUID") then
		-- intPerCrit = 61; @ lvl 60
		intPerCrit = 80;
		spellCrit = GetSpellCritChance(4); -- Nature
	elseif (className == "SHAMAN") then
		-- intPerCrit = 57.1429; @lvl 60
		intPerCrit = 80;
		spellCrit = GetSpellCritChance(4); -- Nature
	end

	local critFromDeltaRating = ratingToPercent(itemCritRatingDelta);
	local critFromDeltaInt = itemIntDelta / intPerCrit;
	local currentSpellCrit = spellCrit + critFromDeltaRating + critFromDeltaInt;

	local critRatingDelta = itemCritRatingDelta + getglobal("HealPointsVariables8InputBox"):GetNumber();
	local intDelta = itemIntDelta + getglobal("HealPointsVariables1InputBox"):GetNumber() * (1 + BonusPercentInt);

	critFromDeltaRating = ratingToPercent(critRatingDelta);
	critFromDeltaInt = intDelta / intPerCrit;
	local newSpellCrit = spellCrit + critFromDeltaRating + critFromDeltaInt;

	return currentSpellCrit, newSpellCrit;
end

local function getCurrentAndNewSpellHaste(itemHasteRatingDelta)
	local function ratingToPercent(hasteRating)
		if (UnitLevel("player") < 61) then
			return hasteRating * 52 / (10 * (math.max(10, UnitLevel("player")) - 8));
		else
			return hasteRating * (262 - 3 * UnitLevel("player")) / (10 * 82);
		end
	end

	local spellHaste = GetCombatRatingBonus(20);

	local hasteFromDelta = ratingToPercent(itemHasteRatingDelta);
	local currentSpellHaste = spellHaste + hasteFromDelta;

	hasteFromDelta = ratingToPercent(itemHasteRatingDelta + getglobal("HealPointsVariables9InputBox"):GetNumber());
	local newSpellHaste = spellHaste + hasteFromDelta;

	return currentSpellHaste, newSpellHaste;
end

-- Global functions
function HealPointsCalculator:updateStats() -- Update stats (int, spi, regen, ...)
	if (BonusPercentInt == nil) then
		self:talentsChanged();
	end

	-- Intellect
	local _, currentIntellect, _, _ = UnitStat("player", 4);
	local intDelta = getglobal("HealPointsVariables1InputBox"):GetNumber();
	local extraInt = BonusPercentInt * intDelta;
	HealPointsCalculatorUI:setVariableStatInfo(1, currentIntellect, extraInt, "%5.0f");
	intDelta = intDelta + extraInt;

	-- Spirit
	local _, currentSpirit, _, _ = UnitStat("player", 5);
	local extraSpi = BonusPercentSpi * getglobal("HealPointsVariables2InputBox"):GetNumber();
	HealPointsCalculatorUI:setVariableStatInfo(2, currentSpirit, extraSpi, "%5.0f");

	-- Max mana
	local currentMana = UnitManaMax("player");
	local extraMana = BonusPercentMana * (getglobal("HealPointsVariables3InputBox"):GetNumber() + 15 * intDelta);
	HealPointsCalculatorUI:setVariableStatInfo(3, currentMana, 15 * intDelta + extraMana, "%5.0f");

	-- Mana regen (casting, normal, %casting)
	local manaRegenNormal, manaRegenCasting, manaRegenNormalNew, manaRegenCastingNew, percentRegen = getCurrentAndNewManaRegen(0, 0, 0);
	local manaRegenCastingDelta = manaRegenCastingNew - manaRegenCasting - getglobal("HealPointsVariables4InputBox"):GetNumber();
	local manaRegenNormalDelta = manaRegenNormalNew - manaRegenNormal - getglobal("HealPointsVariables5InputBox"):GetNumber();

	HealPointsCalculatorUI:setVariableStatInfo(4, manaRegenCasting, manaRegenCastingDelta, "%5.0f");
	HealPointsCalculatorUI:setVariableStatInfo(5, manaRegenNormal, manaRegenNormalDelta, "%5.0f");
	HealPointsCalculatorUI:setVariableStatInfo(6, 100 * percentRegen, 0, "%5.0f");

	-- +Healing
	local currentHealing, newHealing = getCurrentAndNewHealing(0, 0, 0, 0);
	HealPointsCalculatorUI:setVariableStatInfo(7, currentHealing, newHealing - currentHealing - getglobal("HealPointsVariables7InputBox"):GetNumber(), "%5.0f");

	-- Spell crit rating
	HealPointsCalculatorUI:setVariableStatInfo(8, GetCombatRating(11), 0, "%5.0f");

	-- Spell haste rating
	HealPointsCalculatorUI:setVariableStatInfo(9, GetCombatRating(20), 0, "%5.0f");
end

function HealPointsCalculator:displaySpellStats(spell) -- Show derived stats about specified spell
	if (BonusPercentInt == nil) then
		self:talentsChanged();
	end

	local _, manaRegenCasting, _, manaRegenCastingNew = getCurrentAndNewManaRegen(0, 0, 0);
	local currentMana, newMana = getCurrentAndNewMaxMana(0, 0);
	local currentHealing, newHealing = getCurrentAndNewHealing(0, 0, 0, 0);
	local currentSpellCrit, newSpellCrit = getCurrentAndNewSpellCrit(0, 0);
	local currentSpellHaste, newSpellHaste = getCurrentAndNewSpellHaste(0);

	local oldHPSec = getHPSec(spell, currentHealing, currentSpellCrit, currentSpellHaste);
	local newHPSec = getHPSec(spell, newHealing, newSpellCrit, newSpellHaste);
	local oldHPMana = getHPMana(spell, currentHealing, currentSpellCrit);
	local newHPMana = getHPMana(spell, newHealing, newSpellCrit);
	local oldHPCast = getHPCast(spell, currentHealing, currentSpellCrit);
	local newHPCast = getHPCast(spell, newHealing, newSpellCrit);
	local oldHPTotalRegen, t1 = getHPTotalRegen(spell, currentHealing, currentSpellCrit, currentSpellHaste, manaRegenCasting, currentMana);
	local newHPTotalRegen, t2 = getHPTotalRegen(spell, newHealing, newSpellCrit, newSpellHaste, manaRegenCastingNew, newMana);
	local oldCrit = currentSpellCrit + HealPointsSpells:getSpellCritBonus(spell);
	local newCrit = newSpellCrit + HealPointsSpells:getSpellCritBonus(spell);
	local oldCastTime = HealPointsSpells:getCastTime(spell, currentSpellHaste);
	local newCastTime = HealPointsSpells:getCastTime(spell, newSpellHaste);

	-- Common stats
	HealPointsCalculatorUI:setSpellStat(1, "HP/s:", oldHPSec, newHPSec, "%d");
	HealPointsCalculatorUI:setSpellStat(2, "HP/mana:", oldHPMana, newHPMana, "%1.1f");
	HealPointsCalculatorUI:setSpellStat(3, "HP/cast:", oldHPCast, newHPCast, "%d");
	HealPointsCalculatorUI:setSpellStat(4, "HP/manabar:", oldHPTotalRegen, newHPTotalRegen, "%d");

	-- Spell specific stats
	if (spell['class'].type ~= 'hot') then
		HealPointsCalculatorUI:setSpellStat(5, "Spell crit(%):", oldCrit, newCrit, "%1.2f");
	else
		local oldHPTick = getHPTick(spell, currentHealing);
		local newHPTick = getHPTick(spell, newHealing);
		HealPointsCalculatorUI:setSpellStat(5, "HP/tick:", oldHPTick, newHPTick, "%d");
	end

	if (spell['class'].type ~= 'hot' and spell['class'].type ~= 'instant' and spell['class'].type ~= 'lifebloom' and
		spell['class'].name ~= HealPointsLoc.SPELL_HOLYNOVA and spell['class'].name ~= HealPointsLoc.SPELL_COH) then
		HealPointsCalculatorUI:setSpellStat(6, "Cast time:", oldCastTime, newCastTime, "%1.2f");
	elseif (spell['class'].type == 'lifebloom') then
		local oldHPTick = getHPTick(spell, currentHealing);
		local newHPTick = getHPTick(spell, newHealing);
		HealPointsCalculatorUI:setSpellStat(6, "HP/tick:", oldHPTick, newHPTick, "%d");
	else
		HealPointsCalculatorUI:setSpellStat(6, nil);
	end

	if (spell['class'].type == 'regrowth') then
		local oldHPTick = getHPTick(spell, currentHealing);
		local newHPTick = getHPTick(spell, newHealing);
		HealPointsCalculatorUI:setSpellStat(7, "HP/tick:", oldHPTick, newHPTick, "%d");
	else
		HealPointsCalculatorUI:setSpellStat(7, nil);
	end

	local healFactor1, healFactor2 = HealPointsSpells:getHealingFactor(spell);
	local spellBonus = HealPointsSpells:getHealingPercentBonus(spell);
	healFactor1 = healFactor1 * spellBonus;
	if (healFactor2 ~= nil) then
		healFactor2 = healFactor2 * spellBonus;
	end
	if (spell['class'].type == 'aoe') then
		healFactor1 = healFactor1 * math.min(5, HealPoints.db.char.hot['numtargets']);
	end
	HealPointsCalculatorUI:setHealFactor(healFactor1, healFactor2);

	HealPointsCalculatorUI:setTimeToOOM(t1, t2);
end

function HealPointsCalculator:updateHealPoints() -- Update the healpoints statistic
	if (BonusPercentInt == nil) then
		self:talentsChanged();
	end

	local manaRegenNormal, manaRegenCasting, manaRegenNormalNew, manaRegenCastingNew = getCurrentAndNewManaRegen(0, 0, 0);
	local currentMana, newMana = getCurrentAndNewMaxMana(0, 0);
	local currentHealing, newHealing = getCurrentAndNewHealing(0, 0, 0, 0);
	local currentSpellCrit, newSpellCrit = getCurrentAndNewSpellCrit(0, 0);
	local currentSpellHaste, newSpellHaste = getCurrentAndNewSpellHaste(0);

	local healPointsCurrent, healedPowerful, healedEfficient, powerfulCurrent, efficientCurrent =
	computeHealpoints(currentHealing, currentSpellCrit, currentSpellHaste, currentMana, manaRegenCasting, manaRegenNormal);

	local healPointsNew, healedPowerfulNew, healedEfficientNew, powerfulNew, efficientNew =
	computeHealpoints(newHealing, newSpellCrit, newSpellHaste, newMana, manaRegenCastingNew, manaRegenNormalNew);

	self.HP_LastPowerfulCurrent = powerfulCurrent;
	self.HP_LastPowerfulNew = powerfulNew;
	self.HP_LastEfficientCurrent = efficientCurrent;
	self.HP_LastEfficientNew = efficientNew;

	if (HealPoints_CalcFrame:IsVisible()) then
		HealPointsCalculatorUI:setHealPoints(healedPowerful, healedPowerfulNew, healedEfficient, healedEfficientNew);
	end
	if (CharacterFrame:IsVisible()) then
		HealPointsCharUI:setStats(healPointsCurrent, healedPowerful, healedEfficient, powerfulCurrent, efficientCurrent);
	end
end

function HealPointsCalculator:computeHealPointsDelta()
	if (BonusPercentInt == nil) then
		self:talentsChanged();
	end

	-- Calculator for 1 in improvement to int, spi, mp5, +heal, critRating, hasteRating

	local currentManaRegenNormal, currentManaRegenCasting = getCurrentAndNewManaRegen(0, 0, 0);
	local intManaRegenNormal, intManaRegenCasting = getCurrentAndNewManaRegen(1, 0, 0);
	local spiManaRegenNormal, spiManaRegenCasting = getCurrentAndNewManaRegen(0, 1, 0);
	local mp5ManaRegenNormal = currentManaRegenNormal + 1;
	local mp5ManaRegenCasting = currentManaRegenCasting + 1;

	local currentMana = getCurrentAndNewMaxMana(0, 0);
	local intMana = getCurrentAndNewMaxMana(0, 1);

	local currentHealing = getCurrentAndNewHealing(0, 0, 0, 0);
	local healHealing = getCurrentAndNewHealing(1, 0, 0, 0);
	local intHealing = getCurrentAndNewHealing(0, 1, 0, 0);
	local spiHealing = getCurrentAndNewHealing(0, 0, 1, 0);

	local currentSpellCrit = getCurrentAndNewSpellCrit(0, 0);
	local intSpellCrit = getCurrentAndNewSpellCrit(1, 0);
	local critSpellCrit = getCurrentAndNewSpellCrit(0, 1);

	local currentSpellHaste = getCurrentAndNewSpellHaste(0);
	local hasteSpellHaste = getCurrentAndNewSpellHaste(1);

	local currentHealPoints = computeHealpoints(currentHealing, currentSpellCrit, currentSpellHaste, currentMana, currentManaRegenCasting, currentManaRegenNormal);
	local intHealPoints = computeHealpoints(intHealing, intSpellCrit, currentSpellHaste, intMana, intManaRegenCasting, intManaRegenNormal);
	local spiHealPoints = computeHealpoints(spiHealing, currentSpellCrit, currentSpellHaste, currentMana, spiManaRegenCasting, spiManaRegenNormal);
	local mp5HealPoints = computeHealpoints(currentHealing, currentSpellCrit, currentSpellHaste, currentMana, mp5ManaRegenCasting, mp5ManaRegenNormal);
	local healHealPoints = computeHealpoints(healHealing, currentSpellCrit, currentSpellHaste, currentMana, currentManaRegenCasting, currentManaRegenNormal);
	local critHealPoints = computeHealpoints(currentHealing, critSpellCrit, currentSpellHaste, currentMana, currentManaRegenCasting, currentManaRegenNormal);
	local hasteHealPoints = computeHealpoints(currentHealing, currentSpellCrit, hasteSpellHaste, currentMana, currentManaRegenCasting, currentManaRegenNormal);

	return intHealPoints - currentHealPoints, spiHealPoints - currentHealPoints, mp5HealPoints - currentHealPoints,
	healHealPoints - currentHealPoints, critHealPoints - currentHealPoints, hasteHealPoints - currentHealPoints;
end

function HealPointsCalculator:computeHealpointsDiff(itemLink)
	local function lookup(table, index)
		if (table == nil or table[index] == nil) then
			return 0;
		end
		return table[index];
	end

	local function computeHP(itemBonuses, slotBonuses)
		local intDelta = HealPointsUtil:round((lookup(itemBonuses, "INT") - lookup(slotBonuses, "INT")) * (1 + BonusPercentInt));
		local spiDelta = HealPointsUtil:round((lookup(itemBonuses, "SPI") - lookup(slotBonuses, "SPI")) * (1 + BonusPercentSpi));
		local manaDelta = HealPointsUtil:round((lookup(itemBonuses, "MANA") - lookup(slotBonuses, "MANA")) * (1 + BonusPercentMana));
		local agiDelta = lookup(itemBonuses, "AGI") - lookup(slotBonuses, "AGI");
		local critRatingDelta = lookup(itemBonuses, "SPELLCRITRATING") - lookup(slotBonuses, "SPELLCRITRATING");
		local hasteRatingDelta = lookup(itemBonuses, "SPELLHASTERATING") - lookup(slotBonuses, "SPELLHASTERATING");
		local castingRegenDelta = lookup(itemBonuses, "MANAREG") - lookup(slotBonuses, "MANAREG");
		local healDelta = lookup(itemBonuses, "HEAL") - lookup(slotBonuses, "HEAL");

		local iHealing, iHealingNew = getCurrentAndNewHealing(healDelta, intDelta, spiDelta, agiDelta);
		local iSpellCrit, iSpellCritNew = getCurrentAndNewSpellCrit(intDelta, critRatingDelta);
		local iSpellHaste, iSpellHasteNew = getCurrentAndNewSpellHaste(hasteRatingDelta);
		local iMana, iManaNew = getCurrentAndNewMaxMana(manaDelta, intDelta);
		local iManaRegenNormal, iManaRegenCasting, iManaRegenNormalNew, iManaRegenCastingNew = getCurrentAndNewManaRegen(intDelta, spiDelta, castingRegenDelta);

		iHealing = HealPointsUtil:round(iHealing);
		iMana = HealPointsUtil:round(iMana);
		iHealingNew = HealPointsUtil:round(iHealingNew);
		iManaNew = HealPointsUtil:round(iManaNew);

		if (HealPoints.db.char.debug ~= 0) then
			DEFAULT_CHAT_FRAME:AddMessage("Tooltip debug: +int:"..intDelta.. " +spi:"..spiDelta.." +healing:"..healDelta.." +mana/5:"..castingRegenDelta.." +critRating:"..critRatingDelta.." +hasteRating:"..hasteRatingDelta,0.6,0.6,1);
			DEFAULT_CHAT_FRAME:AddMessage("New stats: "..iHealing..", "..iSpellCrit..", "..iSpellHaste..", "..iMana..", "..iManaRegenCasting..", "..iManaRegenNormal,0.6,0.6,1);
		end
		local iHealPoints = computeHealpoints(iHealing, iSpellCrit, iSpellHaste, iMana, iManaRegenCasting, iManaRegenNormal);
		local iHealPointsNew = iHealPoints;
		if (iHealingNew ~= iHealing or iSpellCritNew ~= iSpellCrit or iManaNew ~= iMana or iManaRegenCastingNew ~= iManaRegenCasting or
			iManaRegenNormalNew ~= iManaRegenNormal or iSpellHasteNew ~= iSpellHaste) then
			iHealPointsNew = computeHealpoints(iHealingNew, iSpellCritNew, iSpellHasteNew, iManaNew, iManaRegenCastingNew, iManaRegenNormalNew);
		end
		return iHealPoints, iHealPointsNew
	end

	if (BonusPercentInt == nil) then
		self:talentsChanged();
	end

	local itemBonuses, slotBonuses, slotBonuses2 = HealPointsBS:getItemSlotBonuses(itemLink);
	if (itemBonuses == nil) then
		return 0, 0;
	end

	if (HealPoints.db.char.debug ~= 0) then
		DEFAULT_CHAT_FRAME:AddMessage("Bonuses for: "..itemLink,1,1,1);
		for bonus, details in pairs(itemBonuses) do
			HealPoints:Print(bonus..": "..details);
		end
		if (slotBonuses ~= nil) then
			DEFAULT_CHAT_FRAME:AddMessage("Replaces these bonuses: ",1,1,1);
			for bonus, details in pairs(slotBonuses) do
				HealPoints:Print(bonus..": "..details);
			end
		end
	end

	-- Current healpoints
	local healing, healingNew= getCurrentAndNewHealing(0, 0, 0, 0);
	local spellCrit, spellCritNew = getCurrentAndNewSpellCrit(0, 0);
	local spellHaste, spellHasteNew = getCurrentAndNewSpellHaste(0);
	local mana, manaNew = getCurrentAndNewMaxMana(0, 0)
	local manaRegenNormal, manaRegenCasting, manaRegenNormalNew, manaRegenCastingNew = getCurrentAndNewManaRegen(0, 0, 0);

	--DEFAULT_CHAT_FRAME:AddMessage("Current: "..healing..", "..spellCrit..", "..spellHaste..", "..mana..", "..manaRegenCasting..", "..manaRegenNormal,0.6,0.6,1);
	local healPoints = computeHealpoints(healing, spellCrit, spellHaste, mana, manaRegenCasting, manaRegenNormal);
	local healPointsNew = healPoints;
	if (healingNew ~= healing or spellCritNew ~= spellCrit or manaNew ~= mana or manaRegenCastingNew ~= manaRegenCasting or manaRegenNormalNew ~= manaRegenNormal) then
		healPointsNew = computeHealpoints(healingNew, spellCritNew, spellHasteNew, manaNew, manaRegenCastingNew, manaRegenNormalNew);
	end

	-- Difference
	local iHealPoints, iHealPointsNew = computeHP(itemBonuses, slotBonuses);
	if (slotBonuses2) then
		local iHealPoints2, iHealPointsNew2 = computeHP(itemBonuses, slotBonuses2);
		return iHealPoints - healPoints, iHealPointsNew - healPointsNew, iHealPoints2 - healPoints, iHealPointsNew2 - healPointsNew;
	else
		return iHealPoints - healPoints, iHealPointsNew - healPointsNew;
	end
end

function HealPointsCalculator:talentsChanged()
	BonusPercentMana = 0;
	BonusPercentInt = 0;
	BonusPercentSpi = 0;

	local _, raceName = UnitRace("player");
	if (raceName == "Human") then
		BonusPercentSpi = 0.1;
	end

	local _, className = UnitClass("player");
	if (className == "PALADIN") then
		local divineIntellect = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_DIVINT); -- Increases intellect by 2% per rank
		BonusPercentInt = 0.02 * divineIntellect;

	elseif (className == "PRIEST") then
		local mentalStrength = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_MENSTR); -- Increases maximum mana by 2% per rank
		BonusPercentMana = 0.02 * mentalStrength;

		local enlightenment = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_ENLIGH); -- Increases int/spi by 1% per rank
		BonusPercentInt = 0.01 * enlightenment;
		BonusPercentSpi = BonusPercentSpi + 0.01 * enlightenment;

		local spiritOfRedemption = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_SPIRED); -- Increases spi by 5%
		BonusPercentSpi = BonusPercentSpi + 0.05 * spiritOfRedemption;

	elseif (className == "DRUID") then
		local heartOfTheWild = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_HEOFWI); -- Increases int by 4% per rank
		BonusPercentInt = 0.04 * heartOfTheWild;

		local livingSpirit = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_LIVSPI); -- Increases spi by 5% per rank
		BonusPercentSpi = 0.05 * livingSpirit;

		local survivalFittest = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_SURFIT); -- Increases all stats by 1% per rank
		BonusPercentInt = BonusPercentInt + 0.01 * survivalFittest;
		BonusPercentSpi = BonusPercentSpi + 0.01 * survivalFittest;

	elseif (className == "SHAMAN") then
		local ancestralKnowledge = HealPointsUtil:getTalentRank(HealPointsLoc.TALENT_ANCKNO); -- Increases maximum mana by 1% per rank
		BonusPercentMana = 0.01 * ancestralKnowledge;
	end
end