--------------------------------------------------
-- BonusScanner v1.1
-- by Crowley <crowley@headshot.de>
-- performance improvements by Archarodim
--
-- get the latest version here:
-- http://ui.worldofwar.net/ui.php?id=1461
-- http://www.curse-gaming.com/mod.php?addid=2384
--
-- Modified for HealPoints by Eridan
--------------------------------------------------

local PATTERN_SETNAME = "^(.*) %(%d/%d%)$";
local PATTERN_GENERIC_PREFIX = "^%+?(%d+)%%?(.*)$";
local PATTERN_GENERIC_SUFFIX = "^(.*)%+(%d+)%%?$";
local PATTERN_GENERIC_TWOPRE = "^%+?(%d+)%s([^%+]+)%s"..HealPointsBSL.AND.."%s%+?(%d+)%s(.+)%.?$";
local PATTERN_HEALING_TWOPRE = "^%+(%d+)%s([^%s]+)%s%+%d+%s.+%s"..HealPointsBSL.AND.."%s%+?(%d+)%s(.+)%.?$";
local PATTERN_GENERIC_TWOSUF = "^(.+)%s%+(%d+)%s"..HealPointsBSL.AND.."%s(.+)%s%+?(%d+)%.?$";

HealPointsBS ={
	bonuses = { };
	bonuses_details = { };

	IsUpdating = false; -- not sure if this check is needed but who knows with multithreading...
	MinCheckInterval = 1; -- Minimum time to wait between each scan
	CheckIntervalCounter = 0; -- counter, do not change
	CheckForBonusPlease = 0; -- The flag that when set makes BonusScanner scan the equipment and call the update function

	active = nil;
	temp ={
		sets = { }, -- oversikt over sett som er parset (1 = parset)
		set = "", -- settnavn p sist sette sett (tingen som parses n)
		slot = "", -- navn p den slot'en som parses n
		bonuses = { }, -- bonuser under parsing
		details = { }, -- detaljer per slot
		emptySockets = false;
	};

	types ={
		"AGI", -- agility
		"INT", -- intellect
		"SPI", -- spirit
		"HEAL", -- healing
		"MANAREG", -- mana regeneration per 5 sec.
		"MANA", -- mana points

		-- Added
		"SPELLCRITRATING", -- spell critical strike rating
		"SPELLHASTERATING", -- spell haste rating
		"CASTINGREG", -- % mana regeneration while casting
		"HEALFROMINT", -- % of int added to healing

		"TIME_HL", -- reduced casting time Holy Light
		"CRIT_FOL", -- extra crit% Flash of Light
		"CRIT_HL", -- extra crit% Holy Light
		"AVG_PC_FOL", -- increased effect Flash of Light by %

		"TIME_FH", -- reduced casting time Flash Heal
		"CRIT_POH", -- extra crit% PoH
		"GH_RENEW", -- Greater Heal also gives Renew effect
		"MANA_PC_RENEW", -- Cheaper Renew by %
		"DURATION_RENEW", -- increased duration Renew
		"MANA_PC_POH", -- Cheaper PoH by %
		"AVG_PC_GH", -- increased effect Greater Heal by %

		"TIME_REGR", -- reduced casting time Regrowth
		"DURATION_REJUV", -- increased duration Rejuvenation
		"MANA_PC_DRUID", -- Cheaper druids spells by %
		"MANA_REFUND_CRIT_HT", -- Refund of % mana on HT crits
		"DURATION_REGR", -- increased duration Regrowth
		"AVG_BURST_LIFEBL", -- increased effect from Lifebloom (Burst only)
		"AVG_PC_HT", -- increased effect from Healing Touch by %

		"MANA_REFUND_HWLHW",-- chance for mana refund on (Lesser) Healing Wave cast
		"JUMP_HW", -- Healing Wave jumps to nearby targets
		"AVG_PC_JUMPS_CHAIN", -- increased effect from chain heal jumps
		"TIME_CHAIN", -- reduced casting time Chain Heal
		"MANA_PC_LHW", -- cheaper Lesser Healing Wave by %
		"MANA_PC_CHAIN", -- cheaper Chain Heal by %
		"AVG_PC_CHAIN", -- increased effect Chain Heal by %

		"AVG_ABS_FOL", -- increased effect from Flash of Light
		"AVG_ABS_BOL", -- increased effect from Blessing of Light
		"AVG_ABS_HL", -- increased effect from Holy Light
		"MANA_ABS_HL", -- cheaper Holy Light by mana

		"AVG_ABS_HT", -- increased effect from Healing Touch
		"MANA_REFUND_HT", -- Refund x mana on HT casts
		"AVG_ABS_REJUV", -- increased effect from Rejuvenation
		"AVG_HOT_LIFEBL", -- increased effect from Lifebloom (HoT only)
		"MANA_ABS_REGR", -- cheaper Regrowth by mana
		"MANA_ABS_REJUV", -- cheaper Rejuvenation by mana

		"MANA_REFUND_LHW", -- Refund x mana on Lesser Healing Wave casts
		"AVG_ABS_CHAIN", -- increased base effect of chain heal
		"AVG_ABS_LHW", -- increased effect from Lesser Healing Wave
		"MANA_ABS_HW", -- cheaper Healing Wave by mana
		"AVG_ABS_HW", -- increased effect from Healing Wave
		"MANA_ABS_CHAIN", -- cheaper Chain Heal by mana
	};

	slots ={
		"Head",
		"Neck",
		"Shoulder",
		"Shirt",
		"Chest",
		"Waist",
		"Legs",
		"Feet",
		"Wrist",
		"Hands",
		"Finger0",
		"Finger1",
		"Trinket0",
		"Trinket1",
		"Back",
		"MainHand",
		"SecondaryHand",
		"Ranged",
		"Tabard",
	};
}

local slotConvert ={
	INVTYPE_HEAD = "Head",
	INVTYPE_NECK = "Neck",
	INVTYPE_SHOULDER = "Shoulder",
	INVTYPE_BODY = "Shirt",
	INVTYPE_CHEST = "Chest",
	INVTYPE_ROBE = "Chest",
	INVTYPE_WAIST = "Waist",
	INVTYPE_LEGS = "Legs",
	INVTYPE_FEET = "Feet",
	INVTYPE_WRIST = "Wrist",
	INVTYPE_HAND = "Hands",
	INVTYPE_FINGER = "Finger0",
	INVTYPE_TRINKET = "Trinket0",
	INVTYPE_CLOAK = "Back",
	INVTYPE_WEAPON = "MainHand",
	INVTYPE_SHIELD = "SecondaryHand",
	INVTYPE_2HWEAPON = "MainHand",
	INVTYPE_WEAPONMAINHAND = "MainHand",
	INVTYPE_WEAPONOFFHAND = "SecondaryHand",
	INVTYPE_HOLDABLE = "SecondaryHand",
	INVTYPE_RANGED = "Ranged",
	INVTYPE_THROWN = "Ranged",
	INVTYPE_RANGEDRIGHT = "Ranged",
	INVTYPE_TABARD = "Tabard" ,
	INVTYPE_RELIC = "Ranged"
};


local function GetSlotBonuses(slotname)
	local bonus, details;
	local bonuses = {};
	for bonus, details in pairs(HealPointsBS.bonuses_details) do
		if (details[slotname]) then
			bonuses[bonus] = details[slotname];
		end
	end
	return bonuses;
end

local function isEnchanted(frame)
	for i=1,frame:NumLines() do
		local mytext = getglobal(frame:GetName().."TextLeft"..i);
		local text = mytext:GetText();
		local r, g, b, a = mytext:GetTextColor();

		if (r == 0 and g > 0.99 and b == 0 and
			string.find(text, "^(%d+) "..HealPointsBSL.ARMOR.."$") == nil and
			string.find(text, "^"..HealPointsBSL.ARMOR.."..:.(%d+)$") == nil and
			string.sub(text, 0, string.len(ITEM_SPELL_TRIGGER_ONEQUIP)) ~= ITEM_SPELL_TRIGGER_ONEQUIP and
			string.sub(text, 0, string.len(ITEM_SET_BONUS)-2).."%s" ~= ITEM_SET_BONUS and
			string.sub(text, 0, string.len(ITEM_SPELL_TRIGGER_ONUSE)) ~= ITEM_SPELL_TRIGGER_ONUSE and
			string.sub(text, 0, string.len(HealPointsBSL.SOCKET_MSG)) ~= HealPointsBSL.SOCKET_MSG and
			string.sub(text, 0, string.len(ITEM_SOCKET_BONUS)-2).."%s" ~= ITEM_SOCKET_BONUS) then
			return true;
		end
	end
	return false;
end

local function AddValue(effect, value)
	local i,e;
	local b = HealPointsBS.temp.bonuses;
	local d = HealPointsBS.temp.details;
	local s = HealPointsBS.temp.slot;

	if (type(effect) == "string") then
		if (b[effect]) then
			b[effect] = b[effect] + value;
		else
			b[effect] = value;
		end

		if (s) then
			if (d[effect]) then
				if (d[effect][s]) then
					d[effect][s] = d[effect][s] + value;
				else
					d[effect][s] = value;
				end
			else
				d[effect] = {};
				d[effect][s] = value;
			end
		end
		elseif (type(value) == "table") then
			for i,e in pairs(effect) do
				AddValue(e, value[i]);
			end
		else
			for i,e in pairs(effect) do
				AddValue(e, value);
			end
	end
end

local function CheckOther(line)
	-- Last fallback for non generic enchants, like "Mana Regen x per 5 sec."
	local i, p, value1, value2;

	for i, p in pairs(HealPointsBSL.PATTERNS_OTHER) do
		value1, value2 = string.match(line, "^" .. p.pattern);
		if (value2) then -- Two effects
			if (p.value and p.value[2]) then
				AddValue(p.effect[1], p.value[1])
				AddValue(p.effect[2], p.value[2])
			else
				AddValue(p.effect[1], value1)
				AddValue(p.effect[2], value2)
			end
			return;
		elseif (value1) then -- One effect
			if (p.value) then
				AddValue(p.effect, p.value)
			else
				AddValue(p.effect, value1)
			end
			return;
		end
	end
end

local function CheckGeneric(line)
	-- Scans generic bonuses like "+3 Intellect" or "Arcane Resistance +4"

	local function trim(s)
		s = string.gsub(s, "^%s+", "" ); -- Remove spaces from the beginning of the line
		s = string.gsub(s, "%s+$", "" ); -- Remove spaces from the end of the line
		s = string.gsub(s, "%.$", "" ); -- Remove . from the end of the line
		return s;
	end

	local function split(s, delim)
		local pos = string.find(s, delim, 1, true);
		if (pos) then
			local t = string.sub(s, 1, pos-1);
			s = string.sub(line, pos+1);
			return t, s;
		else
			return nil, s;
		end
	end

	local function lookup(token, value)
		if(HealPointsBSL.PATTERNS_GENERIC_LOOKUP[token]) then
			AddValue(HealPointsBSL.PATTERNS_GENERIC_LOOKUP[token], value);
			return true;
		end
			return false;
	end

	-- find effects combined with 'and'
	local num = 1;
	local _, _, v1, t1, v2, t2 = string.find(line, PATTERN_GENERIC_TWOPRE);
	if (not t1) then
		num = 2;
		_, _, v1, t1, v2, t2 = string.find(line, PATTERN_HEALING_TWOPRE);
	end
	if (not t1) then
		num = 3;
		_, _, t1, v1, t2, v2 = string.find(line, PATTERN_GENERIC_TWOSUF);
	end
	-- if (t1 and t2) then
	-- HealPoints:Print(v1.."*"..t1.."*"..v2.."*"..t2.." Pattern:"..num);
	-- end
	local found1 = false;
	local found2 = false;
	if (t1 and v1) then
		t1 = string.lower(trim(t1));
		found1 = lookup(t1, v1);
	end
	if (t2 and v2) then
		t2 = string.lower(trim(t2));
		if (HealPointsBSL.PATTERNS_GENERIC_LOOKUP[t1] ~= "HEAL" or HealPointsBSL.PATTERNS_GENERIC_LOOKUP[t2] ~= "HEAL") then
			found2 = lookup(t2, v2);
		end
	end
	if (found1 == true or found2 == true) then
		return true;
	end

	local found = false;
	-- split enchants with multiple effects
	while(string.len(line) > 0) do
		local tmpStr;
		tmpStr, line = split(line, "/");
		if (not tmpStr) then
			tmpStr, line = split(line, "&");
		end
		if (not tmpStr) then
			tmpStr, line = split(line, ",");
		end
		if (not tmpStr) then
			tmpStr = line;
			line = "";
		end

		tmpStr = trim(tmpStr);
		local _, _, value, token = string.find(tmpStr, PATTERN_GENERIC_PREFIX);
		if (not value) then
			_, _, token, value = string.find(tmpStr, PATTERN_GENERIC_SUFFIX);
		end
		if (token and value) then
			token = string.lower(trim(token));
			found = lookup(token, value);
		end
	end
	return found;
end

local function CheckSetEquip(line)
	-- Scans passive bonuses like "Set: " and "Equip: "
	local i, p;
	for i,p in pairs(HealPointsBSL.PATTERNS_SETEQUIP) do
		local _, _, value = string.find(line, "^" .. p.pattern);
		if (value) then
			AddValue(p.effect, value)
			return true; -- prevent duplicated patterns to cause bonuses to be counted several times
		end
	end
	return false;
end

local function ScanLine(line, includeSet, includeEnchant, isGreen, insertGem)
	if (string.sub(line, 0, 2) == "|c") then -- fix for white enchants, stolen from ItemBonusLib
		line = string.sub(line, 11, -3)
	end

	-- Check for empty socket
	if (insertGem ~= false and string.sub(line,0,string.len(HealPointsBSL.BLUE_SOCKET)) == HealPointsBSL.BLUE_SOCKET) then
		local gemStats = HealPointsGems:getBlueSelected();
		if (gemStats ~= nil) then
			local key, value;
			for key, value in pairs(gemStats) do
				AddValue(key, value);
			end
		else
			HealPointsBS.temp.emptySockets = true;
		end

	elseif (insertGem ~= false and string.sub(line,0,string.len(HealPointsBSL.RED_SOCKET)) == HealPointsBSL.RED_SOCKET) then
		local gemStats = HealPointsGems:getRedSelected();
		if (gemStats ~= nil) then
			local key, value;
			for key, value in pairs(gemStats) do
				AddValue(key, value);
			end
		else
			HealPointsBS.temp.emptySockets = true;
		end

	elseif (insertGem ~= false and string.sub(line,0,string.len(HealPointsBSL.YELLOW_SOCKET)) == HealPointsBSL.YELLOW_SOCKET) then
		local gemStats = HealPointsGems:getYellowSelected();
		if (gemStats ~= nil) then
			local key, value;
			for key, value in pairs(gemStats) do
				AddValue(key, value);
			end
		else
			HealPointsBS.temp.emptySockets = true;
		end

	-- Check for "Equip: "
	elseif (string.sub(line,0,string.len(ITEM_SPELL_TRIGGER_ONEQUIP)) == ITEM_SPELL_TRIGGER_ONEQUIP) then
		local tmpStr = string.sub(line,string.len(ITEM_SPELL_TRIGGER_ONEQUIP)+2);
		local found = CheckSetEquip(tmpStr);
		if (not found) then
			CheckGeneric(tmpStr);
		end

	-- Check for "Set: "
	elseif (includeSet ~= false and string.sub(line,0,string.len(ITEM_SET_BONUS)-2).."%s" == ITEM_SET_BONUS
	and HealPointsBS.temp.set ~= "" and not HealPointsBS.temp.sets[HealPointsBS.temp.set]) then
		HealPointsBS.temp.slot = "Set";
		local tmpStr = string.sub(line,string.len(ITEM_SET_BONUS)-1);
		local found = CheckSetEquip(tmpStr);
		if (not found) then
			CheckGeneric(tmpStr);
		end

	-- Check for "Socket bonus: "
	elseif (string.sub(line,0,string.len(ITEM_SOCKET_BONUS)-2).."%s" == ITEM_SOCKET_BONUS and (isGreen or HealPointsBS.temp.emptySockets == false)) then
		local tmpStr = string.sub(line,string.len(ITEM_SOCKET_BONUS)-1);
		local found = CheckGeneric(tmpStr);
		if (not found) then
			CheckOther(tmpStr);
		end;

	-- any other line (standard stats, enchantment, set name, etc.)
	else
		-- Check for set name
		local _, _, tmpStr = string.find(line, PATTERN_SETNAME);
		if (tmpStr) then
			HealPointsBS.temp.set = tmpStr;
		elseif (includeEnchant == true or isGreen == false) then
			local found = CheckGeneric(line);
			if (not found) then
				CheckOther(line);
			end;
		end
	end
end;


local function ScanTooltip(includeSet, includeEnchant, insertGem)
	local lines = HealPointsBSTooltip:NumLines();
	for i=2, lines, 1 do
		local tmpText = getglobal(HealPointsBSTooltip:GetName().."TextLeft"..i);
		if (tmpText:GetText()) then
			local line = tmpText:GetText();
			local r, g, b = tmpText:GetTextColor();
			local isGreen = (r == 0 and g > 0.99 and b == 0);
			ScanLine(line, includeSet, includeEnchant, isGreen, insertGem);
		end
	end
end

local function ScanEquipment()
	HealPointsBS.temp.bonuses = {};
	HealPointsBS.temp.details = {};
	HealPointsBS.temp.sets = {};
	HealPointsBS.temp.set = "";
	HealPointsBS.temp.emptySockets = false;

	local slotname, i;
	for i, slotname in pairs(HealPointsBS.slots) do
		local slotid, _ = GetInventorySlotInfo(slotname.. "Slot");
		HealPointsBSTooltip:ClearLines();
		local hasItem = HealPointsBSTooltip:SetInventoryItem("player", slotid);

		if (hasItem) then
			HealPointsBS.temp.slot = slotname;
			ScanTooltip(true, true, false);
			-- if set item, mark set as already scanned
			if (HealPointsBS.temp.set ~= "") then
				HealPointsBS.temp.sets[HealPointsBS.temp.set] = 1;
			end;
		end
	end
	HealPointsBS.bonuses = HealPointsBS.temp.bonuses;
	HealPointsBS.bonuses_details = HealPointsBS.temp.details;
end

local function ScanItem(includeSet, includeEnchant, insertGem) -- Called from getItemSlotBonuses
	HealPointsBS.temp.bonuses = {};
	HealPointsBS.temp.sets = {};
	HealPointsBS.temp.set = "";
	HealPointsBS.temp.slot = "";
	HealPointsBS.temp.emptySockets = false;
	ScanTooltip(includeSet, includeEnchant, insertGem);
	return HealPointsBS.temp.bonuses;
end

-- Global functions
function HealPointsBS:update()
	-- Update function to hook into.
	-- Gets called, when Equipment changes (after UNIT_INVENTORY_CHANGED)
end

function HealPointsBS:GetBonus(bonus)
	if(HealPointsBS.bonuses[bonus]) then
		if (type(HealPointsBS.bonuses[bonus]) == "string") then
			HealPointsBS.bonuses[bonus] = tonumber(HealPointsBS.bonuses[bonus]);
		end
		return HealPointsBS.bonuses[bonus];
	end
	return 0;
end

function HealPointsBS:getItemSlotBonuses(itemLink)
	HealPointsBSTooltip:ClearLines();
	HealPointsBSTooltip:SetHyperlink(itemLink);

	if (type(itemLink) == "string" ) then
		_,_, itemLink = string.find(itemLink, "item:(%d+):");
	end

	local _, _, _, _, _, type, _, _, itemEquipLoc = GetItemInfo(itemLink);
	if (type == HealPointsBSL.GEM_TYPE) then
		local itemBonuses = ScanItem(false, true, true);
		return itemBonuses;
	end
	local slotName = slotConvert[itemEquipLoc];
	if (slotName == nil) then
		return nil;
	end

	local isEnchanted = isEnchanted(HealPointsBSTooltip);

	local itemBonuses = ScanItem(false, true, true);
	local slotBonuses;
	if (not isEnchanted) then
		local slotid, _ = GetInventorySlotInfo(slotName.. "Slot");
		HealPointsBSTooltip:ClearLines();
		local hasItem = HealPointsBSTooltip:SetInventoryItem("player", slotid);
		slotBonuses = ScanItem(false, false, true);
	else
		slotBonuses = GetSlotBonuses(slotName);
	end

	if (itemEquipLoc == "INVTYPE_2HWEAPON") then -- 2hander replaces 1hander + shield/offhand
		local slotBonuses2 = GetSlotBonuses("SecondaryHand");
		for index, value in pairs(slotBonuses2) do
			if (slotBonuses[index] == nil) then
				slotBonuses[index] = value;
			else
				slotBonuses[index] = slotBonuses[index] + value;
			end
		end
	end
	if (slotName == "SecondaryHand") then -- shield/offhand replaces 2hander
		local mainHandLink = GetInventoryItemLink("player",GetInventorySlotInfo("MainHandSlot"))
		if (mainHandLink ~= nil) then
			local _, _, itemCode = strfind(mainHandLink, "(%d+):")
			local _, _, _, _, _, _, _, _, loc = GetItemInfo(itemCode);
			if (loc == "INVTYPE_2HWEAPON") then
				slotBonuses = GetSlotBonuses("MainHand");
			end
		end
	end
	if (slotBonuses == nil) then
		return nil;
	elseif (slotName == "Finger0") then
		return itemBonuses, slotBonuses, GetSlotBonuses("Finger1");
	elseif (slotName == "Trinket0") then
		return itemBonuses, slotBonuses, GetSlotBonuses("Trinket1");
	else
		return itemBonuses, slotBonuses;
	end
end

-- Event functions
function HealPointsBS:OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("PLAYER_LEAVING_WORLD");
end

function HealPointsBS:OnEvent()
	if ((event == "UNIT_INVENTORY_CHANGED") and HealPointsBS.active) then
		HealPointsBS.CheckForBonusPlease = 1;
		return;
	end
	if (event == "PLAYER_ENTERING_WORLD") then
		HealPointsBS.active = 1;
		HealPointsBS.CheckForBonusPlease = 1;
		this:RegisterEvent("UNIT_INVENTORY_CHANGED");
		return;
	end
	if (event == "PLAYER_LEAVING_WORLD") then
		this:UnregisterEvent("UNIT_INVENTORY_CHANGED");
		return;
	end
end

function HealPointsBS:OnUpdate(elapsed)
	-- The use of the <OnUpdate></OnUpdate> *feature* avoid freezes and lags caused by the useless repeated call of BonusScanner:ScanEquipment()...

	if (HealPointsBS.IsUpdating) then
		return;
	end

	HealPointsBS.IsUpdating = true;

	-- if the equipment has changed then check if we are allowed to test for bonuses
	if (HealPointsBS.CheckForBonusPlease == 1) then
		HealPointsBS.CheckIntervalCounter = HealPointsBS.CheckIntervalCounter + elapsed;

		-- if we have wait long enough then proceed...
		if (HealPointsBS.CheckIntervalCounter > HealPointsBS.MinCheckInterval) then
			HealPointsBS.CheckForBonusPlease = 2; -- means we are currently checking
			ScanEquipment(); -- scan the equiped items
			HealPointsBS:update(); -- call the update function (for the mods using this library)
			if (HealPointsBS.CheckForBonusPlease ~= 1) then -- if no other update has been requested
				HealPointsBS.CheckForBonusPlease = 0;
			end
			HealPointsBS.CheckIntervalCounter = 0;
		end
	end

	HealPointsBS.IsUpdating = false;
end