
HealPoints:SetFuBarOption("hasIcon", true);
HealPoints:SetFuBarOption("iconPath", "Interface\\Icons\\Spell_Holy_FlashHeal");
HealPoints:SetFuBarOption("cannotDetachTooltip", true);

local int ={ stat = "Intellect", statmod = 1 };
local spi ={ stat = "Spirit", statmod = 1 };
local mp5 ={ stat = "Mana/5s", statmod = 2.5 };
local heal ={ stat = "+Healing", statmod = 0.455 };
local crit ={ stat = "Spell Crit rating", statmod = 1 };
local haste ={ stat = "Spell Haste rating", statmod = 1 };

local stats = { };
stats[1] = int;
stats[2] = spi;
stats[3] = mp5;
stats[4] = heal;
stats[5] = crit;
stats[6] = haste;

function HealPoints:PrintMVS()
	local function statTableSort(e1, e2)
		if (e1.value > e2.value) then
			return true;
		else
			return false;
		end
	end

	if HealPoints.ISHEALER then
		local iv, sv, mv, hv, cv, h2v = HealPointsCalculator:computeHealPointsDelta();
		int.value = HealPointsUtil:round(iv / int.statmod);
		spi.value = HealPointsUtil:round(sv / spi.statmod);
		mp5.value = HealPointsUtil:round(mv / mp5.statmod);
		heal.value = HealPointsUtil:round(hv / heal.statmod);
		crit.value = HealPointsUtil:round(cv / crit.statmod);
		haste.value = HealPointsUtil:round(h2v / haste.statmod);
		table.sort(stats, statTableSort);
	end
	
	self:Print("Most valuable stat ranking:");
	self:Print("--------------------------------------");
	for i = 1, table.getn(stats) do
		self:Print(stats[i].stat.."     "..stats[i].value.." points/cost");
	end
end

function HealPoints:OnFuBarClick()
	if (HealPoints.ISHEALER and HealPoints:IsActive()) then
		if (HealPoints_CalcFrame:IsShown()) then
			HealPoints_CalcFrame:Hide();
		else
			HealPoints_CalcFrame:Show();
		end
	end
end

local debugpage = {
	debug ={
		type = "toggle",
		name = "Debug mode",
		desc = "Toggles the display of debug messages.",
		get = function()
			return HealPoints.db.char.debug == 1;
		end,
		set = function()
			HealPoints:clearLinkCache();
			HealPoints.db.char.debug = 1 - HealPoints.db.char.debug;
		end
	},	
	bscan ={
		type = "execute",
		name = "Print special bonuses",
		desc = "Print special set/equip bonuses detected to the console.",
		buttonText = "Print",
		func = function()
			HealPoints:listScannedBonuses();
		end
	},
};

local gempage = {
	bluegems ={
		type = "group",
		name = "Blue Sockets",
		desc = "Select crafted, rare gem to be used for empty blue socket calculations.",
		args = HealPointsGems.blueSocket,
	},
	redgems ={
		type = "group",
		name = "Red Sockets",
		desc = "Select crafted, rare gem to be used for empty red socket calculations.",
		args = HealPointsGems.redSocket,
	},
	yellowgems ={
		type = "group",
		name = "Yellow Sockets",
		desc = "Select crafted, rare gem to be used for empty yellow socket calculations.",
		args = HealPointsGems.yellowSocket,
	},
};

HealPoints:SetConfigTable({
	name = "HealPoints",
	desc = "HealPoints Configuration.",
	icon = "Interface\\Icons\\Spell_Holy_FlashHeal",
	type = "group",
	args ={
		tooltips ={
			type = "toggle",
			name = "HealPoints in tooltips",
			desc = "Toggles the display of HealPoints change in item tooltips.",
			order = 10,
			get = function()
				return HealPoints.db.char.tooltips == 1;
			end,
			set = function()
				HealPoints.db.char.tooltips = 1 - HealPoints.db.char.tooltips;
			end
		},
		computemvs ={
			type = "execute",
			name = "Print most valuable stats",
			desc = "Lists the most valuable stat ranking according to current gear and buffs.",
			buttonText = "Print",
			order = 11,
			func = "PrintMVS",
		},

		socketmenu = {
			type = "group",
			name = "Socket config",
			desc = "Select gems to be socketed for item comparisons.",
			order = 20,
			args = gempage,
		},
		debugmenu = {
			type = "group",
			name = "Debug",
			desc = "Debug options.",
			order = 40,
			args = debugpage,
		},
	}
});
