HealPoints = Rock:NewAddon("HealPoints", "LibRockDB-1.0", "LibRockHook-1.0", "LibRockEvent-1.0", "LibRockConsole-1.0", "LibFuBarPlugin-3.0", "LibRockConfig-1.0")

HealPoints.ISHEALER = nil;
local lastLink = nil;
local diff1 = nil;
local diff2 = nil;
local diff3 = nil;
local diff4 = nil;

HealPoints:SetDatabase("HEALPOINTS_CONFIG", "HEALPOINTS_CONFIG");
HealPoints:SetDatabaseDefaults('char',{
	power ={
		spell = "",
		auto = true,
		duration = 1,
		rank = 1,
		mana = 100,
	},
	endurance ={
		spell = "",
		auto = true,
		duration = 5,
		rank = 1,
		mana = 0,
	},
	hot ={
		numtargets = 3,
	},
	tooltips = 1,
	debug = 0,
	gems ={
		blueGem = 1,
		redGem = 1,
		yellowGem = 1,
	}
});

function HealPoints:OnInitialize()
	local _, className = UnitClass("player");
	if (className == "PALADIN" or className == "PRIEST" or className == "DRUID" or className == "SHAMAN") then
		HealPoints.ISHEALER = 1;
		HealPointsSpells:init();
		HealPointsCalculatorUI:init();
		HealPointsConfigUI:init();
	else
		return;
	end

	self:AddSecureHook(GameTooltip, "SetBagItem", function(this, bag, slot)
		self:DrawTooltip(GameTooltip, GetContainerItemLink(bag, slot));
		end
	);

	self:AddSecureHook(GameTooltip, "SetLootItem", function(this, slot)
		self:DrawTooltip(GameTooltip, GetLootSlotLink(slot));
		end
	);

	self:AddSecureHook(GameTooltip, "SetQuestItem", function(this, unit, slot)
		self:DrawTooltip(GameTooltip, GetQuestItemLink(unit, slot));
		end
	);

	self:AddSecureHook(GameTooltip, "SetQuestLogItem", function(this, sOpt, slot)
		self:DrawTooltip(GameTooltip, GetQuestLogItemLink(sOpt, slot));
		end
	);

	self:AddSecureHook(GameTooltip, "SetTradeSkillItem", function(this, skill, slot)
		local link = (slot) and GetTradeSkillReagentItemLink(skill, slot) or GetTradeSkillItemLink(skill);
		self:DrawTooltip(GameTooltip, link);
		end
	);

	self:AddSecureHook(GameTooltip, "SetMerchantItem", function(this, slot)
		self:DrawTooltip(GameTooltip, GetMerchantItemLink(slot));
		end
	);

	self:AddSecureHook(GameTooltip, "SetAuctionItem", function(this, unit, slot)
		self:DrawTooltip(GameTooltip, GetAuctionItemLink(unit, slot));
		end
	);

	self:AddSecureHook(GameTooltip, "SetLootRollItem", function(this, id)
		self:DrawTooltip(GameTooltip, GetLootRollItemLink(id));
		end
	);

	self:AddSecureHook(GameTooltip, "SetHyperlink", function(this, link)
		self:DrawTooltip(GameTooltip, link)
		end
	);

	self:AddHook(GameTooltip, "SetInventoryItem", function(this, unit, slot)
		local sItem, sCooldown, sRepair = self.hooks[GameTooltip]["SetInventoryItem"](this, unit, slot);
		if(not sItem) then return nil; end
		if (slot > 39) then -- bank
			self:DrawTooltip(GameTooltip, GetInventoryItemLink(unit, slot));
		end
		return sItem, sCooldown, sRepair;
	end
	, true);

	self:AddSecureHook("SetItemRef", function(link, name, button)
		if(link and name and ItemRefTooltip) then
			if( strsub(link, 1, 6) ~= "Player" ) then
				if( ItemRefTooltip:IsVisible()) then
					if(not DressUpFrame:IsVisible()) then
						self:DrawTooltip(ItemRefTooltip, link);
					end
					ItemRefTooltip.isDisplayDone = nil;
					end
				end
			end
		end
	);

	self:AddSecureHook(HealPointsBS, "update", HealPoints.GearChanged);

	-- Remove old settings
	HEALPOINTS_CONFIG['endurance'] = nil;
	HEALPOINTS_CONFIG['power'] = nil;
	HEALPOINTS_CONFIG['tooltips'] = nil;
	HEALPOINTS_CONFIG['regen'] = nil;
	HEALPOINTS_CONFIG['hot'] = nil;
end

function HealPoints:OnEnable(first)
	if (HealPoints.ISHEALER == 1) then
		self:AddEventListener("UNIT_AURA", "StatsChanged");
		self:AddEventListener("UNIT_LEVEL", "StatsChanged");
		self:AddEventListener("UNIT_MAXMANA", "StatsChanged");
		self:AddEventListener("UNIT_STATS", "StatsChanged");
		self:AddEventListener("LEARNED_SPELL_IN_TAB", "SpellsChanged");
		self:AddEventListener("CHARACTER_POINTS_CHANGED", "TalentsChanged");
		if (not self:HasHook(HealPointsBS, "update")) then
			self:AddSecureHook(HealPointsBS, "update", HealPoints.GearChanged);
		end
		HealPointsConfigUI:spellsChanged();
		HealPoints_CharFrame:Show();
		if (not first) then
			HealPointsUtil:talentsChanged();
			HealPointsCalculator:updateHealPoints();
		end
	else
		DisableAddOn("HealPoints");
	end
end

function HealPoints:OnDisable()
	HealPoints_CharFrame:Hide();
	HealPoints_CalcFrame:Hide();
	HealPoints_ConfigFrame:Hide();
end

function HealPoints:StatsChanged(target) -- UNIT_AURA, UNIT_LEVEL, UNIT_MAXMANA, UNIT_STATS
	lastLink = nil;
	if (UnitIsUnit(target, "player")) then
		if (HealPoints_CalcFrame:IsVisible()) then
			HealPointsCalculator:updateStats();
			HealPointsCalculatorUI:updateSelectedSpellStats();
		end
		if (HealPoints_CalcFrame:IsVisible() or CharacterFrame:IsVisible()) then
			HealPointsCalculator:updateHealPoints();
		end
	end
end

function HealPoints:SpellsChanged(spelltabnr) -- LEARNED_SPELL_IN_TAB
	lastLink = nil;
	HealPointsSpells:spellsChanged();
	HealPointsCalculatorUI:updateSpellLists();
	if (HealPoints_CalcFrame:IsVisible()) then
		HealPointsCalculator:updateStats();
		HealPointsCalculatorUI:updateSelectedSpellStats();
	end
	HealPointsCalculator:updateHealPoints();
	HealPointsConfigUI:spellsChanged();
end

function HealPoints:TalentsChanged(delta) -- CHARACTER_POINTS_CHANGED
	lastLink = nil;
	HealPointsUtil:talentsChanged();
	HealPointsCalculator:talentsChanged();
	HealPointsCalculatorUI:updateSpellLists();
	if (HealPoints_CalcFrame:IsVisible()) then
		HealPointsCalculator:updateStats();
		HealPointsCalculatorUI:updateSelectedSpellStats();
	end
	HealPointsCalculator:updateHealPoints();
end

function HealPoints:GearChanged()
	lastLink = nil;
	if (HealPoints_CalcFrame:IsVisible()) then
		HealPointsCalculator:updateStats();
		HealPointsCalculatorUI:updateSelectedSpellStats();
	end
	if (HealPoints_CalcFrame:IsVisible() or CharacterFrame:IsVisible()) then
		HealPointsCalculator:updateHealPoints();
	end
end

function HealPoints:DrawTooltip(frame, reference)
	local function addLine(text, d1, d2)
		if (d1 == d2) then
			frame:AddDoubleLine(text, HealPointsUtil:colorValue(d1),
			NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b,
			NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
		else
			frame:AddDoubleLine(text, HealPointsUtil:colorValue(d1).." / "..HealPointsUtil:colorValue(d2),
			NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b,
			NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
		end
	end

	if (HealPoints:IsActive() and HealPoints.db.char.tooltips ~= 0 and reference ~= nil and string.find(reference, "item", 0, true) ~= nil) then
		if (reference ~= lastLink) then
			diff1, diff2, diff3, diff4 = HealPointsCalculator:computeHealpointsDiff(reference)
			lastLink = reference;
		end
		if (diff3 ~= nil and diff3 ~= 0 and diff4 ~= nil and diff4 ~= 0) then
			addLine("HealPoints difference, top slot:", diff1, diff2);
			addLine("HealPoints difference, bottom slot:", diff3, diff4);
			frame:Show();
		elseif (diff1 ~= 0 or diff2 ~= 0) then
			addLine("HealPoints difference:", diff1, diff2);
			frame:Show();
		end
	end
end

function HealPoints:clearLinkCache()
	lastLink = nil;
end

function HealPoints:listScannedBonuses()
	local _, className = UnitClass("player");
	self:Print("Special set/equip bonuses detected:");
	self:Print("===================================");
	if (className == "PALADIN") then
		self:Print("Reduces the casting time of your Holy Light spell by 0."..HealPointsBS:GetBonus('TIME_HL').." sec.");
		self:Print("Increases healing done by Flash of Light by up to "..HealPointsBS:GetBonus('AVG_ABS_FOL'));
		self:Print("Increases the healing from your Flash of Light ability by "..HealPointsBS:GetBonus('AVG_PC_FOL').."%");
		self:Print("Increases the benefit your Flash of Light and Holy Light spells receive from Blessing of Light by "..HealPointsBS:GetBonus('AVG_ABS_BOL').."/"..2*HealPointsBS:GetBonus('AVG_ABS_BOL'));
		self:Print("Increases healing done by Holy Light by up to "..HealPointsBS:GetBonus('AVG_ABS_HL'));
		self:Print("Reduces the mana cost of Holy Light by "..HealPointsBS:GetBonus('MANA_ABS_HL'));
	elseif (className == "PRIEST") then
		self:Print("-0."..HealPointsBS:GetBonus('TIME_FH').." sec to the casting time of your Flash Heal spell.");
		self:Print("Increases your chance of a critical hit with Prayer of Healing by "..HealPointsBS:GetBonus('CRIT_POH').."%");
		self:Print("Your Greater Heals now have a heal over time component equivalent to a rank "..HealPointsBS:GetBonus('GH_RENEW').." Renew.");
		self:Print("Reduces the mana cost of your Renew spell by "..HealPointsBS:GetBonus('MANA_PC_RENEW').."%");
		self:Print("Increases the duration of your Renew spell by "..HealPointsBS:GetBonus('DURATION_RENEW').." sec.");
		self:Print("Reduces the mana cost of your Prayer of Healing ability by "..HealPointsBS:GetBonus('MANA_PC_POH').."%");
		self:Print("Increases the healing from your Greater Heal ability by "..HealPointsBS:GetBonus('AVG_PC_GH').."%");
	elseif (className == "DRUID") then
		self:Print("Reduces the casting time of your Regrowth spell by 0."..HealPointsBS:GetBonus('TIME_REGR').." sec.");
		self:Print("Increases the duration of your Rejuvenation spell by "..HealPointsBS:GetBonus('DURATION_REJUV').." sec.");
		self:Print("Reduces the mana cost of your Healing Touch, Regrowth, Rejuvenation, and Tranquility spells by "..HealPointsBS:GetBonus('MANA_PC_DRUID').."%");
		self:Print("On Healing Touch critical hits, you regain "..HealPointsBS:GetBonus('MANA_REFUND_CRIT_HT').."% of the mana cost of the spell.");
		self:Print("Increases the duration of your Regrowth spell by "..HealPointsBS:GetBonus('DURATION_REGR').." sec.");
		self:Print("Increases the final amount healed by your Lifebloom spell by "..HealPointsBS:GetBonus('AVG_BURST_LIFEBL'));
		self:Print("Increases the healing from your Healing Touch ability by "..HealPointsBS:GetBonus('AVG_PC_HT').."%");
		self:Print("Increases the amount healed by Healing Touch by "..HealPointsBS:GetBonus('AVG_ABS_HT'));
		self:Print("Gain up to "..HealPointsBS:GetBonus('MANA_REFUND_HT').." mana each time you cast Healing Touch ");
		self:Print("Increases healing done by Rejuvenation by up to "..HealPointsBS:GetBonus('AVG_ABS_REJUV'));
		self:Print("Increases the periodic healing of your Lifebloom by up to "..HealPointsBS:GetBonus('AVG_HOT_LIFEBL'));
		self:Print("Reduces the mana cost of Regrowth by "..HealPointsBS:GetBonus('MANA_ABS_REGR'));
		self:Print("Reduces the mana cost of Rejuvenation by "..HealPointsBS:GetBonus('MANA_ABS_REJUV'));
	elseif (className == "SHAMAN") then
		self:Print("After casting your Healing Wave or Lesser Healing Wave spell, gives you a 25% chance to gain Mana equal to "..HealPointsBS:GetBonus('MANA_REFUND_HWLHW').. "% of the base cost of the spell.");
		self:Print("Your Healing Wave will now jump to additional nearby targets. Each jump reduces the effectiveness of the heal by "..HealPointsBS:GetBonus('JUMP_HW').."%, and the spell will jump to up to two additional targets. (0% = no jumping)");
		self:Print("Increases the amount healed by Chain Heal to targets beyond the first by "..HealPointsBS:GetBonus('AVG_PC_JUMPS_CHAIN').."%");
		self:Print("-0."..HealPointsBS:GetBonus('TIME_CHAIN').." seconds on the casting time of your Chain Heal spell.");
		self:Print("Reduces the cost of your Lesser Healing Wave spell by "..HealPointsBS:GetBonus('MANA_PC_LHW').."%");
		self:Print("Your Chain Heal ability costs "..HealPointsBS:GetBonus('MANA_PC_CHAIN').."% less mana.");
		self:Print("Increases the amount healed by your Chain Heal ability by "..HealPointsBS:GetBonus('AVG_PC_CHAIN').."%");
		self:Print("Increases the base amount healed by Chain Heal by "..HealPointsBS:GetBonus('AVG_ABS_CHAIN'));
		self:Print("Increases healing done by Lesser Healing Wave by up to "..HealPointsBS:GetBonus('AVG_ABS_LHW'));
		self:Print("Reduces the mana cost of Heaing Wave by "..HealPointsBS:GetBonus('MANA_ABS_HW'));
		self:Print("Increases healing done by Healing Wave by up to "..HealPointsBS:GetBonus('AVG_ABS_HW'));
		self:Print("Reduces the mana cost of Chain Heal by "..HealPointsBS:GetBonus('MANA_ABS_CHAIN'));
	end
end
