-- HealAssign
-- by Greltok of Aerie Peak
-- Copyright (c) 2006-2007 Simon Ward

HA_version = {}

HA_version.__index = HA_version

function HA_version.toString( a )
    local result
    if a.bugRev and a.bugRev ~= 0 then
        result = string.format( "%d.%d.%d", ( a.majorRev or 0 ), ( a.minorRev or 0 ), a.bugRev )
    else
        result = string.format( "%d.%d", ( a.majorRev or 0 ), ( a.minorRev or 0 ) )
    end
    return result
end

function HA_version.compare( a, b )
    local result
    if ( a.majorRev or 0 ) > ( b.majorRev or 0 ) then
        result = 1
    elseif ( b.majorRev or 0 ) > ( a.majorRev or 0 ) then
        result = -1
    elseif ( a.minorRev or 0 ) > ( b.minorRev or 0 ) then
        result = 1
    elseif ( b.minorRev or 0 ) > ( a.minorRev or 0 ) then
        result = -1
    elseif ( a.bugRev or 0 ) > ( b.bugRev or 0 ) then
        result = 1
    elseif ( b.bugRev or 0 ) > ( a.bugRev or 0 ) then
        result = -1
    else
        result = 0
    end
    return result
end

HA_version.__eq = function( a, b ) return HA_version.compare( a, b ) == 0 end
HA_version.__lt = function( a, b ) return HA_version.compare( a, b ) < 0 end
HA_version.__le = function( a, b ) return HA_version.compare( a, b ) <= 0 end
HA_version.__tostring = HA_version.toString

function HA_version:new( majorRev, minorRev, bugRev )
    local result = { majorRev = majorRev, minorRev = minorRev, bugRev = bugRev }
    setmetatable( result, self )
    return result
end

function HA_version:newFromString( stringValue )
    local _, _, majorString, minorString, bugString = string.find( stringValue, "^([%d]*)%.?([%d]*)%.?([%d]*)$" )
    return self:new( tonumber( majorString ), tonumber( minorString ), tonumber( bugString ) )
end
