-- HealAssign
-- by Greltok of Aerie Peak
-- Copyright (c) 2006-2007 Simon Ward

HA_timer = { accumulated = 0 }
HA_timer.__index = HA_timer

HA_timermanager = { timers = {} }

function HA_timermanager.update( elapsed )
    for k in pairs( HA_timermanager.timers ) do
        k:update( elapsed )
    end
end

function HA_timermanager.clear()
    for k in pairs( HA_timermanager.timers ) do
        HA_timermanager.timers[k] = nil
    end
end

function HA_timermanager.addtimer( timer )
    HA_timermanager.timers[timer] = true
end

function HA_timermanager.removetimer( timer )
    HA_timermanager.timers[timer] = nil
end

function HA_timermanager.containstimer( timer )
    if HA_timermanager.timers[timer] then
        return true
    end
    return false
end

function HA_timer:new( delay, callback, data, repeats )
    if delay <= 0 then
        error( "delay is invalid", 2 )
    end
    if not callback then
        error( "callback is invalid", 2 )
    end
    local result = { delay = delay, callback = callback }
    if data ~= nil then
        result.data = data
    end
    if repeats ~= nil then
        result.repeats = repeats
    end
    setmetatable( result, self )
    return result
end

function HA_timer:run()
    HA_timermanager.addtimer( self )
end

function HA_timer:stop()
    HA_timermanager.removetimer( self )
    self:reset()
end

function HA_timer:reset()
    self.accumulated = nil
end

function HA_timer:active()
    return HA_timermanager.containstimer( self )
end

function HA_timer:update( elapsed )
    local newTime = self.accumulated + elapsed
    if newTime >= self.delay then
        self.callback( self.data )
        self.accumulated = nil
        if not self.repeats then
            self:stop()
        end
    else
        self.accumulated = newTime
    end
end
