-- HealAssign
-- by Greltok of Aerie Peak
-- Copyright (c) 2006-2008 Simon Ward

if( GetLocale() == "enUS" ) then

BINDING_HEADER_HEALASSIGN                       = "HealAssign";
BINDING_NAME_HEALASSIGN_SHOW_OPTIONS            = "Show options window";

HEALASSIGN_MESSAGE_PREFIX                       = "<HA> ";

HEALASSIGN_TITLE                                = "HealAssign v%s"
HEALASSIGN_LOADED                               = "HealAssign v%s loaded."

HEALASSIGN_VERSION_CHECK                        = "HealAssign v%s installed."

HEALASSIGN_WINDOW_TITLE                         = "HealAssign"

HEALASSIGN_TOOLTIP                              = "Left click: toggle options menu\nDrag: move icon"

HEALASSIGN_ASSIGNMENTS_TAB_TITLE                = "Assignments";
HEALASSIGN_OPTIONS_TAB_TITLE                    = "Options";

HEALASSIGN_OPTIONS_OPACITY_TITLE                = "Opacity";
HEALASSIGN_OPTIONS_OPACITY_LOW                  = "Low";
HEALASSIGN_OPTIONS_OPACITY_HIGH                 = "High";

HEALASSIGN_OPTIONS_SCALE_TITLE                  = "Scale";
HEALASSIGN_OPTIONS_SCALE_SMALL                  = "Small";
HEALASSIGN_OPTIONS_SCALE_LARGE                  = "Large";

HEALASSIGN_OPTIONS_RESET_WINDOW                 = "Reset Window";

HEALASSIGN_CHECKBOX_MAP_BUTTON                  = "Show Minimap Button";
HEALASSIGN_CHECKBOX_SQUARE_MAP                  = "Square Minimap";
HEALASSIGN_CHECKBOX_MEMBER_ADDED                = "Notify When Raid Member Added / Removed";
HEALASSIGN_CHECKBOX_MEMBER_OFFLINE              = "Notify When Raid Member Offline / Online";
HEALASSIGN_CHECKBOX_ASSIGNMENTS_CHANGED         = "Notify When Assignments Change";
HEALASSIGN_CHECKBOX_MY_ASSIGNMENTS_CHANGED      = "Play Sound When My Assignments Change";
HEALASSIGN_CHECKBOX_IGNORE_OWN_HEALS            = "Ignore My Incoming Heals";
HEALASSIGN_CHECKBOX_SHOW_ASSIGNMENTS            = "Show Assignments Window";
HEALASSIGN_CHECKBOX_LOCK_ASSIGNMENTS            = "Lock Assignments Window (Shift to Drag)";

HEALASSIGN_MESSAGE_JOINED_RAID                  = "You have joined a raid.";
HEALASSIGN_MESSAGE_LEFT_RAID                    = "You have left a raid.";

HEALASSIGN_MESSAGE_NO_TARGETS                   = "You are not assigned to heal anyone.";
HEALASSIGN_MESSAGE_NO_HEALERS                   = "You have no healers assigned to you.";
HEALASSIGN_MESSAGE_NOT_A_HEALER                 = "You are not a healer.";

HEALASSIGN_MESSAGE_CHANNEL_SET                  = "Channel set to \"%s\".";
HEALASSIGN_MESSAGE_NO_CHANNEL                   = "No channel has been set.";

HEALASSIGN_MESSAGE_UNASSIGNED_HEALERS_PREFIX    = "Unassigned healers: ";
HEALASSIGN_MESSAGE_NO_UNASSIGNED_HEALERS        = "There are no unassigned healers.";

HEALASSIGN_MESSAGE_RAID_RANK_CHANGED            = "Your raid rank has changed to %s.";
HEALASSIGN_RAID_RANK_NORMAL                     = "Normal";
HEALASSIGN_RAID_RANK_ASSISTANT                  = "Assistant";
HEALASSIGN_RAID_RANK_LEADER                     = "Leader";
HEALASSIGN_MESSAGE_NOT_PROMOTED                 = "Your raid rank must be Assistant or Leader to do that.";
HEALASSIGN_MESSAGE_NOT_SERVER                   = "You must be the server to do that.";
HEALASSIGN_MESSAGE_NOT_GUILD_OFFICER            = "You must be a guild officer to do that.";

HEALASSIGN_MESSAGE_UNKNOWN_COMMAND              = "Unknown command \"%s\".";
HEALASSIGN_MESSAGE_INVALID_ARGUMENT             = "Invalid argument \"%s\".";
HEALASSIGN_MESSAGE_INVALID_ARGUMENT_COUNT       = "Invalid argument count.";

HEALASSIGN_MESSAGE_UNKNOWN_MESSAGE_TYPE         = "Error! Unknown message type from %s.";

HEALASSIGN_MESSAGE_NOT_IN_RAID                  = "You are not in a raid!";

HEALASSIGN_MESSAGE_WHISPERING_ASSIGNMENTS       = "Whispering healing assignments.";

HEALASSIGN_WHISPER_COMMAND_TARGETS              = "mytargets";
HEALASSIGN_WHISPER_COMMAND_HEALERS              = "myhealers";

HEALASSIGN_SLASH_COMMAND_HELP                   = "help";
HEALASSIGN_SLASH_COMMAND_OPTIONS                = "options";
HEALASSIGN_SLASH_COMMAND_ASSIGN                 = "assign";
HEALASSIGN_SLASH_COMMAND_ASSIGN_TARGET          = "assigntarget";
HEALASSIGN_SLASH_COMMAND_UNASSIGN               = "unassign";
HEALASSIGN_SLASH_COMMAND_CLEAR                  = "clear";

HEALASSIGN_SLASH_COMMAND_LIST                   = "list";
HEALASSIGN_SLASH_COMMAND_LISTTARGETS            = "listtargets";
HEALASSIGN_SLASH_COMMAND_SUB_LIST_RAID              = "raid";
HEALASSIGN_SLASH_COMMAND_SUB_LIST_CHANNEL           = "channel";
HEALASSIGN_SLASH_COMMAND_SUB_LIST_WHISPER           = "whisper";
HEALASSIGN_SLASH_COMMAND_SUB_LIST_OFFICER           = "officer";

HEALASSIGN_SLASH_COMMAND_SETCHANNEL             = "setchannel";
HEALASSIGN_SLASH_COMMAND_UNASSIGNED             = "unassigned";
HEALASSIGN_SLASH_COMMAND_VERSIONCHECK           = "versioncheck";
HEALASSIGN_SLASH_COMMAND_VERSIONLIST            = "versionlist";
HEALASSIGN_SLASH_COMMAND_SYNC                   = "sync";
HEALASSIGN_SLASH_COMMAND_SERVER                 = "server";

HEALASSIGN_SLASH_COMMAND_SET                    = "set";
HEALASSIGN_SLASH_COMMAND_SUB_SET_SAVE               = "save";
HEALASSIGN_SLASH_COMMAND_SUB_SET_LOAD               = "load";
HEALASSIGN_SLASH_COMMAND_SUB_SET_ERASE              = "erase";
HEALASSIGN_SLASH_COMMAND_SUB_SET_LIST               = "list";

HEALASSIGN_MESSAGE_HEALER_MULTIPLE_FOUND        = "Multiple healer matches found for \"%s\":";
HEALASSIGN_MESSAGE_HEALER_NOT_FOUND             = "No healer match found for \"%s\".";

HEALASSIGN_MESSAGE_TARGET_SEPARATOR             = " <- ";
HEALASSIGN_MESSAGE_HEALER_SEPARATOR             = " -> ";
HEALASSIGN_MESSAGE_LIST_SEPARATOR               = ", ";
HEALASSIGN_MESSAGE_LIST_TERMINATOR              = ".";

HEALASSIGN_MESSAGE_MEMBER_MULTIPLE_FOUND        = "Multiple matches found for \"%s\":";
HEALASSIGN_MESSAGE_MEMBER_NOT_FOUND             = "No match found for \"%s\".";

HEALASSIGN_MESSAGE_HEALER_ASSIGNED              = "%s: %s is now assigned to heal %s.";
HEALASSIGN_MESSAGE_HEALER_ALREADY_ASSIGNED      = "%s is already assigned to heal %s.";

HEALASSIGN_MESSAGE_HEALER_UNASSIGNED            = "%s: %s is no longer assigned to heal %s.";
HEALASSIGN_MESSAGE_HEALER_NOT_ASSIGNED_TARGET   = "%s is not assigned to heal %s.";
HEALASSIGN_MESSAGE_HEALER_UNASSIGNED_ALL        = "%s: %s is no longer assigned to heal anyone.";
HEALASSIGN_MESSAGE_HEALER_NOT_ASSIGNED          = "%s is not assigned to heal anyone.";

HEALASSIGN_MESSAGE_ASSIGNMENTS_CLEARED          = "%s: Healing assignments cleared.";

HEALASSIGN_MESSAGE_VERSION_FORMATTER_SERVER     = "*%s v%s";
HEALASSIGN_MESSAGE_VERSION_FORMATTER_USER       = "%s v%s";
HEALASSIGN_MESSAGE_VERSION_NONE                 = "not installed";
HEALASSIGN_MESSAGE_VERSION_OFFLINE              = "offline";

HEALASSIGN_MESSAGE_SERVER_SET                   = "%s is now the server.";
HEALASSIGN_MESSAGE_SERVER_LOST                  = "%s is no longer the server.";
HEALASSIGN_MESSAGE_NO_SERVER                    = "There is no server. Use \"/ha server\" to become the server.";

HEALASSIGN_MESSAGE_SENDING_SYNC                 = "Sending full sync.";
HEALASSIGN_MESSAGE_REQUESTING_SYNC              = "Requesting full sync.";

HEALASSIGN_MESSAGE_ASSIGNMENTS_SYNCED           = "%s: Healing assignments synced.";

HEALASSIGN_MESSAGE_SYNC_FAILED                  = "Sync failed: %s.";
HEALASSIGN_MESSAGE_SYNC_UNKNOWN                 = "unknown";
HEALASSIGN_MESSAGE_SYNC_TIMEOUT                 = "timeout";
HEALASSIGN_MESSAGE_SYNC_OUT_OF_ORDER            = "out of order";
HEALASSIGN_MESSAGE_SYNC_UNEXPECTED_SENDER       = "unexpected sender";
HEALASSIGN_MESSAGE_SYNC_PARTIAL                 = "partial";

HEALASSIGN_MESSAGE_NO_ASSIGNMENTS               = "There are no healing assignments.";

HEALASSIGN_MESSAGE_NO_VERSIONS                  = "No members of the raid have HealAssign installed.";
HEALASSIGN_MESSAGE_VERSIONS_IDENTICAL           = "All versions of HealAssign are identical.";
HEALASSIGN_MESSAGE_VERSION_UPDATED              = "Updated version of HealAssign available (v%s).";

HEALASSIGN_SLASH_COMMAND1                       = "/healassign";
HEALASSIGN_SLASH_COMMAND2                       = "/ha";

HEALASSIGN_BASIC_HELP                           = "Use \"/ha help\" or \"/healassign help\" for command list.";

HEALASSIGN_MESSAGE_MEMBER_JOINED_RAID           = "%s (%s) has joined the raid.";
HEALASSIGN_MESSAGE_MEMBER_LEFT_RAID             = "%s (%s) has left the raid.";

HEALASSIGN_MESSAGE_MEMBER_ONLINE                = "%s (%s) has come online.";
HEALASSIGN_MESSAGE_MEMBER_OFFLINE               = "%s (%s) has gone offline.";

HEALASSIGN_MESSAGE_SET_OVERWROTE                = "Set \"%s\" overwritten.";
HEALASSIGN_MESSAGE_SET_SAVED                    = "Set \"%s\" saved.";
HEALASSIGN_MESSAGE_SET_ERASED                   = "Set \"%s\" erased.";
HEALASSIGN_MESSAGE_SET_NOT_FOUND                = "Set \"%s\" not found.";
HEALASSIGN_MESSAGE_SET_LOADED                   = "Set \"%s\" loaded.";
HEALASSIGN_MESSAGE_SET_NONE                     = "No saved sets.";
HEALASSIGN_MESSAGE_SET_MULTIPLE_FOUND           = "Multiple set matches found for \"%s\":";

HEALASSIGN_BUFF_FEIGN_DEATH                     = "Feign Death";
HEALASSIGN_BUFF_SPIRIT_OF_REDEMPTION            = "Spirit of Redemption";

HEALASSIGN_STATUS_AGGRO                         = "Aggro";
HEALASSIGN_STATUS_DEAD                          = "Dead";
HEALASSIGN_STATUS_GHOST                         = "Ghost";
HEALASSIGN_STATUS_OFFLINE                       = "Offline";
HEALASSIGN_STATUS_FEIGN_DEATH                   = "Feign";
HEALASSIGN_STATUS_SPIRIT_OF_REDEMPTION          = "Spirit";

HEALASSIGN_SET_FORMATTER                        = "Set: \"%s\" Date: %s";
HEALASSIGN_SET_MULTIPLE_FORMATTER               = "\"%s\"";
HEALASSIGN_SET_DATE_FORMATTER                   = "%c";

HEALASSIGN_NOT_YET_IMPLEMENTED                  = "This Area Not Yet Implemented";

HEALASSIGN_KEYWORD_WARRIOR                      = "[Warriors]";
HEALASSIGN_KEYWORD_ROGUE                        = "[Rogues]";
HEALASSIGN_KEYWORD_HUNTER                       = "[Hunters]";
HEALASSIGN_KEYWORD_MAGE                         = "[Mages]";
HEALASSIGN_KEYWORD_WARLOCK                      = "[Warlocks]";
HEALASSIGN_KEYWORD_DRUID                        = "[Druids]";
HEALASSIGN_KEYWORD_PRIEST                       = "[Priests]";
HEALASSIGN_KEYWORD_SHAMAN                       = "[Shaman]";
HEALASSIGN_KEYWORD_PALADIN                      = "[Paladins]";

HEALASSIGN_KEYWORD_GROUP1                       = "[Group1]";
HEALASSIGN_KEYWORD_GROUP2                       = "[Group2]";
HEALASSIGN_KEYWORD_GROUP3                       = "[Group3]";
HEALASSIGN_KEYWORD_GROUP4                       = "[Group4]";
HEALASSIGN_KEYWORD_GROUP5                       = "[Group5]";
HEALASSIGN_KEYWORD_GROUP6                       = "[Group6]";
HEALASSIGN_KEYWORD_GROUP7                       = "[Group7]";
HEALASSIGN_KEYWORD_GROUP8                       = "[Group8]";

HEALASSIGN_KEYWORD_GROUP1_ALT                   = "[1]";
HEALASSIGN_KEYWORD_GROUP2_ALT                   = "[2]";
HEALASSIGN_KEYWORD_GROUP3_ALT                   = "[3]";
HEALASSIGN_KEYWORD_GROUP4_ALT                   = "[4]";
HEALASSIGN_KEYWORD_GROUP5_ALT                   = "[5]";
HEALASSIGN_KEYWORD_GROUP6_ALT                   = "[6]";
HEALASSIGN_KEYWORD_GROUP7_ALT                   = "[7]";
HEALASSIGN_KEYWORD_GROUP8_ALT                   = "[8]";

HEALASSIGN_CLASS_NAMES = 
{
    WARRIOR = "Warrior",
    ROGUE   = "Rogue",
    HUNTER  = "Hunter",
    MAGE    = "Mage",
    WARLOCK = "Warlock",
    DRUID   = "Druid",
    PRIEST  = "Priest",
    SHAMAN  = "Shaman",
    PALADIN = "Paladin"
};

HEALASSIGN_SPELL_RANGE = 
{
    DRUID   = "Healing Touch",
    PRIEST  = "Lesser Heal",
    SHAMAN  = "Healing Wave",
    PALADIN = "Holy Light"
};

HEALASSIGN_HELP_FORMATTER                       = "%s: %s";
HEALASSIGN_HELP_INTRO                           = "Use \"/ha help <command>\" for more specific help.";
HEALASSIGN_HELP_NOT_AVAILABLE                   = "No help available for this topic.";
HEALASSIGN_HELP_NOT_AVAILABLE_FOR_TOPIC         = "No help available for topic \"%s\".";

HEALASSIGN_HELP_BASIC_LISTING =
{
    [HEALASSIGN_SLASH_COMMAND_HELP]             = "Displays help.",
    [HEALASSIGN_SLASH_COMMAND_OPTIONS]          = "Displays configuration UI.",
    [HEALASSIGN_SLASH_COMMAND_ASSIGN]           = "Assigns the healer to the target(s).",
    [HEALASSIGN_SLASH_COMMAND_ASSIGN_TARGET]    = "Assigns the target to the healer(s).",
    [HEALASSIGN_SLASH_COMMAND_UNASSIGN]         = "Unassigns the healer from the target(s).",
    [HEALASSIGN_SLASH_COMMAND_CLEAR]            = "Clears all healing assignments.",
    
    [HEALASSIGN_SLASH_COMMAND_LIST]             = "Lists all healing assignments by healer.",
    [HEALASSIGN_SLASH_COMMAND_LISTTARGETS]      = "Lists all healing assignments by target.",
    
    [HEALASSIGN_SLASH_COMMAND_SET]              = "Saves and loads assignment sets.",
    
    [HEALASSIGN_SLASH_COMMAND_SETCHANNEL]       = "Sets the channel.",
    [HEALASSIGN_SLASH_COMMAND_UNASSIGNED]       = "Lists all unassigned healers.",
    [HEALASSIGN_SLASH_COMMAND_VERSIONCHECK]     = "Lists raid members with different versions of HealAssign.",
    [HEALASSIGN_SLASH_COMMAND_VERSIONLIST]      = "Lists the versions of HealAssign.",
    [HEALASSIGN_SLASH_COMMAND_SYNC]             = "Sends / requests a full sync.",
    [HEALASSIGN_SLASH_COMMAND_SERVER]           = "Become the server for HealAssign."
};

HEALASSIGN_HELP_LISTING =
{
    [HEALASSIGN_SLASH_COMMAND_ASSIGN]           = "assign <healer name> <target name> [target name] [target name] ...",
    [HEALASSIGN_SLASH_COMMAND_ASSIGN_TARGET]    = "assigntarget <target name> <healer name> [healer name] [healer name] ...",
    [HEALASSIGN_SLASH_COMMAND_UNASSIGN]         = "unassign <healer name> [target name] [target name] [target name] ...\nIf the target name is omitted, all targets will be removed from this healer.",
    
    [HEALASSIGN_SLASH_COMMAND_LIST]             = "Optional arguments:\n    raid: Lists to the raid.\n    channel: Lists to the channel.\n    officer: Lists to the officer channel.\n    whisper: Whispers assignments to healers.",
    [HEALASSIGN_SLASH_COMMAND_LISTTARGETS]      = "Optional arguments:\n    raid: Lists to the raid.\n    channel: Lists to the channel.\n    officer: Lists to the officer channel.",
    
    [HEALASSIGN_SLASH_COMMAND_SET]              = "Arguments:\n    save <name>: Saves the current assignments as a set with the given name.\n    load <name>: Loads assignments from the given set name.\n    erase <name>: Erases the set with the given name.\n    list: Lists all saved assignment sets.",
    
    [HEALASSIGN_SLASH_COMMAND_VERSIONCHECK]     = "The server is marked with *.",
    [HEALASSIGN_SLASH_COMMAND_VERSIONLIST]      = "The server is marked with *.",
    [HEALASSIGN_SLASH_COMMAND_SYNC]             = "If you are the server, sends a full sync.\nIf you are not the server, requests a full sync."
};

end
