--[[
Project name: HeadCount
Developed by: seppyk (http://www.authority-km.com)
Website: http://www.wowace.com/wiki/HeadCount
Description: Manages tracking of raid attendance and more.
License: Creative Common Attribution-NonCommercial-ShareAlike 3.0 Unported
File: en_US.lua
File description: en_US resource bundle
]]

local L = AceLibrary("AceLocale-2.2"):new("HeadCount")

L:RegisterTranslations("enUS", function() return {
	["product.usage"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Use |cFF9999FF/headcount|r or |cFF9999FF/hc|r for configuration.", 	

	["am"] = "am", 
	["active"] = "Active", 
	["Bank"] = true, 
	["Boss"] = true, 
	["Cancel"] = "Cancel", 
	["Class"] = "Class", 
	["Close"] = true, 
	["Cost"] = true, 
	["Current"] = "Current", 
	["Date"] = true, 
	["Disenchanted"] = true, 
	["end"] = "End", 
	["false"] = "False", 
	["Female"] = "Female", 
	["Gender"] = "Gender", 
	["Guild"] = "Guild", 
	["Length"] = true, 
	["Level"] = "Level", 
	["Loot"] = true, 
	["Male"] = "Male", 
	["Member"] = "Member", 
	["Members"] = "Members", 
	["Name"] = "Name", 
	["No"] = "No", 
	["None"] = "None", 
	["Offline"] = true, 
	["Offspec"] = true, 
	["online"] = "Online", 
	["Player"] = true, 
	["Players"] = true, 
	["pm"] = "pm", 
	["Presence"] = "Presence", 
	["Race"] = "Race", 
	["Raid"] = true,  		
	["Recovery"] = "Recovery", 
	["remove"] = "Remove", 
	["Save"] = true, 
	["Source"] = true, 
	["Standby"] = true, 
	["start"] = "Start", 
	["Time"] = "Time", 
	["Total"] = true, 
	["true"] = "True", 
	["Unknown"] = "Unknown", 
	["version"] = "Version", 
	["Wait"] = true, 
	["Yes"] = "Yes", 
	["Zone"] = true, 

	["Assign loot to bank"] = true, 
	["Assign loot as disenchanted"] = true, 
	["Assign loot as offspec"] = true, 
	["Begin time"] = "Begin time", 
	["Boss kills"] = true, 
	["Close menu"] = true, 
	["Close the menu"] = true, 
	["Current raid"] = "Current raid", 	
	["Druid players"] = true, 
	["End active raid"] = "End active raid", 
	["End raid"] = "End raid", 
	["End time"] = "End time", 
	["Export raid"] = "Export raid", 
	["Go back"] = "Go back", 
	["General information"] = "General information", 
	["Hunter players"] = true, 
	["Item cost"] = "Item cost", 
	["Item level"] = "Item level", 
	["Item unavailable"] = "Item unavailable", 
	["Last activity"] = "Last activity", 
	["Last activity time"] = "Last activity time", 
	["Loot cost"] = true, 
	["Loot source"] = true, 
	["Looted by"] = true, 
	["Mage players"] = true, 
	["Manage loot"] = true, 
	["Member name"] = "Member name", 
	["No list"] = "No list", 
	["Number of bosses"] = "Number of bosses", 
	["Number of items"] = "Number of items", 
	["Number of members"] = "Number of members", 
	["Offline time"] = "Offline time", 
	["Paladin players"] = true, 
	["Priest players"] = true, 
	["Raid information"] = "Raid information", 
	["Raid list"] = "Raid list", 
	["Raid list time"] = "Raid list time", 
	["Remove all"] = "Remove all", 
	["Remove all raids"] = "Remove all raids", 
	["Remove boss"] = "Remove boss", 
	["Remove raid"] = "Remove raid", 
	["Remove member"] = "Remove member", 
	["Remove loot"] = "Remove loot", 
	["Rogue players"] = true, 
	["Shaman players"] = true, 
	["Start new raid"] = "Start new raid", 
	["Start raid"] = "Start raid", 
	["Time history"] = "Time history", 
	["Time information"] = "Time information", 
	["Total time"] = "Total time", 
	["Trash mob"] = "Trash mob", 
	["View raid bosses"] = "View raid bosses", 
	["View raid loot"] = "View raid loot", 
	["View raid members"] = "View raid members", 
	["Wait list"] = "Wait list", 
	["Wait list time"] = "Wait list time", 
	["Warlock players"] = true, 
	["Warrior players"] = true, 
	
	-- Console commands
	["console.commands"] = { "/headcount", "/hc" }, 
	["console.usage.item.quality"] = "[|cFF9D9D9DPoor|r | |cFFFFFFFFCommon|r | |cFF1EFF00Uncommon|r | |cFF0070DDRare|r | |cFFA335EEEpic|r | |cFFFF8000Legendary|r | |cFFE6CC80Artifact|r]", 
	["console.usage.groups"] = "[1 2 3 4 5 6 7 8]", 
	["console.usage.exclude"] = "[link]", 
	
	["console.command.gui.name"] = "Raid tracker",
	["console.command.gui.description"] = "Opens the raid tracker user interface.",	
	
	["console.command.attendance.name"] = "Attendance", 
	["console.command.attendance.description"] = "Configure attendance tracking options.", 
	["console.command.attendance.raidlistgroups.name"] = "Raid list groups", 
	["console.command.attendance.raidlistgroups.description"] = "Set the raid list groups.", 
	["console.command.attendance.waitlistgroups.name"] = "Wait list groups", 
	["console.command.attendance.waitlistgroups.description"] = "Set the wait list groups.", 
	["console.command.attendance.autoselection.name"] = "Automatic group selection", 
	["console.command.attendance.autoselection.description"] = "Enables or disables automatic group selection by raid zone.", 	
	["console.command.attendance.delay.name"] = "Attendance delay", 
	["console.command.attendance.delay.description"] = "Sets the attendance delay to increase or decrease performance at the cost of attendance accuracy.  Increase the time (measured in number of seconds) for improved performance at the cost of decreased accuracy.", 
	["console.command.attendance.bgtracking.name"] = "Battleground tracking", 
	["console.command.attendance.bgtracking.description"] = "Enables or disables attendance tracking while in a battleground.", 
	
	["console.command.time.name"] = "Time", 
	["console.command.time.description"] = "Configure time options.", 
	["console.command.time.timezone.name"] = "Time zone", 
	["console.command.time.timezone.description"] = "Sets the time zone difference for display.", 	
	["console.command.time.timeformat.name"] = "24-hour time format", 
	["console.command.time.timeformat.description"] = "Enables or disables the 24-hour time format.", 
	["console.command.time.timetotals.name"] = "Time totals", 
	["console.command.time.timetotals.description"] = "Sets the lists that contribute to total activity time.", 
	["console.command.time.timetotals.raidlisttime.name"] = "Raid list time", 
	["console.command.time.timetotals.raidlisttime.description"] = "Enables or disables raid list activity to count as total activity time.", 
	["console.command.time.timetotals.waitlisttime.name"] = "Wait list time", 
	["console.command.time.timetotals.waitlisttime.description"] = "Enables or disables wait list activity to count as total activity time.", 
	["console.command.time.timetotals.offlinetime.name"] = "Offline time", 
	["console.command.time.timetotals.offlinetime.description"] = "Enables or disables offline activity to count as total activity time.", 
							
	["console.command.loot.name"] = "Loot", 
	["console.command.loot.description"] = "Configure loot tracking options.", 
	["console.command.loot.minimum.name"] = "Minimum loot quality", 
	["console.command.loot.minimum.description"] = "Set the minimum tracked loot quality.", 
	["console.command.loot.popup.name"] = "Loot management popup", 
	["console.command.loot.popup.description"] = "Enables or disabled the loot management popup window whenever a tracked loot item is distributed.", 
	["console.command.loot.exclude.name"] = "Loot exclusion", 
	["console.command.loot.exclude.description"] = "Manage loot exclusion", 
	
	["console.command.export.name"] = "Export", 
	["console.command.export.description"] = "Configure exporting options.", 	
	["console.command.export.format.name"] = "Export format", 
	["console.command.export.format.description"] = "Set the export format.", 
	["console.command.export.format.usage"] = "[EQdkp]", 

	["console.command.reporting.name"] = "Reporting", 
	["console.command.reporting.description"] = "Configure reporting options", 
	["console.command.reporting.bosskills.name"] = "Broadcast boss kills",  
	["console.command.reporting.bosskills.description"] = "Broadcast boss kills in real-time to guild chat", 
	["console.command.reporting.loot.name"] = "Broadcast loot", 
	["console.command.reporting.loot.description"] = "Broadcast loot in real-time to guild chat.", 
	
	["console.command.debug.name"] = "Debug", 
	["console.command.debug.description"] = "Enables or disables the debug flag.", 		

	["console.command.exclude.name"] = "Exclude", 
	["console.command.exclude.description"] = "Enables or disables tracking for specific loot items.", 
	["console.command.exclude.add.name"] = "Add loot", 
	["console.command.exclude.add.description"] = "Add loot to the exclude list.", 
	["console.command.exclude.add.set"] = "Successfully added loot to the exclude list.", 	
	["console.command.exclude.remove.name"] = "Remove loot", 
	["console.command.exclude.remove.description"] = "Remove loot from the exclude list.", 
	["console.command.exclude.remove.set"] = "Successfully removed loot from the exclude list.", 
	["console.command.exclude.list.name"] = "List loot", 
	["console.command.exclude.list.description"] = "Display the exclusion list.", 
	
	-- *** MINIMAP MESSAGES ***
	["minimap.frame"] = "|cFF9999FFLeft-click|r |cFFFFFFFFto open the raid tracker.|r", 
	["minimap.configuration"] = "|cFF9999FFRight-click|r |cFFFFFFFFto open the configuration menu.", 
	["minimap.button.rotate"] = "|cFF9999FFLeft-click|r |cFFFFFFFFand|r |cFF9999FFdrag the mouse|r |cFFFFFFFFto rotate the minimap button.", 
	["minimap.button.drag"] = "|cFFFFFFFFHold|r |cFF9999FFalt|r |cFFFFFFFFand|r |cFF9999FFdrag the mouse|r |cFFFFFFFFto move the minimap button.", 

	-- Information messages
	["info.boss.snapshot"] = "Boss snapshot (%d members)", 
	["info.end.raid"] = "Do you want to end the active raid?", 
	["info.end.raid.noraidsexists"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Unable to end the active raid because no raid is currently active.", 	
	["info.exclude.loot"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r %s (%s)", 
	["info.exclude.loot.manage"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Use the command-line options to manage loot exclusion (/headcount exclude).", 	
	["info.exclude.loot.title"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Number of excluded items: %d", 	
	["info.exclude.number"] = "Number of excluded items: %d", 
	["info.export.raid"] = "Exporting raid information (%s format)", 	
	["info.initialization.complete"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Addon loaded.", 
	["info.item.unsafe"] = "This item is unsafe.", 
	["info.item.query"] = "You may left-click to attempt to query the server for this item.", 
	["info.item.requery"] = "If the item was queried, you may need to reclick to requery and/or refresh the interface.", 
	["info.loot.manage"] = "Manage loot information", 
	["info.newraid"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r New raid started (%s).", 
	["info.noraidsexist"] = "No raids currently exist.", 
	["info.noraidsselected"] = "No raid is currently selected.", 
	["info.raidbosses"] = "Raid bosses (%d bosses)", 
	["info.raidhistory"] = "Raid history (%d raids)", 
	["info.raidloot"] = "Raid loot (%d items)", 
	["info.raidmembers"] = "Raid members (%d members)", 
	["info.raidplayer"] = "Member information", 
	["info.remove.raid"] = "Do you want to remove this raid?", 
	["info.remove.allraids"] = "Do you want to remove all raids?", 
	["info.remove.allraids.warning"] = "WARNING: This will delete all tracked data.", 
	["info.remove.boss"] = "Do you want to remove this raid boss?", 
	["info.remove.member"] = "Do you want to remove this raid member?", 
	["info.remove.loot"] = "Do you want to remove this raid loot?", 
	["info.start.raid"] = "Do you want to start a new raid?", 
	
	-- Warning messages
	
	["warning.export.raid.currentraid"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Unable to export.  An active raid cannot be exported.", 	
	["warning.loot.manage.cost"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Unable to manage loot.  The loot cost must be a valid number.",
	["warning.loot.manage.looter"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Unable to manage loot.  The looted by value must be a valid string.", 
	["warning.loot.manage.source"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Unable to manage loot.  The loot source value must be a valid string.", 
	["warning.loot.popup.remove.loot"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Unable to remove loot because a loot management popup window is active.", 	
	["warning.loot.popup.remove.raid"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Unable to remove raid because a loot management popup window is active.", 
	["warning.loot.popup.remove.removeall"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Unable to remove all raids because a loot management popup window is active.", 
	["warning.removeraid.failure"] = "|cFF9999FF%s:|r Unable to remove raid [id: %d].", 
	
	-- Error messages	
	["error.loot.maximum"] = "|cFFFFFF7F%s:|r The maximum loot quality [|cFFFFFF7F%s|r] cannot be less than the minimum loot quality [|cFFFFFF7F%s|r].", 
	["error.loot.minimum"] = "|cFFFFFF7F%s:|r The minimum loot quality [|cFFFFFF7F%s|r] cannot be greater than the maximum loot quality [|cFFFFFF7F%s|r].", 
	["error.type.number"] = "|cFFFFFF7F%s:|r %s expects a number.", 
	["error.type.string"] = "|cFFFFFF7F%s:|r %s expects a string.", 
	["error.sort.name"] = "|cFFFFFF7F%s:|r Unable to sort because a raid member has no name.", 
	["error.sort.starttime"] = "|cFFFFFF7F%s:|r Unable to sort because a raid has no start time.", 
	["error.exclude.duplicate"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Unable to add because the loot item, %s, is already in the exclude list.", 
	["error.exclude.missing"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r Unable to remove because the loot item, %s, is not present in the exclude list.", 
	
	
	-- Guild messages
	["guild.broadcast.bosskill"] = "Raid boss killed: %s", 
	["guild.broadcast.loot"] = "%s receives raid loot: %s [%s]", 
	
	-- Debug messages
	["debug.boss.engage"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Boss engaged: %s (%s).", 
	["debug.boss.kill"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Boss killed: %s (%s).", 
	["debug.boss.kill.complete"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Boss encounter complete: %s.", 
	["debug.boss.loot.complete"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Boss loot encountered: %s.", 
	["debug.boss.wipe"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Boss wipe.", 
	["debug.boss.wipe.check"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Checking for boss wipe.", 
	["debug.enable.loadedraiddata"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Loaded raid data (%d raids).", 
	["debug.event.register"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Registering event: %s", 
	["debug.event.unregister"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Unregistering event: %s", 
	["debug.raidtracker.setup.raid.final"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Owner is in raid and the most recent raid is final.  Starting new raid.", 
	["debug.raidtracker.setup.raid.nofinal"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Owner is in raid and the most recent raid is not final.  Continuing.", 
	["debug.raidtracker.setup.noraid.final"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Owner is not in a raid and the most recent raid is final.  No recovery required.", 
	["debug.raidtracker.setup.noraid.nofinal"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r The owner is not in a raid.  Recovering by finalizing the most recent raid.", 
	["debug.raid.update.activitytime"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r The new raid update activity time is: (%s)", 
	["debug.raid.update.addmember.raidlist"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Adding a new player [%s] to the raid list.", 
	["debug.raid.update.addmember.waitlist"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Adding a new player [%s] to the wait list.",	
	["debug.raid.update.addmember.nolist"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Adding a new player [%s] to no list.", 
	["debug.raid.update.addmember.offline"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Adding a new player [%s] to no list.  Player is offline.", 	
	["debug.raid.update.modifymember.raidlist"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Moving an existing player [%s] to the raid list.", 	
	["debug.raid.update.modifymember.waitlist"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Moving an existing player [%s] to the wait list.", 
	["debug.raid.update.modifymember.nolist"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Moving an existing player [%s] to no list.", 
	["debug.raid.update.modifymember.offline"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Moving an existing player [%s] to no list.  Player is offline.", 
	["debug.raid.update.continue"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r The current raid is continuing (Updated: %s).", 
	["debug.raid.update.end"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r The raid has ended (%s).", 
	["debug.raid.update.numberOfRaidMembers"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r There currently are %d tracked raid members.", 
	["debug.raid.update.modifymember.leave"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r %s has left the raid.",  
	["debug.status.battleground.enter"] =  "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Raid tracking is disabled because player is in a battleground (%s).", 
	["debug.status.battleground.leave"] =  "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Raid tracking is enabled because player exited a battleground.", 
	["debug.console.command.attendance.groups.range.invalid"] = "The group value [%d] is not in the proper range [1-8].", 
	["debug.console.command.attendance.groups.number.invalid"] = "The group value [%s] is not a number.", 

	["debug.mod.disable"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Mod disabled.",  
	["debug.mod.enable"] = "|cFF9999FF%s|r |cFF6666FF(%s.%s):|r |cFF9999FF(DEBUG)|r Mod enabled.",  

	-- Localization
	["language.de"] = "German", 	
	["language.en"] = "English", 
	["language.es"] = "Spanish", 	
	["language.fr"] = "French", 
	["language.ko"] = "Korean", 
	["language.ru"] = "Russian", 
	["language.zh"] = "Chinese", 	
	
	-- Item quality
	["Poor"] = true, 
	["Common"] = true, 
	["Uncommon"] = true, 
	["Rare"] = true, 
	["Epic"] = true, 
	["Legendary"] = true, 
	["Artifact"] = true, 
	
	-- Time lists
	["Raidlist"] = true, 
	["Waitlist"] = true, 
	["Offline"] = true, 
	
	-- Export formats
	["EQdkp"] = true, 
	["XML"] = true, 
	["Text"] = true, 

	-- Classes
	["Druid"] = true, 
	["Hunter"] = true, 
	["Mage"] = true, 
	["Paladin"] = true, 
	["Priest"] = true, 
	["Rogue"] = true, 
	["Shaman"] = true, 
	["Warlock"] = true, 
	["Warrior"] = true, 	

	-- Raid instances
	["Zul'Gurub"] = true, 		
	["Ruins of Ahn'Qiraj"] = true, 
	["Onyxia's Lair"] = true, 
	["Molten Core"] = true, 
	["Blackwing Lair"] = true, 
	["Naxxramas"] = true, 
	["Ahn'Qiraj"] = true,  
	["Karazhan"] = true, 
	["Zul'Aman"] = true, 
	["Gruul's Lair"] = true, 
	["Magtheridon's Lair"] = true, 
	["Serpentshrine Cavern"] = true, 
	["Tempest Keep"] = true, 		
	["Hyjal Summit"] = true, 
	["Black Temple"] = true, 
	["Sunwell Plateau"] = true, 	

	-- Raid instance name aliases
	["Temple of Ahn'Qiraj"] = true, 
	["Battle for Mount Hyjal"] = true, 

	-- Battleground zones
	["Alterac Valley"] = true, 
	["Arathi Basin"] = true, 
	["Eye of the Storm"] = true, 
	["Warsong Gulch"] = true, 
	
	-- Arena zones
	["Blade's Edge Arena"] = true, 
	["Nagrand Arena"] = true, 
	["Ruins of Lordaeron"] = true, 
	
	-- Chest targets
	["Cache of the Firelord"] = true, 
	["Four Horsemen Chest"] = true, 
	["Dust Covered Chest"] = true, 
	
	-- Bosses
	["Akama"] = true, 
	["Amani Bear Spirit"] = true, 
	["Amani Dragonhawk Spirit"] = true, 
	["Amani Eagle Spirit"] = true, 
	["Amani Lynx Spirit"] = true, 
	["Arygos"] = true, 
	["Blade of Azzinoth"] = true, 
	["Blindeye the Seer"] = true, 	
	["Caelestrasz"] = true, 
	["Captain Balinda Stonehearth"] = true, 
	["Captain Galvangar"] = true, 
	["Dire Wolf"] = true, 
	["Dorothee"] = true, 
	["Drek'Thar"] = true, 
	["Echo of Medivh"] = true, 
	["Emperor Vek'lor"] = true,
	["Emperor Vek'nilash"] = true,	
	["Entropius"] = true, 	
	["Essence of Anger"] = true,
	["Essence of Desire"] = true, 
	["Essence of Suffering"] = true, 
	["Eye of C'Thun"] = true, 
	["Feugen"] = true, 
	["Gathios the Shatterer"] = true,
	["Grand Astromancer Capernian"] = true, 
	["Grand Warlock Alythess"] = true,
	["Hellfire Channeler"] = true, 
	["High Nethermancer Zerevor"] = true,
	["Highlord Mograine"] = true, 
	["Flame of Azzinoth"] = true, 
	["Image of Medivh"] = true, 
	["Julianne"] = true,		
	["Kalecgos"] = true, 
	["Kiggler the Crazed"] = true, 
	["Krosh Firehand"] = true, 
	["Lady Blaumeux"] = true,
	["Lady Jaina Proudmoore"] = true, 	
	["Lady Malande"] = true,		
	["Lady Sacrolash"] = true,
	["Lord Sanguinar"] = true, 
	["Lord Victor Nefarius"] = true, 
	["Madrigosa"] = true, 
	["Maiev Shadowsong"] = true, 
	["Majordomo Executus"] = true, 
	["Master Engineer Telonicus"] = true, 
	["Merithra of the Dream"] = true, 	
	["Midnight"] = true, 
	["Ohgan"] = true, 
	["Olm the Summoner"] = true, 
	["Roar"] = true, 
	["Romulo"] = true,	
	["Sathrovarr the Corruptor"] = true, 
	["Shadow of Aran"] = true, 
	["Shadow of Leotheras"] = true, 
	["Sir Zeliek"] = true,	
	["Spirit of the Lynx"] = true, 
	["Stalagg"] = true, 
	["Strawman"] = true, 
	["Thaladred the Darkener"] = true, 
	["Thane Korth'azz"] = true, 	
	["The Big Bad Wolf"] = true,
	["The Crone"] = true,	
	["The Illidari Council"] = true, 
	["Thrall"] = true, 
	["Tinhead"] = true,  
	["Tito"] = true, 
	["Tyrande Whisperwind"] = true, 
	["Vanndar Stormpike"] = true, 	
	["Veras Darkshadow"] = true,	

	-- Boss events aliases
	["Chess Event"] = true, 
	["Eredar Twins"] = true, 
	["Opera Event (The Big Bad Wolf)"] = true, 
	["Opera Event (Romulo and Julianne)"] = true, 	
	["Opera Event (Wizard of Oz)"] = true, 
	["Reliquary of Souls"] = true, 
	["The Four Horsemen"] = true, 
	["Twin Emperors"] = true, 

	-- *** MISCELLANEOUS ***
	itemQuality = {
		"Poor", 
		"Common", 
		"Uncommon", 
		"Rare", 
		"Epic", 
		"Legendary", 
		"Artifact", 
	}, 

	itemQualityNumbers = {
		["Poor"] = 0, 
		["Common"] = 1, 
		["Uncommon"] = 2, 
		["Rare"] = 3, 
		["Epic"] = 4, 
		["Legendary"] = 5, 
		["Artifact"] = 6, 
	}, 	

	-- Raid instances
	-- The key name may also need translation for other locales
	raidInstances = { 		
		["Zul'Gurub"] = "Zul'Gurub", 		
		["Ruins of Ahn'Qiraj"] = "Ruins of Ahn'Qiraj", 
		["Onyxia's Lair"] = "Onyxia's Lair", 
		["Molten Core"] = "Molten Core", 
		["Blackwing Lair"] = "Blackwing Lair", 
		["Naxxramas"] = "Naxxramas", 
		["Ahn'Qiraj"] = "Temple of Ahn'Qiraj", 
		["Karazhan"] = "Karazhan", 
		["Zul'Aman"] = "Zul'Aman", 
		["Gruul's Lair"] = "Gruul's Lair", 
		["Magtheridon's Lair"] = "Magtheridon's Lair", 
		["Serpentshrine Cavern"] = "Serpentshrine Cavern", 
		["Tempest Keep"] = "Tempest Keep", 		
		["Hyjal Summit"] = "Battle for Mount Hyjal", 
		["Black Temple"] = "Black Temple", 
		["Sunwell Plateau"] = "Sunwell Plateau", 
	}, 
	
	bossEncounterList = {
		["Emperor Vek'lor"] = "Twin Emperors",
		["Emperor Vek'nilash"] = "Twin Emperors",	
		["Highlord Mograine"] = "The Four Horsemen",	
		["Lady Blaumeux"] = "The Four Horsemen",	
		["Sir Zeliek"] = "The Four Horsemen",	
		["Thane Korth'azz"] = "The Four Horsemen", 	
		["Julianne"] = "Opera Event (Romulo and Julianne)",	
		["Romulo"] = "Opera Event (Romulo and Julianne)",	
		["The Big Bad Wolf"] = "Opera Event (Big Bad Wolf)",
		["The Crone"] = "Opera Event (Wizard of Oz)",	
		["Essence of Anger"] = "Reliquary of Souls",
		["Gathios the Shatterer"] = "The Illidari Council",
		["High Nethermancer Zerevor"] = "The Illidari Council",
		["Lady Malande"] = "The Illidari Council",		
		["Veras Darkshadow"] = "The Illidari Council",
		["Sathrovarr the Corruptor"] = "Kalecgos", 
		["Grand Warlock Alythess"] = "Eredar Twins",
		["Lady Sacrolash"] = "Eredar Twins",
		["Entropius"] = "M'uru", 	
	}, 
	
	ignoreBossList = {
		-- Zul'Gurub (ZG)
		["Ohgan"] = true, 
		
		-- Blackwing Lair (BWL)
		["Lord Victor Nefarius"] = true, 
		
		-- Temple of Ahn'Qiraj (AQ40)
		["Arygos"] = true, 
		["Caelestrasz"] = true, 
		["Eye of C'Thun"] = true, 
		["Merithra of the Dream"] = true, 
		
		-- Naxxramas
		["Feugen"] = true, 
		["Stalagg"] = true, 
		
		-- Karazhan
		["Dorothee"] = true, 	
		["Echo of Medivh"] = true, 
		["Image of Medivh"] = true, 
		["Midnight"] = true, 
		["Roar"] = true, 
		["Shadow of Aran"] = true, 
		["Strawman"] = true, 
		["Tinhead"] = true,  
		["Tito"] = true, 		
		
		-- Zul'Aman (ZA)
		["Amani Bear Spirit"] = true, 
		["Amani Dragonhawk Spirit"] = true, 
		["Amani Eagle Spirit"] = true, 
		["Amani Lynx Spirit"] = true, 
		["Spirit of the Lynx"] = true, 
		
		-- Gruul's Lair
		["Blindeye the Seer"] = true, 
		["Kiggler the Crazed"] = true, 
		["Krosh Firehand"] = true, 
		["Olm the Summoner"] = true, 
		
		-- Magtheridon's Lair
		["Hellfire Channeler"] = true, 
		
		-- Serpentshrine Cavern (SSC)
		["Shadow of Leotheras"] = true, 
		
		-- Tempest Keep (TK)
		["Grand Astromancer Capernian"] = true, 
		["Lord Sanguinar"] = true, 
		["Master Engineer Telonicus"] = true, 
		["Thaladred the Darkener"] = true, 
		
		-- Battle for Mount Hyjal
		["Lady Jaina Proudmoore"] = true, 
		["Thrall"] = true, 
		["Tyrande Whisperwind"] = true, 
		["Dire Wolf"] = true, 

		-- Black Temple (BT)
		["Blade of Azzinoth"] = true, 
		["Essence of Desire"] = true, 
		["Essence of Suffering"] = true, 
		["Maiev Shadowsong"] = true, 
		["The Illidari Council"] = true, 
		["Akama"] = true, 
		["Flame of Azzinoth"] = true, 
		
		-- Sunwell Plateau
		["Kalecgos"] = true, 
		["Madrigosa"] = true, 
		
		-- Battlegrounds
		["Drek'Thar"] = true, 
		["Captain Galvangar"] = true, 
		["Captain Balinda Stonehearth"] = true, 
		["Vanndar Stormpike"] = true, 		
	}, 
	
	-- NON-TRANSLATED TEXT	
	-- ** OBJECTS **
	["object.Boss"] = "Boss", 
	["object.RaidTracker"] = "RaidTracker", 
	["object.Raid"] = "Raid", 
	["object.RaidListWrapper"] = "RaidListWrapper", 
	["object.Player"] = "Player", 
	["object.Loot"] = "Loot", 
	["object.TimePair"] = "TimePair", 
	["object.Time"] = "Time", 	
	
	["product.name"] = "HeadCount", 
	["product.version.major"] = "1", 
	["product.version.minor"] = "1", 
	["product.version.release"] = "5", 
} end)