--[[
Hatty's Mark Bar v 1.1
]]

-- Tooltips

local HMB_TOOLTIPS = {}
HMB_TOOLTIPS[1] = "Star"
HMB_TOOLTIPS[2] = "Circle"
HMB_TOOLTIPS[3] = "Diamond"
HMB_TOOLTIPS[4] = "Triangle"
HMB_TOOLTIPS[5] = "Moon"
HMB_TOOLTIPS[6] = "Square"
HMB_TOOLTIPS[7] = "X"
HMB_TOOLTIPS[8] = "Skull"
HMB_TOOLTIPS[9] = "Ready Check"

HMB_NONE = 0
HMB_RAID = 1
HMB_PARTY = 2

HMB_LOCKED = 1

function hmb_toggle()
    local frame = getglobal("HMB_main")
    if (frame) then
       if (frame:IsVisible()) then
            frame:Hide();
        else
            frame:Show();
        end
    end
end

function hmb_mark(num)
    if (UnitExists("target")) then
        SetRaidTargetIcon("target", num)
    end
end

function hmb_onload()
    SLASH_HMB1 = "/hmb"
    SlashCmdList["HMB"] = hmb_toggle;
    
    this:RegisterEvent("PARTY_MEMBERS_CHANGED")
	this:RegisterEvent("PARTY_LEADER_CHANGED")
    this:RegisterEvent("VARIABLES_LOADED")
end

function hmb_tooltip(id)
    GameTooltip:SetOwner(this, "ANCHOR_BOTTOMLEFT")
    
    if (id ~= 10) then
        GameTooltip:SetText(HMB_TOOLTIPS[id])
    else
        if (HMB_LOCKED == 1) then
            GameTooltip:SetText("Unlock HMB")
        else
            GameTooltip:SetText("Lock HMB")
        end
    end
    
    GameTooltip:Show()
end

function hmb_onevent()
    if (event == "PARTY_MEMBERS_CHANGED" or event == "PARTY_LEADER_CHANGED") then
        local gtype = hmb_grouptype()
        local frame = getglobal("HMB_main")
        if (gtype == HMB_RAID and (IsRaidLeader() or IsRaidOfficer())) then
            frame:Show()
        elseif (gtype == HMB_PARTY and IsPartyLeader()) then
            frame:Show()
        else
            frame:Hide()
        end
    elseif (event == "VARIABLES_LOADED") then
        local icon = getglobal("HMB_btn_lockunlockIcon")
        if (HMB_LOCKED == 1) then
            HMB_LOCKED = 0
            icon:SetTexCoord(0, 0.25, 0, 1)
        else
            HMB_LOCKED = 1
            icon:SetTexCoord(0.25, 0.50, 0, 1)
        end
    end
end

function hmb_grouptype()
    local raid = (GetNumRaidMembers() > 0)
    local party = (GetNumPartyMembers() > 0)
    
    if (raid) then
        return HMB_RAID
    elseif (party) then
        return HMB_PARTY
    else
        return HMB_NONE
    end
end

function hmb_lockunlock()
    local icon = getglobal("HMB_btn_lockunlockIcon")
    if (HMB_LOCKED == 1) then
        HMB_LOCKED = 0
        icon:SetTexCoord(0, 0.25, 0, 1)      
    else
        HMB_LOCKED = 1
        icon:SetTexCoord(0.25, 0.50, 0, 1)
    end
end

