-- (c) Torrid of www.torridreflections.com, aka Torrid/Torec/Torvie of Black Dragonflight USA
-- this file may be distributed so long as it remains unaltered
-- if this file is posted to a web site, credit must be given to me along with a link to my web page
-- portions of code in this file may be used in other works so long as credit is given to me

HKC_MAX_HISTORY = 100;
HKC_MAX_LEVEL = 70;

HKC_CFG = {};
HKC_CFG_DEFAULTS = {
	chatMessages = true,
	chatMessagesHK = true,
	onClickMsg = true,
	maxRecords = 500,
	maxArenaRecords = 20,
	doNotOpen = false,
	disableLifetime = false,
};
HKC_BGHISTORY_LABELS = nil;
HKC_BGHISTORY_BRACKET_LABELS = nil;

HKC_PlayerData = {};
HKC_KillsToday = {};
HKC_KillsLifetime = {};
HKC_BonusHistory = {};
HKC_BGHistory = {};
HKC_ArenaHistory = {};
HKC_TotalWinLoss = {};

local HKC_Server = "";
local HKC_PlayerName = "";
local HKC_Player = "";
local HKC_LastWinTimestamp = 0;
--local HKC_LastEstimated = 0;
local HKC_InBattleground = false;
local HKC_Map = "";				-- the BG map the player was just in (or is in)
local HKC_LastScore = 0;
local HKC_LastStats = 0;
local HKC_GotArenaScores = false;
local HKC_LastArenaSize = nil;

-- battleground outcome variables
local HKC_Winner = nil;
local HKC_Bracket = nil;
local HKC_isArena = nil;
local HKC_EnterTime = 0;
local HKC_Participants = 0;
local HKC_PremadePctA = 0;
local HKC_PremadePctH = 0;
local HKC_AFKA = 0;
local HKC_AFKH = 0;
local HKC_KBs = 0;
local HKC_Dmg = 0;
local HKC_Healing = 0;
local HKC_KBPlace = 0;
local HKC_DamagePlace = 0;
local HKC_HealingPlace = 0;
local HKC_AllianceScore = -1;
local HKC_HordeScore = -1;
local HKC_JoinedLate = 0;
local HKC_KillHonor = 0;
local HKC_BonusHonor = 0;
local HKC_ScoreboardBonusHonor = 0;

-- UI drop down selections
local HKC_Selected = 1;
local HKC_BGHistory_Selected = 1;
local HKC_BGHistoryBracket_Selected = 1;

local HKC_FrameText = {};			-- the text displayed in the UI text window scroll frame
local HKC_ZoneInTime = {};			-- to track the zone in time of players in the BG
local HKC_LastSort = 0;				-- the last sorted column in the table frame display
local HKC_DB = {};				-- the references to the records the table displays.  can sort this w/o altering the record tables

StaticPopupDialogs["HKC_DELETE_LIFETIME"] = {
	text = HKC_CONFIRM_DELETE_LIFETIME,
	button1 = YES,
	button2 = NO,
	OnAccept = function()
		HKC_KillsLifetime = {};
	end,
	timeout = 0,
	showAlert = 1,
	hideOnEscape = 1,
};

function HKC_OnLoad()
	SlashCmdList["HKC"] = HKCCmdLine;
	SLASH_HKC1 = "/hkc"; 

	this:RegisterEvent("VARIABLES_LOADED");
--	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("CHAT_MSG_COMBAT_HONOR_GAIN");
--	this:RegisterEvent("UNIT_NAME_UPDATE");
	this:RegisterEvent("PLAYER_TARGET_CHANGED");
	this:RegisterEvent("UPDATE_MOUSEOVER_UNIT");
	this:RegisterEvent("UPDATE_BATTLEFIELD_SCORE");
	this:RegisterEvent("ZONE_CHANGED_NEW_AREA");

	if (DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage(HKC_LOGINMSG);
	end
end

function HKCResetToday(forcereset)
	local hk, dk, contribution, rank;
	local moreThanTwoDays = false;

	-- check date, if it's been more than two days, reset
	local d = date("*t");
	local dateStamp = time(d);		-- today's date in seconds (one big number)

	-- if no date in player data, then he is new to v2.  Rely on yesterday's values
	if ( HKC_PlayerData.dateStamp ) then
		if ( dateStamp > (HKC_PlayerData.dateStamp + 172800) ) then	-- 172800 = two days
			moreThanTwoDays = true;
		end
	end

	HKC_PlayerData.dateStamp = dateStamp;

	-- Yesterday's values
	hk, contribution = GetPVPYesterdayStats();

	-- if yesterday's values differ from when last logged in, wipe kills for today
	if (	moreThanTwoDays or
		HKC_PlayerData.yesterdayHK ~= hk or
		HKC_PlayerData.yesterdayCP ~= contribution or
		forcereset
	) then
		-- new day
--		if ( HKC_PlayerData.estCP.HKCtoday > 0 ) then
--			HKC_AddHistory( "|c00ffffff"..date().."|r: "..string.format(HKC_RESETHISTORY, HKC_PlayerData.estCP.HKCtoday) );
--		end

		HKC_PlayerData.yesterdayHK = hk;
		HKC_PlayerData.yesterdayCP = contribution;

		HKC_KillsToday = {};

		-- wipe estinated CP for today
--		HKC_PlayerData.estCP.blizzToday = 0;
--		HKC_PlayerData.estCP.HKCtoday = 0;

		DEFAULT_CHAT_FRAME:AddMessage(HKC_RESET, 1, 0, 0);
	end
end

function HKCLogin()
	-- this addon has had a dozen versions and was one of my first, so you'll see some
	-- weird stuff here (and elsewhere)

	HKC_Server = GetCVar("realmName");
	HKC_PlayerName = UnitName("player");
	HKC_Player = HKC_PlayerName.." "..HKC_Server;

	-- just in case
	if ( UnitLevel("player") > HKC_MAX_LEVEL ) then
		HKC_MAX_LEVEL = HKC_MAX_LEVEL + 10;
	end

	-- add server to BG history if server is new (or version upgrade)
	if ( not HKC_BGHistory[HKC_Server] ) then
		HKC_BGHistory[HKC_Server] = {};
	end
	if ( not HKC_TotalWinLoss[HKC_Server] ) then
		HKC_TotalWinLoss[HKC_Server] = {};
	end

	-- add defaults to config
	local k, v;
	for k, v in pairs(HKC_CFG_DEFAULTS) do
		if ( type(HKC_CFG[k]) == "nil" ) then
			HKC_CFG[k] = v;
		end
	end

	-- new character?
	if ( not HKC_PlayerData.yesterdayHK ) then
		HKC_PlayerData = { yesterdayHK = 0, yesterdayCP = 0};
	end
--	if ( not HKC_PlayerData.estCP ) then
--		HKC_PlayerData.estCP = {
--			blizzToday = 0,
--			HKCtoday = 0,
--		};
--	end

	-- version upgrade?
	if ( not HKC_PlayerData.version or HKC_PlayerData.version ~= HKC_VERSION ) then
--debugmsg("updating HKC version");
		-- very old version data found?	
		if ( HKC_CFG[HKC_Player] ) then

			-- delete unused ancient version data if found
			if ( HKC_CFG[HKC_Player].LWDK) then
				HKC_CFG[HKC_Player].LWDK = nil;
				HKC_CFG[HKC_Player].YHK = nil;
				HKC_CFG[HKC_Player].LWrank = nil;
				HKC_CFG[HKC_Player].YC = nil;
				HKC_CFG[HKC_Player].LWHK = nil;
				HKC_CFG[HKC_Player].LWC = nil;
				HKC_CFG[HKC_Player].CPthisweek = nil;
				HKC_CFG[HKC_Player].ESTCP = nil;
				HKC_CFG[HKC_Player].YDK = nil;
				if (HKC_STANDINGS) then
					HKC_STANDINGS = nil;
				end
				if (HKC_WBLSTANDINGS) then
					HKC_WBLSTANDINGS = nil;
				end
				if (HKCHonorBonusHistory) then
					HKCHonorBonusHistory = nil;
				end
				if (HKCBGHonorHistory) then
					HKCBGHonorHistory = nil;
				end
			end

			-- update to version 3
			-- new version uses SavedVariablesPerCharacter instead of SavedVariables
			-- plus new detailed BG stats
			if ( HKC_CFG[HKC_Player].HonorBonusHistory ) then
				HKC_BonusHistory = HKC_CFG[HKC_Player].HonorBonusHistory;
				HKC_CFG[HKC_Player].HonorBonusHistory = nil;
			end
			if ( HKC_CFG[HKC_Player].BGHonorHistory ) then
				HKC_CFG[HKC_Player].BGHonorHistory = nil;
			end
			if ( HKC_CFG[HKC_Player].winLossRecord ) then
				-- delete BG histories with no names
				if ( HKC_CFG[HKC_Player].winLossRecord[""] ) then
					HKC_CFG[HKC_Player].winLossRecord[""] = nil;
				end
				if ( not HKC_TotalWinLoss[HKC_Server]["Old Data"] ) then
					HKC_TotalWinLoss[HKC_Server]["Old Data"] = {};
				end
				HKC_TotalWinLoss[HKC_Server]["Old Data"][HKC_PlayerName] = HKC_CFG[HKC_Player].winLossRecord;
				HKC_CFG[HKC_Player].winLossRecord = nil;
			end

			HKC_PlayerData = HKC_CFG[HKC_Player];
			HKC_CFG[HKC_Player] = nil;
		end

		-- more old version rearranging
		if ( HKC_KILLSLIFETIME and HKC_KILLSLIFETIME[HKC_Player] ) then
			HKC_KillsLifetime = HKC_KILLSLIFETIME[HKC_Player];
			HKC_KILLSLIFETIME[HKC_Player] = nil;
		end
		if ( HKC_KILLSTODAY and HKC_KILLSTODAY[HKC_Player] ) then
			HKC_KillsToday = HKC_KILLSTODAY[HKC_Player];
			HKC_KILLSTODAY[HKC_Player] = nil;
		end

		-- upgrade to 3.1 from 3
		local bg, bracket;
		for bg in pairs(HKC_BGHistory[HKC_Server]) do
			for bracket in pairs(HKC_BGHistory[HKC_Server][bg]) do
				for k, v in pairs(HKC_BGHistory[HKC_Server][bg][bracket]) do
					if ( not v[13] ) then
						v[13] = 0;
					end
					if ( not v[14] ) then
						v[14] = -1;
					end
					if ( not v[15] ) then
						v[15] = -1;
					end
				end
			end
		end

		-- fix blizzard's 71-70 nonsense
		for bg in pairs(HKC_BGHistory[HKC_Server]) do
			for bracket in pairs(HKC_BGHistory[HKC_Server][bg]) do
				if ( bracket == "71-70" ) then

					if ( not HKC_BGHistory[HKC_Server][bg]["70-70"] ) then
						HKC_BGHistory[HKC_Server][bg]["70-70"] = {};
					end

					for k, v in pairs(HKC_BGHistory[HKC_Server][bg][bracket]) do
						table.insert(HKC_BGHistory[HKC_Server][bg]["70-70"], v);
					end
					table.sort(HKC_BGHistory[HKC_Server][bg]["70-70"], 
						function(a, b)
							return a[1] < b[1];
						end
					);
					HKC_BGHistory[HKC_Server][bg][bracket] = nil;
					break;
				end
			end
		end

		for bg in pairs(HKC_TotalWinLoss[HKC_Server]) do
			for bracket in pairs(HKC_TotalWinLoss[HKC_Server][bg]) do
				if ( bracket == "71-70" ) then

					if ( not HKC_TotalWinLoss[HKC_Server][bg]["70-70"] ) then
						HKC_TotalWinLoss[HKC_Server][bg]["70-70"] = {};
					end

					for k, v in pairs(HKC_TotalWinLoss[HKC_Server][bg][bracket]) do
						if ( not HKC_TotalWinLoss[HKC_Server][bg]["70-70"][k] ) then
							HKC_TotalWinLoss[HKC_Server][bg]["70-70"][k] = { [1] = 0, [2] = 0, [3] = 0 };
						end

						HKC_TotalWinLoss[HKC_Server][bg]["70-70"][k][1] = HKC_TotalWinLoss[HKC_Server][bg]["70-70"][k][1] + HKC_TotalWinLoss[HKC_Server][bg][bracket][k][1];
						HKC_TotalWinLoss[HKC_Server][bg]["70-70"][k][2] = HKC_TotalWinLoss[HKC_Server][bg]["70-70"][k][2] + HKC_TotalWinLoss[HKC_Server][bg][bracket][k][2];
						HKC_TotalWinLoss[HKC_Server][bg]["70-70"][k][3] = HKC_TotalWinLoss[HKC_Server][bg]["70-70"][k][3] + HKC_TotalWinLoss[HKC_Server][bg][bracket][k][3];
					end

					
					HKC_TotalWinLoss[HKC_Server][bg][bracket] = nil;
					break;
				end
			end
		end

		-- arena maps are not battlegrounds
		if ( HKC_BGHistory[HKC_Server]["All Arenas"] ) then
			HKC_BGHistory[HKC_Server]["All Arenas"] = nil;
		end

		HKC_PlayerData.version = HKC_VERSION;
	end

	-- hook arena details frame to hide/show HKC panel when clicked
	hooksecurefunc("PVPFrame_OnShow", HKCOpenFrame);
	hooksecurefunc("PVPFrame_OnHide", HKCCloseFrame);
	hooksecurefunc("PVPTeamDetails_OnShow", HKCCloseFrame);
	hooksecurefunc("PVPTeamDetails_OnHide", HKCOpenFrame);
end

function HKC_EstimateCP(ecp, lastKill)
	if ( HKC_KillsToday[lastKill] > 10 ) then
		return 0
	elseif ( HKC_KillsToday[lastKill] == 1 ) then
		return ecp
	else
		return ecp - ( (HKC_KillsToday[lastKill] - 1) / 10 * ecp );
--		ecp = math.ceil(ecp - ( (HKC_KillsToday[lastKill] - 1) / 10 * ecp ));
--		return ecp
	end
end

function HKC_AddHistory(s)
	table.insert(HKC_BonusHistory, s);

	local i, n;

	n = #HKC_BonusHistory;
	if ( n > HKC_MAX_HISTORY ) then
		for i = 1, (n - HKC_MAX_HISTORY) do
			table.remove(HKC_BonusHistory, 1);
		end
	end
end

function HKC_BonusHistoryOnExit()
	-- call this after player just left a BG

	if ( HKC_isArena ) then
		return
	end

	-- scoreboard honor gained will be higher than adding up the chat text gains because the chat text gains
	-- truncate decimals
	if ( HKC_ScoreboardBonusHonor > HKC_BonusHonor ) then
-- debug
--debugmsg("HKC_ScoreboardBonusHonor ("..HKC_ScoreboardBonusHonor..") > HKC_BonusHonor ("..HKC_BonusHonor..")");
--		HKC_PlayerData.estCP.HKCtoday = HKC_PlayerData.estCP.HKCtoday + (HKC_ScoreboardBonusHonor - HKC_BonusHonor);
--		HKC_PlayerData.estCP.blizzToday = HKC_PlayerData.estCP.blizzToday + (HKC_ScoreboardBonusHonor - HKC_BonusHonor);
		HKC_BonusHonor = HKC_ScoreboardBonusHonor;
	end
	HKC_ScoreboardBonusHonor = 0;

--	gained = math.floor(HKC_PlayerData.estCP.HKCtoday - HKC_LastEstimated);
	gained = math.floor(HKC_KillHonor + HKC_BonusHonor);
	elapsed = math.floor( (time() - HKC_EnterTime) / 60 );

	if ( gained < 0 ) then
		gained = "?";
	end

	if ( HKC_CFG.chatMessages ) then
		DEFAULT_CHAT_FRAME:AddMessage( string.format(HKC_ENDBG, HKC_Map, elapsed) );
		HKC_KillHonor = math.floor(HKC_KillHonor);
		HKC_BonusHonor = math.floor(HKC_BonusHonor);
		DEFAULT_CHAT_FRAME:AddMessage( string.format(HKC_ENDBG4, tostring(gained), tostring(HKC_KillHonor), tostring(HKC_BonusHonor)) );

		if ( HKC_PremadePctA > 0 or HKC_PremadePctH > 0 ) then
			DEFAULT_CHAT_FRAME:AddMessage( string.format(HKC_ENDBG2, HKC_PremadePctA, HKC_PremadePctH) );
		end
		if ( HKC_AFKA > 0 or HKC_AFKH > 0 ) then
			DEFAULT_CHAT_FRAME:AddMessage( string.format(HKC_ENDBG3, HKC_AFKA, HKC_AFKH) );
		end
	end

	-- debug
	--[[
	DEFAULT_CHAT_FRAME:AddMessage("KB Place: "..HKC_KBPlace);
	DEFAULT_CHAT_FRAME:AddMessage("Damage Place: "..HKC_DamagePlace);
	DEFAULT_CHAT_FRAME:AddMessage("Healing Place: "..HKC_HealingPlace);
	DEFAULT_CHAT_FRAME:AddMessage("Alliance Score: "..HKC_AllianceScore);
	DEFAULT_CHAT_FRAME:AddMessage("Horde Score: "..HKC_HordeScore);

	if ( HKC_Winner ) then
		DEFAULT_CHAT_FRAME:AddMessage("HKC_Winner == "..HKC_Winner);
		if ( HKC_Winner ~= 0 and HKC_Winner ~= 1 and HKC_AllianceScore >= 0 and HKC_HordeScore >= 0 ) then
			if ( HKC_AllianceScore > HKC_HordeScore ) then
				DEFAULT_CHAT_FRAME:AddMessage("Alliance Won");
			else
				DEFAULT_CHAT_FRAME:AddMessage("Horde Won");
			end
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage("Left Early");
	end
	]]

	if ( HKC_Map == "Eastern Kingdoms" or HKC_Map == "" ) then
		return
	end

	-- Honor bonus history
	HKC_AddHistory( string.format(HKC_EXIT_HISTORY1, date(), HKC_Map) );
	if ( HKC_Winner and (HKC_Winner == 0 or HKC_Winner == 1) ) then
		HKC_AddHistory( string.format(getglobal("VICTORY_TEXT"..HKC_Winner)..";  "..HKC_EXIT_HISTORY2, elapsed, tostring(gained)) );
	else
		HKC_AddHistory( string.format(HKC_EXIT_HISTORY2, elapsed, tostring(gained)) );
	end

	-- BG History
	if ( gained ~= "?" ) then	-- ? used to mean day roll over, but I fixed that.  Why do I leave this here?  beats me

		local victor;
		if ( HKC_Winner ) then		-- 0 == horde, 1 == alliance, 255 == bugged, nil == no winner

			if ( HKC_Winner == 0 or HKC_Winner == 1 ) then
				victor = HKC_Winner;

			elseif ( HKC_AllianceScore >= 0 and HKC_HordeScore >= 0 ) then
				if ( HKC_AllianceScore > HKC_HordeScore ) then
					victor = 1;
				else
					victor = 0;
				end
			else
				-- blizzard's function still broken and no score data
				victor = 2;
			end
		else
			victor = 2;
		end
		
		local dateStamp = time(date("*t"));		-- today's date in seconds (one big number)

		-- determine level bracket if not obtained by blizzard's function for whatever reason
		local playerLevel = UnitLevel("player");
		local bracket;
		if ( not HKC_Bracket ) then
--debugmsg("HKC_Bracket not set");
			if ( HKC_Map == HKC_ALTERAC_VALLEY or HKC_Participants >= 30 ) then
				if ( playerLevel == HKC_MAX_LEVEL ) then
					bracket = (HKC_MAX_LEVEL - 9).."-"..HKC_MAX_LEVEL;
				else
					if ( playerLevel % 10 == 0 ) then
						bracket = (playerLevel - 9).."-"..playerLevel;
					else
						bracket = (playerLevel / 10 - (playerLevel / 10) % 1) * 10 + 1;
						bracket = bracket.."-"..(bracket + 9);
					end
				end
			else
				if ( playerLevel == HKC_MAX_LEVEL ) then
					bracket = HKC_MAX_LEVEL.."-"..HKC_MAX_LEVEL;
				else
					bracket = (playerLevel / 10 - (playerLevel / 10) % 1) * 10;
					bracket = bracket.."-"..bracket + 9;
				end
			end
--debugmsg("bracket calculated as "..bracket);
		else
			bracket = HKC_Bracket;
		end

		-- total win loss
		if ( not HKC_TotalWinLoss[HKC_Server][HKC_Map] ) then
			HKC_TotalWinLoss[HKC_Server][HKC_Map] = {};
		end
		if ( not HKC_TotalWinLoss[HKC_Server][HKC_Map][bracket] ) then
			HKC_TotalWinLoss[HKC_Server][HKC_Map][bracket] = {};
		end
		if ( not HKC_TotalWinLoss[HKC_Server][HKC_Map][bracket][HKC_PlayerName] ) then
			HKC_TotalWinLoss[HKC_Server][HKC_Map][bracket][HKC_PlayerName] = { [1] = 0, [2] = 0, [3] = 0 };
		end
		local winLossArr = HKC_TotalWinLoss[HKC_Server][HKC_Map][bracket][HKC_PlayerName];
		winLossArr[victor + 1] = winLossArr[victor + 1] + 1;

		-- bg history
		if ( not HKC_BGHistory[HKC_Server][HKC_Map] ) then
			HKC_BGHistory[HKC_Server][HKC_Map] = {};
		end
		if ( not HKC_BGHistory[HKC_Server][HKC_Map][bracket] ) then
			HKC_BGHistory[HKC_Server][HKC_Map][bracket] = {};
		end

		-- store placement and joined late data all into one integer value to save memory
		local places = HKC_KBPlace + (HKC_DamagePlace * 100) + (HKC_HealingPlace * 10000);
		if ( HKC_JoinedLate == 2 ) then
			places = places + 1000000;
		end
		table.insert(HKC_BGHistory[HKC_Server][HKC_Map][bracket], {
			[1] = dateStamp,
			[2] = victor,
			[3] = gained,
			[4] = elapsed,
			[5] = HKC_PremadePctA,
			[6] = HKC_PremadePctH,
			[7] = HKC_AFKA,
			[8] = HKC_AFKH,
			[9] = HKC_KBs,
			[10] = HKC_Dmg,
			[11] = HKC_Healing,
			[12] = HKC_PlayerName,
			[13] = places,
			[14] = HKC_AllianceScore,
			[15] = HKC_HordeScore,
		} );

		-- remove old records if over the max records limit
		if ( table.getn(HKC_BGHistory[HKC_Server][HKC_Map][bracket]) > HKC_CFG.maxRecords ) then
			local i;
			local n = table.getn(HKC_BGHistory[HKC_Server][HKC_Map][bracket]) - HKC_CFG.maxRecords;

			for i = 1, n do
				table.remove(HKC_BGHistory[HKC_Server][HKC_Map][bracket], 1);
			end
		end

		HKC_PremadePctA = 0;
		HKC_PremadePctH = 0;
		HKC_AFKA = 0;
		HKC_AFKH = 0;
		HKC_KBs = 0;
		HKC_Dmg = 0;
		HKC_Healing = 0;
		HKC_Bracket = nil;
		HKC_KBPlace = 0;
		HKC_DamagePlace = 0;
		HKC_HealingPlace = 0;
		HKC_AllianceScore = -1;
		HKC_HordeScore = -1;
		HKC_JoinedLate = 0;
	end
end

-- get battlefield stats at least once every 30 seconds
function HKC_Timer()
	if ( HKC_LastScore + 30 < time() ) then
		HKC_LastScore = time() + 5;
		RequestBattlefieldScoreData();
--debugmsg("requesting battlefield score data");
	end
end

function HKC_OnEvent(event)
	if ( event == "UPDATE_MOUSEOVER_UNIT" ) then
		if ( UnitExists("mouseover") and HKC_KillsToday[UnitName("mouseover")] ) then
			-- GameTooltipTextRight3:SetText("("..HKC_KillsToday[UnitName("target")].." kills today)");
			-- GameTooltipTextRight3:Show();
			if (GameTooltipTextLeft3:GetText() == "PvP") then
				GameTooltipTextLeft3:SetText("PvP ("..HKC_KillsToday[UnitName("mouseover")]..HKC_KILLSTODAYTEXT..")");
			end
		end

	elseif ( event == "PLAYER_TARGET_CHANGED" and HKC_CFG.onClickMsg ) then
		if (	UnitExists("target")
			and UnitIsPlayer("target")
			and UnitIsEnemy("target", "player")
			and UnitIsPVP("target")
			and not UnitIsTrivial("target")
		) then
			if (HKC_KillsToday[UnitName("target")]) then
				UIErrorsFrame:AddMessage(HKC_KillsToday[UnitName("target")]..HKC_KILLSTODAYTEXT, 1.0, 1.0, 1.0, 1.0, 1);
			else
				UIErrorsFrame:AddMessage(HKC_NEVERKILLED, 1.0, 1.0, 1.0, 1.0, 1);
			end
		end

	elseif (event == "CHAT_MSG_COMBAT_HONOR_GAIN") then
		local rank, ecp;

		_, _, lastKill, rank, ecp = string.find(arg1, HKC_HONORGAIN1);

		-- if not PK
		if ( not lastKill ) then

			-- bonus honor?
			_, _, ecp = string.find(arg1, HKC_HONORGAIN2);
			if ( ecp ) then

				ecp = tonumber(ecp);

--				HKC_PlayerData.estCP.HKCtoday = HKC_PlayerData.estCP.HKCtoday + ecp;
--				HKC_PlayerData.estCP.blizzToday = HKC_PlayerData.estCP.blizzToday + ecp;
				HKC_BonusHonor = HKC_BonusHonor + ecp;

				HKC_AddHistory( "|c00ffffff"..date().."|r: +"..ecp );

				-- update frame if visible
				if ( HKCFrame:IsVisible() ) then
					HKCFrame_Update();
				end

				return
			end

			-- DK?
			_, _, lastKill = string.find(arg1, HKC_DISHONOR);
			if ( HKC_CFG.chatMessagesHK and lastKill ) then
				DEFAULT_CHAT_FRAME:AddMessage(HKC_DISHONORWARNING..lastKill..")", 1, 0, 0);

			elseif ( HKC_CFG.chatMessagesHK ) then

				-- Unknown Message
				DEFAULT_CHAT_FRAME:AddMessage(HKC_ERRORMSG..arg1.."'");
			end

			return
		end

		-- add to lifetime kill history
		if ( not HKC_CFG.disableLifetime ) then
			if ( not HKC_KillsLifetime[lastKill]) then
				-- first ever kill of this person
				HKC_KillsLifetime[lastKill] = 1;
			else
				HKC_KillsLifetime[lastKill] = HKC_KillsLifetime[lastKill] + 1;
			end
		end

		-- add to today's kill history
		if ( not HKC_KillsToday[lastKill] ) then
			-- first kill today
			HKC_KillsToday[lastKill] = 0;
		end
		HKC_KillsToday[lastKill] = HKC_KillsToday[lastKill] + 1;

		if ( ecp ) then
			ecp = tonumber(ecp);

--			HKC_PlayerData.estCP.blizzToday = HKC_PlayerData.estCP.blizzToday + ecp;
--			HKC_PlayerData.estCP.HKCtoday = HKC_PlayerData.estCP.HKCtoday + ecp;
			HKC_KillHonor = HKC_KillHonor + ecp;

			-- update frame if visible
			if ( HKCFrame:IsVisible() ) then
				HKCFrame_Update();
			end
		end

		if ( HKC_CFG.chatMessagesHK ) then
			DEFAULT_CHAT_FRAME:AddMessage( string.format(HKC_KILLMSG, lastKill, HKC_KillsToday[lastKill], rank, ecp) );
		end

--	elseif (event == "PLAYER_ENTERING_WORLD") then


	elseif ( event == "ZONE_CHANGED_NEW_AREA" ) then
		HKC_ZoneInTime = {};
		HKC_GotArenaScores = false;

		local instance, instanceType = IsInInstance();
		if ( instance and instanceType == "pvp" ) then
			-- we're in a bg

			HKC_isArena = false;
			HKC_LastStats = 0;
			HKC_LastScore = 0;
			HKCTimerFrame:Show();

			-- get map name
			--[[
			local i, status, id, map;
			for i=1, MAX_BATTLEFIELD_QUEUES do
				status, map, id = GetBattlefieldStatus(i);
				debugmsg(map);
				debugmsg(status);
				debugmsg(id);
				if (id ~= 0) then
					break;
				end
			end
			]]
			map = GetZoneText();

			if ( HKC_InBattleground and map ~= HKC_Map ) then
				-- player switched battlegrounds
				HKC_BonusHistoryOnExit();
			end
			-- check for new day, reset if it is
			HKCResetToday();

			HKC_InBattleground = true;
			HKC_Map = map;
--			HKC_LastEstimated = HKC_PlayerData.estCP.HKCtoday;
			HKC_EnterTime = time();
			HKC_KillHonor = 0;
			HKC_BonusHonor = 0;

			-- bonus history on BG entrance; remove earliest entry if more than 30
			HKC_AddHistory( string.format(HKC_ENTERED, date(), map) );

		else
			-- we're not in a bg

			HKCTimerFrame:Hide();

			-- if we just left a bg
			if ( HKC_InBattleground ) then
				HKC_BonusHistoryOnExit();
			end

			HKC_InBattleground = false;

			-- check for new day, reset if it is
			HKCResetToday();
		end

	elseif ( event == "UPDATE_BATTLEFIELD_SCORE" ) then
		HKC_Winner = GetBattlefieldWinner();
		local instance, instanceType = IsInInstance();
		local now = time();
		HKC_LastScore = now;

		if ( instance and instanceType == "pvp" ) then
			HKC_isArena = false;
			-- get stats no more than once every 5 seconds in case some retarded addon spams RequestBattlefieldScoreData()
			if ( HKC_Winner or HKC_LastStats < (now - 5) ) then
				HKC_GetBGStats();
			end
		elseif ( instance and instanceType == "arena" ) then
			HKC_isArena = true;
			if ( HKC_Winner ) then
				HKC_GetArenaStats();
			end
		end
		-- debug
		--debugmsg("update battlefield score");

	elseif ( event == "VARIABLES_LOADED" ) then
		HKCLogin();
	end
end

function HKC_GetBGStats()
	local i;
	local a = 0;
	local h = 0;
	local serverPop = { [0] = {}, [1] = {} };
	local players = {};
	local numScores = GetNumBattlefieldScores();
	local name, faction, server, damage, healing, killingBlows, honorGained;
	local totalKBs = 0;

	HKC_AFKA = 0;
	HKC_AFKH = 0;

	if (numScores > 0) then
		HKC_LastStats = time();

		-- in case UI reloaded
		if ( not HKC_InBattleground ) then
			-- get map name
			local n, instanceId, map;
			for n=1, MAX_BATTLEFIELD_QUEUES do
				_, map, instanceId = GetBattlefieldStatus(n);
				if ( instanceId ~= 0 ) then
					break;
				end
			end

			HKC_InBattleground = true;
			HKC_Map = map;
--			HKC_LastEstimated = HKC_PlayerData.estCP.HKCtoday;
			HKC_EnterTime = time();
			HKCTimerFrame:Show();
		end

		for i = 1, numScores do

			name, killingBlows, _, _, honorGained, faction, _, _, _, _, damage, healing = GetBattlefieldScore(i);

			totalKBs = totalKBs + killingBlows;
			
			-- server populations
			if (string.find(name, "-", 1, true)) then
				server = string.sub(name, string.find(name, "-", 1, true) + 1);
			else
				server = HKC_Server;
			end

			if (not serverPop[faction][server]) then
				serverPop[faction][server] = 1;
			else
				serverPop[faction][server] = serverPop[faction][server] + 1;
			end

			-- keep track of when they zoned in (or when first seen at least)
			local now = time();
			if ( not HKC_ZoneInTime[name] ) then
				HKC_ZoneInTime[name] = now;
			end
			if ( faction == 0 ) then
				h = h + 1;

				-- 0 damage, 0 healing, and been in the zone for 5+ mins == afker
				if ( damage == 0 and healing == 0 and HKC_ZoneInTime[name] < (now - 300) ) then
					HKC_AFKH = HKC_AFKH + 1;
				end
			elseif ( faction == 1 ) then
				a = a + 1;
				if ( damage == 0 and healing == 0 and HKC_ZoneInTime[name] < (now - 300) ) then
					HKC_AFKA = HKC_AFKA + 1;
				end
			end

			if ( name == HKC_PlayerName ) then
				HKC_KBs = killingBlows;
				HKC_Dmg = damage;
				HKC_Healing = healing;
				HKC_ScoreboardBonusHonor = honorGained;
			end

			table.insert(players, {
				name = name,
				kbs = killingBlows,
				damage = damage,
				healing = healing,
			});
		end

		 -- 0 == waiting for first update battlefield score; 1 == not joined late; 2 == joined late
		if ( HKC_JoinedLate == 0 ) then
			if ( totalKBs > 0 ) then
				HKC_JoinedLate = 2;
			else
				HKC_JoinedLate = 1;
			end
--debugmsg("JoinedLate: "..HKC_JoinedLate);
		end

		-- KB place
		if ( HKC_KBs > 0 ) then
			table.sort(players, 
				function(a, b)
					return a.kbs > b.kbs;
				end
			);
			for i in ipairs(players) do
				if ( players[i].name == HKC_PlayerName ) then
					HKC_KBPlace = i;
					break;
				end
			end

			-- in case of tie, rank will match that of highest rank
			for i in ipairs(players) do
				if ( players[i].kbs == HKC_KBs ) then
					HKC_KBPlace = i;
					break;
				end
			end
		end

		-- damage place
		if ( HKC_Dmg > 0 ) then
			table.sort(players, 
				function(a, b)
					return a.damage > b.damage;
				end
			);
			for i in ipairs(players) do
				if ( players[i].name == HKC_PlayerName ) then
					HKC_DamagePlace = i;
					break;
				end
			end
		end

		-- healing place
		if ( HKC_Healing > 0 ) then
			table.sort(players, 
				function(a, b)
					return a.healing > b.healing;
				end
			);
			for i in ipairs(players) do
				if ( players[i].name == HKC_PlayerName ) then
					HKC_HealingPlace = i;
					break;
				end
			end
		end

		-- keep track of which side has the most people to determine which bracket range to use.
		-- this is a safety measure in case GetBattlefieldStatus() reports 0 0, or HKC_ALTERAC_VALLEY
		-- isn't localized or a new BG with 30+ people is implemened in the future (I'm assuming it
		-- would use the same level range as AV)
		if ( a > h ) then
			HKC_Participants = a;
		else
			HKC_Participants = h;
		end
		-- debug
--		debugmsg("Alliance: "..a.."    Horde: "..h);

		if ( not HKC_Bracket ) then
			local status, id, low, high;
			for i=1, MAX_BATTLEFIELD_QUEUES do
				status, _, id, low, high = GetBattlefieldStatus(i);
				if ( id ~= 0 and status == "active" ) then
					break;
				end
				low = 0;
				high = 0;
			end
			if ( low > 0 and high > 0 ) then
				-- to correct Blizzard's bug
				if ( low > HKC_MAX_LEVEL ) then
					low = HKC_MAX_LEVEL;
				end

				HKC_Bracket = low.."-"..high;
			end
--debugmsg(HKC_Bracket);
		end

		local pct;

		-- horde
		HKC_PremadePctH = 0;
		for faction, server in pairs(serverPop[0]) do

			-- if more than 8 people,
			-- and this server comprises of more than or equal to 20% of the faction,
			-- and more than 2 people from this server
			if ( h > 8 and server >= (h * .2) and server > 2 ) then

				-- percent of the people in the faction from this server
				pct = 100 / h * server;
				HKC_PremadePctH = HKC_PremadePctH + pct - ((100 - pct) * .1);	-- reduce the impact of smaller premades on the total
			end
		end
		HKC_PremadePctH = HKC_PremadePctH - HKC_PremadePctH % 1;	-- convert to int

		-- alliance
		HKC_PremadePctA = 0;
		for faction, server in pairs(serverPop[1]) do

			-- if more than 8 people,
			-- and this server comprises of more than or equal to 20% of the faction,
			-- and more than 2 people from this server
			if ( a > 8 and server >= (a * .2) and server > 2 ) then

				-- percent of the people in the faction from this server
				pct = 100 / a * server;
				HKC_PremadePctA = HKC_PremadePctA + pct - ((100 - pct) * .1);	-- reduce the impact of smaller premades on the total
			end
		end
		HKC_PremadePctA = HKC_PremadePctA - HKC_PremadePctA % 1;	-- convert to int


		-- get resources, reinforcements, flag captures, victory points
		for i = 1, GetNumWorldStateUI() do
			_, _, name, server  = GetWorldStateUIInfo(i);
			if ( server == "Interface\\TargetingFrame\\UI-PVP-Alliance" ) then
				_, _, damage = string.find(name, "(%d+)/%d+");
				if ( not damage ) then
					_, _, damage = string.find(name, "(%d+)");		-- av
				end
				if ( damage ) then
					HKC_AllianceScore = tonumber(damage);
				end
			end
			if ( server == "Interface\\TargetingFrame\\UI-PVP-Horde" ) then
				_, _, damage = string.find(name, "(%d+)/%d+");
				if ( not damage ) then
					_, _, damage = string.find(name, "(%d+)");		-- av
				end
				if ( damage ) then
					HKC_HordeScore = tonumber(damage);
				end
			end
		end

	end  -- if ( numScores > 0 )
end

function HKCLookup(target)
	local char;

	-- force to lowercase then upper the 1st letter
	target = string.lower(target);
	char = string.sub(target, 1, 1);
	target = string.sub(target, 2);
	target = string.upper(char)..target;
	
	if (HKC_KillsToday[target]) then
		DEFAULT_CHAT_FRAME:AddMessage(target.." "..HKC_KILLSTODAYTEXT..":"..HKC_KillsToday[target], 1, 1, 0);
	else
		DEFAULT_CHAT_FRAME:AddMessage(target.." "..HKC_NEVERKILLED, 1, 1, 0);
	end

	if ( HKC_KillsLifetime[target] ) then
		DEFAULT_CHAT_FRAME:AddMessage( string.format(HKC_LIFETIMEKILLSMSG, target, HKC_KillsLifetime[target]) , 1, 1, 0);
	else
		DEFAULT_CHAT_FRAME:AddMessage( string.format(HKC_LIFETIMEKILLSMSG, target, 0) , 1, 1, 0);
	end
end

function HKCCmdLine(param)
	local arg1;
	local arg2;
	_, _, arg1, arg2 = string.find(param, "(%a+)%s+(.+)");
	if (not arg1) then
		arg1 = param;
	end

	if (arg1 == "lookup") then
		if (not arg2 and UnitExists("target") and UnitIsPlayer("target") and UnitIsEnemy("target", "player") ) then
			arg2 = UnitName("target");
		end
		if (arg2) then
			HKCLookup(arg2);
		end

	elseif (arg1 == "honor") then
--		DEFAULT_CHAT_FRAME:AddMessage( HKC_HKCTODAYEST.." |c00ffff00"..HKC_PlayerData.estCP.blizzToday.."|r" );
--		DEFAULT_CHAT_FRAME:AddMessage( HKC_BEFOREDIMINISHING.." |c00ffff00"..math.floor(HKC_PlayerData.estCP.HKCtoday).."|r" );
		-- if in a BG, show honor gained so far
		if (HKC_InBattleground) then
--			DEFAULT_CHAT_FRAME:AddMessage( HKC_FROMBG.." |c00ffff00"..math.floor(HKC_PlayerData.estCP.HKCtoday - HKC_LastEstimated).."|r" );
			DEFAULT_CHAT_FRAME:AddMessage( HKC_KILLHONOR.." |c00ffff00"..math.floor(HKC_KillHonor).."|r" );
			DEFAULT_CHAT_FRAME:AddMessage( HKC_BONUSHONOR.." |c00ffff00"..math.floor(HKC_BonusHonor).."|r" );
			DEFAULT_CHAT_FRAME:AddMessage( HKC_FROMBG.." |c00ffff00"..math.floor(HKC_BonusHonor + HKC_KillHonor).."|r" );
		end

	elseif (arg1 == "show") then
		HKCOpenFrame(true);

	elseif (arg1 == "forcereset") then
		if (arg2 == "today") then
			HKCResetToday(true);
		else
			DEFAULT_CHAT_FRAME:AddMessage(HKC_FORCERESET_SYNTAX, 1, 1, 0);
		end
	else
		local s;
		for _, s in ipairs(HKC_HELP) do
			DEFAULT_CHAT_FRAME:AddMessage(s);
		end
	end
end

-- if text is true, then return values as text display strings, i.e. "(#1)" instead of 1
function HKC_SplitItem13(i, text)
	local kbs, damage, healing, joinedLate;

	kbs = i % 100;
	damage = ((i % 10000) - kbs) / 100;
	healing = ((i % 1000000) - i % 10000) / 10000;

	joinedLate = ((i % 10000000) - i % 1000000) / 1000000;
	if ( joinedLate == 1 ) then
		joinedLate = true;
	else
		joinedLate = false;
	end

	if ( text ) then
		if ( kbs > 0 ) then
			kbs = "(#"..kbs..")";
		else
			kbs = "";
		end
		if ( damage > 0 ) then
			damage = "(#"..damage..")";
		else
			damage = "";
		end
		if ( healing > 0 ) then
			healing = "(#"..healing..")";
		else
			healing = "";
		end
		if ( joinedLate ) then
			joinedLate = HKC_JOINED_LATE;
		else
			joinedLate = "";
		end
	end

	return kbs, damage, healing, joinedLate;
end

function HKC_ShowRecord(record)

	local text = "|c00ffffff"..date("%c", record[1]).."|r: ";
	local kbRank, damageRank, healingRank, joinedLate = "", "", "", "";

	if ( record[13] ) then
		kbRank, damageRank, healingRank, joinedLate = HKC_SplitItem13(record[13], true);
	end

	if ( record[2] == 0 ) then
		text = text..HKC_HORDE..HKC_WON;
	elseif ( record[2] == 1 ) then
		text = text..HKC_ALLIANCE..HKC_WON;
	else
		text = text..HKC_LEFT_EARLY;
	end
	table.insert( HKC_FrameText, string.format(text, date("%c", record[1])) );

	text = HKC_ELAPSED..": |c0000ffff%i|rm; %s  "..HONOR.." "..HKC_GAINED..": |c0000ffff%i|r";
	table.insert( HKC_FrameText, string.format(text, record[4], joinedLate, record[3] ) );

	if ( record[14] and record[14] >= 0 ) then
		text = HKC_ALLIANCE.." "..HKC_SCORE..": |c00ffffff"..record[14].."|r; ";
		text = text..HKC_HORDE.." "..HKC_SCORE..": |c00ffffff"..record[15].."|r ";
		table.insert( HKC_FrameText, text );
	end

	if ( record[5] > 0 ) then
		table.insert( HKC_FrameText, string.format(HKC_ALLIANCE..HKC_PREMADE_SCORE.."|c00ffffff%i|r", record[5]) );
	end
	if ( record[6] > 0 ) then
		table.insert( HKC_FrameText, string.format(HKC_HORDE..HKC_PREMADE_SCORE.."|c00ffffff%i|r", record[6]) );
	end
	if ( record[7] > 0 ) then
		table.insert( HKC_FrameText, string.format(HKC_ALLIANCE..HKC_AFKERS.."|c00ffffff%i|r", record[7]) );
	end
	if ( record[8] > 0 ) then
		table.insert( HKC_FrameText, string.format(HKC_HORDE..HKC_AFKERS.."|c00ffffff%i|r", record[8]) );
	end

	text = HKC_KBS..": |c00ffff00%i|r; %s";
	table.insert(HKC_FrameText, string.format(text, record[9], kbRank) );
	text = DAMAGE..": |c00ffff00%i|r; %s  "..HKC_HEALING..": |c00ffff00%i|r %s";
	table.insert(HKC_FrameText, string.format(text, record[10], damageRank, record[11], healingRank) );

	if ( record[12] ~= HKC_PlayerName ) then
		table.insert(HKC_FrameText, string.format(CHARACTER..": |c0000ff00%s|r", record[12]));
	end
	table.insert(HKC_FrameText, "");
end

function HKC_GetWinPercentiles(aWins, hWins, incompletes)
	if ( aWins + hWins + incompletes == 0 ) then
		return 0, 0, 0;
	end
	local total = aWins + hWins + incompletes;

	-- ghetto rounding
	local aPct = 100 / total * aWins;
	if ( (aPct % 1) >= .5 ) then
		aPct = math.ceil(aPct);
	else
		aPct = math.floor(aPct);
	end
	local hPct = 100 / total * hWins;
	if ( (hPct % 1) >= .5 ) then
		hPct = math.ceil(hPct);
	else
		hPct = math.floor(hPct);
	end
	local incompletePct = 100 / total * incompletes;
	if ( (incompletePct % 1) >= .5 ) then
		incompletePct = math.ceil(incompletePct);
	else
		incompletePct = math.floor(incompletePct);
	end

	return aPct, hPct, incompletePct;
end

function HKCFrameBGStats(bg, bracket)

	HKC_FrameText = {};

--	table.insert( HKC_FrameText, "" );
	table.insert( HKC_FrameText, string.format("|c00ffffff%s|r [|c00ffffff%s|r]", bg, bracket) );
	table.insert( HKC_FrameText, "" );


	-- lifetime win/losses (independant of record data)

	local i, horde, alliance, left = 0, 0, 0, 0;
	local data, aPct, hPct, iPct, aPct2, hPct2;

	-- get total wins/losses
	for _, data in pairs(HKC_TotalWinLoss[HKC_Server][bg][bracket]) do
		horde = horde + data[1];
		alliance = alliance + data[2];
		left = left + data[3];
	end

	-- "Horde Wins: n (x%/y%)"
	local sH = string.format(VICTORY_TEXT_ARENA_WINS, HKC_HORDE)..": |c0000ffff%i|r (|c00ff1919%i%%|r/|c00ff1919%i%%|r)";
	local sA = string.format(VICTORY_TEXT_ARENA_WINS, HKC_ALLIANCE)..": |c0000ffff%i|r (|c0000adef%i%%|r/|c0000adef%i%%|r)";

	-- this player only's wins/losses
	if ( HKC_TotalWinLoss[HKC_Server][bg][bracket][HKC_PlayerName] ) then
		data = HKC_TotalWinLoss[HKC_Server][bg][bracket][HKC_PlayerName];

		aPct, hPct, iPct = HKC_GetWinPercentiles(data[2], data[1], data[3]);
		aPct2, hPct2 = HKC_GetWinPercentiles(data[2], data[1], 0);

		table.insert( HKC_FrameText, "|c0000ff00"..HKC_PlayerName.."|r's "..HKC_MATCHES );
		table.insert( HKC_FrameText, string.format(sA, data[2], aPct, aPct2) );
		table.insert( HKC_FrameText, string.format(sH, data[1], hPct, hPct2) );
		table.insert( HKC_FrameText, "|c00999999"..HKC_LEFT_EARLY.."|r: |c0000ffff"..data[3].."|r (|c00999999"..iPct.."%|r)" );
		table.insert( HKC_FrameText, "" );
	end

	-- all wins/losses
	aPct, hPct, iPct = HKC_GetWinPercentiles(alliance, horde, left);
	aPct2, hPct2 = HKC_GetWinPercentiles(alliance, horde, 0);

	table.insert( HKC_FrameText, ALL.." "..HKC_MATCHES );
	table.insert( HKC_FrameText, string.format(sA, alliance, aPct, aPct2) );
	table.insert( HKC_FrameText, string.format(sH, horde, hPct, hPct2) );
	table.insert( HKC_FrameText, "|c00999999"..HKC_LEFT_EARLY.."|r: |c0000ffff"..left.."|r (|c00999999"..iPct.."%|r)" );
	table.insert( HKC_FrameText, "" );


	-- display record data

	local records, cap;
	local count = 0;
	records = table.getn(HKC_BGHistory[HKC_Server][bg][bracket]);

	if ( records > 50 ) then
		cap = 50;
	else
		cap = records;
	end
	table.insert( HKC_FrameText, string.format(HKC_LAST_50, records, cap) );
	table.insert( HKC_FrameText, "" );

	for i = records, 1, -1 do
		HKC_ShowRecord(HKC_BGHistory[HKC_Server][bg][bracket][i]);
		count = count + 1;
		if ( count >= 50 ) then
			break;
		end
	end

	-- pre version 3 data
	if ( (	not HKC_TotalWinLoss[HKC_Server]["Old Data"] or
		not HKC_TotalWinLoss[HKC_Server]["Old Data"][HKC_PlayerName] or
		not HKC_TotalWinLoss[HKC_Server]["Old Data"][HKC_PlayerName][bg] ) and
		records > 0
	) then
		return
	end

	local wins, losses;

	wins = HKC_TotalWinLoss[HKC_Server]["Old Data"][HKC_PlayerName][bg].wins;
	losses = HKC_TotalWinLoss[HKC_Server]["Old Data"][HKC_PlayerName][bg].losses;

	table.insert( HKC_FrameText, "|c0000ff00"..HKC_PlayerName.."|r"..HKC_OLD_DATA );
	table.insert( HKC_FrameText, "|c00ffffff"..bg.."|r: |c0033ffcc"..wins.."|r/|c0033cccc"..losses.."|r" );

end

function HKCFrameHistory()
	local v;

	HKC_FrameText = {};
	for _, v in ipairs(HKC_BonusHistory) do
		table.insert(HKC_FrameText, v);
	end
end

function HKCFrameTop()
	local name, kills, count, lastkills, rank, victim, i;
	local top10 = {};
	local targetarr;
	local output = "";

	HKC_FrameText = {};

	-- people killed today
	i = 0;
	for _ in pairs(HKC_KillsToday) do
		i = i + 1;
	end
	table.insert(HKC_FrameText, string.format(HKC_PEOPLEKILLEDTODAY, i) );

	-- people killed lifetime
	i = 0;
	for _ in pairs(HKC_KillsLifetime) do
		i = i + 1;
	end
	table.insert(HKC_FrameText, string.format(HKC_PEOPLEKILLEDLIFETIME, i) );

	table.insert(HKC_FrameText, "");

	for i = 1, 2 do
		if ( i == 1 ) then
			table.insert(HKC_FrameText, "|c00ffffff"..HKC_TOP10TODAY.."|r");
			targetarr = HKC_KillsToday;
		else
			table.insert(HKC_FrameText, "|c00ffffff"..HKC_TOP10TOTAL.."|r");
			targetarr = HKC_KillsLifetime;
			top10 = {};
		end
	
		for name, kills in pairs(targetarr) do
			table.insert(top10, {name = name, kills = kills});
		end

		table.sort(top10, 
			function(a, b)
				return a.kills > b.kills;
			end
		);

		count = 0;
		lastkills = 0;

		-- iterate every person killed
		for rank, victim in ipairs(top10) do

			count = count + 1;

			-- lastkills is needed in case of a tie
			if ( lastkills ~= victim.kills ) then
				-- no tie

				if ( lastkills > 0  ) then
					-- output player(s) and kill num
					table.insert( HKC_FrameText, output.." ("..lastkills..")" );
					output = "";
				end
				lastkills = victim.kills;

				-- reached 10+ players
				-- this doesn't get seen in the case of a tie
				if ( count > 10 ) then
					break;
				end
			else
				-- tie

				if ( #output > 35 ) then
					table.insert( HKC_FrameText, output..", " );
					output = "";
				else
					output = output..", "
				end
			end

			output = output..victim.name;

			-- if this is the last entry, we need to output
			if ( rank == #top10 ) then
				table.insert( HKC_FrameText, output.." ("..lastkills..")" );
			end
		end

		table.insert( HKC_FrameText, "" );
	end
end

-- main drop down

function HKCFrameDropDown_OnShow()
	UIDropDownMenu_Initialize( this, HKCFrameDropDown_Initialize );
	UIDropDownMenu_SetWidth( 100, HKCFrameDropDown );
	UIDropDownMenu_SetSelectedID( HKCFrameDropDown, HKC_Selected );
	HKCFrameDropDown_OnClick();
end

function HKCFrameDropDown_Initialize()
	local k, v, info;

	for k, v in ipairs(HKC_DROPDOWN_LABELS) do
		UIDropDownMenu_AddButton( {
			text = v,
			value = k,
			func = HKCFrameDropDown_OnClick,
		} );
	end
end

function HKCFrameDropDown_OnClick()
	local value, k;

	-- hide config widgets
	for k in ipairs(HKC_CONFIG_OPTIONS) do
		getglobal("HKCOption"..k.."CheckButton"):Hide();
	end

	HKCMaxRecordsEditBox:Hide();
	HKCMaxArenaRecordsEditBox:Hide();
	HKCFrameDeleteLifetimeOptionButton:Hide();

	-- hide BG history drop downs and table button
	HKCBGHistoryDropDown:Hide();
	HKCBGHistoryBracketDropDown:Hide();
	HKCFrameTableButton:Hide();
	HKCArenaHistoryDropDown:Hide();

	UIDropDownMenu_SetSelectedID( HKCFrameDropDown, this.value );
	value = UIDropDownMenu_GetSelectedID( HKCFrameDropDown );

	if ( value ) then
		HKC_Selected = value;
	end

	if ( HKC_Selected == 2 ) then

		-- Bonus History

		HKCFrameHistory();
		HKCFrame_Update();	-- needed to get the scroll bar slider to end up at the bottom every time
		if ( #HKC_FrameText == HKC_MAX_HISTORY ) then
			HKCScrollFrameScrollBar:SetValue(936);
		end

	elseif ( HKC_Selected == 3 ) then

		-- Kills

		HKCFrameTop();

	elseif ( HKC_Selected == 4 ) then

		-- Arena History

		HKC_FrameText = {};
		HKCArenaHistoryDropDown:Show();

		UIDropDownMenu_SetWidth( 50, HKCArenaHistoryDropDown );
		UIDropDownMenu_Initialize( HKCArenaHistoryDropDown, HKCArenaHistoryDropDown_Initialize );
		if ( HKC_LastArenaSize ) then
			UIDropDownMenu_SetSelectedValue( HKCArenaHistoryDropDown, HKC_LastArenaSize );
			HKCFrameArenaHistory(HKC_LastArenaSize);
		end

	elseif ( HKC_Selected == 5 ) then

		-- Config

		HKC_FrameText = {};

		for k in ipairs(HKC_CONFIG_OPTIONS) do
			getglobal("HKCOption"..k.."CheckButton"):Show();
		end
		HKCMaxRecordsEditBox:Show();
		HKCMaxArenaRecordsEditBox:Show();
		HKCFrameDeleteLifetimeOptionButton:Show();

	else

		-- BG Statistics

		HKCBGHistoryDropDown:Show();
		HKCBGHistoryBracketDropDown:Show();
		HKCFrameTableButton:Show();

		HKCScrollFrameScrollBar:SetValue(0);

		local bg;

		-- set BG drop down labels
		HKC_BGHISTORY_LABELS = {};
		for k in pairs(HKC_BGHistory[HKC_Server]) do
			table.insert(HKC_BGHISTORY_LABELS, k);
		end

		-- select BG
		if ( HKC_BGHISTORY_LABELS[HKC_BGHistory_Selected] ) then
			bg = HKC_BGHISTORY_LABELS[HKC_BGHistory_Selected];
		elseif ( HKC_BGHISTORY_LABELS[1] ) then
			bg = HKC_BGHISTORY_LABELS[1];
			HKC_BGHistory_Selected = 1;
		end

		UIDropDownMenu_SetWidth( 120, HKCBGHistoryDropDown );
		UIDropDownMenu_SetWidth( 75, HKCBGHistoryBracketDropDown );

		if ( bg ) then
			HKC_SetBracketLabels(bg);

			UIDropDownMenu_Initialize( HKCBGHistoryDropDown, HKCBGHistoryDropDown_Initialize );
			UIDropDownMenu_SetSelectedID( HKCBGHistoryDropDown, HKC_BGHistory_Selected );

			UIDropDownMenu_Initialize( HKCBGHistoryBracketDropDown, HKCBGHistoryBracketDropDown_Initialize );
			UIDropDownMenu_SetSelectedID( HKCBGHistoryBracketDropDown, HKC_BGHistoryBracket_Selected );

			HKC_ShowHistory();
		end

	end
	HKCFrame_Update();
end

function HKC_ShowHistory()
	local k, bg, bracket;
	bg = HKC_BGHISTORY_LABELS[HKC_BGHistory_Selected];
	if ( HKC_BGHistory[HKC_Server][bg] ) then
		HKC_SetBracketLabels(bg);
		HKCBGHistoryBracketDropDown_Initialize();

		-- use selected bracket
		if ( HKC_BGHISTORY_BRACKET_LABELS and HKC_BGHISTORY_BRACKET_LABELS[HKC_BGHistoryBracket_Selected] ) then
			bracket = HKC_BGHISTORY_BRACKET_LABELS[HKC_BGHistoryBracket_Selected];
			UIDropDownMenu_SetSelectedID( HKCBGHistoryBracketDropDown, HKC_BGHistoryBracket_Selected );

		elseif ( HKC_BGHISTORY_BRACKET_LABELS[1] ) then
			bracket = HKC_BGHISTORY_BRACKET_LABELS[1];
			UIDropDownMenu_SetSelectedID( HKCBGHistoryBracketDropDown, 1 );
			HKC_BGHistoryBracket_Selected = 1;
		else
			-- if no selected bracket or other error, just pick one
			for k in pairs(HKC_BGHistory[HKC_Server][bg]) do
				bracket = k;
				break;
			end
		end

		-- drop downs are buggy, and display incorrect text
		UIDropDownMenu_SetText(HKC_BGHISTORY_BRACKET_LABELS[HKC_BGHistoryBracket_Selected], HKCBGHistoryBracketDropDown);

		if ( bracket ) then
			HKCFrameBGStats(bg, bracket);
		end
	end
end

-- BG history drop down

function HKCBGHistoryDropDown_Initialize()
	local k, v, info;

	for k, v in ipairs(HKC_BGHISTORY_LABELS) do
		UIDropDownMenu_AddButton( {
			text = v,
			value = k,
			func = HKCBGHistoryDropDown_OnClick,
		} );
	end

end

function HKCBGHistoryDropDown_OnClick()

	UIDropDownMenu_SetSelectedID( HKCBGHistoryDropDown, this.value );
	value = UIDropDownMenu_GetSelectedID( HKCBGHistoryDropDown );

	if ( value ) then
		HKC_BGHistory_Selected = value;
	end

	HKC_ShowHistory();
	HKCFrame_Update();
end

-- BG history bracket drop down

function HKCBGHistoryBracketDropDown_Initialize()
	local k, v, bg;

	for k, v in ipairs(HKC_BGHISTORY_BRACKET_LABELS) do
		UIDropDownMenu_AddButton( {
			text = v,
			value = k,
			func = HKCBGHistoryBracketDropDown_OnClick,
		} );
	end

end

function HKCBGHistoryBracketDropDown_OnClick()

	UIDropDownMenu_SetSelectedID( HKCBGHistoryBracketDropDown, this.value );
	value = UIDropDownMenu_GetSelectedID( HKCBGHistoryBracketDropDown );

	if ( value ) then
		HKC_BGHistoryBracket_Selected = value;
	else
		value = 1;
	end

	HKC_ShowHistory();
	HKCFrame_Update();
end

function HKCFrame_Update()
	local offset = FauxScrollFrame_GetOffset(HKCScrollFrame);
	local items = #HKC_FrameText;
	local i;


--	HKCFrameBlizHonorPoints:SetText( math.floor(HKC_PlayerData.estCP.blizzToday) );
--	HKCFrameEstHonorPoints:SetText( math.floor(HKC_PlayerData.estCP.HKCtoday) );

	-- if in a BG, show honor gained so far
	if (HKC_InBattleground) then
--		local gained = math.floor(HKC_PlayerData.estCP.HKCtoday - HKC_LastEstimated);
		local gained = math.floor(HKC_BonusHonor + HKC_KillHonor);

		HKCFrameKillHonorLabel:Show();
		HKCFrameKillHonorPoints:Show();
		HKCFrameBonusHonorLabel:Show();
		HKCFrameBonusHonorPoints:Show();
		HKCFrameHonorBGLabel:Show();
		HKCFrameBGHonorPoints:Show();

		HKCFrameKillHonorPoints:SetText(HKC_KillHonor);
		HKCFrameBonusHonorPoints:SetText(HKC_BonusHonor);
		HKCFrameBGHonorPoints:SetText(gained);
	else
		HKCFrameKillHonorLabel:Hide();
		HKCFrameKillHonorPoints:Hide();
		HKCFrameBonusHonorLabel:Hide();
		HKCFrameBonusHonorPoints:Hide();
		HKCFrameHonorBGLabel:Hide();
		HKCFrameBGHonorPoints:Hide();
	end

	for i = 1, 22 do
		if ( HKC_FrameText[i + offset] ) then
			getglobal("HKCFrameBody"..i.."Text"):SetText( HKC_FrameText[i + offset] );
		else
			getglobal("HKCFrameBody"..i.."Text"):SetText("");
		end

	end

	if ( items <= 22 ) then
		HKCScrollFrame:Hide();
	else
		HKCScrollFrame:Show();
	end

	FauxScrollFrame_Update(HKCScrollFrame, items, 22, 12 );
end

function HKC_SetBracketLabels(bg)
	-- set bracket drop down labels
	HKC_BGHISTORY_BRACKET_LABELS = {};
	for k in pairs(HKC_BGHistory[HKC_Server][bg]) do
		table.insert(HKC_BGHISTORY_BRACKET_LABELS, k);
	end
end

function HKCFrame_OnShow()
	if ( UnitFactionGroup("player") == "Horde" ) then
		HKCFramePortrait:SetTexture("Interface\\PVPRankBadges\\PvPRankHorde");
	else
		HKCFramePortrait:SetTexture("Interface\\PVPRankBadges\\PvPRankAlliance");
	end
	HKCShowButton:Hide();

	UIDropDownMenu_Initialize( HKCFrameDropDown, HKCFrameDropDown_Initialize );
	UIDropDownMenu_SetWidth( 100, HKCFrameDropDown );
	UIDropDownMenu_SetSelectedID( HKCFrameDropDown, HKC_Selected );
	HKCFrameDropDown_OnClick();
end

function HKCCloseFrame()
	HKCFrame:Hide();
	PlaySound("igCharacterInfoClose");
end

function HKCOpenFrame(force)
	if ( HKC_CFG.doNotOpen and not force ) then
		return
	end
	if ( PVPTeamDetails:IsVisible() ) then
		PVPTeamDetails:Hide();
	end
	HKCFrame:Show();
	PlaySound("igCharacterInfoOpen");
end

function HKCTableFrame_DrawTable(db, offset)
	if ( not offset ) then
		offset = 0;
	end

	local record, i;

	for i = 1, 20 do
		record = db[i + offset];
		if ( record ) then
			getglobal("HKCTableFrameListItem"..i.."Time"):SetText(date("%c", record[1]));

			if ( record[2] == 0 ) then
				getglobal("HKCTableFrameListItem"..i.."Victor"):SetText(HKC_HORDE);
			elseif ( record[2] == 1 ) then
				getglobal("HKCTableFrameListItem"..i.."Victor"):SetText(HKC_ALLIANCE);
			else
				getglobal("HKCTableFrameListItem"..i.."Victor"):SetText("|c00999999-|r");
			end

			local kbRank, damageRank, healingRank, joinedLate = "", "", "", "";
			if ( record[13] ) then
				kbRank, damageRank, healingRank, joinedLate = HKC_SplitItem13(record[13], true);
			end

			if ( joinedLate == "" ) then
				getglobal("HKCTableFrameListItem"..i.."Duration"):SetText("|c0000ffff"..record[4].."|r m");
			else
				getglobal("HKCTableFrameListItem"..i.."Duration"):SetText("|c0000ffff"..record[4].."|r m*");
			end
			getglobal("HKCTableFrameListItem"..i.."Gained"):SetText("|c0000ffff"..record[3].."|r");

			if ( record[5] > 0 ) then
				getglobal("HKCTableFrameListItem"..i.."PremadeA"):SetText(record[5]);
			else
				getglobal("HKCTableFrameListItem"..i.."PremadeA"):SetText("|c00999999-|r");
			end
			if ( record[6] > 0 ) then
				getglobal("HKCTableFrameListItem"..i.."PremadeH"):SetText(record[6]);
			else
				getglobal("HKCTableFrameListItem"..i.."PremadeH"):SetText("|c00999999-|r");
			end

			if ( record[4] <= 5 and record[7] == 0 and record[8] == 0 ) then
				-- was not in BG long enough to determine AFKers
				getglobal("HKCTableFrameListItem"..i.."AFKA"):SetText("|c00999999-|r");
				getglobal("HKCTableFrameListItem"..i.."AFKH"):SetText("|c00999999-|r");
			else
				if ( record[7] > 0 ) then
					getglobal("HKCTableFrameListItem"..i.."AFKA"):SetText("|c00ffffff"..record[7].."|r");
				else
					getglobal("HKCTableFrameListItem"..i.."AFKA"):SetText("|c00999999"..record[7].."|r");
				end
				if ( record[8] > 0 ) then
					getglobal("HKCTableFrameListItem"..i.."AFKH"):SetText("|c00ffffff"..record[8].."|r");
				else
					getglobal("HKCTableFrameListItem"..i.."AFKH"):SetText("|c00999999"..record[8].."|r");
				end
			end

			if ( record[14] ) then
				if ( record[14] < 0 ) then
					getglobal("HKCTableFrameListItem"..i.."AScore"):SetText("?");
				else
					getglobal("HKCTableFrameListItem"..i.."AScore"):SetText(record[14]);
				end
				if ( record[15] < 0 ) then
					getglobal("HKCTableFrameListItem"..i.."HScore"):SetText("?");
				else
					getglobal("HKCTableFrameListItem"..i.."HScore"):SetText(record[15]);
				end
			else
				getglobal("HKCTableFrameListItem"..i.."AScore"):SetText("");
				getglobal("HKCTableFrameListItem"..i.."HScore"):SetText("");
			end

			getglobal("HKCTableFrameListItem"..i.."KBs"):SetText("|c00ffff00"..record[9].."|r "..kbRank);
			getglobal("HKCTableFrameListItem"..i.."Damage"):SetText("|c00ffff00"..record[10].."|r "..damageRank);
			getglobal("HKCTableFrameListItem"..i.."Healing"):SetText("|c00ffff00"..record[11].."|r "..healingRank);
			getglobal("HKCTableFrameListItem"..i.."Character"):SetText("|c0000ff00"..record[12].."|r");
		else
			getglobal("HKCTableFrameListItem"..i.."Time"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."Victor"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."Duration"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."Gained"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."AScore"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."HScore"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."PremadeA"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."PremadeH"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."AFKA"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."AFKH"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."KBs"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."Damage"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."Healing"):SetText("");
			getglobal("HKCTableFrameListItem"..i.."Character"):SetText("");
		end
	end
end

function HKCTableFrame_GetAverages()
	local record;
	local records, afkRecords, hordeWins, allianceWins, duration, gained, premadeA, premadeH, afkA, afkH, kbs, damage, healing = 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0;

	for _, record in ipairs(HKC_DB) do
		if ( record[2] == 0 ) then
			hordeWins = hordeWins + 1;
		elseif ( record[2] == 1 ) then
			allianceWins = allianceWins + 1;
		end

		duration = duration + record[4];
		gained = gained + record[3];
		premadeA = premadeA + record[5];
		premadeH = premadeH + record[6];
		if ( record[7] > 0 or record[8] > 0 or record[4] > 5 ) then
			afkA = afkA + record[7];
			afkH = afkH + record[8];
			afkRecords = afkRecords + 1;
		end
		kbs = kbs + record[9];
		damage = damage + record[10];
		healing = healing + record[11];

		records = records + 1;
	end

	if ( records == 0 ) then
		HKCTableFrameAverages:Hide();
		HKCTableFrameHonorPerHour:Hide();
		HKCTableFrameWinPercent:Hide();
		return
	else
		HKCTableFrameAverages:Show();
		HKCTableFrameHonorPerHour:Show();
		HKCTableFrameWinPercent:Show();
	end

	-- average and trim decimal length
	duration = duration / records;
	duration = duration - (duration % .1);
	gained = gained / records;
	gained = gained - (gained % 1 );
	premadeA = premadeA / records;
	premadeA = premadeA - (premadeA % .1);
	premadeH = premadeH / records;
	premadeH = premadeH - (premadeH % .1);
	if ( afkRecords > 0 ) then
		afkA = afkA / afkRecords;
		afkA = afkA - (afkA % .1);
		afkH = afkH / afkRecords;
		afkH = afkH - (afkH % .1);
	end
	kbs = kbs / records;
	kbs = kbs - (kbs % .1);
	damage = damage / records;
	damage = damage - (damage % 1);
	healing = healing / records;
	healing = healing - (healing % 1);

	local incompleteGames = records - allianceWins - hordeWins;
	HKCTableFrameAveragesVictor:SetText("|c0000adef"..allianceWins.."|r/|c00ff1919"..hordeWins.."|r/|c00999999"..incompleteGames.."|r");

	local alliancePct, hordePct, incompletePct = HKC_GetWinPercentiles(allianceWins, hordeWins, incompleteGames);
	HKCTableFrameWinPercent:SetText("|c0000adef"..alliancePct.."%|r/|c00ff1919"..hordePct.."%|r/|c00999999"..incompletePct.."%|r");

	HKCTableFrameAveragesDuration:SetText("|c0000ffff"..duration.."|r m");
	HKCTableFrameAveragesGained:SetText("|c0000ffff"..gained.."|r");
	local x = gained / (duration / 60);
	x = x - (x % 1);
	HKCTableFrameHonorPerHour:SetText("|c0000ffff"..x.."|r "..HONOR.."/"..HOURS_ABBR);

	HKCTableFrameAveragesPremadeA:SetText(premadeA);
	HKCTableFrameAveragesPremadeH:SetText(premadeH);

	if ( afkRecords > 0 ) then
		HKCTableFrameAveragesAFKA:SetText(afkA);
		HKCTableFrameAveragesAFKH:SetText(afkH);
	else
		HKCTableFrameAveragesAFKA:SetText("|c00999999-|r");
		HKCTableFrameAveragesAFKH:SetText("|c00999999-|r");
	end

	HKCTableFrameAveragesKBs:SetText("|c00ffff00"..kbs.."|r");
	HKCTableFrameAveragesDamage:SetText("|c00ffff00"..damage.."|r");
	HKCTableFrameAveragesHealing:SetText("|c00ffff00"..healing.."|r");
end

function HKC_CheckFilters(record)
	local min, max;

	if ( HKCFilterFrameIncompletesCheckButton:GetChecked() and record[2] == 2 ) then
		return false;
	end
	if ( HKCFilterFrameAllianceWinsCheckButton:GetChecked() and record[2] == 1 ) then
		return false;
	end
	if ( HKCFilterFrameHordeWinsCheckButton:GetChecked() and record[2] == 0 ) then
		return false;
	end
	if ( HKCFilterFrameOtherCharactersCheckButton:GetChecked() and record[12] ~= HKC_PlayerName ) then
		return false;
	end
	if ( HKCFilterFrameDurationRangeCheckButton:GetChecked() ) then
		min = HKCFilterFrameMinDurationEditBox:GetNumber();
		max = HKCFilterFrameMaxDurationEditBox:GetNumber();
		if ( record[4] < min or record[4] > max ) then
			return false;
		end
	end
	if ( HKCFilterFrameHonorRangeCheckButton:GetChecked() ) then
		min = HKCFilterFrameMinHonorEditBox:GetNumber();
		max = HKCFilterFrameMaxHonorEditBox:GetNumber();
		if ( record[3] < min or record[3] > max ) then
			return false;
		end
	end
	if ( HKCFilterFramePremadeARangeCheckButton:GetChecked() ) then
		min = HKCFilterFramePremadeAMinEditBox:GetNumber();
		max = HKCFilterFramePremadeAMaxEditBox:GetNumber();
		if ( record[5] < min or record[5] > max ) then
			return false;
		end
	end
	if ( HKCFilterFramePremadeHRangeCheckButton:GetChecked() ) then
		min = HKCFilterFramePremadeHMinEditBox:GetNumber();
		max = HKCFilterFramePremadeHMaxEditBox:GetNumber();
		if ( record[6] < min or record[6] > max ) then
			return false;
		end
	end
	if ( HKCFilterFrameAFKARangeCheckButton:GetChecked() ) then
		min = HKCFilterFrameAFKAMinEditBox:GetNumber();
		max = HKCFilterFrameAFKAMaxEditBox:GetNumber();
		if ( record[7] < min or record[7] > max ) then
			return false;
		end
	end
	if ( HKCFilterFrameAFKHRangeCheckButton:GetChecked() ) then
		min = HKCFilterFrameAFKHMinEditBox:GetNumber();
		max = HKCFilterFrameAFKHMaxEditBox:GetNumber();
		if ( record[8] < min or record[8] > max ) then
			return false;
		end
	end
	if ( HKCFilterFrameMinKBsCheckButton:GetChecked() and record[9] < HKCFilterFrameMinKBsEditBox:GetNumber() ) then
		return false;
	end
	if ( HKCFilterFrameMinDamageCheckButton:GetChecked() and record[10] < HKCFilterFrameMinDamageEditBox:GetNumber() ) then
		return false;
	end
	if ( HKCFilterFrameMinHealingCheckButton:GetChecked() and record[11] < HKCFilterFrameMinHealingEditBox:GetNumber() ) then
		return false;
	end
	if ( HKCFilterFrameTimeOfDayCheckButton:GetChecked() ) then
		min = HKCFilterFrameTimeOfDayMinEditBox:GetNumber();
		max = HKCFilterFrameTimeOfDayMaxEditBox:GetNumber();

		local hour = date("%H", record[1]);
		hour = tonumber(hour);

		if ( hour < min or hour > max ) then
			return false;
		end
	end
	if (	HKCFilterFrameJoinedLateCheckButton:GetChecked()
		or HKCFilterFrameKBRankCheckButton:GetChecked()
		or HKCFilterFrameDamageRankCheckButton:GetChecked()
		or HKCFilterFrameHealingRankCheckButton:GetChecked()
	) then
		local kbRank, damageRank, healingRank, joinedLate = HKC_SplitItem13(record[13]);

		if ( HKCFilterFrameJoinedLateCheckButton:GetChecked() and joinedLate ) then
			return false;
		end
		if ( HKCFilterFrameKBRankCheckButton:GetChecked() ) then
			min = HKCFilterFrameKBRankMinEditBox:GetNumber();
			max = HKCFilterFrameKBRankMaxEditBox:GetNumber();

			if ( kbRank < min or kbRank > max ) then
				return false;
			end
		end
		if ( HKCFilterFrameDamageRankCheckButton:GetChecked() ) then
			min = HKCFilterFrameDamageRankMinEditBox:GetNumber();
			max = HKCFilterFrameDamageRankMaxEditBox:GetNumber();

			if ( damageRank < min or damageRank > max ) then
				return false;
			end
		end
		if ( HKCFilterFrameHealingRankCheckButton:GetChecked() ) then
			min = HKCFilterFrameHealingRankMinEditBox:GetNumber();
			max = HKCFilterFrameHealingRankMaxEditBox:GetNumber();

			if ( healingRank < min or healingRank > max ) then
				return false;
			end
		end
	end
	return true;
end

function HKCTableFrame_UpdateDB()
	-- create an array of references to every record so we can sort and filter
	HKC_DB = {};

	local bg, bracket;
	bg = HKC_BGHISTORY_LABELS[HKC_BGHistory_Selected];
	if ( HKC_BGHistory[HKC_Server][bg] ) then
		if ( HKC_BGHISTORY_BRACKET_LABELS and HKC_BGHISTORY_BRACKET_LABELS[HKC_BGHistoryBracket_Selected] ) then
			bracket = HKC_BGHISTORY_BRACKET_LABELS[HKC_BGHistoryBracket_Selected];
		end
	end

	if ( not bg or not bracket ) then
		return
	end

	-- time frame
	local startDate, endDate, startDateTable, endDateTable;
	if ( not HKCTableFrameAllRecordsCheckButton:GetChecked() ) then
		startDateTable = {
			month = HKCTableFrameStartMonthEditBox:GetNumber(),
			day = HKCTableFrameStartDayEditBox:GetNumber(),
			year = HKCTableFrameStartYearEditBox:GetNumber() + 2000,
			hour = HKCTableFrameStartHourEditBox:GetNumber()
		};
		endDateTable = {
			month = HKCTableFrameEndMonthEditBox:GetNumber(),
			day = HKCTableFrameEndDayEditBox:GetNumber(),
			year = HKCTableFrameEndYearEditBox:GetNumber() + 2000,
			hour = HKCTableFrameEndHourEditBox:GetNumber()
		};
		startDate = time(startDateTable);
		endDate = time(endDateTable);
		if ( not startDate ) then
			startDate = 0;
		end
		if ( not endDate ) then
			endDate = 9999999999;
		end
	end

	-- get record references from HKC_BGHistory
	local record;
	local records = 0;
	for _, record in ipairs(HKC_BGHistory[HKC_Server][bg][bracket]) do

		if ( HKCTableFrameAllRecordsCheckButton:GetChecked() ) then
			-- all records
			if ( HKC_CheckFilters(record) ) then
				table.insert(HKC_DB, record);
			end
			records = records + 1;
		else
			-- time frame
			if ( record[1] > startDate and record[1] < endDate ) then
				if ( HKC_CheckFilters(record) ) then
					table.insert(HKC_DB, record);
				end
				records = records + 1;
			end
		end

	end

	-- print records displayed
	HKCTableFrameRecords:SetText(table.getn(HKC_DB)..HKC_OF..records);

	-- set averages
	HKCTableFrame_GetAverages();

	HKC_LastSort = 0;
	HKCTableFrame_Sort(1);	-- sort by date, descending
end

function HKCTableFrame_OnShow()

	local bg, bracket;
	bg = HKC_BGHISTORY_LABELS[HKC_BGHistory_Selected];
	if ( HKC_BGHistory[HKC_Server][bg] ) then
		if ( HKC_BGHISTORY_BRACKET_LABELS and HKC_BGHISTORY_BRACKET_LABELS[HKC_BGHistoryBracket_Selected] ) then
			bracket = HKC_BGHISTORY_BRACKET_LABELS[HKC_BGHistoryBracket_Selected];
		end
	end

	if ( not bg or not bracket ) then
		return
	end

	local ref = HKC_BGHistory[HKC_Server][bg][bracket];

	HKCTableFrameTitle:SetText(bg.." "..bracket.." "..HKC_BRACKET_LABEL);

	HKCTableFrameStartMonthEditBox:SetText( date("%m", ref[1][1]) );
	HKCTableFrameStartDayEditBox:SetText( date("%d", ref[1][1]) );
	HKCTableFrameStartYearEditBox:SetText( date("%y", ref[1][1]) );
	HKCTableFrameStartHourEditBox:SetText( date("%H", ref[1][1]) );
	HKCTableFrameEndMonthEditBox:SetText( date("%m", ref[table.getn(ref)][1]) );
	HKCTableFrameEndDayEditBox:SetText( date("%d", ref[table.getn(ref)][1]) );
	HKCTableFrameEndYearEditBox:SetText( date("%y", ref[table.getn(ref)][1]) );
	HKCTableFrameEndHourEditBox:SetText( date("%H", ref[table.getn(ref)][1]) + 1 );

	HKCTableFrame_UpdateDB();

	HKCTableFrame_Update();
end

function HKCTableFrame_Update()
	local offset = FauxScrollFrame_GetOffset(HKCTableFrameScrollBar);

	HKCTableFrame_DrawTable(HKC_DB, offset);
	local items = table.getn(HKC_DB);
	local i;

	if ( items <= 20 ) then
		HKCTableFrameScrollBar:Hide();
	else
		HKCTableFrameScrollBar:Show();
	end

	FauxScrollFrame_Update(HKCTableFrameScrollBar, items, 20, 12 );
end

function HKCTableFrame_Sort(type)

	if ( HKC_LastSort == type ) then
		table.sort(HKC_DB, 
			function(a, b)
				local x, y = a[type], b[type];
				if ( not x ) then
					x = 0;
				end
				if ( not y ) then
					y = 0;
				end

				return x < y;
			end
		);
		HKC_LastSort = 0;
	else
		table.sort(HKC_DB, 
			function(a, b)
				local x, y = a[type], b[type];
				if ( not x ) then
					x = 0;
				end
				if ( not y ) then
					y = 0;
				end

				return x > y;
			end
		);
		HKC_LastSort = type;
	end

end

function HKCTableFrameAllRecordsCheckButton_OnClick()
	if (this:GetChecked()) then
		HKCTableFrameStartMonthEditBox:Hide();
		HKCTableFrameStartDayEditBox:Hide();
		HKCTableFrameStartYearEditBox:Hide();
		HKCTableFrameStartHourEditBox:Hide();
		HKCTableFrameEndMonthEditBox:Hide();
		HKCTableFrameEndDayEditBox:Hide();
		HKCTableFrameEndYearEditBox:Hide();
		HKCTableFrameEndHourEditBox:Hide();
		HKCTableFrameTo:Hide();
	else
		HKCTableFrameStartMonthEditBox:Show();
		HKCTableFrameStartDayEditBox:Show();
		HKCTableFrameStartYearEditBox:Show();
		HKCTableFrameStartHourEditBox:Show();
		HKCTableFrameEndMonthEditBox:Show();
		HKCTableFrameEndDayEditBox:Show();
		HKCTableFrameEndYearEditBox:Show();
		HKCTableFrameEndHourEditBox:Show();
		HKCTableFrameTo:Show();
	end

	HKCTableFrame_UpdateDB();
	HKCTableFrame_Update();
end

function HKCTableFrameTimeFrameEditBoxes_SetTimeFrame()
	this:HighlightText(0, 0);
	HKCTableFrame_UpdateDB();
	HKCTableFrame_Update();
end

function HKCFrameFiltersButton_OnClick()
	if ( HKCFilterFrame:IsVisible() ) then
		this:SetText(FILTERS.." >>>");
		HKCFilterFrame:Hide();
	else
		this:SetText(FILTERS.." <<<");
		HKCFilterFrame:Show();
	end
end

function HKCFilterFrame_OptionClicked(check)
	HKCTableFrame_UpdateDB();
	HKCTableFrame_Update();
	if ( check ) then
		if ( this:GetChecked() ) then
			PlaySound("igMainMenuOptionCheckBoxOn");
		else
			PlaySound("igMainMenuOptionCheckBoxOff");
		end
	end
end


-- Arena History Functions

function HKC_DisplayArenaRecord(record)

	local text = "|c00ffffff"..date("%c", record[2]).."|r: "..HKC_RATING_CHANGE..": |c0000ffff"..record[3].."|r";
	table.insert( HKC_FrameText, text );

	local teamNum, team;

	for teamNum = 0, 1 do

		team = record[teamNum];

		if ( not team ) then
			break;
		end

		text = "|c00ffffff"..team[1].."|r - "..HKC_RATED.." |c00ffff00"..team[2].."|r";
		table.insert( HKC_FrameText, text );

		if ( team[3] ) then
			text = HKC_SERVER_LABEL..": "..team[3];
			table.insert( HKC_FrameText, text );
		end

		for i = 4, table.getn(team) do
			text = "|c0000ff00"..team[i].name.."|r, "..team[i].race.." "..team[i].class;
			table.insert( HKC_FrameText, text );

			text = "  ";
			if ( team[i].kbs > 0 ) then
				text = text..team[i].kbs.." "..HKC_KBS.."; ";
			end
			if ( team[i].damage > 0 ) then
				text = text..team[i].damage.." "..DAMAGE;
			end
			if ( team[i].healing > 0 ) then
				if ( team[i].damage > 0 ) then
					text = text.."; ";
				end
				text = text..team[i].healing.." "..HKC_HEALING;
			end

			table.insert( HKC_FrameText, text );
		end
	end

	text = TIME_ELAPSED.." |c0000ffff"..SecondsToTime(record[4]).."|r";
	table.insert( HKC_FrameText, text );

	table.insert( HKC_FrameText, "" );
end

function HKCFrameArenaHistory(size)
	HKC_FrameText = {};

	if ( not size ) then
		return
	end

	local i;

	table.insert( HKC_FrameText, "|c00ffffff"..size.."v"..size.."|r:" );
	table.insert( HKC_FrameText, "" );

	for i = table.getn(HKC_ArenaHistory[size]), 1, -1 do
		HKC_DisplayArenaRecord(HKC_ArenaHistory[size][i]);
	end

	table.insert( HKC_FrameText, "" );
	table.insert( HKC_FrameText, "" );
end

function HKC_GetArenaStats()
	if ( HKC_GotArenaScores ) then
		return;
	end

	local teamName, teamRating, newTeamRating, status, id, size;
	local _, isRegistered = IsActiveBattlefieldArena();

	for i = 1, MAX_BATTLEFIELD_QUEUES do
		status, _, id, _, _, size = GetBattlefieldStatus(i);
		if ( status == "active" ) then
			break;
		end
		size = nil;
	end

	if ( not size ) then
		return
	end
	HKC_LastArenaSize = size;

	if ( not isRegistered ) then
		return
	end

	local numScores = GetNumBattlefieldScores();
	local i, name, faction, server, class, race, damage, healing, killingBlows, myTeam, otherTeam;
	local teams = { [0] = {}, [1] = {} };
	teams[0][1] = "";
	teams[1][1] = "";
	teams[0][2] = 0;
	teams[1][2] = 0;

	if ( numScores > 0 ) then
		for i = 1, numScores do

			name, killingBlows, _, _, _, faction, _, race, class, _, damage, healing = GetBattlefieldScore(i);

			if ( name == HKC_PlayerName ) then
				myTeam = faction;
				if ( faction == 0 ) then
					otherTeam = 1;
				else
					otherTeam = 0;
				end
			end

			if ( string.find(name, "-", 1, true) ) then
				_, _, name, server = string.find(name, "(.+)%-(.+)");
			else
				server = HKC_Server;
			end
			if ( not server ) then
				server = "";
			end

			teams[faction][3] = server;
			table.insert(teams[faction], {
				name = name,
				class = class,
				race = race,
				kbs = killingBlows,
				damage = damage,
				healing = healing
			} );
		end
	end

	if ( #teams[0] < 4 or #teams[1] < 4 ) then
		return
	end

	teamName, teamRating, newTeamRating = GetBattlefieldTeamInfo(otherTeam);

	if ( not teamName or teamRating  == 0 ) then
		return
	end

	teams[otherTeam][1] = teamName;
	teams[otherTeam][2] = teamRating;

	teamName, teamRating, newTeamRating = GetBattlefieldTeamInfo(myTeam);

	if ( not teamName or teamRating == 0 ) then
		return
	end

	teams[myTeam][1] = teamName;
	teams[myTeam][2] = teamRating;

	local record = {
		[0] = teams[0],
		[1] = teams[1],
		[2] = time(date("*t"));
		[3] = (newTeamRating - teamRating),
		[4] = (GetBattlefieldInstanceRunTime() / 1000),
	};

	if ( not HKC_ArenaHistory[size] ) then
		HKC_ArenaHistory[size] = {};
	end

	table.insert(HKC_ArenaHistory[size], record);

	-- remove old records if over the max records limit
	if ( table.getn(HKC_ArenaHistory[size]) > HKC_CFG.maxArenaRecords ) then
		local n = table.getn(HKC_ArenaHistory[size]) - HKC_CFG.maxArenaRecords;

		for i = 1, n do
			table.remove(HKC_ArenaHistory[size], 1);
		end
	end

	HKC_GotArenaScores = true;
end

function HKCArenaHistoryDropDown_Initialize()
	local k;

	for k in pairs(HKC_ArenaHistory) do
		UIDropDownMenu_AddButton( {
			text = k.."v"..k,
			value = k,
			func = HKCArenaHistoryDropDown_OnClick,
		} );

		if ( not HKC_LastArenaSize ) then
			HKC_LastArenaSize = k;
		end
	end

end

function HKCArenaHistoryDropDown_OnClick()

	UIDropDownMenu_SetSelectedValue( HKCArenaHistoryDropDown, this.value );
	value = UIDropDownMenu_GetSelectedValue( HKCArenaHistoryDropDown );

	if ( not value ) then
		return
	end

	HKCFrameArenaHistory(value);
	HKC_LastArenaSize = value;
	HKCFrame_Update();
end
