﻿-- Guild Note on Login
GNOL_VERSION="1.0.0";

GNOL_NameMap = {};
GNOL_ONLINE = ".*%[(.+)%]%S*"..string.sub(ERR_FRIEND_ONLINE_SS, 20)

GNOL_InitComplete = false;
GNOL_Debug = false;

--ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL_JOIN", gnolChatFilter);
--ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL_LEAVE", gnolChatFilter);


function GuildNoteOnLogin_OnLoad()
  SlashCmdList["GUILD_NOTE_ON_LOGIN"] = GuildNoteOnLogin;
  SLASH_GUILD_NOTE_ON_LOGIN1 = "/gnol";  
  
  this:RegisterEvent("PLAYER_ENTERING_WORLD");
  this:RegisterEvent("VARIABLES_LOADED");
  --this:RegisterEvent("CHAT_MSG_CHANNEL_JOIN")
  --this:RegisterEvent("CHAT_MSG_CHANNEL_LEAVE")
end

-- slash handler
function GuildNoteOnLogin(msg)
    if(msg == "reload") then
        GNOL_UpdateRoster();
    elseif(msg == "debug") then
        GNOL_Debug = not (GNOL_Debug);
        msg("Debug = "..GNOL_Debug);
    elseif( DEFAULT_CHAT_FRAME ) then
       DEFAULT_CHAT_FRAME:AddMessage("Guild Note on Login version "..GNOL_VERSION..".", .6, .4, .7);
     end
end


local function println(text)
    if( DEFAULT_CHAT_FRAME ) then
        DEFAULT_CHAT_FRAME:AddMessage(text, .5, .8, .8);
    end
end

local function debug(msg)
    if( GNOL_Debug and DEFAULT_CHAT_FRAME ) then
        DEFAULT_CHAT_FRAME:AddMessage(text, .4, .7, .7);
    end
end

function GNOL_msg(msg)
    if( DEFAULT_CHAT_FRAME ) then
        DEFAULT_CHAT_FRAME:AddMessage(msg, .6, .4, .7);
    end
end

function GuildNoteOnLogin_OnEvent()
  if(event == "VARIABLES_LOADED") then
        GuildRoster();        
        GNOL_UpdateRoster()
  elseif (event == "PLAYER_ENTERING_WORLD") then
        println("Guild Note On Login mod loaded.");
        GuildRoster();        
        GNOL_UpdateRoster();
		this:UnregisterEvent("PLAYER_ENTERING_WORLD")
        this:RegisterEvent("GUILD_ROSTER_UPDATE")

		--this:RegisterEvent("CHAT_MSG_CHANNEL_JOIN")
		--this:RegisterEvent("CHAT_MSG_CHANNEL_LEAVE")
        this:RegisterEvent("CHAT_MSG_SYSTEM")
  elseif (event == "CHAT_MSG_CHANNEL_JOIN") then
      --GNOL_ChannelJoin(arg2);
  elseif (event == "CHAT_MSG_CHANNEL_JOIN") then
      --GNOL_ChannelJoin(arg2);
  elseif (event == "CHAT_MSG_SYSTEM") then
      GNOL_GuildChannelJoin(arg1);
  elseif (event == "GUILD_ROSTER_UPDATE") then
	  GNOL_UpdateRoster();
      this:UnregisterEvent("GUILD_ROSTER_UPDATE")
  end
end


function GNOL_UpdateRoster()
    if IsInGuild() then
       local numTotal = GetNumGuildMembers();
       println("GNOL loading names = "..numTotal);
       for gi=1, numTotal, 1 do
           name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(gi);
           --println("Adding "..name.." with note "..note);
           GNOL_NameMap[name] = note;
        end 
    end    
end

function GNOL_Init()
  -- nothing yet
--  GNOL_InitComplete = true;
end


function GNOL_GuildChannelJoin(msg)
    local _, _, player = string.find(msg, GNOL_ONLINE);
    if(player) then
        local note = GNOL_NameMap[player];
        if(note) then
            println(player.."'s note: "..note);
        end
    end
end


--TODO:  IsInGuild() - disable if player not in a guild.
--local gnolChatFilter(cmsg)
    --GNOL_msg("Chat filter activated.  Message is: "..cmsg);
   -- return false, cmsg;
  --if strfind(msg, "has come online") then
  --    DEFAULT_CHAT_FRAME:AddMessage("GNOL Sees: "..msg, .6, .4, .7);
      --GuildRoster();
      --local numOnline, numTotal = (GetNumGuildMembers()), (GetNumGuildMembers(true));
      --name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(index);
      
    --  return false, "hello"
    --return false, gsub(msg, "lol", "")
    --CHAT_MSG_CHANNEL_JOIN
  --end
--end

