-- Default (English)
--------------------

if (not GLDG_TXT) then
	GLDG_TXT = {}
end

-- Binding names
BINDING_HEADER_GUILDGREET		= "GuildGreet";
BINDING_NAME_GUILDGREETCONFIG		= "Open config window";
BINDING_NAME_GUILDGREETCLEAR		= "Clear greet list"
BINDING_NAME_GUILDGREETTEST		= "Test trigger";
BINDING_NAME_GUILDGREETGREETGUILD	= "Greet Guild and Channel";
BINDING_NAME_GUILDGREETBYEGUILD		= "Say goodbye to guild and channel";
BINDING_NAME_GUILDGREETLATERGUILD	= "Say see you later to guild and channel"

-- Names for the tabs
GLDG_TXT.TabSettings	= "Settings"
GLDG_TXT.TabGreetings	= "Greetings"
GLDG_TXT.TabPlayers	= "Guild members"
GLDG_TXT.TabFriends	= "Friends"
GLDG_TXT.TabChannel	= "Channel"
GLDG_TXT.TabColour	= "Colours"
GLDG_TXT.SubTabGeneral  = "General"
GLDG_TXT.SubTabChat	= "Chat"
GLDG_TXT.SubTabGreeting	= "Greeting"
GLDG_TXT.SubTabDebug	= "Debug"
GLDG_TXT.SubTabOther	= "Other"

-- Queue list
GLDG_TXT.new		= "NEW"
GLDG_TXT.lvl		= "LEVEL"
GLDG_TXT.rank		= "RANK"

-- Queue list tooltips
GLDG_TXT.tipdef		= "At %s, this guild member came online for the first time during this session."
GLDG_TXT.tiprelog	= "At %s, this guild member came back online after being offline for %s."
GLDG_TXT.tipdef_f	= "At %s, this friend came online for the first time during this session."
GLDG_TXT.tiprelog_f	= "At %s, this friend came back online after being offline for %s."
GLDG_TXT.tipdef_c	= "At %s, this channel member came online for the first time during this session."
GLDG_TXT.tiprelog_c	= "At %s, this channel member came back online after being offline for %s."
GLDG_TXT.tiprelogalt	= " Character used by player previously was %s."
GLDG_TXT.tipnew		= "At %s, this player joined the guild"
GLDG_TXT.tipnew2	= "Player joined the guild before you logged on."
GLDG_TXT.tiplvl		= "Guild member reached level %s."
GLDG_TXT.tiplvl_f	= "Friend reached level %s."
GLDG_TXT.tiplvl_c	= "Channel member reached level %s."
GLDG_TXT.tiprank	= "%s promoted the player to rank %s earlier."
GLDG_TXT.tiprank2	= "At %s, %s promoted this player to rank %s."
GLDG_TXT.tiprank3	= "Player was promoted to rank %s before you logged on."
GLDG_TXT.tipalt		= " Main character for this player is %s."
GLDG_TXT.hour		= "%d hour "
GLDG_TXT.minute		= "%d min"
GLDG_TXT.lvlIncrease1	= "has increased his level from"
GLDG_TXT.lvlIncrease2	= "to"
GLDG_TXT.lvlIncrease3	= ""
GLDG_TXT.leftguild	= "has left the guild"

-- Settings tab: greeting options
GLDG_TXT.optheader	= "Configuration options to determine who, when and how to greet"
GLDG_TXT.relogalways	= "Always show relogs"
GLDG_TXT.reloglimit	= "Only show relogs after more then %d min"
GLDG_TXT.greetasmain	= "Greet alts with the same name as main by default"
GLDG_TXT.randomize	= "Randomly use alias and or main and alt names"
GLDG_TXT.whisper	= "Whisper greetings to players"
GLDG_TXT.useFriends	= "Manage friend's list"
GLDG_TXT.autoAssign	= "Automatically assign main/alt based on guild note"
GLDG_TXT.channelName	= "Channel name to monitor"
GLDG_TXT.includeOwn	= "Display your own characters"
GLDG_TXT.minlevelupalways = "Always show level-up"
GLDG_TXT.minlevelup	= "Only show level-up for levels above %d"
GLDG_TXT.eventonly	= "Only update guild roster on events"
GLDG_TXT.updatetime	= "Update guild roster every %d seconds"

-- Settings tab: chat options
GLDG_TXT.chatheader	= "Printing information to chat"
GLDG_TXT.defaultChatFrame = "Using default chat frame"
GLDG_TXT.chatFrame	= "Using chat frame %d (%s)"
GLDG_TXT.listNames	= "List alt and main names when player logs in"
GLDG_TXT.listNamesOff	= "List alt and main names when player logs off"
GLDG_TXT.listLevelUp	= "List to chat when a player levels up (online only)"
GLDG_TXT.listLevelUpOff	= "List to chat when a player levels up (offline players, printed when you log in)"
GLDG_TXT.listQuit	= "List to chat when a player leaves the guild"
GLDG_TXT.extendChat	= "Add main name to chat when an alt sends a message"
GLDG_TXT.extendMain	= "Even re-add main name for main char (if the above option is enabled)"
GLDG_TXT.extendAlias	= "Add main's alias to chat (if it exists and the above option is enabled)"

-- Settings tab: greeting options
GLDG_TXT.greetingheader	= "Greeting the guild and channel (per character setting)"
GLDG_TXT.greetGuild	= "Greet guild when 'Greet Key' is pressed (also applies to saying bye)"
GLDG_TXT.greetChannel	= "Greet channel when 'Greet Key' is pressed (also applies to saying bye)"
GLDG_TXT.autoGreet	= "Automatically greet guild and/or channel when logging in (depends on settings above). |cFFFF0000Use carefully (see tooltip)."
GLDG_TXT.greetingsubheader = "Temporarily suppress greeting players"
GLDG_TXT.supressAll	= "Supress all"
GLDG_TXT.supressNone	= "Supress none"
GLDG_TXT.supressGreet	= "Don't put players coming online on the greet list"
GLDG_TXT.supressJoin	= "Don't put players joining the guild on the greet list"
GLDG_TXT.supressLevel	= "Don't put players that level up on the greet list"
GLDG_TXT.supressRank	= "Don't put players that get promoted on the greet list"
GLDG_TXT.noGratsOnLogin	= "Don't congratulate players that just logged in"
GLDG_TXT.guildAlias	= "Guild alias for: "
GLDG_TXT.guildNoAlias	= "Can't set guild alias while unguilded"

-- Settings tab: Debug
GLDG_TXT.dumpHeader	= "GuildGreetDump interface"
GLDG_TXT.noDumping	= "GuildGreetDump not found - cannot configure dumping"
GLDG_TXT.noDumpingShort	= "GuildGreetDump not found"
GLDG_TXT.enableDump	= "Enable dumping of debug info to GuildGreetDump"
GLDG_TXT.verboseDump	= "Use verbose dumping of debug info to GuildGreetDump"
GLDG_TXT.dumpSet	= "There are %d dump sets stored in the saved variables file"
GLDG_TXT.currentIndex	= "There are %d entries stored in dump set %d"
GLDG_TXT.btnClear	= "Clear current set (set %d)"
GLDG_TXT.btnClearAll	= "Clear all sets"
GLDG_TXT.btnNew		= "Use a new set"

-- Settings tab: other options
GLDG_TXT.otherheader	= "Various settings"
GLDG_TXT.useLocalTime	= "Use local time instead of server time"
GLDG_TXT.showNewerVersions = "Show if newer versions of addons are available"
GLDG_TXT.enableContextMenu = "Enable player context menu (may cause taint issues in raid frame, see tooltip)"

-- Settings tab: player list settings
GLDG_TXT.listheader	= "Configuration options for displaying the players waiting for a greeting"
GLDG_TXT.listdirect	= "List grows upwards instead of downwards"
GLDG_TXT.listvisible	= "List header is always visible"
GLDG_TXT.listsize	= "Display a maximum of %d queued players"

-- Greetings tab
GLDG_TXT.greetheader	= "Manage the messages you want to use for greeting"
GLDG_TXT.collectheader	= "Custom collections"
GLDG_TXT.cbnew		= "Create new collection"
GLDG_TXT.cbdel		= "Remove selection"
GLDG_TXT.cbrealm	= "Set realm collection"
GLDG_TXT.cbguild	= "Set guild collection"
GLDG_TXT.cbplayer	= "Set character collection"
GLDG_TXT.custheader	= "Current value"
GLDG_TXT.nodef		= "not defined"
GLDG_TXT.selection	= "Selected collection"

-- Greetins tab: selection header and buttons
GLDG_TXT.colglobal	= "Global defaults"
GLDG_TXT.colcustom	= "Collection \'%s\'"
GLDG_TXT.msgheader	= "%s : select the greeting category you want to edit"
GLDG_TXT.default	= "coming online"
GLDG_TXT.relog		= "relogging"
GLDG_TXT.joining	= "joining guild"
GLDG_TXT.newrank	= "promotion"
GLDG_TXT.newlevel	= "leveling"
GLDG_TXT.bye		= "bye char"
GLDG_TXT.night		= "night char"
GLDG_TXT.guild		= "greet guild"
GLDG_TXT.channel	= "greet channel"
GLDG_TXT.byeGuild	= "bye guild"
GLDG_TXT.nightGuild	= "night guild"
GLDG_TXT.byeChannel	= "bye channel"
GLDG_TXT.nightChannel	= "night channel"
GLDG_TXT.laterGuild	= "later guild"
GLDG_TXT.laterChannel	= "later channel"

-- Greetings tab: greetings editbox
GLDG_TXT.Greet		= "Edit default greeting message: first use of %s is replaced by player name"
GLDG_TXT.GreetBack	= "Edit relog greeting message: first use of %s is replaced by player name"
GLDG_TXT.Welcome	= "Edit welcome greeting message: first use of %s is replaced by player name"
GLDG_TXT.NewRank	= "Edit promotion congratulations: first %s is player, second %s is new rank"
GLDG_TXT.NewLevel	= "Edit new level congratulations: first %s is player, second %s is new level"
GLDG_TXT.Bye		= "Edit leaving message (day) for players: first use of %s is replaced by player name"
GLDG_TXT.Night		= "Edit leaving message (night) for players: first use of %s is replaced by player name"
GLDG_TXT.Guild		= "Edit message to great guild: first use of %s is guild alias"
GLDG_TXT.Channel	= "Edit message to greet channel: first use of %s is guild alias"
GLDG_TXT.ByeGuild	= "Edit message to say good bye to guild: first use of %s is guild alias"
GLDG_TXT.NightGuild	= "Edit message to say good night to guild: first use of %s is guild alias"
GLDG_TXT.ByeChannel	= "Edit message to say good bye to channel"
GLDG_TXT.NightChannel	= "Edit message to say good night to channel"
GLDG_TXT.LaterGuild	= "Edit message to say see you later to guild: first use of %s is guild alias"
GLDG_TXT.LaterChannel	= "Edit message to say see you later to channel"

-- Players tab
GLDG_TXT.playersheader	= "Configure settings for your guildmembers: ignore them, set main/alt and enter alias"
GLDG_TXT.markIGN	= "IGNORE"
GLDG_TXT.markMAIN	= "MAIN"
GLDG_TXT.markALT	= "ALT"
GLDG_TXT.ignores	= "Include ignored players in the list"
GLDG_TXT.showalt	= "Always show alts"
GLDG_TXT.groupalt	= "Keep with main"
GLDG_TXT.filterUnassigned = "Show only unassigned characters"
GLDG_TXT.pbsign		= "Ignore"
GLDG_TXT.pbrign		= "Unignore"
GLDG_TXT.pbalias	= "Set alias"
GLDG_TXT.pbsmain	= "Set as main"
GLDG_TXT.pbrmain	= "Unset as main"
GLDG_TXT.pbpmain	= "Promote to main"
GLDG_TXT.pbsalt		= "Set as alt"
GLDG_TXT.pbralt		= "Unset as alt"
GLDG_TXT.pbdelete	= "Delete"
GLDG_TXT.mainhead	= "Select main for character %s"
GLDG_TXT.aliashead	= "Set alias for character %s"

-- Friends tab (much shared with players tab)
GLDG_TXT.friendsheader	= "Configure settings for your friends: ignore them, set main/alt and enter alias"

-- Friends tab (much shared with players tab)
GLDG_TXT.channelheader	= "Configure settings for your channel members: ignore them, set main/alt and enter alias"
GLDG_TXT.none		= "<none>"

-- Colour tab
GLDG_TXT.colGuild	= "Guild"
GLDG_TXT.colFriends	= "Friends"
GLDG_TXT.colChannel	= "Channel"
GLDG_TXT.colChatHeader	= "Chat"
GLDG_TXT.colOn		= "Coming online"
GLDG_TXT.colGoOff	= "Going offline"
GLDG_TXT.colIsOff	= "Is offline"
GLDG_TXT.colAlias	= "Alias"
GLDG_TXT.colListHeader	= "Greet list"
GLDG_TXT.colList	= "Coming online"
GLDG_TXT.colRelog	= "Relogging"
GLDG_TXT.colNew		= "New member"
GLDG_TXT.colLevel	= "Level up"
GLDG_TXT.colRank	= "Promotion"
GLDG_TXT.colCommonHeader = "Common"
GLDG_TXT.colHelp	= "Output"
GLDG_TXT.colHeader	= "Greet list header"
GLDG_TXT.colDefault	= "Default colours"

-- Colour picker extension
GLDG_TXT.red		= "Red"
GLDG_TXT.green		= "Green"
GLDG_TXT.blue		= "Blue"
GLDG_TXT.opactiy	= "Opacity"
GLDG_TXT.colourConfig	= "Cannot configure two colours at once"
GLDG_TXT.colourDefault	= "Cannot set default colours while colour picker is open"

-- Common use
GLDG_TXT.set		= "set"
GLDG_TXT.cancel		= "cancel"
GLDG_TXT.update		= "update"
GLDG_TXT.delete		= "remove"
GLDG_TXT.add		= "add"
GLDG_TXT.clear		= "clear"

-- Help, About and Listing
GLDG_TXT.help			= "A tool to manage mains and alts in the guild and greet them"
GLDG_TXT.usage			= "Usage"
GLDG_TXT.name			= "name"
GLDG_TXT.help_all		= "List alts of all members to chat"
GLDG_TXT.help_online		= "List alts of members that are online to chat"
GLDG_TXT.help_list		= "List alts of all members for copying"
GLDG_TXT.help_name		= "List main and alts for <name>"
GLDG_TXT.help_name_full		= "List main and alts for <name> with full class and level info"
GLDG_TXT.help_clear		= "Clear the greet list without greeting anyone"
GLDG_TXT.help_urbin = "List details about all addons by Urbin"
GLDG_TXT.noargs			= "without argument, show config frame"
GLDG_TXT.listall		= "Listing all guild members (also offline)"
GLDG_TXT.listonline		= "Listing online guild members only"
GLDG_TXT.listall_friends	= "Listing all friends (also offline)"
GLDG_TXT.listonline_friends	= "Listing online friends only"
GLDG_TXT.listall_channel	= "Listing all channel members (also offline)"
GLDG_TXT.listonline_channel	= "Listing online channel members only"
GLDG_TXT.notinguild		= "is not in guild"
GLDG_TXT.notfriend		= "or a friend"
GLDG_TXT.notchannel		= "or in channel"
GLDG_TXT.pasting		= "Pasting to list"
GLDG_TXT.disabled		= "Friends support disabled"
GLDG_TXT.disabled_c		= "Channel support disabled"
GLDG_TXT.command		= "Could not parse command"
GLDG_TXT.argmissing		= "Another argument is needed after command"
GLDG_TXT.by			= "by"
GLDG_TXT.version		= "Version"
GLDG_TXT.date			= "Date"
GLDG_TXT.web			= "Website"
GLDG_TXT.slash		= "Slash command"
GLDG_TXT.urbin		= "Other addons by Urbin"

-- Force Chatlist
GLDG_TXT.forceChatList	= "Forced chatlist to be displayed in chat"

-- Player menus
GLDG_TXT.menu			= "GuildGreet"
GLDG_TXT.lookup		= "Lookup"
GLDG_TXT.goodbye	= "Good bye"

-- Version check
GLDG_TXT.newer		= "A newer Version of the addon is available."
GLDG_TXT.newer1		= "You have version "
GLDG_TXT.newer2		= "Player "
GLDG_TXT.newer3		= " has version "
GLDG_TXT.newer4		= "."
GLDG_TXT.bigBrother	= " is using version "
GLDG_TXT.bigBrother2	= " has updated from version "
GLDG_TXT.bigBrother3	= " to version "
GLDG_TXT.bigBrother4	= ""
GLDG_TXT.bigBrother5	= "Listing known GuildGreet users"
GLDG_TXT.bigBrother6	= "No other GuildGreet users known"

-- Reloading of UI
GLDG_TXT.reloadQuestion	= "You must reload your interface for this change to take effect. Shall this be done now?"
GLDG_TXT.reloadNow	= "Reload now"
GLDG_TXT.later	= "Reload later"
GLDG_TXT.reload		= "You must manually reload your interface by typing /console reloadui"

-- Help Tooltips
GLDG_TXT.elements = {}
GLDG_TXT.elements.name = {}
GLDG_TXT.elements.tip = {}

GLDG_TXT.elements.name.GuildGreetListTitle	= "Greet list"
GLDG_TXT.elements.tip.GuildGreetListTitle	= "This list shows characters that need to be greeted or congratulated.\r\nLeft clicking on an entry will greet or congratulate the player.\r\nRight clicking an entry will remove the character without greeting.\r\nRight clicking the title will clear all characters without greeting."
GLDG_TXT.elements.name.GuildGreetListClose	= "Clear greet list"
GLDG_TXT.elements.tip.GuildGreetListClose	= "Click the close button to clear the greet list without greeting or congratulating people."

GLDG_TXT.elements.name.Tab1	= GLDG_TXT.TabSettings
GLDG_TXT.elements.tip.Tab1	= "Configures the features of the addon"
GLDG_TXT.elements.name.Tab2	= GLDG_TXT.TabGreetings
GLDG_TXT.elements.tip.Tab2	= "Define the phrases to be used to greet people. Define customer phrase sets."
GLDG_TXT.elements.name.Tab3	= GLDG_TXT.TabPlayers
GLDG_TXT.elements.tip.Tab3	= "Manage main and alt chars of your guild"
GLDG_TXT.elements.name.Tab4	= GLDG_TXT.TabFriends
GLDG_TXT.elements.tip.Tab4	= "Manage main and alt chars of your friends list"
GLDG_TXT.elements.name.Tab5	= GLDG_TXT.TabChannel
GLDG_TXT.elements.tip.Tab5	= "Manage main and alt chars of your channel members"
GLDG_TXT.elements.name.Tab6	= GLDG_TXT.TabColour
GLDG_TXT.elements.tip.Tab6	= "Define colours to be used"

GLDG_TXT.elements.name.SettingsTab1	= GLDG_TXT.SubTabGeneral
GLDG_TXT.elements.tip.SettingsTab1	= "Settings of the addon, whom to greet, when to greet, list sizes, etc."
GLDG_TXT.elements.name.SettingsTab2	= GLDG_TXT.SubTabChat
GLDG_TXT.elements.tip.SettingsTab2	= "Configures which messages are printed to the chat"
GLDG_TXT.elements.name.SettingsTab3	= GLDG_TXT.SubTabGreeting
GLDG_TXT.elements.tip.SettingsTab3	= "Defining some detailed greeting parameters"
GLDG_TXT.elements.name.SettingsTab4	= GLDG_TXT.SubTabDebug
GLDG_TXT.elements.tip.SettingsTab4	= "Configure the GuildGreetDump addon in order to define how debug information should be dumped"
GLDG_TXT.elements.name.SettingsTab5	= GLDG_TXT.SubTabOther
GLDG_TXT.elements.tip.SettingsTab5	= "Reserved for future extensions"

GLDG_TXT.elements.name.SettingsGeneralRelogSlider	= "Reloge time"
GLDG_TXT.elements.tip.SettingsGeneralRelogSlider	= "Define whether characters that relog are always shown in the greeting list or only if they have been offline for at least the defined time in minutes"
GLDG_TXT.elements.name.SettingsGeneralMinLevelUpSlider	= "Level-up limit"
GLDG_TXT.elements.tip.SettingsGeneralMinLevelUpSlider	= "Define, which level a character needs to have reached before he is congratulated when reaching a new level. If this setting is zero, each new level will be congratulated for."
GLDG_TXT.elements.name.SettingsGeneralUpdateTimeSlider	= "Guild roster updates"
GLDG_TXT.elements.tip.SettingsGeneralUpdateTimeSlider	= "Define, whether the guild roster is only reparsed on events or at fixed intervals.\r\nPolling at fixed intervals may increase your communication load."
GLDG_TXT.elements.name.SettingsGeneralAutoAssignBox	= "Auto Assign"
GLDG_TXT.elements.tip.SettingsGeneralAutoAssignBox	= "If this setting is enabled, the guild notes and officer notes will be parsed for entries of the form 'Main' and 'alt-<main name>' to automatically manage main and alt names for your guild members."
GLDG_TXT.elements.name.SettingsGeneralGreetAsMainBox	= "Greet as Main"
GLDG_TXT.elements.tip.SettingsGeneralGreetAsMainBox	= "If this setting is enabled, any alt character is greetet with the name or alias of its main character"
GLDG_TXT.elements.name.SettingsGeneralIncludeOwnBox	= "Include own"
GLDG_TXT.elements.tip.SettingsGeneralIncludeOwnBox	= "If this setting is enabled, your own characters will also be shown in the guild list"
GLDG_TXT.elements.name.SettingsGeneralRandomizeBox	= "Random Greetings"
GLDG_TXT.elements.tip.SettingsGeneralRandomizeBox	= "If this setting is enabled, a character will be randomly greeted by either his name or alias (or that of his main, if the setting to greet alts as main is enabled)"
GLDG_TXT.elements.name.SettingsGeneralUseFriendsBox	= "Use Friends"
GLDG_TXT.elements.tip.SettingsGeneralUseFriendsBox	= "If this setting is enabled, GuildGreet will also manage your friends coming online and going offline"
GLDG_TXT.elements.name.SettingsGeneralWhisperBox	= "Whisper Greetings"
GLDG_TXT.elements.tip.SettingsGeneralWhisperBox		= "If this setting is enabled, greetings will be whispered to people instead of using the guild chat or channel selected"
GLDG_TXT.elements.name.SettingsGeneralChannelNameDropboxButton	= "Use Channel"
GLDG_TXT.elements.tip.SettingsGeneralChannelNameDropboxButton	= "If you choose any channel other than "..GLDG_TXT.none..", GuildGreet will monitor that channel for people joing and leaving it"

GLDG_TXT.elements.name.SettingsGeneralListdirectBox	= "Grow direction"
GLDG_TXT.elements.tip.SettingsGeneralListdirectBox	= "If this setting is enabled, the greet list will grow upwards instead of downwards"
GLDG_TXT.elements.name.SettingsGeneralListheaderBox	= "Always show header"
GLDG_TXT.elements.tip.SettingsGeneralListheaderBox	= "If this setting is enabled, the greet list header will always be shown, even if nobody needs to be greeted"
GLDG_TXT.elements.name.SettingsGeneralListsizeSlider	= "Greet list size"
GLDG_TXT.elements.tip.SettingsGeneralListsizeSlider	= "This defines how many people to be greeted will be shown in the greet list. If there are more people to be greeted than configured in this setting, the oldest entries will be shown."

GLDG_TXT.elements.name.SettingsChatChatFrameSlider	= "Chat frame"
GLDG_TXT.elements.tip.SettingsChatChatFrameSlider	= "Defines which chat frame is used to display GuildGreet chat messages."
GLDG_TXT.elements.name.SettingsChatListNamesBox		= "List online"
GLDG_TXT.elements.tip.SettingsChatListNamesBox		= "If this setting is enabled, a line printing all characters of the player that has just come online will be printed to the chat"
GLDG_TXT.elements.name.SettingsChatListNamesOffBox	= "List offline"
GLDG_TXT.elements.tip.SettingsChatListNamesOffBox	= "If this setting is enabled, a line printing all characters of the player that has just gone offline will be printed to the chat"
GLDG_TXT.elements.name.SettingsChatListLevelUpBox	= "List level up (online)"
GLDG_TXT.elements.tip.SettingsChatListLevelUpBox	= "If this setting is enabled, a line will be printed to the chat whenever a character levels up"
GLDG_TXT.elements.name.SettingsChatListLevelUpOffBox	= "List level up (offline)"
GLDG_TXT.elements.tip.SettingsChatListLevelUpOffBox	= "If this setting is enabled, a line will be printed for each character that is offline and leveled up while you were offline"
GLDG_TXT.elements.name.SettingsChatListQuitBox		= "List people quitting guild"
GLDG_TXT.elements.tip.SettingsChatListQuitBox		= "If this setting is enabled, a line will be printed if a character leaves the guild"
GLDG_TXT.elements.name.SettingsChatExtendChatBox	= "Main name in chat"
GLDG_TXT.elements.tip.SettingsChatExtendChatBox		= "If this setting is enabled, the name of the main will be prepended to the message an alt sends."
GLDG_TXT.elements.name.SettingsChatExtendMainBox	= "Main name in chat even for main"
GLDG_TXT.elements.tip.SettingsChatExtendMainBox		= "If this setting is enabled, the name of the main will be prepended even to messages of the main, not just the alt."
GLDG_TXT.elements.name.SettingsChatExtendAliasBox	= "Alias in chat"
GLDG_TXT.elements.tip.SettingsChatExtendAliasBox	= "If this setting is enabled, the alias of the main will be prepended to the message an alt sends instead of using the main name."

GLDG_TXT.elements.name.SettingsGreetingGreetGuildBox	= "Greet guild"
GLDG_TXT.elements.tip.SettingsGreetingGreetGuildBox	= "If this setting is enabled, pressing the (configurable) 'greet', 'see you later' and 'goodbye' keys will send an appropriate message to the guild chat. The keys can be configured in the key binding menu."
GLDG_TXT.elements.name.SettingsGreetingGreetChannelBox	= "Greet channel"
GLDG_TXT.elements.tip.SettingsGreetingGreetChannelBox	= "If this setting is enabled, pressing the (configurable) 'greet', 'see you later' and 'goodbye' keys will send an appropriate message to the channel. The keys can be configured in the key binding menu."
GLDG_TXT.elements.name.SettingsGreetingAutoGreetBox	= "Auto greet"
GLDG_TXT.elements.tip.SettingsGreetingAutoGreetBox	= "If this setting is enabled, a greeting will be sent to the guild chat and/or channel, as configured in the two settings above.\r\n|cFFFF0000Use carefully:\r\nThis will be executed every time you log in or reload your user interface using |r/console reloadui|cFFFF0000, so it's easy to annoy your friends."

GLDG_TXT.elements.name.SettingsGreetingSupressAll	= "Supress all greetings"
GLDG_TXT.elements.tip.SettingsGreetingSupressAll	= "Press this button to check all four checkboxes below. This will suppress all entries to the greet list, the output to the chat is not impacted.\r\nThis button is useful if you do not want to be distracted during an instance run."
GLDG_TXT.elements.name.SettingsGreetingSupressNone	= "Allow all greetings"
GLDG_TXT.elements.tip.SettingsGreetingSupressNone	= "Press this button to clear all four checkboxes below. This will allow all entries to the greet list."
GLDG_TXT.elements.name.SettingsGreetingSupressGreetBox	= "Supress greetings"
GLDG_TXT.elements.tip.SettingsGreetingSupressGreetBox	= "If this setting is enabled, players that come online will not be put on the greet list. This feature can be used to disable greeting of characters without deleting all the greeting phrases. If no greeting phrases are defined, the character will not be put on the greet list, even if this setting is cleared."
GLDG_TXT.elements.name.SettingsGreetingSupressJoinBox	= "Supress welcome"
GLDG_TXT.elements.tip.SettingsGreetingSupressJoinBox	= "If this setting is enabled, players that join the guild will not be put on the greet list. This feature can be used to disable greeting of characters without deleting all the greeting phrases. If no greeting phrases are defined, the character will not be put on the greet list, even if this setting is cleared."
GLDG_TXT.elements.name.SettingsGreetingSupressLevelBox	= "Supress levelup"
GLDG_TXT.elements.tip.SettingsGreetingSupressLevelBox	= "If this setting is enabled, players that level up will not be put on the greet list. This feature can be used to disable congratulating of characters without deleting all the congratulation phrases. If no congratulation phrases are defined, the character will not be put on the greet list, even if this setting is cleared."
GLDG_TXT.elements.name.SettingsGreetingSupressRankBox	= "Supress promotions"
GLDG_TXT.elements.tip.SettingsGreetingSupressRankBox	= "If this setting is enabled, players that are promoted will not be put on the greet list. This feature can be used to disable congratulating of characters without deleting all the congratulation phrases. If no congratulation phrases are defined, the character will not be put on the greet list, even if this setting is cleared."
GLDG_TXT.elements.name.SettingsGreetingNoGratsOnLoginBox	= "No congratulations on login"
GLDG_TXT.elements.tip.SettingsGreetingNoGratsOnLoginBox		= "If this setting is enabled, players that have been promoted or levelled up, will not be congratulated when the login but greeted instead.\r\nIf this setting is enabled, congratulations will only be given to players that are promoted or level up when already logged in."

GLDG_TXT.elements.name.SettingsGreetingGuildAliasEditbox	= "Guild Alias"
GLDG_TXT.elements.tip.SettingsGreetingGuildAliasEditbox		= "Enter a guild alias to be used instead of your guild name in the guild greetings. Press enter to set or escape to clear the alias."
GLDG_TXT.elements.name.SettingsGreetingGuildAliasSet		= "Set guild alias"
GLDG_TXT.elements.tip.SettingsGreetingGuildAliasSet		= "Press this button to set the guild alias currently being edited. This alias will then be used in guild greetings."
GLDG_TXT.elements.name.SettingsGreetingGuildAliasClear		= "Clear guild alias"
GLDG_TXT.elements.tip.SettingsGreetingGuildAliasClear		= "Press this button to clear the current guild alias. The full guild name will be used in guild greetings."

GLDG_TXT.elements.name.SettingsDebugEnableDumpBox	= "Enable Dumping"
GLDG_TXT.elements.tip.SettingsDebugEnableDumpBox	= "If this setting is enabled, debug information will be dumped into the saved variables of the GuildGreetDump addon. This information can then be uploaded on Curse Gaming to facilitate debugging.\r\n|cFFFF0000Note: this will create a lot of data, so use carefully.\r\n\r\nDon't enable this unless you were told to do so by Urbin on Curse Gaming!"
GLDG_TXT.elements.name.SettingsDebugVerboseDumpBox	= "Verbose Dumping"
GLDG_TXT.elements.tip.SettingsDebugVerboseDumpBox	= "If this setting is enabled, each message that is written to the dump set will be written to the chat as well."
GLDG_TXT.elements.name.SettingsDebugClearButton		= "Clear current set"
GLDG_TXT.elements.tip.SettingsDebugClearButton		= "Click this button to delete all entries of dump the current set"
GLDG_TXT.elements.name.SettingsDebugClearAllButton	= "Clear all sets"
GLDG_TXT.elements.tip.SettingsDebugClearAllButton	= "Click this button to delete all dump sets"
GLDG_TXT.elements.name.SettingsDebugNewButton		= "Use new set"
GLDG_TXT.elements.tip.SettingsDebugNewButton		= "Click this button to create a new dump set to which debug output is written"

GLDG_TXT.elements.name.SettingsOtherUseLocalTimeBox	= "Use local time"
GLDG_TXT.elements.tip.SettingsOtherUseLocalTimeBox	= "If this setting is enabled, local time is used instead of server time. This means that the time information in the greet list is based on local time as well as the decision whether to say 'good bye' or 'good night'."
GLDG_TXT.elements.name.SettingsOtherShowNewerVersionsBox	= "Show if newer version is available"
GLDG_TXT.elements.tip.SettingsOtherShowNewerVersionsBox	= "GuildGreet broadcasts its version in guild, party and raid channels. If this setting is enabled, and another player has a newer version than the one you are using, you will be informed about it with a message in the chat frame."
GLDG_TXT.elements.name.SettingsOtherEnableContextMenuBox	= "Enable player context menu"
GLDG_TXT.elements.tip.SettingsOtherEnableContextMenuBox	= "If this setting is enabled, two entries are added to the player context menu which appears if you right click on a player portrait or a player name in chat. The entries will allow to query GuildGreet about information you have on this player and to say good bye to the player.\r\n|cFFFF0000Note: There have been reports that this causes taint issues when using the raid frame. If this happens to you, disable this feature.|r\r\n\r\nI will look into secure methods to extend the context menu when I have a little more time.\r\n\r\n|cFFFF0000NOTE: You will be queried if you want to reload your interface when changing this option, as it only takes effect if you reload the user interface.|r"

GLDG_TXT.elements.name.ColourDefault		= "Default colours"
GLDG_TXT.elements.name.ColourHeader		= "Change colour and opacity"
GLDG_TXT.elements.name.ColourHelp		= "Change colour"
GLDG_TXT.elements.name.ColourChannelAlias	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourChannelGoOffline	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourChannelIsOffline	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourChannelLevel	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourChannelList	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourChannelNew		= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourChannelOnline	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourChannelRank	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourChannelRelog	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourFriendsAlias	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourFriendsGoOffline	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourFriendsIsOffline	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourFriendsLevel	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourFriendsList	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourFriendsNew		= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourFriendsOnline	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourFriendsRank	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourFriendsRelog	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourGuildAlias		= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourGuildGoOffline	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourGuildIsOffline	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourGuildLevel		= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourGuildList		= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourGuildNew		= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourGuildOnline	= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourGuildRank		= GLDG_TXT.elements.name.ColourHelp
GLDG_TXT.elements.name.ColourGuildRelog		= GLDG_TXT.elements.name.ColourHelp

GLDG_TXT.elements.tip.ColourDefault		= "Resets all colour values to their default values."
GLDG_TXT.elements.tip.ColourHeader		= "Define the colour of the Greeting List header line"
GLDG_TXT.elements.tip.ColourHelp		= "Define the colour of messages printed to the chat"

GLDG_TXT.elements.tip.ColourGuildAlias		= "Define the colour of alias names printed to the chat"
GLDG_TXT.elements.tip.ColourGuildGoOffline	= "Define the colour of messages printed to the chat about characters that have gone offline"
GLDG_TXT.elements.tip.ColourGuildIsOffline	= "Define the colour of characters that are offline when a message is printed to the chat about a character that has come online"
GLDG_TXT.elements.tip.ColourGuildOnline		= "Define the colour of the character that has just come online in the message that is printed to the chat"

GLDG_TXT.elements.tip.ColourGuildNew		= "Define the colour of an entry in the greet list for players that have just joined the guild"
GLDG_TXT.elements.tip.ColourGuildList		= "Define the colour of an entry in the greet list for players that have come online for the first time this session"
GLDG_TXT.elements.tip.ColourGuildRelog		= "Define the colour of an entry in the greet list for players that have relogged"
GLDG_TXT.elements.tip.ColourGuildLevel		= "Define the colour of an entry in the greet list for players that have levelled up"
GLDG_TXT.elements.tip.ColourGuildRank		= "Define the colour of an entry in the greet list for players that have been promoted"

GLDG_TXT.elements.tip.ColourChannelAlias	= GLDG_TXT.elements.tip.ColourGuildAlias
GLDG_TXT.elements.tip.ColourChannelGoOffline	= GLDG_TXT.elements.tip.ColourGuildGoOffline
GLDG_TXT.elements.tip.ColourChannelIsOffline	= GLDG_TXT.elements.tip.ColourGuildIsOffline
GLDG_TXT.elements.tip.ColourChannelOnline	= GLDG_TXT.elements.tip.ColourGuildLevel
GLDG_TXT.elements.tip.ColourChannelNew		= "Define the colour of an entry in the greet list for players that have just joined the channel"
GLDG_TXT.elements.tip.ColourChannelList		= GLDG_TXT.elements.tip.ColourGuildList
GLDG_TXT.elements.tip.ColourChannelRelog	= GLDG_TXT.elements.tip.ColourGuildRelog
GLDG_TXT.elements.tip.ColourChannelLevel	= GLDG_TXT.elements.tip.ColourGuildNew
GLDG_TXT.elements.tip.ColourChannelRank		= GLDG_TXT.elements.tip.ColourGuildRank

GLDG_TXT.elements.tip.ColourFriendsAlias	= GLDG_TXT.elements.tip.ColourGuildAlias
GLDG_TXT.elements.tip.ColourFriendsGoOffline	= GLDG_TXT.elements.tip.ColourGuildGoOffline
GLDG_TXT.elements.tip.ColourFriendsIsOffline	= GLDG_TXT.elements.tip.ColourGuildIsOffline
GLDG_TXT.elements.tip.ColourFriendsOnline	= GLDG_TXT.elements.tip.ColourGuildOnline
GLDG_TXT.elements.tip.ColourFriendsNew		= "Define the colour of an entry in the greet list for players that have just joined the friends list"
GLDG_TXT.elements.tip.ColourFriendsList		= GLDG_TXT.elements.tip.ColourGuildList
GLDG_TXT.elements.tip.ColourFriendsRelog	= GLDG_TXT.elements.tip.ColourGuildRelog
GLDG_TXT.elements.tip.ColourFriendsLevel	= GLDG_TXT.elements.tip.ColourGuildLevel
GLDG_TXT.elements.tip.ColourFriendsRank		= GLDG_TXT.elements.tip.ColourGuildRank

GLDG_TXT.elements.name.PlayersAlt2Box	= "Keep with main"
GLDG_TXT.elements.tip.PlayersAlt2Box	= "If this setting is enabled, alt characters will be grouped together with their main char in the character list."
GLDG_TXT.elements.name.PlayersAltBox	= "Always show alts"
GLDG_TXT.elements.tip.PlayersAltBox	= "If this setting is enabled, alt characters will be shown in the character list."
GLDG_TXT.elements.name.PlayersIgnoreBox	= "Include ignored"
GLDG_TXT.elements.tip.PlayersIgnoreBox	= "If this setting is enabled, characters which have been set to ignore using the ignore button, will still be included in the character list. Note, this is not related to placing somebody on the /ignore list"

GLDG_TXT.elements.name.PlayersAlias		= "Alias"
GLDG_TXT.elements.tip.PlayersAlias		= "Use this button to define, update or clear an alias for this character"
GLDG_TXT.elements.name.PlayersAlt		= "Alt"
GLDG_TXT.elements.tip.PlayersAlt		= "Use this button to set or unset this character as an alt character to some other (main) character"
GLDG_TXT.elements.name.PlayersIgnore		= "Ignore"
GLDG_TXT.elements.tip.PlayersIgnore		= "Use this button to not monitor the coming online and going offline of this character. Not, this is not related to placing somebody on the /ignore list."
GLDG_TXT.elements.name.PlayersMain		= "Main"
GLDG_TXT.elements.tip.PlayersMain		= "Use this button to set or unset this character as a main character"
GLDG_TXT.elements.name.PlayersSubAliasDel	= "Delete alias"
GLDG_TXT.elements.tip.PlayersSubAliasDel	= "Click this button to delete the alias for the currently selected character"
GLDG_TXT.elements.name.PlayersSubAliasSet	= "Set/Update alias"
GLDG_TXT.elements.tip.PlayersSubAliasSet	= "Use this button to set or update the alias for the currently selected character"
GLDG_TXT.elements.name.PlayersSubAliasEditbox	= "Alias"
GLDG_TXT.elements.tip.PlayersSubAliasEditbox	= "Enter the alias name you want to use for the currently selected character"
GLDG_TXT.elements.name.PlayersLine		= "Character selection"
GLDG_TXT.elements.tip.PlayersLine		= "Click on a name to manage this character"
GLDG_TXT.elements.name.PlayersSubMainAltLine	= "Choose main"
GLDG_TXT.elements.tip.PlayersSubMainAltLine	= "Click on an entry in this list to select the main character for the currently selected (alt) character"

GLDG_TXT.elements.name.FriendsAlias		= GLDG_TXT.elements.name.PlayersAlias
GLDG_TXT.elements.tip.FriendsAlias		= GLDG_TXT.elements.tip.PlayersAlias
GLDG_TXT.elements.name.FriendsAlt		= GLDG_TXT.elements.name.PlayersAlt
GLDG_TXT.elements.tip.FriendsAlt		= GLDG_TXT.elements.tip.PlayersAlt
GLDG_TXT.elements.name.FriendsIgnore		= GLDG_TXT.elements.name.PlayersIgnore
GLDG_TXT.elements.tip.FriendsIgnore		= GLDG_TXT.elements.tip.PlayersIgnore
GLDG_TXT.elements.name.FriendsMain		= GLDG_TXT.elements.name.PlayersMain
GLDG_TXT.elements.tip.FriendsMain		= GLDG_TXT.elements.tip.PlayersMain
GLDG_TXT.elements.name.FriendsSubAliasDel	= GLDG_TXT.elements.name.PlayersSubAliasDel
GLDG_TXT.elements.tip.FriendsSubAliasDel	= GLDG_TXT.elements.tip.PlayersSubAliasDel
GLDG_TXT.elements.name.FriendsSubAliasSet	= GLDG_TXT.elements.name.PlayersSubAliasSet
GLDG_TXT.elements.tip.FriendsSubAliasSet	= GLDG_TXT.elements.tip.PlayersSubAliasSet
GLDG_TXT.elements.name.FriendsSubAliasEditbox	= GLDG_TXT.elements.name.PlayersSubAliasEditbox
GLDG_TXT.elements.tip.FriendsSubAliasEditbox	= GLDG_TXT.elements.tip.PlayersSubAliasEditbox
GLDG_TXT.elements.name.FriendsLine		= GLDG_TXT.elements.name.PlayersLine
GLDG_TXT.elements.tip.FriendsLine		= GLDG_TXT.elements.tip.PlayersLine
GLDG_TXT.elements.name.FriendsSubMainAltLine	= GLDG_TXT.elements.name.PlayersSubMainAltLine
GLDG_TXT.elements.tip.FriendsSubMainAltLine	= GLDG_TXT.elements.tip.PlayersSubMainAltLine

GLDG_TXT.elements.name.ChannelAlias		= GLDG_TXT.elements.name.PlayersAlias
GLDG_TXT.elements.tip.ChannelAlias		= GLDG_TXT.elements.tip.PlayersAlias
GLDG_TXT.elements.name.ChannelAlt		= GLDG_TXT.elements.name.PlayersAlt
GLDG_TXT.elements.tip.ChannelAlt		= GLDG_TXT.elements.tip.PlayersAlt
GLDG_TXT.elements.name.ChannelIgnore		= GLDG_TXT.elements.name.PlayersIgnore
GLDG_TXT.elements.tip.ChannelIgnore		= GLDG_TXT.elements.tip.PlayersIgnore
GLDG_TXT.elements.name.ChannelMain		= GLDG_TXT.elements.name.PlayersMain
GLDG_TXT.elements.tip.ChannelMain		= GLDG_TXT.elements.tip.PlayersMain
GLDG_TXT.elements.name.ChannelSubAliasDel	= GLDG_TXT.elements.name.PlayersSubAliasDel
GLDG_TXT.elements.tip.ChannelSubAliasDel	= GLDG_TXT.elements.tip.PlayersSubAliasDel
GLDG_TXT.elements.name.ChannelSubAliasSet	= GLDG_TXT.elements.name.PlayersSubAliasSet
GLDG_TXT.elements.tip.ChannelSubAliasSet	= GLDG_TXT.elements.tip.PlayersSubAliasSet
GLDG_TXT.elements.name.ChannelSubAliasEditbox	= GLDG_TXT.elements.name.PlayersSubAliasEditbox
GLDG_TXT.elements.tip.ChannelSubAliasEditbox	= GLDG_TXT.elements.tip.PlayersSubAliasEditbox
GLDG_TXT.elements.name.ChannelLine		= GLDG_TXT.elements.name.PlayersLine
GLDG_TXT.elements.tip.ChannelLine		= GLDG_TXT.elements.tip.PlayersLine
GLDG_TXT.elements.name.ChannelSubMainAltLine	= GLDG_TXT.elements.name.PlayersSubMainAltLine
GLDG_TXT.elements.tip.ChannelSubMainAltLine	= GLDG_TXT.elements.tip.PlayersSubMainAltLine

GLDG_TXT.elements.name.ChannelDelete		= "Delete character"
GLDG_TXT.elements.tip.ChannelDelete		= "Use this button to remove a character that used to be channel member but no longer uses the channel"

GLDG_TXT.elements.name.GreetingsSelLevel	= "Level up phrases"
GLDG_TXT.elements.tip.GreetingsSelLevel		= "Press this button to define the phrases to be used when a character levels up."
GLDG_TXT.elements.name.GreetingsSelBye		= "Goodybe phrases"
GLDG_TXT.elements.tip.GreetingsSelBye		= "Press this button to define the phrases to be used when you want to say goodbye to a character"
GLDG_TXT.elements.name.GreetingsSelNight	= "Goodnight phrases"
GLDG_TXT.elements.tip.GreetingsSelNight		= "Press this button to define the phrases to be used when you want to say goodbye to a character during the night"
GLDG_TXT.elements.name.GreetingsSelRank		= "Promotion phrases"
GLDG_TXT.elements.tip.GreetingsSelRank		= "Press this button to define the phrases to be used when a character is promoted"
GLDG_TXT.elements.name.GreetingsSelJoin		= "Joining guild phrases"
GLDG_TXT.elements.tip.GreetingsSelJoin		= "Press this button to define the phrases to be used when a character joins your guild"
GLDG_TXT.elements.name.GreetingsSelDefault	= "Greeting phrases"
GLDG_TXT.elements.tip.GreetingsSelDefault	= "Press this button to define the phrases to be used when a character comes online for the first time during a session"
GLDG_TXT.elements.name.GreetingsSelRelog	= "Relog phrases"
GLDG_TXT.elements.tip.GreetingsSelRelog		= "Press this button to define the phrases to be used when a character comes back online after having been offline for some time"
GLDG_TXT.elements.name.GreetingsSelGuild	= "Greet guild"
GLDG_TXT.elements.tip.GreetingsSelGuild		= "Press this button to define the phrases to be used when you greet your guild"
GLDG_TXT.elements.name.GreetingsSelChannel	= "Greet channel"
GLDG_TXT.elements.tip.GreetingsSelChannel	= "Press this button to define the phrases to be used when you greet your channel"

GLDG_TXT.elements.name.GreetingsSelByeGuild	= "Good bye to guild"
GLDG_TXT.elements.tip.GreetingsSelByeGuild	= "Press this button to define the phrases to be used when you are saying good bye to your guild"
GLDG_TXT.elements.name.GreetingsSelNightGuild	= "Good night to guild"
GLDG_TXT.elements.tip.GreetingsSelNightGuild	= "Press this button to define the phrases to be used when you are saying good night guild"
GLDG_TXT.elements.name.GreetingsSelByeChannel	= "Good bye to channel"
GLDG_TXT.elements.tip.GreetingsSelByeChannel	= "Press this button to define the phrases to be used when you are saying good bye to your channel"
GLDG_TXT.elements.name.GreetingsSelNightChannel	= "Good night to channel"
GLDG_TXT.elements.tip.GreetingsSelNightChannel	= "Press this button to define the phrases to be used when you are saying good night to your channel"
GLDG_TXT.elements.name.GreetingsSelLaterGuild	= "See you later to guild"
GLDG_TXT.elements.tip.GreetingsSelLaterGuild	= "Press this button to define the phrases to be used when you are saying 'see you later' to your guild"
GLDG_TXT.elements.name.GreetingsSelLaterChannel	= "See you later to channel"
GLDG_TXT.elements.tip.GreetingsSelLaterChannel	= "Press this button to define the phrases to be used when you are saying 'see you later' to your channel"


GLDG_TXT.elements.name.GreetingsMsgAdd		= "Add or update phrase"
GLDG_TXT.elements.tip.GreetingsMsgAdd		= "Press this button to add or update the currently edited phrase"
GLDG_TXT.elements.name.GreetingsMsgDel		= "Remove or clear phrase"
GLDG_TXT.elements.tip.GreetingsMsgDel		= "Press this button to clear the phrase edit field or to remove the currently selected phrase from the phrase list"
GLDG_TXT.elements.name.GreetingsEditbox		= "Enter phrase"
GLDG_TXT.elements.tip.GreetingsEditbox		= "Enter the phrase to be added in this edit box"
GLDG_TXT.elements.name.GreetingsLine		= "Defined phrases"
GLDG_TXT.elements.tip.GreetingsLine		= "This list contains the currently defined phrases for the selected greeting type. Click on an existing phrase to edit or remove it"

GLDG_TXT.elements.name.GreetingsColNewDel	= "Create/remove collection"
GLDG_TXT.elements.tip.GreetingsColNewDel	= "Press this button to define a new collection of phrases or to delete an existing collection if one is selected"
GLDG_TXT.elements.name.GreetingsColPlayer	= "Set char collection"
GLDG_TXT.elements.tip.GreetingsColPlayer	= "Press this button to select a collection of phrases to be used with the current character. This can be useful to define greetings for a special character."
GLDG_TXT.elements.name.GreetingsColGuild	= "Set guild collection"
GLDG_TXT.elements.tip.GreetingsColGuild		= "Press this button to select a collection of phrases to be used with all characters in the current guild. This can be useful to define different greetings for different language guilds or a RP and non-RP guild."
GLDG_TXT.elements.name.GreetingsColRealm	= "Set realm collection"
GLDG_TXT.elements.tip.GreetingsColRealm		= "Press this button to select a collection of phrases to be used with all characters on the current realm. This can be useful to define different greetings for a RP and non-RP realm for example."
GLDG_TXT.elements.name.GreetingsCollect		= "Collection list"
GLDG_TXT.elements.tip.GreetingsCollect		= "This list contains the currently defined collections. Click on an existing collection to assign or remove it or to edit the assigned phrases"

GLDG_TXT.elements.name.GreetingsSubNewEditbox	= "Enter collection name"
GLDG_TXT.elements.tip.GreetingsSubNewEditbox	= "Enter the name of the new collection to be created in this edit box"

GLDG_TXT.elements.name.GreetingsSubNewAdd	= "Add collection"
GLDG_TXT.elements.tip.GreetingsSubNewAdd	= "Press this button to create a new collection with the name entered in the collection name edit box"
GLDG_TXT.elements.name.GreetingsSubNewCancel	= "Cancel collection"
GLDG_TXT.elements.tip.GreetingsSubNewCancel	= "Press this button to cancel the creation of a new collection"

GLDG_TXT.elements.name.GreetingsSubChangeGlobal		= "Use global defaults"
GLDG_TXT.elements.tip.GreetingsSubChangeGlobal		= "Use this button to use the standard phrases for the selected group instead of a collection"
GLDG_TXT.elements.name.GreetingsSubChangeSelection	= "Use selected collection"
GLDG_TXT.elements.tip.GreetingsSubChangeSelection	= "Use this button to use the phrases of the currently selected collection for the selected group"
GLDG_TXT.elements.name.GreetingsSubChangeClear		= "Don't use collection"
GLDG_TXT.elements.tip.GreetingsSubChangeClear		= "Use this button to not use a collection but the standard phrases for the selected group."
GLDG_TXT.elements.name.GreetingsSubChangeCancel		= "Leave unchanged"
GLDG_TXT.elements.tip.GreetingsSubChangeCancel		= "Use this button to not change the phrases to be used by the selected group"


-- Some greetings to get started: those can be changed in the configuration GUI
-- Important note: this list will only be used when no configuration is found!
-------------------------------------------------------------------------------

-- Default
GLDG_GREET = {}
GLDG_GREET[1] = "Hi %s"
GLDG_GREET[2] = "Hello %s"
GLDG_GREET[3] = "Hey %s"
-- Relogs
GLDG_GREETBACK = {}
GLDG_GREETBACK[1] = "Welcome back %s"
GLDG_GREETBACK[2] = "Hi again %s"
GLDG_GREETBACK[3] = "Hi %s, welcome back"
-- Welcome to guild
GLDG_WELCOME = {}
GLDG_WELCOME[1] = "Welcome to the guild %s"
GLDG_WELCOME[2] = "Hi %s, nice to have you in the guild"
GLDG_WELCOME[3] = "Welcome %s, good you're joining us"
-- Promotion
GLDG_RANK = {}
GLDG_RANK[1] = "Congratulations %s with your promotion to %s"
GLDG_RANK[2] = "Grats for %s on becoming %s"
-- New level
GLDG_LEVEL = {}
GLDG_LEVEL[1] = "Congratulations %s on reaching level %s"
GLDG_LEVEL[2] = "%s, grats on getting level %s"
-- Leaving (day)
GLDG_BYE = {}
GLDG_BYE[1] = "Goodbye %s"
GLDG_BYE[2] = "Bye bye %s"
-- Leaving (night)
GLDG_NIGHT = {}
GLDG_NIGHT[1] = "Goodbye %s"
GLDG_NIGHT[2] = "Bye bye %s"
GLDG_NIGHT[3] = "Good night %s"
-- Greeting guild
GLDG_GUILD = {}
GLDG_GUILD[1] = "Hi guildies"
-- Greeting channel
GLDG_CHANNEL = {}
GLDG_CHANNEL[1] = "Hi friends"
-- Good bye guild
GLDG_BYE_GUILD = {}
GLDG_BYE_GUILD[1] = "Good bye guildies"
-- Good night guild
GLDG_NIGHT_GUILD = {}
GLDG_NIGHT_GUILD[1] = "Good night guildies"
-- Good bye channel
GLDG_BYE_CHANNEL = {}
GLDG_BYE_CHANNEL[1] = "Good bye friends"
-- Good night channel
GLDG_NIGHT_CHANNEL = {}
GLDG_NIGHT_CHANNEL[1] = "Good night friends"
-- See you later guild
GLDG_LATER_GUILD = {}
GLDG_LATER_GUILD[1] = "See you later guildies"
-- See you later channel
GLDG_LATER_CHANNEL = {}
GLDG_LATER_CHANNEL[1] = "See you later friends"
