--[[
  Guild Event Manager (GEM) - Version 3
  by Kiki from European "Conseil des Ombres" (Horde)
  ----------------------------------------
  Time Stamp handling
]]

--[[
  Exported API Functions:

   GEM3_STAMP_CheckStamp(channel,pl_name,stamp)
    Input:
     channel:  string -- Name of the channel to check (real name, not GUILD constant if checking special guild channel)
     pl_name:  string -- 
     stamp:    int    -- 
    Output:
     valid: bool -- True if the stamp is correct, false otherwise
    Events:
     "OnInvalidTimeStamp"(channel,pl_name,offset) is called when 'pl_name' sent a message to 'channel' with an incorrect system time (with 'offset' seconds of error)
    Purpose:
     If I'm a TimeMaster, checks if message sent by the player is correct or not.


]]

--------------- Local variables ---------------

--------------- Internal functions ---------------

-- Return 0 if offset is acceptable, offset value otherwise
local function _GEM3_STAMP_GetErrorOffset(stamp)
  local tim = GEM3_STAMP_GetLocalStamp();
  local diff = stamp - tim;

  if(abs(diff) > GEM3_STAMP_MAX_OFFSET)
  then
    return diff;
  end
  return 0;
end


--------------- Exported functions ---------------

function GEM3_STAMP_CheckStamp(channel,pl_name,stamp,cmd,params)
  if(GEM3_QA_Config.time_ref) -- I'm a timeref
  then
    local offset = _GEM3_STAMP_GetErrorOffset(stamp);
    if(offset ~= 0)
    then
      -- Check player's message, if it's a GEM3_CMD_PLAYER_INFOS and he is a time ref too, or directly a GEM3_CMD_INCORRECT_STAMP
      if(cmd == GEM3_CMD_INCORRECT_STAMP or (cmd == GEM3_CMD_PLAYER_INFOS and params[13] == true))
      then
        if(GEM3_QA_Config.debug and GEM3_QA_Config.debug >= 1) then
          GEM3_ChatDebug(GEM3_DEBUG_WARNING,"Player "..pl_name.." has an incorrect time/date setting but is a TimeRef too. Check my settings too!!");
        end
        GEM3_COM_IncorrectTimeStamp(channel,pl_name,offset); -- Send the error message to the other player
        GEM3_COM_DisableMyself(GEM3_LOC_DISABLED_TIMEREF_CONFLICT); -- Disable all communications
        GEM3_STAMP_SetTimeRef(false); -- Disable myself as a timeref
        -- GUI Callback
        GEM3_TriggerCallback("OnTimeRefConflict",channel,pl_name,offset);
      else
        if(GEM3_QA_Config.debug and GEM3_QA_Config.debug >= 1) then
          GEM3_ChatDebug(GEM3_DEBUG_WARNING,"Player "..pl_name.." has an incorrect time/date setting");
        end
        GEM3_COM_IncorrectTimeStamp(channel,pl_name,offset); -- Send the error message to the other player
        -- GUI Callback
        GEM3_TriggerCallback("OnUserWithIncorrectTimeSettings",channel,pl_name,offset);
      end
      return false; -- Discard the message
    end
  end
  return true;
end

function GEM3_STAMP_GetLocalStamp()
  return time();
end

function GEM3_STAMP_SetTimeRef(isTimeRef)
  GEM3_QA_Config.time_ref = isTimeRef;
end

function GEM3_STAMP_IsTimeRef()
  return GEM3_QA_Config.time_ref;
end

