--[[
  Guild Event Manager (GEM) - Version 3
  by Kiki from European "Conseil des Ombres" (Horde)
  ----------------------------------------
  Sorting plugins part
]]


--------------- Shared variables ---------------

GEM3_SORT_Plugins = {};


--------------- Local variables ---------------


--------------- Internal functions ---------------

--------------- Exported functions ---------------

function GEM3_SORT_RegisterPlugin(plugin)
  if(type(plugin) ~= "table")
  then
    GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin: Passed plugin is not a table");
    return;
  end
  if(plugin.Name == nil)
  then
    GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin: Passed plugin has no 'Name' parameter");
    return;
  end
  if(type(plugin.Name) ~= "string")
  then
    GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin: Passed plugin's 'Name' value is not a string");
    return;
  end
  local name = plugin.Name;
  if(plugin.SortType == nil)
  then
    GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin '"..name.."': Passed plugin has no 'SortType' parameter");
    return;
  end
  if(type(plugin.SortType) ~= "number")
  then
    GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin '"..name.."': Passed plugin's 'SortType' value is not a number");
    return;
  end
  if(plugin.Sort == nil)
  then
    GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin '"..name.."': Passed plugin has no 'Sort' function");
    return;
  end
  if(type(plugin.Sort) ~= "function")
  then
    GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin '"..name.."': Passed plugin's 'Sort' value is not a function");
    return;
  end
  if(plugin.Configure and type(plugin.Configure) ~= "function")
  then
    GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin '"..name.."': Passed plugin's 'Configure' value is not a function");
    return;
  end
  if(plugin.Help and type(plugin.Help) ~= "string")
  then
    GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin '"..name.."': Passed plugin's 'Help' value is not a string");
    return;
  end
  -- Check for Name and SortType uniqueness
  for n,pl in pairs(GEM3_SORT_Plugins)
  do
    if(plugin.Name == n)
    then
      GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin '"..name.."': Already have a registered plugin with that name");
      return;
    end
    if(plugin.SortType == pl.SortType)
    then
      GEM3_ChatPrint("GEM3_SORT_RegisterPlugin : Failed to register plugin '"..name.."': Already have a registered plugin with that SortType");
      return;
    end
  end
  -- Ok, add plugin
  GEM3_SORT_Plugins[name] = plugin;
  if(GEM3_Events.debug and GEM3_Events.debug >= 1) then
    GEM3_ChatDebug(GEM3_DEBUG_GLOBAL,"GEM3_SORT_RegisterPlugin : Successfully loaded plugin '"..name.."'");
  end
end

function GEM3_SORT_GetSortType(sortname)
  if(sortname == nil)
  then
    return nil;
  end

  local plugin = GEM3_SORT_Plugins[sortname];
  if(plugin ~= nil)
  then
    return plugin.SortType;
  end
  return nil;
end

function GEM3_SORT_GetPlugin(sorttype)
  for name,plugin in pairs(GEM3_SORT_Plugins)
  do
    if(plugin.SortType == sorttype)
    then
      return plugin;
    end
  end
  return nil;
end


--[[
  Main sorting function.
]]
function GEM3_SORT_SortPlayers(event)
  GEM3_ChatDebug(GEM3_DEBUG_SORT,"GEM3_SORT_SortPlayers: EventID="..event.id.." - SortType="..event.sorttype);
  local plugin = GEM3_SORT_GetPlugin(event.sorttype);
  if(plugin == nil)
  then
    GEM3_ChatWarning("GEM3_SORT_SortPlayers: Cannot find selected sorting plugin ("..event.sorttype..")!");
    return false;
  end

  GEM3_ChatDebug(GEM3_DEBUG_SORT,"GEM3_SORT_SortPlayers: Calling plugin's Sort function");
  plugin.Sort(event);
end

