--[[
  Guild Event Manager (GEM) - Version 3
  by Kiki from European "Conseil des Ombres" (Horde)
  ----------------------------------------
  Debug module
]]

GEM3_DEBUG_GLOBAL      = 0x0001; -- Blanc
GEM3_DEBUG_PROTOCOL    = 0x0002; -- Jaune fonc
GEM3_DEBUG_CHANNEL     = 0x0004; -- Bleu clair
GEM3_DEBUG_EVENTS      = 0x0008; -- Vert fonc
GEM3_DEBUG_COMMANDS    = 0x0010; -- Orange clair
GEM3_DEBUG_SUBSCRIBERS = 0x0020; -- Violet fonc
GEM3_DEBUG_SORT        = 0x0040; -- Cyan clair
GEM3_DEBUG_QUEUES      = 0x0080; -- Cyan fonc
GEM3_DEBUG_WARNING     = 0x0100; -- Rouge
GEM3_DEBUG_TIMESTAMP   = 0x0200; -- Rose
GEM3_DEBUG_SYNC        = 0x0400;
GEM3_DEBUG_ALL_MASK    = 0xFFFF;

GEM3_DebugLog = {};


local _GEM3_DBG_InfosScheduled = false;
local _GEM3_DBG_INFOS_UPDATE_DELAY = 1;

-- Optims vars (get a local copy)
local bit_band = bit.band;
local tinsert = table.insert;
local strlen = string.len;

local function _GEM3_DBG_ScheduledDebugInfos()
  local tim = time();

  -- Get config infos
  local bcast = GEM3_QA_Config.my_bcast_offset;
  -- Get Queues infos
  local cmd_que_count,evt_que_count = GEM3_QUE_GetDebugInfos();
  -- GUI Callback
  GEM3_TriggerCallback("OnDebugInfos",bcast,cmd_que_count,evt_que_count);
  
  -- Reschedule routine
  if(GEM3_QA_Config.debug >= 1)
  then
    Chronos.schedule(_GEM3_DBG_INFOS_UPDATE_DELAY,_GEM3_DBG_ScheduledDebugInfos);
    _GEM3_DBG_InfosScheduled = true;
  else
    _GEM3_DBG_InfosScheduled = false;
  end
end


function GEM3_DBG_SetDebugMode(mode)
  if(not mode) then mode = 0; end
  if(mode == 1)
  then
    GEM3_QA_Config.debug = mode;
    if(not _GEM3_DBG_InfosScheduled)
    then
      Chronos.schedule(_GEM3_DBG_INFOS_UPDATE_DELAY,_GEM3_DBG_ScheduledDebugInfos);
      _GEM3_DBG_InfosScheduled = true;
    end
  else
    GEM3_QA_Config.debug = 0;
  end
  -- GUI Callback
  GEM3_TriggerCallback("OnDebugMode",mode);
end

function GEM3_ChatDebug(dbg_type,str)
  if(GEM3_QA_Config.debug and GEM3_QA_Config.debug >= 1 and GEM3_QA_Config.debug_flags and (bit_band(GEM3_QA_Config.debug_flags,dbg_type) == dbg_type))
  then
    local tab = date("*t",tim);
    local hour_str = tab.hour;
    local min_str = tab.min;
    local sec_str = tab.sec;
    
    if(strlen(hour_str) == 1)
    then
      hour_str = "0"..hour_str;
    end
    if(strlen(min_str) == 1)
    then
      min_str = "0"..min_str;
    end
    if(strlen(sec_str) == 1)
    then
      sec_str = "0"..sec_str;
    end
    local time_str = "["..hour_str..":"..min_str..":"..sec_str.."] "..str;
    -- GUI Callback
    GEM3_TriggerCallback("OnDebugMessage",dbg_type,time_str);
  end
end

function GEM3_ChatWarning(str)
  if(DEFAULT_CHAT_FRAME)
  then
    DEFAULT_CHAT_FRAME:AddMessage("GuildEventManager WARNING (please inform Kiki): "..str, 1.0, 0, 0);
  end
  GEM3_ChatDebug(GEM3_DEBUG_WARNING,str);
end

function GEM3_Todo(str)
  if(GEM3_QA_Config.debug and GEM3_QA_Config.debug >= 1)
  then
    if(DEFAULT_CHAT_FRAME)
    then
      DEFAULT_CHAT_FRAME:AddMessage("GuildEventManager TODO: "..str, 1.0, 0, 0);
    end
    GEM3_ChatDebug(GEM3_DEBUG_WARNING,str);
  end
end

function GEM3_ChatPrint(str)
  if(DEFAULT_CHAT_FRAME)
  then
    DEFAULT_CHAT_FRAME:AddMessage("GuildEventManager: "..str, 0.9, 0.8, 0.10);
  end
end

function GEM3_ChatMsg(str)
  if(DEFAULT_CHAT_FRAME)
  then
    DEFAULT_CHAT_FRAME:AddMessage(str, 0.9, 0.7, 0.10);
  end
end

function GEM3_PrintTable(tab,ofs)
  if(type(tab) ~= "table")
  then
    GEM3_ChatMsg("GEM3_PrintTable Error: Not a table");
    return;
  end
  if(ofs == nil)
  then
    GEM3_ChatMsg("Printing table: "..tostring(tab));
  end

  local myofs = ofs;
  if(myofs == nil)
  then
    myofs = " ";
  end
  for n,v in pairs(tab)
  do
    local t = type(v);
    GEM3_ChatMsg(myofs.."Param '"..n.."' (type: "..t.."): "..tostring(v));
    if(t == "table")
    then
      GEM3_PrintTable(v,myofs.." ");
    end
  end
  
  if(ofs == nil)
  then
    GEM3_ChatMsg("End of print");
  end
end

function GEM3_DBG_CheckTypes(func_name,...)
  local count = select("#",...) / 3;

  for i=1,count
  do
    local var,name,typ = select((i-1)*3+1,...);
    local typ,nilAllowed = string.gsub(typ,"-nil","");
    if(type(var) ~= typ and (nilAllowed == 0 or type(var) ~= "nil"))
    then
      error(func_name.." parameter check failed: Param '"..name.."' (#"..i..") is of type '"..type(var).."' instead of '"..typ.."'");
    end
  end
end

