--[[
  Guild Event Manager (GEM) - Version 3
  by Kiki from European "Conseil des Ombres" (Horde)
  ----------------------------------------
  Constantes
]]


-- GEM3 version
GEM3_VERSION = GetAddOnMetadata("GEM3_Core", "Version");
GEM3_COM_PROTOCOL_REVISION = 3.007;
GEM3_MIN_CONFIG_VERSION_RESET = 1.28;

-- Remove player if not logged since this time
GEM3_PLAY_LASTLOG_MAX = 60*60*24*30; -- 30 days
-- Delay btw 2 players info update
GEM3_PLAY_UPDATE_INFOS_DELAY = 45; -- 45 sec
-- Delay (min/max range) before event/command broadcast for non channel leader
GEM3_QUE_SCHEDULE_DELAY_MIN = 30;
GEM3_QUE_SCHEDULE_DELAY_MAX = 90;
-- Delay between logout/login of the same player, so we don't broadcast again
GEM3_QUE_MIN_DELAY_LOGOUT_LOGIN = 60;
-- Max timestamp offset btw TimeRef and other player
GEM3_STAMP_MAX_OFFSET = 60*15; -- 15 min
GEM3_COMM_PREFIX = "GEM3";

-- Subscription source
GEM3_SUB_SOURCE_SELF = "s";
GEM3_SUB_SOURCE_EXTERNAL = "e"; -- Name of the player who externally added this player, is concatenated
GEM3_SUB_SOURCE_WEB = "w"; -- Name of the player who subscribed this player, is concatenated
GEM3_SUB_SOURCE_TEMPLATE = "t";

-- Subscription queue wanted
GEM3_SUB_FORCE_QUEUE_NONE = 0;
GEM3_SUB_FORCE_QUEUE_TITULAR = 1;
GEM3_SUB_FORCE_QUEUE_SUBSTITUTE = 2;
GEM3_SUB_FORCE_QUEUE_REPLACEMENT = 3;
GEM3_SUB_FORCE_QUEUE_NOT_COMING = 4;

-- Subscription State - used by GEM3_Player struct (server side) and GEM3_Subscription struct (client side)
GEM3_SUB_STATE_NONE = 0;
GEM3_SUB_STATE_TITULAR = 1;
GEM3_SUB_STATE_SUBSTITUTE = 2;
GEM3_SUB_STATE_REPLACEMENT = 3;
GEM3_SUB_STATE_NOT_COMING = 4;
GEM3_SUB_STATE_NOT_ACKED = 5;
GEM3_SUB_STATE_DISCARD = 6; -- Internal
GEM3_SUB_STATE_UNSUBSCRIBING = 7;

-- Subscription error codes
GEM3_SUB_ERROR_LEVEL_RANGE = 1;
GEM3_SUB_ERROR_BANNED = 2;
GEM3_SUB_ERROR_KICKED = 3;
GEM3_SUB_ERROR_UNKNOWN_EVENT = 4;
GEM3_SUB_ERROR_DEADLINE = 5;

-- Class Role
GEM3_ROLE_UNKNOWN = 0;
GEM3_ROLE_TANK = 1;
GEM3_ROLE_CDPS = 2;
GEM3_ROLE_RDPS = 4;
GEM3_ROLE_DPS = 6;
GEM3_ROLE_HEAL = 8;

-- Event types
GEM3_EVT_TYPE_NONE = 0;
GEM3_EVT_TYPE_TEST = 1;
GEM3_EVT_TYPE_RESET = 2;
GEM3_EVT_TYPE_LFG = 10;
GEM3_EVT_TYPE_POLL = 11;
GEM3_EVT_TYPE_PLAYER_AVALABILITY = 12;
GEM3_EVT_TYPE_RAID_AVAILABILITY = 13;
GEM3_EVT_TYPE_INSTANCE5 = 20;
GEM3_EVT_TYPE_INSTANCE5_BC = 21;
GEM3_EVT_TYPE_INSTANCE5_WOTLK = 22;
GEM3_EVT_TYPE_INSTANCE5_BCH = 23;
GEM3_EVT_TYPE_INSTANCE5_WOTLKH = 24;
GEM3_EVT_TYPE_RAID = 30;
GEM3_EVT_TYPE_RAID_BC = 31;
GEM3_EVT_TYPE_RAID_WOTLK = 32;
GEM3_EVT_TYPE_PVP = 40;
GEM3_EVT_TYPE_GUILD_EVENT = 60;
GEM3_EVT_TYPE_GUILD_OFFICERMEETING = 61;

-- Instance tags
GEM3_INST_TAG_NONE = 0x0000;
GEM3_INST_TAG_KARA = 0x0001;
GEM3_INST_TAG_ZA = 0x0002;
GEM3_INST_TAG_MAGTH = 0x0004;
GEM3_INST_TAG_GRUUL = 0x0008;
GEM3_INST_TAG_SSC = 0x0010;
GEM3_INST_TAG_EYE = 0x0020;
GEM3_INST_TAG_HYJAL = 0x0040;
GEM3_INST_TAG_BT = 0x0080;
GEM3_INST_TAG_SWP = 0x0100;
-- Keep room for WOTLK instances
GEM3_INST_TAG_MC = 0x02000000;
GEM3_INST_TAG_ZG = 0x04000000;
GEM3_INST_TAG_AQ20 = 0x08000000;
GEM3_INST_TAG_AQ40 = 0x10000000;
GEM3_INST_TAG_NAX = 0x20000000;
GEM3_INST_TAG_BWL = 0x40000000;
GEM3_INST_TAG_ONY = 0x80000000;

-- GEM3_ChannelPlayer field access
GEM3_ACCESS_INST_TAG_ID = 1;
GEM3_ACCESS_INST_TAG_RESET = 2;

-- Action for incomming event
GEM3_EVT_ACTION_DISCARD        = 0;
GEM3_EVT_ACTION_NEW            = 1;
GEM3_EVT_ACTION_UPDATED        = 2;
GEM3_EVT_ACTION_CRASHED        = 3;
GEM3_EVT_ACTION_RECOVER_UPDATE = 4;

-- Internal error texts (should be in localization file)
GEM3_INTERNAL_ERROR_1 = "Internal Error #1. Please contact Kiki";
GEM3_INTERNAL_ERROR_2 = "Internal Error #2. Please contact Kiki";
GEM3_INTERNAL_ERROR_3 = "Internal Error #3. Please contact Kiki";

