--[[
  Guild Event Manager (GEM) - Version 3
  by Kiki from European "Conseil des Ombres" (Horde)
  ----------------------------------------
  CMD module
]]

--------------- Saved variables ---------------

--------------- Shared variables ---------------

--------------- Local variables ---------------
GEM3_Saved_ScheduledTaskInterval = GEM3_COM_ScheduledTaskInterval;

--------------- Hooked functions ---------------

--------------- Internal functions ---------------

local function _GEM3_CMD_ListIgnoredEvents()
  GEM3_ChatPrint("List of ignored events :");
  for id,val in pairs(GEM3_QA_Events.ignored)
  do
    local event = GEM3_QA_Events.events[id];
    if(event ~= nil)
    then
      GEM3_ChatPrint(" - EventId '"..id.."' by '"..event.leader.."' at '"..event.ev_place.."' with comment '"..event.ev_comment.."'");
    end
  end
  GEM3_ChatPrint("End of List");
end

local function _GEM3_CMD_UnignoreEvent(eventId)
  GEM3_QA_Events.ignored[eventId] = nil;
  GEM3_ChatPrint("EventID '"..eventId.."' unignored");
  GEM3_NotifyGUI(GEM3_NOTIFY_EVENT_UPDATE,eventId);
end

local function _GEM3_CMD_ListIgnoredPlayers()
  local banned = GEM3_Defaults_Banned[GEM3_Realm];
  GEM3_ChatPrint("List of banned players :");
  for name in pairs(GEM3_QA_Events.ignored_players)
  do
    if(banned and banned[name])
    then
      GEM3_ChatPrint(" - "..name.." (default ban)");
    else
      GEM3_ChatPrint(" - "..name);
    end
  end
  GEM3_ChatPrint("End of List");
end

local function _GEM3_CMD_UnignorePlayer(pl_name)
  local banned = GEM3_Defaults_Banned[GEM3_Realm];
  if(banned and banned[pl_name])
  then
    GEM3_ChatPrint("Player '"..pl_name.."' is 'forced banned' from the GEM3_defaults.lua file. You must remove the name from the file before using the '/gem unban' command !");
  else
    GEM3_QA_Events.ignored_players[pl_name] = nil;
    GEM3_ChatPrint("Player '"..pl_name.."' unbanned");
  end
end

--------------- Exported functions ---------------

function GEM3_CMD_Help()
  GEM3_ChatPrint("/gem toggle : Shows or hides the GUI (you can also assign a key in your shortcuts)");
  GEM3_ChatPrint("/gem join : Rejoin GEM channels, if auto-join failed");
  GEM3_ChatPrint("/gem channels : Lists current GEM channels");
  GEM3_ChatPrint("/gem addchan <Name> [<Password>] : Adds a new GEM channel with password (optional)");
  GEM3_ChatPrint("/gem delchan <Name> : Removes a current GEM channel");
  GEM3_ChatPrint("/gem setdefchan <Name> : Changes the default channel for 'New events'");
  GEM3_ChatPrint("/gem setalias <ChannelName> <Alias> <SlashCmd> : Sets alias/slashcmd for this channel");
  GEM3_ChatPrint("/gem delalias <ChannelName> : Removes alias and slashcmd for this channel");
  GEM3_ChatPrint("/gem delchar <CharName> : Removes one of your Characters from the dropdown list in subscribe and new event tabs");
  GEM3_ChatPrint("--- ADVANCED COMMANDS ---");
  GEM3_ChatPrint("/gem offset <hours> : Forces an offset from the server (in hours, can be negative)");
  GEM3_ChatPrint("/gem ignored : List all ignored events");
  GEM3_ChatPrint("/gem unignore : Un ignore an event");
  GEM3_ChatPrint("/gem banned : List all ignored players");
  GEM3_ChatPrint("/gem unban : Un ban a player");
  GEM3_ChatPrint("/gem scale <scale value> : Sets the GEM windows scale value");
  GEM3_ChatPrint("/gem events : Displays all incoming events");
  GEM3_ChatPrint("/gem archive <EventID> : Archives an expired Event");
  GEM3_ChatPrint("--- Debug commands ---");
  GEM3_ChatPrint("/gem debug <1/2/0> : Sets or not debug mode (2=debug+log)");
  GEM3_ChatPrint("/gem pause <on/off> : Quick dirty hack to *pause* GEM");
end

function GEM3_CMD_Command(cmd,param)
  if(cmd == "toggle")
  then
    GEM3_Toggle();
    return true;

  elseif(cmd == "pause")
  then
    if(param == "on")
    then
      GEM3_Paused = true;
      GEM3_ChatPrint("GEM is paused");
      -- Temp leave channels
      for name,chantab in pairs(GEM3_COM_Channels)
      do
        GEM3_COM_LeaveChannel(name);
        GEM3_COM_PurgeQueueMessageForChannel(name);
      end
      GEMMinimapButtonText:SetText("P");
      GEM3_Saved_ScheduledTaskInterval = GEM3_COM_ScheduledTaskInterval;
      GEM3_COM_ScheduledTaskInterval = 60;
    elseif(param == "off")
    then
      GEM3_COM_ScheduledTaskInterval = GEM3_Saved_ScheduledTaskInterval;
      GEM3_Paused = false;
      GEM3_ChatPrint("GEM is no longer paused");
      GEMMinimapButtonText:SetText("");
      GEM3_InitChannels(false);
    else
      GEM3_ChatPrint("Unknown param to pause command: '"..param.."'");
    end
    return true;

  elseif(cmd == "ignored")
  then
    _GEM3_CMD_ListIgnoredEvents();
    return true;
  elseif(cmd == "unignore")
  then
    if(param == "")
    then
      GEM3_ChatPrint("Missing parameter for 'unignore' option");
      return true;
    end
    if(GEM3_QA_Events.events[param] == nil)
    then
      GEM3_ChatPrint("Unknown EventID '"..param.."'");
      return true;
    end
    if(GEM3_QA_Events.ignored[param] == nil)
    then
      GEM3_ChatPrint("EventID '"..param.."' not currently ignored");
      return true;
    end
    _GEM3_CMD_UnignoreEvent(param);
    return true;

  elseif(cmd == "banned")
  then
    _GEM3_CMD_ListIgnoredPlayers();
    return true;
  elseif(cmd == "unban")
  then
    if(param == "")
    then
      GEM3_ChatPrint("Missing parameter for 'unban' option");
      return true;
    end
    if(GEM3_QA_Events.ignored_players[param] == nil)
    then
      GEM3_ChatPrint("Player '"..param.."' not currently banned");
      return true;
    end
    _GEM3_CMD_UnignorePlayer(param);
    return true;

  elseif(cmd == "debug")
  then
    if(param == "1")
    then
      GEM3_DBG_SetDebugMode(1,true);
      GEM3_ChatPrint("Debug mode ON");
    elseif(param == "2")
    then
      GEM3_DBG_SetDebugMode(2,true);
      GEM3_ChatPrint("Debug mode ON WITH LOG");
    else
      GEM3_DBG_SetDebugMode(0,true);
      GEM3_ChatPrint("Debug mode OFF");
    end
    return true;

  elseif(cmd == "join")
  then
    GEM3_InitChannels(false);
    return true;
  elseif(cmd == "channels")
  then
    GEM3_ChatPrint("GEM channels list : <Name> : <Password> : <Alias> : <SlashCmd>");
    for channame, tab in pairs(GEM3_COM_Channels)
    do
      local def = "";
      if(channame == GEM3_DefaultSendChannel)
      then
        def = "(Default channel for 'New events')";
      end
      local pwd = tab.password;
      if(pwd == nil or pwd == "")
      then
        pwd = "(no password)";
      end
      local alias = tab.alias;
      if(alias == nil or alias == "")
      then
        alias = "(no alias)";
      end
      local slash = tab.slash;
      if(slash == nil or slash == "")
      then
        slash = "(no slash)";
      end
      GEM3_ChatPrint(" - "..channame.." "..def.." : "..pwd.." : "..alias.." : "..slash);
    end
    GEM3_ChatPrint("End of listing");
    return true;

  elseif(cmd == "addchan")
  then
    if(not param or param == "")
    then
      GEM3_ChatPrint("Need to specify a channel name");
      return true;
    end
    local _,_,chan,pwd = string.find(param,"([^%s]+)%s*(.*)");
    if(not chan)
    then
      GEM3_ChatPrint("Need to specify a channel name");
      return true;
    end
    GEMOptions_AddChannel(chan,pwd,"","");
    GEM3_ChatPrint("Channel "..chan.." added !");
    return true;

  elseif(cmd == "delchan")
  then
    if(not param or param == "")
    then
      GEM3_ChatPrint("Need to specify a channel name");
      return true;
    end
    if(not GEM3_COM_Channels[param])
    then
      GEM3_ChatPrint("Unknown GEM channel "..param);
      return true;
    end
    GEMOptions_RemoveChannel(param);
    GEM3_ChatPrint("Channel "..param.." removed !");
    return true;

  elseif(cmd == "setdefchan")
  then
    if(not param or param == "")
    then
      GEM3_ChatPrint("Need to specify a channel name");
      return true;
    end
    if(not GEM3_COM_Channels[param])
    then
      GEM3_ChatPrint("Unknown GEM channel "..param);
      return true;
    end
    GEM3_DefaultSendChannel = param;
    GEM3_ChatPrint("Channel "..param.." set as default one for New events !");
    return true;

  elseif(cmd == "setalias")
  then
    if(not param or param == "")
    then
      GEM3_ChatPrint("Need to specify a channel");
      return true;
    end
    local _,_,chan,alias,slash = string.find(param,"([^%s]+)%s+([^%s]+)%s+([^%s]+)");
    if(chan == nil or alias == nil or slash == nil or chan == "" or alias == "" or slash == "")
    then
      GEM3_ChatPrint("Need to specify a channel, an alias and a slashcmd");
      return true;
    end
    if(not GEM3_COM_Channels[chan])
    then
      GEM3_ChatPrint("Unknown GEM channel "..chan);
      return true;
    end
    for i,chantab in pairs(GEM3_QA_Config.channels)
    do
      if(chantab.name == chan)
      then
        chantab.alias = alias;
        chantab.slash = slash;
        break;
      end
    end
    GEM3_COM_Channels[chan].alias = alias;
    GEM3_COM_Channels[chan].slash = slash;
    GEM3_COM_AliasChannel(chan,GEM3_COM_Channels[chan].alias,GEM3_COM_Channels[chan].slash);
    GEM3_ChatPrint("Alias and SlashCmd for channel "..chan.." set to : "..alias.." : "..slash);
    return true;

  elseif(cmd == "delalias")
  then
    if(not param or param == "")
    then
      GEM3_ChatPrint("Need to specify a channel");
      return true;
    end
    if(not GEM3_COM_Channels[param])
    then
      GEM3_ChatPrint("Unknown GEM channel "..param);
      return true;
    end
    for i,chantab in pairs(GEM3_QA_Config.channels)
    do
      if(chantab.name == param)
      then
        chantab.alias = "";
        chantab.slash = "";
        break;
      end
    end
    GEM3_COM_UnAliasChannel(param,GEM3_COM_Channels[param].alias,GEM3_COM_Channels[param].slash);
    GEM3_COM_Channels[param].alias = "";
    GEM3_COM_Channels[param].slash = "";
    GEM3_ChatPrint("Removed Alias and SlashCmd for channel "..param);
    return true;

  elseif(cmd == "offset")
  then
    local hours = tonumber(param);
    if(hours == nil)
    then
      GEM3_QA_Config.ForceHourOffset = nil;
      GEM3_ChatPrint("Removing Forced hours offset !");
    else
      if(hours > 24 or hours < -24)
      then
        GEM3_ChatPrint("Hour offset value must be <24 and >-24");
      end
      GEM3_QA_Config.ForceHourOffset = hours;
      GEM3_ChatPrint("Forced hour offset to "..hours.." hours !");
    end
    GEM3_ServerOffset = 666;
    GEM3_ComputeServerOffset();
    GEMNew_Reset();
    return true;

  elseif(cmd == "scale")
  then
    local value = tonumber(param);
    if(value == nil)
    then
      GEM3_ChatPrint("Incorrect scale value (must be a number) : "..tostring(param));
    else
      GEM3_QA_Config.scale = value;
      GEM3_ChatPrint("Scale value set to "..value);
    end
    return true;

  elseif(cmd == "events")
  then
    GEM3_ChatPrint("List of incoming events:");
    for id,event in pairs(GEM3_QA_Events.events)
    do
      if(GEM3_CHAN_IsChannelActive(event.channel))
      then
        GEM3_ChatPrint(" - EventId '"..id.."' (channel '"..event.channel.."') by '"..event.leader.."' at '"..event.ev_place.."' "..GEM3_ConvertDateFormat(date(GEM3_QA_Config.DateFormat,event.ev_date + GEM3_ComputeHourOffset())));
      end
    end
    GEM3_ChatPrint("End of List");
    return true;

  elseif(cmd == "archive")
  then
    local event = GEM3_QA_Events.events[param];
    if(event == nil)
    then
      GEM3_ChatPrint("Unknown EventID : "..tostring(param));
      return true;
    end
    local tim = time();
    if(event.ev_date == nil)
    then
      return true;
    end
    --if(event.ev_date < (tim-GEM3_GetOffsetTime(param)))
    --then
      GEM3_QA_Events.archived[param] = GEM3_QA_Events.events[param];
      GEM3_ChatWarning("ArchiveEvent: WARNING: Shared 'event table' will be destroyed when event is closed");
      GEM3_ChatPrint("EventID "..param.." archived !");
    --else
      --GEM3_ChatPrint("Cannot archive an incoming event");
    --end
    return true;

  elseif(cmd == "delchar")
  then
--~     if(GEM3_QA_Events.my_names[param] == nil)
--~     then
--~       GEM3_ChatPrint("Unknown character : "..tostring(param));
--~       return true;
--~     end
--~     if(param == GEM3_PlayerName)
--~     then
--~       GEM3_ChatPrint("Cannot remove current character !");
--~       return true;
--~     end
--~     GEM3_QA_Config.my_names[param] = nil;
--~     GEM3_ChatPrint("Character '"..param.."' removed !");
--~     return true;
GEM3_ChatPrint("'delchar' command: TODO");
  end
  return false;
end
