﻿--[[
 Guild Event Manager GUI
 -------------------------------------
  Code: Movix - Conseil des Ombres - EU
  Main  
]]




function GEM3UI_Reset()
 if GEM3UI_ResetCore:GetChecked() then
  GEM3_DebugLog={};
  GEM3_Config={};
  GEM3_Events={};
  GEM3_Players={};
  GEM3_ExternalCommands={};
 end
 
 if GEM3UI_ResetTemplates:GetChecked() then
  GEM3UI.Templates = nil;
 end
 
 if GEM3UI_ResetUI:GetChecked() then
  GEM3UI = nil;
 end
 ReloadUI();
end


--- INITIALIZATION

function  GEM3UI_Init()
 local plname = UnitName("player"); 
 
 GEM3UI_PlayerVersions = {};

------ READING SV

--- MAJOR RELEASE CHANGE INIT
 if GEM3UI.VersionMajor ~= GEM3UI_MAJOR then
  GEM3UI={};
  GEM3UI.VersionMajor = GEM3UI_MAJOR;
  GEM3UI.VersionMinor = GEM3UI_MINOR;
  GEM3UI.Revision     = GEM3UI_REVISION;
 end

--- MINOR RELEASE CHANGE INIT 
 if GEM3UI.VersionMinor ~= GEM3UI_MINOR then 
   if GEM3UI.VersionMinor or 0 < 3 then
    GEM3UI={};
   end
   GEM3UI.VersionMinor = GEM3UI_MINOR;
   GEM3UI.Revision     = GEM3UI_REVISION;
 end
 
--- REVISION RELEASE CHANGE INIT 
 if GEM3UI.Revision ~= GEM3UI_REVISION then 
   GEM3UI.Revision     = GEM3UI_REVISION;
   GEM3UI[plname] = nil;
   GEM3UI.WindowState = nil
 end

--- FIRST RUN INIT
 if GEM3UI.Firstrun               == nil then
   GEM3UI.ShowTooltips = true;
   GEM3UI.ShowMinimapIcon = true;
   GEM3UI.AutoSubscribe = false;
   GEM3UI.ShowTooltips = true;
   GEM3UI.NotifySound = false;
   GEM3UI.NotifySubs = false;
   GEM3UI.NotifyNew = true;
   GEM3UI.NotifyOwn = true;
   GEM3UI.NotifyEdit = true;
   GEM3UI.NotifyDateChange = true;
   GEM3UI.NotifyKickBan = true;
   GEM3UIRUNCFGWIZ = true;
   GEM3UI.WindowState = 0
   GEM3UI.Firstrun = "DONE1"
 end
GEM3UI.InvitePeriod = 15;
--- GENERAL INITS
 if GEM3UI                     == nil then GEM3UI = {};                       end
 if GEM3UI.Templates           == nil then GEM3UI.Templates = {};             end
 if GEM3UI[plname]             == nil then GEM3UI[plname]  = {};              end

 if GEM3UI.InvitePeriod        == nil then GEM3UI.InvitePeriod = 3*60;        end

 if GEM3UI.VersionMajor        == nil then GEM3UI.VersionMajor = GEM3UI_MAJOR;end
 if GEM3UI.VersionMinor        == nil then GEM3UI.VersionMinor = GEM3UI_MINOR;end
 if GEM3UI.Revision            == nil then GEM3UI.Revision     = GEM3UI_REVISION;end

-- Main FRAME an Minimap Icon settings
 if GEM3UI.Scale               == nil then GEM3UI.Scale = 1;                  end
 if GEM3UI.WindowState         == nil then GEM3UI.WindowState = 1;            end --0 = full, 1 = half, 2 = small     
 if GEM3UI.MinimapRadius       == nil then GEM3UI.MinimapRadius = Minimap:GetWidth()/4; end
 if GEM3UI.MinimapAngle        == nil then GEM3UI.MinimapAngle = 180;         end
 if GEM3UI.MinimapIcon         == nil then GEM3UI.MinimapIcon = "Spell_Nature_TimeStop"; end
 if GEM3UI.WindowPosX          == nil then GEM3UI.WindowPosX = (GetScreenWidth()*UIParent:GetEffectiveScale()/2)+(GEM3UI_MainWidth/2); end
 if GEM3UI.WindowPosY          == nil then GEM3UI.WindowPosY = (GetScreenHeight()*UIParent:GetEffectiveScale()/2)+(GEM3UI_MainHeight/2); end
-- Calendar and Date settings
 if GEM3UI.FirstWeekday        == nil then GEM3UI.FirstWeekday = 1;           end -- true = lundi, false = dimanche
-- if GEM3UI.FirstWeekday == false then GEM3UI_FirstWeekday = 0; else GEM3UI_FirstWeekday = 1; end
 if GEM3UI.DateFormat          == nil then GEM3UI.DateFormat = true;          end -- true= d/m/y, false = y/m/d
 if GEM3UI.TimeFormat          == nil then GEM3UI.TimeFormat = true;          end -- true= 24h, false = 12h
 if GEM3UI.DateSeparator       == nil then GEM3UI.DateSeparator = "/";        end
 if GEM3UI.CalCol              == nil then GEM3UI.CalCol = GEM3UI_calcol;     end
 if GEM3UI.DayCol              == nil then GEM3UI.DayCol = GEM3UI_daycol;     end
 if GEM3UI.CalText             == nil then GEM3UI.CalText = GEM3UI_caltext;   end
-- General settings
 if GEM3UI.ServerTimeOffSet    == nil then GEM3UI.ServerTimeOffSet = 0;       end
 if GEM3UI.DefaultHour         == nil then GEM3UI.DefaultHour = 20;           end
 if GEM3UI.DefaultMinute       == nil then GEM3UI.DefaultMinute = 30;         end
 if GEM3UI.DefaultDuration     == nil then GEM3UI.DefaultDuration = 60*60*3;  end
 if GEM3UI.ArchiveBeforeDelete == nil then GEM3UI.ArchiveBeforeDelete = false end

-- Player specific settings
 if GEM3UI[plname].OnlyMyChannels == nil then GEM3UI[plname].OnlyMyChannels = false; end

-- Eventype filtering
 if GEM3UI[plname].EvenTypeFilters == nil then GEM3UI[plname].EvenTypeFilters = {};             end
 for evtypeid, evtype in pairs (GEM3UI_LocalizedStrings.EventTypes) do
  if 
   GEM3UI[plname].EvenTypeFilters[evtypeid] == nil then GEM3UI[plname].EvenTypeFilters[evtypeid] = true;
   evtype.state = true;
  else
   evtype.state = GEM3UI[plname].EvenTypeFilters[evtypeid];
  end
 end

----- INIT RUNTIME VARS
 GEM3UI_NEEDUPDATE = "";

 if GEM3UI.DateFormat == false then 
  GEM3UI_DateFormatString = "%y"..GEM3UI.DateSeparator.."%m"..GEM3UI.DateSeparator.."%d";
 else
  GEM3UI_DateFormatString = "%d"..GEM3UI.DateSeparator.."%m"..GEM3UI.DateSeparator.."%y";
 end
 
 if GEM3UI.TimeFormat == false then 
  GEM3UI_TimeFormatString = "%I:%M %p";
 else
  GEM3UI_TimeFormatString = "%H:%M";
 end
 
 GEM3UICFG_tabid = 1;
  
 GEM3UI_calcol = GEM3UI.CalCol;
 GEM3UI_daycol = GEM3UI.DayCol;
 GEM3UI_caltext = GEM3UI.CalText;
 
 --GEM3_NewEvents = 0;
 
----- FINISH INITIALIZING 
 GEM3UI_ContextFrame="GEM3UIDay";
 
 if GEM3UI.ChannelFilter == nil then GEM3UI.ChannelFilter = {}; end
 for i, channel in ipairs(GEM3_QA_Config.channels) do
  if GEM3_PLAY_IsPlayerInChannel(channel.name,UnitName("player")) then
    if GEM3UI.ChannelFilter[channel.name] == nil then GEM3UI.ChannelFilter[channel.name] = true; end
  end
  GEM3UI_EventChannelFilters[channel.name] = GEM3UI.ChannelFilter[channel.name];
 end
 GEM3UI_EventChannelFilterTextLabel:SetText(GEM3UI_LocalizedStrings["_Channels"]);

 GEM3UI_DDMenuFrame = CreateFrame("FRAME", "GEM3UI_DDMenuFrame", nil, "UIDropDownMenuTemplate");

 if GEM3UI.UseServerTime then
  GEM3UI_EventlistDateColumnHeaderLabel:SetText(GEM3UI_LocalizedStrings["_Date"] .. " ("..GEM3UI_LocalizedStrings["_server"]..")");
 else
  GEM3UI_EventlistDateColumnHeaderLabel:SetText(GEM3UI_LocalizedStrings["_Date"] .. " ("..GEM3UI_LocalizedStrings["_local"]..")");
 end

--- Version Checking
 GEM3UI_HIGHEST_MAJOR = GEM3UI_MAJOR;
 GEM3UI_HIGHEST_MINOR = GEM3UI_MINOR;
 GEM3UI_HIGHEST_REV = GEM3UI_REVISION;


 GEM3UI_LoadCFGPage();
 GEM3UIMain:SetScript("OnSizeChanged", GEM3UI_Resizing);
 GEM3UI_RegisterPlugin();
 GroupAnalyse.RegisterForEvents(GEM3UI_InviteProcess);


 if GEM3UIMain:IsVisible() then 
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
 end

end


function GEM3UI_SendMyVersion()
 GEM3_COM_SendCustomMessage(GEM3_GuildChannelName,"GEM3UI_UIVersionReply", GEM3UI_MAJOR, GEM3UI_MINOR, GEM3UI_REV);
end

function GEM3UI_UIVersionReply(chan, player, stamp, major, minor, revision)
 if GEM3UI_PlayerVersions[chan] == nil then 
  GEM3UI_PlayerVersions[chan] = {};
 end
 GEM3UI_PlayerVersions[chan][player] = {MAJOR = major, MINOR = minor, REVISION = revision}; 
end

function _GEM3UI_CM_SENDVER (chan, player, stamp, major, minor, revision, hmajor, hminor, hrevision)
 local senderhas = GEM3UI_SAMEVERSION;
 local color = {1,0,0};
 if msgsend== nil then msgsend=false; end
 local H = GEM3UI_HIGHEST_MAJOR.."."..GEM3UI_HIGHEST_MINOR.."."..GEM3UI_HIGHEST_REV;
 local h = (hmajor or "").."."..(hminor or "").."."..(hrevision or "");
 if H < h then
  GEM3UI_HIGHEST_MAJOR = hmajor;
  GEM3UI_HIGHEST_MINOR = hminor;
  GEM3UI_HIGHEST_REV = hrevision;
  GEM3UI_HIGHEST_SOURCE = player;
  DEFAULT_CHAT_FRAME:AddMessage(GEM3UI_LocalizedStrings["YouHaveAnOutdatedVersion"], unpack(color));
  DEFAULT_CHAT_FRAME:AddMessage(string.format(GEM3UI_LocalizedStrings["PlayerKnowNewerVersion"], player, chan, hmajor,hminor,hrevision or 0), unpack(color));
 end
end




-- FUNCTION LINKED TO SLASH COMMAND /GEMUI
function GEM3UI_show(arg1)
 if arg1 == "" then GEM3UIMain:Show(); end
 if arg1 == "reset" then
  if GEM3UIMain:IsVisible() then GEM3UIMain:Hide(); end
  GEM3UIReset:Show()
 end 
end


-- FRAME EVENT HANDLER

function GEM3UI_MainOnShow()
   GEM3_NewEvents = 0;
   GEM3MinimapButton_Update();
   GEM3UIMain:SetScale(GEM3UI.Scale);
   gemuipopulate();
   local cal = getglobal("GEM3UICalendar");
   GEM3UI_today = date ("*t");
   if (GEM3UICalendar:IsVisible()) then
    MovixLibCreateCalendar(cal, GEM3UI_today.month, GEM3UI_today.year);
    GEM3UI_HilightDay(cal.SELDAY, cal);
   end
   if (GEM3UIMainMainPanel:IsVisible()) then
    GEM3UI_EventListScrollUpdate();
   end
   GEM3UI_CalHighlightSubstDays();
   
      
   GEM3UIMain:ClearAllPoints();
   GEM3UIMain:SetPoint("TOPRIGHT", UIParent, "BOTTOMLEFT", GEM3UI.WindowPosX, GEM3UI.WindowPosY);
   GEM3UIMain:SetWidth(GEM3UI_MainWidth);
   GEM3UIMain:SetHeight(GEM3UI_MainHeight);
   
   local state = GEM3UI.WindowState;
   for i=this.state+1,state do
    GEM3UI_Collapse();
   end
   if GEM3UIRecoverFrame:IsVisible() then
    this:Hide();
   end
   
   if GEM3UI.WindowState == 0 then
    GEM3UIMainTitelLabel:SetText(GEM3UI_LocalizedStrings["_lblTitle"].." V."..GEM3_GetVersion());
    GEM3UIMainAlertLabel:SetText(GEM3UI_NEEDUPDATE);
   else
    GEM3UIMainTitelLabel:SetText("GEM 3");
    GEM3UIMainAlertLabel:SetText("");
   end
   if getglobal("GEM3UIEventListToolbar"):IsVisible() then 
    GEM3UI_BuildToolBar();
   end
end

function GEM3UI_MainStartMoving()
 --local fr = GEM3UIeventDetails;
 --if fr:IsVisible() then
  --fr.wasVisible = true;
  --fr:Hide();
 --else
  --fr.wasVisible = false;
 --end
 --GEM3UI_MainFrameHideShowcontent("HIDE");
 this:StartMoving();
end

function GEM3UI_MainStopMoving()
local fr = GEM3UIeventDetails;
 --GEM3UIMainMainPanel
 --if fr.wasVisible then
  --fr:Show();
 --end
 this:StopMovingOrSizing();
 GEM3UI.WindowPosX = GEM3UIMain:GetRight();
 GEM3UI.WindowPosY = GEM3UIMain:GetTop();
 GEM3UIMain:ClearAllPoints();
 GEM3UIMain:SetPoint("TOPRIGHT", UIParent, "BOTTOMLEFT", GEM3UI.WindowPosX, GEM3UI.WindowPosY);
 --GEM3UI_MainFrameHideShowcontent("SHOW");
end



function GEM3UI_Toggle()
  if (GEM3UIMain:IsVisible()) then
    GEM3UIMain:Hide();
  else
    GEM3UIMain:Show();
  end
end





-- Global UI refresh function 

function GEM3UI_RefreshView(reason, ...)
 if GEM3UI_InitTerminated ~= true then return; end
 if not GEM3UIMain:IsVisible() then return end
 if reason == nil then return; end
 local expline = getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine); 
 if reason == "GEM3UI_REFRESH_CLOSEONLY" then
  if expline ~= nil then
    GEM3UI_ExpandEventLine(expline, true);
  end   
  return;
 end
--- Evenlist visible
 if GEM3UIMainMainPanelEventListMain:IsVisible() then
   local expline = getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine); 
   mydbg("Eventlist visible");
   if reason == "GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE" then
      local close, line, event = select(1,...)
      if expline ~= nil then
       if close == "CLOSE" and (line == "SELF" or line == nil) then
         if MyEvent[expline.ev_index].id == event.id then
          gemuipopulate();
          GEM3UI_DisplayDaydetails();
          GEM3UI_EventListScrollUpdate();
          GEM3UI_ExpandEventLine(expline, true);
         end
       end
       GEM3UI_EventLinePopulate(expline);
      else
        gemuipopulate();
        GEM3UI_EventListScrollUpdate();
      end
   else
    if not GEM3UI_ShowArchive:GetChecked() and not GEM3UI_ShowTemplates:GetChecked() then
      for i=1,GEM3UI_DefaultLines do
          local line = getglobal("GEM3UI_lineFrame"..i)
          if line:IsVisible() then
            mydbg("line visible");
          
            local ev = GEM3UI_EventSource[MyEvent[line.ev_index].id]
            
            if reason == "GEM3UI_REFRESH_EVENT_UPDATE" then
             mydbg("Event update");
             local id = select (1,...);
             if ev.id == id then
              gemuipopulate();
              GEM3UI_fillLine(i, line.ev_index);
              mydbg("Event update : "..id);
             end
            end

            if reason == "GEM3UI_REFRESH_LEADERS" then
             mydbg("Leader update");
             local leader = select (1,...);
             if ev.leader == leader then
              GEM3UI_fillLine(i, line.ev_index);
              mydbg("Leader update : "..leader);
             end
            end --- refresh Leader or Event update
            
            if expline ~= nil then
               mydbg("Event open");
               GEM3UI_EventLinePopulate(expline);
               GEM3UI_SubsFromRefresh()
               GEM3UI_EventDetailsShow()
               GEM3UI_EventMembersListScrollUpdate();
             end
          end --- if line visible
       end --- Line loop
    end -- Archive or template
   end --- reason == GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE
 end --- Evenlist visible
 
 if (reason == "GEM3UI_REFRESH_EVENT_UPDATE" 
 or reason == "GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE")
 then
   local cal = getglobal("GEM3UICalendar");
   MovixLibCreateCalendar(cal, cal.amonth.month, cal.amonth.year);
   GEM3UI_CalHighlightSubstDays();
   GEM3UI_DisplayDaydetails();
 end
 if getglobal("GEM3UIEventListToolbar"):IsVisible() then 
  GEM3UI_BuildToolBar();
 end
 
 if GEM3UIEventSubs:IsVisible() and GEM3UIEventSubs.userIsEditing ~= true then
  GEM3UI_EventDetailsShow();
 end
end -- function GEM3UI_RefreshView




-- FUNCTION ON FRAME LOAD
function GEM3UI_UIOnLoad()
  GEM3UI = {};
  GEM3UICalendar:ClearAllPoints();
  GEM3UICalendar:SetPoint("TOPRIGHT", GEM3UIMain, "TOPRIGHT", -8, -50);
  GEM3UIPlayerDetails:ClearAllPoints();
  GEM3UIPlayerDetails:SetPoint("BOTTOMRIGHT", GEM3UIMain, "BOTTOMRIGHT", -8, 10);
  GEM3UIEventSubs:ClearAllPoints();
  GEM3UIEventSubs:SetPoint("BOTTOMRIGHT", GEM3UIMain, "BOTTOMRIGHT", -8, 10);
  GEM3UIDay:ClearAllPoints();
  GEM3UIDay:SetPoint("BOTTOMRIGHT", GEM3UIMain, "BOTTOMRIGHT", -8, 10);
  GEM3UIPlayerPanel:ClearAllPoints();
  GEM3UIPlayerPanel:SetPoint("BOTTOMRIGHT", GEM3UIMain, "BOTTOMRIGHT", -8, 10);
  GEM3UIMainFrameButtons:ClearAllPoints();
  GEM3UIMainFrameButtons:SetPoint("TOPRIGHT", GEM3UIMain, "TOPRIGHT", -8, -6);
  --GEM3UIMainFrameButtons:SetFrameStrata("TOOLTIP");
  --GEM3UIMainFrameButtons:SetFrameLevel(255);
  --GEM3UIMainFrameButtons:Raise();
   
  GEM3UIMain:ClearAllPoints();
  GEM3UIMain:SetPoint("TOPRIGHT", UIParent, "TOPRIGHT", GEM3UI.WindowPosX, GEM3UI.WindowPosY);
  
  local gemuiver = GEM3UI_MAJOR.."."..GEM3UI_MINOR..GEM3UI_REVISION;
  SLASH_GEM3UI1 = "/GEM";
  SLASH_GEM3UI2 = "/GEM3";
  SlashCmdList["GEM3UI"] = GEM3UI_show;
  DEFAULT_CHAT_FRAME:AddMessage(string.format(GEM3UI_LocalizedStrings["GEM3UILOADED"],gemuiver), 0.9, 0.80, 0.10);
  DEFAULT_CHAT_FRAME:AddMessage(GEM3UI_LocalizedStrings["GEM3UIRESET"], 0.9, 0.80, 0.10);
end

if GEM3_GetVersion == nil then
 GEM3_GetVersion = function ()
  return "3.003";
 end
end

function GEM3UI_OnEvent(self, event, ...)
 arg1 = select (1, ...);
end

function GEM3UI_OnCoreVarsLoaded()
    local gemuiver = GEM3UI_MAJOR.."."..GEM3UI_MINOR..GEM3UI_REVISION;
    if GEM3_GetVersion() < GEM3UI_MINCOREVERSION then
     DEFAULT_CHAT_FRAME:AddMessage(string.format(GEM3UI_LocalizedStrings["COREINCOMPATIBLE"],GEM3_GetVersion(),gemuiver), 0.9, 0.1, 0.10);
     return;
    end
    
 
 --if (event == "VARIABLES_LOADED") then --and (arg1 == "GEM3UI")) then
   local scrollit;
   local cal;
   GEM3UI_Init();
   GEM3UI_InitConfigFrame();
   GEM3UIMain:RegisterForDrag("LeftButton");
   GEM3MinimapButton:RegisterForDrag("RightButton");
   tinsert(UISpecialFrames,GEM3UIMain:GetName());
   --tinsert(UISpecialFrames,GEM3UIAddExternal:GetName());

   GEM3UI_CreateSizer();
   
   gemuipopulate();
   scrollit = getglobal("GEM3UIMainEventScrollList");
   if scrollit == nil then
    scrollit = CreateFrame("SCROLLFRAME", "GEM3UIMainEventScrollList", getglobal("GEM3UIMainMainPanelEventListMain"), "GEM3UIScrollFrameTemplate");
   end
   scrollit:SetPoint("TOPLEFT", getglobal("GEM3UIMainMainPanelEventListMain") ,"TOPLEFT", 0, -49)
   scrollit:SetPoint("BOTTOMRIGHT", getglobal("GEM3UIMainMainPanelEventListMain") ,"BOTTOMRIGHT", -27, 4)
   createuiline();
   
   scrollit = getglobal("GEM3UIMembersListScroll");
   if scrollit == nil then
    scrollit = CreateFrame("SCROLLFRAME", "GEM3UIMembersListScroll", getglobal("GEM3UIMembersList"), "GEM3UIScrollFrameTemplate");
   end
   scrollit:SetPoint("TOPLEFT", getglobal("GEM3UIMembersList") ,"TOPLEFT", 0, -4)
   scrollit:SetPoint("BOTTOMRIGHT", getglobal("GEM3UIMembersList") ,"BOTTOMRIGHT", -27, 4)
   GEM3UI_CreateChannelMembersline();
   
   scrollit = getglobal("GEM3UIDayEventScrollList");
   if scrollit == nil then
    scrollit = CreateFrame("SCROLLFRAME", "GEM3UIDayEventScrollList", getglobal("GEM3UIDay"), "GEM3UIScrollFrameTemplate");
   end
   scrollit :SetPoint("TOPLEFT", getglobal("GEM3UIDay") ,"TOPLEFT", 4, -82);
   scrollit :SetPoint("BOTTOMRIGHT", getglobal("GEM3UIDay") ,"BOTTOMRIGHT", -27, 75);
   createDayEventline();

   scrollit = getglobal("GEM3UI_eventSubscriptionListScroll");
   if scrollit == nil then
    scrollit = CreateFrame("SCROLLFRAME", "GEM3UI_eventSubscriptionListScroll", getglobal("GEM3UI_eventSubscriptionList") , "GEM3UIScrollFrameTemplate");
   end
   scrollit:SetPoint("TOPLEFT", getglobal("GEM3UI_eventSubscriptionList"), 3, -16);
   scrollit:SetPoint("BOTTOMRIGHT", getglobal("GEM3UI_eventSubscriptionList"), -27, 28);
   createplayersline();
   
   scrollit = getglobal("GEM3UI_CFGChanlistScroll");
   if scrollit == nil then
    scrollit = CreateFrame("SCROLLFRAME", "GEM3UI_CFGChanlistScroll", getglobal("GEM3UI_CFGChanlist") , "GEM3UIScrollFrameTemplate");
   end
   scrollit:SetPoint("TOPLEFT", getglobal("GEM3UI_CFGChanlist"), 3, -20);
   scrollit:SetPoint("BOTTOMRIGHT", getglobal("GEM3UI_CFGChanlist"), -27, 28);
   createChannelline();
   
   GEM3UI_today = date ("*t");
   GEM3UIDay.d = GEM3UI_today;
   cal = getglobal("GEM3UICalendar");
   cal.amonth = date ("*t", time({["year"] = GEM3UI_today.year, ["month"] = GEM3UI_today.month, ["day"] = 1, }));
   cal.SELDAY = GEM3UI_today;
   cal.amonth = MovixLibMonthDaycount(cal.amonth);
   cal.amonth = MovixLibSetWday(cal.amonth);

   GEM3UIMain.state = 0;
   GEM3UI_InitTerminated = true;
   
   GEM3UI_GetChannelMembers();
--  end
  
  if GEM3UIRUNCFGWIZ == true then
   GEM3UI_MainTabClick(4);
   GEM3UIMain:Show();
   GEM3UI.ShowMinimapIcon = true;
   GEM3UIRUNCFGWIZ = false; 
  end
  GEM3MinimapButton_Update();
  GEM3UI_MinimapButtonReposition();
end



function GEM3UI_CreateSizer()
   
   local Sizer = getglobal("GEM3UIMainSizer");
   if Sizer == nil then
    Sizer = CreateFrame("FRAME", "GEM3UIMainSizer", GEM3UIMain);
   end
   Sizer:SetPoint("TOPLEFT", GEM3UIMain, "BOTTOMRIGHT", -18,18);
   Sizer:EnableMouse();
   Sizer:SetWidth(18);
   Sizer:SetHeight(18);
   Sizer:SetBackdrop({   bgFile = "interface\\AddOns\\GEM3UI\\ResizeGrip", edgeFile ="", tile= false, tileSize=0, edgeSize=0, insets = { left=0, right=0, top=0, bottom=0}});
   Sizer:SetScript("OnMouseDown", GEM3UI_ResizingMD); 
   Sizer:SetScript("OnMouseUp", GEM3UI_ResizingMU);
   
end


function GEM3UI_DayDetailsHide()
 local expline = getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine);
 if expline ~= nil then
  GEM3UI_ExpandEventLine(expline, true);
 end
 this:GetParent():Hide();
end


function GEM3UI_DayEventClick(obj)
 GEM3UI_ContextFrame="GEM3UIDay";
 GEM3UIEventSubs.ev_index = GEM3UI_DayEvents[obj.index];
 GEM3UIEventSubs.evt = GEM3UI_EventSource[MyEvent[GEM3UI_DayEvents[obj.index]].id];
 GEM3UIEventSubs.form=true;
 GEM3UIEventSubs:Show();
 
end

function GEM3UI_DayEventLineHighLight(obj)
GEM3UIDayEVCommentLabel:SetText(MyEvent[GEM3UI_DayEvents[obj.index]].ev_comment);
GEM3UI_SetDebugStatus(string.format("EVENTLINE: %s - EVENTID: %s", GEM3UI_DayEvents[obj.index], MyEvent[GEM3UI_DayEvents[obj.index]].id),0);
end

function GEM3UI_DayEventLineOut(obj)
GEM3UIDayEVCommentLabel:SetText("");
end



-- GEM3UI_ContextFrame="GEM3UIEventSubs";
-- GEM3UI_ContextFrame="GEM3UIDay";
-- GEM3UI_ContextFrame="GEM3UIPlayerPanel";

function GEM3UI_DetailPanelOnShow(self)
 if GEM3UI_MovingOrSizing == true then return; end
 
 if GEM3UI_ActPanel == nil then 
  GEM3UI_ActPanel = getglobal("GEM3UIDay");
 end
 
 if GEM3UI_ActPanel:GetName() ~= self:GetName() then
  self.GEM3UI_OldPanel = GEM3UI_ActPanel;
  GEM3UI_ActPanel = self;
  self.GEM3UI_OldPanel:Hide();
 end
 
 if GEM3UI_ActPanel.GEM3UI_OldPanel == nil then 
   GEM3UI_ActPanel.GEM3UI_OldPanel = GEM3UI_ActPanel;
 end

 if GEM3UI_expandedLine == 0 then
   getglobal("GEM3UIDay").GEM3UI_OldPanel = getglobal("GEM3UIDay");
 end

 if self:GetName() == "GEM3UIEventSubs" then
   GEM3UI_EventDetailsShow();
 end
 
 if self:GetName() == "GEM3UIDay" then
  GEM3UIEventSubs.userIsEditing = nil;
  GEM3UI_DisplayDaydetails();
 end
 
 if self:GetName() == "GEM3UIPlayerPanel" then
  GEM3UIEventSubs.userIsEditing = nil;
  GEM3UI_DisplayPlayerDetails();
 end
 
end

function GEM3UI_DetailPanelOnHide(self)
 if GEM3UI_MovingOrSizing == true then return; end
 if GEM3UIPlayerPanel.Stickedplname ~= nil then GEM3UIPlayerPanel.Stickedplname = nil; end
 
 if GEM3UI_ActPanel:GetName() == self:GetName() then
  GEM3UI_ActPanel = self.GEM3UI_OldPanel;
  self.GEM3UI_OldPanel:Show();
  --getglobal(GEM3UI_ContextFrame):Show();
 end
end




function GEM3UI_MemberLineOnEnter()
 GEM3UIPlayerPanel.plname = GEM3UI_ChannelMembers[this.index].name;
 if not GEM3UIPlayerPanel:IsVisible() then 
  GEM3UIPlayerPanel:Show();
 end
 GEM3UI_DisplayPlayerDetails();
end

function GEM3UI_MemberLineOnLeave()
 if GEM3UIPlayerPanel.Stickedplname == nil then
  --GEM3UIPlayerPanel:Hide();
 else
  GEM3UIPlayerPanel.plname = GEM3UIPlayerPanel.Stickedplname;
  GEM3UI_DisplayPlayerDetails();
 end
end


-- Main frame expand / collapse functions
function GEM3UI_Collapse()
  GEM3UI.WindowState = 0;
  if (GEM3UIMainMainPanel:IsVisible()) then
   GEM3UI.WindowState = 1;
   GEM3UIMainMainPanel:Hide();
   GEM3UIMain:SetWidth(GEM3UIMain:GetWidth() - GEM3UIMainMainPanel:GetWidth());
   GEM3UIMainFrameButtonsExpand:Enable();
  else
   if (GEM3UICalendar:IsVisible()) then
    GEM3UI.WindowState = 2;
    GEM3UICalendar:Hide();
    GEM3UIMain:SetHeight(GEM3UIMain:GetHeight() - GEM3UICalendar:GetHeight());
    GEM3UIMainFrameButtonsCollapse:Disable();
    GEM3UIMainFrameButtonsExpand:Enable();
   end
  end
  GEM3UI_ShowTemplates:SetChecked(false);
  GEM3UI_ShowArchive:SetChecked(false);
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
  --GEM3UI_-RefreshAll();
  GEM3UIMainStatusBar:Hide();
  GEM3UIMain.state = GEM3UI.WindowState;
  GEM3UI_SetToolbarPosition();
end

function GEM3UI_Expand()
  GEM3UI.WindowState = 2;
  if (not GEM3UIMainMainPanel:IsVisible()) then
   if (not GEM3UICalendar:IsVisible()) then
    GEM3UI.WindowState = 1;
    GEM3UICalendar:Show();
    GEM3UIMain:SetHeight(GEM3UIMain:GetHeight() + GEM3UICalendar:GetHeight());
    GEM3UIMainFrameButtonsCollapse:Enable();
    GEM3UIMainFrameButtonsExpand:Enable();
   else
    GEM3UI.WindowState = 0
    GEM3UIMainMainPanel:Show();
    GEM3UIMainStatusBar:Show();
    if GEM3_QA_Config.debug > 0 then
     GEM3UI_DebugStatusBar:Show();
    end
    GEM3UIMainFrameButtonsExpand:Disable();
    GEM3UIMainFrameButtonsCollapse:Enable();
   
    GEM3UIMain:SetWidth(GEM3UIMain:GetWidth() + GEM3UIMainMainPanel:GetWidth());
   end
  end
  GEM3UIMain.state = GEM3UI.WindowState;
  GEM3UI_SetToolbarPosition();
end



--- Main Frame scaling
function GEM3UI_MainFrameHideShowcontent(state)
  if state == "HIDE" then 
   GEM3UI_MovingOrSizing=true;
  else
   GEM3UI_MovingOrSizing=false;
  end

  --GEM3UI_HideShow(GEM3UIMainMainPanel,state);
  --GEM3UI_HideShow(GEM3UICalendar,state);
  --GEM3UI_HideShow(GEM3UIPlayerDetails,state);
  --GEM3UI_HideShow(GEM3UIEventSubs,state);
  --GEM3UI_HideShow(GEM3UIDay,state);
  --GEM3UI_HideShow(GEM3UIPlayerPanel,state);
  --GEM3UI_HideShow(GEM3UIMainStatusBar,state);
  --GEM3UI_HideShow(GEM3UI_DebugStatusBar,state);
end

function GEM3UI_HideShow(frm, state)
 if state == "HIDE" then
  frm.oldstate=frm:IsVisible();
  frm:Hide();
 else
  if frm.oldstate then
   frm:Show();
  end
 end
end


function GEM3UI_ResizingMD()  -- MouseDown
  GEM3UI_MainFrameHideShowcontent("HIDE");
  GEM3UI_Resizing(2);
end

function GEM3UI_ResizingMU() -- MouseUp
 GEM3UI_Resizing(1);
 GEM3UI.WindowPosX = GEM3UIMain:GetRight();
 GEM3UI.WindowPosY = GEM3UIMain:GetTop();
 GEM3UIMain:ClearAllPoints();
 GEM3UIMain:SetPoint("TOPRIGHT", UIParent, "BOTTOMLEFT", GEM3UI.WindowPosX, GEM3UI.WindowPosY);
 GEM3UI_MainFrameHideShowcontent("SHOW");
end

function GEM3UI_Resizing(state)
 if state == nil then  state = 0; end 
 if state == 0 and GEM3UI_IsSizing == true then -- draging
   GEM3UIMain:SetHeight(GEM3UIMain:GetWidth()/GEM3UI_FrameRatio);
 elseif state== 1 then -- stopdragging
  GEM3UIMain:StopMovingOrSizing();
  GEM3UI.Scale = GEM3UIMain:GetWidth()/GEM3UI_MainWidth*GEM3UI_OldScale ;
  GEM3UIMain:SetHeight(GEM3UI_MainHeight );
  GEM3UIMain:SetWidth(GEM3UI_MainWidth);
  if GEM3UI.Scale > 1.4 then GEM3UI.Scale = 1.4; end
  if GEM3UI.Scale < 0.5 then GEM3UI.Scale = 0.5; end
  GEM3UIMain:SetScale(GEM3UI.Scale);
  GEM3UI_IsSizing = false;
  local kids = { GEM3UIMain:GetChildren() };
  for _, child in ipairs(kids) do
   if (child:GetName() ~= "GEM3UIMainSizer" and child.wasvisible == true) then
     child:Show();
   end
  end
 elseif state == 2 then -- startdragging
  GEM3UI_IsSizing = true;
  GEM3UI_MainHeight = GEM3UIMain:GetHeight()
  GEM3UI_MainWidth = GEM3UIMain:GetWidth();
  GEM3UI_FrameRatio = GEM3UI_MainWidth/GEM3UI_MainHeight;
  GEM3UI_OldScale =  GEM3UI.Scale;
  GEM3UIMain:StartSizing("BOTTOMRIGHT");
  local kids = { GEM3UIMain:GetChildren() };
  for _, child in ipairs(kids) do
   if (child:GetName() ~= "GEM3UIMainSizer" and child:IsVisible() == true) then
     child:Hide();
     child.wasvisible = true;
   end
  end
 end
 GEM3UIMainStatusBar:ClearAllPoints()
 GEM3UIMainStatusBar:SetPoint("TOPLEFT", GEM3UIMain, "BOTTOMLEFT", 0 ,3);
 GEM3UIMainStatusBar:SetWidth(GEM3UIMain:GetWidth());
 GEM3UIMainStatusBar:SetHeight(25);
 if GEM3_QA_Config.debug > 0 then
  GEM3UI_DebugStatusBar:ClearAllPoints()
  GEM3UI_DebugStatusBar:SetWidth(GEM3UIMain:GetWidth());
  if GEM3UI.WindowState == 0 then
    GEM3UI_DebugStatusBar:SetPoint("TOPLEFT", GEM3UIMainStatusBar, "BOTTOMLEFT", 0 ,3);
    GEM3UI_DebugStatusBar:SetHeight(25);
    GEM3UI_DebugStatusBarText:SetPoint("TOPLEFT", 101,-4);
    GEM3UI_DebugStatusBarText:SetWidth(443);
    GEM3UI_DebugStatusBarText:SetHeight(15)
    GEM3UIMainDelayDBG:SetPoint("TOPLEFT", 540,-4);
    
  else
    GEM3UI_DebugStatusBar:SetPoint("TOPLEFT", GEM3UIMainStatusBar, "BOTTOMLEFT", 0 ,25);
    GEM3UI_DebugStatusBar:SetHeight(100);
    GEM3UI_DebugStatusBarText:SetPoint("TOPLEFT", 3,-20);
    GEM3UI_DebugStatusBarText:SetWidth(GEM3UIMainStatusBar:GetWidth()-8);
    GEM3UI_DebugStatusBarText:SetHeight(60)
    GEM3UIMainDelayDBG:SetPoint("TOPLEFT", 3,-80);
  end
 end
 if GEM3UI.WindowState == 0 then
   GEM3UIMainTitelLabel:SetText(GEM3UI_LocalizedStrings["_lblTitle"].." V."..GEM3_GetVersion());
   GEM3UIMainAlertLabel:SetText(GEM3UI_NEEDUPDATE);
 else
  GEM3UIMainTitelLabel:SetText("GEM 3");
  GEM3UIMainAlertLabel:SetText("");
 end
 GEM3UI_SetToolbarPosition();
end

-- TAB Handling
function GEM3UI_MainTabClick(tabid)
 if tabid ~= nil then
  GEM3UI_tabid = tabid;
  obj = getglobal("GEM3UIMainMainPanelTab"..tabid);
 else
  GEM3UI_tabid = string.sub(this:GetName(),23)*1;
  obj = this;
 end
 if GEM3UI_tabid ~= 2 then
  GEM3UICreate.ev_id = nil;
 end
 local tab;
 local tabtexture;
 local tabedFrames = {
  [1] = "GEM3UIMainMainPanelEventListMain",
  [2] = "GEM3UICreate",
  [3] = "GEM3UIMembers",
  [4] = "GEM3UIOptions",
  [5] = "GEM3UIDebug",
  [6] = "GEM3UIHelp",
  [7] = "GEM3UIPlugins",
 };
 for i=1,#tabedFrames do
   tabtexture = getglobal("GEM3UIMainMainPanelTab"..i.."Texture");
   tab = getglobal(tabedFrames[i]);
   if tabtexture:GetDrawLayer() == "ARTWORK" then
     tabtexture:SetDrawLayer("BACKGROUND");
     tabtexture:SetTexCoord(0, 1, 0.26, 0.5);
     tab:Hide();
   end
   if i == GEM3UI_tabid then
     tabtexture:SetDrawLayer("ARTWORK");
     tabtexture:SetTexCoord(0, 1, 0, 0.25);
     tab:SetParent(obj:GetParent());
     tab:SetPoint("TOPLEFT", 3,-30);
     tab:Show();
   end
 end
end


function GEM3UI_HelpTabShow()
GEM3UI_HELP_CORETITELLabel:SetText(GEM3UI_LocalizedStrings["_lblTitle"].." "..GEM3UI_LocalizedStrings["_core"].." "..GEM3UI_LocalizedStrings["_version"].." "..GEM3_GetVersion());
GEM3UI_HELP_UITITELLabel:SetText(GEM3UI_LocalizedStrings["_lblTitle"].." "..GEM3UI_LocalizedStrings["_ui"].." "..GEM3UI_LocalizedStrings["_version"].." "..GEM3UI_MAJOR.."."..GEM3UI_MINOR..GEM3UI_REVISION);
end



-- CALENDAR FUNCTIONS
function GEM3UI_CalHighlightSubstDays()
  if GEM3UI_ShowTemplates:GetChecked() then return; end
    local i;
    for i in pairs(MyEvent) do
    local ev=GEM3UI_EventSource[MyEvent[i].id];
    if GEM3_SUB_GetSubscribedInfos(ev.id, UnitName("Player")) then
     local day = date("*t", ev.ev_date);
     GEM3UI_ChangeDaySetColor(getglobal("GEM3UICalendar"), day, GEM3UI_COLOR_CAL_WITHSUBSCRIBEDEVENT);
    end
   end
end


function GEM3UI_NextDay()
 local parent = getglobal("GEM3UICalendar");
 parent.SELDAY = MovixLibMonthDaycount(parent.SELDAY);
 if parent.SELDAY.day == parent.SELDAY.monthdaycount then
  if parent.SELDAY.month == 12 then
    parent.SELDAY.day = 1;
    parent.SELDAY.month = 1;
    parent.SELDAY.year = parent.SELDAY.year + 1
  else
    parent.SELDAY.day = 1;
    parent.SELDAY.month = parent.SELDAY.month + 1;
  end
 else
  parent.SELDAY.day = parent.SELDAY.day + 1;
 end
 parent.SELDAY = date ("*t", time({["year"] = parent.SELDAY.year, ["month"] = parent.SELDAY.month, ["day"] = parent.SELDAY.day, }));
 GEM3UIDay.d = parent.SELDAY;
 GEM3UIDay:Show();
 GEM3UI_DisplayDaydetails();
 MovixLibCreateCalendar(parent, parent.SELDAY.month, parent.SELDAY.year);
 GEM3UI_HilightDay(parent.SELDAY, parent);
end

function GEM3UI_PrevDay()
 local parent = getglobal("GEM3UICalendar");
 if parent.SELDAY.day == 1 then
  if parent.SELDAY.month == 1 then
    parent.SELDAY.day = 31;
    parent.SELDAY.month = 12;
    parent.SELDAY.year = parent.SELDAY.year - 1
  else
    parent.SELDAY.day = 1;
    parent.SELDAY.month = parent.SELDAY.month - 1;
    parent.SELDAY = MovixLibMonthDaycount(parent.SELDAY);
    parent.SELDAY.day = parent.SELDAY.monthdaycount;
  end
 else
  parent.SELDAY.day = parent.SELDAY.day - 1;
 end
 parent.SELDAY = date ("*t", time({["year"] = parent.SELDAY.year, ["month"] = parent.SELDAY.month, ["day"] = parent.SELDAY.day, }));
 GEM3UIDay.d = parent.SELDAY;
 GEM3UIDay:Show();
 GEM3UI_DisplayDaydetails();
 MovixLibCreateCalendar(parent, parent.SELDAY.month, parent.SELDAY.year);
 GEM3UI_HilightDay(parent.SELDAY, parent);
end


function GEM3UI_GetDateShow(target)
  GEM3UI_DatePickTarget = target;
  local datepick = getglobal("GEM3UI_DatePicker");
  if datepick == nil then 
   datepick = CreateFrame("FRAME", "GEM3UI_DatePicker", GEM3UIMain);
   datepick:SetFrameStrata("TOOLTIP");
   datepick:SetFrameLevel(10);
   datepick:SetWidth(170) -- Set these to whatever height/width is needed 
   datepick:SetHeight(170) -- for your Texture
   datepick:SetBackdrop( { 
    bgFile = "interface\\raidframe\\ui-raidframe-groupbg", 
    edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, 
    insets = { left = 3, right = 3, top = 3, bottom = 3 }
    });
    datepick:SetBackdropColor(0,0,0,1);
    datepick:SetScale(0.79);
  else
   if datepick:IsVisible() then
    datepick:Hide();
    return;
   end
  end
  datepick:SetPoint("TOPLEFT", this:GetParent(), "BOTTOMLEFT", 0,3);
  local id = 5;
  if target == "date" then id = 5; else id = 10; end
  local d = getglobal("GEM3EDITBOX"..id);
  local m = getglobal("GEM3EDITBOX"..id+1);
  local y = getglobal("GEM3EDITBOX"..id+2);
  
  if string.len(y:GetText()) == 2 then 
   y:SetText("20"..y:GetText());
  elseif string.len(y:GetText()) < 2 then
   y:SetText(GEM3UI_today.year);
  end
  
  if string.len(m:GetText()) == 0 then 
   m:SetText(GEM3UI_today.month);
  end
  
  if string.len(d:GetText()) == 0 then 
   d:SetText(GEM3UI_today.day);
  end
  
  datepick.SELDAY = date ("*t", time({["year"] = y:GetText(), ["month"] = m:GetText(), ["day"] = d:GetText(), }));

  datepick.amonth= date ("*t", time({["year"] = y:GetText(), ["month"] = m:GetText(), ["day"] = 1, }));
  datepick.amonth = MovixLibMonthDaycount(datepick.amonth);
  datepick.amonth = MovixLibSetWday(datepick.amonth);
  MovixLibCreateCalendar(datepick, datepick.SELDAY.month, datepick.SELDAY.year, GEM3UI_GetDate);
  datepick:Show();
end

function GEM3UI_GetDate()
    local pickdate = GEM3UI_DayClicked (this);
    if pickdate ~= 0 then 
      pickdate = date("*t", pickdate);
      local d = getglobal("GEM3EDITBOX5");
      local m = getglobal("GEM3EDITBOX6");
      local y = getglobal("GEM3EDITBOX7");
      local h = getglobal("GEM3EDITBOX8");
      local mi = getglobal("GEM3EDITBOX9");
      if GEM3UI_DatePickTarget ~= "date" then
       d = getglobal("GEM3EDITBOX10");
       m = getglobal("GEM3EDITBOX11");
       y = getglobal("GEM3EDITBOX12");
       h = getglobal("GEM3EDITBOX13");
       mi = getglobal("GEM3EDITBOX14");

      end
       d:SetText(string.format("%02d", pickdate.day));
       m:SetText(string.format("%02d", pickdate.month));
       y:SetText(pickdate.year);       
       if string.len(h:GetText()) == 0 then h:SetText("20"); end
       if string.len(mi:GetText()) == 0 then mi:SetText("00"); end
    end
    GEM3UI_DatePicker:Hide();
    
end 

function GEM3UI_DayHasEvent(d)
 local daystart = time({["year"] = d.year, ["month"] = d.month, ["day"] = d.day, ["hour"] = 0; ["minute"] = 0; ["sec"] = 0;}); ---(60*60);
 local daystop = daystart+(60*60*24); --time({["year"] = d.year, ["month"] = d.month, ["day"] = d.day, ["hour"] = 23; ["minute"] = 59; ["sec"] = 59;});
 for i in pairs(MyEvent) do
  if (MyEvent[i].ev_date >= daystart and MyEvent[i].ev_date <= daystop) then
   return true
  end
 end
 return false;
end



    



--- DIALOG BOXES


function GEM3UI_DialogIgnoreMember(value)
   GEM3_PLAY_IgnorePlayer(value);
   GEM3UI_ShowHideIgnoredMembers();
   --GEM3UI_-RefreshAll();
   GEM3UI_SetStatusMessage(string.format(GEM3UI_LocalizedStrings["_memberhasbeenignored"], value));
end

function GEM3UI_DialogIgnoreEvent(value)
 GEM3_EVT_IgnoreEvent(value);
 local ev = GEM3UI_EventSource[value];
 GEM3UI_SetStatusMessage(string.format(GEM3UI_LocalizedStrings["_eventhasbeenignored"], ev.ev_place, ev.id, ev.leader));
end

function GEM3UI_DialogCloseEvent(value, reason)
 GEM3_EVT_CloseEvent(value, reason);
 local ev = GEM3UI_EventSource[value];
 GEM3UI_SetStatusMessage(string.format(GEM3UI_LocalizedStrings["_eventhasbeenclosed"], ev.ev_place, ev.id, ev.leader));
end
 






-- DD inits
function GEM3UI_DropDownClasses()
 GEM3UI_DropDowninit("Classes"); 
 --local dd = getglobal("GEM3UIDropDown");
 --local t;
 local i=0;
 --local r;
 for i in pairs(GEM3UI_Classes) do
    GEM3UI_DDAddLine(GEM3UI_Classes[i].gemid, GEM3UI_Classes[i].name_loc, GEM3UI_Classes[i].name_loc, true, false, GEM3UI_DropDownClassesClick);
 end
end

function GEM3UI_DropDownClassesClick()
 GEM3UI_ExternalAddClassChanged();
end

function GEM3UI_FillDropDownPlayers()
 GEM3UI_DropDowninit("My Rerolls");
 --local dd = getglobal("GEM3UIDropDown");
 --local ddl;
 --local ddt;
 local i=0;
 --local p;
 local rerolls = GEM3_PLAY_GetMyRerolls();
 for p in pairs(rerolls) do
  i = i+1;
  local player = rerolls[p];
  GEM3UI_DDAddLine(player.name, player.name, player.name, GEM3_IsMyReroll(player.name), false, GEM3UI_SubsFromRefresh);
 end
 GA_ReleaseTable(rerolls,0)
end

function GEM3UI_FillSortDD() 
 GEM3UI_DropDowninit("Sorttype");
 --local dd = getglobal("GEM3UIDropDown");
 local nameret;
 for name in pairs(GEM3_SORT_Plugins) do
   nameret=name;
   GEM3UI_DDAddLine(GEM3_SORT_GetSortType(name), name, name, true,false, nil);
 end
 return nameret;
end
      
function GEM3UI_DefaultDropDownRoles(class)
 GEM3UI_DropDownRoles(nil, GEM3UI_CFGDefaultRole);
 --GEM3UI_DropDownRoles(class, GEM3UI[UnitName("player")].DefaultRole);
end

function GEM3UI_SubsDropDownRoles()
 GEM3UI_DropDownRoles(nil, nil);
end

function GEM3UI_CFGDefaultRole(id)
 GEM3UI[UnitName("player")].DefaultRole = id;
 GEM3_QA_Config.role = id;
 GEM3UI_ConfigDefaultRoleTextLabel:SetText(GEM3UI_Roles[GEM3UI_GetRoleIndex(id)].name_loc);
end

function GEM3UI_DropDownRoles(class, foo)
 GEM3UI_DropDowninit("Roles");
 local i = 0;
 local t, allowedroles, selectedplayer;
 if class ~= nil then
  allowedroles = GEM3_PLAY_GetAllowedRoles(GEM3UI_CLASS_STRINGS[class]);
 else
  if GEM3UIEventSubsForm:IsVisible() then
   local pl = GEM3_PLAY_GetPlayerInfos(GEM3UI_ActualPlayerTextLabel:GetText());
   allowedroles = GEM3_PLAY_GetAllowedRoles(pl.class);
  else
   class, classEN = UnitClass("player");
   allowedroles = GEM3_PLAY_GetAllowedRoles(classEN);
  end
 end
 
 for r=1, 5 do
  if (bit.band(allowedroles, GEM3UI_Roles[r].gemid) ~= 0) and GEM3UI_Roles[r].gemid ~=6 then
   i = i+1;
   if (bit.band(GEM3UI_Roles[4].gemid, GEM3UI_Roles[r].gemid) ~= 0) then
     t= GEM3UI_Roles[4].name_loc.." "..GEM3UI_Roles[r].name_loc;
   else
     t=GEM3UI_Roles[r].name_loc;
   end
   GEM3UI_DDAddLine(GEM3UI_Roles[r].gemid, t, t, true, false, foo);
  end
 end
end



function GEM3UI_MainHide()
 GEM3UI_MainWidth = GEM3UIMain:GetWidth();
 GEM3UI_MainHeight = GEM3UIMain:GetHeight();
 GEM3UIFirstRunHelp:Hide();
 GEM3UIFirstRunHelp:SetScript("OnUpdate", nil);
 GEM3UIRUNCFGWIZ = false;
 if GEM3UI.Firstrun == "DONE1" then
    GEM3UI.WindowState = 1;
    GEM3UI.Firstrun = "DONE";
 end
end



function GEM3UI_BuildToolBar()
 --GEM3UI_SetToolbarPosition();
 local tb = getglobal("GEM3UIEventListToolbar");
 local i = 1;
 local but = getglobal(tb:GetName().."but"..i);
 while but do
  but:Hide();
  i = i + 1;
  but = getglobal(tb:GetName().."but"..i);
 end
 
 i = 1;
 for ev_type, count in pairs (GEM3UI_EventTypePresent) do
  
  if (GEM3_QA_Config.debug > 0 and ev_type < 20)
     or ev_type >= 20 
  then
    GEM3UI_CreateButton(but, tb, i, ev_type, count);
    i = i + 1; 
  end
 end
end


function GEM3UI_CreateButton(but, tb, i, ev_type, count)
 local but = getglobal(tb:GetName().."but"..i);
   if but == nil then
    but = CreateFrame("BUTTON", tb:GetName().."but"..i, tb, "ToolbarButtonTemplate");
   end
   but:SetWidth(19);
   but:SetHeight(19);

   if GEM3UI_LocalizedStrings.EventTypes[ev_type].state==true then
     GEM3UI_DrawButtonShadow(but, true);
     local bicon = getglobal(but:GetName().."Icon");
     bicon:SetTexture(GEM3UI_LocalizedStrings.EventTypes[ev_type].tbip);
   else
     GEM3UI_DrawButtonShadow(but, false);
     local bicon = getglobal(but:GetName().."Icon");
     bicon:SetTexture(GEM3UI_LocalizedStrings.EventTypes[ev_type].tbin);
   end
   if tb:GetHeight() == 40 then
    if i == 1 then
     but:SetPoint("TOPLEFT", tb, "TOPLEFT", 2,0);
    elseif (i > 1 and i < 9) or i > 9 then
     but:SetPoint("TOPLEFT", getglobal(tb:GetName().."but"..i-1), "TOPRIGHT", 1,0);
    elseif i == 9 then
     but:SetPoint("TOPLEFT", tb, "TOPLEFT", 2,-19);
    end
   else
    if i == 1 then
     but:SetPoint("TOPLEFT", tb, "TOPLEFT", 0,-6);
    else
     but:SetPoint("TOPLEFT", getglobal(tb:GetName().."but"..i-1), "TOPRIGHT", 2,0);
    end
   end
   but:SetScript("OnLeave", GEM3UI_HideTooltip);
   but:SetScript("OnEnter", GEM3UI_ToolbarTooltipShow);
   but:SetText(count);
   but.index=ev_type
   but:Show();
end





function GEM3UI_ToolbarTooltipShow()
 local t = string.format(GEM3UI_LocalizedStrings["EventTypesToolbarButtonsTooltip"],GEM3UI_LocalizedStrings.EventTypes[this.index].longtext);
 GEM3UI_GameTooltipShow(t);
end



function GEM3UI_ToolBarButtonClick()
 local tex;
 local plname = UnitName("player"); 
 if GEM3UI_LocalizedStrings.EventTypes[this.index].state then
  GEM3UI_LocalizedStrings.EventTypes[this.index].state = false;
  GEM3UI[plname].EvenTypeFilters[this.index] = false;
  GEM3UI_DrawButtonShadow(this, false);
 else
  GEM3UI_DrawButtonShadow(this, true);
  GEM3UI_LocalizedStrings.EventTypes[this.index].state=true;
  GEM3UI[plname].EvenTypeFilters[this.index] = true;
 end
 --GEM3UI_-RefreshAll(GEM3UI_REFRESH_CLOSE_OPEN_EVENTLINE);
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
end





function GEM3UI_SetToolbarPosition()
if GEM3UIMain.state == 0 then 
   GEM3UIEventListToolbar:SetParent(GEM3UIMainMainPanelEventListMain);
   GEM3UIEventListToolbar:ClearAllPoints();
   GEM3UIEventListToolbar:SetPoint("TOPLEFT",GEM3UIMainMainPanelEventListMain, "TOPLEFT", 14, -4);
   GEM3UIEventListToolbar:SetWidth(390);
   GEM3UIEventListToolbar:SetHeight(30);
else
   GEM3UIEventListToolbar:SetParent(GEM3UIDay);
   GEM3UIEventListToolbar:ClearAllPoints();
   GEM3UIEventListToolbar:SetPoint("TOPLEFT", GEM3UIDay, "TOPLEFT", 3, -41);
   GEM3UIEventListToolbar:SetWidth(220);
   GEM3UIEventListToolbar:SetHeight(40);
end
GEM3UIEventListToolbar:Show();
GEM3UI_BuildToolBar()
end


function GEM3UI_RegisterPlugin(name)
 local tabobj = getglobal("GEM3UIMainMainPanelTab7");
 local tabobjlbl = getglobal("GEM3UIMainMainPanelTab7Text");
 if name ~= nil then
  table.insert(GEM3UI_PluginList, name);
 end
 if #GEM3UI_PluginList > 0 then
  tabobj:Show();
  tabobjlbl:Show();
 else
   tabobj:Hide();
   tabobjlbl:Hide();
 end
end



GEM3UI_DIALOG_INTERNAL = 0
GEM3UI_DIALOG_CONFIRM_EVENT_IGNORE = 1;
GEM3UI_DIALOG_CONFIRM_MEMBER_IGNORE = 2;
GEM3UI_DIALOG_CONFIRM_EVENT_CLOSE = 3;
GEM3UI_DIALOG_CONFIRM_UNSUBSCRIBE = 4;
GEM3UI_DIALOG_CONFIRM_PLAYER_KICK = 5;
GEM3UI_DIALOG_CONFIRM_PLAYER_BAN = 6;
GEM3UI_DIALOG_CONFIRM_EVENT_RECOVER = 7;
GEM3UI_DIALOG_CONFIRM_EVENT_RECOVER_REJECT = 8;
GEM3UI_DIALOG_CONFIRM_EVENT_RECOVER_DELETE = 9;
GEM3UI_DIALOG_CONFIRM_EVENT_DELETE = 10;
GEM3UI_DIALOG_CONFIRM_EVENTARCHIVE_DELETE = 11;
GEM3UI_DIALOG_CONFIRM_CANCEL_EVENT_EDIT = 12;
GEM3UI_DIALOG_CONFIRM_SETTIMEREF = 13;
GEM3UI_DIALOG_CONFIRM_SETTIMEREFCONFLICT = 14;
GEM3UI_DIALOG_CONFIRM_NOOBTIMEREFCONFLICT = 15;
GEM3UI_DIALOG_CONFIRM_UPGRADENEEDED = 16;


GEM3UI_CONFIRM_DIALOGS = {
   [GEM3UI_DIALOG_CONFIRM_EVENT_IGNORE]  = {label = "_ConfirmEventIgnore", reason=false, foo= GEM3UI_DialogIgnoreEvent},
   [GEM3UI_DIALOG_CONFIRM_MEMBER_IGNORE] = {label = "_ConfirmMemberIgnore",reason=false,  foo= GEM3UI_DialogIgnoreMember},
   [GEM3UI_DIALOG_CONFIRM_EVENT_CLOSE]   = {label = "_ConfirmEventClose", reason=true, foo= GEM3UI_DialogCloseEvent},
   [GEM3UI_DIALOG_CONFIRM_UNSUBSCRIBE]   = {label = "_ConfirmEventUnsubscribe", reason=true, foo= GEM3UI_DialogUnsubscribeEvent},
   [GEM3UI_DIALOG_CONFIRM_PLAYER_KICK]   = {label = "_ConfirmPlayerKick", reason=true, foo= GEM3UI_ProccedPlayerKick},
   [GEM3UI_DIALOG_CONFIRM_PLAYER_BAN]   = {label = "_ConfirmPlayerBan", reason=true, foo= GEM3UI_ProccedPlayerBan},
   [GEM3UI_DIALOG_CONFIRM_EVENT_RECOVER]   = {label = "_ConfirmEventRecover", reason=false, foo= GEM3UI_ProceedEventRecover},
   [GEM3UI_DIALOG_CONFIRM_EVENT_RECOVER_REJECT]   = {label = "_ConfirmEventRecoverReject", reason=false, foo= GEM3UI_ProceedEventRecoverReject},
   [GEM3UI_DIALOG_CONFIRM_EVENT_RECOVER_DELETE]   = {label = "_ConfirmEventRecoverDelete", reason=false, foo= GEM3UI_ProceedEventRecoverDelete},
   [GEM3UI_DIALOG_CONFIRM_EVENTARCHIVE_DELETE]   = {label = "_ConfirmEventArchiveDelete", reason=false, foo= GEM3UI_EventDeleteArchive},
   [GEM3UI_DIALOG_CONFIRM_EVENT_DELETE]   = {label = "_ConfirmEventDelete", reason=false, foo= GEM3UI_EventDelete},
   [GEM3UI_DIALOG_CONFIRM_CANCEL_EVENT_EDIT]   = {label = "_ConfirmCancelEventEdit", reason=false, foo= GEM3UI_CancelCreate},
   [GEM3UI_DIALOG_CONFIRM_SETTIMEREF]   = {label = "_ConfirmSetTimeRef", reason=false, foo= GEM3UI_SetTimeRef},
   [GEM3UI_DIALOG_CONFIRM_SETTIMEREFCONFLICT]   = {label = "_ConfirmTimeRefConflict", reason=false, foo= nil},
   [GEM3UI_DIALOG_CONFIRM_NOOBTIMEREFCONFLICT]   = {label = "_ConfirmIncorrectTimeSettings", reason=false, foo= nil},
   [GEM3UI_DIALOG_CONFIRM_UPGRADENEEDED]   = {label = "_ConfirmUpgradeNeeded", reason=false, foo= nil},
}

