﻿--[[
 Guild Event Manager GUI
 -------------------------------------
  Code: Movix - Conseil des Ombres - EU
  LIBS
]]


function GEM3UI_TextFrameScroll()
 if (arg1 == 1) then
   this:ScrollUp();
 else
   this:ScrollDown();
 end
end


-- LOCALIZATION FUNCTION
function MovixLib_Localize(str)
  local objtype = this:GetObjectType();
  
  local mobj = "";
  if (objtype == "Frame") then
   mobj = this:GetName().."Label";
  elseif (objtype == "CheckButton" or objtype == "Button") then
   mobj = this:GetName().."Text";
  else
   mobj = this:GetName();
  end
  
  mobj = getglobal(mobj)
  par = mobj:GetText();
  if string.sub(par,1,1) == "_" then
   if GEM3UI_LocalizedStrings[par] ~= nil then 
     mobj:SetText(GEM3UI_LocalizedStrings[par]);
   end
  elseif str~=nil then
    mobj:SetText(str);
  end
end


-------- HELP & Tooltip ------
function GEM3UI_GameTooltipShow(Text, force)
    if not GEM3UI.ShowTooltips and force == nil then return; end
	local oname = this:GetName();
    GameTooltip:SetOwner(this, "ANCHOR_LEFT");
	GameTooltip:ClearLines();
	GameTooltip:SetText(GEM3UI_LocalizedStrings["_lblTitle"], 1,1,1,1);
	GameTooltip:AddLine(" "); 
    if oname == "GEM3MinimapButton" then 
        if #GEM3UI_newEvents == 1 then
		    GameTooltip:AddLine(GEM3UI_LocalizedStrings["_NewEvent"]); 
            GameTooltip:AddLine(" "); 
	    end
        if #GEM3UI_newEvents > 1 then
		     GameTooltip:AddLine(string.format(GEM3UI_LocalizedStrings["_NewEvents"], #GEM3UI_newEvents)); 
             GameTooltip:AddLine(" "); 
        end
    end
    if Text ~= nil then
     GameTooltip:AddLine(Text); 
    else
     local i = 1;
     local tt = GEM3UI_LocalizedStrings["tt_"..this:GetName()..i];
     while (tt) do
      GameTooltip:AddLine(tt); 
      i = i + 1;
      tt = GEM3UI_LocalizedStrings["tt_"..this:GetName()..i];
     end
    end
	GameTooltip:Show(); 
    GameTooltip:SetFrameStrata("TOOLTIP");
    GameTooltip:SetFrameLevel(255);
    GameTooltip:Raise();

end

function GEM3UI_HideTooltip()
 GameTooltip:Hide();
end


-------- Minimap button ------

function GEM3UI_MiniMapIconStartMove()
  GEM3MinimapButton:SetScript("OnUpdate", GEM3UI_MiniMapIconDoMove);
end

function GEM3UI_MiniMapIconStopMove()
GEM3MinimapButton:SetScript("OnUpdate", nil);
end

function GEM3UI_MiniMapIconDoMove()
  	local curX, curY = GetCursorPosition()
    local miniX, miniY = Minimap:GetCenter()
    miniX = miniX * Minimap:GetEffectiveScale()
    miniY = miniY * Minimap:GetEffectiveScale()
    local relX = miniX - curX
   	local relY = miniY - curY
    local angle = math.deg(math.atan2(relY, relX)) + 180
    local distance = (((relX*2) + (relY*2))/2)-(Minimap:GetWidth()/2);
    if IsControlKeyDown() then
     GEM3UI_MinimapButtonReposition(nil, distance);
    else
     GEM3UI_MinimapButtonReposition(angle);
    end    
end

function GEM3UI_MinimapButtonReposition(angle, distance)
	 if (not angle) then angle = GEM3UI.MinimapAngle or 1
	 else GEM3UI.MinimapAngle = angle; end
	 if (not distance) then distance = GEM3UI.MinimapRadius or Minimap:GetWidth()/4
	 else GEM3UI.MinimapRadius = distance; end
     local width,height = Minimap:GetWidth()/2, Minimap:GetHeight()/2
	 width = width+distance
	 height = height+distance
	 local iconX, iconY
	 iconX = width * cos(angle)
	 iconY = height * sin(angle)
	 GEM3MinimapButton:ClearAllPoints()
	 GEM3MinimapButton:SetPoint("CENTER", Minimap, "CENTER", iconX, iconY)
end

function GEM3MinimapButton_Update()
    if GEM3UI.ShowMinimapIcon then
    
     if #GEM3UI_newEvents > 0 then 
      GEM3MinimapButtonText:SetText(GEM3UI_newEvents);
     else
      GEM3MinimapButtonText:SetText("");
     end
     
     GEM3MinimapButtonText:SetTextColor(1.0,0.1,0.1);
     GEM3MinimapButtonTexture:SetTexture("interface\\AddOns\\GEM3UI\\gem");
     GEM3MinimapButton:SetAlpha(1);
     GEM3UI_MinimapButtonReposition();
     GEM3MinimapButton:Show();
    else
     GEM3MinimapButton:Hide();
    end
end



---- DIALOG POPUP BOX
StaticPopupDialogs["GEM3UI_CONFIRM"] = {
   text = TEXT("%s"),
   button1 = TEXT(OKAY),
   button2 = TEXT(CANCEL),
   hideOnEscape = 1,
   whileDead=1,
   showAlert = 1,
   hasEditBox = 1,
   OnShow = function ()
      GEMUI_PopUpDialogCancel=nil;
      this.myid = getglobal(this:GetName().."Text"):GetText();
      this.myid = tonumber(this.myid);
      getglobal(this:GetName().."Text"):SetText(GEM3UI_LocalizedStrings[GEM3UI_CONFIRM_DIALOGS[this.myid].label]);
      if GEM3UI_CONFIRM_DIALOGS[this.myid].reason then 
       getglobal(this:GetName().."EditBox"):Show();
       getglobal(this:GetName().."EditBox"):SetText("");
      else
       getglobal(this:GetName().."EditBox"):Hide();
      end
   end,
   
   OnAccept =  function(argName)
      
      local frm = getglobal(this:GetParent():GetName());
      local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();
      ret1, ret2 = pcall(GEM3UI_CONFIRM_DIALOGS[frm.myid].foo, argName, text);
      GEMUI_PopUpDialogCancel=false;
   end,
   OnCancel = function (_,reason)
      if reason == "timeout" or reason == "clicked" then
          GEM3UI_PopUpDialogCancel=true;
      end
  end,
  timeout = 0
};

function GEM3UI_Popup(popupcode, data)
 if InCombatLockdown() then
  GEM3MinimapButton:SetScript("OnUpdate", GEM3UI_MiniMapCombatOnwait);  
  table.insert(GEM3UI_Popupdata, {code = popupcode, data = data} )
 else
   local dialogFrame = StaticPopup_Show("GEM3UI_CONFIRM", popupcode);
   if data and dialogFrame then dialogFrame.data = data; end
 end
end

function GEM3UI_MiniMapCombatOnwait()
 if InCombatLockdown() then return; end
 for i, popup in pairs(GEM3UI_Popupdata) do
  if popup.code == GEM3UI_DIALOG_INTERNAL then
  else
   local dialogFrame = StaticPopup_Show("GEM3UI_CONFIRM", popup.code);
   if popup.data and dialogFrame then dialogFrame.data = popup.data; end
  end
  table.remove(GEM3UI_Popupdata, i);
 end
 GEM3MinimapButton:SetScript("OnUpdate", nil);  
end

--- STATUS BAR MESSAGE HANDLING

function GEM3UI_SetStatusMessage(msg, delay)
 if delay == nil then delay = 5; end
 if delay == 0  then
  GEM3UIMainStatusBar:SetScript("OnUpdate", nil);
 else
  GEM3UIMainStatusBar.oldMessage = GEM3UIMainStatusBarTextLabel:GetText();
  GEM3UIMainStatusBar:SetScript("OnUpdate", GEM3UI_SetStatusMessageUpdate);
 end
 GEM3UIMainStatusBarTextLabel:SetText(msg);
 GEM3UIMainStatusBar.olddelay = GEM3UIMainStatusBar.delay;
 GEM3UIMainStatusBar.delay = delay;
 GEM3UIMainStatusBar.t = time();
end

function GEM3UI_SetDebugStatus(msg, delay)
 if GEM3UI_DEBUGMODE > 0 then
  if delay == nil then delay = 5; end
  if delay == 0  then
   GEM3UI_DebugStatusBar:SetScript("OnUpdate", nil);
  else
   GEM3UI_DebugStatusBar.oldMessage = GEM3UI_DebugStatusBarTextLabel:GetText();
   GEM3UI_DebugStatusBar:SetScript("OnUpdate", GEM3UI_SetStatusMessageUpdate);
  end
  GEM3UI_DebugStatusBarTextLabel:SetText(msg);
  GEM3UI_DebugStatusBar.olddelay = GEM3UI_DebugStatusBar.delay;
  GEM3UI_DebugStatusBar.delay = delay;
  GEM3UI_DebugStatusBar.t = time();
 end
 GEM3UI_DebugStatusBarTitelLabel:SetText("DEBUG-"..GEM3_QA_Config.debug_flags..":");
end


function GEM3UI_SetStatusMessageUpdate()
 if this.delay > 0 and (time() - this.t) > this.delay then
  getglobal(this:GetName().."TextLabel"):SetText("");
  this:SetScript("OnUpdate", nil);
  if this.olddelay == 0 then
   getglobal(this:GetName().."TextLabel"):SetText(this.oldMessage);
  end
 end
end



---- DropDown

function GEM3UI_DropDowninit(title)
 local i = 1;
 local dd = getglobal("GEM3UIDropDown");
 local scrollit = getglobal("GEM3UIDropDownScroll");
 dd.title=nil;
 dd.title=title;
 dd.strwidth=0;
 if scrollit == nil then
  scrollit = CreateFrame("SCROLLFRAME", "GEM3UIDropDownScroll", dd , "GEM3UIScrollFrameTemplate");
 end
 GEM3UI_CreateDDlines();
 if dd.items ~= nil then
  GA_WipeTable(dd.items,50);
 end
 dd.items = nil;
 dd.items= GA_GetTable();
 dd.target=nil;
 dd.opentime = time();
 GEM3UI_DDScrollUpdate();
end

function GEM3UI_DDAddLine(id, value, label, state, checked, foo)
  local dd = getglobal("GEM3UIDropDown");
  item = GA_GetTable();
  item.id = id;
  item.value=value;
  item.label=label;
  item.state=state;
  item.checked=checked;
  item.foo=foo;
  if (string.len(label) * 7) + 40 > (dd.strwidth or 0) then dd.strwidth = (string.len(label) * 7) + 40; end
  table.insert(dd.items, item);
end


function GEM3UI_DDScrollUpdate()
   local dd = getglobal("GEM3UIDropDown");
   local line; -- 1 through 5 of our window to scroll
   local lineplusoffset=0; -- an index into our data calculated from the scroll offset
   local cnt = #dd.items;
   for line=1,GEM3UI_DefaultDDLines do
       getglobal("GEM3UIDropDownline"..line):Hide();
   end
   FauxScrollFrame_Update(GEM3UIDropDownScroll,cnt,GEM3UI_DefaultDDLines,15);
   for line=1,GEM3UI_DefaultDDLines do
     lineplusoffset = line + FauxScrollFrame_GetOffset(GEM3UIDropDownScroll);
     if lineplusoffset < cnt+1 then
       GEM3UI_fillDDLine(line, lineplusoffset );
       getglobal("GEM3UIDropDownline"..line):Show();
     end
   end
 end


function GEM3UI_fillDDLine(i, index)
 local framename = "GEM3UIDropDownline"..i;
 local dd = getglobal("GEM3UIDropDown");
 local line = getglobal(framename);
 local item = dd.items[index];
 line.dd_index = index;
 getglobal(framename.."Text"):SetText(item.label);
 if item.checked == true then
   getglobal(framename.."Check"):Show();
 else
   getglobal(framename.."Check"):Hide();
 end
  
 if item.state == true then
    line:Enable();
 else
    line:Disable();
 end
 
 if #dd.items > GEM3UI_DefaultDDLines then
   line:SetWidth(GEM3UIDropDownScroll:GetWidth());
 else
   line:SetWidth(GEM3UIDropDownScroll:GetWidth()+18);
 end
end






 function GEM3UI_CreateDDlines()
 local framename;
 local line;
 local i;
 for i=1,GEM3UI_DefaultDDLines do
  framename = "GEM3UIDropDownline"..i;
  line = getglobal(framename);
  if line == nil then
   line = CreateFrame("BUTTON", framename, getglobal("GEM3UIDropDown"), "GEM3UI_DDLine");
  end
  if i > 1 then
    line:SetPoint("TOPLEFT", getglobal("GEM3UIDropDownline"..(i-1)), "BOTTOMLEFT", 0, 0);
  else
    line:SetPoint("TOPLEFT", getglobal("GEM3UIDropDownScroll"), "TOPLEFT", 3, -3);
  end
  line:SetWidth(GEM3UIDropDownScroll:GetWidth()-10);
  line:SetHeight(14);
  line:RegisterForClicks("LeftButtonUp", "RightButtonUp");
  
  local ddc = getglobal(line:GetName().."Check");
  if ggc == nil then
   ddc= line:CreateTexture(line:GetName().."Check");
  end
  ddc:SetPoint("TOPLEFT", 0,0);
  ddc:SetHeight(12);
  ddc:SetWidth(12);
  ddc:SetTexture("interface\\buttons\\ui-checkbox-check");
  ddc:Hide();
  line:Hide();
  local ddt = getglobal(line:GetName().."Text");
  ddt:SetPoint("TOPLEFT", 15,0);
  --ddt:SetWidth(ddt:GetParent():GetWidth()-25);
  line:SetScript("OnClick", GEM3UI_DropDownClick);
 end
end


function GEM3UI_DDshow()  -- Contextmenu
  local dd = getglobal("GEM3UIDropDown");
  dd:SetParent(this);
  --GEM3UIMain:SetFrameStrata("BACKGROUND");
  local x, y = GetCursorPosition();
  
 dd:ClearAllPoints();
 dd:SetPoint("BOTTOMLEFT", UIParent, (x)/GEM3UI.Scale, ((y)/GEM3UI.Scale)-dd:GetHeight());
 dd:SetFrameStrata("DIALOG");
 dd:SetFrameLevel(200);
 
 GEM3UI_DD_SetGlobal();
end

function GEM3UI_ShowDD(dd) -- DropDown list
 dd:SetParent(this:GetParent());
 dd:ClearAllPoints();
 if GEM3UI_DefaultDDLines > #dd.items then
   dd:SetHeight((#dd.items*14)+10);
 else
   dd:SetHeight((GEM3UI_DefaultDDLines*14)+10);
 end
 dd:SetPoint("TOPRIGHT", this, "BOTTOMRIGHT", 0, 2);
 
 GEM3UI_DD_SetGlobal();
end



function GEM3UI_DD_SetGlobal()
 local dd = getglobal("GEM3UIDropDown");
 dd:SetWidth(dd.strwidth);
 local ddtitle = getglobal(dd:GetName().."Title");
 local ddtitlel = getglobal(dd:GetName().."TitleLine");
 
 if ddtitlel == nil then
  ddtitlel = dd:CreateTexture(dd:GetName().."TitleLine");
  ddtitlel:SetHeight(15);
  ddtitlel:SetPoint("TOPLEFT", dd, 3, -3);
  ddtitlel:SetTexture(0.3,0.3,0.3,1);
  ddtitlel:SetDrawLayer("BACKGROUND");
 end
 if ddtitle == nil then
   ddtitle = dd:CreateFontString(dd:GetName().."Title", "ARTWORK", "GameFontNormal");
   ddtitle:SetPoint("TOPLEFT", dd, 7, -3);
   ddtitle:SetHeight(15);
   ddtitle:SetTextColor(1,1,1,1);
   ddtitle:SetJustifyH("LEFT");
 end 
 ddtitlel:SetWidth(dd:GetWidth()-6);
 ddtitle:SetWidth(dd:GetWidth()-6); 
 local scrollit = getglobal("GEM3UIDropDownScroll");
 local titelheight = 0 ;
 if dd.title ~= nil then
  ddtitle:SetText(dd.title);
  ddtitle:Show();
  ddtitlel:Show();
  scrollit:SetPoint("TOPLEFT", dd, 3, -18);
  scrollit:SetPoint("BOTTOMRIGHT", dd, -27, 3);
  titelheight = 15;
 else
  ddtitle:Hide();
  ddtitlel:Hide();
  scrollit:SetPoint("TOPLEFT", dd, 3, -3);
  scrollit:SetPoint("BOTTOMRIGHT", dd, -27, 3);
 end

 if GEM3UI_DefaultDDLines > #dd.items then
   dd:SetHeight((#dd.items*14)+10+titelheight);
 else
   dd:SetHeight((GEM3UI_DefaultDDLines*14)+10+titelheight);
 end

 if dd:IsVisible() then
  dd:Hide();
 end
 dd:Show();
 dd:Raise();
end




function GEM3UI_DropDownOpenClose(foo, arg)
  GEM3UI_DropDowninit();
 local dd = getglobal("GEM3UIDropDown")
 dd.target = this:GetParent():GetName().."TextLabel";
 if dd:IsVisible() then
   dd:Hide();
 else
   pcall(foo, arg);
   GEM3UI_ShowDD(dd);
 end
 dd.target = this:GetParent():GetName().."TextLabel";
end


function GEM3UI_DropDownClick (obj)
  local dd = getglobal("GEM3UIDropDown");
  if dd.target ~= nil then
   local target = getglobal(dd.target);
   if target then
    target:SetText(dd.items[this.dd_index].value);
    target.id=dd.items[this.dd_index].id;
   end
  end
  if dd.items[this.dd_index].foo ~= nil then
   retok, ret1 = pcall(dd.items[this.dd_index].foo ,dd.items[this.dd_index].id, dd.items[this.dd_index].value);
  end
  dd:Hide();
end


function GEM3UI_CloseDD()
 local dd = getglobal("GEM3UIDropDown");
 if dd:IsVisible() and (time()-dd.opentime) > 1 then
  dd:Hide();
 end
 
end


function GEM3UI_HighlightTexture(self, state)
 local tex = getglobal(self:GetName().."Texture");
 local texhl = getglobal(self:GetName().."HLTexture"); 
 if texhl == nil then
  texhl = self:CreateTexture(self:GetName().."HLTexture", "OVERLAY");
  texhl:SetTexture(tex:GetTexture());
  texhl:SetAllPoints();
  texhl:SetBlendMode("ADD");
 end
 if state == "ON" then
  texhl:Show();
  texhl:SetVertexColor(1,0,0, 1);
 else
  texhl:Hide();
  texhl:SetVertexColor(1,1,1, 0);
 end
end


--function GEM3UI_DDAddLine(id, value, label, state, checked, foo)
function GEM3UI_SetDDMenu(target, table)
 if target == nil then 
  --if type(target) ~= "string" then target = target:GetName(); end
 --else
  target = "cursor";
 end
 EasyMenu(table, GEM3UI_DDMenuFrame, target, 0,0, "MENU", 5);
  GEM3UI_DDTable = GA_ReleaseTable(table);
end


-- HANDLE ESC KEY for EditBoxes to release Focus
function GEM3UI_ESCpressed()
    this:ClearFocus();
end


-- SCROLL FRAMES

function GEM3UIScrollFrame_OnScroll()
  if this:GetName() == "GEM3UIMainEventScrollList" then
    FauxScrollFrame_OnVerticalScroll(14, GEM3UI_EventListScrollUpdate);
  end
  if this:GetName() == "GEM3UI_eventSubscriptionListScroll" then
    FauxScrollFrame_OnVerticalScroll(14, GEM3UI_EventMembersListScrollUpdate);
  end
  if this:GetName() == "GEM3UIDayEventScrollList" then 
    FauxScrollFrame_OnVerticalScroll(14, GEM3UI_DayEventListScrollUpdate);
  end
  if this:GetName() == "GEM3UIMembersListScroll" then
    FauxScrollFrame_OnVerticalScroll(14, GEM3UI_ChannelMembersScrollUpdate);
  end
  if this:GetName() == "GEM3UI_CFGChanlistScroll" then
    FauxScrollFrame_OnVerticalScroll(14, GEM3UI_ChanListScrollUpdate);
  end
  if this:GetName() == "GEM3UIDropDownScroll" then
    FauxScrollFrame_OnVerticalScroll(14, GEM3UI_DDScrollUpdate);
  end



end

function GEM3UIScrollFrame_OnMouseWheel(arg1)
--[[  if this:GetName() == "GEM3UIMainEventScrollList" then
    GEM3UI_ScrollFrameOnMouseWheel(arg1);
  end
  if this:GetName() == "GEM3UI_eventSubscriptionListScroll" then
    GEM3UI_ScrollFrameOnMouseWheel(arg1);
  end
  if this:GetName() == "GEM3UIDayEventList" then
    GEM3UI_ScrollFrameOnMouseWheel(arg1);
  end
  if this:GetName() == "GEM3UIDayEventList" then ]]--
    GEM3UI_ScrollFrameOnMouseWheel(arg1);
  --end
end

function GEM3UIScrollFrame_Update()
 if this:GetName() == "GEM3UIMainEventScrollList" then
   GEM3UI_EventListScrollUpdate();
 end
 if this:GetName() == "GEM3UI_eventSubscriptionListScroll" then
  GEM3UI_EventMembersListScrollUpdate();
 end
 if this:GetName() == "GEM3UIDayEventList" then
  GEM3UI_DayEventListScrollUpdate();
 end
 if this:GetName() == "GEM3UIMembersListScroll" then
  GEM3UI_ChannelMembersScrollUpdate();
 end
 if this:GetName() == "GEM3UI_CFGChanlistScroll" then
  GEM3UI_ChanListScrollUpdate();
 end
 
 if this:GetName() == "GEM3UIDropDownScroll" then
  GEM3UI_DDScrollUpdate();
 end
 
 
end


function GEM3UI_ScrollFrameOnMouseWheel(value, scrollBar)
	if this:GetName() == "GEM3UIMainEventScrollList" then return; end
    scrollBar = scrollBar or getglobal(this:GetName() .. "ScrollBar");
	if ( value > 0 ) then
		scrollBar:SetValue(scrollBar:GetValue() - 14);
	else
		scrollBar:SetValue(scrollBar:GetValue() + 14);
	end
end

----- misc
function GEM3UI_GetClassIndex(class)
 for i, class_str in ipairs(GEM3UI_Classes) do
  if class_str.gemid == class then return i; end
 end
 return false
end

function GEM3UI_GetRoleIndex(role)
 for i, role_str in ipairs(GEM3UI_Roles) do
  if role_str.gemid == role then return i; end
 end
 return 0;
end




function GEM3UI_IsPlayerOnline(chan, pl)
 --mydbg("GEM3UI_IsPlayerOnline:"..pl.." chan :"..chan);
 if pl == nil then return false; end
 if UnitIsConnected(pl) == 1 then return true; end
 local plinfo = GEM3_PLAY_GetPlayerInfos(pl, chan);
 if plinfo ~= nil then
  if plinfo.connected == true then return true; end
 end
 return false;
end
 

function GEM3UI_TblCpy(tab)
  if(type(tab) ~= "table")
  then
    return nil;
  end
  local newtab = GA_GetTable();
  for n,v in pairs(tab)
  do
    if(type(v) == "table") -- recurs dup
    then
      newtab[n] = GEM3UI_TblCpy(v);
    else
      newtab[n] = v;
    end
  end
  return newtab;
end


---- TOOLBAR


--[[
function GEM3UI_CreateToolBar(tbname, parent)
 local tb = getglobal(tbname);
 if tb==nil then
  tb = parent:CreateFrame("FRAME", tbname);
 end
 tb.buttons={};
 return tb;
end

function GEM3UI_RefreshToolBar(tb)
 if tb==nil then tb = this; end
 if tb == nil then return; end
 if tb.buttons = nil then return; end
 local i = 0;
 for i, button in pairs(tb.buttons) do
  i = i+1;
  local but = getglobal(tb:GetName().."but"..i);
  if but == nil then
   but = CreateFrame("BUTTON", tb:GetName().."but"..i, tb, "ToolbarButtonTemplate");
  end
  
  button.name = but:GetName();
  but:SetScript("OnClick", button.OnClick);
  but:SetScript("OnEnter", button.OnEnter);
  but:SetScript("OnLeave", button.OnLeave);
  GEM3UI_DrawButtonShadow(but, but.State);
  local bicon = getglobal(but:GetName().."Icon");
  bicon:SetTexture(but.texture);
  but:SetHeight(tb:GetHeight());
  but:SetWidth(but:GetHeight());
  
  if button.visible then 
   but:Show();
  else
   but:Hide();
  end
  if button.active then 
   but:SetAlpha(1);
  else
   but:SetAlpha(0.5);
  end
 end
end


function GEM3UI_AddToolbarButton(tb, texture, text, tt, state, active, visible, OnEnter, OnLeave, OnClick)
 local but = GA_GetTable();
 but.active = active;
 but.visible = visible;
 but.Onenter=OnEnter;
 but.OnLeave=OnLeave;
 but.OnClick=OnClick;
 but.texture=texture;
 but.text=text
 but.tooltip=tt;
 but.State=state;
 table.insert(tb.buttons, but);
end

]]--


function GEM3UI_DrawButtonShadow(but, state)
   local b;
   local prefix = but:GetName();
   bt = getglobal(prefix.."1");
   if bt == nil then 
    bt = but:CreateTexture("$parent1");
    bl = but:CreateTexture("$parent2");
    bb = but:CreateTexture("$parent3");
    br = but:CreateTexture("$parent4");
    
    bicon = but:CreateTexture("$parentIcon");
    bicon:SetTexture(1,0,1,0.7);
    bicon:SetPoint("TOPLEFT", but, "TOPLEFT", 1, -1);
    bicon:SetPoint("BOTTOMRIGHT", but, "BOTTOMRIGHT", -1, 1);
    
    bt:SetPoint("TOPLEFT", but, "TOPLEFT", 0, 0);
    bt:SetPoint("BOTTOMRIGHT", but, "TOPRIGHT", 0, -1);
    bl:SetPoint("TOPLEFT", but, "TOPLEFT", 0, 0);
    bl:SetPoint("BOTTOMRIGHT", but, "BOTTOMLEFT", 1, 0);
    br:SetPoint("TOPLEFT", but, "TOPRIGHT", -1, 0);
    br:SetPoint("BOTTOMRIGHT", but, "BOTTOMRIGHT", 0, 0);
    bb:SetPoint("TOPLEFT", but, "BOTTOMLEFT", 0, 1);
    bb:SetPoint("BOTTOMRIGHT", but, "BOTTOMRIGHT", 0, 0);
    
   else
    bt = getglobal(prefix.."1");
    bl = getglobal(prefix.."2");
    bb = getglobal(prefix.."3");
    br = getglobal(prefix.."4");
    bicon = getglobal(prefix.."Icon");
   end

   if state then
    bt:SetTexture(0.5,0.5,0.5,1);
    bl:SetTexture(0.5,0.5,0.5,1);
    bb:SetTexture(1,1,1,1);
    br:SetTexture(1,1,1,1);
    but:SetTextColor(1,1,1,0);
    bicon:SetAlpha(1);
   else
    bt:SetTexture(1,1,1,1);
    bl:SetTexture(1,1,1,1);
    bb:SetTexture(0.5,0.5,0.5,1);
    br:SetTexture(0.5,0.5,0.5,1);
    but:SetTextColor(1,1,1,1);
    bicon:SetAlpha(0.5);
   end
end