﻿--[[
 Guild Event Manager GUI
 -------------------------------------
  Code: Movix - Conseil des Ombres - EU
  Plugins
]]

function GEM3UI_PluginFrameOnShow()
   GEM3UI_PluginListScrollUpdate();
   GEM3UIPlugins_PluginTitleLabel:SetText("");
end


function GEM3UI_PluginFrameOnLoad()
   local scrollit;
   scrollit = CreateFrame("SCROLLFRAME", "GEM3UIMainPluginScrollList", getglobal("GEM3UIPlugins"), "GEM3UIScrollFrameTemplate");
   scrollit:SetPoint("TOPLEFT", getglobal("GEM3UIPluginsList") ,"TOPLEFT", 0, -7)
   scrollit:SetPoint("BOTTOMRIGHT", getglobal("GEM3UIPluginsList") ,"BOTTOMRIGHT", -27, 4)
   scrollit:SetScript("OnVerticalScroll",GEM3UI_Plugins_listScroll);
   scrollit:SetScript("OnShow",GEM3UI_PluginListScrollUpdate);
   GEM3UI_CreatePluginLine();
end


function GEM3UI_Plugins_listScroll()
 FauxScrollFrame_OnVerticalScroll(14, GEM3_GS_MemberListScrollUpdate);
end



function GEM3UI_PlugInSelect()
 if GEM3UIPlugins.actualPlugin ~= nil then
  getglobal(GEM3UIPlugins.actualPlugin.."Form"):Hide();
 end
 local frmname = GEM3UI_PluginList[this.index].."Form";
 mydbg(frmname);
 local frm = getglobal(frmname);
 frm:SetParent(GEM3UIPlugins);
 frm:SetPoint("TOPLEFT", GEM3UIPlugins, 160,-28);
 frm:SetWidth(360);
 frm:SetHeight(370);
 frm:Show();
 GEM3UIPlugins.actualPlugin = GEM3UI_PluginList[this.index];
 GEM3UIPlugins_PluginTitleLabel:SetText(GEM3UI_PluginList[this.index]);
end

function GEM3UI_CreatePluginLine()
 local framename;
 local parent = getglobal("GEM3UIPluginsList");
 local line;
 local i;
 for i=1,GEM3UI_DefaultPlugins do
  framename = "GEM3UI_PluginlineFrame"..i;
  line = CreateFrame("BUTTON", framename, parent, "PluginLineTemplate");
  if i > 1 then
    line:SetPoint("TOPLEFT", getglobal("GEM3UI_PluginlineFrame"..(i-1)), "BOTTOMLEFT", 0, 0);
  else
    line:SetPoint("TOPLEFT", getglobal("GEM3UIMainPluginScrollList"), "TOPLEFT", 3, 0);
  end 
  line:SetHeight(15);
  line:SetWidth(GEM3UIMainPluginScrollList:GetWidth()+17);
  line:Hide();
  line:RegisterForClicks("LeftButtonUp", "RightButtonUp");
 end
end


function GEM3UI_fillPluginLine(i, index)
 local framename = "GEM3UI_PluginlineFrame"..i;
 local line = getglobal(framename);
 line.index = index;
 local lbl = getglobal(framename.."PluginNameLabel");
 lbl:SetText(GEM3UI_PluginList[index]);
end

function GEM3UI_PluginListScrollUpdate()
   local line; -- 1 through 5 of our window to scroll
   local lineplusoffset=0; -- an index into our data calculated from the scroll offset
   local cnt = #GEM3UI_PluginList;

   for line=1,GEM3UI_DefaultPlugins do
       getglobal("GEM3UI_PluginlineFrame"..line):Hide();
   end
   FauxScrollFrame_Update(GEM3UIMainPluginScrollList,cnt,GEM3UI_DefaultPlugins,14);
   for line=1,GEM3UI_DefaultDayEvents do
     lineplusoffset = line + FauxScrollFrame_GetOffset(GEM3UIMainPluginScrollList);
     if lineplusoffset < cnt+1 then
       GEM3UI_fillPluginLine(line, lineplusoffset );
       getglobal("GEM3UI_PluginlineFrame"..line):Show();
     end
   end
 end


