﻿-- Members list

function GEM3UI_MembersSortlist(e1, e2)
 returnval = GEM3UIMembers.sortdir or false;
 if GEM3UIMembers.sortfld==nil then GEM3UIMembers.sortfld="name"; end
 if e1 == nil then return returnval; end
 if e2 == nil then return not returnval; end
 local E1, E2, E3;
 if GEM3UIMembers.sortfld=="lvl" then
   E1 = e1.level; E2 = e2.level;
 elseif GEM3UIMembers.sortfld=="name" then
   E1 = e1.name; E2 = e2.name;
 elseif GEM3UIMembers.sortfld=="location" then
   E1 = e1.location; E2 = e2.location;
 end
 if returnval then E3 = E1; E1 = E2; E2 = E3; end -- change sortorder
 
 if E1 == E2 then
  return e1.name > e2.name
 else
  return E1 > E2
 end
end


function GEM3UI_MembersSort()
 if this.data == "lvl"      then
  GEM3UIMembers.sortfld="lvl";
 elseif this.data == "location" then
  GEM3UIMembers.sortfld="location";
 elseif this.data == "name"     then
  GEM3UIMembers.sortfld="name";
 end
 this.sortdir = not (this.sortdir or false);
 GEM3UIMembers.sortdir = this.sortdir;
 table.sort(GEM3UI_ChannelMembers, GEM3UI_MembersSortlist);
 GEM3UI_ChannelMembersScrollUpdate();
end

function GEM3UI_ColumHeaderHighLight(flag)
 if flag == true then
  getglobal(this:GetName().."Label"):SetTextColor(0,1,0,1);
 else
  getglobal(this:GetName().."Label"):SetTextColor(0.9,0.85,0.15,1);
 end
end

function GEM3UI_ShowHideOfflineMembers()
 GEM3UI_GetChannelMembers();
 GEM3UI_ChannelMembersScrollUpdate();
end

function GEM3UI_ShowHideIgnoredMembers()
 GEM3UI_GetChannelMembers();
 GEM3UI_ChannelMembersScrollUpdate();
end

function GEM3UI_MembersFilterChannelDD(self)
 if GEM3UI_DDTable == nil then
  GEM3UI_DDTable = GA_GetTable();
 end
 table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings["_Channels"],   isTitle = true, textHeight = 12 });
 --table.insert(GEM3UI_ChannelDDTable, {   text = GEM3UI_LocalizedStrings["None"],   isradio = true,   checked = false,   func = function() GEM3UI_EventFilterChannelAllClick(0) end,   closeWhenClicked = true, });
 for i, channel in ipairs(GEM3_QA_Config.channels) do
  if GEM3_PLAY_IsPlayerInChannel(channel.name,UnitName("player")) then
     local tbl = {   text = channel.name,   func = function() GEM3UI_MembersFilterChannelClick(channel.name) end, }
     table.insert(GEM3UI_DDTable, tbl);
  end
 end
 --table.insert(GEM3UI_ChannelDDTable, {   text = GEM3UI_LocalizedStrings["All"],   isradio = true,   checked = false,   func = function() GEM3UI_EventNameFilterOnClickAll(1) end,   closeWhenClicked = true, });
 GEM3UI_SetDDMenu(self, GEM3UI_DDTable)
end

--function GEM3UI_MembersFilterChannelDD()
 --for i, channel in ipairs(GEM3_QA_Config.channels) do
  --if GEM3_PLAY_IsPlayerInChannel(channel.name,UnitName("player")) then
--    GEM3UI_DDAddLine(channel.name, channel.name, channel.name, true, false, GEM3UI_MembersFilterChannelClick);
  --end
 --end
--end

function GEM3UI_MembersFilterChannelClick(value)
 GEM3UI_MembersFilterChannelTextLabel.value = value
 GEM3UI_MembersFilterChannelTextLabel:SetText(value);
 GEM3UI_GetChannelMembers();
 GEM3UI_ChannelMembersScrollUpdate();
end


function GEM3UI_ChannelMembersOnShow()
  if GEM3UI_MembersFilterChannelTextLabel.value ==nil then 
   for i, channel in ipairs(GEM3_QA_Config.channels) do
    if GEM3_PLAY_IsPlayerInChannel(channel.name,UnitName("player")) then
      GEM3UI_MembersFilterChannelTextLabel.value = channel.name;
      GEM3UI_MembersFilterChannelTextLabel:SetText(channel.name);
    end
   end
  end
 if GEM3UIPlayerPanel.stickedLine ~= nil then 
   GEM3UIPlayerPanel.stickedLine:UnlockHighlight();
 end
 GEM3UI_GetChannelMembers();
 GEM3UI_ChannelMembersScrollUpdate();
end

function GEM3UI_GetChannelMembers()
 local channamefilter = GEM3UI_MembersFilterChannelTextLabel.value;
 GEM3UI_ConnectedMembers = 0;
 GEM3UI_ignoredMembers =0;
 GEM3UI_totalMembers=0;

 GEM3UI_ChannelMembersCount = 0;
 GEM3UI_ChannelMembers = {};
 
 for i, chan in ipairs(GEM3_QA_Channels) do
  if GEM3_CHAN_IsChannelActive(chan.name) and  channamefilter == chan.name then
   for i, player in pairs(GEM3_QA_Players[chan.name]) do
     GEM3UI_totalMembers = GEM3UI_totalMembers+1;
     local show = true;
     if GEM3_PLAY_IsPlayerIgnored(player.name) then GEM3UI_ignoredMembers= GEM3UI_ignoredMembers + 1; end
     if player.connected then GEM3UI_ConnectedMembers = GEM3UI_ConnectedMembers + 1; end
         
     if not GEM3UIMembersShowIgnored:GetChecked() and GEM3_PLAY_IsPlayerIgnored(player.name) then
       show = false;
     end
     if not GEM3UIMembersShowOffline:GetChecked() and not player.connected then
        show = false;
     end
     if show then
      GEM3UI_ChannelMembersCount = GEM3UI_ChannelMembersCount + 1;
      GEM3UI_ChannelMembers[GEM3UI_ChannelMembersCount]=player;
     end
   end
  end
 end
 table.sort(GEM3UI_ChannelMembers, GEM3UI_MembersSortlist);
end


function GEM3UI_MemberLineOnClick()
 if arg1 == "RightButton" then
  local dd = getglobal("GEM3UIDropDown");
  dd.target = this.index;
  GEM3UI_DropDowninit();
  GEM3UI_MemberLineMenu(this);
  GEM3UI_DDshow();
 elseif arg1 == "LeftButton" then
  GEM3UI_ContextFrame="GEM3UIPlayerPanel";
  GEM3UIPlayerPanel.Stickedplname = GEM3UI_ChannelMembers[this.index].name;
  --GEM3UI_ActPanel.GEM3UI_OldPanel = GEM3UI_ActPanel;
  if GEM3UIPlayerPanel.stickedLine ~= nil then 
   GEM3UIPlayerPanel.stickedLine:UnlockHighlight();
  end
  GEM3UIPlayerPanel.stickedLine = this;
  this:LockHighlight();
 end
end

function GEM3UI_MemberLineMenu(obj)
 local ls = GEM3UI_LocalizedStrings;
 GEM3UI_DDAddLine("Whisp", GEM3UI_ChannelMembers[obj.index].name, ls["WhispPlayer"], true, false, GEM3UI_MemberMenuClick);
 GEM3UI_DDAddLine("Invite", GEM3UI_ChannelMembers[obj.index].name, ls["InvitePlayer"], true, false, GEM3UI_MemberMenuClick);
 GEM3UI_DDAddLine("Who", GEM3UI_ChannelMembers[obj.index].name, ls["whoPlayer"], true, false, GEM3UI_MemberMenuClick);
 if GEM3_PLAY_IsPlayerIgnored(GEM3UI_ChannelMembers[obj.index].name) == true then 
   GEM3UI_DDAddLine("Unignore", GEM3UI_ChannelMembers[obj.index].name, ls["UnIgnore"], true, false, GEM3UI_MemberMenuClick);
 else
   GEM3UI_DDAddLine("Ignore", GEM3UI_ChannelMembers[obj.index].name, ls["Ignore"], true, false, GEM3UI_MemberMenuClick);
 end
end

function GEM3UI_MemberMenuClick(id, value)
 if      id == "Whisp" then ChatFrameEditBox:Show(); ChatFrameEditBox:Insert("/w "..value);
 elseif  id == "Invite"  then InviteUnit(value);
 elseif  id == "Who"  then SendWho(value);
 elseif  id == "Ignore"  then 
   local dialogFrame = StaticPopup_Show("GEM3UI_CONFIRM", GEM3UI_DIALOG_CONFIRM_MEMBER_IGNORE);
   if(dialogFrame) then dialogFrame.data = value; end
 elseif  id == "Unignore"  then GEM3_PLAY_UnIgnorePlayer(value); GEM3UI_ShowHideIgnoredMembers(); 
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
  --GEM3UI_-RefreshAll();
 end
end


function GEM3UI_CreateChannelMembersline()
 local framename;
 local parent = getglobal("GEM3UIMembersList");
 local line;
 local i;
 for i=1,GEM3UI_DefaultChannelPlayerLines do
  framename = "GEM3UI_ChannelMemberlineFrame"..i;
  line = CreateFrame("BUTTON", framename, parent, "MemberLineTemplate");
  if i > 1 then
    line:SetPoint("TOPLEFT", getglobal("GEM3UI_ChannelMemberlineFrame"..(i-1)), "BOTTOMLEFT", 0, 0);
  else
    line:SetPoint("TOPLEFT", getglobal("GEM3UIMembersListScroll"), "TOPLEFT", 4, -18);
  end
  line:SetWidth(parent:GetWidth()-10);
  line:SetHeight(14);
  line.classicon = getglobal(framename.."ClassIconTexture");
  --line.classicon = line:CreateTexture(framename.."ClassIcon");
  --line.classicon:SetPoint("TOPLEFT", line, "TOPLEFT", 2, -1);
  --line.classicon:SetHeight(12);
  --line.classicon:SetWidth(12);
  --line.classicon:SetDrawLayer("BACKGROUND");

  line.roleicon = getglobal(framename.."RoleIconTexture");
  --line.roleicon = line:CreateTexture(framename.."RoleIcon");
  --line.roleicon:SetPoint("TOPLEFT", line, "TOPLEFT", 14, -1);
  --line.roleicon:SetHeight(12);
  --line.roleicon:SetWidth(12);
  --line.roleicon:SetDrawLayer("ARTWORK");
  
  line.statusicon = getglobal(framename.."StatusIconTexture");
  --line.statusicon = line:CreateTexture(framename.."StatusIcon");
  --line.statusicon:SetPoint("TOPLEFT", line, "TOPLEFT", 28, -1);
  --line.statusicon:SetHeight(12);
  --line.statusicon:SetWidth(12);
  --line.statusicon:SetDrawLayer("ARTWORK");
  line.statusicon:SetTexture("interface\\AddOns\\GEM3UI\\X");

  line.leadicon = getglobal(framename.."LeadIconTexture");
  --line.leadicon = line:CreateTexture(framename.."LeadIcon");
  --line.leadicon :SetPoint("TOPLEFT", line, "TOPLEFT", 42, 0);
  --line.leadicon :SetHeight(12);
  --line.leadicon :SetWidth(12);
  --line.leadicon :SetDrawLayer("ARTWORK");
  line.leadicon:SetTexture("interface\\groupframe\\ui-group-leadericon");
  
  line:Hide();
  line:RegisterForClicks("LeftButtonUp", "RightButtonUp");
 end
end


function GEM3UI_FillChannelMembersLine(i, index)
 local framename = "GEM3UI_ChannelMemberlineFrame"..i;
 local line = getglobal(framename);
 local lbl,r,g,b,a;
 line.roleicon:SetTexture("");
 line.classicon:SetTexture("");
 line.index = index;
 lbl = getglobal(framename.."PlayerNameLabel");
 if GEM3UI_ChannelMembers[index].connected then 
  r = 0;
  g = 1;
  b = 0;
  a = 1;
 else 
  r = 1;
  g = 1;
  b = 1;
  a = 0.8; 
 end
 local pname = GEM3UI_ChannelMembers[index].name;
 lbl:SetText(pname);
 lbl:SetTextColor(r,g,b,a);
 lbl = getglobal(framename.."PlayerLvLLabel");
 lbl:SetText(GEM3UI_ChannelMembers[index].level);
 lbl:SetTextColor(r,g,b,a);
 lbl = getglobal(framename.."PlayerGuildLabel");
 lbl:SetText(GEM3UI_ChannelMembers[index].location);
 lbl:SetTextColor(r,g,b,a);
 
 local classid = GEM3UI_GetClassIndex(GEM3UI_ChannelMembers[index].class);
 local roleid = GEM3UI_GetRoleIndex(GEM3UI_ChannelMembers[index].role);
 line.roleicon:SetTexture("interface\\icons\\"..GEM3UI_Roles[roleid].icon);
 line.classicon:SetTexture("interface\\icons\\"..GEM3UI_Classes[classid].icon);
 
 
 
 line.statusicon:Hide();
 if GEM3_PLAY_IsPlayerIgnored(GEM3UI_ChannelMembers[index].name) then 
  line.statusicon:SetTexture("interface\\AddOns\\GEM3UI\\X");
  line.statusicon:Show(); 
 end
 if GEM3_PLAY_IsPlayerIgnored(GEM3UI_ChannelMembers[index].name) == false and GEM3UI_ChannelMembers[index].isTimeRef then
  line.statusicon:SetTexture("interface\\AddOns\\GEM3UI\\bell");
  line.statusicon:Show(); 
 end
 
 if GEM3UI_ChannelMembers[index].isLeader and GEM3UI_ChannelMembers[index].connected then line.leadicon:Show(); else line.leadicon:Hide(); end
 
 --if GEM3UI_ChannelMembers[index].connected then a = 1; else a=0.4 end
 
 line.classicon:SetAlpha(a);
 line.roleicon:SetAlpha(a);
 
 
 if GEM3UI_ChannelMembersCount > GEM3UI_DefaultChannelPlayerLines then
   line:SetWidth(GEM3UIMembersListScroll:GetWidth());
 else
   line:SetWidth(GEM3UIMembersListScroll:GetWidth()+18);
 end
end

function GEM3UI_ChannelMembersScrollUpdate()
   local line; -- 1 through 5 of our window to scroll
   local lineplusoffset=0; -- an index into our data calculated from the scroll offset
   local cnt = #GEM3UI_ChannelMembers;  

   for line=1,GEM3UI_DefaultChannelPlayerLines do
       getglobal("GEM3UI_ChannelMemberlineFrame"..line):Hide();
   end
   FauxScrollFrame_Update(GEM3UIMembersListScroll,cnt,GEM3UI_DefaultChannelPlayerLines,14);
   for line=1,GEM3UI_DefaultChannelPlayerLines do
     lineplusoffset = line + FauxScrollFrame_GetOffset(GEM3UIMembersListScroll);
     if lineplusoffset < cnt+1 then
       GEM3UI_FillChannelMembersLine(line, lineplusoffset );
       getglobal("GEM3UI_ChannelMemberlineFrame"..line):Show();
     end
   end
   if GEM3UIMembers:IsVisible() then
    GEM3UI_SetStatusMessage(string.format(GEM3UI_LocalizedStrings["_MembersInChannelStatus"], GEM3UI_ConnectedMembers, GEM3UI_ignoredMembers, GEM3UI_totalMembers), 0);
   end
end


function GEM3UI_CreatePlayerTagIcons()
 frm = getglobal("GEM3UIPlayerPlayerTag1");
 if frm == nil then return; end
 
 for i=1, 14 do
   frmname = "GEM3UIPlayerPlayerTag"..i;
   local frm = getglobal(frmname);
   frm:EnableMouse();
   frm.icon = getglobal(frmname.."Texture");
   frm.icon:SetAllPoints();
   frm.icon:SetHeight(15);
   frm.icon:SetWidth(15);
   frm.icon:SetDrawLayer("ARTWORK");
   frm:SetScript("OnLeave", GEM3UI_PlayerLineHideTagPopup);
   frm:SetScript("OnEnter", GEM3UI_PlayerLineShowTagPopup);
   frm:SetScript("OnMouseUp", GEM3UI_PlayerLineShowTagPopup);
 end
end

function GEM3UI_DisplayPlayerDetails()
 if not GEM3UIPlayerPanel:IsVisible() then return; end
 local p = GEM3_PLAY_GetPlayerInfos(GEM3UIPlayerPanel.plname);
 local classid = GEM3UI_GetClassIndex(p.class);
 local roleid = GEM3UI_GetRoleIndex(p.role);
--init
 GEM3UIPlayerPlayerNameLabel:SetText("");
 GEM3UIPlayerPlayerGuildLabel:SetText("");
 GEM3UIPlayerClassIconTexture:SetTexture("");
 GEM3UIPlayerRoleIconTexture:SetTexture("");
 GEM3UIPlayerClassTextLabel:SetText("");
 GEM3UIPlayerRoleTextLabel:SetText("");
 GEM3UIPlayerPlayerLevelLabel:SetText("");
 GEM3UIPlayerPlayerVersionLabel:SetText("");
 GEM3UIPlayerPlayerCommentLabel:SetText("");
 GEM3UIPlayerPlayerGuildRankLabel:SetText("");
 GEM3UIPlayerPlayerStatusLabel:SetText("");
 GEM3UIPlayerPlayerLastLogLabel:SetText("");
 GEM3UIPlayerPlayerZoneLabel:SetText("");
 GEM3UI_CreatePlayerTagIcons();
 for i = 1, 14 do
  local ico = getglobal("GEM3UIPlayerPlayerTag"..i.."Texture");
  ico:SetTexture("");
 end

-- fill

 local i = 1;
 for tagid, tag in pairs(p.tags) do
  if tag[GEM3_ACCESS_INST_TAG_RESET] > time()+GEM3UI.ServerTimeOffSet and i <= 14 then
   local frm = getglobal("GEM3UIPlayerPlayerTag"..i);
   if string.find(TaggedInstances[tagid].icon, "lfgframe") ~= nil then
     frm.icon:SetTexCoord(0,0.8,0,0.72);
   else
     frm.icon:SetTexCoord(0,1,0,1);
   end
   frm.plname=p.name;
   frm.ev_subtype=tagid;
   frm.tags = p.tags
   --id = tag[GEM3_ACCESS_INST_TAG_ID];
   --frm.tagtime = tag[GEM3_ACCESS_INST_TAG_RESET];
   frm.icon:SetTexture(TaggedInstances[tagid].icon);
   i=i+1;
  end
 end
 
 GEM3UIPlayerPlayerNameLabel:SetText(p.name);
 GEM3UIPlayerPlayerGuildLabel:SetText("<"..p.guild..">");
 GEM3UIPlayerClassIconTexture:SetTexture("interface\\icons\\"..GEM3UI_Classes[classid].icon);
 if roleid > 0 then
  GEM3UIPlayerRoleIconTexture:SetTexture("interface\\icons\\"..GEM3UI_Roles[roleid].icon);
 end
 GEM3UIPlayerClassTextLabel:SetText(GEM3UI_Classes[classid].name_loc);
 GEM3UIPlayerRoleTextLabel:SetText(GEM3UI_Roles[roleid].name_loc);
 GEM3UIPlayerPlayerLevelLabel:SetText(p.level);
 GEM3UIPlayerPlayerVersionLabel:SetText(p.version);
 GEM3UIPlayerPlayerCommentLabel:SetText(GEM3UI_LocalizedStrings["_Comment"]..": "..(p.comment or ""));
 GEM3UIPlayerPlayerGuildRankLabel:SetText(p.grank_name);
 if p.officer == 2 then
  GEM3UIPlayerPlayerStatusLabel:SetText(GEM3UI_LocalizedStrings["_GM"]);
 elseif p.officer == 1 then
  GEM3UIPlayerPlayerStatusLabel:SetText(GEM3UI_LocalizedStrings["_Officer"]);
 elseif p.guild == "" then
  GEM3UIPlayerPlayerStatusLabel:SetText(GEM3UI_LocalizedStrings["_Guildless"]);
 else
  GEM3UIPlayerPlayerStatusLabel:SetText(GEM3UI_LocalizedStrings["_GuildMember"]);
 end
 GEM3UIPlayerPlayerLastLogLabel:SetText(date(GEM3UI_DateFormatString, p.lastlog));
 GEM3UIPlayerPlayerZoneLabel:SetText(p.location);
end