﻿function GEM3UI_EventNameFilterDD(self)
 local flton = false;
 local fltoff = false;
 if GEM3UI_EventNameFilters == nil then
  GEM3UI_EventNameFilters = GA_GetTable();
 end
 
 for i, evt in pairs(GEM3UI_EventSource) do
  if not GEM3UI[UnitName("Player")].OnlyMyChannels or (GEM3UI[UnitName("Player")].OnlyMyChannels and GEM3_PLAY_IsPlayerInChannel(evt.channel,UnitName("player"))) then
   if GEM3UI_EventNameFilters[evt.ev_place] == nil then
    if GEM3UI_EventChannelFilters[evt.channel] == true then
     GEM3UI_EventNameFilters[evt.ev_place] = true;
    end
   else 
    if GEM3UI_EventChannelFilters[evt.channel] ~= true then
     GEM3UI_EventNameFilters[evt.ev_place] = nil;
    end
   end
   if GEM3UI_EventNameFilters[evt.ev_place] == true then
    flton = true;
   else
    fltoff=true;
   end
  end
 end
 local title = GEM3UI_LocalizedStrings["_EventNameFilterActivated"];
 if not fltoff then title = GEM3UI_LocalizedStrings["_EventAll"]; end
 if GEM3UI_DDTable == nil then
  GEM3UI_DDTable = GA_GetTable();
 end
 table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings["_EventNameFilter"],   isTitle = true, textHeight = 12 });
 table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings["None"],   isradio = true,   checked = not flton,   func = function() GEM3UI_EventNameFilterOnClickAll(false) end, });
 for i, evtflt in pairs(GEM3UI_EventNameFilters) do
  local tbl = {   text = i,   isradio = true,   checked = evtflt,   func = function() GEM3UI_EventNameFilterOnClick(i) end, }
  table.insert(GEM3UI_DDTable, tbl);
 end
 table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings["All"],   isradio = true,   checked = not fltoff,   func = function() GEM3UI_EventNameFilterOnClickAll(true) end,});
 GEM3UI_SetDDMenu(self,GEM3UI_DDTable)
end


function GEM3UI_EventNameFilterOnClick(evtfltid)
 GEM3UI_EventNameFilters[evtfltid] = not GEM3UI_EventNameFilters[evtfltid] ;
 local isfiltered = false;
 for i, evtflt in pairs(GEM3UI_EventNameFilters) do
   if evtflt == false then
    isfiltered = true; 
   end
 end
 
 if isfiltered then
  GEM3UI_EventNameFilterTextLabel:SetText(GEM3UI_LocalizedStrings["_EventNameFilterActivated"]);
 else
  GEM3UI_EventNameFilterTextLabel:SetText(GEM3UI_LocalizedStrings["_EventAll"]);
 end
 GEM3UI_RefreshView("GEM3UI_REFRESH_CLOSEONLY");
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
end


function GEM3UI_EventNameFilterOnClickAll(flag)
 for i, evtflt in pairs(GEM3UI_EventNameFilters) do
   GEM3UI_EventNameFilters[i]=flag;
 end
 if flag then 
  GEM3UI_EventNameFilterTextLabel:SetText(GEM3UI_LocalizedStrings["_EventAll"]);
 else
  GEM3UI_EventNameFilterTextLabel:SetText(GEM3UI_LocalizedStrings["_EventNameFilterActivated"]);
 end
 --GEM3UI_-RefreshAll(GEM3UI_REFRESH_CLOSE_OPEN_EVENTLINE);
 --GEM3UI_EventListScrollUpdate();
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
end


function GEM3UI_EventsSort(self)
 if self.data == "date"      then
  GEM3UIMain.sortfld="date";
 elseif self.data == "ev_place" then
  GEM3UIMain.sortfld="ev_place";
 elseif self.data == "leader"     then
  GEM3UIMain.sortfld="leader";
 end
 self.sortdir = not (self.sortdir or false);
 GEM3UIMain.sortdir = self.sortdir;
 table.sort(MyEvent, GEM3UI_SortEvList);
 GEM3UI_EventListScrollUpdate();
end


function GEM3UI_SortEvList(e1, e2)
 returnval = GEM3UIMain.sortdir or false;
 if GEM3UIMain.sortfld==nil then GEM3UIMain.sortfld="date"; end
 if e1 == nil then return returnval; end
 if e2 == nil then return not returnval; end
 local E1, E2, E3;
 if GEM3UIMain.sortfld=="date" then
   E1 = e1.ev_date; E2 = e2.ev_date;
 elseif GEM3UIMain.sortfld=="ev_place" then
   E1 = string.upper(e1.ev_place); E2 = string.upper(e2.ev_place);
 elseif GEM3UIMain.sortfld=="leader" then
   E1 = e1.leader; E2 = e2.leader;
 end
 if returnval then E3 = E1; E1 = E2; E2 = E3; end -- change sortorder
  
 if E1 == E2 then
   return e1.cnt < e2.cnt;
 else
  return E1 < E2
 end 
end

function GEM3UI_ToggleArchive()
 GA_ReleaseTable(GEM3UI_EventNameFilters);
 GEM3UI_EventNameFilters = nil;
 GEM3UI_RefreshView("GEM3UI_REFRESH_CLOSEONLY");
 if GEM3UI_ShowTemplates:GetChecked() then GEM3UI_ShowTemplates:SetChecked(false); end
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
 GEM3UI_BuildToolBar();
end

function GEM3UI_DoNothing ()
end

function GEM3UI_ToggleTemplates()
 GA_ReleaseTable(GEM3UI_EventNameFilters);
 GEM3UI_EventNameFilters = nil;
 GEM3UI_RefreshView("GEM3UI_REFRESH_CLOSEONLY");
 if GEM3UI_ShowArchive:GetChecked() then GEM3UI_ShowArchive:SetChecked(false); end
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
 GEM3UI_BuildToolBar();
end


function GEM3UI_EventFilterChannelDD(self)
 if GEM3UI_DDTable == nil then
  GEM3UI_DDTable = GA_GetTable();
 end
 table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings["_Channels"],   isTitle = true, textHeight = 12 });
 --table.insert(GEM3UI_ChannelDDTable, {   text = GEM3UI_LocalizedStrings["None"],   isradio = true,   checked = false,   func = function() GEM3UI_EventFilterChannelAllClick(0) end,   closeWhenClicked = true, });
 local chans = GA_GetTable();
 for name,config in pairs(GEM3_Config[GEM3_Realm]) do 
  if (GEM3UI[UnitName("player")].OnlyMyChannels and name == UnitName("player")) or not GEM3UI[UnitName("player")].OnlyMyChannels then
   for i, chan in ipairs(config.channels) do
    if not chans[chan.name] then 
     local tbl = {   text = chan.name,   isradio = true,   checked = GEM3UI_EventChannelFilters[chan.name],   func = function() GEM3UI_EventFilterChannelClick(chan.name,GEM3UI_EventChannelFilters[chan.name]) end, }
     table.insert(GEM3UI_DDTable, tbl);
     chans[chan.name] = true;
    end
   end
  end
 end
 --table.insert(GEM3UI_ChannelDDTable, {   text = GEM3UI_LocalizedStrings["All"],   isradio = true,   checked = false,   func = function() GEM3UI_EventNameFilterOnClickAll(1) end,   closeWhenClicked = true, });
 GEM3UI_SetDDMenu(self, GEM3UI_DDTable)
 GA_ReleaseTable(chans, 10);
end

function GEM3UI_EventFilterChannelAllClick(index, value)
 if index == 0 then value = false; else value = true; end
 for channame, val in pairs (GEM3UI_EventChannelFilters) do
  GEM3UI_EventChannelFilters[channame] = value;
 end
 GEM3UI.ChannelFilter = GEM3UI_EventChannelFilters;
 GEM3UI_RefreshView("GEM3UI_REFRESH_CLOSEONLY");
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
end


function GEM3UI_EventFilterChannelClick(index, value)
 if GEM3UI_EventChannelFilters[index] then
  GEM3UI_EventChannelFilters[index] = false
 else
  GEM3UI_EventChannelFilters[index] = true
 end
 GEM3UI.ChannelFilter = GEM3UI_EventChannelFilters;
 GEM3UI_RefreshView("GEM3UI_REFRESH_CLOSEONLY");
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
end


function gemuipopulate()
 local subs = nil;
 GEM3UI_totalEvents = 0;
 GEM3UI_closedEvents =0;
 GEM3UI_ignoredEvents =0;
 GEM3UI_subsEvents = 0;
 GEM3UI_eventcount = 0 ;
 MyEvent = {};
 GEM3UI_EventTypePresent = {};

 if GEM3UI_EventNameFilters == nil then
  GEM3UI_EventNameFilters = GA_GetTable();
 end

--- initialize the source of elements to display in the eventlist 
 if GEM3_QA_Events ~= nil then
  if GEM3UI_ShowArchive:GetChecked() then
   GEM3UI_EventSource = GEM3_QA_Events.archived; 
  elseif GEM3UI_ShowTemplates:GetChecked() then
   GEM3UI_EventSource = GEM3UI.Templates; 
  else
   GEM3UI_EventSource = GEM3_QA_Events.events; 
   subs = GEM3_QA_Events.subscribed;
  end
 else
  GEM3UI_EventSource = nil;
 end
--- If Eventlist has to be populated
 if GEM3UI_EventSource ~= nil then
  for ev_id, ev in pairs(GEM3UI_EventSource) do
   
   if not GEM3UI[UnitName("Player")].OnlyMyChannels 
      or (GEM3UI[UnitName("Player")].OnlyMyChannels 
          and GEM3_PLAY_IsPlayerInChannel(ev.channel,UnitName("player"))
         )
      or GEM3UI_ShowTemplates:GetChecked()
   then
    
    
    if GEM3UI_EventTypePresent[ev.ev_type] then
     GEM3UI_EventTypePresent[ev.ev_type] = GEM3UI_EventTypePresent[ev.ev_type] +1;
    else
     GEM3UI_EventTypePresent[ev.ev_type] = 1;
    end
    
    
    local showtype = false;
    for evtypeid, evtype in pairs (GEM3UI_LocalizedStrings.EventTypes) do
     if evtypeid == ev.ev_type and evtype.state == true then
        if ev.ev_type >=20 or ev.ev_type == GEM3_EVT_TYPE_NONE then
         showtype = true;
        elseif GEM3_QA_Config.debug > 0 and ev.ev_type <20 then
         showtype = true;
        end
     end
    end
    
    local showplace = true;
    if GEM3UI_EventNameFilters[ev.ev_place] ~= nil then
       showplace = GEM3UI_EventNameFilters[ev.ev_place];
     end
    
    if not (GEM3UI_EventChannelFilters[ev.channel] or false) and not (GEM3UI_ShowArchive:GetChecked() or GEM3UI_ShowTemplates:GetChecked()) then
     showchannel=false;
    else
     showchannel=true;
    end
        
    if showtype == true and showplace ~= false and showchannel then
    GEM3UI_totalEvents = GEM3UI_totalEvents +1;
    GEM3UI_eventcount = GEM3UI_eventcount +1;
     MyEvent[GEM3UI_eventcount] = {
      ["cnt"] = GEM3UI_eventcount,
      ["id"] = ev_id,
      ["ev_type"] = ev.ev_type,
      ["channel"] = ev.channel,
      ["leader"] = ev.leader,
      ["ev_date"] = (ev.ev_date+(GEM3UI.ServerTimeOffSet*60*60)),
      ["deadline"] = (ev.deadline+(GEM3UI.ServerTimeOffSet*60*60)),
      ["ev_place"] = ev.ev_place,
      ["ev_comment"] = ev.ev_comment,
      ["update_time"] = ((ev.update_time or 0) +(GEM3UI.ServerTimeOffSet*60*60)),
      ["max_count"] = ev.tit_count.."/"..ev.max_count,
      ["min_lvl"] = ev.min_lvl,
      ["max_lvl"] = ev.max_lvl,
      ["sub_count"] = ev.sub_count,
      ["repl_count"] = ev.repl_count,
      ["rej_count"] = ev.rej_count,
      ["outDated"] = false,
      ["ignored"] = false,
      ["closed_comment"] = ev.closed_comment,
      };
      
      MyEvent[GEM3UI_eventcount]["NAcount"] = 0;      
      if not GEM3UI_ShowArchive:GetChecked() and not GEM3UI_ShowTemplates:GetChecked() then
       local nacount = GEM3_CMD_GetNonAckedSubscriptions(ev.id);
       if nacount then
        MyEvent[GEM3UI_eventcount]["NAcount"] = #nacount;
       end
       GA_ReleaseTable(nacount,10);
      end
      
      local count = 0;
      for _,infos in pairs(ev.players) do
       if infos.current_queue == GEM3_SUB_STATE_TITULAR then
        count = count + 1
       end 
      end
      MyEvent[GEM3UI_eventcount]["Totals"]  = count;
      
      if subs then
       if subs[ev_id] ~= nil then
        local rerolls = GEM3_PLAY_GetMyRerolls();
        for i, pl in ipairs(rerolls) do
         if GEM3_SUB_GetSubscribedInfos(ev_id, pl.name) then 
            GEM3UI_subsEvents = GEM3UI_subsEvents +1;
         end
        end
        GA_ReleaseTable(rerolls,0);
       end
      end
      
      if ev.deadline < time() then
       MyEvent[GEM3UI_eventcount]["outdated"] = true;
      end
      if ev.ev_date < time() then
       MyEvent[GEM3UI_eventcount]["passed"] = true;
      end

      if GEM3_EVT_IsEventIgnored(ev.id) then
       MyEvent[GEM3UI_eventcount]["ignored"] = true;
       GEM3UI_ignoredEvents =GEM3UI_ignoredEvents +1;
      end
      if ev.closed_comment ~= nil then
       GEM3UI_closedEvents = GEM3UI_closedEvents +1;
       MyEvent[GEM3UI_eventcount]["closed"] = true;
      end
     end
   end
  end
  table.sort(MyEvent, GEM3UI_SortEvList);
 end
end


function GEM3UI_QueueSelectCBClick(self)
  local cb = self:GetName();
  local state = self:GetChecked();
  GEM3UIeventDetailsAsRepCB:SetChecked(false);
  GEM3UIeventDetailsAsNCCB:SetChecked(false);
  self:SetChecked(state);
end


function GEM3UI_EventlistOnShow()
  gemuipopulate();
  GEM3UI_EventListScrollUpdate();
  GEM3UI_IsEventExpanded()
end


function GEM3UI_IsEventExpanded()
 --mydbg("GEM3UI_IsEventExpanded");
 if GEM3UI_expandedLine > 0 then
  local line = getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine);
  --line:SetBackdropColor(0.5,0.5,0.5,0.8);
  line:LockHighlight();
  if MyEvent[line.ev_index] ~= nil then
   GEM3UIeventDetails.evt = GEM3UI_EventSource[MyEvent[line.ev_index].id]
   GEM3UIEventSubs.evt = GEM3UIeventDetails.evt;
   GEM3UI_EventLinePopulate(); 
   GEM3UI_EventDetailOnShow();
   GEM3UI_EventDetailsShow();
  end
 end
end

function GEM3UI_FillPlayerDetails(p_id)
local p = GEM3UI_EventPlayers[p_id];
local f = "GEM3UIPlayerDetails";
local classid = GEM3UI_GetClassIndex(p.class);
local roleid = GEM3UI_GetRoleIndex(p.role);
local altroleid = GEM3UI_GetRoleIndex(p.alt_role);

--init
getglobal(f.."NameLabel"):SetText("");
getglobal(f.."GuildLabel"):SetText("");
getglobal(f.."LvLLabel"):SetText("");
getglobal(f.."ClassLabel"):SetText("");
getglobal(f.."RoleLabel"):SetText("");
getglobal(f.."QueueLabel"):SetText("");
getglobal(f.."PosLabel"):SetText("");
getglobal(f.."Update_dateLabel"):SetText("");
getglobal(f.."Update_timeLabel"):SetText("");
getglobal(f.."TagRstDateLabel"):SetText("");
getglobal(f.."TagRstTimeLabel"):SetText("");
getglobal(f.."CommentLabel"):SetText("");
getglobal(f.."ClassIconTexture"):SetTexture("");
getglobal(f.."RoleIconTexture"):SetTexture("");
getglobal(f.."AltRoleIconTexture"):SetTexture("");

-- fill
getglobal(f.."NameLabel"):SetText(p.name);
getglobal(f.."GuildLabel"):SetText("<"..p.guild..">");
getglobal(f.."LvLLabel"):SetText(p.level);
getglobal(f.."ClassLabel"):SetText(GEM3UI_Classes[classid].name_loc);
getglobal(f.."RoleLabel"):SetText(GEM3UI_Roles[roleid].name_loc);
if altroleid > 0 then
 getglobal(f.."RoleLabel"):SetText(getglobal(f.."RoleLabel"):GetText().." ("..GEM3UI_Roles[altroleid].name_loc..")");
end

local pfq = "";
if p.lead_force_queue ~= GEM3_SUB_FORCE_QUEUE_NONE then
 pfq = "(F) ";
end

if p.current_queue ~= nil then
  getglobal(f.."QueueLabel"):SetText(pfq..GEM3UI_Queues[p.current_queue].name);
  getglobal(f.."PosLabel"):SetText(pfq..p.queue_pos);
else 
  getglobal(f.."QueueLabel"):SetText(GEM3UI_LocalizedStrings["_not_acknedshort"]);
  getglobal(f.."PosLabel"):SetText("");
end
getglobal(f.."Update_dateLabel"):SetText(date(GEM3UI_DateFormatString, p.main_time));
getglobal(f.."Update_timeLabel"):SetText(date(GEM3UI_TimeFormatString, p.main_time));

 local pl = GEM3_PLAY_GetPlayerInfos(p.name);
 if pl ~= nil then
  if pl.tags[GEM3UIeventDetails.evt.ev_subtype] ~= nil then
   if pl.tags[GEM3UIeventDetails.evt.ev_subtype][GEM3_ACCESS_INST_TAG_RESET] > GEM3UIeventDetails.evt.ev_date+GEM3UI.ServerTimeOffSet then
    local rsttime = pl.tags[GEM3UIeventDetails.evt.ev_subtype][GEM3_ACCESS_INST_TAG_RESET];
    getglobal(f.."TagRstDateLabel"):SetText(date(GEM3UI_DateFormatString,rsttime));
    getglobal(f.."TagRstTimeLabel"):SetText(date(GEM3UI_TimeFormatString,rsttime));
   end
  end
 end

 local commentadd = "";
 if string.sub(p.source, 1,1) == GEM3_SUB_SOURCE_EXTERNAL then
  commentadd = " "..GEM3UI_LocalizedStrings["_AddedExternalby"]..string.sub(p.source, 2);
 end
 mydbg(p.source.." "..commentadd);

getglobal(f.."CommentLabel"):SetText(p.comment..commentadd);
getglobal(f.."ClassIconTexture"):SetTexture("interface\\icons\\"..GEM3UI_Classes[classid].icon);
getglobal(f.."RoleIconTexture"):SetTexture("interface\\icons\\"..GEM3UI_Roles[roleid].icon);
if altroleid > 0 then
 getglobal(f.."AltRoleIconTexture"):SetTexture("interface\\icons\\"..GEM3UI_Roles[altroleid].icon);
end

local classlinep = getglobal("GEM3UI_EventDetailsLimitsFrame"..GEM3UI_Classes[classid].gemid.."Uline");
local rolelinep = getglobal("GEM3UI_EventDetailsLimitsFrame"..GEM3UI_Roles[roleid].name.."Uline");

local parent = getglobal("GEM3UIeventDetailsLimitsFrame");
local classline = getglobal("GEM3UI_EventDetailsClassLimitsHL");
if classline == nil then
    classline  = parent:CreateTexture("GEM3UI_EventDetailsClassLimitsHL");
    classline:SetHeight(15);
    classline:SetWidth(classlinep:GetWidth());
    classline:SetDrawLayer("BORDER");
    classline:SetTexture(0.4,0.4,0.4,0.4);
end
classline:SetPoint("TOPLEFT", classlinep, "TOPLEFT", 0, 0);
classline:Show();
local roleline = getglobal("GEM3UI_EventDetailsRoleLimitsHL");
if roleline == nil then
    roleline = parent:CreateTexture("GEM3UI_EventDetailsRoleLimitsHL");
    roleline:SetHeight(15);
    roleline:SetWidth(rolelinep:GetWidth());
    roleline:SetDrawLayer("BORDER");
    roleline:SetTexture(0.4,0.4,0.4,0.4);
end
roleline:SetPoint("TOPLEFT", rolelinep, "TOPLEFT",0,0);
roleline:Show();

end


function GEM3UI_PlayerLineHighLight(line)
  GEM3UI_FillPlayerDetails(line.player_index);
  GEM3UIPlayerDetails:Show();
  GEM3UI_PlayerLineShowTagPopup(line);
end




function GEM3UI_PlayerLineOut(line)
  local p = GEM3UI_EventPlayers[line.player_index];
  local classid = GEM3UI_GetClassIndex(p.class);
  local roleid = GEM3UI_GetRoleIndex(p.role);
  local classline = getglobal("GEM3UI_EventDetailsClassLimitsHL");
  local roleline = getglobal("GEM3UI_EventDetailsRoleLimitsHL");
  roleline:Hide();
  classline:Hide();
  GEM3UIPlayerDetails:Hide();
  GEM3UI_PlayerLineHideTagPopup();
end


function GEM3UI_PlayerLineLoad(obj)
 GEM3UI_EventLineLoad(obj);
end

function GEM3UI_EventLineLoad(line)
  local bgFile, GEMedgeFile, GEMinsets = line:GetBackdrop();
  --line:SetBackdrop({   bgFile = "interface\\buttons\\bluegrad64",   edgeFile = GEMedgeFile,   insets = GEMinsets   }  );
  --line:SetBackdropColor(0.5,0.5,0.5,0);
end



function GEM3UI_LineButtonClick(self)
 GEM3UI_ExpandEventLine(self:GetParent(), "true");
end


function GEM3UI_EventLineOnDoubleClick()
 if GEM3UI_ShowTemplates:GetChecked() then
  if IsControlKeyDown() then
   GEM3UI_DeleteTemplate(MyEvent[this.ev_index].id);
  else
   GEM3UI_CreateNewFromTemplate(MyEvent[this.ev_index].id);
  end
 end
end

function GEM3UI_EventLineOnClick(self, arg1)
 if arg1 == "RightButton" then
  local dd = getglobal("GEM3UIDropDown");
  GEM3UI_EventLineMenu(self)
  --GEM3UI_DDshow();
 elseif arg1 == "LeftButton" then
  if getglobal(self:GetName().."ExpandButton"):IsVisible() then
   GEM3UI_ExpandEventLine(self, "true");
   GEM3UI_ContextFrame="GEM3UIEventSubs";
  end
 end
end


function GEM3UI_PlayerLineOnClick()
 if arg1 == "RightButton" then
  --local dd = getglobal("GEM3UIDropDown");
  --dd.id  =   getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine).ev_index;
  --dd.target = this.player_index;
  --local plname = GEM3UI_EventPlayers[this.player_index].name;
  --GEM3UI_DropDowninit(plname);
  GEM3UI_PlayerLineMenu(this, getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine).ev_index);
  --GEM3UI_DDshow();
 end
end

function GEM3UI_PlayerLineMenu(obj, ev_id)
 local isleader = nil;
 local isassist = nil;
 local isnotofficer = true;
 if GEM3_IsMyReroll(MyEvent[ev_id].leader) then
  isleader = true;
  isnotofficer =false;
 end
 local plid = obj.player_index;
 local pl = GEM3UI_EventPlayers[plid];
 local plname = pl.name
 if not GEM3UI_ShowTemplates:GetChecked() and not GEM3UI_ShowArchive:GetChecked() then
  if GEM3_EVT_IsAssistant(MyEvent[ev_id].id,UnitName("player")) then
   isassist = true;
   isnotofficer =false;
  end
 end
 
 local ls = GEM3UI_LocalizedStrings;
 
 if GEM3UI_DDTable == nil then
  GEM3UI_DDTable = GA_GetTable();
 end
 table.insert(GEM3UI_DDTable, {   text = plname,   isTitle = true, textHeight = 12 });
 if GEM3UI_ShowTemplates:GetChecked() then
  table.insert(GEM3UI_DDTable, {   text = ls["Delete"],  func = function() GEM3UI_PlayerMenuClick("Delete", plid) end,});
 else
  table.insert(GEM3UI_DDTable, {   text = ls["AssistPlayer"],  disabled = not isleader , func = function() GEM3UI_PlayerMenuClick("Assist", plid) end,});
  table.insert(GEM3UI_DDTable, {   text = ls["Queues"],   isTitle = true, textHeight = 12 });
  table.insert(GEM3UI_DDTable, {   text = ls["ForceNonePlayer"],  disabled = isnotofficer or pl.lead_force_queue == GEM3_SUB_FORCE_QUEUE_NONE, func = function() GEM3UI_PlayerMenuClick("ForceNone", plid) end,});
  table.insert(GEM3UI_DDTable, {   text = ls["ForceTPlayer"],  disabled = isnotofficer or pl.lead_force_queue == GEM3_SUB_FORCE_QUEUE_TITULAR, func = function() GEM3UI_PlayerMenuClick("ForceT", plid) end,});
  table.insert(GEM3UI_DDTable, {   text = ls["ForceSPlayer"],  disabled = isnotofficer or pl.lead_force_queue == GEM3_SUB_FORCE_QUEUE_SUBSTITUTE, func = function() GEM3UI_PlayerMenuClick("ForceS", plid) end,});
  table.insert(GEM3UI_DDTable, {   text = ls["ForceRPlayer"],  disabled = isnotofficer or pl.lead_force_queue == GEM3_SUB_FORCE_QUEUE_REPLACEMENT, func = function() GEM3UI_PlayerMenuClick("ForceR", plid) end,});
  table.insert(GEM3UI_DDTable, {   text = ls["ForceNCPlayer"], disabled = isnotofficer or pl.lead_force_queue == GEM3_SUB_FORCE_QUEUE_NOT_COMING, func = function() GEM3UI_PlayerMenuClick("ForceNC", plid) end,});
  table.insert(GEM3UI_DDTable, {   text = ls["KickPlayer"],  disabled = isnotofficer, func = function() GEM3UI_PlayerMenuClick("Kick", plid) end,});
  table.insert(GEM3UI_DDTable, {   text = ls["BanPlayer"],  disabled = isnotofficer, func = function() GEM3UI_PlayerMenuClick("Ban", plid) end,});
  --table.insert(GEM3UI_DDTable, {   text = ls["UnBanPlayer"],  disabled = not (isofficer and isleader and GEM3_SUB_IsPlayerBanned(MyEvent[ev_id].id,GEM3UI_EventPlayers[plid].name)) , func = function() GEM3UI_PlayerMenuClick("UnBan", plid) end,});
  table.insert(GEM3UI_DDTable, {   text = ls["Ignore"],  disabled = isnotofficer, func = function() GEM3UI_PlayerMenuClick("Ignore", plid) end,});
 end
 table.insert(GEM3UI_DDTable, {   text = "Action",   isTitle = true, textHeight = 12 });
 table.insert(GEM3UI_DDTable, {   text = ls["WhispPlayer"],  func = function() GEM3UI_PlayerMenuClick("Whisp", plid) end,});
 table.insert(GEM3UI_DDTable, {   text = ls["InvitePlayer"],  func = function() GEM3UI_PlayerMenuClick("Invite", plid) end,});
 table.insert(GEM3UI_DDTable, {   text = ls["whoPlayer"],  func = function() GEM3UI_PlayerMenuClick("Who", plid) end,});
 
 GEM3UI_SetDDMenu(nil,GEM3UI_DDTable)
end

function GEM3UI_PlayerMenuClick(id, value)
 local ev_id = MyEvent[getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine).ev_index].id;
 local evt = GEM3UI_EventSource[ev_id];
 local plname = GEM3UI_EventPlayers[value].name;
 if      id == "Assist"   then GEM3_EVT_SetAssistant(evt.id,plname);  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", evt.id);
 --elseif  id == "Leader"   then GEM3_EVT_SetLeader(evt.id,plname);
 elseif  id == "ForceNone" then GEM3_SUB_ForceQueueForPlayer(evt.id,plname,GEM3_SUB_FORCE_QUEUE_NONE);
 elseif  id == "ForceR"   then GEM3_SUB_ForceQueueForPlayer(evt.id,plname,GEM3_SUB_FORCE_QUEUE_REPLACEMENT);
 elseif  id == "ForceNC"  then GEM3_SUB_ForceQueueForPlayer(evt.id,plname,GEM3_SUB_FORCE_QUEUE_NOT_COMING);
 elseif  id == "ForceS"   then GEM3_SUB_ForceQueueForPlayer(evt.id,plname,GEM3_SUB_FORCE_QUEUE_SUBSTITUTE);
 elseif  id == "ForceT"   then GEM3_SUB_ForceQueueForPlayer(evt.id,plname,GEM3_SUB_FORCE_QUEUE_TITULAR);
 elseif  id == "Kick"     then GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_PLAYER_KICK, {evtid = evt.id, pl = plname});
 elseif  id == "Ban"      then GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_PLAYER_BAN, {evtid = evt.id, pl = plname});
 elseif  id == "UnBan"    then GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_PLAYER_BAN, {evtid = evt.id, pl = plname});
 elseif  id == "Ignore"   then GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_MEMBER_IGNORE, plname);
 elseif  id == "Whisp"    then ChatFrameEditBox:Show(); ChatFrameEditBox:Insert("/w "..plname);
 elseif  id == "Invite"   then InviteUnit(plname);
 elseif  id == "Who"      then SendWho(plname);
 elseif  id == "Delete"   then evt.players[plname]=nil
 end
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", nil);
end


function GEM3UI_ProccedPlayerKick(dta, reason)
  GEM3_EVT_KickFromEvent(dta.evtid, dta.pl,reason);
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", dta.evtid);
  --GEM3UI_-RefreshAll();
end

function GEM3UI_ProccedPlayerBan(dta, reason)
  GEM3_EVT_BanFromEvent(dta.evtid, dta.pl,reason);
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", dta.evtid);
  --GEM3UI_-RefreshAll();
end

function GEM3UI_ProccedPlayerUnban(dta)
  GEM3_EVT_unBanFromEvent(dta.evtid, dta.pl);
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", dta.evtid);
  --GEM3UI_-RefreshAll();
end


function GEM3UI_EventLineMenu(obj)
 local isleader = GEM3_IsMyReroll(MyEvent[obj.ev_index].leader);
 local archive = GEM3UI_ShowArchive:GetChecked();
 local templates = GEM3UI_ShowTemplates:GetChecked();
 local ls = GEM3UI_LocalizedStrings;

 if GEM3UI_DDTable == nil then
  GEM3UI_DDTable = GA_GetTable();
 end
 table.insert(GEM3UI_DDTable, {   text = MyEvent[obj.ev_index].ev_place,   isTitle = true, textHeight = 12 });
 local evid = MyEvent[obj.ev_index].id;
 if not archive and not templates then
  table.insert(GEM3UI_DDTable, {   text = ls["Modify"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("Modify", evid) end,});
  table.insert(GEM3UI_DDTable, {   text = ls["Archive"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("Archive", evid) end,});
  if MyEvent[obj.ev_index].closed == true then
    table.insert(GEM3UI_DDTable, {   text = ls["Open"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("Open", evid) end,});
  else
    table.insert(GEM3UI_DDTable, {   text = ls["Close"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("Close", evid) end,});
  end
  table.insert(GEM3UI_DDTable, {   text = ls["Delete"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("Delete", evid) end,});
  if MyEvent[obj.ev_index].ignored == true then
    table.insert(GEM3UI_DDTable, {   text = ls["Unignore"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("Unignore", evid) end,});
  else
    table.insert(GEM3UI_DDTable, {   text = ls["Ignore"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("Ignore", evid) end,});
  end
  table.insert(GEM3UI_DDTable, {   text = ls["CopyasTemplate"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("CopyasTemplate", evid) end,});
 end
 if archive then
   table.insert(GEM3UI_DDTable, {   text = ls["Delete"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("DeleteArchive", evid) end,});
 end
 if templates then
  table.insert(GEM3UI_DDTable, {   text = ls["CreateNew"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("CreateFromTemplate", evid) end,});
  table.insert(GEM3UI_DDTable, {   text = ls["Delete"],  disabled = not isleader , func = function() GEM3UI_EventMenuClick("DeleteTemplate", evid) end,});
 end
  GEM3UI_SetDDMenu(nil,GEM3UI_DDTable)
end

function GEM3UI_EventLineOnEnter()
   mydbg("GEM3UI_EventlineOnenter");
   local es = getglobal("GEM3UIEventSubs");
   if GEM3UI_expandedLine == 0 then
     es.ev_index = this.ev_index;
     es.evt= GEM3UI_EventSource[MyEvent[this.ev_index].id];
     es.form=false;
     if es:IsVisible() then
      es:Hide();
     end
     es:Show();
     if GEM3UI_SET_EVTCHANGE_TBL(es.evt, GEM3UI_EVENT_CHANGE_VIEWED) then
      GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", es.evt.id);
      --GEM3UI_-RefreshAll();
     end
   end
   GEM3UI_SetDebugStatus(string.format("EVENTLINE: %s, EVENT ID : %s ", this.ev_index, MyEvent[this.ev_index].id ),0);
end


function GEM3UI_EventLineOnLeave()
   local es = getglobal("GEM3UIEventSubs");
   if GEM3UI_expandedLine == 0 then
     es:Hide();
   end
   es.form=true;
end

function GEM3UI_EventMenuClick(id, value)
 if      id == "Delete" then GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_EVENT_DELETE,value); 
 elseif  id == "DeleteArchive"  then GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_EVENTARCHIVE_DELETE, value); 
 elseif  id == "Modify"  then GEM3UI_EventEdit(value);
 elseif  id == "Archive"  then GEM3_EVT_ArchiveEvent(value);
 elseif  id == "Close"  then GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_EVENT_CLOSE, value); 
 elseif  id == "Open"  then GEM3_EVT_UnCloseEvent(value); GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", value);
 elseif  id == "Ignore"  then GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_EVENT_IGNORE, value); 
 elseif  id == "Unignore"  then GEM3_EVT_UnIgnoreEvent(value); GEM3_EVT_UnCloseEvent(value); GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", value);
 elseif  id == "Expand"  then GEM3_EVT_CloseEvent(value);
 elseif  id == "Collapse"  then GEM3UI_EventClose(value);
 elseif  id == "CreateFromTemplate"  then GEM3UI_CreateNewFromTemplate(value);
 elseif  id == "DeleteTemplate"  then GEM3UI_DeleteTemplate(value);
 elseif  id == "CopyasTemplate"  then GEM3UI_CreateModifyEvent(true, GEM3UI_EventSource[value]);
 
 end
end


function GEM3UI_DeleteTemplate(value)
 table.remove(GEM3UI.Templates, value);
 --GEM3UI_-RefreshAll();
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
end



function GEM3UI_EventDelete(id)
 local expline = getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine);
 if expline ~= nil then
  if expline.ev_index == id then
   GEM3UI_ExpandEventLine(expline, true);
  end
 end
 if GEM3UI.ArchiveBeforeDelete then
   GEM3_EVT_ArchiveEvent(id);
 end
 GEM3_EVT_DeleteEvent(id);
 GEM3UI_SetStatusMessage(string.format("EVENT: %s DELETED", id),2);
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
end


function GEM3UI_EventDeleteArchive(id)
 local expline = getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine);
 if expline ~= nil then
  GEM3UI_ExpandEventLine(expline, true);
 end
 GEM3_EVT_DeleteArchivedEvent(id);
 GEM3UI_SetStatusMessage(string.format("EVENT Archive: %s DELETED", id),2);
 --GEM3UI_-RefreshAll();
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
end



function GEM3UI_ExpandEventLine(line, eventlistupdate)
 local lineid = string.sub(line:GetName(),17)*1;
 local isleader = false;
 local es = getglobal("GEM3UIEventSubs");
 if getglobal(line:GetName().."ExpandButton"):IsEnabled() == false then return; end
 if line.ignored == true and GEM3UI_expandedLine ~= lineid and isleader== false then return; end
 if MyEvent[line.ev_index] == nil then return; end
 local lineheader = getglobal(line:GetName().."HeadLineBG");
 if UnitName("player") == MyEvent[line.ev_index].leader then
  isleader = true;
 end
 if GEM3UI_expandedLine == lineid then
   line:SetHeight(GEM3UI_DefaultLineHeight);
   if GEM3UI_lines <= GEM3UI_DefaultLines then
    GEM3UIMainEventScrollList:SetVerticalScroll(0);
   end
   GEM3UIEventSubs:Hide();
   GEM3UI_lines = GEM3UI_DefaultLines;
   GEM3UI_expandedLine= 0;
   getglobal(line:GetName().."ExpandButton"):SetText("+");
   GEM3UIeventDetails:Hide();
   GEM3UIMainEventScrollList:SetVerticalScroll(1);
   GEM3UI_SetDebugStatus(string.format("EVENT: %s COLLAPSED", MyEvent[line.ev_index].id),0);
   --line:SetBackdropColor(0.5,0.5,0.5,0);
   line:UnlockHighlight();
   lineheader:Hide();
   line.expanded = false;
   --line:SetHighlightTexture("interface\\buttons\\ui-listbox-highlight2");
 else
   if GEM3UI_expandedLine ~= 0 then
     local expline = getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine);
     GEM3UI_ExpandEventLine(expline, false);
     GEM3UIEventSubs:Hide();
     getglobal(expline:GetName().."HeadLineBG"):Hide();
   end
   GEM3UI_lines = GEM3UI_DefaultLines-GEM3UI_DefaultLineExpandedMultiplicator+1;
   local scrollup =  lineid + GEM3UI_DefaultLineExpandedMultiplicator-GEM3UI_DefaultLines;
   if scrollup > 0 then
    GEM3UIMainEventScrollList:SetVerticalScroll(GEM3UIMainEventScrollList:GetVerticalScroll()+(GEM3UI_DefaultLineHeight*scrollup));
    lineid = lineid - scrollup;
   end
   GEM3UI_expandedLine = lineid;
   line = getglobal("GEM3UI_lineFrame"..lineid);
   
   lineheader = getglobal(line:GetName().."HeadLineBG");
   line:SetHeight(GEM3UI_DefaultLineExpandedMultiplicator*GEM3UI_DefaultLineHeight);
   getglobal(line:GetName().."ExpandButton"):SetText("-");
   GEM3UIeventDetails.evt = GEM3UI_EventSource[MyEvent[line.ev_index].id];
   GEM3UIeventDetails.recover = false;
   GEM3UIeventDetails:Show();
   GEM3UIeventDetails:SetParent(line);
   GEM3UIeventDetails:SetPoint("TOPLEFT", line ,"TOPLEFT", 1, -17);
   GEM3UIeventDetails:SetPoint("BOTTOMRIGHT", line ,"BOTTOMRIGHT", -1, 1);
   GEM3UI_Scrollpos = GEM3UIMainEventScrollList:GetVerticalScroll();
   es:Hide();
   es.ev_index = line.ev_index;
   es.form=true;
   es:Show();
   --line:SetBackdropColor(0.5,0.5,0.5,1);
   --line:SetHighlightTexture("interface\\dialogframe\\ui-dialogbox-gold-background");
   line.expanded = true;
   lineheader:Show();
   line:LockHighlight();
   GEM3UI_SetDebugStatus(string.format("EVENT: %s EXPANDED", MyEvent[line.ev_index].id),0);
 end
 
 if eventlistupdate == "true" then 
   GEM3UI_EventListScrollUpdate(); 
 end
end

function GEM3UI_Subscribe()
 local ev_id = GEM3UIEventSubs.evt.id;
 local player = GEM3_PLAY_GetPlayerInfos(GEM3UI_ActualPlayerTextLabel:GetText());
 local force_queue = GEM3_SUB_FORCE_QUEUE_NONE;
 if GEM3UIeventDetailsAsRepCB:GetChecked() then 
  force_queue = GEM3_SUB_FORCE_QUEUE_REPLACEMENT;
 elseif GEM3UIeventDetailsAsNCCB:GetChecked() then 
  force_queue = GEM3_SUB_FORCE_QUEUE_NOT_COMING;
 end
 local subs, reason  = GEM3_SUB_Subscribe(
                    ev_id,
                    GEM3UI_ActualPlayerTextLabel.id,
                    player.guild,
                    player.level,
                    player.class,
                    GEM3UI_ActualRoleTextLabel.id,
                    GEM3UI_SUB_Comment:GetText(),
                    force_queue,
                    GEM3UI_AlternateRoleTextLabel.id or GEM3_ROLE_UNKNOWN);
 if subs then
  PlaySound("PVPENTERQUEUE");
 else
  PlaySound("igQuestFailed");
 end                    
 --GEM3UI_-RefreshAll();
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
 GEM3UI_SubsFromRefresh();
 GEM3UI_SetStatusMessage(reason);
 GEM3UI_CheckSubsEdit();
end

function GEM3UI_ModifySubscribe()
 local ev_id = GEM3UIEventSubs.evt.id;
 
 local subs = GEM3_SUB_GetSubscribedInfos(ev_id, GEM3UI_ActualPlayerTextLabel.id);
 
 local force_queue = GEM3_SUB_FORCE_QUEUE_NONE;
 if GEM3UIeventDetailsAsRepCB:GetChecked() then 
  force_queue = GEM3_SUB_FORCE_QUEUE_REPLACEMENT;
 elseif GEM3UIeventDetailsAsNCCB:GetChecked() then 
  force_queue = GEM3_SUB_FORCE_QUEUE_NOT_COMING;
 end
 
 local ret, reason  = GEM3_SUB_SubscribeUpdate(
       ev_id,
       subs.name,
       subs.guild,
       subs.level,
       subs.class,
       GEM3UI_ActualRoleTextLabel.id,
       GEM3UI_SUB_Comment:GetText(),
       force_queue,
       GEM3UI_AlternateRoleTextLabel.id or GEM3_ROLE_UNKNOWN);
 if ret then
  PlaySound("PVPENTERQUEUE");
 else
  PlaySound("igQuestFailed");
 end
 --GEM3UI_-RefreshAll();
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
 GEM3UI_SubsFromRefresh();
 GEM3UI_SetStatusMessage(reason);
 GEM3UI_CheckSubsEdit();
end


function GEM3UI_UnSubscribe()
 
 local ev_id = GEM3UIEventSubs.evt.id;
 local player = GEM3_PLAY_GetPlayerInfos(GEM3UI_ActualPlayerTextLabel.id);
 subs, reason  = GEM3_SUB_SubscribeUpdate(
                    ev_id,
                    GEM3UI_ActualPlayerTextLabel.id,
                    player.guild,
                    player.level,
                    player.class,
                    GEM3UI_ActualRoleTextLabel.id,
                    GEM3UI_SUB_Comment:GetText(),
                    GEM3_SUB_FORCE_QUEUE_NOT_COMING,
                    GEM3UI_AlternateRoleTextLabel.id or GEM3_ROLE_UNKNOWN);
 --GEM3UI_-RefreshAll();
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
 GEM3UI_SubsFromRefresh();
 GEM3UI_SetStatusMessage(reason);
 GEM3UI_CheckSubsEdit();
end

function GEM3UI_CheckSubsEdit()
 GEM3UIEventSubs.userIsEditing = nil;
 if not GEM3UIEventSubs.ev_id then return; end
 local s = GEM3_SUB_GetSubscribedInfos(GEM3UIEventSubs.ev_id, GEM3UI_ActualPlayerTextLabel:GetText())
 if s == nil then s = { comment = "", role = GEM3_QA_Config.role, alt_role = GEM3_ROLE_UNKNOWN, state = GEM3_SUB_STATE_TITULAR}; end
 state = GEM3_SUB_STATE_TITULAR;
 if GEM3UIeventDetailsAsRepCB:GetChecked() then state = GEM3_SUB_STATE_REPLACEMENT end
 if GEM3UIeventDetailsAsNCCB:GetChecked() then state = GEM3_SUB_STATE_NOT_COMING end
 if s.comment  ~= GEM3UI_SUB_Comment:GetText()
 or s.alt_role ~= (GEM3UI_AlternateRoleTextLabel.id or GEM3_ROLE_UNKNOWN)
 or s.role     ~= (GEM3UI_ActualRoleTextLabel.id or GEM3_ROLE_UNKNOWN)
 or s.state    ~= state
 then 
   GEM3UIEventSubs.userIsEditing = true;
 end
end


function GEM3UI_DisplayDaydetails()
 local parent = getglobal("GEM3UIDay");
 local prevbut = getglobal(parent:GetName().."prevbut");
 if prevbut == nil then
  prevbut = CreateFrame("BUTTON", parent:GetName().."prevbut", parent, "PrevButtonTemplate");
  prevbut:SetPoint("TOPLEFT", parent, 5, -5);
  prevbut:SetWidth(16);
  prevbut:SetHeight(16);
  prevbut:SetText("<");
  prevbut:SetScript("OnClick", GEM3UI_PrevDay);
 end
 local nextbut = getglobal(parent:GetName().."nextbut");
 if nextbut == nil then
  nextbut= CreateFrame("BUTTON", parent:GetName().."nextbut", parent, "NextButtonTemplate");
  nextbut:SetPoint("TOPLEFT", parent, 148, -5);
  nextbut:SetWidth(16);
  nextbut:SetHeight(16);
  nextbut:SetText(">");
  nextbut:SetScript("OnClick", GEM3UI_NextDay);
 end
 local m = GEM3UIDay.d;
 local i = 0;
 GEM3UI_DayEvents = {};
 GEM3UI_DayEventCount = 0;
 for i in pairs(MyEvent) do 
  local db = time({["year"] = m.year, ["month"] = m.month, ["day"] = m.day, ["hour"] = 0, ["min"] = 0});
  local de = time({["year"] = m.year, ["month"] = m.month, ["day"] = m.day, ["hour"] = 23, ["min"] = 59});
  if MyEvent[i].ev_date > db and MyEvent[i].ev_date < de then
    GEM3UI_DayEventCount = GEM3UI_DayEventCount +1;
    GEM3UI_DayEvents[GEM3UI_DayEventCount]=i;
  end
 end
 GEM3UI_DayEventListScrollUpdate();
 
 GEM3UIDayDayLabel:SetText(GEM3UI_LocalizedStrings.day[m.wday-1].." "..m.day);
 GEM3UIDayDayMonthYearLabel:SetText(GEM3UI_LocalizedStrings.month[m.month].." "..m.year);
end


function GEM3UI_HighlightEventList(d, lock) 
 for i=1, GEM3UI_DefaultLines do
  local line = getglobal("GEM3UI_lineFrame"..i);
  if lock == true then
   if line:IsVisible() then
    if d <= MyEvent[line.ev_index].ev_date and (d+60*60*24) >= MyEvent[line.ev_index].ev_date then
     line:LockHighlight();
    end
   end
  else
   line:UnlockHighlight();
  end
 end
end


function GEM3UI_EventDetailsShow(id)
 local ev = GEM3UIEventSubs.evt;
 local es = getglobal("GEM3UIEventSubs");
 local now = time();
 
 GEM3UI_eventSubscriptionListInvite:Disable();
 GEM3UI_eventSubscriptionListAddMember:Disable();
 if ev.leader == UnitName("player") or GEM3_EVT_IsAssistant(ev.id,UnitName("player"))
  then
   if not GEM3UI_EventIsGroupFull(ev) 
      and (GEM3UI_GroupingForEvent == nil or GEM3UI_GroupingForEvent == ev.id)
   then
    GEM3UI_eventSubscriptionListInvite:Enable();
   end
   GEM3UI_eventSubscriptionListAddMember:Enable();
  end
 
 local evico = getglobal ("GEM3UIEventSubsEventIcon");
 if evico == nil then
   evico = GEM3UIEventSubs:CreateTexture("GEM3UIEventSubsEventIcon");
   evico:SetPoint("TOPLEFT", GEM3UIEventSubs, "TOPLEFT", 7, -6);
   evico:SetWidth(20);
   evico:SetHeight(20);
   evico:SetDrawLayer("ARTWORK");
   evico:Show();
 end
 evico:SetTexture(GEM3UI_LocalizedStrings.EventTypes[ev.ev_type].tbin);
  
 local evdelimiter = getglobal ("GEM3UIEventSubsEventDelimiter1");
 if evdelimiter == nil then
   evdelimiter = GEM3UIEventSubs:CreateTexture("GEM3UIEventSubsEventDelimiter1");
   evdelimiter:SetPoint("TOPLEFT", GEM3UIEventSubs, "TOPLEFT", 3, -3);
   evdelimiter:SetWidth(GEM3UIEventSubs:GetWidth()-6);
   evdelimiter:SetHeight(24);
   evdelimiter:Show();
   evdelimiter:SetDrawLayer("BACKGROUND");
   evdelimiter:SetTexture(0.4,0.4,0.4,1);
 end
 local evdelimiter = getglobal ("GEM3UIEventSubsEventDelimiter2");
 if evdelimiter == nil then
   evdelimiter = GEM3UIEventSubs:CreateTexture("GEM3UIEventSubsEventDelimiter2");
   evdelimiter:SetPoint("TOPLEFT", GEM3UIEventSubsEv_NameLabel, "BOTTOMLEFT", -5, -1);
   evdelimiter:SetWidth(GEM3UIEventSubs:GetWidth()-6);
   evdelimiter:SetHeight(1);
   evdelimiter:Show();
   evdelimiter:SetDrawLayer("BACKGROUND");
   evdelimiter:SetTexture(0.5,0.5,0.5,1);
 end
 local evdelimiter = getglobal ("GEM3UIEventSubsEventDelimiter3");
 if evdelimiter == nil then
   evdelimiter = GEM3UIEventSubs:CreateTexture("GEM3UIEventSubsEventDelimiter3");
   evdelimiter:SetPoint("TOPLEFT", GEM3UIEventSubsEv_CommentLabel, "BOTTOMLEFT", -5, -1);
   evdelimiter:SetWidth(GEM3UIEventSubs:GetWidth()-6);
   evdelimiter:SetHeight(1);
   evdelimiter:Show();
   evdelimiter:SetDrawLayer("BACKGROUND");
   evdelimiter:SetTexture(0.5,0.5,0.5,1);
 end

 
 
 if GEM3UI_ShowTemplates:GetChecked() then
  GEM3UIEventSubsEv_NameLabel:SetText(ev.ev_place);
  GEM3UIEventSubsLeaderLabel:SetText(UnitName("player"));
  GEM3UIEventSubsEv_SubsLabel:SetText("");
  GEM3UIEventSubsEvDateLabel:SetText("");
  --GEM3UIEventSubsEvTimeLabel:SetText("");
  GEM3UIEventSubsEv_CommentLabel:SetText(GEM3UI_LocalizedStrings["_Comment"]..": ");
  GEM3UIEventSubsMessageTextLabel:SetText("");
 else
  GEM3UIEventSubsEv_NameLabel:SetText(ev.ev_place);
  GEM3UIEventSubsLeaderLabel:SetText(ev.leader);
  GEM3UIEventSubsEv_SubsLabel:SetText(ev.tit_count.."/"..ev.max_count.."("..ev.repl_count..")/["..ev.sub_count.."]");
  local datestr = GEM3UI_LocalizedStrings["dayshort"][date("*t", ev.ev_date+(GEM3UI.ServerTimeOffSet*60*60)).wday-1];
  datestr = datestr.." "..date(GEM3UI_DateFormatString.." "..GEM3UI_TimeFormatString, ev.ev_date+(GEM3UI.ServerTimeOffSet*60*60));
  GEM3UIEventSubsEvDateLabel:SetText(datestr);
  --GEM3UIEventSubsEvTimeLabel:SetText(date("%H:%M", ev.ev_date));
  GEM3UIEventSubsEv_CommentLabel:SetText(GEM3UI_LocalizedStrings["_Comment"]..": "..ev.ev_comment);
  es.ev_id = ev.id;
  if ev.deadline == nil then ev.deadline = ev.ev_date; end
 end

 local playerison, rerollison = GEM3_CHAN_IsChannelConfiguredForAnyReroll(ev.channel);

 GEM3UIEventSubsForm:Hide();
 GEM3UIEventSubsMessage:Show();
 if GEM3UI_ShowArchive:GetChecked() then
  GEM3UIEventSubsMessageTextLabel:SetText(GEM3UI_LocalizedStrings["cannotsubsarchived"]);
 elseif GEM3UI_ShowTemplates:GetChecked() then
  GEM3UIEventSubsMessageTextLabel:SetText(GEM3UI_LocalizedStrings["cannotsubstemplate"]);
 elseif (now>ev.deadline or now>ev.ev_date) then
   GEM3UIEventSubsMessageTextLabel:SetText(GEM3UI_LocalizedStrings["cannotsubspassed"]);
 elseif  ev.closed_comment ~= nil then
  if ev.closed_comment == "Ignored" then
   GEM3UIEventSubsMessageTextLabel:SetText(GEM3UI_LocalizedStrings["cannotsubsignored"]);
  else
   GEM3UIEventSubsMessageTextLabel:SetText(string.format(GEM3UI_LocalizedStrings["cannotsubsclosed"],ev.closed_comment));
  end
 elseif GEM3_EVT_IsEventIgnored(ev.id) then
  GEM3UIEventSubsMessageTextLabel:SetText(GEM3UI_LocalizedStrings["cannotsubsignored"]); 
 elseif not rerollison then
  GEM3UIEventSubsMessageTextLabel:SetText(GEM3UI_LocalizedStrings["cannotsubsotherchan"]);
 else
  GEM3UIEventSubsMessageTextLabel:SetText("");
 end

 if GEM3UIEventSubsMessageTextLabel:GetText() == nil then 
   GEM3UIEventSubsForm:Show();
   GEM3UIEventSubsMessage:Hide();
   GEM3UI_SubsFromRefresh();
 else
   GEM3UIEventSubsForm:Hide();
   GEM3UIEventSubsMessage:Show();
 end
end

function GEM3UI_SubsFromRefresh(id)
 if GEM3UIEventSubs.userIsEditing == true and id == nil then return; end
 local ev;
 GEM3UIEventSubsFormCancelButton:Disable();
 GEM3UIEventSubsFormSubscribeButton:Disable();
 GEM3UIeventDetailsAsRepCB:SetChecked(false);
 GEM3UIeventDetailsAsNCCB:SetChecked(false);
 GEM3UI_SUB_Comment:SetText("");
 GEM3UIEventSubsFormSubscribeButton:SetScript("OnClick", GEM3UI_Subscribe);
 GEM3UIEventSubsFormSubscribeButton:SetText(GEM3UI_LocalizedStrings["_Subscribe"]);
 ev = GEM3UI_EventSource[GEM3UIEventSubs.ev_id];
 if ev == nil then return; end
 
 GEM3UI_AlternateRoleTextLabel.id= GEM3_ROLE_UNKNOWN;
 GEM3UI_AlternateRoleTextLabel.value = GEM3_ROLE_UNKNOWN;
 GEM3UI_AlternateRoleTextLabel:SetText(GEM3UI_Roles[GEM3UI_GetRoleIndex(GEM3_ROLE_UNKNOWN)].name_loc);
 
 if id == nil then 
   GEM3UI_ActualPlayerTextLabel:SetText(UnitName("player"));
   GEM3UI_ActualPlayerTextLabel.id = UnitName("player");
   GEM3UI_ActualPlayerTextLabel.value =  UnitName("player");
  
   GEM3UI_ActualRoleTextLabel.id = GEM3_QA_Config.role;
   GEM3UI_ActualRoleTextLabel.value = GEM3_QA_Config.role;
   GEM3UI_ActualRoleTextLabel:SetText(GEM3UI_Roles[GEM3UI_GetRoleIndex(GEM3_QA_Config.role)].name_loc);
   local rerolls =  GEM3_PLAY_GetMyRerolls();
   --for pl_index, pl_struct in ipairs(rerolls) do
    local plsub = GEM3_SUB_GetSubscribedInfos(ev.id, UnitName("player"));
    if plsub then
     GEM3UI_ActualPlayerTextLabel:SetText(plsub.name);
     GEM3UI_ActualPlayerTextLabel.id=plsub.name;
     GEM3UI_ActualPlayerTextLabel.value=plsub.name;
     GEM3UI_ActualRoleTextLabel.id = plsub.role;
     GEM3UI_ActualRoleTextLabel.value = plsub.role;
     GEM3UI_ActualRoleTextLabel:SetText(GEM3UI_Roles[GEM3UI_GetRoleIndex(plsub.role)].name_loc);
     
     GEM3UI_AlternateRoleTextLabel.id= plsub.alt_role;
     GEM3UI_AlternateRoleTextLabel.value = plsub.alt_role;
     GEM3UI_AlternateRoleTextLabel:SetText(GEM3UI_Roles[GEM3UI_GetRoleIndex(plsub.alt_role)].name_loc);

     if plsub.state == 3 then GEM3UIeventDetailsAsRepCB:SetChecked(true); end
     if plsub.state == 4 then GEM3UIeventDetailsAsNCCB:SetChecked(true); end
     GEM3UI_SUB_Comment:SetText(plsub.comment);
     GEM3UIEventSubsFormSubscribeButton:SetText(GEM3UI_LocalizedStrings["_Update"]);
     GEM3UIEventSubsFormSubscribeButton:SetScript("OnClick", GEM3UI_ModifySubscribe);
     GEM3UIEventSubsFormSubscribeButton:Enable();
     GEM3UIEventSubsFormCancelButton:Enable();
     GEM3UIEventSubsFormCancelButton:SetScript("OnClick", GEM3UI_UnSubscribe);
    end
   --end
   GEM3UIEventSubsFormSubscribeButton:Enable();
   GA_ReleaseTable(rerolls,0);
  else
   local plsub = GEM3_SUB_GetSubscribedInfos(ev.id,GEM3UI_ActualPlayerTextLabel:GetText());
   if plsub then
     GEM3UIEventSubsFormSubscribeButton:SetText(GEM3UI_LocalizedStrings["_Update"]);
     GEM3UIEventSubsFormSubscribeButton:SetScript("OnClick", GEM3UI_ModifySubscribe);
     GEM3UIEventSubsFormSubscribeButton:Enable();
     GEM3UIEventSubsFormCancelButton:Enable();
     GEM3UIEventSubsFormCancelButton:SetScript("OnClick", GEM3UI_UnSubscribe);
     
     GEM3UI_ActualRoleTextLabel.id = plsub.role;
     GEM3UI_ActualRoleTextLabel.value = plsub.role;
     GEM3UI_ActualRoleTextLabel:SetText(GEM3UI_Roles[GEM3UI_GetRoleIndex(plsub.role)].name_loc);
     
     GEM3UI_AlternateRoleTextLabel.id= plsub.alt_role;
     GEM3UI_AlternateRoleTextLabel.value = plsub.alt_role;
     GEM3UI_AlternateRoleTextLabel:SetText(GEM3UI_Roles[GEM3UI_GetRoleIndex(plsub.alt_role)].name_loc);

     if plsub.state == 3 then GEM3UIeventDetailsAsRepCB:SetChecked(true); end
     if plsub.state == 4 then GEM3UIeventDetailsAsNCCB:SetChecked(true); end
     GEM3UI_SUB_Comment:SetText(plsub.comment);
     GEM3UIEventSubsFormSubscribeButton:Enable();
   else
     local roles, altrole;
     local p = GEM3_PLAY_GetPlayerInfos(GEM3UI_ActualPlayerTextLabel:GetText());
     if p == nil then
      role =  GEM3_QA_Config.role;
      altrole = GEM3_ROLE_UNKNOWN;
     else
      role = p.role;
      altrole = p.alt_role;
     end
     GEM3UI_ActualRoleTextLabel.id = role;
     GEM3UI_ActualRoleTextLabel.value = role;
     GEM3UI_ActualRoleTextLabel:SetText(GEM3UI_Roles[GEM3UI_GetRoleIndex(role)].name_loc);
     
     GEM3UI_AlternateRoleTextLabel.id= altrole;
     GEM3UI_AlternateRoleTextLabel.value = altrole;
     GEM3UI_AlternateRoleTextLabel:SetText(GEM3UI_Roles[GEM3UI_GetRoleIndex(altrole)].name_loc);
     
     GEM3UIEventSubsFormSubscribeButton:SetText(GEM3UI_LocalizedStrings["_Subscribe"]);
     GEM3UIEventSubsFormSubscribeButton:SetScript("OnClick", GEM3UI_Subscribe);
     GEM3UIEventSubsFormSubscribeButton:Enable();
     GEM3UIEventSubsFormCancelButton:Disable();
   end
  end
end


function GEM3UI_SortEventPlayer(e1,e2)
 local res = false;
 local e1q, e2q, e1pos, e2pos;
 
 
 if e1.current_queue ~= nil then
  e1q = e1.current_queue;
  e1pos = e1.queue_pos;
 else
  e1q = 10;
  e1pos = e1.update_time;
 end
 
 if e2.current_queue ~= nil then
  e2q = e2.current_queue;
  e2pos = e2.queue_pos;
 else
  e2q = 10;
  e2pos = e2.update_time;
 end
 
 if e2q > e1q then
   res = true;
 elseif e2q == e1q then
  if e1pos == nil then e1pos = 0; end
  if e2pos == nil then e2pos = 0; end
  if e2pos > e1pos then
   res = true;
  end
 end
 return res;
end

function GEM3UI_EventLinePopulate()
 --mydbg("GEM3UI_EventLinePopulate");
 local ev = GEM3UIeventDetails.evt;
 local players = ev.players;
 local climits = ev.classes;
 local rlimits = ev.roles;
 local parent = getglobal("GEM3UI_eventSubscriptionList");
 GEM3UI_eventmembercount =0;
 if GEM3UI_EventPlayers == nil then
  GEM3UI_EventPlayers= GA_GetTable();
 else
  GEM3UI_EventPlayers = GA_WipeTable(GEM3UI_EventPlayers,0);
 end
 local playerslist = getglobal("GEM3UI_eventSubscriptionListScroll");
 
 if not GEM3UI_ShowArchive:GetChecked() then
  players = GEM3_CMD_GetNonAckedSubscriptions(ev.id);
  if players ~= nil then
   for _, pl_struct in ipairs(players) do
     if (pl_struct.force_queue == GEM3_SUB_FORCE_QUEUE_NOT_COMING) then
      pl_struct.current_queue = GEM3_SUB_STATE_NOT_COMING;
     end
     if (pl_struct.force_queue == GEM3_SUB_FORCE_QUEUE_REPLACEMENT) then
      pl_struct.current_queue = GEM3_SUB_STATE_REPLACEMENT;
     end
     if (GEM3UI_RoleFilter == nil and GEM3UI_ClassFilter == nil)
        or bit.band(GEM3UI_RoleFilter or 0, pl_struct.role) ~= 0
        or GEM3UI_ClassFilter == pl_struct.class
     then
      GEM3UI_eventmembercount = GEM3UI_eventmembercount +1;
      table.insert(GEM3UI_EventPlayers, pl_struct);
     end
   end
   GA_ReleaseTable(players);
  end
 end
 
 for name, pl_struct in pairs(ev.players) do
   local isNA = false;
   for i, pl in pairs(GEM3UI_EventPlayers) do
    if pl.name == pl_struct.name then
     isNA= true;
    end
   end
   if isNA == false then
     if (GEM3UI_RoleFilter == nil and GEM3UI_ClassFilter == nil)
        or bit.band(GEM3UI_RoleFilter or 0, pl_struct.role) ~= 0
        or GEM3UI_ClassFilter == pl_struct.class
     then
     GEM3UI_eventmembercount = GEM3UI_eventmembercount +1;
     table.insert(GEM3UI_EventPlayers, pl_struct);
    end
   end
 end
 
 table.sort(GEM3UI_EventPlayers,GEM3UI_SortEventPlayer);
 
 local lbl;
 for i in pairs(GEM3UI_Classes) do
  if GEM3UI_Classes[i].active == true then
   local limindex = GEM3UI_Classes[i].gemid;
   local limitmax = climits[limindex].max;
   local limitmin = climits[limindex].min;
   local tit_count = climits[limindex].tit_count;
   local sub_count = climits[limindex].sub_count;
   local repl_count = climits[limindex].repl_count;
   if limitmax == nil then limitmax = ""; end
   if limitmin == nil then limitmin = ""; end
   if tit_count == 0 then tit_count = ""; end
   if sub_count == 0 then sub_count = ""; end
   if repl_count == 0 then repl_count = ""; end
   
   lbl = getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limindex .."TLabel");
   lbl:SetText(tit_count);
   lbl:SetTextColor(1,1,1,1);
   
   lbl=getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limindex .."SLabel");
   lbl:SetText(sub_count);
   lbl:SetTextColor(1,1,1,1);
   
   lbl=getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limindex .."RLabel");
   lbl:SetText(repl_count);
   lbl:SetTextColor(1,1,1,1);
   
   lbl = getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limindex .."MiLabel");
   lbl:SetText(limitmin);
   lbl:SetTextColor(1,1,1,1);
--   if ((tonumber(tit_count) or 0) + (tonumber(sub_count) or 0)) >= (tonumber(limitmin) or 0) then
   if (tonumber(tit_count) or 0) < (tonumber(limitmin) or 0) then
     lbl:SetTextColor(1,0,0,1);
   end
   
   lbl = getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limindex .."MaLabel");
   lbl:SetText(limitmax);
   lbl:SetTextColor(1,1,1,1);
   --if ((tonumber(tit_count) or 0)+ (tonumber(sub_count) or 0)) > (tonumber(limitmax) or 0) then
--     lbl:SetTextColor(1,0,0,1);
   --end
  end
 end
 
 for i in pairs(GEM3UI_Roles) do
  if GEM3UI_Roles[i].active == true or i == 4 then
   if not (i == 4 and GEM3UI_ShowTemplates:GetChecked()) then   
    local limindex = GEM3UI_Roles[i].gemid;
    local limname = GEM3UI_Roles[i].name;
    if rlimits[limindex] ~= nil then
     local rmin = rlimits[limindex].min;
     local rmax = rlimits[limindex].max;
     local rtit = rlimits[limindex].tit_count;
     local rsub = rlimits[limindex].sub_count;
     local rrep = rlimits[limindex].repl_count;
     if rmax == nil then rmax = ""; end
     if rmin == nil then rmin = ""; end
     if rtit == 0 then rtit = ""; end
     if rsub == 0 then rsub = ""; end
     if rrep == 0 then rrep = ""; end
   
     lbl=getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limname.."TLabel");
     lbl:SetText(rtit);
     lbl:SetTextColor(1,1,1,1);
   
     lbl=getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limname.."SLabel");
     lbl:SetText(rsub);
     lbl:SetTextColor(1,1,1,1);
   
     lbl=getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limname.."RLabel");
     lbl:SetText(rrep);
     lbl:SetTextColor(1,1,1,1);
   
     lbl = getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limname .."MiLabel");
     lbl:SetText(rmin);
     lbl:SetTextColor(1,1,1,1);
     --if ((tonumber(rtit) or 0) + (tonumber(rsub) or 0)) >= (tonumber(rmin) or 0) then
     if (tonumber(rtit) or 0) < (tonumber(rmin) or 0) then
       lbl:SetTextColor(1,0,0,1);
     end
   
     lbl = getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limname .."MaLabel");
     lbl:SetText(rmax);
     lbl:SetTextColor(1,1,1,1);
     --if ((tonumber(rtit) or 0) + (tonumber(rsub) or 0)) > (tonumber(rmax) or 0) then
 --      lbl:SetTextColor(1,0,0,1);
     --end
    end
   end
  end
 end
 GEM3UI_DrawEventDetailsLimits();
 GEM3UI_EventMembersListScrollUpdate();
 if GEM3UIMain:IsVisible() then
  local es = getglobal("GEM3UIEventSubs");
  es.ev_index = ev.id;
  if not GEM3UI_ShowArchive:GetChecked() then
   GEM3UI_SubsFromRefresh();
  end
 end



--   ["deadline"] = ev.deadline,
--   ["update_time"] = ev.update_time,
end

function GEM3UI_FilterPlayerListReset()
 mydbg("GEM3UI_FilterPlayerListReset");
 GEM3UI_RoleFilter = nil;
 GEM3UI_ClassFilter = nil;
 GEM3UI_EventLinePopulate();
 local classline = getglobal("GEM3UI_EventDetailsClassLimitsHL");
 classline:Hide();
end

function GEM3UI_FilterPlayerListRole(id)
 mydbg("GEM3UI_FilterPlayerListRole");
 GEM3UI_RoleFilter = GEM3UI_Roles[id].gemid;
 GEM3UI_EventLinePopulate();
 GEM3UI_FilterPlayerListHighlight("ROLE", id)
end

function GEM3UI_FilterPlayerListClass(id)
 mydbg("GEM3UI_FilterPlayerListClass");
 GEM3UI_ClassFilter = GEM3UI_Classes[id].gemid;
 GEM3UI_EventLinePopulate();
 GEM3UI_FilterPlayerListHighlight("CLASS", id)
end


function GEM3UI_FilterPlayerListHighlight(ftype, id)
 mydbg("GEM3UI_FilterPlayerListHighlight");
 local parent = getglobal("GEM3UIeventDetailsLimitsFrame");
 local line = getglobal("GEM3UI_EventDetailsClassLimitsHL");
 
 local linep = nil
 if ftype == "CLASS" then
  linep = getglobal("GEM3UI_EventDetailsLimitsFrame"..GEM3UI_Classes[id].gemid.."Uline");
 else 
  linep = getglobal("GEM3UI_EventDetailsLimitsFrame"..GEM3UI_Roles[id].name.."Uline");
 end
 if line == nil then
    line  = parent:CreateTexture("GEM3UI_EventDetailsClassLimitsHL");
    line:SetHeight(15);
    line:SetWidth(linep:GetWidth());
    line:SetDrawLayer("BORDER");
    line:SetTexture(0.4,0.4,0.4,0.4);
 end
 if ftype == "CLASS" and id == 10 then
  line:SetPoint("TOPLEFT", linep, "TOPLEFT", 0, -8);
 else
  line:SetPoint("TOPLEFT", linep, "TOPLEFT", 0, 0);
  line:Show();
 end
 --line:Show();
end



function GEM3UI_DrawEventDetailsLimits()
  mydbg("GEM3UI_DrawEventDetailsLimits");
  local parent = getglobal("GEM3UIeventDetailsLimitsFrame");
  -- Draw Classlimit horizontal separators
   for i in pairs(GEM3UI_Classes) do
    local limindex = GEM3UI_Classes[i].gemid;
    local texname = "GEM3UI_EventDetailsLimitsFrame"..limindex.."Uline";
    local anchorparent = getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limindex.."TLabel");
    GEM3UI_CreatePlainTexture(parent, texname, anchorparent, 0, -133, parent:GetWidth()-8, 1, "ARTWORK", 1, 1, 1, 0.2);
    local tmp = getglobal(texname.."ClassIcon");
    if tmp == nil then
      tmp = parent:CreateTexture(texname.."ClassIcon");
    end
    tmp:SetPoint("TOPLEFT", anchorparent, "TOPLEFT", -125, -2);
    tmp:SetHeight(12);
    tmp:SetWidth(12);
    tmp:SetDrawLayer("ARTWORK");
    tmp:SetTexture("interface\\icons\\"..GEM3UI_Classes[i].icon);
   end
  -- Draw Rolelimit horizontal separators
  for i in pairs(GEM3UI_Roles) do
   local limname = GEM3UI_Roles[i].name;
   local texname = "GEM3UI_EventDetailsLimitsFrame"..limname.."Uline";
   local anchorparent = getglobal("GEM3UIeventDetailsLimitsFrameLimit"..limname.."TLabel");
   GEM3UI_CreatePlainTexture(parent, texname, anchorparent, 0, -133, parent:GetWidth()-8, 1, "ARTWORK", 1, 1, 1, 0.2);
   local tmp = getglobal(texname.."RoleIcon");
   if tmp == nil then
    tmp = parent:CreateTexture(texname.."RoleIcon");
   end
   tmp:SetPoint("TOPLEFT", anchorparent, "TOPLEFT", -125, -2);
   tmp:SetHeight(12);
   tmp:SetWidth(12);
   tmp:SetDrawLayer("ARTWORK");
   tmp:SetTexture("interface\\icons\\"..GEM3UI_Roles[i].icon);
  end
  -- thicker seperator line between Classes and Roles
  local texname = "GEM3UI_EventDetailsLimitsFrameHEROUline";
  local anchorparent = getglobal("GEM3UIeventDetailsLimitsFrameLimitHEROTLabel");
  GEM3UI_CreatePlainTexture(parent, texname, anchorparent, 6, -133, parent:GetWidth()-8, 6, "ARTWORK", 1, 1, 1, 0.2);
  
  -- Draw vertical seperators
  local texname = "GEM3UI_EventDetailsLimitsFrameTITUline";
  local anchorparent = getglobal("GEM3UIeventDetailsLimitsFrameLimitHeaderTITLabel");
  GEM3UI_CreatePlainTexture(parent, texname, anchorparent, 0, 0, 1, 250, "ARTWORK", 1, 1, 1, 0.2);
  local texname = "GEM3UI_EventDetailsLimitsFrameSUBUline";
  local anchorparent = getglobal("GEM3UIeventDetailsLimitsFrameLimitHeaderSUBLabel");
  GEM3UI_CreatePlainTexture(parent, texname, anchorparent, 0, 0, 1, 250, "ARTWORK", 1, 1, 1, 0.2);
  local texname = "GEM3UI_EventDetailsLimitsFrameREPUline";
  local anchorparent = getglobal("GEM3UIeventDetailsLimitsFrameLimitHeaderREPLabel");
  GEM3UI_CreatePlainTexture(parent, texname, anchorparent, 0, 0, 1, 250, "ARTWORK", 1, 1, 1, 0.2);
  local texname = "GEM3UI_EventDetailsLimitsFrameMINUline";
  local anchorparent = getglobal("GEM3UIeventDetailsLimitsFrameLimitHeaderMINLabel");
  GEM3UI_CreatePlainTexture(parent, texname, anchorparent, 0, -6, 6, 250, "ARTWORK", 1, 1, 1, 0.2);
  local texname = "GEM3UI_EventDetailsLimitsFrameMAXUline";
  local anchorparent = getglobal("GEM3UIeventDetailsLimitsFrameLimitHeaderMAXLabel");
  GEM3UI_CreatePlainTexture(parent, texname, anchorparent, 0, 0, 1, 250, "ARTWORK", 1, 1, 1, 0.2);
  
  --disable HERO LINE
  local col = {};
  local texname = getglobal("GEM3UIeventDetailsLimitsFrameLimitHEROTitleLabel");
  col.r, col.g, col.b, col.a = texname:GetTextColor();
  texname:SetTextColor(col.r, col.g, col.b, 0.2);
  local texname = getglobal("GEM3UIeventDetailsLimitsFrameLimitHEROTLabel");
  texname:SetText("");
  local texname = getglobal("GEM3UIeventDetailsLimitsFrameLimitHEROSLabel");
  texname:SetText("");
  local texname = getglobal("GEM3UIeventDetailsLimitsFrameLimitHERORLabel");
  texname:SetText("");
  local texname = getglobal("GEM3UIeventDetailsLimitsFrameLimitHEROMiLabel");
  texname:SetText("");
  local texname = getglobal("GEM3UIeventDetailsLimitsFrameLimitHEROMaLabel");
  texname:SetText("");
end

function GEM3UI_CreatePlainTexture(parent, texname, anchorparent, top, left, width, height, layer, cr, cg, cb, ca)
   local uline = getglobal(texname);
   if uline == nil then
    uline = parent:CreateTexture(texname);
    uline:SetPoint("TOPLEFT", anchorparent, "TOPLEFT", left, top);
    uline:SetHeight(height);
    uline:SetWidth(width);
    uline:SetTexture(cr,cg,cb,ca);
    uline:SetDrawLayer(layer);
   else
    uline:SetPoint("TOPLEFT", anchorparent, "TOPLEFT", left, top);
    uline:SetHeight(height);
    uline:SetWidth(width);
    uline:SetTexture(cr,cg,cb,ca);
    uline:SetDrawLayer(layer);
   end
end


function createDayEventline()
 local framename;
 local parent = getglobal("GEM3UIDay");
 local line;
 local i;
 for i=1,GEM3UI_DefaultDayEvents do
  framename = "GEM3UI_DayEventlineFrame"..i;
  line = getglobal(framename);
  if line == nil then
   line = CreateFrame("BUTTON", framename, parent, "DayEventLineTemplate");
  end
  if i > 1 then
    line:SetPoint("TOPLEFT", getglobal("GEM3UI_DayEventlineFrame"..(i-1)), "BOTTOMLEFT", 0, 0);
  else
    line:SetPoint("TOPLEFT", getglobal("GEM3UIDayEventScrollList"), "TOPLEFT", 3, 0);
  end 
  line:SetHeight(15);
  line:SetWidth(GEM3UIDayEventScrollList:GetWidth()+17);
  line:Hide();
  line:RegisterForClicks("LeftButtonUp", "RightButtonUp");
 end
end


function GEM3UI_fillDayEventLine(i, index)
 --if GEM3UI_ShowTemplates:GetChecked() then return; end
 local framename = "GEM3UI_DayEventlineFrame"..i;
 local line = getglobal(framename);
 line.index = index;
 local ev = GEM3UI_EventSource[MyEvent[GEM3UI_DayEvents[index]].id];
 local r = 1;
 local g = 1;
 local b = 1;
 local a = 1;
 
 local rerolls =  GEM3_PLAY_GetMyRerolls();
 for i in pairs(rerolls) do
   local subsdet = ev.players[rerolls[i].name];
   if subsdet ~= nil then
    if subsdet.current_queue <= GEM3_SUB_STATE_NOT_ACKED and
       subsdet.current_queue > GEM3_SUB_STATE_NONE then     
            r = GEM3UI_EVSUBS[subsdet.current_queue].text_color.r;
            g = GEM3UI_EVSUBS[subsdet.current_queue].text_color.g;
            b = GEM3UI_EVSUBS[subsdet.current_queue].text_color.b;
            a = GEM3UI_EVSUBS[subsdet.current_queue].text_color.a;
    end
   end
 end
 
 local lbl = getglobal(framename.."EventTimeLabel");
 lbl:SetText(date(GEM3UI_TimeFormatString, MyEvent[GEM3UI_DayEvents[index]].ev_date+(GEM3UI.ServerTimeOffSet*60*60)));
 lbl:SetTextColor(r,g,b,a);
 
 lbl = getglobal(framename.."EventNameLabel")
 lbl:SetText(MyEvent[GEM3UI_DayEvents[index]].ev_place);
 lbl:SetTextColor(r,g,b,a);
 
 if GEM3UI_DayEventCount > GEM3UI_DefaultDayEvents then
   line:SetWidth(GEM3UIDayEventScrollList:GetWidth());
 else
   line:SetWidth(GEM3UIDayEventScrollList:GetWidth()+17);
 end
end

function GEM3UI_DayEventListScrollUpdate()
   local line; -- 1 through 5 of our window to scroll
   local lineplusoffset=0; -- an index into our data calculated from the scroll offset
   local cnt = GEM3UI_DayEventCount;

   for line=1,GEM3UI_DefaultDayEvents do
       getglobal("GEM3UI_DayEventlineFrame"..line):Hide();
   end
   FauxScrollFrame_Update(GEM3UIDayEventScrollList,cnt,GEM3UI_DefaultDayEvents,14);
   for line=1,GEM3UI_DefaultDayEvents do
     lineplusoffset = line + FauxScrollFrame_GetOffset(GEM3UIDayEventScrollList);
     if lineplusoffset < cnt+1 then
       GEM3UI_fillDayEventLine(line, lineplusoffset );
       getglobal("GEM3UI_DayEventlineFrame"..line):Show();
     end
   end
 end



function GEM3UI_EventMembersListScrollUpdate()
   local line; -- 1 through 5 of our window to scroll
   local lineplusoffset=0; -- an index into our data calculated from the scroll offset
   local cnt = GEM3UI_eventmembercount;

   for line=1,GEM3UI_DefaultPlayerLines do
       getglobal("GEM3UI_PlayerlineFrame"..line):Hide();
   end
   FauxScrollFrame_Update(GEM3UI_eventSubscriptionListScroll,cnt,GEM3UI_DefaultPlayerLines,14);
   for line=1,GEM3UI_DefaultPlayerLines do
     lineplusoffset = line + FauxScrollFrame_GetOffset(GEM3UI_eventSubscriptionListScroll);
     if lineplusoffset < cnt+1 then
       GEM3UI_fillPlayersLine(line, lineplusoffset );
       getglobal("GEM3UI_PlayerlineFrame"..line):Show();
     end
   end
 end


function GEM3UI_PlayerLineShowTagPopup(line)
 if line.plname==nil then return; end
 local tagicon = getglobal ("GEM3UIPlayerTagToolTipIcon");
 if tagicon == nil then 
  tagicon = GameTooltip:CreateTexture("GEM3UIPlayerTagToolTipIcon");
  tagicon:SetPoint("TOPRIGHT", GameTooltip, "TOPLEFT", 2, -2);
  tagicon:SetHeight(60);
  tagicon:SetWidth(60);
  --tagicon:SetDrawLayer("HIGHLIGH");
 end
 tagicon:Show();
 local msg =         line.plname;
 if line.tags ~= nil then
  for i, tag in pairs (TaggedInstances) do
   if bit.band(line.ev_subtype, i) ~= 0 and line.tags[i] ~= nil then
    msg = msg .. "\n".. GEM3UI_LocalizedStrings[TaggedInstances[i].name]
    msg = msg .. "\n".. "ID   : "..line.tags[i][GEM3_ACCESS_INST_TAG_ID];
    msg = msg .. "\n".. "Reset: "..date(GEM3UI_DateFormatString.." "..GEM3UI_TimeFormatString, line.tags[i][GEM3_ACCESS_INST_TAG_RESET]);
    if string.find(TaggedInstances[i].icon, "lfgframe") ~= nil then
     tagicon:SetTexCoord(0,0.8,0,0.72);
    else
     tagicon:SetTexCoord(0,1,0,1);
    end
    tagicon:SetTexture(TaggedInstances[i].icon);
   end
  end
 end
 GEM3UI_GameTooltipShow(msg, true);
end

function GEM3UI_PlayerLineHideTagPopup()
 
 GameTooltip:Hide();
 local tagicon = getglobal ("GEM3UIPlayerTagToolTipIcon");
 if tagicon ~= nil then
  tagicon:Hide();
 end
end

function GEM3UI_fillPlayersLine(i, index)
 local framename = "GEM3UI_PlayerlineFrame"..i;
 local line = getglobal(framename);
 local P = GEM3UI_TblCpy(GEM3UI_EventPlayers[index]);
 local pl = GEM3_PLAY_GetPlayerInfos(P.name);
 line.player_index = index;
 line.fqueue = GEM3UI_EventPlayers[index].force_queue
 local lbl = getglobal(framename.."PlayerNameLabel");
 lbl:SetText(P.name);
 local PlayerOnline = GEM3UI_IsPlayerOnline(GEM3UIeventDetails.evt.channel, P.name);

 line.classicon:SetTexture("");
 line.roleicon:SetTexture("");
 line.altroleicon:SetTexture("");
 line.tagicon:SetTexture("");
 line.commenticon:SetTexture("");
 
 
 if (P.lead_force_queue or GEM3_SUB_FORCE_QUEUE_NONE) ~= GEM3_SUB_FORCE_QUEUE_NONE then
  line.hl:Show();
 else
  line.hl:Hide();
 end
 
 line.plname=nil;
 local player_tagged = nil;
 if pl ~= nil then
    for i,tag in pairs (TaggedInstances) do
     if bit.band (GEM3UIeventDetails.evt.ev_subtype, i) ~= 0 then
      if pl.tags[i] ~= nil then
       if pl.tags[i][GEM3_ACCESS_INST_TAG_RESET] > GEM3UIeventDetails.evt.ev_date+GEM3UI.ServerTimeOffSet then
         player_tagged = i;
       end
      end
     end
    end
    if player_tagged then
      line.tagicon:SetTexture(TaggedInstances[player_tagged].icon);
      line.plname=pl.name;
      line.ev_subtype=GEM3UIeventDetails.evt.ev_subtype;
      line.tags = pl.tags;
      --[GEM3UIeventDetails.evt.ev_subtype][GEM3_ACCESS_INST_TAG_ID]
      --line.tagtime = pl.tags[GEM3UIeventDetails.evt.ev_subtype][GEM3_ACCESS_INST_TAG_RESET]
      if string.find(TaggedInstances[player_tagged].icon, "lfgframe") ~= nil then
       line.tagicon:SetTexCoord(0,0.8,0,0.72);
      else
       line.tagicon:SetTexCoord(0,1,0,1);
      end
    end
  end
 
 
 local col = {1,1,1,1};
 if PlayerOnline == true then 
  if UnitInParty(GEM3UI_EventPlayers[index].name) or UnitInRaid(GEM3UI_EventPlayers[index].name) then
   col = {0.3,0.3,0.8,1};
  else
    col = {0,1,0,1};
  end
 else
  if GEM3UI_EventPlayers[index].current_queue == GEM3_SUB_STATE_NOT_COMING then
   col = {0.6,0.1,0.1,1};
  else
   col = {1,1,1,1};
  end

 end
 lbl:SetTextColor(unpack(col)); 
 
 if GEM3UI_EventPlayers[index].current_queue == GEM3_SUB_STATE_NOT_COMING then
   col = {0.6,0.1,0.1,1};
 end
 
 if P.source == nil then P.source = GEM3_SUB_SOURCE_SELF; end
 if string.sub(P.source, 1,1) == GEM3_SUB_SOURCE_EXTERNAL then
  line.subssourceicon:SetTexture("interface\\buttons\\ui-guildbutton-officernote-up");
 elseif string.sub(P.source, 1,1) == GEM3_SUB_SOURCE_TEMPLATE then
  line.subssourceicon:SetTexture("interface\\buttons\\ui-sliderbar-button-horizontal");
 elseif string.sub(P.source, 1,1) == GEM3_SUB_SOURCE_WEB then
  line.subssourceicon:SetTexture("interface\\ui-guildbutton-motd-up");
 elseif string.sub(P.source, 1,1) == GEM3_SUB_SOURCE_SELF then
  line.subssourceicon:SetTexture("");
 end
 
 line.isofficericon:Hide();
 if GEM3UIeventDetails.evt.leader == P.name then
  line.isofficericon:SetTexture("interface\\groupframe\\ui-group-leadericon");
  line.isofficericon:Show();
 end

 if GEM3_EVT_IsAssistant(GEM3UIeventDetails.evt.id, P.name) then
  line.isofficericon:SetTexture("interface\\groupframe\\ui-group-assistanticon");
  line.isofficericon:Show();
 end

 if P.comment ~= "" then
     line.commenticon:SetTexture("interface\\buttons\\ui-guildbutton-publicnote-up");
 end
 
 
 lbl = getglobal(framename.."PlayerPosLabel")
 if P.current_queue ~= nil then
  if P.current_queue == GEM3_SUB_STATE_NOT_COMING
    or P.current_queue == GEM3_SUB_STATE_REPLACEMENT then
   lbl:SetText(GEM3UI_Queues[P.current_queue].short);
  else
   lbl:SetText(GEM3UI_Queues[P.current_queue].short..P.queue_pos);
  end
 else
  lbl:SetText(GEM3UI_LocalizedStrings["_not_acknedshort"]);
 end
 lbl:SetTextColor(unpack(col)); 
 
 
 
 lbl = getglobal(framename.."PlayerLvLLabel");
 lbl:SetText(P.level);
 lbl:SetTextColor(unpack(col));
 
 local classid = GEM3UI_GetClassIndex(P.class);
 local roleid = GEM3UI_GetRoleIndex(P.role);
 local altroleid = GEM3UI_GetRoleIndex(P.alt_role);
 line.classicon:SetTexture("interface\\icons\\"..GEM3UI_Classes[classid].icon);
 line.roleicon:SetTexture("interface\\icons\\"..GEM3UI_Roles[roleid].icon);
 line.altroleicon:SetTexture("interface\\icons\\"..GEM3UI_Roles[altroleid].icon);
 
 
 if GEM3UI_eventmembercount > GEM3UI_DefaultPlayerLines then
   line:SetWidth(GEM3UI_eventSubscriptionListScroll:GetWidth());
 else
   line:SetWidth(GEM3UI_eventSubscriptionListScroll:GetWidth()+18);
 end
 
 if GEM3UIeventDetails.recover ~= true then
  line:SetScript("OnClick", GEM3UI_PlayerLineOnClick);
 else
  line:SetScript("OnClick", nil)
 end
end


function createplayersline()
 local framename;
 local parent = getglobal("GEM3UI_eventSubscriptionList");
 local line;
 local i;
 for i=1,GEM3UI_DefaultPlayerLines do
  framename = "GEM3UI_PlayerlineFrame"..i;
  line = getglobal(framename);
  if line == nil then
   line = CreateFrame("BUTTON", framename, parent, "PlayerLineTemplate");
  end
  if i > 1 then
    line:SetPoint("TOPLEFT", getglobal("GEM3UI_PlayerlineFrame"..(i-1)), "BOTTOMLEFT", 0, 0);
  else
    line:SetPoint("TOPLEFT", getglobal("GEM3UI_eventSubscriptionList"), "TOPLEFT", 5, -18);
  end
  line:SetWidth(parent:GetWidth()-10);
  line:SetHeight(14);
  line.classicon = getglobal(framename.."ClassIconTexture");
  line.roleicon = getglobal(framename.."RoleIconTexture");
  line.altroleicon = getglobal(framename.."AltRoleIconTexture");
  
  line.tagicon = getglobal(framename.."TagIconTexture");
  line.tagicon:ClearAllPoints();
  line.tagicon:SetPoint("TOPRIGHT", line, "TOPRIGHT", -2, -1);
  line.tagicon:SetWidth(12);
  line.tagicon:SetHeight(12);
  
  line.commenticon = getglobal(framename.."HasCommentTexture");
  line.commenticon:ClearAllPoints();
  line.commenticon:SetPoint("TOPRIGHT", line, "TOPRIGHT", -15, -1);
  line.commenticon:SetWidth(12);
  line.commenticon:SetHeight(12);
  
  line.subssourceicon = getglobal(framename.."SubsSourceTexture");
  line.subssourceicon:ClearAllPoints();
  line.subssourceicon:SetPoint("TOPRIGHT", line, "TOPRIGHT", -28, -1);
  line.subssourceicon:SetWidth(12);
  line.subssourceicon:SetHeight(12);
  
  line.isofficericon = getglobal(framename.."IsOfficerTexture");
  line.isofficericon:ClearAllPoints();
  line.isofficericon:SetPoint("TOPRIGHT", line, "TOPRIGHT", -41, -1);
  line.isofficericon:SetWidth(12);
  line.isofficericon:SetHeight(12);
  
  
  line.hl = getglobal(framename.."HLTexture"); 
  if line.hl  == nil then
  line.hl = line:CreateTexture(framename.."HLTexture", "ARTWORK");
  line.hl:SetTexture(1,1,1,0.1);
  
  line.hl:SetPoint("BOTTOMLEFT", getglobal(framename.."PlayerPos"), "BOTTOMLEFT", 0, 1);
  line.hl:SetWidth(8);
  line.hl:SetHeight(12);
 end
  
  
  line:RegisterForClicks("LeftButtonUp", "RightButtonUp");
  line:Hide();
  
 end
end



function GEM3UI_EventListScrollUpdate()
   mydbg("GEM3UI_EventListScrollUpdate");
   local line; -- 1 through 5 of our window to scroll
   local lineplusoffset; -- an index into our data calculated from the scroll offset
   local cnt = GEM3UI_eventcount;
   for line=1,GEM3UI_DefaultLines do
       getglobal("GEM3UI_lineFrame"..line):Hide();
   end
   FauxScrollFrame_Update(GEM3UIMainEventScrollList,cnt,GEM3UI_lines,14);
   for line=1,GEM3UI_lines do
     lineplusoffset = line + FauxScrollFrame_GetOffset(GEM3UIMainEventScrollList);
     if lineplusoffset < cnt+1 then
       GEM3UI_fillLine(line, lineplusoffset );
       getglobal("GEM3UI_lineFrame"..line):Show();
     end
   end
   GEM3UI_IsEventExpanded();
   GEM3UI_SetStatusMessage(string.format(GEM3UI_LocalizedStrings["_EventsStatus"], GEM3UI_totalEvents , GEM3UI_closedEvents, GEM3UI_subsEvents, GEM3UI_ignoredEvents), 0);
end

function createuiline()
 local framename;
 local line;
 local i;
 for i=1,GEM3UI_DefaultLines do
  framename = "GEM3UI_lineFrame"..i;
  line = getglobal(framename);
  if line == nil then
   line = CreateFrame("BUTTON", framename, getglobal("GEM3UIMainMainPanelEventListMain"), "EventLineTemplate");
  end
  if i > 1 then
    line:SetPoint("TOPLEFT", getglobal("GEM3UI_lineFrame"..(i-1)), "BOTTOMLEFT", 0, 0);
--    line:SetPoint("BOTTOMRIGHT", getglobal("GEM3UI_lineFrame"..(i-1)), "BOTTOMLEFT", 0, 0);
  else
    line:SetPoint("TOPLEFT", getglobal("GEM3UIMainEventScrollList"), "TOPLEFT", 5, 0);
--    line:SetPoint("BOTTOMRIGHT", getglobal("GEM3UI_lineFrame"..(i-1)), "BOTTOMLEFT", 0, 0);
  end
  line:Hide();
  line:RegisterForClicks("LeftButtonUp", "RightButtonUp");
  line.hltex = line:GetHighlightTexture();
 end
end




function GEM3UI_fillLine(i, index)
 local id = MyEvent[index].id;
 local ev = GEM3UI_EventSource[id]
 local framename = "GEM3UI_lineFrame"..i;
 local lbl;
 local line = getglobal(framename);
 
 local stateico = getglobal(framename.."StateIconTexture");
 local subsico = getglobal(framename.."SubsIconTexture");
 local leadstateico = getglobal(framename.."LeaderStateIconTexture");
 local evtico = getglobal(framename.."EventIconTexture");
 evtico:SetTexture(GEM3UI_LocalizedStrings.EventTypes[ev.ev_type].tbin);
 local sc, ic;

 local STATE = GEM3UI_EV_STATE_NORMAL;
 local SUBS = GEM3_SUB_STATE_NONE;
 subsico:SetTexture(GEM3UI_EVLINE[SUBS].icon); 
 local alpha= nil;
 local texc = nil; 
 
 local sr = GEM3UI_EVSUBS[GEM3UI_EV_STATE_NORMAL].text_color.r;
 local sg = GEM3UI_EVSUBS[GEM3UI_EV_STATE_NORMAL].text_color.g;
 local sb = GEM3UI_EVSUBS[GEM3UI_EV_STATE_NORMAL].text_color.b;
 local sa = GEM3UI_EVSUBS[GEM3UI_EV_STATE_NORMAL].text_color.a;
 local er = GEM3UI_EVLINE[GEM3UI_EV_STATE_NORMAL].line_color.r;
 local eg = GEM3UI_EVLINE[GEM3UI_EV_STATE_NORMAL].line_color.g;
 local eb = GEM3UI_EVLINE[GEM3UI_EV_STATE_NORMAL].line_color.b;
 local ea = GEM3UI_EVLINE[GEM3UI_EV_STATE_NORMAL].line_color.a;
 
 line.ev_index = index;
 line.ignored = MyEvent[index].ignored;
 line.outdated = MyEvent[index].outdated;
 line.closed = MyEvent[index].closed;
 line.passed = MyEvent[index].passed;
 
 if GEM3UI_eventcount > GEM3UI_lines then
   line:SetWidth(GEM3UIMainEventScrollList:GetWidth());
 else
   line:SetWidth(GEM3UIMainEventScrollList:GetWidth()+17);
 end
 
 
 
 
 --- Toggle Expand button
 local expbut = getglobal(framename.."ExpandButton");
 if (not line.ignored) then -- and not GEM3UI_ShowTemplates:GetChecked()) then 
  expbut:Show();
 else
   expbut:Hide();
 end

 if not GEM3UI_ShowArchive:GetChecked() and not GEM3UI_ShowTemplates:GetChecked() then
  if line.closed then
   STATE= GEM3UI_EV_STATE_CLOSED;
  end
  if line.ignored then
   STATE= GEM3UI_EV_STATE_IGNORED;
  end
  if line.outdated then
   STATE = GEM3UI_EV_STATE_OUTDATED;
  end
  if line.passed then
   STATE = GEM3UI_EV_STATE_PASSED;
  end
  
--- Check if Event new or updated since last list viewing  
  for i, ctype in ipairs(GEM3UI_newEvents) do
   if ctype.id == ev.id then
    STATE = GEM3UI_EV_STATE_NEW;
   end
  end
  
  
  
  local rerolls =  GEM3_PLAY_GetMyRerolls(ev.channel);
  for i, player in ipairs(rerolls) do
    if GEM3_QA_Events.subscribed[ev.id] ~= nil then
     local subsinfo = GEM3_SUB_GetSubscribedInfos(ev.id, player.name);
        if subsinfo then                                                              -- Subscribed YES
            local subsdet = ev.players[player.name];                        
            if subsdet ~= nil then                                                       -- has leader seen ?
                if subsdet.current_queue >= GEM3_SUB_STATE_NOT_ACKED or subsdet.current_queue == GEM3_SUB_STATE_NONE or subsdet.current_queue ~= subsinfo.state then                        -- Yes, seen, if subscription not aked
                    --    if subsico:GetTexture() ~= GEM3UI_EVLINE[GEM3UI_EV_STATE_SUBS].icon then  -- verify if another toon has aked subs for this ev
                    subsico:SetTexture(GEM3UI_EVLINE[GEM3UI_EV_STATE_NAK].icon);             -- else set nak ico
                    SUBS = subsinfo.state
                    --end
                else
                    subsico:SetTexture(GEM3UI_EVLINE[GEM3UI_EV_STATE_SUBS].icon);
                    SUBS = subsinfo.state
                end
            else
                subsico:SetTexture(GEM3UI_EVLINE[GEM3UI_EV_STATE_NAK].icon);            -- else set nak ico
                SUBS = subsinfo.state
            end
        end
    end
  end
 end

 if STATE == GEM3UI_EV_STATE_NORMAL or STATE == GEM3UI_EV_STATE_OUTDATED or STATE == GEM3UI_EV_STATE_NEW then
  --if SUBS ~= GEM3_SUB_STATE_NONE then
   sr = GEM3UI_EVSUBS[SUBS].text_color.r;
   sg = GEM3UI_EVSUBS[SUBS].text_color.g;
   sb = GEM3UI_EVSUBS[SUBS].text_color.b;
   sa = GEM3UI_EVSUBS[SUBS].text_color.a;
 end
 
 if STATE ~= GEM3UI_EV_STATE_NORMAL and STATE ~= GEM3UI_EV_STATE_OUTDATED and STATE ~= GEM3UI_EV_STATE_NEW then
   er = GEM3UI_EVLINE[STATE].line_color.r;
   eg = GEM3UI_EVLINE[STATE].line_color.g;
   eb = GEM3UI_EVLINE[STATE].line_color.b;
   ea = GEM3UI_EVLINE[STATE].line_color.a;
   sr = er;
   sg = eg;
   sb = eb;
   sa = ea;
 end
 
 
 
----- EventState Icon  (Ignored, Closed, Outdated)
  stateico:SetTexture(GEM3UI_EVLINE[STATE].icon); 
  sc = GEM3UI_EVLINE[STATE].icon_color;
  if sc then
   stateico:SetVertexColor(sc.r,sc.g,sc.b,sc.a);
  end
  if GEM3UI_EVLINE[STATE].texc then
   local texc = GEM3UI_EVLINE[STATE].texc ;
   stateico:SetTexCoord(texc.l,texc.r,texc.t,texc.b);
  else
    stateico:SetTexCoord(0,1,0,1);
  end

--- EventSubs Icon : Subscription or not
 ic = GEM3UI_EVSUBS[SUBS].icon_color;
 if ic then 
  subsico:SetVertexColor(ic.r,ic.g,ic.b,ic.a);
 end


---- Date Place eand Subscription columns
 local lbl = getglobal(framename.."DateLabel");
 if not GEM3UI_ShowTemplates:GetChecked() then
  lbl:SetText(date(GEM3UI_DateFormatString.." "..GEM3UI_TimeFormatString,ev.ev_date+(GEM3UI.ServerTimeOffSet*60*60)));
  lbl:SetTextColor(sr,sg,sb,sa);
 else
  lbl:SetText("");
 end
 
 local lbl = getglobal(framename.."TitleLabel");
 lbl:SetText(ev.ev_place);
 lbl:SetTextColor(sr,sg,sb,sa);
 

 local lbl = getglobal(framename.."MembersLabel");
 lbl:SetText(ev.tit_count.."/"..ev.max_count.." ("..ev.sub_count..")["..MyEvent[index]["Totals"] + MyEvent[index]["NAcount"].."]");
 lbl:SetTextColor(sr,sg,sb,sa);


----- Leader Column 
 local lbl = getglobal(framename.."LeaderLabel");
 lbl:SetText(ev.leader);
 if GEM3_PLAY_IsPlayerInChannel(ev.channel, ev.leader)
 then
  leadstateico:SetTexture("interface\\buttons\\ui-checkbox-check");
   if line.closed or line.ignored or line.outdated or line.passed then 
    lbl:SetTextColor(er,eg,eb,ea);
   else
    lbl:SetTextColor(0,1,0,1);
   end
  else
  leadstateico:SetTexture("interface\\spellshadow\\spell-shadow-unacceptable");
  lbl:SetTextColor(er,eg,eb,ea);
 end
 if GEM3_IsMyReroll(ev.leader) then
  leadstateico:SetTexture("interface\\groupframe\\ui-group-leadericon");
 end
 if GEM3_EVT_AmIAssistant(ev.id) then
  leadstateico:SetTexture("interface\\groupframe\\ui-group-assistanticon");
 end

----- EventLevel Column
 local lbl = getglobal(framename.."LvlLabel");
 lbl:SetText(ev.min_lvl.."-"..ev.max_lvl);
 if UnitLevel("player") >= ev.min_lvl and UnitLevel("player") <= ev.max_lvl 
    or (line.closed or line.ignored or line.outdated or line.passed)
 then
  lbl:SetTextColor(er,eg,eb,ea);
 else
  lbl:SetTextColor(1,0,0,a);
 end

-- if no special state, use the state icon to display the icon of tagged instances
 if STATE == GEM3UI_EV_STATE_NORMAL then
   for i, tag in pairs(TaggedInstances) do
    if bit.band(ev.ev_subtype, i) ~= 0 then
     if string.find(TaggedInstances[i].icon, "lfgframe") ~= nil then
      stateico:SetTexCoord(0,0.8,0,0.72);
     else
      stateico:SetTexCoord(0,1,0,1);
     end
     stateico:SetTexture(TaggedInstances[i].icon);
    end
   end
 end


 GA_ReleaseTable(rerolls,0);
end


function GEM3UI_EventDetailOnShow()
 --mydbg("GEM3UI_EventDetailOnShow");
 GEM3UI_EventLinePopulate();
 GEM3UI_eventSubscriptionListUnban:Disable();
 local ev = GEM3UIeventDetails.evt;
 if GEM3UIeventDetails.recover == true then
  GEM3UI_eventSubscriptionListAddMember:Disable();
  GEM3UI_eventSubscriptionListInvite:Disable();
  GEMUI_EventRecover_dateLabel:SetText(date(GEM3UI_DateFormatString.." "..GEM3UI_TimeFormatString, ev.ev_date+(GEM3UI.ServerTimeOffSet*60*60)));
  GEMUI_EventRecover_ev_placeLabel:SetText(ev.ev_place);
  GEMUI_EventRecover_leaderLabel:SetText(ev.leader);
  GEMUI_EventRecover_commentLabel:SetText(ev.comment);
 end
 if ev.isTemplate ~= true then
  GEM3UI_EventLineHeaderDeadlineLabel:SetText(date(GEM3UI_DateFormatString.." "..GEM3UI_TimeFormatString, ev.deadline+(GEM3UI.ServerTimeOffSet*60*60)));
  GEM3UI_EventLineHeaderDurationLabel:SetText(date("%H:%M", ev.ev_duration));
  GEM3UI_EventLineHeaderUpdateTimeLabel:SetText(date(GEM3UI_DateFormatString.." "..GEM3UI_TimeFormatString, ev.update_time+(GEM3UI.ServerTimeOffSet*60*60)));
  GEM3UI_EventLineHeaderChannelLabel:SetText(ev.channel);
 end
 local tagnames = " <Tag: ";
 local tagcount = 0;
 for i, tag in pairs (TaggedInstances) do
  if bit.band(ev.ev_subtype, i) ~= 0 then
    tagcount = tagcount +1;
    tagname = TaggedInstances[i].name;
    if string.len (tagname) > 0 then
     if tagcount > 1 then
      tagnames = tagnames.."-"..GEM3UI_LocalizedStrings[tagname.."_Short"];
     else
      tagnames = tagnames..GEM3UI_LocalizedStrings[tagname.."_Short"];
     end
    end
  end
 end
 local tagnames = tagnames ..">"
 if tagcount == 0 then tagnames = ""; end
 GEM3UI_EventLineHeaderEventTypeLabel:SetText(GEM3UI_LocalizedStrings.EventTypes[ev.ev_type].longtext..tagnames);
 --GEM3UI_EventLineHeaderEventTypeLabel:SetText(TaggedInstances[ev.sub_type].name);
 local bans = GEM3_EVT_GetBannedPlayers(ev.id);
 if #bans > 0 and GEM3_IsMyReroll(ev.leader) then
   GEM3UI_eventSubscriptionListUnban:Enable();
 end
 GA_ReleaseTable(bans,2)
end



------ LOST EVENT RECOVERING
function GEM3UI_RecoverEventDialog(event)
 local eventfrm = getglobal("GEM3UIeventDetails");
 local parent = getglobal("GEM3UIRecoverFrame");
 if eventfrm.events == nil then
  eventfrm.events = {};
 end
 tinsert(eventfrm.events, event);
 GEM3UIeventDetails.recover = true;
 parent.timer = 0;
 parent.inc = -0.015;
 parent:SetScript("OnUpdate", GEM3UI_EventRecoverFrameOnUpdate); 
 GEM3MinimapButton:SetScript("OnUpdate", GEM3UI_RecoverMiniMapOnUpdate);
 GEM3MinimapButton:SetScript("OnClick", GEM3UI_ShowRecoverFrame);
 PlaySound("Deathbind Sound");
end


function GEM3UI_ShowRecoverFrame()
 if GEM3UIMain:IsVisible() then
  GEM3UIMain:Hide();
 end
 GEM3UIRecoverFrame:Show();
end

function GEM3UI_RecoverMiniMapOnUpdate()
   if not GEM3UIRecoverFrame:IsVisible() then
    GEM3UIRecoverFrame.timer = GEM3UIRecoverFrame.timer +    GEM3UIRecoverFrame.inc;
    if GEM3UIRecoverFrame.timer > 1.3 then
       GEM3UIRecoverFrame.inc = -0.05;
    end
    if GEM3UIRecoverFrame.timer < 0 then
       GEM3UIRecoverFrame.inc = 0.15;
    end
   end
   GEM3MinimapButtonText:SetText("");
   GEM3MinimapButtonTexture:SetTexture("interface\\gossipframe\\activequesticon");
   GEM3MinimapButton:SetAlpha(GEM3UIRecoverFrame.timer);
end


function GEM3UI_EventRecoverFrameOnShow()
 local eventfrm = getglobal("GEM3UIeventDetails");
 local parent = getglobal("GEM3UIRecoverFrame");
 
 for i, event in ipairs(eventfrm.events) do
  if eventfrm.evt == nil then
   eventfrm.evt = event;
  end
 end
 GEM3UI_RecoverFrameDrawPrevNextButton();
 GEM3UI_GetPrevNextRecoverevent();
 eventfrm:SetParent(parent);
 eventfrm:SetPoint("TOPLEFT", 20,-115);
 eventfrm:Show();
 GEM3UI_EventDetailOnShow();
end


function GEM3UI_EventRecoverFrameOnHide()
 local eventfrm = getglobal("GEM3UIeventDetails");
 local nextevent = false;
 for i, event in ipairs(eventfrm.events) do
  if event.id ~= eventfrm.evt.id then
   nextevent = event;
  end
 end
 for i, event in ipairs(eventfrm.events) do
   if event.id == eventfrm.evt.id then
    table.remove(eventfrm.events, i);
   end
 end
 if nextevent then
  eventfrm.evt = nextevent;
  this:Show();
 else
  GEM3UIRecoverFrame:SetScript("OnUpdate", nil);
  GEM3MinimapButton:SetScript("OnUpdate", nil);
  GEM3MinimapButton:SetScript("OnClick", GEM3UI_Toggle);
  GEM3MinimapButton_Update();
  eventfrm.recover = false;
  eventfrm.evt = nil;
 end
end

function GEM3UI_EventRecoverFrameOnUpdate()
   GEM3UIRecoverFrame.timer = GEM3UIRecoverFrame.timer +    GEM3UIRecoverFrame.inc;
   if GEM3UIRecoverFrame.timer > 1.3 then
      GEM3UIRecoverFrame.inc = -0.015;
   end
   if GEM3UIRecoverFrame.timer < 0 then
      GEM3UIRecoverFrame.inc = 0.05;
   end
   GEM3UIRecoverFrameWARNING2Label:SetTextColor(1,GEM3UIRecoverFrame.timer,GEM3UIRecoverFrame.timer,GEM3UIRecoverFrame.timer);   
end

function GEM3UI_RecoverCancel()
 GEM3UIRecoverFrame:Hide();
end


function GEM3UI_RecoverButtonOnClick()
 GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_EVENT_RECOVER);
end

function GEM3UI_RecoverDeleteButtonOnClick()
 GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_EVENT_RECOVER_DELETE);
end

function GEM3UI_RecoverRejectButtonOnClick()
 GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_EVENT_RECOVER_REJECT);
end

function GEM3UI_ProceedEventRecoverReject()
 GEM3_EVT_RejectLostEvent(GEM3UIeventDetails.evt)
 GEM3UIRecoverFrame:Hide();
end


function GEM3UI_ProceedEventRecover()
 GEM3_EVT_RecoverLostEvent(GEM3UIeventDetails.evt);
 GEM3UIRecoverFrame:Hide();
end


function GEM3UI_ProceedEventRecoverDelete()
 GEM3_EVT_DeleteLostEvent(GEM3UIeventDetails.evt,"Delete by leader on Event Recovery");
 GEM3UIRecoverFrame:Hide();
end

function GEM3UI_GetPrevNextRecoverevent()
 local eventfrm = getglobal("GEM3UIeventDetails");
 local nextevent = true;
 local prevevent = false;
 for i, event in ipairs(eventfrm.events) do
   if event.id ~= eventfrm.evt.id and prevevent == false and nextevent ==true then
    prevevent = event;
   end
   if event.id == eventfrm.evt.id then
    nextevent = false
   end
   if event.id ~= eventfrm.evt.id and nextevent == false then
    nextevent = event;
   end
 end
 if prevevent then 
  GEM3UIRecoverFrameprevbut:Enable();
 else
  GEM3UIRecoverFrameprevbut:Disable();
 end
 if nextevent then
  GEM3UIRecoverFramenextbut:Enable();
 else
  GEM3UIRecoverFramenextbut:Disable();
 end
 GEM3UIRecoverFrameEventConterLabel:SetText(#eventfrm.events);
 return prevevent, nextevent;
end

function GEM3UI_PrevRecoverEvent()
 --mydbg("GEM3UI_PrevRecoverEvent");
 local eventfrm = getglobal("GEM3UIeventDetails");
 local prevevent, nextevent = GEM3UI_GetPrevNextRecoverevent();
 eventfrm.evt = prevevent;
 GEM3UI_GetPrevNextRecoverevent();
 GEM3UI_EventDetailOnShow();
end

function GEM3UI_NextRecoverEvent()
 --mydbg("GEM3UI_NextRecoverEvent");
 local eventfrm = getglobal("GEM3UIeventDetails");
 local prevevent, nextevent = GEM3UI_GetPrevNextRecoverevent();
 eventfrm.evt = nextevent;
 GEM3UI_GetPrevNextRecoverevent();
 GEM3UI_EventDetailOnShow();
end

function GEM3UI_RecoverFrameDrawPrevNextButton()
local parent = getglobal("GEM3UIRecoverFramePanel1");
 local prevbut = getglobal("GEM3UIRecoverFrameprevbut");
 if prevbut == nil then
  prevbut = CreateFrame("BUTTON", "GEM3UIRecoverFrameprevbut", parent, "PrevButtonTemplate");
  prevbut:SetPoint("TOPLEFT", parent, 303, -6);
  prevbut:SetWidth(16);
  prevbut:SetHeight(16);
  prevbut:SetScript("OnClick", GEM3UI_PrevRecoverEvent);
 end
 local nextbut = getglobal("GEM3UIRecoverFramenextbut");
 if nextbut == nil then
  nextbut= CreateFrame("BUTTON", "GEM3UIRecoverFramenextbut", parent, "NextButtonTemplate");
  nextbut:SetPoint("TOPLEFT", parent, 510, -6);
  nextbut:SetWidth(16);
  nextbut:SetHeight(16);
  nextbut:SetText(">");
  nextbut:SetScript("OnClick", GEM3UI_NextRecoverEvent);
 end
end


---- GROUPING FUNCTION
---- GROUPING FUNCTION

function GEM3UI_InviteProcess(event, data)
 if event == GroupAnalyse.EVENT_MEMBER_JOINED 
  or event == GroupAnalyse.EVENT_MEMBER_LEFT then
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", nil);
 end
 if GEM3UI_GroupingForEvent == nil then return; end
 local ev = GEM3_QA_Events.events[GEM3UI_GroupingForEvent];
 local groupcomplet = false;
--- MEMBER JOINED
 if event == GroupAnalyse.EVENT_MEMBER_JOINED then
  if UnitName("player") == data then return; end
  if ev.tit_count > 5 and GetNumRaidMembers() == 0 then
    ConvertToRaid();
  end
  local InviteMessage = string.format("GEM3: "..GEM3UI_LocalizedStrings["_WelcomeToEvent"], ev.ev_place);
  SendChatMessage(InviteMessage, "WHISPER", nil, data);
  groupcomplet = GEM3UI_EventIsGroupFull(ev);
--- MEMBER LEFT 
 elseif event == GroupAnalyse.EVENT_MEMBER_LEFT then
   local InviteMessage = string.format("GEM3: "..GEM3UI_LocalizedStrings["_YouWereGrouped"], ev.ev_place);
   SendChatMessage(InviteMessage, "WHISPER", nil, data);
--- GROUPMODE CHANGED 
 elseif event == GroupAnalyse.EVENT_GROUP_MODE_CHANGED then
  --  IF GROUP DISBANDED STOP GROUPING
  if data == GroupAnalyse.MODE_NONE or data == GroupAnalyse.MODE_SOLO then
   GEM3UI_GroupingForEvent = nil;
   GEM3UI_eventSubscriptionListInvite:SetText(GEM3UI_LocalizedStrings["_InviteAll"]);
  end
 end
 if groupcomplet and GEM3UI_GroupingForEvent then
   GEM3UI_EventInviteOnClick();
 end
end


function GEM3UI_EventIsGroupFull(ev)
  local groupcomplet  = true;
  for i,pl in pairs(ev.players) do
     if not (UnitInParty(pl.name) or UnitInRaid(pl.name)) then
       groupcomplet  = false;
     end
  end
  
  if not groupcomplet then 
   local grpcount = GetNumRaidMembers()
   if grpcount == 0 then 
    grpcount = GetNumPartyMembers();
   end
   if grpcount >= ev.max_count then
    groupcomplet = true;
   end
  end
  return groupcomplet;
end

function GEM3UI_EventInviteOnClick()
  
   
  if GEM3UI_GroupingForEvent ~= nil then
   GEM3UI_GroupingForEvent = nil;
   GEM3UI_eventSubscriptionListInvite:SetText(GEM3UI_LocalizedStrings["_InviteAll"]);
   GEM3UI_eventSubscriptionListInvite:SetScript("OnUpdate", nil);
   ChatFrame_RemoveMessageEventFilter("CHAT_MSG_WHISPER_INFORM", GEM3UI_InviteChatFilter);
   ChatFrame_RemoveMessageEventFilter("CHAT_MSG_SYSTEM", GEM3UI_InviteChatFilter);
   ERR_ALREADY_IN_GROUP_S = GEM3UI_OLD.ERR_ALREADY_IN_GROUP_S;
   ERR_DECLINE_GROUP_S = GEM3UI_OLD.ERR_DECLINE_GROUP_S;
  else
   local event = GEM3UIeventDetails.evt;
   GEM3UI_GroupingForEvent = event.id;
   GEM3UI_eventSubscriptionListInvite:SetText(GEM3UI_LocalizedStrings["_StopInvite"]);
   GEM3UI_eventSubscriptionListInvite.invTime = time();
   GEM3UI_eventSubscriptionListInvite:SetScript("OnUpdate", GEM3UIEventInviteOnUpdate);
   ChatFrame_AddMessageEventFilter("CHAT_MSG_WHISPER_INFORM", GEM3UI_InviteChatFilter);
   ChatFrame_AddMessageEventFilter("CHAT_MSG_SYSTEM", GEM3UI_InviteChatFilter);
   GEM3UI_OLD.ERR_ALREADY_IN_GROUP_S = ERR_ALREADY_IN_GROUP_S ;
   GEM3UI_OLD.ERR_DECLINE_GROUP_S  = ERR_DECLINE_GROUP_S ;
   ERR_ALREADY_IN_GROUP_S = "GEM3 ALREADY IN GROUP:%s";
   ERR_DECLINE_GROUP_S = "GEM3 GROUP DECLINE:%s";
   GEM3UI_EventInviteLoop(true);
  end
end

function GEM3UIEventInviteOnUpdate()
  if GEM3UI_GroupingForEvent ~= nil then
   if GEM3UI_eventSubscriptionListInvite.invTime < time() - GEM3UI.InvitePeriod then
    GEM3UI_EventInviteLoop();
   end
  else
   GEM3UI_eventSubscriptionListInvite:SetScript("OnEvent", nil);
  end
end

function GEM3UI_InviteChatFilter(msg)
  if string.find(msg, "GEM3: ") then
    return true
  end
  
  if string.find(msg, string.sub(ERR_ALREADY_IN_GROUP_S, 1, string.len(ERR_ALREADY_IN_GROUP_S)-2)) then
    local player = string.sub(msg, string.len(ERR_ALREADY_IN_GROUP_S)-1)
    local InviteMessage = string.format("GEM3: "..GEM3UI_LocalizedStrings["alreadygrouped"]);
    SendChatMessage(InviteMessage, "WHISPER", nil, player);
    return true
  end
  
  if string.find(msg, string.sub(ERR_DECLINE_GROUP_S, 1, string.len(ERR_DECLINE_GROUP_S)-2)) then
    local player = string.sub(msg, string.len(ERR_DECLINE_GROUP_S)-1)
    local InviteMessage = string.format("GEM3: "..GEM3UI_LocalizedStrings["youareinagemparty"]);
    SendChatMessage(InviteMessage, "WHISPER", nil, player);
    return true
  end
  
end

function GEM3UI_EventInviteLoop(firstrun)
  local invited = 0;
  local grpcount = GetNumRaidMembers()
  if grpcount > 0 then invited = -100; end
  local event = GEM3_QA_Events.events[GEM3UI_GroupingForEvent];
   for i,player in pairs(event.players) do
    local pl = GEM3_PLAY_GetPlayerInfos(player.name);
    local connected = false;
    if pl == nil then 
     connected = true;
    else
     if UnitInParty(pl.name) or UnitInRaid(pl.name) then
      connected = false;
     else
      connected = pl.connected
     end
    end
    if ( connected and invited < 5 and player.name ~= UnitName("player") and player.current_queue == GEM3_SUB_STATE_TITULAR) then
       invited = invited + 1;
       local InviteMessage = string.format("GEM3: "..GEM3UI_LocalizedStrings["_PartRequestForEvent"], UnitName("Player"), event.ev_place);
       SendChatMessage(InviteMessage, "WHISPER", nil, player.name);
       InviteUnit(player.name);
    end
  end
  GEM3UI_eventSubscriptionListInvite.invTime = time();
end


---- Unbann DD
function GEM3UI_FillDropDownBanned()
 local evt = GEM3UIeventDetails.evt;
 GEM3UI_DropDowninit(GEM3UI_LocalizedStrings["_Unban"]);
 local bans = GEM3_EVT_GetBannedPlayers(evt.id);
 for i, pl_name in ipairs(bans) do
  GEM3UI_DDAddLine(evt.id, pl_name.name, pl_name.name, true, false, GEM3UI_PlayerUnbanFromEvent);
 end
 GA_ReleaseTable(bans,2)
 GEM3UI_DDshow();
end

function GEM3UI_PlayerUnbanFromEvent(ev_id,player)
 GEM3_EVT_UnBanFromEvent(ev_id,player);
 local bans = GEM3_EVT_GetBannedPlayers(ev_id);
 if #bans > 0 then 
  GEM3UI_eventSubscriptionListUnban:Enable();
 else
  GEM3UI_eventSubscriptionListUnban:Disable();
 end
 GA_ReleaseTable(bans,2)
end