﻿--[[
 Guild Event Manager GUI
 -------------------------------------
  Code: Movix - Conseil des Ombres - EU
  DEBUGGING
]]

function mydbg(msg)
 if GEM3UIDBG == true then
    DEFAULT_CHAT_FRAME:AddMessage(msg, 0.9, 0.8, 0.10);
 end
end

--/script GEM3_PrintTable(GEM3UI_DEBUGDATA)
function GEM3UI_SetFilterLevel(id, value)
 GEM3UIDebug.debug_flags= GEM3UI_GetDebugLevelAfterDD(GEM3UIDebug, id);
 GEM3UI_DisplayDebug();
end


function GEM3UI_SetFullFilterLevel(id, value)
 if bit.band(GEM3UIDebug.debug_flags, id) == id then
  GEM3UIDebug.debug_flags= 0;
  GEM3UIDebug.UIFILTER = false;
 else
  GEM3UIDebug.debug_flags= GEM3_DEBUG_ALL_MASK;
  GEM3UIDebug.UIFILTER = true;
 end
 GEM3UI_DisplayDebug();
end


function GEM3UI_DEBUGPAGENAV(nav)
 local totpage=math.floor(GEM3UI_DEBUGTOTALSHOWNMSG/GEM3UI_DEBUGLINESPERPAGE)+1;
 if     nav == -2 then
  GEM3UI_DebugNav_actPage  = 1;
 elseif nav == -1 and GEM3UI_DebugNav_actPage  > 1 then
  GEM3UI_DebugNav_actPage  = GEM3UI_DebugNav_actPage  -1;
 elseif nav ==  1 and GEM3UI_DebugNav_actPage  < totpage then
  GEM3UI_DebugNav_actPage  = GEM3UI_DebugNav_actPage  + 1;
 elseif nav ==  2 then
  GEM3UI_DebugNav_actPage  = totpage;
 end
 GEM3UI_DisplayDebug();
end



function GEM3UI_DisplayDebug(msg,debug_type)
 if GEM3UI_DebugNav_actPage == nil then GEM3UI_DebugNav_actPage = 1; end
 local totpage=math.floor(GEM3UI_DEBUGTOTALSHOWNMSG/GEM3UI_DEBUGLINESPERPAGE)+1;
 if msg ~= nil then
  
   local col = GEM3_DBG_ColorCodes[debug_type];
   local r, g, b = unpack(col);
   hcol = string.format("\n|cff%02x%02x%02x", r*255,g*255,b*255);
   if debug_type == nil or debug_type == 0 then
    GEM3UI_DEBUGTOTALSHOWNMSG = GEM3UI_DEBUGTOTALSHOWNMSG + 1;
    if GEM3UI_DebugNav_actPage == totpage then
     GEM3UIDBGSCRLEDTEdit:SetText(GEM3UIDBGSCRLEDTEdit:GetText()..hcol..msg);
    end
   else
    if string.len(GEM3UIDBGSEARCHSTRING:GetText()) > 0 then
     if string.find(msg, GEM3UIDBGSEARCHSTRING:GetText()) then
      if GEM3UI_IsDebugLevelEnabled(GEM3UIDebug,debug_type) then
       GEM3UI_DEBUGTOTALSHOWNMSG = GEM3UI_DEBUGTOTALSHOWNMSG + 1;
       if GEM3UI_DebugNav_actPage == totpage then
        GEM3UIDBGSCRLEDTEdit:SetText(GEM3UIDBGSCRLEDTEdit:GetText()..hcol..msg);
       end
      end
     end
    else
     if GEM3UI_IsDebugLevelEnabled(GEM3UIDebug,debug_type) then
       GEM3UI_DEBUGTOTALSHOWNMSG = GEM3UI_DEBUGTOTALSHOWNMSG + 1;
       if GEM3UI_DebugNav_actPage == totpage then
        GEM3UIDBGSCRLEDTEdit:SetText(GEM3UIDBGSCRLEDTEdit:GetText()..hcol..msg);
       end
     end
    end
   end
 else
  GEM3UIDBGSCRLEDTEdit:SetText("");
  GEM3UI_DEBUGTOTALSHOWNMSG = 0 ;
  local n = 0;
  if string.len(GEM3UIDBGSEARCHSTRING:GetText()) > 0 then
   for i, dbg in ipairs(GEM3UI_DEBUGDATA) do
     local col = GEM3_DBG_ColorCodes[dbg.dbgtype];
     local r, g, b = unpack(col);
     hcol = string.format("\n|cff%02x%02x%02x", r*255,g*255,b*255);
     if string.find(dbg.dbgmsg, GEM3UIDBGSEARCHSTRING:GetText()) then
      local showit = GEM3UI_IsDebugLevelEnabled(GEM3UIDebug,dbg.dbgtype);
      if dbg.dbgtype == 0 then showit = true; end
      if showit then
       GEM3UI_DEBUGTOTALSHOWNMSG = GEM3UI_DEBUGTOTALSHOWNMSG + 1;
       n = n + 1;
       if math.floor(n/GEM3UI_DEBUGLINESPERPAGE)+1 == GEM3UI_DebugNav_actPage  then
        GEM3UIDBGSCRLEDTEdit:SetText(GEM3UIDBGSCRLEDTEdit:GetText()..hcol..dbg.dbgmsg);
       end
      end
     end
    end
  else
   for i, dbg in ipairs(GEM3UI_DEBUGDATA) do
     local showit = GEM3UI_IsDebugLevelEnabled(GEM3UIDebug,dbg.dbgtype);
     local col = GEM3_DBG_ColorCodes[dbg.dbgtype];
     local r, g, b = unpack(col);
     hcol = string.format("\n|cff%02x%02x%02x", r*255,g*255,b*255);
     if dbg.dbgtype == 0 then showit = true; end
     if showit then 
      GEM3UI_DEBUGTOTALSHOWNMSG = GEM3UI_DEBUGTOTALSHOWNMSG + 1;
      n = n + 1;
      if math.floor(n/GEM3UI_DEBUGLINESPERPAGE)+1 == GEM3UI_DebugNav_actPage  then
       GEM3UIDBGSCRLEDTEdit:SetText(GEM3UIDBGSCRLEDTEdit:GetText()..hcol..dbg.dbgmsg);
      end
     end
   end
  end
 end
 local totpage=math.floor(GEM3UI_DEBUGTOTALSHOWNMSG/GEM3UI_DEBUGLINESPERPAGE)+1;
 GEM3UIDEBUGMSGCNTLabel:SetText(string.format("DbgMsgCnt: %d (%d) - Page %d/%d",GEM3UI_DEBUGTOTALSHOWNMSG ,#GEM3UI_DEBUGDATA,GEM3UI_DebugNav_actPage ,totpage));
end


function GEM3UI_SetDebugMode(wipedata)
 local mode = 0;
 if GEM3UI_GeneraloptionsTabDebug:GetChecked() then mode = 1; end
 GEM3_DBG_SetDebugMode(mode);
 GEM3UI_BuildToolBar();
 --GEM3UI_-RefreshAll(GEM3UI_REFRESH_CLOSE_OPEN_EVENTLINE);
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
 GA_WipeTable(GEM3UI_DEBUGDATA, 10);
 GEM3UI_DEBUGPAGENAV(-2);
end

function GEM3UI_SetDebugLevel(id, value)
 GEM3_QA_Config.debug_flags = GEM3UI_GetDebugLevelAfterDD(GEM3_QA_Config , id);
 GEM3UI_SetDebugStatus(string.format("DEBUGMODE SET TO: %s", GEM3_QA_Config.debug_flags ),10);
end

function GEM3UI_SetFullDebugLevel(id, value)
 if bit.band(GEM3_QA_Config.debug_flags, id) == id then
 GEM3_QA_Config.debug_flags = 0;
 else
  GEM3_QA_Config.debug_flags = GEM3_DEBUG_ALL_MASK;
 end
 GEM3UI_SetDebugStatus(string.format("DEBUGMODE SET TO: %s", GEM3_QA_Config.debug_flags ),5);
end

function GEM3UI_IsDebugLevelEnabled(src, dbglvl)
 if dbglvl == 0 then
  if src.debug_flags == dbglvl then
   return true;
  else
   return false;
  end
 else
  if bit.band(src.debug_flags, dbglvl) == dbglvl then
   return true;
  else
   return false;
  end
 end
end

function GEM3UI_GetDebugLevelAfterDD(src, val)
 local ret;
 if bit.band(src.debug_flags, val) == val then
  ret = src.debug_flags - val;
 else
  ret = src.debug_flags + val;
 end
 return ret;
end

function GEM3UI_SetDebugLevelDD()
local s = GEM3UI_LocalizedStrings;
local src = GEM3_QA_Config;
   GEM3UI_DDAddLine(0, 0, s["GEM3_DEBUG_NONE"], true, GEM3UI_IsDebugLevelEnabled(src, 0), GEM3UI_SetFullDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_GLOBAL, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_GLOBAL), s["GEM3_DEBUG_GLOBAL"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_GLOBAL), GEM3UI_SetDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_PROTOCOL, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_PROTOCOL), s["GEM3_DEBUG_PROTOCOL"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_PROTOCOL), GEM3UI_SetDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_CHANNEL, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_CHANNEL), s["GEM3_DEBUG_CHANNEL"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_CHANNEL), GEM3UI_SetDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_EVENTS, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_EVENTS), s["GEM3_DEBUG_EVENTS"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_EVENTS), GEM3UI_SetDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_COMMANDS, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_COMMANDS), s["GEM3_DEBUG_COMMANDS"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_COMMANDS), GEM3UI_SetDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_SUBSCRIBERS, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_SUBSCRIBERS), s["GEM3_DEBUG_SUBSCRIBERS"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_SUBSCRIBERS), GEM3UI_SetDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_SORT, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_SORT), s["GEM3_DEBUG_SORT"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_SORT), GEM3UI_SetDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_QUEUES, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_QUEUES), s["GEM3_DEBUG_QUEUES"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_QUEUES), GEM3UI_SetDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_WARNING, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_WARNING), s["GEM3_DEBUG_WARNING"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_WARNING), GEM3UI_SetDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_TIMESTAMP, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_TIMESTAMP), s["GEM3_DEBUG_TIMESTAMP"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_TIMESTAMP), GEM3UI_SetDebugLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_ALL_MASK, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_ALL_MASK), s["GEM3_DEBUG_ALL_MASK"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_ALL_MASK), GEM3UI_SetFullDebugLevel);
end

function GEM3UI_SetDebugFilterDD ()
local s = GEM3UI_LocalizedStrings;
local src = GEM3UIDebug;
   GEM3UI_DDAddLine(0, 0, s["GEM3_DEBUG_NONE"], true, GEM3UI_IsDebugLevelEnabled(src, 0), GEM3UI_SetFullFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_GLOBAL, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_GLOBAL), s["GEM3_DEBUG_GLOBAL"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_GLOBAL), GEM3UI_SetFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_PROTOCOL, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_PROTOCOL), s["GEM3_DEBUG_PROTOCOL"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_PROTOCOL), GEM3UI_SetFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_CHANNEL, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_CHANNEL), s["GEM3_DEBUG_CHANNEL"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_CHANNEL), GEM3UI_SetFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_EVENTS, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_EVENTS), s["GEM3_DEBUG_EVENTS"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_EVENTS), GEM3UI_SetFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_COMMANDS, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_COMMANDS), s["GEM3_DEBUG_COMMANDS"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_COMMANDS), GEM3UI_SetFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_SUBSCRIBERS, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_SUBSCRIBERS), s["GEM3_DEBUG_SUBSCRIBERS"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_SUBSCRIBERS), GEM3UI_SetFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_SORT, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_SORT), s["GEM3_DEBUG_SORT"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_SORT), GEM3UI_SetFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_QUEUES, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_QUEUES), s["GEM3_DEBUG_QUEUES"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_QUEUES), GEM3UI_SetFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_WARNING, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_WARNING), s["GEM3_DEBUG_WARNING"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_WARNING), GEM3UI_SetFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_TIMESTAMP, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_TIMESTAMP), s["GEM3_DEBUG_TIMESTAMP"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_TIMESTAMP), GEM3UI_SetFilterLevel);
   GEM3UI_DDAddLine(GEM3_DEBUG_ALL_MASK, GEM3UI_GetDebugLevelAfterDD(src, GEM3_DEBUG_ALL_MASK), s["GEM3_DEBUG_ALL_MASK"], true, GEM3UI_IsDebugLevelEnabled(src, GEM3_DEBUG_ALL_MASK), GEM3UI_SetFullFilterLevel);
end






function GEM3UI_DebugOnShow()
 GEM3UIDBGSCRLEDTEdit:SetFont("Fonts\\ARIALN.TTF", 10);
 GEM3UIDEBUGLINESPERPAGEEDIT:SetText(GEM3UI_DEBUGLINESPERPAGE); 
 --GEM3UIDBGSCRLEDT:SetScript("OnVerticalScroll", GEM3UI_DBGSCRLEDTOnVerticalScroll);
 --GEM3UIDBGSCRLEDTEdit:SetScript("OnEscapePressed", GEM3UI_ESCpressed);
end

function GEM3UI_DBGSCRLEDTEditOnUpdate()
 ScrollingEdit_OnUpdate(null);
end

function GEM3UI_DBGSCRLEDTOnVerticalScroll()
    local scrollbar = getglobal(this:GetName().."ScrollBar");
    scrollbar:SetValue(arg1);
    local min;
    local max;
    min, max = scrollbar:GetMinMaxValues();
    if ( arg1 == 0 ) then
        getglobal(scrollbar:GetName().."ScrollUpButton"):Disable();
    else
        getglobal(scrollbar:GetName().."ScrollUpButton"):Enable();
    end
	if ((scrollbar:GetValue() - max) == 0) then
	    getglobal(scrollbar:GetName().."ScrollDownButton"):Disable();
		--GEM3UIDBGSCRLEDTEdit:SetScript("OnUpdate", GEM3UI_DBGSCRLEDTEditOnUpdate)
	else
	    getglobal(scrollbar:GetName().."ScrollDownButton"):Enable();
        --GEM3UIDBGSCRLEDTEdit:SetScript("OnUpdate", nil)
	end
end

function GEM3UI_SaveDebugLog()
    GEM3_DebugLog = {};
    for i, dbg in ipairs(GEM3UI_DEBUGDATA) do
        table.insert(GEM3_DebugLog, dbg.dbgmsg);
    end
end