﻿--[[
 Guild Event Manager GUI
 -------------------------------------
  Code: Movix - Conseil des Ombres - EU
  Event Create and Edit
]]


function GEM3UI_CreateFormOnLoad()
  GEM3UICreate.init=false;
  GEM3UICreate.ev_id = nil;
 if GEM3UI.DateFormat == false then
  GEM3EDITBOX5:SetPoint("TOPLEFT", 88, -6);
  GEM3EDITBOX6:SetPoint("TOPLEFT", 56, -6);
  GEM3EDITBOX7:SetPoint("TOPLEFT", 11, -6);
  GEM3EDITBOX4.tabid=6;
  GEM3EDITBOX7.tabid=5;
  GEM3EDITBOX6.tabid=4;
  GEM3EDITBOX5.tabid=7;
  Datesep1:SetPoint("TOPLEFT", 45, -6);
  Datesep2:SetPoint("TOPLEFT", 77, -6);
  
  GEM3EDITBOX10:SetPoint("TOPLEFT", 88, -6);
  GEM3EDITBOX11:SetPoint("TOPLEFT", 56, -6);
  GEM3EDITBOX12:SetPoint("TOPLEFT", 11, -6);
  GEM3EDITBOX9.tabid=11;
  GEM3EDITBOX12.tabid=10;
  GEM3EDITBOX11.tabid=9;
  GEM3EDITBOX10.tabid=12;
  Datesep3:SetPoint("TOPLEFT", 45, -6);
  Datesep4:SetPoint("TOPLEFT", 77, -6);
 
  GEM3EDITBOX15:SetPoint("TOPLEFT", 88, -6);
  GEM3EDITBOX16:SetPoint("TOPLEFT", 56, -6);
  GEM3EDITBOX17:SetPoint("TOPLEFT", 11, -6);
  GEM3EDITBOX14.tabid=16;
  GEM3EDITBOX17.tabid=15;
  GEM3EDITBOX16.tabid=14;
  GEM3EDITBOX15.tabid=17;
  Datesep5:SetPoint("TOPLEFT", 45, -6);
  Datesep6:SetPoint("TOPLEFT", 77, -6);
 
 end
 Datesep1Label:SetText(GEM3UI.DateSeparator);
 Datesep2Label:SetText(GEM3UI.DateSeparator);
 Datesep3Label:SetText(GEM3UI.DateSeparator);
 Datesep4Label:SetText(GEM3UI.DateSeparator);
 Datesep5Label:SetText(GEM3UI.DateSeparator);
 Datesep6Label:SetText(GEM3UI.DateSeparator);
 GEM3UICreate.init=true;
end


function GEM3UI_EventEdit(id)
 GEM3UICreate.ev_id = id;
 GEM3UI_MainTabClick(2);
end

function GEM3UI_CopyDateToDeadline()
  GEM3EDITBOX10:SetText(GEM3EDITBOX5:GetText());
  GEM3EDITBOX11:SetText(GEM3EDITBOX6:GetText());
  GEM3EDITBOX12:SetText(GEM3EDITBOX7:GetText());
  GEM3EDITBOX13:SetText(GEM3EDITBOX8:GetText());
  GEM3EDITBOX14:SetText(GEM3EDITBOX9:GetText());
end


function GEM3UI_SetEndDate()
  GEM3EDITBOX10:SetText(GEM3EDITBOX5:GetText());
  GEM3EDITBOX11:SetText(GEM3EDITBOX6:GetText());
  GEM3EDITBOX12:SetText(GEM3EDITBOX7:GetText());
  GEM3EDITBOX13:SetText(GEM3EDITBOX8:GetText());
  GEM3EDITBOX14:SetText(GEM3EDITBOX9:GetText());
end




function GEM3UI_CreateModifyEvent(asTemplate, ev)
 --GEM3UI_EditCreateValidateForm();
 if GEM3UICreate.event == nil then GEM3UICreate.event = {}; end
 if ev == nil then
  ev = GEM3UICreate.event;
  ev.ev_date = time({day=GEM3EDITBOX5:GetText(), month=GEM3EDITBOX6:GetText(), year=GEM3EDITBOX7:GetText(), hour=GEM3EDITBOX8:GetText(), min=GEM3EDITBOX9:GetText(), sec=0 });
  ev.deadline = time({day=GEM3EDITBOX10:GetText(), month=GEM3EDITBOX11:GetText(), year=GEM3EDITBOX12:GetText(), hour=GEM3EDITBOX13:GetText(), min=GEM3EDITBOX14:GetText(), sec=0 });
  ev.ev_duration = time({day=GEM3EDITBOX15:GetText(), month=GEM3EDITBOX16:GetText(), year=GEM3EDITBOX17:GetText(), hour=GEM3EDITBOX18:GetText(), min=GEM3EDITBOX19:GetText(), sec=0 }) - ev.ev_date;
  ev.channel = GEM3UI_CreateChannelNameTextLabel:GetText();
  ev.leader= UnitName("player");
  ev.ev_place = GEM3EDITBOX1:GetText();
  ev.ev_comment = GEM3EDITBOX20:GetText();
  ev.max_count = tonumber(GEM3EDITBOX2:GetText());
  ev.min_lvl = tonumber(GEM3EDITBOX3:GetText());
  ev.max_lvl = tonumber(GEM3EDITBOX4:GetText());
  ev.ev_type = GEM3UI_CreateTypeTextLabel.id;
  ev.ev_subtype = GEM3UI_CreateTagTypeTextLabel.id;
  ev.sorttype = GEM3_SORT_GetSortType(GEM3UI_CreatePriorityTextLabel:GetText());
  ev.sortstring = GEM3UI_CreatePriorityTextLabel:GetText();
  ev.classes = {
   ["DRUID"]   = {min=tonumber(GEM3EDITBOX21:GetText()) , max=tonumber(GEM3EDITBOX22:GetText())},
   ["HUNTER"]  = {min=tonumber(GEM3EDITBOX25:GetText()) , max=tonumber(GEM3EDITBOX26:GetText())},
   ["MAGE"]    = {min=tonumber(GEM3EDITBOX29:GetText()) , max=tonumber(GEM3EDITBOX30:GetText())},
   ["PALADIN"] = {min=tonumber(GEM3EDITBOX33:GetText()) , max=tonumber(GEM3EDITBOX34:GetText())},
   ["PRIEST"]  = {min=tonumber(GEM3EDITBOX37:GetText()) , max=tonumber(GEM3EDITBOX38:GetText())},
  
   ["ROGUE"]   = {min=tonumber(GEM3EDITBOX23:GetText()) , max=tonumber(GEM3EDITBOX24:GetText())},
   ["SHAMAN"]  = {min=tonumber(GEM3EDITBOX27:GetText()) , max=tonumber(GEM3EDITBOX28:GetText())},
   ["WARLOCK"] = {min=tonumber(GEM3EDITBOX31:GetText()) , max=tonumber(GEM3EDITBOX32:GetText())},
   ["WARRIOR"] = {min=tonumber(GEM3EDITBOX35:GetText()) , max=tonumber(GEM3EDITBOX36:GetText())},
 --  ["HERO"]    = {min=tonumber(GEM3EDITBOX39:GetText()) , max=tonumber(GEM3EDITBOX40:GetText())},
  };
  ev.roles = {
   [GEM3_ROLE_TANK] = {min=tonumber(GEM3EDITBOX41:GetText()), max=tonumber(GEM3EDITBOX42:GetText())},
   [GEM3_ROLE_HEAL] = {min=tonumber(GEM3EDITBOX43:GetText()), max=tonumber(GEM3EDITBOX44:GetText())},
   [GEM3_ROLE_RDPS] = {min=tonumber(GEM3EDITBOX45:GetText()), max=tonumber(GEM3EDITBOX46:GetText())},
   [GEM3_ROLE_CDPS] = {min=tonumber(GEM3EDITBOX47:GetText()), max=tonumber(GEM3EDITBOX48:GetText())},
  };
 end
 local result = "";
 if asTemplate then
   if GEM3UI.Templates == nil then GEM3UI.Templates = {}; end
   evt = GEM3UI_TblCpy(ev)
   evt.id = ev.leader..math.fmod(time(),1000);
   evt.isTemplate=true;
   evt.ev_date = 0;
   evt.deadline = 0;
  for i, p in pairs(evt.players) do
   p.source = GEM3_SUB_SOURCE_TEMPLATE;
   p.comment = "";
  end
  table.insert(GEM3UI.Templates, evt);
  GEM3UI_ShowTemplates:SetChecked(true);
 else
  if GEM3UICreateCreate:GetText() == GEM3UI_LocalizedStrings["_Create"]  then
   
 --- check for multiple creation
   local repeattable = GA_GetTable();
   local multiplier = (tonumber(GEM3UI_CreateMultipleForTheN:GetText()) or 0);
   local oneweek = 60*60*24*7;
   local evdatedind =  (date("*t", ev.ev_date).wday)-1;
   if evdatedind == 0 then evdatedind = 7; end
   local deadlineoffset = ev.ev_date - ev.deadline;
   for dindex = 1, 7 do
    local repeatday = getglobal("GEM3UI_CreateMultiple"..dindex);
    if evdatedind <= dindex then
     dbase = ev.ev_date + ( (dindex-evdatedind) * 60*60*24);
    else
     dbase = ev.ev_date + ( (7-(evdatedind-dindex)) * 60*60*24);
    end
    if repeatday:GetChecked() then 
     for rpt=0, multiplier-1 do
      table.insert(repeattable, dbase + (rpt*oneweek));
     end
    end
   end
   
   if #repeattable > 0 then
    for tind, ev_date in pairs(repeattable) do
     ev_id, result = GEM3UI_EventCreator(ev,ev_date, ev_date-deadlineoffset);
     GEM3UI_SetStatusMessage(result);
    end
   else
    ev_id, result = GEM3UI_EventCreator(ev,ev.ev_date, ev.deadline)
   end
  else
   ev_id, result = GEM3_EVT_ModifyEvent(GEM3UICreate.ev_id, ev.ev_date-(GEM3UI.ServerTimeOffSet*60*60), ev.deadline-(GEM3UI.ServerTimeOffSet*60*60), ev.ev_place, ev.ev_comment, ev.max_count, ev.min_lvl, ev.max_lvl, ev.classes, ev.roles, ev.sortstring, ev.ev_type , ev.ev_subtype, ev.ev_duration);
   if GEM3UICreate.FilterName then GEM3UI_EventNameFilters[GEM3UICreate.FilterName] = nil; end
   GEM3UI_EventNameFilters[ev.ev_place] = true;
  end
  GEM3UI_SetStatusMessage(result);
  GEM3UI_ShowTemplates:SetChecked(false);
  GEM3UI_ShowArchive:SetChecked(false);
  --GEM3UI_CreateFormOnLoad();
 end
  --GEM3UI_-RefreshAll(GEM3UI_REFRESHCLOSEOPENEVENTLINE);
  GEM3UI_MainTabClick(1);
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE");
  GEM3UI_BuildToolBar();
end

function GEM3UI_EventCreator(ev,ev_date, deadline)
  ev_id, result = GEM3_EVT_CreateNewEvent(ev.channel, ev.leader, ev_date-(GEM3UI.ServerTimeOffSet*60*60), deadline-(GEM3UI.ServerTimeOffSet*60*60), ev.ev_place, ev.ev_comment, ev.max_count, ev.min_lvl, ev.max_lvl, ev.classes, ev.roles, ev.sortstring, ev.ev_type, ev.ev_subtype, ev.ev_duration );
  if ev_id then
   for i, p in pairs(ev.players) do
     local subs, reason  = GEM3_SUB_SubscribeExternal(ev_id,p.name,p.guild,p.level,p.class,p.role,p.comment,p.force_queue,p.alt_role or GEM3_ROLE_UNKNOWN);
   end
  end
  return ev_id, result;
end




function GEM3UI_CancelCreate()
 GEM3UICreate.ev_id=nil;
 GEM3UI_InitCreateForm();
 GEM3UI_SetDebugStatus("EDIT/CREATE Canceled:",0)
 GEM3UICreate.edited=false;
end





function GEM3UI_InitCreateForm()
--GEM3UI_CreateFormOnLoad();
 GEM3UICreate.tags = 0;
 if GEM3UICreate.tags == 0 then 
  GEM3UI_CreateTagTypeTextLabel:SetText(GEM3UI_LocalizedStrings["_NoTagDefined"]);
 else
  GEM3UI_CreateTagTypeTextLabel:SetText(GEM3UI_LocalizedStrings["_TagDefined"])
 end
 GEM3UICreate.init=false;
 --- Show or hide Templates Dropdown
 if #GEM3UI.Templates > 0 then
   GEM3EDITBOX1Button:Show();
 else
   GEM3EDITBOX1Button:Hide();
 end

 for i=1, 7 do
  getglobal("GEM3UI_CreateMultiple"..i):SetChecked(false);
 end
 GEM3UI_CreateMultipleForTheN:SetText(""); 
  
  
  
 GEM3UI_Create_GetNewEvent(GEM3UI_EventSource[GEM3UICreate.ev_id]); --- initialize wether with empty event or with event to edit / template
 
 local ev = GEM3UICreate.event;


 if GEM3UICreate.ev_id ~= nil then
   GEM3UI_SetDebugStatus("EDIT-INIT:"..GEM3UICreate.ev_id,0);
 else
  GEM3UI_SetDebugStatus("CREATE NEW-INIT",0);
 end
  
 local cal = getglobal("GEM3UICalendar");
 local h=GEM3UI.DefaultHour;
 local m=GEM3UI.DefaultMinute;
 

--- delete all editbox contents
  local id = 1;
  local edtbx = getglobal("GEM3EDITBOX"..id);
  while (edtbx ~= nil) do
   edtbx:SetText("");
   id = id +1;
   edtbx = getglobal("GEM3EDITBOX"..id);
  end

 --- set Sortstring
 if ev.sorttype == nil then 
  for name in pairs(GEM3_SORT_Plugins) do
    GEM3UI_CreatePriorityTextLabel:SetText(name); 
    ev.sorttype = GEM3_SORT_GetSortType(GEM3UI_CreatePriorityTextLabel:GetText());
  end
 else
  GEM3UI_CreatePriorityTextLabel:SetText(GEM3_SORT_GetPlugin(ev.sorttype).Name); 
 end
 
 --- set Eventtype
  if ev.ev_type == nil then ev.ev_type = GEM3_EVT_TYPE_NONE; end
   for i, ev_type in pairs(GEM3UI_LocalizedStrings.EventTypes) do
     if ev.ev_type == i then
      GEM3UI_CreateTypeTextLabel.id = i;
      GEM3UI_CreateTypeTextLabel.value = ev_type.longtext;
      GEM3UI_CreateTypeTextLabel:SetText(ev_type.longtext);
     end
  end
  

 --- set Eventtype
  if ev.ev_subtype == nil then ev.ev_subtype = GEM3_INST_TAG_NONE; end
  if ev.ev_subtype == GEM3_INST_TAG_NONE then
   GEM3UI_CreateTagTypeTextLabel:SetText(GEM3UI_LocalizedStrings["_NoTagDefined"]);
  else
   GEM3UI_CreateTagTypeTextLabel:SetText(GEM3UI_LocalizedStrings["_TagDefined"]);
  end
  GEM3UI_CreateTagTypeTextLabel.id = ev.ev_subtype;
  
 --- set Channel  
  if ev.channel == nil then ev.channel = ""; end
  if ev.channel == "" then
   for i, chan in pairs(GEM3_QA_Config.channels) do
    if GEM3_PLAY_IsPlayerInChannel(chan.name,UnitName("player")) then
     GEM3UI_CreateChannelNameTextLabel:SetText(chan.name);
    end
   end
  else
   GEM3UI_CreateChannelNameTextLabel:SetText(ev.channel);
  end

 --- Set Time and deadline
  local gemdate = date ("*t", ev.ev_date);
  GEM3EDITBOX5:SetText(gemdate.day);
  GEM3EDITBOX6:SetText(gemdate.month);
  GEM3EDITBOX7:SetText(gemdate.year);
  GEM3EDITBOX8:SetText(gemdate.hour);
  GEM3EDITBOX9:SetText(gemdate.min);
 
  gemdate = date ("*t", ev.deadline);
  GEM3EDITBOX10:SetText(gemdate.day);
  GEM3EDITBOX11:SetText(gemdate.month);
  GEM3EDITBOX12:SetText(gemdate.year);
  GEM3EDITBOX13:SetText(gemdate.hour);
  GEM3EDITBOX14:SetText(gemdate.min);

  local gemdate = date ("*t", ev.ev_date+ev.ev_duration);
  GEM3EDITBOX15:SetText(gemdate.day);
  GEM3EDITBOX16:SetText(gemdate.month);
  GEM3EDITBOX17:SetText(gemdate.year);
  GEM3EDITBOX18:SetText(gemdate.hour);
  GEM3EDITBOX19:SetText(gemdate.min);

 --- Set General Event data
  GEM3EDITBOX1:SetText(ev.ev_place);
  GEM3EDITBOX2:SetText(ev.max_count);
  GEM3EDITBOX3:SetText(ev.min_lvl);
  GEM3EDITBOX4:SetText(ev.max_lvl);
  GEM3EDITBOX20:SetText(ev.ev_comment);

 --- Set Class limits
  for i, class in pairs(GEM3UI_Classes) do
   if class.active then
    if ev.classes[class.gemid].min ~= nil then 
     getglobal("GEM3EDITBOX"..class.edid):SetText(ev.classes[class.gemid].min);
    end
    if ev.classes[class.gemid].max ~= nil then 
     getglobal("GEM3EDITBOX"..class.edid+1):SetText(ev.classes[class.gemid].max);
    end
   end
  end
 --- Set Role limits 
  local n=0;
  for i, role in pairs(GEM3UI_Roles) do
   if role.active then 
    n = n+1;
    if ev.roles[role.gemid].min ~= nil then 
     getglobal("GEM3EDITBOX"..role.edid):SetText(ev.roles[role.gemid].min);
    end
    if ev.roles[role.gemid].max ~= nil then 
     getglobal("GEM3EDITBOX"..role.edid+1):SetText(ev.roles[role.gemid].max);
    end
   end
  end
 
 --- Init buttons
  if ev.isTemplate== true or ev.id == nil then
   GEM3UICreateCreate:SetText(GEM3UI_LocalizedStrings["_Create"]);
   GEM3UICreateDelete:Disable();
  else
   GEM3UICreateCreate:SetText(GEM3UI_LocalizedStrings["_Modify"]);
   GEM3UICreateDelete:Enable();
  end
  GEM3UI_CreateAsTemplateButton:Enable();
  GEM3UICreateCreate:Disable();
 
  GEM3UICreate.init=true;
 --GEM3UI_EditCreateValidateForm();
  GEM3UI_CreateFormValidate();
  GEM3UICreate.edited=false;
end






function GEM3UI_EditBoxWheel()
 GEM3UI_WheelValidate(this, arg1);
end


function GEM3UI_WheelValidate(obj, arg1)
 local linkedfield = nil;
 local linkedvalue = nil;
 local t = tonumber(obj:GetText());
 local newt;
 if t == nil then t = 0; end
 local inc = 1;
 if type(obj.vartype) == "number" then
  inc = obj.vartype;
 end
 if obj.vartype == "minute" then
  inc = 15;
 end
 t = t + (inc * arg1);
 
 if obj.vartype == "day" then
  linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))+2);
  local y  = tonumber(linkedfield:GetText());
  linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))+1);
  linkedvalue = tonumber(linkedfield:GetText());
  local checkit = tonumber(date("%m", time({["year"] = y, ["month"] = linkedvalue, ["day"] = t, ["hour"] = 12, ["min"] = 00})));
  if (checkit ~= linkedvalue) and t> 28 then 
     newt= 1;
  end
  if t < 1 then
     newt = tonumber(date("%d", time({["year"] = y, ["month"] = linkedvalue, ["day"] = -1, ["hour"] = 12, ["min"] = 00})))+1;
  end
 end
 
 if obj.vartype == "month" then
  linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))+1);
  linkedvalue = tonumber(linkedfield:GetText());
  if t < 1 then
   newt= 12;
  end
  if t > 12 then
   newt= 1;
  end
 end
 
 if t < 0 and obj.vartype == "minute" then
  if obj:GetName() == "GEM3UIDefaultMinute" then
   linkedfield = GEM3UIDefaultHour;
  else
   linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))-1);
  end
   newt = 45;
 end
 
 if t > 45 and obj.vartype == "minute" then 
  if obj:GetName() == "GEM3UIDefaultMinute" then
   linkedfield = GEM3UIDefaultHour;
  else
   linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))-1);
  end
  newt = 00;
 end
 
 if t < 0 and obj.vartype == "hour" then
  if obj:GetName() ~= "GEM3UIDefaultHour" then
   linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))-3);
  end
  newt = 23;
 end
 if t > 23 and obj.vartype == "hour" then
  if obj:GetName() ~= "GEM3UIDefaultHour" then
   linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))-3);
  end
  newt = 0;
 end
 
 if t < 1  and obj.vartype == "players" then  
  newt = 1;
 end
 
 
 if newt ~= nil and linkedfield then 
  GEM3UI_WheelValidate(linkedfield, arg1);
 end
 
 obj:SetText(newt or t);
 
 if obj.vartype == "minute" or obj.vartype == "hour" or obj.vartype == "day" or obj.vartype == "month" or obj.vartype == "year" then
  GEM3UI_EditboxDateTimeValidate(obj)
 else
  GEM3UI_EditboxValidate(obj);
 end
end


function GEM3UI_EditCreateValidateForm()
 --local id = 1;
 --local edtbx = getglobal("GEM3EDITBOX"..id);
 --while (edtbx ~= nil and id < 50) do
  --GEM3UI_EditboxValidate(edtbx);
  --id = id + 1;
  --edtbx = getglobal("GEM3EDITBOX"..id);
 --end
end



function GEM3UI_EditboxDateTimeValidate(obj)
 if GEM3UICreate.init ~= true then return; end

 GEM3UICreate.edited=true;

 if obj == nil then obj = this; end
  local t = obj:GetText();
  local field = obj.vartype;
  local linkedfield = nil;
  local linkedvalue = nil;
  if field  ~= nil then 
   t = tonumber(t);
 end
 
 if field == "day" then
      t = string.format("%02d",t);
 elseif field == "month" then
      t = string.format("%02d",t);
 elseif field == "year" then
      if t < GEM3UI_today.year then t= GEM3UI_today.year; end
 elseif field == "hour" then
      t = string.format("%02d",t);
 elseif field == "minute" then
      t = string.format("%02d",t);
 end
  if t ~= nil then
  obj:SetText(t);
 end
 GEM3UI_CreateFormValidate();
end


function GEM3UI_EditboxValidate(obj)
 if GEM3UICreate.init ~= true then return; end

 GEM3UICreate.edited=true;

 if obj == nil then obj = this; end
  local t = obj:GetText();
  local field = obj.vartype;
  local linkedfield = nil;
  local linkedvalue = nil;
  if field  ~= nil then 
   t = tonumber(t);
 end
 
 if field == "players" then
      if t < 1 then t= 99; end
      if t > 99 then t= 5; end

 elseif field == "minlvl" then
      linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))+1);
      linkedvalue = tonumber(linkedfield:GetText());
      if t < 1 then t= 70; end
      if t > 70 then t= 1; end
      if linkedvalue < t then linkedfield:SetText(t); end

 elseif field == "maxlvl" then
      linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))-1);
      linkedvalue = tonumber(linkedfield:GetText());
      if t < 1 then t= 70; end
      if t > 70 then t= 1; end
      if linkedvalue > t then linkedfield:SetText(t); end

 elseif field == "limitmin" then
      linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))+1);
      linkedvalue = tonumber(linkedfield:GetText());
      if t ~= nil then
       if t < 1 then 
        t= "";
       else
        if linkedvalue ~= nil then
         if linkedvalue < t then linkedfield:SetText(t); end
        end
       end
      end

 elseif field == "limitmax" then
      linkedfield = getglobal("GEM3EDITBOX"..tonumber(string.sub(obj:GetName(),12))-1);
      linkedvalue = tonumber(linkedfield:GetText());
      if t ~= nil then
       if t < 0 then 
        t= "";
       else
        if linkedvalue ~= nil then
         if linkedvalue > t then 
          if t == 0 then 
           linkedfield:SetText(""); 
          else
           linkedfield:SetText(t); 
          end
         end
        end
       end
      end
 end
 if t ~= nil then
  obj:SetText(t);
 end
 GEM3UI_CreateFormValidate();
end

function GEM3UI_CreateFormValidate()
 local GEM3UI_EV_EDIT_CHECK_OK=0
 local GEM3UI_EV_EDIT_CHECK_EDITED=1
 local GEM3UI_EV_EDIT_CHECK_NOK=2
 
 local allVarsOk = GEM3UI_EV_EDIT_CHECK_OK;
 local msg = "";
  
 local td = time();  -- today y,m,d
 local rectifiedtime = date("*t", td + (60 * 30));
 local check = time({["year"]  = tonumber(GEM3EDITBOX7:GetText()),
                     ["month"] = tonumber(GEM3EDITBOX6:GetText()),
                     ["day"]   = tonumber(GEM3EDITBOX5:GetText()),
                     ["hour"]  = tonumber(GEM3EDITBOX8:GetText()),
                     ["min"]   = tonumber(GEM3EDITBOX9:GetText())});
 
 if check - td < 0 then
  allVarsOk = GEM3UI_EV_EDIT_CHECK_EDITED;
  msg = msg.." - Event date was in the past -> modified";
  GEM3EDITBOX5:SetText(rectifiedtime.day); 
  GEM3EDITBOX6:SetText(rectifiedtime.month);
  GEM3EDITBOX7:SetText(rectifiedtime.year);
  GEM3EDITBOX8:SetText(rectifiedtime.hour);
  GEM3EDITBOX9:SetText(rectifiedtime.min);
  --GEM3UI_EditboxValidate(GEM3EDITBOX5);
  --GEM3UI_EditboxValidate(GEM3EDITBOX6);
  --GEM3UI_EditboxValidate(GEM3EDITBOX7);
  --GEM3UI_EditboxValidate(GEM3EDITBOX8);
  --GEM3UI_EditboxValidate(GEM3EDITBOX9);
 end

 local check2 = time({["year"]  = tonumber(GEM3EDITBOX17:GetText()),
                     ["month"] = tonumber(GEM3EDITBOX16:GetText()),
                     ["day"]   = tonumber(GEM3EDITBOX15:GetText()),
                     ["hour"]  = tonumber(GEM3EDITBOX18:GetText()),
                     ["min"]   = tonumber(GEM3EDITBOX19:GetText())});

 
 if check2 < check then
  local rectifiedtime = date("*t", check);
  allVarsOk = GEM3UI_EV_EDIT_CHECK_EDITED;
  msg = msg.." - Wrong Duration, set to 0 -";
  GEM3EDITBOX15:SetText(rectifiedtime.day);  
  GEM3EDITBOX16:SetText(rectifiedtime.month);
  GEM3EDITBOX17:SetText(rectifiedtime.year);
  GEM3EDITBOX18:SetText(rectifiedtime.hour);
  GEM3EDITBOX19:SetText(rectifiedtime.min);
  
  --GEM3UI_EditboxValidate(GEM3EDITBOX10);
  --GEM3UI_EditboxValidate(GEM3EDITBOX11);
  --GEM3UI_EditboxValidate(GEM3EDITBOX12);
  --GEM3UI_EditboxValidate(GEM3EDITBOX13);
  --GEM3UI_EditboxValidate(GEM3EDITBOX14);
 end
 
  
 if not GEM3_CHAN_IsChannelActive(GEM3UI_CreateChannelNameTextLabel:GetText()) then
  msg = "no channel is selected, please select one";
  allVarsOk = GEM3UI_EV_EDIT_CHECK_NOK;
 end
 
 if string.len(GEM3EDITBOX1:GetText()) == 0 then
  allVarsOk = GEM3UI_EV_EDIT_CHECK_NOK;
  msg = msg.." - No eventname defined";
 end
 
 
 if allVarsOk < GEM3UI_EV_EDIT_CHECK_NOK then
  GEM3UICreateCreate:Enable();
  GEM3UI_CreateAsTemplateButton:Enable();
  if allVarsOk == GEM3UI_EV_EDIT_CHECK_OK then
   msg = "All informations are ok, event can be created";
  else
   msg = msg .. " Event can be created";
  end
 else
  GEM3UICreateCreate:Disable();
  GEM3UI_CreateAsTemplateButton:Disable();
 end
 GEM3UI_SetStatusMessage(msg);

end




-- replacement for the default calendar dayclick function to populate the create event date/deadline fields
function GEM3UI_DayClicked (dayobj)
 local mparent = dayobj:GetParent();
 local dayid = string.sub(dayobj:GetName(),string.len(mparent:GetName())+16);
 local lid = math.floor(dayid/8);
 local day = dayid%8;
 local mdayid = dayid - (lid + 8 + mparent.amonth.wday)+1;
 local pickdate = 0;
 if mdayid > 0 and mdayid <= mparent.amonth.monthdaycount and day > 0 then
    pickdate = time({["year"] = mparent.amonth.year, ["month"] = mparent.amonth.month, ["day"] = mdayid, });
 end
 return pickdate;
end

-- HANDLE TAB KEY to change focus
function GEM3UI_TabPressed()
 local id = string.sub(this:GetName(),12);
 if this.tabid ~= nil then 
   id = this.tabid;
 end
 
 local nxt = getglobal("GEM3EDITBOX"..id+1);
 local go = true;
 local i =0;
 while (nxt ~= nil and go==true) do
  if nxt:IsVisible() then
   nxt:SetFocus();
   go = false;
  else
   i = i +1;
   nxt = getglobal("GEM3EDITBOX"..id+i);
  end
 end
 if go == true then
  getglobal("GEM3EDITBOX1"):SetFocus();
 end
end




function GEM3UI_CreateNewFromTemplate(value)
 GEM3UICreate.ev_id =value;
 GEM3UI_MainTabClick(2);
 --GEM3UICreate.ev_id =value;
 --GEM3UI_InitCreateForm();
end

function GEM3UI_Create_GetNewEvent(ev)
 if GEM3UICreate.event == nil then GEM3UICreate.event = {}; end
 local cal = getglobal("GEM3UICalendar"); 
 local nev = GEM3UICreate.event;
 if ev == nil then ev={}; end

 if ev.isTemplate then
  nev.ev_date = time({day=cal.SELDAY.day, month=cal.SELDAY.month, year=cal.SELDAY.year, hour=GEM3UI.DefaultHour, min=GEM3UI.DefaultMinute, sec=0 });
  nev.deadline = time({day=cal.SELDAY.day, month=cal.SELDAY.month, year=cal.SELDAY.year, hour=GEM3UI.DefaultHour, min=GEM3UI.DefaultMinute, sec=0 });
 else
  nev.ev_date = ev.ev_date or time({day=cal.SELDAY.day, month=cal.SELDAY.month, year=cal.SELDAY.year, hour=GEM3UI.DefaultHour, min=GEM3UI.DefaultMinute, sec=0 });
  nev.deadline = ev.deadline or time({day=cal.SELDAY.day, month=cal.SELDAY.month, year=cal.SELDAY.year, hour=GEM3UI.DefaultHour, min=GEM3UI.DefaultMinute, sec=0 });
 end
 nev.ev_duration = ev.ev_duration or GEM3UI.DefaultDuration;
 
 nev.channel = ev.channel;
 nev.sorttype = ev.sorttype;
 
 nev.ev_type = ev.ev_type or GEM3_EVT_TYPE_NONE;
 nev.ev_subtype = ev.ev_subtype or GEM3_INST_TAG_NONE;
 
 nev.leader= ev.leader or UnitName("player");
 if ev.ev_place then
  nev.ev_place = ev.ev_place
  GEM3UICreate.FilterName = ev.ev_place;
 else
  nev.ev_place = "";
  GEM3UICreate.FilterName = nil;
 end
 nev.ev_comment = ev.ev_comment or "";
 nev.max_count = ev.max_count or 5;
 nev.min_lvl = ev.min_lvl or 1;
 nev.max_lvl = ev.max_lvl or GEM3UI_MaxLevel;
 nev.tit_count = ev.tit_count or 0;
 nev.sub_count = ev.sub_count or 0;
 nev.repl_count = ev.repl_count or 0;
 nev.rej_count = ev.rej_count or 0;
 
 if ev.players then
  nev.players = GEM3UI_TblCpy(ev.players);
 else
  nev.players = {};
 end
 
 if ev.classes then
  nev.classes = GEM3UI_TblCpy(ev.classes);
 else
  nev.classes = {
   ["DRUID"]   = {min=nil , max=nil},
   ["HUNTER"]  = {min=nil , max=nil},
   ["MAGE"]    = {min=nil , max=nil},
   ["PALADIN"] = {min=nil , max=nil},
   ["PRIEST"]  = {min=nil , max=nil},
  
   ["ROGUE"]   = {min=nil , max=nil},
   ["SHAMAN"]  = {min=nil , max=nil},
   ["WARLOCK"] = {min=nil , max=nil},
   ["WARRIOR"] = {min=nil , max=nil},
 --  ["HERO"]    = {min=nil, max=nil},
  };
 end
 
 if ev.roles then
  nev.roles = ev.roles
 nev.roles = GEM3UI_TblCpy(ev.roles);
 else
  nev.roles =  {
   [GEM3_ROLE_TANK] = {min=nil , max=nil},
   [GEM3_ROLE_HEAL] = {min=nil , max=nil},
   [GEM3_ROLE_RDPS] = {min=nil , max=nil},
   [GEM3_ROLE_CDPS] = {min=nil , max=nil},
  };
 end
 nev.id = ev.id or nil;
 nev.isTemplate = ev.isTemplate or nil;
 return nev;
end


--- Dropdown handling

function GEM3UI_ChannelsDD(self)
   if GEM3UI_DDTable == nil then
    GEM3UI_DDTable = GA_GetTable();
   end
   table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings["_Channels"],   isTitle = true, textHeight = 12 });
   for i, channel in pairs(GEM3_QA_Config.channels) do
   if GEM3_PLAY_IsPlayerInChannel(channel.name,UnitName("player")) then
    table.insert(GEM3UI_DDTable, {   text = channel.name,  func = function() GEM3UI_ChannelsCreateDDClicked(channel.name) end,});
   end
  end
  GEM3UI_SetDDMenu(self, GEM3UI_DDTable)
end

function GEM3UI_ChannelsCreateDDClicked(channame)
 GEM3UI_CreateChannelNameTextLabel:SetText(channame);
end

function GEM3UI_FillEvtTypeDD(self)
 if GEM3UI_DDTable == nil then
  GEM3UI_DDTable = GA_GetTable();
 end
 table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings["_EventType"],   isTitle = true, textHeight = 12 });

 for i, evttype in pairs(GEM3UI_LocalizedStrings.EventTypes) do
   if i == 0 or i >=20 or GEM3_QA_Config.debug > 0 then
      table.insert(GEM3UI_DDTable, {   text = evttype.longtext,  func = function() GEM3UI_EvtTypeCreateDDClicked(i, evttype.longtext) end,});
   end
 end
 GEM3UI_SetDDMenu(self, GEM3UI_DDTable)
end

function GEM3UI_EvtTypeCreateDDClicked(id, evtype)
 GEM3UI_CreateTypeTextLabel:SetText(evtype);
 GEM3UI_CreateTypeTextLabel.id = id;
end

function GEM3UI_CreateTagTypeDD(self)
 local ischecked;
 if GEM3UI_DDTable == nil then
  GEM3UI_DDTable = GA_GetTable();
 end
 table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings["taggedInstancesddtitle"],   isTitle = true, textHeight = 12 });

 for i, label in pairs(TaggedInstances) do
  if i ~= GEM3_INST_TAG_NONE then
   local _, val = GEM3UI_CreateGetTag(i)
   if val == 0 then val = GEM3UI_LocalizedStrings["_NoTagDefined"];
   else             val = GEM3UI_LocalizedStrings["_TagDefined"];
   end
   table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings[label.name],  isradio = true, checked = GEM3UI_CreateGetTag(i), func = function() GEM3UI_CreateAddTagtoEvent(i, val) end,});
  end
 end
 GEM3UI_SetDDMenu(self, GEM3UI_DDTable)
end

function GEM3UI_CreateAddTagtoEvent(value, val)
 if (bit.band(GEM3UICreate.event.ev_subtype, value) == value) then
  GEM3UICreate.event.ev_subtype = GEM3UICreate.event.ev_subtype - value;
 else
  GEM3UICreate.event.ev_subtype = GEM3UICreate.event.ev_subtype + value;
 end
 GEM3UI_CreateTagTypeTextLabel.id = GEM3UICreate.event.ev_subtype ;
 GEM3UI_CreateTagTypeTextLabel:SetText(val);
end

function GEM3UI_CreateGetTag(i)
 if (bit.band(GEM3UICreate.event.ev_subtype, i) == i) then
  return true, GEM3UICreate.event.ev_subtype-i;
 else
  return false, GEM3UICreate.event.ev_subtype+i;
 end
end

function GEM3UI_TemplatesDD(self)
 if GEM3UI_DDTable == nil then
  GEM3UI_DDTable = GA_GetTable();
 end
 table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings["_Templates"],   isTitle = true, textHeight = 12 });

 for index, evt in pairs(GEM3UI.Templates) do
  --if GEM3UI_DDTable[GEM3UI_LocalizedStrings.EventTypes[evt.ev_type].longtext] == nil then
   --table.insert(GEM3UI_DDTable, {   text = GEM3UI_LocalizedStrings.EventTypes[evt.ev_type].longtext,  hasArrow = true, func = function() GEM3UI_CreateNewFromTemplateDD(index) end,});
   --GEM3UI_DDTable[GEM3UI_LocalizedStrings.EventTypes[evt.ev_type].longtext] = GA_GetTable();
  --end
  --table.insert(GEM3UI_DDTable[GEM3UI_LocalizedStrings.EventTypes[evt.ev_type].longtext], {   text = evt.ev_place,  func = function() GEM3UI_CreateNewFromTemplateDD(index) end,});
  table.insert(GEM3UI_DDTable, {   text = evt.ev_place,  func = function() GEM3UI_CreateNewFromTemplateDD(index) end,});
 end
 GEM3UI_SetDDMenu(self, GEM3UI_DDTable)
end


function GEM3UI_CreateNewFromTemplateDD(value)
 local oldsource = GEM3UI_EventSource;
 GEM3UI_EventSource = GEM3UI.Templates;
 GEM3UICreate.ev_id =value;
 GEM3UI_InitCreateForm();
 GEM3UI_EventSource = oldsource;
end
