﻿--[[
 Guild Event Manager GUI
 -------------------------------------
  Code: Movix - Conseil des Ombres - EU
  Constants  
]]


GEM3UI_CFGChanEditAllowed = true;
GEM3UIDBG = false;

-- VERSION STUFF
GEM3UI_MAJOR = 1;
GEM3UI_MINOR = 5;
GEM3UI_REVISION = "1";
GEM3UI_MINCOREVERSION = "3.12";

GEM3UI_SAMEVERSION = 0;
GEM3UI_NEWERMAJOR = 1;
GEM3UI_NEWERMINOR = 2;
GEM3UI_NEWERREVISION = 4;
GEM3UI_OLDERMAJOR = 8;
GEM3UI_OLDERMINOR = 16;
GEM3UI_OLDERREVISION = 32;

-- REFRESHING CONSTANTS
GEM3UI_REFRESH_CLOSE_OPEN_EVENTLINE = 1;
GEM3UI_REFRESH_NO_CLOSE_OPEN_EVENTLINE = 2;
GEM3UI_REFRESH_NO_CALENDARREFRESH = 4;

GEM3UI_EVENT_CHANGE_VIEWED = 0;
GEM3UI_EVENT_CHANGE_NEW = 1;
GEM3UI_EVENT_CHANGE_DELETE = 2;
GEM3UI_EVENT_CHANGE_UPDATE = 4;
GEM3UI_EVENT_CHANGE_DATECHANGE = 8;
GEM3UI_EVENT_CHANGE_SUBSCHANGE = 16;
GEM3UI_EVENT_CHANGE_CLOSE = 32;

-- CONSTANTS For UI STUFF
GEM3UI_FrameRatio = 1;
GEM3UI_MainWidth = 718;
GEM3UI_MainHeight = 480;
GEM3UI_OldScale =  1;
GEM3UI_DefaultDDLines = 15;
GEM3UI_DefaultChannelLines = 5;
GEM3UI_DefaultLines = 25;
GEM3UI_DefaultPlayerLines = 16;
GEM3UI_DefaultDayEvents = 6;
GEM3UI_DefaultPlugins = 6;
GEM3UI_DefaultChannelPlayerLines = 23;
GEM3UI_lines = GEM3UI_DefaultLines;
GEM3UI_DefaultLineHeight = 14;
GEM3UI_DefaultLineExpandedMultiplicator = 23;

-- DATA CONSTANTS
GEM3UI_OLD = {};
GEM3UIDBGSCRL = {};
GEM3UI_DEBUGDATA = GA_GetTable();
GEM3UI_DebugNav_actPage = 1;
GEM3UI_DEBUGTOTALSHOWNMSG = 0;
GEM3UI_MAXDEBUGLINES = 30000;
GEM3UI_DEBUGLINESPERPAGE = 150;
GEM3UI_MaxLevel = 70;
GEM3UI_IsSizing = false;
GEM3UI_EventSource = nil;
GEM3UI_PluginList = {};
MyEvent = {};
GEM3UI_Popupdata = {};
GEM3UI_EventTypePresent = {};
GEM3UI_EventChannelFilters = {}
GEM3UI_expandedLine = 0;
GEM3_NewEvents = 0;
GEM3UI_DatePickTarget = "date";
GEM3UI_eventcount = 0;
GEM3UI_eventmembercount = 0;
GEM3UI_DayEventCount = 0;
GEM3UI_tabid = 1;
GEM3UI_today = "";
GEM3UI_month = "";
GEM3UI_SELDAY = "";

GEM3UI_totalEvents = 0;
GEM3UI_subsEvents =0;
GEM3UI_closedEvents =0;
GEM3UI_ignoredEvents =0;
GEM3UI_newEvents ={};

GEM3UI_ConnectedMembers = 0;
GEM3UI_ignoredMembers =0;
GEM3UI_totalMembers=0;


-- VARIOUS CONSTANTS FOR EVENT DISPLAYING
GEM3UI_Classes = {
  [1] =  {gemid = "DRUID",   edid=21 , name_loc = GEM3UI_CLASS_STRINGS["DRUID"],   icon = "ability_druid_maul",active = true },
  [2] =  {gemid = "HUNTER",  edid=25 , name_loc = GEM3UI_CLASS_STRINGS["HUNTER"],  icon = "inv_weapon_bow_07", active = true },
  [3] =  {gemid = "MAGE",    edid=29 , name_loc = GEM3UI_CLASS_STRINGS["MAGE"],    icon = "inv_staff_13", active = true },
  [4] =  {gemid = "PALADIN", edid=33 , name_loc = GEM3UI_CLASS_STRINGS["PALADIN"], icon = "inv_hammer_01", active = true },
  [5] =  {gemid = "PRIEST",  edid=37 , name_loc = GEM3UI_CLASS_STRINGS["PRIEST"],  icon = "inv_staff_30", active = true },
  [6] =  {gemid = "ROGUE",   edid=23 , name_loc = GEM3UI_CLASS_STRINGS["ROGUE"],   icon = "inv_throwingknife_04", active = true },
  [7] =  {gemid = "SHAMAN",  edid=27 , name_loc = GEM3UI_CLASS_STRINGS["SHAMAN"],  icon = "spell_nature_bloodlust", active = true },
  [8] =  {gemid = "WARLOCK", edid=31 , name_loc = GEM3UI_CLASS_STRINGS["WARLOCK"], icon = "spell_nature_faeriefire", active = true },
  [9] =  {gemid = "WARRIOR", edid=35 , name_loc = GEM3UI_CLASS_STRINGS["WARRIOR"], icon = "inv_sword_27",  active = true },
  [10] = {gemid = "HERO",    edid=39 , name_loc = GEM3UI_CLASS_STRINGS["HERO"],    icon = "inv_helmet_70",  active = false },
}

GEM3UI_Roles = {
 [0] = { gemid = 0, edid=nil , name = "UNKNOWN", name_loc = "", icon ="", active = false},
 [1] = { gemid = 1, edid=41 , name = "TANK", name_loc = GEM3UI_LocalizedStrings["_Tank"], icon ="ability_warrior_defensivestance", active = true},
 [2] = { gemid = 2, edid=47 , name = "CDPS", name_loc = GEM3UI_LocalizedStrings["_Contact"], icon ="ability_parry", active = true},
 [3] = { gemid = 4, edid=45 , name = "RDPS", name_loc = GEM3UI_LocalizedStrings["_Range"], icon ="inv_ammo_snowball", active = true},
 [4] = { gemid = 6, edid=nil , name = "DPS",  name_loc = GEM3UI_LocalizedStrings["_DPS"], icon ="ability_parry", active = false},
 [5] = { gemid = 8, edid=43 , name = "HEAL", name_loc = GEM3UI_LocalizedStrings["_Heal"], icon ="spell_holy_sealofsacrifice", active = true},
}
 

GEM3UI_Queues = {
 [0] = {name=GEM3UI_LocalizedStrings["_unknown"], short=GEM3UI_LocalizedStrings["_unknownshort"], icon=""},
 [1] = {name=GEM3UI_LocalizedStrings["_titular"], short=GEM3UI_LocalizedStrings["_titularshort"], icon="inv_chest_cloth_52" },
 [2] = {name=GEM3UI_LocalizedStrings["_substitute"], short=GEM3UI_LocalizedStrings["_substituteshort"], icon="inv_chest_cloth_53" },
 [3] = {name=GEM3UI_LocalizedStrings["_replacement"], short=GEM3UI_LocalizedStrings["_replacementshort"], icon="inv_chest_cloth_54" },
 [4] = {name=GEM3UI_LocalizedStrings["_not_coming"], short=GEM3UI_LocalizedStrings["_not_comingshort"], icon="" },
 [5] = {name=GEM3UI_LocalizedStrings["_not_ackned"], short=GEM3UI_LocalizedStrings["_not_acknedshort"], icon="inv_chest_cloth_55" },
 [6] = {name=GEM3UI_LocalizedStrings["_discard"], short=GEM3UI_LocalizedStrings["_discarshort"], icon="" },
 [7] = {name=GEM3UI_LocalizedStrings["_unsubscribing"], short=GEM3UI_LocalizedStrings["_unsubscribingshort"], icon="" },
 }


GEM3UI_EV_STATE_NORMAL   = 0;
GEM3UI_EV_STATE_NAK      = 1;
GEM3UI_EV_STATE_SUBS     = 2;
GEM3UI_EV_STATE_CLOSED   = 4;
GEM3UI_EV_STATE_IGNORED  = 8;
GEM3UI_EV_STATE_OUTDATED = 16;
GEM3UI_EV_STATE_BANNED   = 32;
GEM3UI_EV_STATE_DELETED   = 64;
GEM3UI_EV_STATE_UPDATED   = 128;
GEM3UI_EV_STATE_NEW   = 256;
GEM3UI_EV_STATE_PASSED   = 512;

GEM3UI_EVLINE = { -- Eventline icon and color formats
 [GEM3UI_EV_STATE_NORMAL] = {icon="", icon_color = {r = 1, g = 1, b = 1, a = 1 }, texc=nil, line_color = {r = 1, g = 1, b = 1, a = 1 } },
 [GEM3UI_EV_STATE_NAK] = {icon="interface\\AddOns\\GEM3UI\\sub_nak", texc=nil,  icon_color = {r = 0.1, g = 1, b = 0.1, a = 1 }, line_color= {r = 0, g = 1, b = 1, a = 1 }  },
 [GEM3UI_EV_STATE_SUBS] = {icon="interface\\AddOns\\GEM3UI\\check", texc= {l=0, r=0.62, t=0, b=0.68},  icon_color = {r = 0, g = 0.5, b = 0, a = 1 }, line_color= {r = 0, g = 1, b = 1, a = 1 }  }, 
 [GEM3UI_EV_STATE_CLOSED] = {icon="interface\\glues\\characterselect\\glues-addon-icons", texc= {l=0.25, r=0.5, t=0, b=1}, icon_color = {r = 1, g = 1, b = 1, a = 1 }, line_color= {r = 1, g = 1, b = 1, a = 0.5 }  },
 [GEM3UI_EV_STATE_IGNORED] = {icon="interface\\AddOns\\GEM3UI\\X", icon_color = {r = 1, g = 0, b = 0, a = 1 },  texc=nil, line_color= {r = 1, g = 0.2, b = 0.2, a = 0.8 }  },
 [GEM3UI_EV_STATE_OUTDATED] = {icon="interface\\AddOns\\GEM3UI\\bell", icon_color = {r = 1, g = 1, b = 1, a = 1 },  texc=nil, line_color= {r = 1, g = 1, b = 1, a = 1 }  },
 [GEM3UI_EV_STATE_BANNED] = {icon="interface\\spellshadow\\spell-shadow-unacceptable", icon_color = nil,  texc=nil, line_color= {r = 0.2, g = 0.2, b = 0.2, a = 0.5 }  },
 [GEM3UI_EV_STATE_DELETED] = {icon="interface\\AddOns\\GEM3UI\\X", icon_color = nil,  texc=nil, line_color= {r = 0.2, g = 0.2, b = 0.2, a = 0.5 }  },
 [GEM3UI_EV_STATE_UPDATED] = {icon="interface\\spellshadow\\spell-shadow-unacceptable", icon_color = nil,  texc=nil, line_color= {r = 0.2, g = 0.2, b = 0.2, a = 0.5 }  },
 [GEM3UI_EV_STATE_NEW] = {icon="interface\\gossipframe\\availablequesticon", icon_color = nil,  texc=nil, line_color= {r = 1, g = 1, b = 1, a = 1 }  },
 [GEM3UI_EV_STATE_PASSED] = {icon="interface\\AddOns\\GEM3UI\\bell", icon_color = nil,  texc=nil, line_color= {r = 1, g = 1, b = 1, a = 0.5 }  },
};

GEM3UI_EVSUBS = { -- Subscription colors
 [0] = {name="NONE", icon_color = {r = 1, g = 1, b = 1, a = 1 }, text_color = {r = 1, g = 1, b = 1, a = 1 } },
 [1] = {name="TIT",  icon_color = {r = 0, g = 1, b = 0, a = 1 }, text_color = {r = 0, g = 1, b = 0, a = 1 }  },
 [2] = {name="SUBS", icon_color = {r = 1, g = 0.85, b = 0.1, a = 1 }, text_color = {r = 1, g = 0.85, b = 0.1, a = 1 }  },
 [3] = {name="REPL", icon_color = {r = 0, g = 0.5, b = 1, a = 1 }, text_color = {r = 0, g = 0.5, b = 1, a = 1 }  },
 [4] = {name="NC",   icon_color = {r = 0.8, g = 0.64, b = 0.42, a = 1 }, text_color = {r = 0.8, g = 0.64, b = 0.42, a = 1 }  },
 [5] = {name="NONE", icon_color = {r = 1, g = 1, b = 1, a = 1 }, text_color = {r = 1, g = 1, b = 1, a = 1 } },
 [6] = {name="NONE", icon_color = {r = 1, g = 1, b = 1, a = 1 }, text_color = {r = 1, g = 1, b = 1, a = 1 } },
 [7] = {name="NONE", icon_color = {r = 1, g = 1, b = 1, a = 1 }, text_color = {r = 1, g = 1, b = 1, a = 1 } },
};


-- CALENDAR CONSTANTS
GEM3UI_monthdays = {
  [1] = 31,
  [2] = 28,
  [3] = 31,
  [4] = 30,
  [5] = 31,
  [6] = 30,
  [7] = 31,
  [8] = 31,
  [9] = 30,
  [10] = 31,
  [11] = 30,
  [12] = 31,
}

GEM3UI_COLOR_CAL_TOPLEFTFIELD = 0;
GEM3UI_COLOR_CAL_DAYHEADER = 1;
GEM3UI_COLOR_CAL_WEEKNUMHEADER = 2;
GEM3UI_COLOR_CAL_DAYLASTNEXTMONTH = 3;
GEM3UI_COLOR_CAL_NORMAL = 4;
GEM3UI_COLOR_CAL_TODAY = 5;
GEM3UI_COLOR_CAL_WITHEVENT = 6;
GEM3UI_COLOR_CAL_WITHSUBSCRIBEDEVENT = 7;
GEM3UI_COLOR_CAL_SELECTEDDAY = 8;
GEM3UI_COLOR_CAL_MOUSEOVER = 9;


-- Calendarfield background color (larger frame, outer)
GEM3UI_calcol = {
		{
			["a"] = 1,
			["r"] = 0.6196078431372549,
			["g"] = 0.6196078431372549,
			["b"] = 0.6196078431372549,
		}, -- [1]
		{
			["a"] = 1,
			["r"] = 0.6196078431372549,
			["g"] = 0.6196078431372549,
			["b"] = 0.6196078431372549,
		}, -- [2]
		{
			["a"] = 1,
			["r"] = 0.2156862745098039,
			["g"] = 0.2156862745098039,
			["b"] = 0.2156862745098039,
		}, -- [3]
		{
			["a"] = 0,
			["r"] = 0.1372549019607843,
			["g"] = 0.1372549019607843,
			["b"] = 0.1372549019607843,
		}, -- [4]
		{
			["a"] = 1,
			["r"] = 0.5058823529411765,
			["g"] = 0.5058823529411765,
			["b"] = 0.5058823529411765,
		}, -- [5]
		{
			["a"] = 1,
			["r"] = 0.5725490196078431,
			["g"] = 0.592156862745098,
			["b"] = 0,
		}, -- [6]
		{
			["a"] = 1,
			["r"] = 0,
			["g"] = 0.04705882352941176,
			["b"] = 0.984313725490196,
		}, -- [7]
		{
			["a"] = 1,
			["r"] = 1,
			["g"] = 1,
			["b"] = 1,
		}, -- [8]
		{
			["a"] = 1,
			["r"] = 1,
			["g"] = 0,
			["b"] = 0,
		}, -- [9]
		[0] = {
			["a"] = 1,
			["r"] = 0.6196078431372549,
			["g"] = 0.6196078431372549,
			["b"] = 0.6196078431372549,
		},
	};

-- Calendarfield color (smaller framer, inner)
GEM3UI_daycol = {
		{
			["a"] = 0.949999988079071,
			["b"] = 0.5529411764705883,
			["g"] = 0.5529411764705883,
			["r"] = 0.5529411764705883,
		}, -- [1]
		{
			["a"] = 0.949999988079071,
			["b"] = 0.5529411764705883,
			["g"] = 0.5529411764705883,
			["r"] = 0.5529411764705883,
		}, -- [2]
		{
			["a"] = 0,
			["b"] = 0.2156862745098039,
			["g"] = 0.2156862745098039,
			["r"] = 0.2156862745098039,
		}, -- [3]
		{
			["a"] = 0.5099999904632568,
			["b"] = 0.1372549019607843,
			["g"] = 0.1372549019607843,
			["r"] = 0.1372549019607843,
		}, -- [4]
		{
			["a"] = 1,
			["b"] = 0.796078431372549,
			["g"] = 0.796078431372549,
			["r"] = 0.796078431372549,
		}, -- [5]
		{
			["a"] = 1,
			["b"] = 0.3333333333333333,
			["g"] = 0.3333333333333333,
			["r"] = 0.3333333333333333,
		}, -- [6]
		{
			["a"] = 1,
			["b"] = 0,
			["g"] = 0.396078431372549,
			["r"] = 0.05490196078431373,
		}, -- [7]
		{
			["a"] = 1,
			["b"] = 0,
			["g"] = 0,
			["r"] = 1,
		}, -- [8]
		{
			["a"] = 1,
			["b"] = 0,
			["g"] = 0,
			["r"] = 1,
		}, -- [9]
		[0] = {
			["a"] = 0,
			["b"] = 0.6901960784313725,
			["g"] = 0.6901960784313725,
			["r"] = 0.6901960784313725,
		},
	};
-- Calendarfield text
GEM3UI_caltext = {
		{
			["a"] = 1,
			["b"] = 1,
			["g"] = 1,
			["r"] = 1,
		}, -- [1]
		{
			["a"] = 1,
			["b"] = 1,
			["g"] = 1,
			["r"] = 1,
		}, -- [2]
		{
			["a"] = 0,
			["b"] = 0.2156862745098039,
			["g"] = 0.2156862745098039,
			["r"] = 0.2156862745098039,
		}, -- [3]
		{
			["a"] = 1,
			["b"] = 0.6666666666666666,
			["g"] = 0.6666666666666666,
			["r"] = 0.6666666666666666,
		}, -- [4]
		{
			["a"] = 1,
			["b"] = 1,
			["g"] = 1,
			["r"] = 1,
		}, -- [5]
		{
			["a"] = 1,
			["b"] = 0,
			["g"] = 1,
			["r"] = 1,
		}, -- [6]
		{
			["a"] = 1,
			["b"] = 1,
			["g"] = 1,
			["r"] = 1,
		}, -- [7]
		{
			["a"] = 1,
			["b"] = 1,
			["g"] = 1,
			["r"] = 1,
		}, -- [8]
		{
			["a"] = 1,
			["b"] = 0,
			["g"] = 0,
			["r"] = 1,
		}, -- [9]
		[0] = {
			["a"] = 1,
			["b"] = 0.6078431372549019,
			["g"] = 0.6078431372549019,
			["r"] = 0.6078431372549019,
		},
	};


-- CONSTANTS FOR TEMPLATE TEMPLATES
GEM3UI_DefaultEvents = {

 [GEM3UI_LocalizedStrings["guildEvents"]] = {
   [GEM3UI_LocalizedStrings["OfficerMeeting"]] = { ev_place=GEM3UI_LocalizedStrings["OfficerMeeting"], ev_comment=GEM3UI_LocalizedStrings["OfficerMeetingComment"], channel="", min_lvl=1, max_lvl=GEM3UI_MaxLevel, max_count=99, sortstring="", ev_type=GEM3_EVT_TYPE_GUILD_EVENT},
   [GEM3UI_LocalizedStrings["GuildSocialEvent"]] = { ev_place=GEM3UI_LocalizedStrings["GuildSocialEvent"], ev_comment=GEM3UI_LocalizedStrings["GuildSocialEventComment"], channel="", min_lvl=1, max_lvl=GEM3UI_MaxLevel, max_count=99, sortstring="", ev_type=GEM3_EVT_TYPE_GUILD_EVENT},
   [GEM3UI_LocalizedStrings["Quest5"]] = { ev_place=GEM3UI_LocalizedStrings["Quest5"], ev_comment=GEM3UI_LocalizedStrings["Quest5Comment"], channel="", min_lvl=1, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_NONE},
   [GEM3UI_LocalizedStrings["Quest10"]] = { ev_place=GEM3UI_LocalizedStrings["Quest10"], ev_comment=GEM3UI_LocalizedStrings["Quest10Comment"], channel="", min_lvl=1, max_lvl=GEM3UI_MaxLevel, max_count=10, sortstring="", ev_type=GEM3_EVT_TYPE_NONE},
   [GEM3UI_LocalizedStrings["DailyQuest"]] = { ev_place=GEM3UI_LocalizedStrings["DailyQuest"], ev_comment=GEM3UI_LocalizedStrings["DailyQuestComment"], channel="", min_lvl=50, max_lvl=GEM3UI_MaxLevel, max_count=99, sortstring="", ev_type=GEM3_EVT_TYPE_QUEST_NONE},
 },
 [GEM3UI_LocalizedStrings["PreBCEventsRaid"]] = {
  [GEM3UI_LocalizedStrings["UBRS"]] = { ev_place=GEM3UI_LocalizedStrings["UBRS"], ev_comment=GEM3UI_LocalizedStrings["UBRSComment"], channel="", min_lvl=45, max_lvl=GEM3UI_MaxLevel, max_count=10, sortstring=""},
  [GEM3UI_LocalizedStrings["ZG"]] = { ev_place=GEM3UI_LocalizedStrings["ZG"], ev_comment=GEM3UI_LocalizedStrings["ZGComment"], channel="", min_lvl=50, max_lvl=GEM3UI_MaxLevel, max_count=20, sortstring="", ev_type=GEM3_EVT_TYPE_RAID, ev_subtype=GEM3_INST_TAG_ZG},
  [GEM3UI_LocalizedStrings["AQ20"]] = { ev_place=GEM3UI_LocalizedStrings["AQ20"], ev_comment=GEM3UI_LocalizedStrings["AQ20Comment"], channel="", min_lvl=50, max_lvl=GEM3UI_MaxLevel, max_count=20, sortstring="", ev_type=GEM3_EVT_TYPE_RAID, ev_subtype=GEM3_INST_TAG_AQ20},
  [GEM3UI_LocalizedStrings["AQ40"]] = { ev_place=GEM3UI_LocalizedStrings["AQ40"], ev_comment=GEM3UI_LocalizedStrings["AQ40Comment"], channel="", min_lvl=50, max_lvl=GEM3UI_MaxLevel, max_count=40, sortstring="", ev_type=GEM3_EVT_TYPE_RAID, ev_subtype=GEM3_INST_TAG_AQ40},
  [GEM3UI_LocalizedStrings["ONY"]] = { ev_place=GEM3UI_LocalizedStrings["ONY"], ev_comment=GEM3UI_LocalizedStrings["ONYComment"], channel="", min_lvl=50, max_lvl=GEM3UI_MaxLevel, max_count=40, sortstring="", ev_type=GEM3_EVT_TYPE_RAID, ev_subtype=GEM3_INST_TAG_ONY},
  [GEM3UI_LocalizedStrings["MC"]] = { ev_place=GEM3UI_LocalizedStrings["MC"], ev_comment=GEM3UI_LocalizedStrings["MCComment"], channel="", min_lvl=50, max_lvl=GEM3UI_MaxLevel, max_count=40, sortstring="", ev_type=GEM3_EVT_TYPE_RAID, ev_subtype=GEM3_INST_TAG_MC},
  [GEM3UI_LocalizedStrings["NAX"]] = { ev_place=GEM3UI_LocalizedStrings["NAX"], ev_comment=GEM3UI_LocalizedStrings["NAXComment"], channel="", min_lvl=60, max_lvl=GEM3UI_MaxLevel, max_count=40, sortstring="", ev_type=GEM3_EVT_TYPE_RAID, ev_subtype=GEM3_INST_TAG_NAX},
  [GEM3UI_LocalizedStrings["BWL"]] = { ev_place=GEM3UI_LocalizedStrings["BWL"], ev_comment=GEM3UI_LocalizedStrings["BWLComment"], channel="", min_lvl=60, max_lvl=GEM3UI_MaxLevel, max_count=40, sortstring="", ev_type=GEM3_EVT_TYPE_RAID, ev_subtype=GEM3_INST_TAG_BWL},
 },
 [GEM3UI_LocalizedStrings["BCEventsInstance5"]] = {
   [GEM3UI_LocalizedStrings["HellfireRamp"]] = { ev_place=GEM3UI_LocalizedStrings["HellfireRamp"], ev_comment=GEM3UI_LocalizedStrings["HellfireRampComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["BloodFum"]] = { ev_place=GEM3UI_LocalizedStrings["BloodFum"], ev_comment=GEM3UI_LocalizedStrings["BloodFumComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["SlavePens"]] = { ev_place=GEM3UI_LocalizedStrings["SlavePens"], ev_comment=GEM3UI_LocalizedStrings["SlavePensComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["Underbog"]] = { ev_place=GEM3UI_LocalizedStrings["Underbog"], ev_comment=GEM3UI_LocalizedStrings["UnderbogComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["ManaTomb"]] = { ev_place=GEM3UI_LocalizedStrings["ManaTomb"], ev_comment=GEM3UI_LocalizedStrings["ManaTombComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["Crypt"]] = { ev_place=GEM3UI_LocalizedStrings["Crypt"], ev_comment=GEM3UI_LocalizedStrings["CryptComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["Sethek"]] = { ev_place=GEM3UI_LocalizedStrings["Sethek"], ev_comment=GEM3UI_LocalizedStrings["SethekComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["Steamvault"]] = { ev_place=GEM3UI_LocalizedStrings["Steamvault"], ev_comment=GEM3UI_LocalizedStrings["SteamvaultComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["ShadowLab"]] = { ev_place=GEM3UI_LocalizedStrings["ShadowLab"], ev_comment=GEM3UI_LocalizedStrings["ShadowLabComment"], channel="", min_lvl=65, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["Mechenar"]] = { ev_place=GEM3UI_LocalizedStrings["Mechenar"], ev_comment=GEM3UI_LocalizedStrings["MechenarComment"], channel="", min_lvl=68, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["Botanica"]] = { ev_place=GEM3UI_LocalizedStrings["Botanica"], ev_comment=GEM3UI_LocalizedStrings["BotanicaComment"], channel="", min_lvl=68, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["Arcatraz"]] = { ev_place=GEM3UI_LocalizedStrings["Arcatraz"], ev_comment=GEM3UI_LocalizedStrings["ArcatrazComment"], channel="", min_lvl=68, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["ShatHall"]] = { ev_place=GEM3UI_LocalizedStrings["ShatHall"], ev_comment=GEM3UI_LocalizedStrings["ShatHallComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["CoT1"]] = { ev_place=GEM3UI_LocalizedStrings["CoT1"], ev_comment=GEM3UI_LocalizedStrings["CoT1Comment"], channel="", min_lvl=66, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
   [GEM3UI_LocalizedStrings["CoT2"]] = { ev_place=GEM3UI_LocalizedStrings["CoT2"], ev_comment=GEM3UI_LocalizedStrings["CoT2Comment"], channel="", min_lvl=66, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BC},
 },

 [GEM3UI_LocalizedStrings["BCEventsInstance5Heroic"]] = {
   [GEM3UI_LocalizedStrings["HellfireRampH"]] = { ev_place=GEM3UI_LocalizedStrings["HellfireRampH"], ev_comment=GEM3UI_LocalizedStrings["HellfireRampHComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["BloodFumH"]] = { ev_place=GEM3UI_LocalizedStrings["BloodFumH"], ev_comment=GEM3UI_LocalizedStrings["BloodFumHComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["SlavePensH"]] = { ev_place=GEM3UI_LocalizedStrings["SlavePensH"], ev_comment=GEM3UI_LocalizedStrings["SlavePensHComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["UnderbogH"]] = { ev_place=GEM3UI_LocalizedStrings["UnderbogH"], ev_comment=GEM3UI_LocalizedStrings["UnderbogHComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["ManaTombH"]] = { ev_place=GEM3UI_LocalizedStrings["ManaTombH"], ev_comment=GEM3UI_LocalizedStrings["ManaTombHComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["CryptH"]] = { ev_place=GEM3UI_LocalizedStrings["CryptH"], ev_comment=GEM3UI_LocalizedStrings["CryptHComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["SethekH"]] = { ev_place=GEM3UI_LocalizedStrings["SethekH"], ev_comment=GEM3UI_LocalizedStrings["SethekHComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["SteamvaultH"]] = { ev_place=GEM3UI_LocalizedStrings["SteamvaultH"], ev_comment=GEM3UI_LocalizedStrings["SteamvaultHComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["ShadowLabH"]] = { ev_place=GEM3UI_LocalizedStrings["ShadowLabH"], ev_comment=GEM3UI_LocalizedStrings["ShadowLabHComment"], channel="", min_lvl=65, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["MechenarH"]] = { ev_place=GEM3UI_LocalizedStrings["MechenarH"], ev_comment=GEM3UI_LocalizedStrings["MechenarHComment"], channel="", min_lvl=68, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["BotanicaH"]] = { ev_place=GEM3UI_LocalizedStrings["BotanicaH"], ev_comment=GEM3UI_LocalizedStrings["BotanicaHComment"], channel="", min_lvl=68, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["ArcatrazH"]] = { ev_place=GEM3UI_LocalizedStrings["ArcatrazH"], ev_comment=GEM3UI_LocalizedStrings["ArcatrazHComment"], channel="", min_lvl=68, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["ShatHallH"]] = { ev_place=GEM3UI_LocalizedStrings["ShatHallH"], ev_comment=GEM3UI_LocalizedStrings["ShatHallHComment"], channel="", min_lvl=55, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["CoT1H"]] = { ev_place=GEM3UI_LocalizedStrings["CoT1H"], ev_comment=GEM3UI_LocalizedStrings["CoT1HComment"], channel="", min_lvl=66, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
   [GEM3UI_LocalizedStrings["CoT2H"]] = { ev_place=GEM3UI_LocalizedStrings["CoT2H"], ev_comment=GEM3UI_LocalizedStrings["CoT2HComment"], channel="", min_lvl=66, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_INSTANCE5_BCH},
 },

 
 [GEM3UI_LocalizedStrings["BCEventsRaid"]] = {
   [GEM3UI_LocalizedStrings["Karazhan"]] = { ev_place=GEM3UI_LocalizedStrings["Karazhan"], ev_comment=GEM3UI_LocalizedStrings["KarazhanComment"], channel="", min_lvl=68, max_lvl=GEM3UI_MaxLevel, max_count=10, sortstring="", ev_type=GEM3_EVT_TYPE_RAID_BC, ev_subtype=GEM3_INST_TAG_KARA},
   [GEM3UI_LocalizedStrings["ZA"]] = { ev_place=GEM3UI_LocalizedStrings["ZA"], ev_comment=GEM3UI_LocalizedStrings["ZAComment"], channel="", min_lvl=68, max_lvl=GEM3UI_MaxLevel, max_count=10, sortstring="", ev_type=GEM3_EVT_TYPE_RAID_BC, ev_subtype=GEM3_INST_TAG_ZA},
   [GEM3UI_LocalizedStrings["Gruul"]] = { ev_place=GEM3UI_LocalizedStrings["Gruul"], ev_comment=GEM3UI_LocalizedStrings["GruulComment"], channel="", min_lvl=65, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring="", ev_type=GEM3_EVT_TYPE_RAID_BC, ev_subtype=GEM3_INST_TAG_GRUUL},
   [GEM3UI_LocalizedStrings["Magtheridon"]] = { ev_place=GEM3UI_LocalizedStrings["Magtheridon"], ev_comment=GEM3UI_LocalizedStrings["MagtheridonComment"], channel="", min_lvl=65, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring="", ev_type=GEM3_EVT_TYPE_RAID_BC, ev_subtype=GEM3_INST_TAG_MAGTH},
   [GEM3UI_LocalizedStrings["SSC"]] = { ev_place=GEM3UI_LocalizedStrings["SSC"], ev_comment=GEM3UI_LocalizedStrings["SSCComment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring="", ev_type=GEM3_EVT_TYPE_RAID_BC, ev_subtype=GEM3_INST_TAG_SSC},
   [GEM3UI_LocalizedStrings["TheEye"]] = { ev_place=GEM3UI_LocalizedStrings["TheEye"], ev_comment=GEM3UI_LocalizedStrings["TheEyeComment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring="", ev_type=GEM3_EVT_TYPE_RAID_BC, ev_subtype=GEM3_INST_TAG_EYE},
   [GEM3UI_LocalizedStrings["Hyjal"]] = { ev_place=GEM3UI_LocalizedStrings["Hyjal"], ev_comment=GEM3UI_LocalizedStrings["HyjalComment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring="", ev_type=GEM3_EVT_TYPE_RAID_BC, ev_subtype=GEM3_INST_TAG_HYJAL},
   [GEM3UI_LocalizedStrings["BlackTemple"]] = { ev_place=GEM3UI_LocalizedStrings["BlackTemple"], ev_comment=GEM3UI_LocalizedStrings["BlackTempleComment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring="", ev_type=GEM3_EVT_TYPE_RAID_BC, ev_subtype=GEM3_INST_TAG_BT},
   [GEM3UI_LocalizedStrings["Sunwell"]] = { ev_place=GEM3UI_LocalizedStrings["Sunwell"], ev_comment=GEM3UI_LocalizedStrings["SunwellComment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring="", ev_type=GEM3_EVT_TYPE_RAID_BC, ev_subtype=GEM3_INST_TAG_SWP},
 },
-- [GEM3UI_LocalizedStrings["WOLKEvents"]] = {
--   [GEM3UI_LocalizedStrings["OldStrat"]] = { ev_place=GEM3UI_LocalizedStrings["OldStrat"], ev_comment=GEM3UI_LocalizedStrings["OldStratComment"], channel="", min_lvl=80, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring=""},
--   [GEM3UI_LocalizedStrings["UC"]] = { ev_place=GEM3UI_LocalizedStrings["UC"], ev_comment=GEM3UI_LocalizedStrings["UCComment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring=""},
--   [GEM3UI_LocalizedStrings["UP"]] = { ev_place=GEM3UI_LocalizedStrings["UP"], ev_comment=GEM3UI_LocalizedStrings["UPComment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring=""},
--   [GEM3UI_LocalizedStrings["AN"]] = { ev_place=GEM3UI_LocalizedStrings["AN"], ev_comment=GEM3UI_LocalizedStrings["ANComment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring=""},
--   [GEM3UI_LocalizedStrings["Oculus"]] = { ev_place=GEM3UI_LocalizedStrings["Oculus"], ev_comment=GEM3UI_LocalizedStrings["OculusComment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring=""},
--   [GEM3UI_LocalizedStrings["NexusRaid"]] = { ev_place=GEM3UI_LocalizedStrings["NexusRaid"], ev_comment=GEM3UI_LocalizedStrings["NexusRaidComment"], channel="", min_lvl=80, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring=""},
--   [GEM3UI_LocalizedStrings["Ulduar"]] = { ev_place=GEM3UI_LocalizedStrings["Ulduar"], ev_comment=GEM3UI_LocalizedStrings["UlduarComment"], channel="", min_lvl=80, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring=""},
--   [GEM3UI_LocalizedStrings["IceCrown"]] = { ev_place=GEM3UI_LocalizedStrings["IceCrown"], ev_comment=GEM3UI_LocalizedStrings["IceCrownComment"], channel="", min_lvl=80, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring=""},
--   [GEM3UI_LocalizedStrings["NAXX"]] = { ev_place=GEM3UI_LocalizedStrings["NAXX"], ev_comment=GEM3UI_LocalizedStrings["NAXXComment"], channel="", min_lvl=80, max_lvl=GEM3UI_MaxLevel, max_count=25, sortstring=""},
-- },
 [GEM3UI_LocalizedStrings["PvPEvents"]] = {
   [GEM3UI_LocalizedStrings["Arena2vs2"]] = { ev_place=GEM3UI_LocalizedStrings["Arena2vs2"], ev_comment=GEM3UI_LocalizedStrings["Arena2vs2Comment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=2, sortstring="", ev_type=GEM3_EVT_TYPE_PVP},
   [GEM3UI_LocalizedStrings["Arena3vs3"]] = { ev_place=GEM3UI_LocalizedStrings["Arena3vs3"], ev_comment=GEM3UI_LocalizedStrings["Arena3vs3Comment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=3, sortstring="", ev_type=GEM3_EVT_TYPE_PVP},
   [GEM3UI_LocalizedStrings["Arena5vs5"]] = { ev_place=GEM3UI_LocalizedStrings["Arena5vs5"], ev_comment=GEM3UI_LocalizedStrings["Arena5vs5Comment"], channel="", min_lvl=70, max_lvl=GEM3UI_MaxLevel, max_count=5, sortstring="", ev_type=GEM3_EVT_TYPE_PVP},
   [GEM3UI_LocalizedStrings["PvPRaid"]] = { ev_place=GEM3UI_LocalizedStrings["PvPRaid"], ev_comment=GEM3UI_LocalizedStrings["PvPRaidComment"], channel="", min_lvl=60, max_lvl=GEM3UI_MaxLevel, max_count=40, sortstring="", ev_type=GEM3_EVT_TYPE_PVP},
   [GEM3UI_LocalizedStrings["BGAlterac"]] = { ev_place=GEM3UI_LocalizedStrings["BGAlterac"], ev_comment=GEM3UI_LocalizedStrings["BGAlteracComment"], channel="", min_lvl=51, max_lvl=GEM3UI_MaxLevel, max_count=40, sortstring="", ev_type=GEM3_EVT_TYPE_PVP},
   [GEM3UI_LocalizedStrings["BGArathi"]] = { ev_place=GEM3UI_LocalizedStrings["BGArathi"], ev_comment=GEM3UI_LocalizedStrings["BGArathiComment"], channel="", min_lvl=20, max_lvl=GEM3UI_MaxLevel, max_count=15, sortstring="", ev_type=GEM3_EVT_TYPE_PVP},
   [GEM3UI_LocalizedStrings["BGWarsong"]] = { ev_place=GEM3UI_LocalizedStrings["BGWarsong"], ev_comment=GEM3UI_LocalizedStrings["BGWarsongComment"], channel="", min_lvl=10, max_lvl=GEM3UI_MaxLevel, max_count=10, sortstring="", ev_type=GEM3_EVT_TYPE_PVP},
   [GEM3UI_LocalizedStrings["EoTS"]] = { ev_place=GEM3UI_LocalizedStrings["EoTS"], ev_comment=GEM3UI_LocalizedStrings["EoTSComment"], channel="", min_lvl=61, max_lvl=GEM3UI_MaxLevel, max_count=15, sortstring="", ev_type=GEM3_EVT_TYPE_PVP},
 },
}


TaggedInstances = {
 [GEM3_INST_TAG_NONE]  = {name = "",            icon = ""},
 [GEM3_INST_TAG_ZG]    = {name = "ZG",          icon = "interface\\lfgframe\\LFGIcon-ZulGurub"},
 [GEM3_INST_TAG_MC]    = {name = "MC",          icon = "interface\\lfgframe\\LFGIcon-MoltenCore"},
 [GEM3_INST_TAG_AQ20]  = {name = "AQ20",        icon = "interface\\lfgframe\\LFGIcon-AQRuins"},
 [GEM3_INST_TAG_AQ40]  = {name = "AQ40",        icon = "interface\\lfgframe\\LFGIcon-AQTemple"},
 [GEM3_INST_TAG_NAX]   = {name = "NAX",         icon = "interface\\lfgframe\\LFGIcon-Naxxramas"},
 [GEM3_INST_TAG_BWL]   = {name = "BWL",         icon = "interface\\lfgframe\\LFGIcon-BlackwingLair"},
 [GEM3_INST_TAG_ONY]   = {name = "ONY",         icon = "interface\\icons\\inv_misc_head_dragon_red"},
 [GEM3_INST_TAG_KARA]  = {name = "Karazhan",    icon = "interface\\lfgframe\\LFGIcon-Karazhan"},
 [GEM3_INST_TAG_ZA]    = {name = "ZA",          icon = "interface\\lfgframe\\LFGIcon-ZulAman"},
 [GEM3_INST_TAG_MAGTH] = {name = "Magtheridon", icon = "interface\\lfgframe\\LFGIcon-HellfireCitadelRaid"},
 [GEM3_INST_TAG_GRUUL] = {name = "Gruul",       icon = "interface\\lfgframe\\LFGIcon-GruulsLair"},
 [GEM3_INST_TAG_SSC]   = {name = "SSC",         icon = "interface\\lfgframe\\LFGIcon-SerpentshrineCavern"},
 [GEM3_INST_TAG_EYE]   = {name = "TheEye",      icon = "interface\\lfgframe\\LFGIcon-TempestKeep"},
 [GEM3_INST_TAG_HYJAL] = {name = "Hyjal",       icon = "interface\\lfgframe\\LFGIcon-HyjalPast"},
 [GEM3_INST_TAG_BT]    = {name = "BlackTemple", icon = "interface\\lfgframe\\LFGIcon-BlackTemple"},
 [GEM3_INST_TAG_SWP]   = {name = "Sunwell",     icon = "interface\\lfgframe\\LFGIcon-Sunwell"},
}


--[[
LFGIcon-AQRuins.blp
LFGIcon-AQTemple.blp
LFGIcon-ArathiBasin.blp
LFGIcon-Auchindoun.blp
LFGIcon-Battleground.blp
LFGIcon-BlackfathomDeeps.blp
LFGIcon-BlackrockDepths.blp
LFGIcon-BlackrockSpire.blp
LFGIcon-BlackTemple.blp
LFGIcon-BlackwingLair.blp
LFGIcon-CavernsOfTime.blp
LFGIcon-CoilFang.blp
LFGIcon-Deadmines.blp
LFGIcon-DireMaul.blp
LFGIcon-Dungeon.blp
LFGIcon-EasternKingdoms.blp
LFGIcon-Gnomeregan.blp
LFGIcon-GruulsLair.blp
LFGIcon-HellfireCitadel.blp
LFGIcon-HellfireCitadel5Man.blp
LFGIcon-HellfireCitadelRaid.blp
LFGIcon-HyjalPast.blp
LFGIcon-Kalimdor.blp
LFGIcon-Karazhan.blp
LFGIcon-MagistersTerrace.blp
LFGIcon-Maraudon.blp
LFGIcon-MoltenCore.blp
LFGIcon-Naxxramas.blp
LFGIcon-Outland.blp
LFGIcon-Quest.blp
LFGIcon-RagefireChasm.blp
LFGIcon-Raid.blp
LFGIcon-RazorfenDowns.blp
LFGIcon-RazorfenKraul.blp
LFGIcon-ScarletMonastery.blp
LFGIcon-Scholomance.blp
LFGIcon-SerpentshrineCavern.blp
LFGIcon-ShadowFangKeep.blp
LFGIcon-StormwindStockades.blp
LFGIcon-Stratholme.blp
LFGIcon-SunkenTemple.blp
LFGIcon-Sunwell.blp
LFGIcon-TempestKeep.blp
LFGIcon-Uldaman.blp
LFGIcon-WailingCaverns.blp
LFGIcon-WarsongGulch.blp
LFGIcon-ZulAman.blp
LFGIcon-ZulFarak.blp
LFGIcon-ZulGurub.blp
]]--