﻿--[[
  Guild Event Manager (GEM3) - Version 3
  ----------------------------------------
  GUI Callbacks
]]


function GEM3UIDBGMSG(...)
 local msg, dbg_type = select(1,...);
 local col;
 if type(dbg_type) ~= "table" then
  col = GEM3_DBG_ColorCodes[dbg_type];
 else
  local a,b,c = select(2,...);
  col = {a,b,c}
  dbg_type =0;
 end
 GEM3UIDBGSCRL.msg = msg;
 
 if GEM3UIDebug.debug_flags == nil then GEM3UIDebug.debug_flags = GEM3_DEBUG_ALL_MASK; end
 if GEM3UIDebug.UIFILTER == nil then GEM3UIDebug.UIFILTER = true; end

 
 if col == nil then col = {1,1,1} end

 if #GEM3UI_DEBUGDATA > GEM3UI_MAXDEBUGLINES then
  table.remove(GEM3UI_DEBUGDATA,1);
 end
 if dbg_type ~= nil then 
  table.insert(GEM3UI_DEBUGDATA, {dbgtype = dbg_type, dbgmsg = msg}); 
 else
  table.insert(GEM3UI_DEBUGDATA, {dbgtype = -1, dbgmsg = msg}); 
 end
 GEM3UI_DisplayDebug(msg, dbg_type);
 
 if GEM3UI_DisplayChat  == true then
  DEFAULT_CHAT_FRAME:AddMessage(msg, unpack(col));
  GEM3UI_DisplayChat = false;
 end
 if GEM3UI_DisplayGuild == true then
  SendChatMessage(msg,"GUILD");
  GEM3UI_DisplayGuild = false;
 end
end


function GEM3UI_SET_EVTCHANGE_TBL(event, chng_type)
  mydbg("GEM3UI_SET_EVTCHANGE");
  local newevt = {};
  local ispresent = false;
  local changed = false;
  newevt.id = event.id;
  newevt.ev_type = event.ev_type;
  newevt.changetype = chng_type;
  for i, ctype in ipairs(GEM3UI_newEvents) do
   if ctype.id == event.id then
    ispresent = true;
    if chng_type == GEM3UI_EVENT_CHANGE_DELETE or chng_type == GEM3UI_EVENT_CHANGE_VIEWED then
     table.remove(GEM3UI_newEvents,i);
    else
     ctype.changetype = chng_type;
    end
   end
  end
  if ispresent == false 
     and (chng_type ~= GEM3UI_EVENT_CHANGE_DELETE and chng_type ~= GEM3UI_EVENT_CHANGE_VIEWED)
  then
    if 
     (GEM3UI.NotifyNew  and chng_type == GEM3UI_EVENT_CHANGE_NEW) or
     (GEM3UI.NotifyEdit and chng_type == GEM3UI_EVENT_CHANGE_UPDATE) or
     (GEM3UI.NotifyDateChange and chng_type == GEM3UI_EVENT_CHANGE_DATECHANGE) or
     (GEM3UI.NotifySubs and chng_type == GEM3UI_EVENT_CHANGE_SUBSCHANGE)
    then
      if GEM3UI_LocalizedStrings.EventTypes[event.ev_type].state==true then
       if not (not GEM3UI.NotifyOwn and event.leader == UnitName("player")) then
        ispresent = true;
        table.insert(GEM3UI_newEvents, newevt);
       end
      end
    end
  end
  
  
  if #GEM3UI_newEvents > 0 then
   GEM3MinimapButton.timer = 0;
   GEM3MinimapButton.inc = -0.015;
   GEM3MinimapButton:SetScript("OnUpdate", GEM3UI_MiniMapEventChangesOnUpdate);  
  end
  return ispresent; --- return true if GEM3UI_newEvents hs been altered
end

function GEM3UI_MiniMapEventChangesOnUpdate()
   if not GEM3UIRecoverFrame:IsVisible() then
    GEM3MinimapButton.timer = GEM3MinimapButton.timer + GEM3MinimapButton.inc;
    if GEM3MinimapButton.timer > 1.3 then
       GEM3MinimapButton.inc = -0.05;
       if GEM3UI.NotifySound then
        PlaySound("GLUESCREENLARGEBUTTONMOUSEOVER");
       end
    end
    if GEM3MinimapButton.timer < 0 then
       GEM3MinimapButton.inc = 0.15;
    end
   end
   GEM3MinimapButtonText:SetText(#GEM3UI_newEvents);
   GEM3MinimapButtonTexture:SetTexture("interface\\gossipframe\\availablequesticon");
   GEM3MinimapButton:SetAlpha(GEM3MinimapButton.timer);
   
   if #GEM3UI_newEvents == 0 then
    GEM3MinimapButton:SetScript("OnUpdate", nil);  
    GEM3MinimapButton_Update();
  end
end






--------------- INIT CALLBACKS -------------------

local function _GEM3UI_CB_OnVariablesLoaded(...)
  local first_time_gem,first_time_realm, first_time_char,reset_by_upgrade = select(1,...);
  --GEM3UI_DisplayChat = true;
  GEM3UIDBGMSG("GEM3 OnVariablesLoaded: "..tostring(first_time_gem).." - "..tostring(first_time_realm).." - "..tostring(first_time_char).." - "..tostring(reset_by_upgrade), {0.9, 0.8, 0.10});
  GEM3UI_OnCoreVarsLoaded();
  GEM3UIDBGSCRL.CB="OnVariablesLoaded";
end


--------------- VERSION CALLBACKS -------------------

local function _GEM3UI_CB_OnUpgradeNeeded(...)
 local new_protocol = select(1,...);
 GEM3UIDBGSCRL.CB="_GEM3UI_CB_OnUpgradeNeeded";
 GEM3UI_DisplayChat = true;
 GEM3UIDBGMSG(string.format(GEM3UI_LocalizedStrings["CoreUpgradeNeeded"] ,new_protocol), {0.9, 0.8, 0.10});
 GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_UPGRADENEEDED);
 GEM3UI_NEEDUPDATE = string.format(GEM3UI_LocalizedStrings["CoreUpgradeNeeded"],new_protocol);
end

local function _GEM3UI_CB_OnUpgradeSuggested(...)
GEM3UIDBGSCRL.CB="UpgradeSuggested";
local new_version = select(1,...);
GEM3UI_DisplayChat = true;
  GEM3UIDBGMSG(string.format(GEM3UI_LocalizedStrings["CoreUpgradeSugested"] ,new_version), {0.9, 0.8, 0.10});
end


--------------- DEBUG CALLBACKS -------------------

GEM3_DBG_ColorCodes = {
 [-1] = {1,1,1},
 [0] = {1,1,1},
 [GEM3_DEBUG_GLOBAL] = {1,1,1},
 [GEM3_DEBUG_PROTOCOL] = {0.5,0.5,0},
 [GEM3_DEBUG_CHANNEL] = {0,0,1.0},
 [GEM3_DEBUG_EVENTS] = {0,0.4,0},
 [GEM3_DEBUG_COMMANDS] = {1,0.5,0},
 [GEM3_DEBUG_SUBSCRIBERS] = {1,0,1},
 [GEM3_DEBUG_SORT] = {0,0.6,0.9},
 [GEM3_DEBUG_QUEUES] = {0,0.4,0.5},
 [GEM3_DEBUG_WARNING] = {1,0.1,0.1},
 [GEM3_DEBUG_TIMESTAMP] = {1,0.5,0.7},
 [GEM3_DEBUG_SYNC] = {0.8,0.3,0.2},
};

local function _GEM3UI_CB_OnDebugMode(...)
 local mode = select(1,...);
 local tabobj = getglobal("GEM3UIMainMainPanelTab5");
 local tabobjlbl = getglobal("GEM3UIMainMainPanelTab5Text");
 GEM3UIDBGSCRL.CB="OnDebugmode";
  GEM3UIDBGMSG("GEM3 OnDebugMode: "..mode, {0.9, 0.8, 0.10});
  GEM3UI_DEBUGMODE = mode;
  if mode > 0 then
    GEM3UI_DebugStatusBar:Show();
    tabobj:Show();
    tabobjlbl:Show();
    GEM3UI_GeneraloptionsTabDebug:SetChecked(true) ;
    if mode == 2 then
     GEM3UIDebugDetailsLog:SetChecked(true);
    end
  else
   GEM3UI_DebugStatusBar:Hide();
   tabobj:Hide();
   tabobjlbl:Hide();
   GEM3UI_GeneraloptionsTabDebug:SetChecked(false) ;
  end
  GEM3UI_SetStatusMessage("DEBUG mode is now : "..mode);
  GEM3UI_DebugStatusBarTitelLabel:SetText("DEBUG-"..GEM3_QA_Config.debug_flags..":");
end

local function _GEM3UI_CB_OnDebugMessage(...)
 local dbg_type,msg = select(1,...);
 GEM3UIDBGSCRL.CB="DebugMessage";
 local col = GEM3_DBG_ColorCodes[dbg_type];
 if col == nil then col = {1,1,1} end
-- if dbg_type == nil then mydbg("NOLNOLNOL"); end
 GEM3UIDBGMSG(msg,dbg_type);
end

local function _GEM3UI_CB_OnDebugInfos(...)
 local bcast,cmd_queue_count,evt_que_count = select(1,...);
 GEM3UIDBGSCRL.CB="DebugInfos";
 GEM3UIMainDelayDBGLabel:SetText(string.format("Delay=%d cmdQC=%d evtQC=%d", bcast, cmd_queue_count,evt_que_count));
end


--------------- CHANNELS CALLBACKS -------------------

local function _GEM3UI_CB_OnAddChannel(...)
 local chanstruct = select(1,...);
 GEM3UIDBGSCRL.CB="AddChannel";
 GEM3UI_CFGChannelsOnShow();
end

local function _GEM3UI_CB_OnAddChannelFailed(...)
  local name,message = select(1,...);
  GEM3UIDBGSCRL.CB="AddChannelFailed";
  GEM3UIDBGMSG("GEM3 OnAddChannelFailed: "..name..": "..message, {0.9, 0.8, 0.10});
end

local function _GEM3UI_CB_OnDelChannel(...)
  local channel = select(1,...);
  GEM3UI_DisplayChat = true;
  GEM3UIDBGSCRL.CB="OnDelChannel";
  GEM3UIDBGMSG("GEM3 OnDelChannel: "..channel, {0.9, 0.8, 0.10});
  GEM3UI_CFGChannelsOnShow();
end

local function _GEM3UI_CB_OnUpdateChannel(...)
 local chanstruct = select(1,...);
 GEM3UIDBGSCRL.CB="OnUpdateChannel";
 GEM3UI_CFGChannelsOnShow();
end

local function _GEM3UI_CB_OnUpdateChannelFailed(...)
  local name,message = select(1,...);
  GEM3UIDBGSCRL.CB="OnUpdatechannelFailed";
  if(message == GEM3_ERR_UPDATE_CHANNEL_FAILED_GUILD_CHAN)
  then
    GEM3UIDBGMSG("GEM3 OnUpdateChannelFailed: Nothing to update for special 'Guild' channel", {0.9, 0.8, 0.10});
    return;
  end
  GEM3UIDBGMSG("GEM3 OnUpdateChannelFailed: "..name..": "..message, {0.9, 0.8, 0.10});
end

local function _GEM3UI_CB_OnChannelsConfigLoaded()
 GEM3UIDBGSCRL.CB="OnChannelConfigLoaded";
  GEM3UIDBGMSG("GEM3 OnChannelsConfigLoaded", {0.9, 0.8, 0.10});

end

local function _GEM3UI_CB_OnPlayerJoinedChannel(...)
  local channel,player = select(1,...);
  GEM3UIDBGSCRL.CB="onPlayerJoinedChannel";
  GEM3UI_DisplayChat = false;
  GEM3UIDBGMSG(GEM3UI_LocalizedStrings["GEM3OnPlayerJoinedChannel"]..": "..tostring(channel)..": "..tostring(player), {0.9, 0.8, 0.10});
  if GEM3UIMainMainPanelEventListMain:IsVisible() then
   --GEM3UI_-RefreshAll(GEM3UI_REFRESH_NO_CLOSE_OPEN_EVENTLINE+GEM3UI_REFRESH_NO_CALENDARREFRESH);
  end
  GEM3UI_RefreshView("GEM3UI_REFRESH_LEADERS", player);
end

local function _GEM3UI_CB_OnPlayerLeftChannel(...)
  local channel,player = select(1,...);
  GEM3UIDBGSCRL.CB="OnPlayerLeftChannel";
  GEM3UI_DisplayChat = false;
  GEM3UIDBGMSG(GEM3UI_LocalizedStrings["GEM3OnPlayerLeftChannel"]..": "..tostring(channel)..": "..tostring(player), {0.9, 0.8, 0.10});
  if GEM3UIMembers:IsVisible() then 
   GEM3UI_GetChannelMembers();
   GEM3UI_ChannelMembersScrollUpdate();
  end
  GEM3UI_RefreshView("GEM3UI_REFRESH_LEADERS", player);
end


function _GEM3UI_CB_OnChannelLeft(...)
 local channel = select(1,...);
 GEM3UIDBGSCRL.CB="OnLeftChannel";
 GEM3UIDBGMSG("GEM3 OnLeftChannel: "..tostring(channel), {0.9, 0.8, 0.10}); 
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE");
 --if GEM3UIMainMainPanelEventListMain:IsVisible() then
  --GEM3UI_-RefreshAll(GEM3UI_REFRESH_NO_CLOSE_OPEN_EVENTLINE+GEM3UI_REFRESH_NO_CALENDARREFRESH);
 --end
end

function  _GEM3UI_CB_OnChannelJoined(...)
 local channel = select(1,...);
 GEM3UIDBGSCRL.CB="OnJoinedChannel";
 GEM3UIDBGMSG("GEM3 OnjoinedChannel: "..tostring(channel), {0.9, 0.8, 0.10});
 GEM3_COM_RegisterCustomMessage("GEM3UI_VersionsSend", _GEM3UI_CM_SENDVER);
 GEM3_COM_RegisterCustomMessage("GEM3UI_IhaveOldVersion", GEM3UI_MyVersionIsOld);
 GEM3_COM_RegisterCustomMessage("GEM3UI_UIVersionRequest", GEM3UI_SendMyVersion);
 GEM3_COM_RegisterCustomMessage("GEM3UI_UIVersionReply", GEM3UI_UIVersionReply);
end



--------------- EVENT CALLBACKS -------------------


local function _GEM3UI_CB_OnNewEvent(...)
  local event = select(1,...);
  GEM3UIDBGSCRL.CB="OnNewEvent";
  GEM3UIDBGMSG("GEM3 OnNewEvent: EventID="..event.id, {0.9, 0.8, 0.10});
  GEM3_NewEvents=GEM3_NewEvents+1;
  GEM3MinimapButton_Update();
  GEM3UI_SET_EVTCHANGE_TBL(event, GEM3UI_EVENT_CHANGE_NEW);
  --GEM3UI_-RefreshAll(GEM3UI_EV_STATE_NEW);
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", nil);
end

local function _GEM3UI_CB_OnUpdatedEvent(...)
  local event,isModified,isDateChanged = select(1,...);
  GEM3UIDBGSCRL.CB="OnUpdateEvent";
  GEM3UIDBGMSG("GEM3 OnUpdatedEvent: EventID="..event.id, {0.9, 0.8, 0.10});
  if isDateChanged then
   GEM3UI_SET_EVTCHANGE_TBL(event, GEM3UI_EVENT_CHANGE_DATECHANGE);
   --GEM3UI_-RefreshAll(GEM3UI_EVENT_CHANGE_DATECHANGE);
  elseif isModified then
   GEM3UI_SET_EVTCHANGE_TBL(event, GEM3UI_EVENT_CHANGE_UPDATE);
   --GEM3UI_-RefreshAll(GEM3UI_EV_STATE_UPDATED);
  else
   GEM3UI_SET_EVTCHANGE_TBL(event, GEM3UI_EVENT_CHANGE_SUBSCHANGE);
   --GEM3UI_-RefreshAll(GEM3UI_EVENT_CHANGE_SUBSCHANGE);
  end
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", event.id);
end

local function _GEM3UI_CB_OnClosedEvent(...)
  local event, reason = select(1,...);
  GEM3UIDBGSCRL.CB="OnCloseEvent";
  GEM3UIDBGMSG("GEM3 OnClosedEvent: EventID="..event.id.." Reason="..reason, {0.9, 0.8, 0.10});
  GEM3UI_SET_EVTCHANGE_TBL(event, GEM3UI_EVENT_CHANGE_CLOSE);
  --GEM3UI_--RefreshAll(GEM3UI_EV_STATE_CLOSED);
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", event.id);
end

local function _GEM3UI_CB_OnDeletedEvent(...)
  local event = select(1,...);
  GEM3UIDBGSCRL.CB="OnDeleteEvent";
  GEM3UIDBGMSG("GEM3 OnDeletedEvent: EventID="..event.id, {0.9, 0.8, 0.10});
  --local expline = getglobal("GEM3UI_lineFrame"..GEM3UI_expandedLine);
  --if expline ~= nil then
   --mydbg(MyEvent[expline.ev_index].id.." : "..event.id);
   --if MyEvent[expline.ev_index].id == event.id then
    --GEM3UI_ExpandEventLine(expline, true);
   --end
  --end
  if GEM3UI.ArchiveBeforeDelete then
   GEM3_EVT_ArchiveEvent(event.id);
  end
  GEM3UI_SET_EVTCHANGE_TBL(event, GEM3UI_EVENT_CHANGE_DELETE);
  --GEM3UI_--RefreshAll(GEM3UI_EV_STATE_DELETED);
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", "CLOSE", "SELF", event);
end


local function _GEM3UI_CB_OnNewEventLost(...)
  local event = select(1,...);
  GEM3UI_DisplayChat = true;
  GEM3UIDBGSCRL.CB="OnNewEventLost";
  GEM3UIDBGMSG("GEM3 OnNewEventLost: EventID="..event.id, {0.9, 0.8, 0.10});
end

local function _GEM3UI_CB_OnEventCreated(...)
  local event = select(1,...);
  GEM3UIDBGSCRL.CB="OnEventCreated";
  GEM3UIDBGMSG("GEM3 OnEventCreated: EventID="..event.id, {0.9, 0.8, 0.10});
  if GEM3UIAutoSubscribe:GetChecked() then
   local player = GEM3_PLAY_GetPlayerInfos(UnitName("player"));
   local subs, reason  = GEM3_SUB_Subscribe(
                    event.id,
                    UnitName("player"),
                    player.guild,
                    player.level,
                    player.class,
                    GEM3_QA_Config.role,
                    "",
                    GEM3_SUB_FORCE_QUEUE_NONE,
                    GEM3_ROLE_UNKNOWN);
   if subs then
    PlaySound("PVPENTERQUEUE");
   else
    PlaySound("igQuestFailed");
   end                    
   GEM3UI_SetStatusMessage(reason);
   mydbg(reason);
  end
end

local function _GEM3UI_CB_OnUpdatedEventLost(...)
 local event = select(1,...);
 GEM3UI_DisplayChat = true;
 GEM3UIDBGSCRL.CB="OnUpdateEventLost";
 GEM3UIDBGMSG("GEM3 OnUpdatedEventLost: EventID="..event.id, {0.9, 0.8, 0.10});
end

local function _GEM3UI_CB_OnCrashedEvent(...)
  local event = select(1,...);
  GEM3UIDBGSCRL.CB="OnEventCrashed";
  GEM3UIDBGMSG("GEM3 OnCrashedEvent: EventID="..event.id.." Place="..event.ev_place.." Date="..date("%c",event.ev_date).." LastUpdated="..date("%c",event.update_time), {0.9, 0.8, 0.10});
  GEM3UI_RecoverEventDialog(event);
end

local function _GEM3UI_CB_OnUpdatedRecoveredEvent(...)
 local new_event,previous_event = select(1,...);
 GEM3UI_DisplayChat = true;
 GEM3UIDBGSCRL.CB="OnUpdaterecoveredEvent";
 GEM3UIDBGMSG("GEM3 OnUpdatedRecoveredEvent: EventID="..new_event.id.." Place="..new_event.ev_place.." Date="..date("%c",new_event.ev_date).." LastUpdated="..date("%c",new_event.update_time), {0.9, 0.8, 0.10});
end


function _GEM3UI_CB_OnEventAssistant(...)
 local ev_id,pl_name = select(1,...);
 GEM3UI_DisplayChat = true;
 GEM3UIDBGSCRL.CB="OnEventAssistant";
 GEM3UIDBGMSG("GEM3 OnEventAssistant: EventID="..ev_id.." Player="..pl_name, {0.9, 0.8, 0.70});
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_ADD_OR_REMOVE", nil);
end

function _GEM3UI_CB_OnSortingInconsistency(...)
 local event = select(1,...);
 GEM3UI_DisplayChat = true;
 GEM3UIDBGSCRL.CB="OnSortingInconsistency";
 GEM3UIDBGMSG("GEM3 OnSortingInconsistency: EventID="..event.id, {0.9, 0.8, 0.70});
end


--------------- SUBSCRIPTION CALLBACKS -------------------

local function _GEM3UI_CB_OnSubscribed(...) -- State = one of GEM3_SUB_STATE_xx
 local ev_id,pl_name,state = select(1,...);
 GEM3UIDBGSCRL.CB="OnSubscribed";
 GEM3UIDBGMSG("GEM3 OnSubscribed: I've subscribed to EventID="..ev_id.." with character "..pl_name.." in queue "..tostring(state), {0.9, 0.8, 0.10});
 --GEM3UI_-RefreshAll(GEM3UI_EV_STATE_SUBS)
 GEM3UI_CheckSubsEdit()
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
  
end

local function _GEM3UI_CB_OnUnSubscribed(...)
  local ev_id,pl_name,comment = select(1,...);
  GEM3UIDBGSCRL.CB="OnUnSubscribed";
  GEM3UIDBGMSG("GEM3 OnUnSubscribed: Player "..pl_name.." unsubscribed from EventID="..ev_id.." with comment '"..tostring(comment).."'", {0.9, 0.8, 0.10});
  --GEM3UI_-RefreshAll(GEM3UI_EV_STATE_SUBS);
  GEM3UI_CheckSubsEdit()
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
end

local function _GEM3UI_CB_OnSubscriptionChanged(...) -- State = one of GEM3_SUB_STATE_xx
  local ev_id,pl_name,state = select(1,...);
  GEM3UIDBGSCRL.CB="OnSubscriptionchanged";
  GEM3UIDBGMSG("GEM3 OnSubscriptionChanged: My subscription changed for EventID="..ev_id.." with character "..pl_name..". I'm now in queue "..state, {0.9, 0.8, 0.10});
  --GEM3UI_-RefreshAll(GEM3UI_EV_STATE_SUBS);
  GEM3UI_CheckSubsEdit()
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
end



local function _GEM3UI_CB_OnSubscriptionLost(...)
  local ev_id,pl_name = select(1,...);
  GEM3UI_DisplayChat = true;
  GEM3UIDBGSCRL.CB="OnsubscriptionLost";
  GEM3UIDBGMSG("GEM3 OnSubscriptionLost: Leader of EventID="..ev_id.." lost my subscription with character "..pl_name, {0.9, 0.8, 0.10});
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
end

local function _GEM3UI_CB_OnSubscriptionFailed(...)
  local ev_id,pl_name,code = select(1,...);
  GEM3UI_DisplayChat = true;
  GEM3UIDBGSCRL.CB="OnsubscriptionFailed";
  GEM3UIDBGMSG("GEM3 OnSubscriptionFailed: EventID="..ev_id.." subscription failed with '"..pl_name.."': "..code, {0.9, 0.8, 0.10});
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
end


--------------- PLAYER CALLBACKS -------------------

local function _GEM3UI_CB_OnPlayerInfosUpdate(...)
  local channel,infos = select(1,...);
  GEM3UIDBGSCRL.CB="OnPlayerInfoUpdate";
  if(channel == GEM3_GuildChannelName) -- Special guild channel
  then
    --GEM3UIDBGMSG("GEM3 OnPlayerInfosUpdate: Channel="..channel.." Player="..infos.name.." isChanLeader="..tostring(infos.isLeader), {0.9, 0.8, 0.10});
  else
    --GEM3UIDBGMSG("GEM3 OnPlayerInfosUpdate: Channel="..channel.." Player="..infos.name, {0.9, 0.8, 0.10});
  end
  if infos.name == UnitName("player") then return; end
  GEM3UI_GetChannelMembers();
  if GEM3UIMembers:IsVisible() then 
   GEM3UI_GetChannelMembers();
   GEM3UI_ChannelMembersScrollUpdate();
  end
  GEM3_COM_SendCustomMessage(channel,"GEM3UI_VersionsSend", GEM3UI_MAJOR,GEM3UI_MINOR,GEM3UI_REVISION, GEM3UI_HIGHEST_MAJOR, GEM3UI_HIGHEST_MINOR, GEM3UI_HIGHEST_REV)
end


function _GEM3UI_CB_OnTimeRefConflict(...)
  local channel,from,offset = select(1,...);
  GEM3UIDBGSCRL.CB="OnTimeRefConflict";
  GEM3UIDBGMSG("GEM3 OnTimeRefConflict: Channel="..channel.." Player="..from.." offset="..tostring(offset), {0.9, 0.8, 0.10});
  GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_SETTIMEREFCONFLICT);
  GEM3UIOptionsDTF_TimeReference:SetChecked(false);
  GEM3_STAMP_SetTimeRef(false);
end

function GEM3UI_OffsetToString(offset)
 if offset < 0 then t = "-"; end
 offset = math.abs(offset);
 offset = date("*t", offset);
 if offset.year > 0 then t= t .." ".. offset.year .. " Year(s)"; end
 if offset.month > 0 then t= t .." ".. offset.month .. " Month(s)"; end
 if offset.day > 0 then t= t .." ".. offset.day .. " Day(s)"; end
 if offset.hour > 0 then t= t .." ".. offset.hour .. " Hour(s)"; end
 if offset.min > 0 then t= t .." ".. offset.min .. " Minute(s)"; end
 if offset.sec > 0 then t= t .." ".. offset.sec .. " Second(s)"; end
 return t
end

function _GEM3UI_CB_OnIncorrectTimeSettings(...)
  local channel,from,offset = select(1,...);
  GEM3UIDBGSCRL.CB="OnIncorrectTimeSettings";
  GEM3UIDBGMSG("GEM3 OnIncorretTimeSettings: Channel="..channel.." Player="..from.." offset="..GEM3UI_OffsetToString(offset), {0.9, 0.8, 0.10});
  GEM3UI_Popup(GEM3UI_DIALOG_CONFIRM_NOOBTIMEREFCONFLICT);
end

function _GEM3UI_CB_OnUserWithIncorrectTimeSettings(...)
 local channel,pl_name,offset = select(1,...);
 GEM3UIDBGSCRL.CB="OnUserWithIncorrectTimeSettings";
 
 GEM3UIDBGMSG("GEM3 OnIncorretTimeSettings: Channel="..channel.." Player="..pl_name.." offset="..GEM3UI_OffsetToString(offset), {0.9, 0.8, 0.10});
 DEFAULT_CHAT_FRAME:AddMessage("GEM3 OnIncorretTimeSettings: Channel="..channel.." Player="..pl_name.." offset="..GEM3UI_OffsetToString(offset), {0.9, 0.8, 0.10});
end

function _GEM3UI_CB_OnKickedFromEvent(...)
 local ev_id,pl_name,from, reason = select(1,...);
 GEM3UI_DisplayChat = true;
 GEM3UIDBGMSG("GEM3 OnKickedFromEvent: Player="..pl_name.." was kicked from event "..ev_id.." by "..from.." because "..reason, {0.9, 0.8, 0.10});
 if GEM3UI.NotifyKickBan then
  message(string.format(GEM3UI_LocalizedStrings["_KickBanNotify"], from, GEM3_QA_Events.events[ev_id].ev_place,reason));
 end
 --GEM3UI_-RefreshAll();
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
end

function _GEM3UI_CB_OnBannedFromEvent(...)
 local ev_id,pl_name,from, reason = select(1,...);
 GEM3UI_DisplayChat = true;
 GEM3UIDBGMSG("GEM3 OnBannedFromEvent: Player="..pl_name.." was banned from event "..ev_id.." by "..from.." because "..reason, {0.9, 0.8, 0.10});
 if GEM3UI.NotifyKickBan then
  message(string.format(GEM3UI_LocalizedStrings["_KickBanNotify"], from, GEM3_QA_Events.events[ev_id].ev_place,reason));
 end
 --GEM3UI_-RefreshAll();
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
end

function _GEM3UI_CB_OnUnBannedFromEvent(...)
 local ev_id,pl_name,from = select(1,...);
 GEM3UI_DisplayChat = true;
 GEM3UIDBGMSG("GEM3 OnUnBannedFromEvent: Player="..pl_name.." was UnBanned from event "..ev_id.." by "..from, {0.9, 0.8, 0.10});
 if GEM3UI.NotifyKickBan then
  message(string.format(GEM3UI_LocalizedStrings["_UnBanNotify"], GEM3_QA_Events.events[ev_id].ev_place,from));
 end
 --GEM3UI_-RefreshAll();
 GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev_id);
end


--- REGISTER CALLBACK
-- init
GEM3_RegisterCallback("OnVariablesLoaded", _GEM3UI_CB_OnVariablesLoaded);
-- Version
GEM3_RegisterCallback("OnUpgradeNeeded", _GEM3UI_CB_OnUpgradeNeeded);
GEM3_RegisterCallback("OnUpgradeSuggested",_GEM3UI_CB_OnUpgradeSuggested);
-- Debug
GEM3_RegisterCallback("OnDebugMode",_GEM3UI_CB_OnDebugMode);
GEM3_RegisterCallback("OnDebugMessage",_GEM3UI_CB_OnDebugMessage);
GEM3_RegisterCallback("OnDebugInfos",_GEM3UI_CB_OnDebugInfos);
-- Channels
GEM3_RegisterCallback("OnAddChannel",_GEM3UI_CB_OnAddChannel);
GEM3_RegisterCallback("OnAddChannelFailed",_GEM3UI_CB_OnAddChannelFailed);
GEM3_RegisterCallback("OnDelChannel",_GEM3UI_CB_OnDelChannel);
GEM3_RegisterCallback("OnUpdateChannel",_GEM3UI_CB_OnUpdateChannel);
GEM3_RegisterCallback("OnUpdateChannelFailed",_GEM3UI_CB_OnUpdateChannelFailed);
GEM3_RegisterCallback("OnChannelsConfigLoaded",_GEM3UI_CB_OnChannelsConfigLoaded);
GEM3_RegisterCallback("OnPlayerJoinedChannel",_GEM3UI_CB_OnPlayerJoinedChannel);
GEM3_RegisterCallback("OnPlayerLeftChannel",_GEM3UI_CB_OnPlayerLeftChannel);

GEM3_RegisterCallback("OnChannelLeft",_GEM3UI_CB_OnChannelLeft);
GEM3_RegisterCallback("OnChannelJoined",_GEM3UI_CB_OnChannelJoined);

-- Events
GEM3_RegisterCallback("OnNewEvent",_GEM3UI_CB_OnNewEvent);
GEM3_RegisterCallback("OnNewEventLost",_GEM3UI_CB_OnNewEventLost);
GEM3_RegisterCallback("OnEventCreated",_GEM3UI_CB_OnEventCreated);
GEM3_RegisterCallback("OnUpdatedEvent",_GEM3UI_CB_OnUpdatedEvent);
GEM3_RegisterCallback("OnUpdatedEventLost",_GEM3UI_CB_OnUpdatedEventLost);
GEM3_RegisterCallback("OnClosedEvent",_GEM3UI_CB_OnClosedEvent);
GEM3_RegisterCallback("OnDeletedEvent",_GEM3UI_CB_OnDeletedEvent);
GEM3_RegisterCallback("OnCrashedEvent",_GEM3UI_CB_OnCrashedEvent);
GEM3_RegisterCallback("OnUpdatedRecoveredEvent",_GEM3UI_CB_OnUpdatedRecoveredEvent);
GEM3_RegisterCallback("OnEventAssistant",_GEM3UI_CB_OnEventAssistant);
GEM3_RegisterCallback("OnSortingInconsistency",_GEM3UI_CB_OnSortingInconsistency);
-- Subscription
GEM3_RegisterCallback("OnSubscribed",_GEM3UI_CB_OnSubscribed);
GEM3_RegisterCallback("OnUnSubscribed",_GEM3UI_CB_OnUnSubscribed);
GEM3_RegisterCallback("OnSubscriptionChanged",_GEM3UI_CB_OnSubscriptionChanged);
GEM3_RegisterCallback("OnSubscriptionLost",_GEM3UI_CB_OnSubscriptionLost);
GEM3_RegisterCallback("OnSubscriptionFailed",_GEM3UI_CB_OnSubscriptionFailed);
-- Players
GEM3_RegisterCallback("OnPlayerInfosUpdate",_GEM3UI_CB_OnPlayerInfosUpdate);
GEM3_RegisterCallback("OnTimeRefConflict",_GEM3UI_CB_OnTimeRefConflict);
GEM3_RegisterCallback("OnIncorrectTimeSettings",_GEM3UI_CB_OnIncorrectTimeSettings);
GEM3_RegisterCallback("OnUserWithIncorrectTimeSettings",_GEM3UI_CB_OnUserWithIncorrectTimeSettings);
GEM3_RegisterCallback("OnKickedFromEvent",_GEM3UI_CB_OnKickedFromEvent);
GEM3_RegisterCallback("OnBannedFromEvent",_GEM3UI_CB_OnBannedFromEvent);
GEM3_RegisterCallback("OnUnBannedFromEvent",_GEM3UI_CB_OnUnBannedFromEvent);
