﻿function GEM3UI_NextMonth()
 local month = 0;
 local year = 0;
 local parent = this:GetParent();
 if parent.amonth.month == 12 then
  month=1;
  year=parent.amonth.year+1;
 else
  month=parent.amonth.month+1;
  year=parent.amonth.year;
 end
 parent.amonth = date ("*t", time({["year"] = year, ["month"] = month, ["day"] = 1, }));
 
 
 parent.amonth = MovixLibMonthDaycount(parent.amonth);
 parent.amonth = MovixLibSetWday(parent.amonth);
 MovixLibCreateCalendar(this:GetParent(), parent.amonth.month, parent.amonth.year);
 GEM3UI_HilightDayLeave(1);
GEM3UI_CalHighlightSubstDays(); 
end

function GEM3UI_PrevMonth()
 local month = 0;
 local year = 0;
 local parent = this:GetParent();
 if parent.amonth.month == 1 then
  month=12;
  year=parent.amonth.year-1;
 else
  month=parent.amonth.month-1;
  year=parent.amonth.year;
 end
 parent.amonth = date ("*t", time({["year"] = year, ["month"] = month, ["day"] = 1, }));
 parent.amonth = MovixLibMonthDaycount(parent.amonth);
 parent.amonth = MovixLibSetWday(parent.amonth);
 MovixLibCreateCalendar(this:GetParent(), parent.amonth.month, parent.amonth.year);
 GEM3UI_HilightDayLeave(1);
 GEM3UI_CalHighlightSubstDays();
end

function MovixLibSetWday(m)
if GEM3UI_FirstWeekday == 1 then 
  if m.wday == 1 then
   m.wday = 8;
  end
 end
 m.wday = m.wday - GEM3UI_FirstWeekday - 1;
 return m;
end


function MovixLibMonthDaycount(m)
 m.monthdaycount = GEM3UI_monthdays[m.month];
 if m.month == 2 then
  if ((m.year%4 == 0 and m.year%100 ~= 0) or m.year%400 == 0) then
    m.monthdaycount = GEM3UI_monthdays[m.month]+1;
  end
 end
 return m;
end


function MovixLibCalendarDayHasEvent(i, parent)
 local calday = getglobal(parent:GetName().."GEM3UI_Calfield"..i);
 local caldayoutset = getglobal (parent:GetName().."GEM3UI_Calfield"..i.."Outset");
 local caldayinset = getglobal (parent:GetName().."GEM3UI_Calfield"..i.."Inset");
 local caldaytext = getglobal (parent:GetName().."GEM3UI_Calfield"..i.."Text");
 caldayoutset:SetTexture(GEM3UI_calcol[GEM3UI_COLOR_CAL_WITHEVENT].r,GEM3UI_calcol[GEM3UI_COLOR_CAL_WITHEVENT].g,GEM3UI_calcol[GEM3UI_COLOR_CAL_WITHEVENT].b,GEM3UI_calcol[GEM3UI_COLOR_CAL_WITHEVENT].a);
 caldayinset:SetTexture(GEM3UI_daycol[GEM3UI_COLOR_CAL_WITHEVENT].r,GEM3UI_daycol[GEM3UI_COLOR_CAL_WITHEVENT].g,GEM3UI_daycol[GEM3UI_COLOR_CAL_WITHEVENT].b,GEM3UI_daycol[GEM3UI_COLOR_CAL_WITHEVENT].a);
 caldaytext:SetTextColor(GEM3UI_caltext[GEM3UI_COLOR_CAL_WITHEVENT].r,GEM3UI_caltext[GEM3UI_COLOR_CAL_WITHEVENT].g,GEM3UI_caltext[GEM3UI_COLOR_CAL_WITHEVENT].b,GEM3UI_caltext[GEM3UI_COLOR_CAL_WITHEVENT].a);
 local fn;
 local fs;
 local ff;
 fn, fs, ff = caldaytext:GetFont();
 caldaytext:SetFont(fn,12,ff);
end

function MovixLibCreateCalendarDay(i, parent, anchor, x, y, color, content)
 local calday = getglobal(parent:GetName().."GEM3UI_Calfield"..i);
 local caldayinset;
 local caldaytext;
 if calday == nil then 
  calday = CreateFrame("FRAME", parent:GetName().."GEM3UI_Calfield"..i, parent, "CaldayTemplate");
  calday:SetPoint("TOPLEFT", anchor, "TOPLEFT", x, y);
  calday:SetWidth(20);
  calday:SetHeight(20);
  calday:SetBackdrop({   bgFile = ""});
  calday.id=i;
  caldayoutset = calday:CreateTexture(parent:GetName().."GEM3UI_Calfield"..i.."Outset");
  caldayoutset:SetPoint("TOPLEFT", calday, "TOPLEFT", 0, 0);
  caldayoutset:SetPoint("BOTTOMRIGHT", calday, "BOTTOMRIGHT", 0, 0);
  caldayoutset:SetDrawLayer("BACKGROUND");
  caldayinset = calday:CreateTexture(parent:GetName().."GEM3UI_Calfield"..i.."Inset");
  caldayinset:SetPoint("TOPLEFT", calday, "TOPLEFT", 1, -1);
  caldayinset:SetPoint("BOTTOMRIGHT", calday, "BOTTOMRIGHT", -1, 1);
  caldayinset:SetDrawLayer("ARTWORK");
  caldaytext = calday:CreateFontString(parent:GetName().."GEM3UI_Calfield"..i.."Text", "ARTWORK", "GameFontNormal");
  caldaytext:SetPoint("TOPLEFT", calday, "TOPLEFT", 0, 0);
  caldaytext:SetPoint("BOTTOMRIGHT", calday, "BOTTOMRIGHT", -1, 0);
 end
 
 caldayoutset = getglobal (parent:GetName().."GEM3UI_Calfield"..i.."Outset");
 caldayinset = getglobal (parent:GetName().."GEM3UI_Calfield"..i.."Inset");
 caldaytext = getglobal (parent:GetName().."GEM3UI_Calfield"..i.."Text");
 
 caldayoutset:SetTexture(GEM3UI_calcol[color].r,GEM3UI_calcol[color].g,GEM3UI_calcol[color].b,GEM3UI_calcol[color].a);
 caldayinset:SetTexture(GEM3UI_daycol[color].r,GEM3UI_daycol[color].g,GEM3UI_daycol[color].b,GEM3UI_daycol[color].a);
 caldaytext:SetTextColor(GEM3UI_caltext[color].r,GEM3UI_caltext[color].g,GEM3UI_caltext[color].b,GEM3UI_caltext[color].a);
 caldaytext:SetText(content);
 local fn;
 local fs;
 local ff;
 fn, fs, ff = caldaytext:GetFont();
 if color < GEM3UI_COLOR_CAL_DAYLASTNEXTMONTH then
  caldaytext:SetFont(fn,9,ff);
 elseif color == GEM3UI_COLOR_CAL_NORMAL then
  caldaytext:SetFont(fn,10,ff);
 else
  caldaytext:SetFont(fn,11,ff);
 end
 return calday;
end

function GEM3UI_HilightDayLeave(state)
   local caldayhl;
   local parent = this:GetParent();
   local prefix = parent:GetName();
   GEM3UI_HighlightEventList(nil, false);
   if state == nil then 
     caldayhl = getglobal(prefix.."caldayhl");
   else
     caldayhl = getglobal(prefix.."caldaySel");
   end
   if caldayhl ~= nil then 
    caldayhl:Hide();
   end
   GEM3UIDay.d = parent.SELDAY;
   GEM3UI_DisplayDaydetails();
   GEM3UIDay:Hide();
   GEM3UI_IsEventExpanded();
end

function GEM3UI_DayClick()
 local mparent = this:GetParent();
 local dayid = string.sub(this:GetName(),string.len(mparent:GetName())+16);
 local lid = math.floor(dayid/8);
 local day = dayid%8;
 local mdayid = dayid - (lid + 8 + mparent.amonth.wday)+1;
 if mdayid > 0 and mdayid <= mparent.amonth.monthdaycount and day > 0 then
   MovixLibCalDayRect(this, "caldaySel", GEM3UI_COLOR_CAL_SELECTEDDAY);
   mparent.SELDAY = date ("*t", time({["year"] = mparent.amonth.year, ["month"] = mparent.amonth.month, ["day"] = mdayid, }));
 end
end




function GEM3UI_HilightDay(day, parent)
 if day ~= nil then
  local i = MovixLibCalGetFieldID(day);
  local mparent = getglobal(parent:GetName().."GEM3UI_Calfield"..i);
  GEM3UIDay.d = day;
  MovixLibCalDayRect(mparent, "caldaySel", GEM3UI_COLOR_CAL_SELECTEDDAY);
  GEM3UIDay:Show();
  GEM3UI_DisplayDaydetails();
 else
  local dayid = string.sub(this:GetName(),string.len(parent:GetName())+16);
  dayid = dayid *1;
  local day = dayid%8;
  local lid = math.floor(dayid/8);
  local mdayid = dayid - (lid + 8 + parent.amonth.wday)+1;
  if mdayid > 0 and mdayid <= parent.amonth.monthdaycount and day > 0 then
   parent.amonth.day=mdayid;
   GEM3UIDay.d = date ("*t", time({["year"] = parent.amonth.year, ["month"] = parent.amonth.month, ["day"] = mdayid, }));
   local d = time({["year"] = parent.amonth.year, ["month"] = parent.amonth.month, ["day"] = mdayid, ["hour"]=0, ["min"]=0, ["sec"]=0});
   GEM3UI_HighlightEventList(d, true);
   GEM3UIDay:Show();
   GEM3UI_DisplayDaydetails();
  end
  if mdayid > 0 and mdayid <= parent.amonth.monthdaycount and day > 0 then
   local mparent = getglobal(parent:GetName().."GEM3UI_Calfield"..dayid);
   MovixLibCalDayRect(mparent, "caldayhl", GEM3UI_COLOR_CAL_MOUSEOVER);
  end
 end
end

function GEM3UI_ChangeDaySetColor(parent, day, color)
  if parent.amonth.month ~= day.month then return; end
  if parent.amonth.year ~= day.year then return; end
  local i = MovixLibCalGetFieldID(day);
  local caldayoutset = getglobal (parent:GetName().."GEM3UI_Calfield"..i.."Outset");
  local caldayinset = getglobal (parent:GetName().."GEM3UI_Calfield"..i.."Inset");
  local caldaytext = getglobal (parent:GetName().."GEM3UI_Calfield"..i.."Text");
  caldayoutset:SetTexture(GEM3UI_calcol[color].r,GEM3UI_calcol[color].g,GEM3UI_calcol[color].b,GEM3UI_calcol[color].a);
  caldayinset:SetTexture(GEM3UI_daycol[color].r,GEM3UI_daycol[color].g,GEM3UI_daycol[color].b,GEM3UI_daycol[color].a);
  caldaytext:SetTextColor(GEM3UI_caltext[color].r,GEM3UI_caltext[color].g,GEM3UI_caltext[color].b,GEM3UI_caltext[color].a);
end


function MovixLibCalGetFieldID(d)
  local dday = date ("*t", time({["year"] = d.year, ["month"] = d.month, ["day"] = 1, }));
  dday = MovixLibSetWday(dday);
  local i = 8 + dday.wday + d.day + (math.floor((d.day+dday.wday-1)/7));
  return i;
end

function MovixLibCalDayRect(parent, frmName, c)
   local caldayhl;
   local prefix = parent:GetParent():GetName();
   caldayhl = getglobal(prefix..frmName);
   if caldayhl == nil then 
    caldayhl = CreateFrame("FRAME", prefix..frmName, parent);
    caldayhlt = caldayhl:CreateTexture("$parentGEM3UI_Calfieldhlt");
    caldayhll = caldayhl:CreateTexture("$parentGEM3UI_Calfieldhll");
    caldayhlr = caldayhl:CreateTexture("$parentGEM3UI_Calfieldhlr");
    caldayhlb = caldayhl:CreateTexture("$parentGEM3UI_Calfieldhlb");
   else
    caldayhlt = getglobal(prefix..frmName.."GEM3UI_Calfieldhlt");
    caldayhll = getglobal(prefix..frmName.."GEM3UI_Calfieldhll");
    caldayhlr = getglobal(prefix..frmName.."GEM3UI_Calfieldhlr");
    caldayhlb = getglobal(prefix..frmName.."GEM3UI_Calfieldhlb");
   end

   caldayhl:Show();

   caldayhlt:SetTexture(GEM3UI_calcol[c].r,GEM3UI_calcol[c].g,GEM3UI_calcol[c].b,GEM3UI_calcol[c].a);
   caldayhll:SetTexture(GEM3UI_calcol[c].r,GEM3UI_calcol[c].g,GEM3UI_calcol[c].b,GEM3UI_calcol[c].a);
   caldayhlr:SetTexture(GEM3UI_calcol[c].r,GEM3UI_calcol[c].g,GEM3UI_calcol[c].b,GEM3UI_calcol[c].a);
   caldayhlb:SetTexture(GEM3UI_calcol[c].r,GEM3UI_calcol[c].g,GEM3UI_calcol[c].b,GEM3UI_calcol[c].a);

   caldayhl:SetParent(parent);
   caldayhl:SetFrameLevel(255);
   caldayhl:SetFrameStrata("DIALOG");
   caldayhl:SetPoint("TOPLEFT", parent, "TOPLEFT", 0, 0);
   caldayhl:SetPoint("BOTTOMRIGHT", parent, "BOTTOMRIGHT", 0, 0);
 
   caldayhlt:SetPoint("TOPLEFT", caldayhl, "TOPLEFT", 0, 0);
   caldayhlt:SetPoint("BOTTOMRIGHT", caldayhl, "TOPRIGHT", 0, -1);
 
   caldayhll:SetPoint("TOPLEFT", caldayhl, "TOPLEFT", 0, 0);
   caldayhll:SetPoint("BOTTOMRIGHT", caldayhl, "BOTTOMLEFT", 1, 0);
 
   caldayhlr:SetPoint("TOPLEFT", caldayhl, "TOPRIGHT", -1, 0);
   caldayhlr:SetPoint("BOTTOMRIGHT", caldayhl, "BOTTOMRIGHT", 0, 0);
 
   caldayhlb:SetPoint("TOPLEFT", caldayhl, "BOTTOMLEFT", 0, 1);
   caldayhlb:SetPoint("BOTTOMRIGHT", caldayhl, "BOTTOMRIGHT", 0, 0);
end


function MovixLibCreateCalendar(parent, m, y, fooOnClick, fooOnOver, fooOnOut)
 if GEM3UI.FirstWeekday == false then GEM3UI_FirstWeekday = 0; else GEM3UI_FirstWeekday = 1; end
 local actmonth = date ("*t", time({["year"] = y, ["month"] = m, ["day"] = 1, }));
 --if m == 12 then nm = 1; ny = y+1; else nm = m; ny = y; end
 --local nextmonth = date ("*t", time({["year"] = ny, ["month"] = nm, ["day"] = 1, }));
 --if m == 1 then pm = 12; py = y-1; else pm = m; py = y; end
 --local prevmonth = date ("*t", time({["year"] = py, ["month"] = pm, ["day"] = 1, }));
 --prevmonth = MovixLibMonthDaycount(prevmonth);
 --nextmonth = MovixLibMonthDaycount(nextmonth);
 actmonth = MovixLibMonthDaycount(actmonth);
 actmonth = MovixLibSetWday(actmonth);
 local calgrid = {};
 local actline = 0;
 local actcol = 0;
 local actday = 0;
  for i = 0, 55 do
  actline = math.floor(i/8);
  actcol = i%8;
  actday = i - (actline + 8 + actmonth.wday)+1;
  if i == 0 then -- premiere case toujours vide
    calgrid[i] = MovixLibCreateCalendarDay(i, parent, parent, 5 , -25, GEM3UI_COLOR_CAL_TOPLEFTFIELD, "");
  elseif actline == 0 then -- ligne des noms de jours
    calgrid[i] = MovixLibCreateCalendarDay(i, parent, calgrid[i-1], 20 , 0, GEM3UI_COLOR_CAL_DAYHEADER, GEM3UI_LocalizedStrings.day1letter[actcol+GEM3UI_FirstWeekday-1]);
  elseif (i%8) == 0 then -- colonne des semaines
    weeknum = date ("%U", time({["year"] = actmonth.year, ["month"] = actmonth.month, ["day"] = actday, }))+1;
    if weeknum > 52 then weeknum = 1; end
    calgrid[i] = MovixLibCreateCalendarDay(i, parent, calgrid[i-8], 0 , -20, GEM3UI_COLOR_CAL_WEEKNUMHEADER, weeknum);
  elseif actday <= 0 then -- derniers jours du mois précédent
    --calgrid[i] = MovixLibCreateCalendarDay(i, GEM3UICalendar, calgrid[i-1], 20 , 0, 1, prevmonth.monthdaycount+actday-1);
    calgrid[i] = MovixLibCreateCalendarDay(i, parent, calgrid[i-1], 20 , 0, GEM3UI_COLOR_CAL_DAYLASTNEXTMONTH, "");
  elseif actday > actmonth.monthdaycount then -- premiers jours du mois suivant
    --calgrid[i] = MovixLibCreateCalendarDay(i, GEM3UICalendar, calgrid[i-1], 20 , 0, 1, actday - actmonth.monthdaycount);
    calgrid[i] = MovixLibCreateCalendarDay(i, parent, calgrid[i-1], 20 , 0, GEM3UI_COLOR_CAL_DAYLASTNEXTMONTH, "");
  else -- jours du mois en cours
    if ((actmonth.month==GEM3UI_today.month) and (actmonth.year==GEM3UI_today.year) and (actday == GEM3UI_today.day) ) then
     calgrid[i] = MovixLibCreateCalendarDay(i, parent, calgrid[i-1], 20 , 0, GEM3UI_COLOR_CAL_TODAY, actday);
    else
     calgrid[i] = MovixLibCreateCalendarDay(i, parent, calgrid[i-1], 20 , 0, GEM3UI_COLOR_CAL_NORMAL, actday);
    end
    local ad = date ("*t", time({["year"] = actmonth.year, ["month"] = actmonth.month, ["day"] = actday, }));
    if GEM3UI_DayHasEvent(ad) == true and parent:GetName() ~= "CalColCfgExample" then
     MovixLibCalendarDayHasEvent(i, parent);
    end
  end
  if fooOnClick ~= nil then 
   calgrid[i]:SetScript("OnMouseUp", fooOnClick);
  end
  if fooOnOver ~= nil then
   calgrid[i]:SetScript("OnEnter", fooOnOver); 
  end
  if fooOnOut ~= nil then 
   calgrid[i]:SetScript("OnLeave", fooOnOut); 
  end

 end
 parent.amonth=actmonth;
 if parent:GetName() ~= "CalColCfgExample" then
  MovixLibCreateCalendarMonthNav(parent);
 end
 
end

function MovixLibCreateCalendarMonthNav(parent)
 local monthtitle = getglobal(parent:GetName().."monthtitle");
 if monthtitle == nil then
  monthtitle = parent:CreateFontString(parent:GetName().."monthtitle", "ARTWORK", "GameFontNormal");
  monthtitle:SetPoint("TOPLEFT", parent, 27, -5);
  monthtitle:SetWidth(119);
  monthtitle:SetHeight(15);
 end
 local prevbut = getglobal(parent:GetName().."prevbut");
 if prevbut == nil then
  prevbut = CreateFrame("BUTTON", parent:GetName().."prevbut", parent, "PrevButtonTemplate");
  prevbut:SetPoint("TOPLEFT", parent, 5, -5);
  prevbut:SetWidth(16);
  prevbut:SetHeight(16);
  prevbut:SetText("<");
  prevbut:SetScript("OnClick", GEM3UI_PrevMonth);
 end
 local nextbut = getglobal(parent:GetName().."nextbut");
 if nextbut == nil then
  nextbut= CreateFrame("BUTTON", parent:GetName().."nextbut", parent, "NextButtonTemplate");
  nextbut:SetPoint("TOPLEFT", parent, 148, -5);
  nextbut:SetWidth(16);
  nextbut:SetHeight(16);
  nextbut:SetText(">");
  nextbut:SetScript("OnClick", GEM3UI_NextMonth);
 end
 monthtitle:SetText(GEM3UI_LocalizedStrings.month[parent.amonth.month].." "..parent.amonth.year);
end