﻿--[[
 Guild Event Manager GUI
 -------------------------------------
  Code: Movix - Conseil des Ombres - EU
  Add External
]]


---- ADD EXTERNAL
function GEM3UI_ShowAddExternal()
 GEM3UIAddExternal.ev_index = MyEvent[this:GetParent():GetParent():GetParent().ev_index].id;
 GEM3UIAddExternal:SetParent("GEM3UIMain");
 GEM3UIAddExternal:SetPoint("CENTER");
 if FriendsFrame:IsVisible() then
  FriendsFrame:Hide();
 end
 GEM3UIAddExternal:Show();
end

function GEM3UI_ExternalAddClassChanged()
 if GEM3UI_CLASS_STRINGS[GEM3UIAddExternalClassTextLabel:GetText()] == 0 then
   GEM3UIAddExternalRoleTextLabel:SetText(GEM3UI_Roles[0].name_loc);
   GEM3UIAddExternalRoleTextLabel.id=GEM3UI_Roles[0].gemid;
 else
  local allowedroles = GEM3_PLAY_GetAllowedRoles(string.upper(GEM3UI_CLASS_STRINGS[GEM3UIAddExternalClassTextLabel:GetText()]));
   local i;
   for r=1, 5 do
    if (bit.band(allowedroles, GEM3UI_Roles[r].gemid) ~= 0) and GEM3UI_Roles[r].gemid ~=6 then
     i = r;
    end
   end
   GEM3UIAddExternalRoleTextLabel:SetText(GEM3UI_Roles[i].name_loc);
   GEM3UIAddExternalRoleTextLabel.id=GEM3UI_Roles[i].gemid;
 end
end


function GEM3UI_PlayerLookup(LookupClicked)
 GEM3UIAddExternal.lookup=true;
 if string.len(GEM3UIAddExternalName:GetText()) > 0 then
  SendWho('n-"'..GEM3UIAddExternalName:GetText()..'"');
  GEM3UI_SetStatusMessage("Recherche en cours", 1)
 else
  if LookupClicked then 
   FriendsFrame:Show();
  end
 end
end



function GEM3UI_FriendsFrameGuildStatusButton_OnClick()
  local name, rank, rankIndex, level, class, zone, note, officernote, online = GetGuildRosterInfo(this.guildIndex);
  GEM3UIAddExternalName:SetText(name);
  local guildname, gr, gri = GetGuildInfo("player");
  GEM3UIAddExternalGuild:SetText(guildname);
  GEM3UIAddExternalClassTextLabel:SetText(class);
  GEM3UIAddExternalLevel:SetText(level);
  GEM3UI_ExternalAddClassChanged();
  if not AddExternalLookupStayopen:GetChecked() then
     FriendsFrame:Hide();
    end
end


function GEM3UI_FriendsFrameWhoButton_OnClick(button)
    local charname, guildname, level, race, class, zone, unknown = GetWhoInfo(getglobal("WhoFrameButton"..this:GetID()).whoIndex);
    GEM3UIAddExternalName:SetText(charname);
    GEM3UIAddExternalGuild:SetText(guildname);
    GEM3UIAddExternalClassTextLabel:SetText(class);
    GEM3UIAddExternalLevel:SetText(level);
    GEM3UI_ExternalAddClassChanged();
    if not AddExternalLookupStayopen:GetChecked() then
     FriendsFrame:Hide();
    end
end

function GEM3UI_FriendsFrameFriendButton_OnClick(button)
    local name, level, class, area, connected = GetFriendInfo(this:GetID());
    if connected then
     SendWho('n-"'..name..'"');
    else
     GEM3UIAddExternalName:SetText(name);
     GEM3UIAddExternalGuild:SetText("");
     GEM3UIAddExternalClassTextLabel:SetText("");
     GEM3UIAddExternalLevel:SetText("");
     GEM3UI_SetStatusMessage("Renseignements incomplet, le joueur n'est pas connecté", 1)
     if not AddExternalLookupStayopen:GetChecked() then
       FriendsFrame:Hide();
     end
    end
end

function GEM3UI_AddExternalInit()
 local ev = GEM3UI_EventSource[GEM3UIAddExternal.ev_index];
 GEM3UI_AddExternalTitelLabel:SetText(string.format(GEM3UI_LocalizedStrings["_AddExternalTitel"], ev.ev_place, date(GEM3UI_DateFormatString , ev.ev_date)));
 GEM3UIAddExternalClassTextLabel:SetText("");
 GEM3UIAddExternalName:SetText("")
 GEM3UIAddExternalComment:SetText("");
 GEM3UIAddExternalGuild:SetText("");
 GEM3UIAddExternalLevel:SetText("");

 GEM3UIAddExternal.FriendsFrameFriendButton_OnClick = FriendsFrameFriendButton_OnClick;
 GEM3UIAddExternal.FriendsFrameWhoButton_OnClick = FriendsFrameWhoButton_OnClick;
 GEM3UIAddExternal.FriendsFrameGuildStatusButton_OnClick = FriendsFrameGuildStatusButton_OnClick;

 FriendsFrameGuildStatusButton_OnClick = GEM3UI_FriendsFrameGuildStatusButton_OnClick;
 FriendsFrameFriendButton_OnClick = GEM3UI_FriendsFrameFriendButton_OnClick;
 FriendsFrameWhoButton_OnClick = GEM3UI_FriendsFrameWhoButton_OnClick;
 
 SetWhoToUI(1);
 GEM3UIAddExternal:RegisterEvent("WHO_LIST_UPDATE");
 GEM3UIAddExternal:RegisterEvent("CHAT_MSG_SYSTEM");
 GEM3UIAddExternal:RegisterEvent("PLAYER_TARGET_CHANGED");
 GEM3UIAddExternal:RegisterForDrag("LeftButton");
 GEM3UIAddExternal:SetScript("OnUpdate", GEM3UI_AddExternalValidate);
end


function GEM3UI_AddExternalValidate()
    local ok = true;
    if string.len(GEM3UIAddExternalName:GetText()) == 0 then ok = false; end
    if GEM3UI_CLASS_STRINGS[GEM3UIAddExternalClassTextLabel:GetText()] == nil then ok = false; end
    if string.len(GEM3UIAddExternalLevel:GetText()) == 0 then
     ok = false;
    else
     if tonumber(GEM3UIAddExternalLevel:GetText()) then
      if tonumber(GEM3UIAddExternalLevel:GetText()) <= 0 then ok = false; end
      if tonumber(GEM3UIAddExternalLevel:GetText()) > GEM3UI_MaxLevel then ok = false; end
     else
      ok = false;
     end
    end
    if ok then
     GEM3UI_AddExternalOK:Enable();
    else
     GEM3UI_AddExternalOK:Disable();
    end
end



function GEM3UI_AddExternalOnEvent()
 if (event == "WHO_LIST_UPDATE" and GEM3UIAddExternal.lookup==true)
 or (event == "CHAT_MSG_SYSTEM" and string.find(arg1, "au total"))
 then
   local numWhos, totalCount = GetNumWhoResults();
   if totalCount == 1 then
    local charname, guildname, level, race, class, zone, unknown = GetWhoInfo(1);
    GEM3UIAddExternalName:SetText(charname);
    GEM3UIAddExternalGuild:SetText(guildname);
    GEM3UIAddExternalClassTextLabel:SetText(class);
    GEM3UIAddExternalLevel:SetText(level);
    GEM3UI_ExternalAddClassChanged();
    FriendsFrame:Hide();
   else
    FriendsFrame:Show();
   end
 end
 if event == "PLAYER_TARGET_CHANGED" then
    local name = UnitName("target");
    if name == nil then return; end
    if UnitIsPlayer("target") then
     GEM3UIAddExternalName:SetText(UnitName("target"));
     local guildname, gr, gri = GetGuildInfo("target");
     if guildname ~= nil then
      GEM3UIAddExternalGuild:SetText(guildname);
     else
      GEM3UIAddExternalGuild:SetText("");
     end
     local classlocal, class = UnitClass("target");
     GEM3UIAddExternalClassTextLabel:SetText(classlocal);
     GEM3UIAddExternalLevel:SetText(UnitLevel("target"));
     GEM3UI_ExternalAddClassChanged();
    end
 end
end


function GEM3UI_AddExternalHide()
 FriendsFrameFriendButton_OnClick = GEM3UIAddExternal.FriendsFrameFriendButton_OnClick;
 FriendsFrameWhoButton_OnClick = GEM3UIAddExternal.FriendsFrameWhoButton_OnClick;
 FriendsFrameGuildStatusButton_OnClick = GEM3UIAddExternal.FriendsFrameGuildStatusButton_OnClick
 GEM3UIAddExternal:UnregisterEvent("WHO_LIST_UPDATE");
 GEM3UIAddExternal:UnregisterEvent("CHAT_MSG_SYSTEM");
 GEM3UIAddExternal:UnregisterEvent("PLAYER_TARGET_CHANGED");
 GEM3UIAddExternal:SetScript("OnUpdate", nil);
 GEM3UIAddExternal.lookup=false;
 GEM3UIAddExternal:Hide();
end



function GEM3UI_AddExternal()
 --FriendsFrameFriendButton_OnClick = GEM3UIAddExternal.FriendsFrameFriendButton_OnClick;
 --FriendsFrameWhoButton_OnClick = GEM3UIAddExternal.FriendsFrameWhoButton_OnClick;
 local force_queue = GEM3_SUB_FORCE_QUEUE_NONE;
 local ev = GEM3UI_EventSource[this:GetParent().ev_index];
 if GEM3UIAddExternalAsReplacement:GetChecked() then 
  force_queue = GEM3_SUB_FORCE_QUEUE_REPLACEMENT;
 end
 local plname = GEM3UIAddExternalName:GetText();
 plname = string.upper(string.sub(plname,1,1))..string.sub(plname,2);
 
 if ev.isTemplate == true then
  local p = {};
  p.name=plname;
  p.guild=GEM3UIAddExternalGuild:GetText();
  p.class=GEM3UI_CLASS_STRINGS[GEM3UIAddExternalClassTextLabel:GetText()];
  p.role=tonumber(GEM3UIAddExternalRoleTextLabel.id);
  p.level= tonumber(GEM3UIAddExternalLevel:GetText());
  p.force_queue=GEM3_SUB_FORCE_QUEUE_NONE;
  p.source=GEM3_SUB_SOURCE_TEMPLATE;
  p.comment="";
  ev.players[p.name] = GEM3UI_TblCpy(p);
  --GEM3UI_-RefreshAll();
  GEM3UI_RefreshView("GEM3UI_REFRESH_EVENT_UPDATE", ev.id);
 else
  subs, reason  = GEM3_SUB_SubscribeExternal(
                    ev.id,
                    plname,
                    GEM3UIAddExternalGuild:GetText(),
                    tonumber(GEM3UIAddExternalLevel:GetText()),
                    GEM3UI_CLASS_STRINGS[GEM3UIAddExternalClassTextLabel:GetText()],
                    tonumber(GEM3UIAddExternalRoleTextLabel.id),
                    GEM3UIAddExternalComment:GetText(),
                    force_queue,
                    GEM3_ROLE_UNKNOWN);
  if subs then
   PlaySound("PVPENTERQUEUE");
  else
   PlaySound("igQuestFailed");
  end                    
  GEM3UI_SetStatusMessage(reason);
 end
 if not AddExternalLookupStayopen:GetChecked() then
  GEM3UIAddExternal:Hide();
 end
end
