--[[
	Copyright (C) 2006-2007 Nymbia

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
]]
local L = AceLibrary("AceLocale-2.2"):new("GrindStatus")
local locked = true
GrindStatus = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceDebug-2.0", "AceEvent-2.0")
local quixote = AceLibrary("Quixote-1.0")
local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local BR = AceLibrary("Babble-Race-2.2")
local PT = LibStub("LibPeriodicTable-3.1")
local deformat = AceLibrary("Deformat-2.0")
local futext = "GrindStatus"
local lootfaction
local grouporder = {}
local sessionstarttime
local sessionstartrepvalues
local realnumfactions
GrindStatus.modules = {}
local qualitycolors = {
	[0] = "|cff9d9d9d",
	[1] = "|cffffffff",
	[2] = "|cff1eff00",
	[3] = "|cff0070dd",
	[4] = "|cffa335ee",
	[5] = "|cffff8000" }
GrindStatus:RegisterDB("GrindStatusDB")
local options = {
	name = L["GrindStatus"],
	desc = L["GrindStatus"],
	type = "group",
	args = {
		header7 = {
			type = "header",
			order = 7999,
		},
		autoswitch = {
			name = L["Autoswitch"],
			desc = L["Automatically change watched faction on rep gains."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.autoswitch end,
			set = function(v) GrindStatus.db.profile.autoswitch=v if v then GrindStatus:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE") else GrindStatus:UnregisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE") end end,
			order = 8000,
		},
		resettime = {
			name = L["Reset Time Data"],
			desc = L["Reset rep per time data for this session"],
			type = "execute",
			func = function() GrindStatus:FactionScan() end,
			order = 8001,
		},
		header8 = {
			type = "header",
			order = 8999,
		},
		showname = {
			name = L["Display Name"]..L["(rep bar)"],
			desc = L["Display faction name in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displayname end,
			set = function(v) GrindStatus.db.profile.displayname=v GrindStatus:UpdateText() end,
			order = 9000,
		},
		showpercent = {
			name = L["Display Percent"]..L["(rep bar)"],
			desc = L["Display progress percent in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displaypercent end,
			set = function(v) GrindStatus.db.profile.displaypercent=v GrindStatus:UpdateText() end,
			order = 9002,
		},
		showtotalrep = {
			name = L["Display Total Rep"]..L["(rep bar)"],
			desc = L["Display total rep progress in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displayabsoluterep end,
			set = function(v) GrindStatus.db.profile.displayabsoluterep=v GrindStatus:UpdateText() end,
			order = 9004,
		},
		shownamefu = {
			name = L["Display Name"]..L["(fubar)"],
			desc = L["Display faction name in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displaynamefu end,
			set = function(v) GrindStatus.db.profile.displaynamefu=v GrindStatus:UpdateText() end,
			order = 9006,
		},
		showpercentfu = {
			name = L["Display Percent"]..L["(fubar)"],
			desc = L["Display progress percent in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displaypercentfu end,
			set = function(v) GrindStatus.db.profile.displaypercentfu=v GrindStatus:UpdateText() end,
			order = 9008,
		},
		showtotalrepfu = {
			name = L["Display Total Rep"]..L["(fubar)"],
			desc = L["Display total rep progress in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displayabsoluterepfu end,
			set = function(v) GrindStatus.db.profile.displayabsoluterepfu=v GrindStatus:UpdateText() end,
			order = 9010,
		},
		header9 = {
			type = "header",
			order = 9999,
		},
		hideoverlay = {
			name = L["Hide Overlay"],
			desc = L["Hide the rep bar overlay"],
			type = "toggle",
			get = function() return GrindStatus.db.profile.hideoverlay end,
			set = function(v) GrindStatus.db.profile.hideoverlay=v if v then GrindStatusFrame:Hide() else GrindStatusFrame:Show() end GrindStatus:UpdateText() end,
			order = 10000,
		},
		lock = {
			name = L["Lock"],
			desc = L["Toggle Locking"],
			type = "toggle",
			get = function() return locked end,
			set = function(v) locked=v end,
			order = 10002,
		},
	}
}
GrindStatus.Options = {
	name = L["GrindStatus"],
	desc = L["GrindStatus"],
	type = "group",
	args = {
		header6 = {
			type = "header",
			order = 6999,
		},
		alphabetical = {
			name = L["Alphabetical"],
			desc = L["Alphabetical"],
			type = "group",
			order = 7000,
			args = {}
		},
		header7 = {
			type = "header",
			order = 7999,
		},
		autoswitch = {
			name = L["Autoswitch"],
			desc = L["Automatically change watched faction on rep gains."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.autoswitch end,
			set = function(v) GrindStatus.db.profile.autoswitch=v if v then GrindStatus:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE") else GrindStatus:UnregisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE") end end,
			order = 8000,
		},
		resettime = {
			name = L["Reset Time Data"],
			desc = L["Reset rep per time data for this session"],
			type = "execute",
			func = function() GrindStatus:FactionScan() end,
			order = 8001,
		},
		header8 = {
			type = "header",
			order = 8999,
		},
		showname = {
			name = L["Display Name"]..L["(rep bar)"],
			desc = L["Display faction name in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displayname end,
			set = function(v) GrindStatus.db.profile.displayname=v GrindStatus:UpdateText() end,
			order = 9000,
		},
		showpercent = {
			name = L["Display Percent"]..L["(rep bar)"],
			desc = L["Display progress percent in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displaypercent end,
			set = function(v) GrindStatus.db.profile.displaypercent=v GrindStatus:UpdateText() end,
			order = 9002,
		},
		showtotalrep = {
			name = L["Display Total Rep"]..L["(rep bar)"],
			desc = L["Display total rep progress in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displayabsoluterep end,
			set = function(v) GrindStatus.db.profile.displayabsoluterep=v GrindStatus:UpdateText() end,
			order = 9004,
		},
		shownamefu = {
			name = L["Display Name"]..L["(fubar)"],
			desc = L["Display faction name in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displaynamefu end,
			set = function(v) GrindStatus.db.profile.displaynamefu=v GrindStatus:UpdateText() end,
			order = 9006,
		},
		showpercentfu = {
			name = L["Display Percent"]..L["(fubar)"],
			desc = L["Display progress percent in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displaypercentfu end,
			set = function(v) GrindStatus.db.profile.displaypercentfu=v GrindStatus:UpdateText() end,
			order = 9008,
		},
		showtotalrepfu = {
			name = L["Display Total Rep"]..L["(fubar)"],
			desc = L["Display total rep progress in summary text."],
			type = "toggle",
			get = function() return GrindStatus.db.profile.displayabsoluterepfu end,
			set = function(v) GrindStatus.db.profile.displayabsoluterepfu=v GrindStatus:UpdateText() end,
			order = 9010,
		},
		header9 = {
			type = "header",
			order = 9999,
		},
		hideoverlay = {
			name = L["Hide Overlay"],
			desc = L["Hide the rep bar overlay"],
			type = "toggle",
			get = function() return GrindStatus.db.profile.hideoverlay end,
			set = function(v) GrindStatus.db.profile.hideoverlay=v if v then GrindStatusFrame:Hide() else GrindStatusFrame:Show() end GrindStatus:UpdateText() end,
			order = 10000,
		},
		lock = {
			name = L["Lock"],
			desc = L["Toggle Locking"],
			type = "toggle",
			get = function() return locked end,
			set = function(v) locked=v end,
			order = 10002,
		},
	}
}
GrindStatus.ToTrack = {}
local currentfaction
local currentbagitems --["itemid"] = num
local currentquestcompletion --[questnumber] = {[1] = {["got"] = numGot, ["needed"] = numNeeded}, }
local currentrep
local racemodifier
function GrindStatus:OnInitialize()
	self:RegisterChatCommand({"/grindstatus", "/grinds"}, options)

	CreateFrame("Button", "GrindStatusFrame", UIParent)
	GrindStatusFrame:SetFrameStrata("HIGH")
	GrindStatusFrame:SetWidth(300)
	GrindStatusFrame:SetHeight(11)
	GrindStatusFrame:SetPoint("BOTTOM",ReputationWatchBar,"BOTTOM",0,0)
	GrindStatusFrame:EnableMouse(true)
	GrindStatusFrame:SetMovable(true)
	GrindStatusFrame:CreateFontString("GrindStatusFrameText","HIGH")
	GrindStatusFrameText:SetPoint("CENTER",GrindStatusFrame,"CENTER",0,3)
	GrindStatusFrameText:SetFontObject("GameFontHighlight")
	GrindStatusFrameText:SetTextColor(1, 1, 1)
	GrindStatusFrameText:Show()
	GrindStatusFrame:SetScript("OnMouseDown", function() if locked == false then GrindStatusFrame:StartMoving() end end)
	GrindStatusFrame:SetScript("OnMouseUp", function() GrindStatusFrame:StopMovingOrSizing() GrindStatus:LootFrame() end)
	dewdrop:Register(GrindStatusFrame,'children',function() GrindStatus:UpdateOptionsTableWithRep() dewdrop:FeedAceOptionsTable(GrindStatus.Options) end)
	tablet:Register(GrindStatusFrame,
		'children', function() if locked then GrindStatus:MakeSmallTooltip() else tablet:Close(GrindStatusFrame) end end,
		'point', function()
			return "BOTTOM", "TOP"
		end
	)

	CreateFrame("Button", "GrindStatusDummyFrame")
	GrindStatusDummyFrame:SetWidth(1)
	GrindStatusDummyFrame:SetHeight(1)
	GrindStatusDummyFrame:SetPoint("CENTER")
	dewdrop:Register(GrindStatusDummyFrame,'children',function() GrindStatus:PopulateLoot() end)

	CreateFrame("GameTooltip","GrindStatusTooltip",UIParent,"GameTooltipTemplate")
	GrindStatusTooltip:SetWidth(1)
	GrindStatusTooltip:SetHeight(1)

	self:RegisterDefaults("profile", {
		displayname = true,
		displaypercent = true,
		displayabsoluterep = false,
		displaynamefu = true,
		displaypercentfu = true,
		displayabsoluterepfu = false,
		autoswitch = false,
		hideoverlay = false,
	})
	for _,v in ipairs(self.modules) do
		v()
	end
	self.modules = nil
end
function GrindStatus:OnEnable()
	self:RegisterEvent("Quixote_Leaderboard_Update")
	self:RegisterEvent("Quixote_Quest_Lost")
	self:RegisterEvent("UPDATE_FACTION")
	self:RegisterEvent("BAG_UPDATE")
	self:RegisterEvent("GrindStatus_UpdateRepItems", function() self:UpdateRepItems() end)
	self:RegisterEvent("GrindStatus_RewardsRefresh")
	if self.db.profile.autoswitch then
		self:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE")
	end
	if not self.db.profile.hideoverlay then
		GrindStatusFrame:Hide()
	else
		GrindStatusFrame:Show()
	end
	ReputationWatchBar:EnableMouse(false)
	if UnitRace("player") == BR["Human"] then
		racemodifier = 1.1
	else
		racemodifier = 1
	end
	self:FactionScan()
end
function GrindStatus:OnDisable()
	GrindStatusFrame:Hide()
	ReputationWatchBar:EnableMouse(true)
	sessionstarttime = nil
	sessionstartrepvalues = {}
end
function GrindStatus:FactionScan()
	sessionstarttime = GetTime()
	sessionstartrepvalues = {}
	for i=1, self:GetRealNumFactions() do
		local name, _, _, _, _, earned, _,_,header = GetFactionInfo(i)
		if name and earned and not header then sessionstartrepvalues[name] = earned end
	end
end
function GrindStatus:Quixote_Leaderboard_Update(name, qid, lbid, description, numHad, numGot, numNeeded, lbtype)
	if lbtype ~= "item" and lbtype ~= "monster" then return end
	local questnum = 0
	if self.ToTrack[currentfaction] and tonumber(self.ToTrack[currentfaction].quests) and tonumber(self.ToTrack[currentfaction].quests) > 0 then
		for i = 1, tonumber(self.ToTrack[currentfaction].quests) do
			if self.ToTrack[currentfaction]["quest"..i] == name then
				questnum = i
			end
		end
	end
	if questnum == 0 then return end
	if currentquestcompletion[questnum] == nil then currentquestcompletion[questnum] = {} self:GetFullQuestInfo(name) end
	currentquestcompletion[questnum][lbid] = {["got"] = numGot, ["needed"] = numNeeded}
	self:UpdateText()
end
function GrindStatus:Quixote_Quest_Lost(name, index)
	self:FullStatusUpdate()
end
function GrindStatus:GrindStatus_RefreshTablet()
	tablet:Refresh('GrindStatusDummy')
end
function GrindStatus:CHAT_MSG_COMBAT_FACTION_CHANGE()
	--this code based on tekAutoRep, tekkub rocks.
	if self.db.profile.autoswitch then
		local _, faction = deformat(arg1, FACTION_STANDING_CHANGED)
		if not faction then faction = deformat(arg1, FACTION_STANDING_INCREASED) end --or deformat(arg1, FACTION_STANDING_DECREASED)
		if faction then
			self:SetWatchedFaction(faction)
		end
	end
end
function GrindStatus:UPDATE_FACTION()
	if not sessionstarttime or not sessionstartrepvalues then
		self:FactionScan()
	end
	local name, _, _, _, value = GetWatchedFactionInfo()
	if name ~= currentfaction then
		currentfaction = name
		self:FullStatusUpdate()
		return
	end
	currentrep = value
	if not name then
		currentfaction = nil
		currentrep = nil
	end

	self:UpdateText()
end
function GrindStatus:BAG_UPDATE(arg1)
	self:ScheduleEvent("GrindStatus_UpdateRepItems", 0.7, self)
end
function GrindStatus:UpdateRepItems()
	self:CancelAllScheduledEvents()
	if not currentfaction or not self.ToTrack[currentfaction] then
		return
	end
	if PT("Reputation.Turnin."..self.ToTrack[currentfaction].english) then
		for id in PT:IterateSet("Reputation.Turnin."..self.ToTrack[currentfaction].english) do
			currentbagitems[tonumber(id)] = GetItemCount(tonumber(id),true)
		end
	else
		for k,v in pairs(currentbagitems) do
			currentbagitems[k]=nil
		end
	end
	self:UpdateText()
end
function GrindStatus:SetWatchedFaction(faction)
	local current = GetWatchedFactionInfo()
	for i=1,self:GetRealNumFactions() do
		local name = GetFactionInfo(i)
		if name == faction and name ~= current then
			SetWatchedFactionIndex(i)
			return
		end
	end
end
function GrindStatus:FullStatusUpdate()
	local name, _, _, _, value = GetWatchedFactionInfo()
	currentfaction = name
	currentrep = value
	currentbagitems = {}
	currentquestcompletion = {}
	if not self.ToTrack[currentfaction] then
		return self:UpdateText()
	end
	if self.ToTrack[currentfaction].quests > 0 then
		for i = 1, self.ToTrack[currentfaction].quests do
			self:GetFullQuestInfo(self.ToTrack[currentfaction]["quest"..i])
		end
	end
	self:UpdateRepItems()
	self:UpdateText()
end
function GrindStatus:UpdateText()
	if self.db.profile.hideoverlay then
		GrindStatusFrame:Hide()
	else
		GrindStatusFrame:Show()
	end
	if not currentfaction then
		futext = "GrindStatus"
		GrindStatusFu:Update()
		GrindStatusFrameText:SetText("GrindStatus")
		return
	end
	if not self.ToTrack[currentfaction] then
		GrindStatusFrameText:SetText("Unknown")
		return
	end
	GrindStatusFrame:EnableMouse(true)
	local assumedrep = currentrep
	if self.ToTrack[currentfaction].quests > 0 then
		for i=1, self.ToTrack[currentfaction].quests do
			local itemsdone = 0
			local itemstotal = 0
			if currentquestcompletion[i] then
				for k, v in pairs(currentquestcompletion[i]) do
					itemsdone = itemsdone + v.got
					itemstotal = itemstotal + v.needed
				end
				if self.ToTrack[currentfaction]["quest"..i.."stop"] and self.ToTrack[currentfaction]["quest"..i.."stop"] <= assumedrep then
					--this quest will give no faction credit.
				else
					assumedrep = assumedrep + ((itemsdone / itemstotal) * (self.ToTrack[currentfaction]["quest"..i.."step"] * racemodifier))
					if self.ToTrack[currentfaction]["quest"..i.."stop"] and self.ToTrack[currentfaction]["quest"..i.."stop"] <= assumedrep then
						--we'll get credit for this quest, but it'll be partial and bring us to this quests's cap
						assumedrep = self.ToTrack[currentfaction]["quest"..i.."stop"]
					end
				end
			end
		end
	end
	if PT("Reputation.Turnin."..self.ToTrack[currentfaction].english) then
		for id,value in PT:IterateSet("Reputation.Turnin."..self.ToTrack[currentfaction].english) do
			if tonumber(currentbagitems[tonumber(id)]) then
				local stopstr = value:match("stop(%d+)")
				if stopstr and tonumber(stopstr) < assumedrep then
					--this item will give no faction credit.
				else
					local step = value:match("v(%d+%/?%d*)")
					local a,b = step:match("^(%d+)%/(%d+)$")
					if a then
						step = a/b
					else
						step = tonumber(step)
					end
					assumedrep = assumedrep + ((currentbagitems[tonumber(id)]) * (step * racemodifier))
					if stopstr and tonumber(stopstr) <= assumedrep then
						--we'll get credit for this item, but it'll be partial and bring us to this item's cap
						assumedrep = tonumber(stopstr)
					end
				end
			end
		end
	end
	local startrep
	local endrep
	if self.db.profile[currentfaction] and self.db.profile[currentfaction].overridestart then
		startrep = self.db.profile[currentfaction].overridestart
	else
		startrep = self.ToTrack[currentfaction].startrepvalue
	end
	if self.db.profile[currentfaction] and self.db.profile[currentfaction].overrideend then
		endrep = self.db.profile[currentfaction].overrideend
	else
		endrep = self.ToTrack[currentfaction].endrepvalue
	end
	if endrep == startrep then GrindStatusFrameText:SetText("0%") return end
	local text = ""
	if self.db.profile.displayname then
		text = currentfaction
		if self.db.profile.displaypercent or self.db.profile.displayabsoluterep then
			text = text..": "
		end
	end
	if self.db.profile.displaypercent then
		text = text..string.format("%.3f", 100*((assumedrep - startrep) / (endrep - startrep ))).."%"
		if self.db.profile.displayabsoluterep then
			text = text.." - "
		end
	end
	if self.db.profile.displayabsoluterep then
		text = text..math.floor(assumedrep).."/"..endrep
	end
	GrindStatusFrameText:SetText(text)

	futext = ""
	if self.db.profile.displaynamefu then
		futext = currentfaction
		if self.db.profile.displaypercentfu or self.db.profile.displayabsoluterepfu then
			futext = futext..": "
		end
	end
	if self.db.profile.displaypercentfu then
		futext = futext..string.format("%.3f", 100*((assumedrep - startrep) / (endrep - startrep ))).."%"
		if self.db.profile.displayabsoluterepfu then
			futext = futext.." - "
		end
	end
	if self.db.profile.displayabsoluterepfu then
		if assumedrep > 42999 then
			futext = futext.."42999".."/"..endrep
		else
			futext = futext..math.floor(assumedrep).."/"..endrep
		end
	end
	GrindStatusFu:Update()
end
function GrindStatus:GetFullQuestInfo(name)
	local questnum
	local _, _, _, _, _, objectives, _, id = quixote:GetQuest(name)
	if self.ToTrack[currentfaction].quests > 0 then
		for i = 1, self.ToTrack[currentfaction].quests do
			if self.ToTrack[currentfaction]["quest"..i] == name then
				questnum = i
			end
		end
	end
	if objectives then
		currentquestcompletion[questnum] = {}
		for j = 1, objectives do
			local description, obtype, numGot, numNeeded = quixote:GetQuestStatusById(id, j)
			if obtype == "item" or obtype == "monster" then
				currentquestcompletion[questnum][j] = {["got"] = numGot, ["needed"] = numNeeded}
			end
		end
	end
end
function GrindStatus:MakeSmallTooltip(faction)
	local usefaction
	if faction then
		usefaction = faction
	else
		usefaction = currentfaction
	end
	tablet:SetTitle(usefaction)
	local cat = tablet:AddCategory('columns', 2, 'child_textR', 0, 'child_textG', 1, 'child_textB', 0, 'child_text2R', 0, 'child_text2G', 1, 'child_text2B', 0)
	if not usefaction then
		cat:AddLine('text', L["No faction selected"])
		return
	end
	if not self.ToTrack[usefaction] then
		tablet:Close()
		return
	end
	local assumedrep, repstring, nextrepvalue, bottom, real
	for i=1,self:GetRealNumFactions() do
		local name, _, standing, bot, top, earnedValue = GetFactionInfo(i)
		if name == usefaction then
			assumedrep = earnedValue
			real = earnedValue
			repstring = getglobal("FACTION_STANDING_LABEL"..standing)
			nextrepvalue = top-bot
			bottom = bot
		end
	end
	if not real then
		cat:AddLine('text', L["No faction selected"])
		return
	end
	cat:AddLine('text', repstring, 'text2', real-bottom.."/"..nextrepvalue)
	cat:AddLine('text', "", 'text2', "("..real..")")
	local cat = tablet:AddCategory('columns', 2, 'child_textR', 1, 'child_textG', 0.4, 'child_textB', 0, 'child_text2R', 1, 'child_text2G', 0.4, 'child_text2B', 0)
	if self.ToTrack[usefaction].quests > 0 then
		for i=1, self.ToTrack[usefaction].quests do
			local _, _, _, _, _, objectives, _, id = quixote:GetQuest(self.ToTrack[usefaction]["quest"..i])
			if objectives then
				local numdone = 0
				local numneeded = 0
				for j = 1, objectives do
					local description, obtype, numGot, numNeeded = quixote:GetQuestStatusById(id, j)
					if obtype == "item" or obtype == "monster" then
						numdone = numdone + numGot
						numneeded = numneeded + numNeeded
					end
				end
				if numdone and numdone > 0 then
					if self.ToTrack[usefaction]["quest"..i.."stop"] and self.ToTrack[usefaction]["quest"..i.."stop"] <= assumedrep then
						--this quest will give no faction credit.
					else
						local addedrep = ((numdone / numneeded) * (self.ToTrack[usefaction]["quest"..i.."step"] * racemodifier))
						assumedrep = assumedrep + addedrep
						if self.ToTrack[usefaction]["quest"..i.."stop"] and self.ToTrack[usefaction]["quest"..i.."stop"] <= assumedrep then
							addedrep = self.ToTrack[usefaction]["quest"..i.."stop"] - assumedrep
							assumedrep = self.ToTrack[usefaction]["quest"..i.."stop"]
						end
						cat:AddLine('text', self.ToTrack[usefaction]["quest"..i], 'text2', (math.floor((numdone/numneeded)*100).."% ("..string.format("%.2f", addedrep)..")"))
					end
				end
			end
		end
	end
	local cat = tablet:AddCategory('columns', 2, 'child_textR', 0.5, 'child_textG', 0.5, 'child_textB', 1, 'child_text2R', 0.5, 'child_text2G', 0.5, 'child_text2B', 1)
	
	if PT("Reputation.Turnin."..self.ToTrack[usefaction].english) then
		for id,value in PT:IterateSet("Reputation.Turnin."..self.ToTrack[usefaction].english) do
			local stopstr = value:match("stop(%d+)")
			if stopstr and tonumber(stopstr) < assumedrep then
				--this item will give no faction credit.
			else
				local step = value:match("v(%d+%/?%d*)")
				local a,b = step:match("^(%d+)%/(%d+)$")
				if a then
					step = a/b
				else
					step = tonumber(step)
				end
				local count  = GetItemCount(tonumber(id), true)
				local addedrep = count * (step * racemodifier)
				
				assumedrep = assumedrep + addedrep
				if stopstr and tonumber(stopstr) < assumedrep then
					addedrep = tonumber(stopstr) - assumedrep
					assumedrep = tonumber(stopstr)
				end
				local name = GetItemInfo(tonumber(id))
				if name and count>0 then
					cat:AddLine('text', name, 'text2', (count.." ("..string.format("%.2f", addedrep)..")"))
				end
			end
		end
	end
	local cat = tablet:AddCategory('columns', 2, 'child_textR', 0.5, 'child_textG', 0.5, 'child_textB', 0.5, 'child_text2R', 0.5, 'child_text2G', 0.5, 'child_text2B', 0.5)
	local startrep
	local endrep
	if self.db.profile[usefaction] and self.db.profile[usefaction].overridestart then
		startrep = self.db.profile[usefaction].overridestart
	else
		startrep = self.ToTrack[usefaction].startrepvalue
	end
	if self.db.profile[usefaction] and self.db.profile[usefaction].overrideend then
		endrep = self.db.profile[usefaction].overrideend
	else
		endrep = self.ToTrack[usefaction].endrepvalue
	end
	if endrep == startrep then tablet:Close() return end
	cat:AddLine('text', L["Grind Start"], 'text2', startrep)
	cat:AddLine('text', L["Grind End"], 'text2', endrep)

	local cat = tablet:AddCategory('columns', 2, 'child_textR', 1, 'child_textG', 1, 'child_textB', 0, 'child_text2R', 1, 'child_text2G', 1, 'child_text2B', 0)
	if assumedrep > 42999 then
		cat:AddLine('text', L["Total"], 'text2', "42999")
	else
		cat:AddLine('text', L["Total"], 'text2', math.floor(assumedrep))
	end
	cat:AddLine('text', L["Percent to Goal"], 'text2',string.format("%.3f", 100*((assumedrep - startrep) / (endrep - startrep ))).."%", 'textR', 1, 'textG', 1, 'textB', 0, 'text2R', 1, 'text2G', 1, 'text2B', 0)

	local cat = tablet:AddCategory('columns', 2, 'child_textR', 0.8, 'child_textG', 0.8, 'child_textB', 1, 'child_text2R', 0.8, 'child_text2G', 0.8, 'child_text2B', 1)
	if not sessionstartrepvalues[usefaction] then
		cat:AddLine('text', L["Time data not available for this faction."])
	else
		local timediff = GetTime() - sessionstarttime
		local repdiff = real - sessionstartrepvalues[usefaction]
		if real < endrep and real > sessionstartrepvalues[usefaction] then
			local hours = math.floor(timediff/3600)
			if hours > 0 then
				cat:AddLine('text', L["Time Played This Session"], 'text2', hours..L["h "]..(math.floor(timediff/60) % 60)..L["m "]..math.floor(timediff % 60)..L["s"])
			else
				cat:AddLine('text', L["Time Played This Session"], 'text2', (math.floor(timediff/60) % 60)..L["m "]..math.floor(timediff % 60)..L["s"])
			end
			cat:AddLine('text', L["Rep Gained This Session"], 'text2', repdiff)
			cat:AddLine('text', L["Rep Per Hour"], 'text2', string.format("%.2f", repdiff/(timediff/3600)))
			local timetogoal = (endrep - real) / (repdiff/timediff)
			local days = math.floor(timetogoal/86400)
			local hours = math.floor(timetogoal/3600) % 24
			if days > 0 then
				cat:AddLine('text', L["Time To Goal"], 'text2', days..L["d "]..hours..L["h "]..(math.floor(timetogoal/60) % 60)..L["m "])
			elseif hours > 0 then
				cat:AddLine('text', L["Time To Goal"], 'text2', hours..L["h "]..(math.floor(timetogoal/60) % 60)..L["m "]..math.floor(timetogoal % 60)..L["s"])
			else
				cat:AddLine('text', L["Time To Goal"], 'text2', (math.floor(timetogoal/60) % 60)..L["m "]..math.floor(timetogoal % 60)..L["s"])
			end
		else
			local hours = math.floor(timediff/3600)
			if hours > 0 then
				cat:AddLine('text', L["Time Played This Session"], 'text2', hours..L["h "]..(math.floor(timediff/60) % 60)..L["m "]..math.floor(timediff % 60)..L["s"])
			else
				cat:AddLine('text', L["Time Played This Session"], 'text2', (math.floor(timediff/60) % 60)..L["m "]..math.floor(timediff % 60)..L["s"])
			end
			cat:AddLine('text', L["Rep Gained This Session"], 'text2', repdiff)
		end
	end

	tablet:SetHint(L["Left click to show faction rewards. Right click for Options."])
end
function GrindStatus:LootFrame(faction)
	if not faction then faction = currentfaction end
	lootfaction = faction
	local x, y = GetCursorPosition()
	GrindStatusDummyFrame:ClearAllPoints()
	GrindStatusDummyFrame:SetPoint("BOTTOMLEFT",x,y)
	dewdrop:Open(GrindStatusDummyFrame)
end
function GrindStatus:PopulateLoot(overridefaction)
	if overridefaction then
		lootfaction = overridefaction
	end
	if not lootfaction then
		return
	end
	local rewardstable = PT("Reputation.Reward."..self.ToTrack[lootfaction].english)
	if not rewardstable then
		return dewdrop:Close()
	end
	dewdrop:AddLine(
		'text', lootfaction,
		'isTitle', true
	)
	local displaykeys = {}
	local displaytable = {}
	for k,v in pairs(rewardstable) do
		if k ~= "set" then
			if not displaytable[tonumber(v)] then
				displaytable[tonumber(v)] = {}
				table.insert(displaykeys, tonumber(v))
			end
			table.insert(displaytable[tonumber(v)], k)
		end
	end
	table.sort(displaykeys)
	for k,v in pairs(displaykeys) do
		dewdrop:AddLine(
			'text', self:NumberToGoalText(tonumber(v)),
			'isTitle', true,
			'order', k*100
		)
		for a,b in pairs(displaytable[v]) do
			local name, link, rarity, _,_,_,_,_,_, texture = GetItemInfo(tonumber(b))
			if not link then
				dewdrop:AddLine(
					'text', "|cFFFF2222["..b.."]",
					'func', self.RewardClick,
					'arg1', self, 'arg2', b,
					'tooltipTitle', "|cFFFF2222"..b,
					'tooltipText', L["Query_Warning"],
					'order', k*100+1
				)
			else
				dewdrop:AddLine(
					'text', qualitycolors[rarity].."["..name.."]",
					'func', self.RewardClick,
					'arg1', self, 'arg2', b,
					'tooltipFunc', self.SetTooltip,
					'tooltipArg1', GameTooltip, 'tooltipArg2', b,
					'order', k*100+1,
					'icon', texture
				)
			end
		end
	end
end
function GrindStatus:SetTooltip(arg1)
	GameTooltip_SetDefaultAnchor(GameTooltip, this)
	GameTooltip:SetHyperlink("item:"..arg1..":0:0:0:0:0:0:0")
end
function GrindStatus:RewardClick(id)
	local name, link, rarity, _,_,_,_,_,_, texture = GetItemInfo(id)
	if not name then
		self:GetItemData(id)
		self:ScheduleEvent("GrindStatus_RewardsRefresh", 2)
		return
	end
	if IsControlKeyDown() then
		DressUpItemLink(id)
	else
		if not ChatFrameEditBox:IsVisible() then
			ChatFrameEditBox:Show()
		end
		ChatFrameEditBox:Insert(link)
	end
end
function GrindStatus:GrindStatus_RewardsRefresh()
	dewdrop:Refresh(1)
end
function GrindStatus:GetItemData(id)
	GrindStatusTooltip:SetOwner(this, "ANCHOR_PRESERVE")
	GrindStatusTooltip:SetHyperlink("item:" .. id)
	GrindStatusTooltip:Hide()
end
function GrindStatus:RegisterGroupOrder(group, catorder)
	grouporder[catorder] = string.gsub(group, " ", "")
	self.Options.args[grouporder[catorder]] = {
		name = group,
		desc = group,
		type = "group",
		order = catorder,
		args = {},
	}
end
function GrindStatus:InitPlugin(factionname, pluginorder, pluginplayergroup, totracktable)
	if pluginplayergroup then
		local playergroup = UnitFactionGroup("player")
		if playergroup ~= pluginplayergroup then
			return
		end
	end
	self.ToTrack[factionname] = totracktable
	local factionopts = {
		name = factionname,
		desc = factionname,
		type = "group",
		args = {
			overridestart = {
				name = L["Grind Start"],
				desc = L["Grind Start"],
				type = 'text',
				get = function()
					if self.db.profile[factionname].overridestart then
						return self:NumberToGoalText(self.db.profile[factionname].overridestart)
					elseif not tonumber(self:NumberToGoalText(self.ToTrack[factionname].startrepvalue)) then
						return self:NumberToGoalText(self.ToTrack[factionname].startrepvalue)
					else
						return L["Default"]
					end
				end,
				set = function(v)
					if v == L["Default"] then
						self.db.profile[factionname].overridestart = nil
					elseif v == L["Hated"] then
						self.db.profile[factionname].overridestart = -42000
					elseif v == L["Hostile"] then
						self.db.profile[factionname].overridestart = -6000
					elseif v == L["Unfriendly"] then
						self.db.profile[factionname].overridestart = -3000
					elseif v == L["Neutral"] then
						self.db.profile[factionname].overridestart = 0
					elseif v == L["Friendly"] then
						self.db.profile[factionname].overridestart = 3000
					elseif v == L["Honored"] then
						self.db.profile[factionname].overridestart = 9000
					elseif v == L["Revered"] then
						self.db.profile[factionname].overridestart = 21000
					elseif v == L["Exalted"] then
						self.db.profile[factionname].overridestart = 42000
					elseif v == L["Max Exalted"] then
						self.db.profile[factionname].overridestart = 42999
					elseif v == L["Current"] then
						for i=1,self:GetRealNumFactions() do
							local name, _, _, _, _, earnedValue = GetFactionInfo(i)
							if name == factionname then
								self.db.profile[factionname].overridestart = earnedValue
							end
						end
					end
					if self.db.profile[factionname].overridestart == self.ToTrack[factionname].startrepvalue then
						self.db.profile[factionname].overridestart = nil
					end
					self:FullStatusUpdate()
				end,
				validate = {L["Default"], L["Hated"], L["Hostile"], L["Unfriendly"], L["Neutral"], L["Friendly"],
					L["Honored"], L["Revered"], L["Exalted"], L["Max Exalted"], L["Current"]},
				order = 100,
			},
			overrideend = {
				name = L["Grind End"],
				desc = L["Grind End"],
				type = 'text',
				get = function()
					if self.db.profile[factionname].overrideend then
						return self:NumberToGoalText(self.db.profile[factionname].overrideend)
					elseif not tonumber(self:NumberToGoalText(self.ToTrack[factionname].endrepvalue)) then
						return self:NumberToGoalText(self.ToTrack[factionname].endrepvalue)
					else
						return L["Default"]
					end
				end,
				set = function(v)
					if v == L["Default"] then
						self.db.profile[factionname].overrideend = nil
					elseif v == L["Hated"] then
						self.db.profile[factionname].overrideend = -42000
					elseif v == L["Hostile"] then
						self.db.profile[factionname].overrideend = -6000
					elseif v == L["Unfriendly"] then
						self.db.profile[factionname].overrideend = -3000
					elseif v == L["Neutral"] then
						self.db.profile[factionname].overrideend = 0
					elseif v == L["Friendly"] then
						self.db.profile[factionname].overrideend = 3000
					elseif v == L["Honored"] then
						self.db.profile[factionname].overrideend = 9000
					elseif v == L["Revered"] then
						self.db.profile[factionname].overrideend = 21000
					elseif v == L["Exalted"] then
						self.db.profile[factionname].overrideend = 42000
					elseif v == L["Max Exalted"] then
						self.db.profile[factionname].overrideend = 42999
					end
					if self.db.profile[factionname].overrideend == self.ToTrack[factionname].endrepvalue then
						self.db.profile[factionname].overrideend = nil
					end
					self:FullStatusUpdate()
				end,
				validate = {L["Default"], L["Hated"], L["Hostile"], L["Unfriendly"], L["Neutral"], L["Friendly"],
					L["Honored"], L["Revered"], L["Exalted"], L["Max Exalted"]},
				order = 101,
			},
			blank = {
				type = "header",
				order = 200,
			},
			watch = {
				type = 'execute',
				name = L["Focus"],
				desc = L["Set this faction as the exp bar."],
				func = function()
					self:SetWatchedFaction(factionname)
				end,
				order = 201,
			},
			showrewards = {
				type = 'group',
				name = L["Show Rewards"],
				desc = L["Show this faction's rewards."],
				args = {},
				order = 202,
			},
		}
	}
	self.Options.args[grouporder[pluginorder]].args[factionname] = factionopts
	self.Options.args.alphabetical.args[factionname] = factionopts
	if not self.db.profile[factionname] then
		self.db.profile[factionname] = {}
	end
end
function GrindStatus:UpdateOptionsTableWithRep()
	for i=1, self:GetRealNumFactions() do
		local name, _, _, _, _, earned = GetFactionInfo(i)
		for groupindex,grouptable in pairs(self.Options.args) do
			if self.Options.args[groupindex].args and self.Options.args[groupindex].args[name] and groupindex ~= "alphabetical" then
				local addstring
				if sessionstartrepvalues[name] and sessionstartrepvalues[name] < earned then
					addstring = "(+"..math.floor(earned-sessionstartrepvalues[name])..")"
				else
					addstring = ""
				end
				if earned < -3000 then
					self.Options.args[groupindex].args[name].name = name.." |cFFFF2222("..earned..")"..addstring
					self.Options.args.alphabetical.args[name].name = name.." |cFFFF2222("..earned..")"..addstring
				elseif earned < 0 then
					self.Options.args[groupindex].args[name].name = name.." |cFFFF8888("..earned..")"..addstring
					self.Options.args.alphabetical.args[name].name = name.." |cFFFF8888("..earned..")"..addstring
				elseif earned < 3000 then
					self.Options.args[groupindex].args[name].name = name.." |cFFFFFF22("..earned..")"..addstring
					self.Options.args.alphabetical.args[name].name = name.." |cFFFFFF22("..earned..")"..addstring
				else
					self.Options.args[groupindex].args[name].name = name.." |cFF22FF22("..earned..")"..addstring
					self.Options.args.alphabetical.args[name].name = name.." |cFF22FF22("..earned..")"..addstring
				end
			end
		end
	end
end
function GrindStatus:GetRealNumFactions()
	local force = false
	if realnumfactions then
		local _, desc = GetFactionInfo(realnumfactions+1)
		if desc and desc ~= "" then
			force = true
		end
	end
	if force or not realnumfactions then
		local i = 1
		while i < 500 do
			local _, desc = GetFactionInfo(i)
			local _, nextdesc = GetFactionInfo(i+1)
			if (not desc and not nextdesc) or (desc == nextdesc) then
				realnumfactions = i-1
				return realnumfactions
			end
			i = i + 1
		end
	end
	if realnumfactions < 5 then realnumfactions = nil return 50 end
	return realnumfactions
end
function GrindStatus:NumberToGoalText(num)
	if num == -42000 or num == 1 then
		return L["Hated"]
	elseif num == -6000 or num == 2 then
		return L["Hostile"]
	elseif num == -3000 or num == 3 then
		return L["Unfriendly"]
	elseif num == 0 or num == 4 then
		return L["Neutral"]
	elseif num == 3000 or num == 5 then
		return L["Friendly"]
	elseif num == 9000 or num == 6 then
		return L["Honored"]
	elseif num == 21000 or num == 7 then
		return L["Revered"]
	elseif num == 42000 or num == 8 then
		return L["Exalted"]
	elseif num == 42999 or num == 9 then
		return L["Max Exalted"]
	end
	return num
end
--FuBar
GrindStatusFu = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "FuBarPlugin-2.0")
GrindStatusFu:RegisterDB("GrindStatusDB")
function GrindStatusFu:OnInitialize()
	self.cannotAttachToMinimap=true
	self.hideWithoutStandby = true
end
function GrindStatusFu:OnMenuRequest(level, arg1, arg2, arg3)
	GrindStatus:UpdateOptionsTableWithRep()
	dewdrop:FeedAceOptionsTable(GrindStatus.Options)
	if level == 4 and arg1 == "showrewards" then
		GrindStatus:PopulateLoot(arg3)
	end
end
function GrindStatusFu:OnTextUpdate()
	self:SetText(futext)
end
function GrindStatusFu:OnEnable()

end
function GrindStatusFu:OnTooltipUpdate()
	GrindStatus:MakeSmallTooltip()
end
function GrindStatusFu:OnClick()
	GrindStatus:LootFrame()
end