﻿
-- Localisation file

if (GetBuildInfo() >= "1.0.0" and GetBuildInfo() < "2.4.0") then
	return
end

-- For translation purposes, the name "Grim Reaper" refers to the mythical agent of death. You know, big black robe, scythe and all that jazz.

local L = LibStub("AceLocale-2.2"):new("GrimReaper")

L:RegisterTranslations("zhTW", function() return {
	TITLE												= "Grim Reaper",
	TITLECOLOUR											= "Grim Reaper by |cFFFF8080Zek|r",
	HINT												= "|cffeda55f點擊|r 隱藏/顯示Grim Reaper",
	BINDING_REPORT										= "發送報告",
	BINDING_LOCK										= "鎖定目前的",
	BINDING_HOLD										= "快速檢視",

	-- General
	CRUSHING											= "碾壓",
	NOINFO												= "沒有戰鬥訊息",
	LOCKED												= "鎖定到%s",
	["Error: %s"]										= "錯誤：%s",

	-- Reporting
	REPORTTITLE											= "來自<Grim Reaper>的報告：%s",
	REPORTNOTHING										= "沒有與%s相關的訊息",
	REPORT_NF											= ERR_GUILD_PLAYER_NOT_FOUND_S,

	-- Menu
	["Display"]											= "顯示",
	["Display options"]									= "顯示選項",
	["Health Bars"]										= "生命條",
	["Show health bars"]								= "顯示生命條",
	["Bars Inside"]										= "內部顯示生命條",
	["Show health bars inside the frame"]				= "在框架內部顯示生命條",
	["Bars Left"]										= "左側顯示生命條",
	["Show health bars on left of frame"] 				= "在框架左側顯示生命條",
	["Time"]											= "時間標籤",
	["Timestamp formatting"]							= "時間標籤格式",
	["None"]											= "不顯示",
	["Don't show timestamps"]							= "不顯示時間標籤",
	["Full Time"]										= "完整時間",
	["Displays full time stamps"]						= "顯示完整時間",
	["Delta Time"]										= "偏移時間",
	["Display time stamps as an offset from the most recent line"] = "顯示相對於最後一條記錄的偏移時間差",
	["Delta Time Next"]									= "相對時間",
	["Display time stamps as an offset from the next line"] = "顯示相鄰兩條記錄之間的時間差",
	["Width"]											= "寬度",
	["Adjust the width of the Grim Reaper"]				= "調整框架寬度",
	["Blizzard Colours"] 								= "BZ 配色",
	["Use Blizzard magic school colours"]				= "使用BZ預設魔法顏色定義",
	["Include"]											= "包含訊息",
	["What to show in the list"] 						= "顯示在列表中的訊息內容",
	["Buff Gains/Losses"] 								= "獲得/消失Buff",
	["Display buff gains and losses"] 					= "將獲得和失去Buff也顯示在列表中",
	["Debuff Gains/Losses"] 							= "獲得/消失Debuff",
	["Display debuff gains and losses"] 				= "將受到和消失Debuff也顯示在列表中",
	["Lock"] 											= "鎖定",
	["Lock to the current unit"] 						= "鎖定目前單位",
	["Hide"] 											= "隱藏",
	["Hide the grim reaper, but keep it active. You can also do this by clicking on the Grim Reaper FuBar/Minimap icon"] = "隱藏視窗，並持續背景作業，你也可以透過點擊FuBar或小地圖上的按鈕執行",
	["Docking"] 										= "吸附",
	["Docking options"] 								= "吸附選項",
	["Enable"] 											= "啟用",
	["Enable docking to the game's default tooltip"] 	= "允許視窗吸附在預設提示訊息視窗上",
	["Dock Point"]										= "錨點",
	["TOPLEFT"]											= "左上",
	["TOPRIGHT"]										= "右上",
	["BOTTOMLEFT"]										= "左下",
	["BOTTOMRIGHT"]										= "右下",
	["Lines"] 											= "行",
	["How many lines to show"] 							= "顯示的行數",
	["Scale"] 											= "縮放",
	["Adjust the scale of the Grim Reaper"]				= "調整縮放比例",
	["Report"]											= "報告",
	["Report options"]									= "報告選項",
	["Report the currently displayed combat lines to chat"]	= "報告目前顯示的訊息到聊天視窗",
	["Self"]											= "Self",
	["Heal"]											= "Heal",
	["Bar Texture"]										= "貼圖材質",
	["Set the texture for the buff timer bars"]			= "設置buff時間條的貼圖",
	["Hover"]											= "滑鼠懸停",
	["Hover options for expanding information on the reaper lines"] = "當滑鼠懸停在某行時顯示的提示訊息內容",
	["Unit Tokens"]										= "單位標記",
	["Use unit tokens to uniquely identify units of the same name"] = "使用單位標記區分相同名字的不同單位",
	["Blizzard Tokens"]									= "BZ標記",
	["Use Blizzard's own unit tokens"]					= "使用BZ內建的標記",
	["Channel"]											= "頻道",
	["Channel output options"]							= "頻道輸出選項",
	["Buff Tips"]										= "Buff提示",
	["Display buff tooltips detailing any buffs used on this line"] = "顯示此行相關的buff提示訊息",
	["Debuff Tips"]										= "Debuff提示",
	["Display debuff tooltips detailing any debuffs used on this line"] = "顯示此行相關的debuff提示訊息",
	["Log"]												= "記錄",
	["Show this player's combat log"]					= "顯示玩家戰鬥記錄",
	["Blizzard Lines"]									= "系統內建記錄",
	["Use Blizzard's own combat log line generation on mouseover"] = "滑鼠懸停時顯示BZ提供的內建戰鬥記錄訊息",
	["Both"]											= "全部",
	["Show this player's combat log for all events"]	= "顯示目標玩家所有戰鬥記錄訊息",
	["Incoming"]										= "目標為玩家",
	["Show this player's combat log for incoming events"] = "顯示目標為該玩家的戰鬥記錄訊息",
	["Outgoing"]										= "玩家造成的",
	["Show this player's combat log for outgoing events"] = "顯示該玩家發起而生成的戰鬥記錄訊息",
	["Casts on player"]									= "對玩家施放的",
	["Display spells cast on player"]					= "顯示對玩家施放的技能",
	["Cures & Steals"]									= "治癒 & 偷取",
	["Show when player is cured or has buff stolen"]	= "顯示玩家何時被治療或被偷取Buff",
	["Time Format"]										= "時間格式",
	["Adjust the time format (Default: %X)"]			= "調整時間顯示格式,預設: %X",
	["<format>\r%X = HH:MM:SS\r%H = HH, %M = MM, %S = SS\reg: %M:%S"] = "<format>\r%X = HH:MM:SS\r%H = HH, %M = MM, %S = SS\reg: %M:%S",
	["Select the player to view, then release the hold key"] = "Select the player to view, then release the hold key",
	["Press the Hold key once more to hide Grim Reaper"] = "Press the Hold key once more to hide Grim Reaper",

	-- Commands
	CMD_DISPLAY			= "display",
	CMD_BARS			= "bars",
	CMD_BARSINSIDE		= "inside",
	CMD_BARSLEFT		= "left",
	CMD_TIME			= "time",
	CMD_NONE			= "none",
	CMD_FULL			= "full",
	CMD_DELTA			= "delta",
	CMD_NEXT			= "next",
	CMD_WIDTH			= "width",
	CMD_COLOURS			= "colours",
	CMD_REPORT			= "report",
	CMD_INCLUDE			= "include",
	CMD_INCLUDE_BUFFS	= "buffs",
	CMD_INCLUDE_DEBUFFS	= "debuffs",
	CMD_LOCK			= "lock",
	CMD_HIDE			= "hide",
	CMD_DOCK			= "dock",
	CMD_DOCKP			= "dockpoint",
	CMD_ENABLE			= "enable",
	CMD_LINES			= "lines",
	CMD_SCALE			= "scale",
	CMD_BARTEXTURE		= "texture",
	CMD_HOVER			= "hover",
	CMD_TOKENS			= "tokens",
	CMD_BLIZZTOKENS		= "blizztokens",
	CMD_SHOWN			= "shown",
	CMD_CHANNEL			= "channel",
	CMD_BUFFTIPS		= "buff",
	CMD_DEBUFFTIPS		= "debuff",
	CMD_LOG				= "log",
	CMD_BLIZZLINE		= "blizzline",
	CMD_LOGBOTH			= "all",
	CMD_LOGIN			= "in",
	CMD_LOGOUT			= "out",
	CMD_INCLUDE_CASTS	= "casts",
	CMD_INCLUDE_CURES	= "cures",
	CMD_FORMAT			= "format",

	ON					= "On",
	OFF					= "Off",
} end)
