﻿
-- Localisation file

if (GetBuildInfo() >= "1.0.0" and GetBuildInfo() < "2.4.0") then
	return
end

-- For translation purposes, the name "Grim Reaper" refers to the mythical agent of death. You know, big black robe, scythe and all that jazz.

local L = LibStub("AceLocale-2.2"):new("GrimReaper")

L:RegisterTranslations("enUS", function() return {
	TITLE												= "Grim Reaper",
	TITLECOLOUR											= "Grim Reaper by |cFFFF8080Zek|r",
	HINT												= "|cffeda55fClick|r to hide/show Grim Reaper",
	BINDING_REPORT										= "Report Selected",
	BINDING_LOCK										= "Lock to Current",
	BINDING_HOLD										= "Quick View",

	-- General
	CRUSHING											= "c",
	NOINFO												= "No combat information",
	LOCKED												= "Locked to %s",
	["Error: %s"]										= true,

	-- Reporting
	REPORTTITLE											= "<Grim Reaper> report for %s",
	REPORTNOTHING										= "Nothing relevant to show for %s",
	REPORT_NF											= ERR_GUILD_PLAYER_NOT_FOUND_S,

	-- Menu
	["Display"]											= true,
	["Display options"]									= true,
	["Health Bars"]										= true,
	["Show health bars"]								= true,
	["Bars Inside"]										= true,
	["Show health bars inside the frame"]				= true,
	["Bars Left"]										= true,
	["Show health bars on left of frame"] 				= true,
	["Time"]											= true,
	["Timestamp formatting"]							= true,
	["None"]											= true,
	["Don't show timestamps"]							= true,
	["Full Time"]										= true,
	["Displays full time stamps"]						= true,
	["Delta Time"]										= true,
	["Display time stamps as an offset from the most recent line"] = true,
	["Delta Time Next"]									= true,
	["Display time stamps as an offset from the next line"] = true,
	["Width"]											= true,
	["Adjust the width of the Grim Reaper"]				= true,
	["Blizzard Colours"] 								= true,
	["Use Blizzard magic school colours"]				= true,
	["Include"]											= true,
	["What to show in the list"] 						= true,
	["Buff Gains/Losses"] 								= true,
	["Display buff gains and losses"] 					= true,
	["Debuff Gains/Losses"] 							= true,
	["Display debuff gains and losses"] 				= true,
	["Lock"] 											= true,
	["Lock to the current unit"] 						= true,
	["Hide"] 											= true,
	["Hide the grim reaper, but keep it active. You can also do this by clicking on the Grim Reaper FuBar/Minimap icon"] = true,
	["Docking"] 										= true,
	["Docking options"] 								= true,
	["Enable"] 											= true,
	["Enable docking to the game's default tooltip"] 	= true,
	["Dock Point"]										= true,
	["TOPLEFT"]											= "Top-Left",
	["TOPRIGHT"]										= "Top-Right",
	["BOTTOMLEFT"]										= "Bottom-Left",
	["BOTTOMRIGHT"]										= "Bottom-Right",
	["Lines"] 											= true,
	["How many lines to show"] 							= true,
	["Scale"] 											= true,
	["Adjust the scale of the Grim Reaper"]				= true,
	["Report"]											= true,
	["Report options"]									= true,
	["Report the currently displayed combat lines to chat"]	= true,
	["Self"]											= true,
	["Heal"]											= true,
	["Bar Texture"]										= true,
	["Set the texture for the buff timer bars"]			= true,
	["Hover"]											= true,
	["Hover options for expanding information on the reaper lines"] = true,
	["Unit Tokens"]										= true,
	["Use unit tokens to uniquely identify units of the same name"] = true,
	["Blizzard Tokens"]									= true,
	["Use Blizzard's own unit tokens"]					= true,
	["Channel"]											= true,
	["Channel output options"]							= true,
	["Buff Tips"]										= true,
	["Display buff tooltips detailing any buffs used on this line"] = true,
	["Debuff Tips"]										= true,
	["Display debuff tooltips detailing any debuffs used on this line"] = true,
	["Log"]												= true,
	["Show this player's combat log"]					= true,
	["Blizzard Lines"]									= true,
	["Use Blizzard's own combat log line generation on mouseover"] = true,
	["Both"]											= true,
	["Show this player's combat log for all events"]	= true,
	["Incoming"]										= true,
	["Show this player's combat log for incoming events"] = true,
	["Outgoing"]										= true,
	["Show this player's combat log for outgoing events"] = true,
	["Casts on player"]									= true,
	["Display spells cast on player"]					= true,
	["Cures & Steals"]									= true,
	["Show when player is cured or has buff stolen"]	= true,
	["Time Format"]										= true,
	["Adjust the time format (Default: %X)"]			= true,
	["<format>\r%X = HH:MM:SS\r%H = HH, %M = MM, %S = SS\reg: %M:%S"] = true,
	["Select the player to view, then release the hold key"] = true,
	["Press the Hold key once more to hide Grim Reaper"] = true,

	-- Commands
	CMD_DISPLAY			= "display",
	CMD_BARS			= "bars",
	CMD_BARSINSIDE		= "inside",
	CMD_BARSLEFT		= "left",
	CMD_TIME			= "time",
	CMD_NONE			= "none",
	CMD_FULL			= "full",
	CMD_DELTA			= "delta",
	CMD_NEXT			= "next",
	CMD_WIDTH			= "width",
	CMD_COLOURS			= "colours",
	CMD_REPORT			= "report",
	CMD_INCLUDE			= "include",
	CMD_INCLUDE_BUFFS	= "buffs",
	CMD_INCLUDE_DEBUFFS	= "debuffs",
	CMD_LOCK			= "lock",
	CMD_HIDE			= "hide",
	CMD_DOCK			= "dock",
	CMD_DOCKP			= "dockpoint",
	CMD_ENABLE			= "enable",
	CMD_LINES			= "lines",
	CMD_SCALE			= "scale",
	CMD_BARTEXTURE		= "texture",
	CMD_HOVER			= "hover",
	CMD_TOKENS			= "tokens",
	CMD_BLIZZTOKENS		= "blizztokens",
	CMD_SHOWN			= "shown",
	CMD_CHANNEL			= "channel",
	CMD_BUFFTIPS		= "buff",
	CMD_DEBUFFTIPS		= "debuff",
	CMD_LOG				= "log",
	CMD_BLIZZLINE		= "blizzline",
	CMD_LOGBOTH			= "all",
	CMD_LOGIN			= "in",
	CMD_LOGOUT			= "out",
	CMD_INCLUDE_CASTS	= "casts",
	CMD_INCLUDE_CURES	= "cures",
	CMD_FORMAT			= "format",

	ON					= "On",
	OFF					= "Off",
} end)
