--[[
	Name: GridStatusShield
	Revision: $Revision: 82146 $
	Developed by: Julith @ Perenolde-EU (billgatesgut@web.de)
	Description: Publishes the sremaining value of the players power word shield on a unit.

	Credits to oodyboo from WoWAce for the idea of this addon.
]]

--{{{ Libraries
local ShieldLeft = LibStub:GetLibrary("LibShieldLeft-1.0", true)
if not ShieldLeft then return end
local L = AceLibrary("AceLocale-2.2"):new("GridStatusShield")
local Roster = AceLibrary("Roster-2.1")

--}}}

L:RegisterTranslations("enUS", function()
	return {
		["Shield left"] = true,  
	}
end)

L:RegisterTranslations("deDE", function()
	return {
		["Shield left"] = "Verbleibender Schild",  
	}
end)


GridStatusShield = GridStatus:NewModule("GridStatusShield")
GridStatusShield.menuName = L["Shield left"]


--{{{ AceDB defaults

GridStatusShield.defaultDB = {
	unitShieldLeft = {
		enable = true,
		priority = 90,
		color = { r = 1, g = 0, b = 0, a = 1 },
	},
}

--}}}

--{{{ Options
local amountOptions = {
}
--}}}

local settings


function GridStatusShield:OnInitialize()
	self.super.OnInitialize(self)
	self:RegisterStatus("unitShieldLeft", L["Shield left"], amountOptions, true)
    settings = GridStatusShield.db.profile
end

function GridStatusShield:OnEnable()
    self:RegisterEvent("Grid_UnitJoined")
    self:RegisterEvent("PLAYER_ENTERING_WORLD", "UpdateAllUnits")

	-- register callbacks
	ShieldLeft.RegisterCallback(self, "ShieldLeft_NewShield")
	ShieldLeft.RegisterCallback(self, "ShieldLeft_RefreshShield")
	ShieldLeft.RegisterCallback(self, "ShieldLeft_RemoveShield")
    ShieldLeft.RegisterCallback(self, "ShieldLeft_UpdateShield")
end

function GridStatusShield:OnDisable()
	ShieldLeft.UnregisterCallback(self, "ShieldLeft_NewShield")
	ShieldLeft.UnregisterCallback(self, "ShieldLeft_RefreshShield")
	ShieldLeft.UnregisterCallback(self, "ShieldLeft_RemoveShield")
    ShieldLeft.UnregisterCallback(self, "ShieldLeft_UpdateShield")
end

function GridStatusShield:Print(msg)
    --print("GridStatusShield: "..msg)
end


function GridStatusShield:UpdateAllUnits()
	local name, status, statusTbl

	for name, status, statusTbl in self.core:CachedStatusIterator("unitShieldLeft") do
		self:Grid_UnitJoined(name)
	end
end

function GridStatusShield:Grid_UnitJoined(name, unitid)
	self:Clear(name)
end


function GridStatusShield:Clear(unitName)
    if not unitName then
        return
    end

    if not Roster:GetUnitObjectFromName(unitName) then return end
    
    self.core:SendStatusLost(unitName, "unitShieldLeft")
end

function GridStatusShield:ShieldLeft_UpdateShield(event, unitName, shieldName, shieldValue, allValue)
    local name = UnitName(unitName)
    self:Print("Updating "..shieldName.." on "..unitName)
            
    self.core:SendStatusGained(name, "unitShieldLeft",
                settings.unitShieldLeft.priority,
                nil,
                settings.unitShieldLeft.color,
                tostring(allValue))
end

function GridStatusShield:ShieldLeft_RefreshShield(event, unitName, shieldName, shieldValue, allValue)
    local name = UnitName(unitName)
    self:Print("Refreshing "..shieldName.." on "..unitName)
            
    self.core:SendStatusGained(name, "unitShieldLeft",
                settings.unitShieldLeft.priority,
                nil,
                settings.unitShieldLeft.color,
                tostring(allValue))
end

function GridStatusShield:ShieldLeft_NewShield(event, unitName, shieldName, shieldValue, allValue)
    local name = UnitName(unitName)
    self:Print("New "..shieldName.." with "..allValue.." on "..unitName)
    
    self.core:SendStatusGained(name, "unitShieldLeft",
                settings.unitShieldLeft.priority,
                nil,
                settings.unitShieldLeft.color,
                tostring(allValue))
end

function GridStatusShield:ShieldLeft_RemoveShield(event, unitName, shieldName, shieldValue, allValue, count)
    local name = UnitName(unitName)
    self:Print("Remove "..shieldName.." with "..allValue.." on "..unitName)
    if count > 0 then
        self.core:SendStatusGained(name, "unitShieldLeft",
                    settings.unitShieldLeft.priority,
                    nil,
                    settings.unitShieldLeft.color,
                    tostring(max(0,allValue)))
    else
        self.core:SendStatusLost(name, "unitShieldLeft")
    end
end

