﻿local L = AceLibrary("AceLocale-2.2"):new("GridStatusRes")
local rescomm = LibStub:GetLibrary("LibResComm-1.0");
if not rescomm then return end

GridStatusRes = GridStatus:NewModule("GridStatusRes")
GridStatusRes.menuName = L["Resurrection"]

--{{{ AceDB defaults

GridStatusRes.defaultDB = {
	debug = false,
	alert_res = {
		enable = true,
		color = { r = 1, g = 0, b = 0, a = 1 },
		priority = 50,
		range = false,
	},
	alert_ressed = {
		enable = true,
		color = { r = 0, g = 1, b = 0, a = 1 },
		priority = 51,
		range = false,
	},
	alert_ss = {
		enable = true,
		color = { r = 0, g = 1, b = 0, a = 1 },
		priority = 49,
		range = false,
	},
}

--}}}

function GridStatusRes:OnInitialize()
	self.super.OnInitialize(self)
	self:RegisterStatus("alert_res", L["Incomming Resurrection"], nil, false)
	self:RegisterStatus("alert_ressed", L["Resurrected"], nil, false)
	self:RegisterStatus("alert_ss", L["Soulstone"], nil, false)
end

function GridStatusRes:ResComm_ResStart(event, _, _, targetName)
    local settings = GridStatusRes.db.profile.alert_res
    
    if not settings.enable then return end
    
	GridStatusRes.core:SendStatusGained(
		targetName,
		"alert_res",
		settings.priority,
        (settings.range and 40),
		settings.color,
		"+RES",
		nil,
		nil,
        nil
	)
end

function GridStatusRes:ResComm_ResEnd(event, _, target)
    if not rescomm:IsUnitBeingRessed(target) then
        GridStatusRes.core:SendStatusLost(target, "alert_res");
    end
end

function GridStatusRes:ResComm_ResExpired(event, name)
	GridStatusRes.core:SendStatusLost(name, "alert_ressed");
end

function GridStatusRes:ResComm_Ressed(event, ressed)
    local settings = GridStatusRes.db.profile.alert_ressed
    
    if not settings.enable then return end
    
	GridStatusRes.core:SendStatusGained(
		ressed,
		"alert_ressed",
		settings.priority,
        (settings.range and 40),
		settings.color,
		"RES",
		nil,
		nil,
        nil
	)
end

function GridStatusRes:ResComm_CanRes(event, ressed)
    local settings = GridStatusRes.db.profile.alert_ss
    
    if not settings.enable then return end
    
	GridStatusRes.core:SendStatusGained(
		ressed,
		"alert_ss",
		settings.priority,
        (settings.range and 40),
		settings.color,
		"SS",
		nil,
		nil,
        nil
	)
end

function GridStatusRes:HealthChanged(units)
    for unit in pairs(units) do
		if not UnitIsDead(unit) then
		    local name = UnitName(unit)
            GridStatusRes.core:SendStatusLost(name, "alert_res");
            GridStatusRes.core:SendStatusLost(name, "alert_ressed");
            GridStatusRes.core:SendStatusLost(name, "alert_ss");
        end
    end
end

function GridStatusRes:OnEnable()
	rescomm.RegisterCallback(self, "ResComm_ResStart");
	rescomm.RegisterCallback(self, "ResComm_ResEnd");
	rescomm.RegisterCallback(self, "ResComm_Ressed");
	rescomm.RegisterCallback(self, "ResComm_CanRes");
	rescomm.RegisterCallback(self, "ResComm_ResExpired");
	self:RegisterBucketEvent("UNIT_HEALTH", 0.1, "HealthChanged");
end

function GridStatusRes:OnDisable()
	rescomm.UnregisterCallback(self, "ResComm_ResStart");
	rescomm.UnregisterCallback(self, "ResComm_ResEnd");
	rescomm.UnregisterCallback(self, "ResComm_Ressed");
	rescomm.UnRegisterCallback(self, "ResComm_CanRes");
	rescomm.UnRegisterCallback(self, "ResComm_Expired");
	self:UnregisterBucketEvent("UNIT_HEALTH");
end

